<?php namespace App\Libraries\Bulkuploads;

helper('text');
class OwnershipFlat_uploads
{
    function __construct()
    {
        $this->fileUploadModel = new \App\Models\FileUploadsModel();
        $this->dt_ci_common = new \App\Libraries\Dt_ci_common();
        $this->dt_ci_acl = new \App\Libraries\Dt_ci_acl();
        $this->ownershipFlatModel = new \App\Models\OwnershipFlatModel();
        $this->commonWebserviceModel = new \App\Models\CommonWebServiceModel();
        $this->towerModel = new \App\Models\TowerModel();
        $this->flatModel = new \App\Models\FlatModel();
        $this->resourceModel = new \App\Models\ResourceModel();
        $this->resourceTypeModel = new \App\Models\ResourceTypeModel();
        $this->session       = \Config\Services::session();
        $this->ionAuthModel = new \App\Models\IonAuthModel();
        $this->parkingSlotModel = new \App\Models\ParkingSlotModel();
    }

    // public function uploadOwnershipFlatMember($userId, $return = false, $file = array())
    // {
    //     $transactionDate = "";
    //     $firstRecord = true;
    //     $startTime = date('Y-m-d H:i:s');
    //     checkAndCreatePath(OWNERSHIP_FLAT_MEMBER_ABS_PATH);

    //     $dirAbsPath = OWNERSHIP_FLAT_MEMBER_ABS_PATH;
    //     $dirRelPath = OWNERSHIP_FLAT_MEMBER_RELATIVE_PATH;

    //     $masterType = "ownership flat Member";

    //     // exists Owner Flat data
    //     $ownershipFlatData = $this->ownershipFlatModel->getOwnershipFlatData(array(
    //         'is_multiple' => 1,
    //         'is_latest' => 1,
    //     ));
    //     // printArray($ownershipFlatData,1);

    //     $ownershipTowerFlatArr = array();
    //     $ownershipFlatArr = array();
    //     $ownershipFlatIndexArr = array();
    //     if(!empty($ownershipFlatData)){
    //         foreach ($ownershipFlatData as $oKey => $oValue) {
    //             $ownershipFlatArr[$oValue['ownership_flat_no']] = $oValue;
    //             $ownershipTowerFlatArr[$oValue['clubbed_tower_flat_name']] = $oValue;
    //             $ownershipFlatIndexArr[$oValue['clubbed_tower_flat_index_no']] = $oValue;
    //         }
    //     }

    //     // exists Flat Data
    //     $flatArr = array();
    //     $flatData = $this->flatModel->getFlatData(array(
    //         'is_multiple' => 1
    //         // 'is_multiple' => 1
    //     ));
    //     if(!empty($flatData)){
    //         foreach ($flatData as $fKey => $fValue) {
    //             $flatArr[$fValue['clubbed_tower_flat_name']] = $fValue;
    //         }
    //     }

    //     // Tower Data
    //     $towerArr = array();
    //     $towerData = $this->towerModel->getTowerData(array(
    //         'is_multiple' => 1
    //         // 'is_multiple' => 1
    //     ));
    //     if(!empty($towerData)){
    //         foreach ($towerData as $tKey => $tValue) {
    //             $towerArr[$tValue['tower_name']] = $tValue;
    //         }
    //     }

    //     // exists Resource Data
    //     $existsResourceDataArr = array();
    //     $existsResourceData = $this->resourceModel->getResourceData(array(
    //         "society_id" => $this->session->get('society_id'),
    //         "is_multiple" => 1,
    //     ));
    //     if(!empty($existsResourceData)){
    //         foreach ($existsResourceData as $rKey => $rValue) {
    //             $existsResourceDataArr[$rValue['resource_mobile_no']] = $rValue;
    //         }
    //     }
    //     // printArray($existsResourceData);
    //     // printArray($existsResourceDataArr,1);
    
    //     // Get Resource Type
    //     $resourceTypeManagerId = getResourceTypeId(RESOURCE_TYPE_MANAGER);
    //     $resourceTypeMemberId = getResourceTypeId(RESOURCE_TYPE_MEMBER);

    //     $resourceTypeMemberData = $this->resourceTypeModel->getResourceTypeData(array(
    //         "resource_type_name" => RESOURCE_TYPE_MEMBER,
    //         "society_id" => $this->session->get('society_id'),
    //     ));

    //     $groupData = $this->commonWebserviceModel->getGroupsData([
    //         'group_id' => $resourceTypeMemberData['group_id'],
    //         'society_id' => $this->session->get('society_id'),
    //     ]);
    //     $groupId = $groupData['id'] ?? '';
    //     $permissions = $groupData['permissions'] ?? '';
    //     $permissionArray = unserialize($permissions);
    //     $permissionLabel = [];
    //     $controllers_methods = $this->dt_ci_acl->getPermissableMethods();
        
    //     foreach ($controllers_methods as $controller_name => $methods_arr) {
    //         foreach ($methods_arr as $method) {
    //             $methodDisplay = is_array($method) ? reset($method) : $method;
    //             $methodActual = is_array($method) ? key($method) : $method;
    //             $inputName = "$controller_name|$methodActual";
    //             $permissionLabel[] = "$inputName|dt|$controller_name|dt|$methodDisplay";
    //         }
    //     }
        
    //     // Get manager Data
    //     $existsManagerDataArr = array();
    //     $userManagerDataArray = $this->commonWebserviceModel->getUserSocietyData(array(
    //         'resource_type_id' => $resourceTypeManagerId,
    //         'society_id' => $resourceTypeManagerId,
    //         'is_multiple' => 1
    //     ));
    //     // printArray($userManagerDataArray,1);
    //     if(!empty($userManagerDataArray)){
    //         foreach ($userManagerDataArray as $maKey => $maValue) {
    //             $existsManagerDataArr[$maValue['phone']] = $maValue;
    //         }
    //     }

    //     // get member data
    //     $existsMemberDataArr = array();
    //     $existsMemberDataSocietyWiseArr = array();
    //     $userMemberDataArray = $this->commonWebserviceModel->getUserSocietyData(array(
    //         'is_member' => 1,
    //         'is_multiple' => 1,
    //     ));
    //     // printArray($userMemberDataArray,1);
    //     if(!empty($userMemberDataArray)){
    //         foreach ($userMemberDataArray as $uMKey => $uMValue) {
    //             $existsMemberDataArr[$uMValue['phone']] = $uMValue;
    //             $existsMemberDataSocietyWiseArr[$uMValue['society_id']."|".$uMValue['phone']] = $uMValue;
    //         }
    //     }
    //     // printArray($existsMemberDataArr);
    //     // printArray($existsMemberDataSocietyWiseArr,1);

    //     $userDataArray = $this->commonWebserviceModel->getUserSocietyData(array(
    //         'is_multiple' => 1,
    //         'is_active' => 1,
    //     ));
    //     $existsUserDataArr = array();
    //     $existsUserMobileNoWiseArr = array();
    //     $existsUserMobileNoSocietyWiseArr = array();
    //     if(!empty($userDataArray)){
    //         foreach($userDataArray as $existsUser) {
    //             $comboKey = $existsUser['society_id']."|".$existsUser['resource_type_id']."|".$existsUser['type_id'];
    //             $existsUserDataArr[$comboKey] = $existsUser;
    //             $existsUserMobileNoWiseArr[$existsUser['phone']][] = $existsUser;
    //             $existsUserMobileNoSocietyWiseArr[$existsUser['phone']][$existsUser['society_id']][] = $existsUser;
    //         }
    //     }

    //     $genderData = genderType();
    //     $bloodGroupData = bloodGroupType();
    //     $relationData = relation();

    //     // printArray($genderData);
    //     // printArray($bloodGroupData);
    //     // printArray($relationData);

    //     $customErrors = array(
            
    //         "101" => "Flat No required",
    //         "102" => "Flat No Invalid",
    //         "201" => "Mobile No Should have 10 digits",
    //         "202" => "This Mobile No already used by resource in this society",
    //         "203" => "This Mobile No already used by manager in this society",
    //         "204" => "Members Can't use same mobile no in same flat",
    //         "301" => "Name Required",
    //         "302" => "Index No is Already there",
    //         "303" => "Index No Required",
    //         "401" => "Invalid Email Formate",
    //         "501" => "Invalid gender Type",
    //         "502" => "Gender required",
    //         "601" => "Invalid relation Type",
    //         "701" => "Invalid blood group Type",
    //         "801" => "Is Owner should be Y Or N Only",
    //         "901" => "Tower required",
    //         "902" => "Tower Invalid",
    //         "1001" => "Invalid formate for date of registory",
    //         "1101" => "At least one member must be marked as owner (is_owner = Y) for this flat", // NEW
    //     );
    //     $response = $this->dt_ci_common->uploadMasterFile($_FILES, $dirAbsPath, $file);
    //     // printArray($response,1);

    //     if ($response['result'] == 'ok') {
    //         $dataExcel = $response['unset_data']['data_excel'];
    //         $uploadData = $response['unset_data']['upload_data'];
    //         $filePrefix = $response['unset_data']['file_prefix'];
    //         unset($response['unset_data']);

    //         $successEntries = 0;
    //         $failedEntries = 0;

    //         $errorRowArr = array();
    //         $dataSaveBatch = array();
    //         $dataResponse = array();
    //         $ownershipFlatInsertArr = array();
    //         $checkOwnershipFlatArr = array();
    //         $memberMobileNoArr = array();
    //         $withoutMobileNoMemberInsertArr = array();
    //         $mobileNoArr = array();

    //         foreach ($customErrors as $cErrKey => $cErrMessage) {
    //             $errorRowArr[$cErrKey] = array();
    //         }
    //         // printArray($dataExcel['values'],1);
    //         foreach ($dataExcel['values'] as $rowNumber => $row) {

    //             $dataSave = array();
    //             $rowErrorArr = array();

    //             $columnMap = array(
    //                 'A'  => 'tower',
    //                 'B'  => 'flat',
    //                 'C'  => 'index_no',
    //                 'D'  => 'date_of_registry',
    //                 'E'  => 'mobile_no',
    //                 'F'  => 'name',
    //                 'G'  => 'email_id',
    //                 'H'  => 'gender',
    //                 'I'  => 'relation',
    //                 'J'  => 'birth_year',
    //                 'K'  => 'blood_group',
    //                 'L'  => 'is_owner',
    //             );

    //             //load dataSave with data in db columns
    //             foreach ($columnMap as $excelCol => $colMKey) {
    //                 $dataSave[$colMKey] = isset($row[$excelCol]) ? $row[$excelCol] : "";
    //             }
    //             $dataRowResponse = $dataSave;
    //             $dataSave = array_map('trim', $dataSave);

    //             if (empty($rowErrorArr)) {

    //                 if($dataSave['flat'] != "" && $dataSave['flat'] != NULL){
    //                     if(!isset($ownershipFlatArr[$dataSave['flat']])){
    //                         // array_push($errorRowArr[102], $rowNumber);
    //                         // array_push($rowErrorArr, 102);

    //                         if($dataSave['tower'] != "" && $dataSave['tower'] != NULL){
    //                             if(!isset($towerArr[$dataSave['tower']])){
    //                                 array_push($errorRowArr[902], $rowNumber);
    //                                 array_push($rowErrorArr, 902);
    //                             }
    //                         } else {
    //                             array_push($errorRowArr[901], $rowNumber);
    //                             array_push($rowErrorArr, 901);
    //                         }

    //                         if($dataSave['flat'] != "" && $dataSave['flat'] != NULL){
    //                             $towerClubIndex = $dataSave['tower']."|".$dataSave['flat'];
    //                             if(!isset($flatArr[$towerClubIndex])){
    //                                 array_push($errorRowArr[102], $rowNumber);
    //                                 array_push($rowErrorArr, 102);
    //                             }else if(isset($ownershipFlatArr[$towerClubIndex])){
    //                                 array_push($errorRowArr[203], $rowNumber);
    //                                 array_push($rowErrorArr, 203);
    //                             }else {
    //                                 $dataSave['flat_id'] = $flatArr[$towerClubIndex]['flat_id'];
    //                             }
    //                         } else {
    //                             array_push($errorRowArr[101], $rowNumber);
    //                             array_push($rowErrorArr, 101);
    //                         }

    //                         if($dataSave['index_no'] != "" && $dataSave['index_no'] != NULL){
    //                             $towerIndexClubIndex = $dataSave['tower']."|".$dataSave['index_no'];
    //                             if(isset($ownershipFlatIndexArr[$towerIndexClubIndex])){
    //                                 array_push($errorRowArr[302], $rowNumber);
    //                                 array_push($rowErrorArr, 302);
    //                             }
    //                         } else {
    //                             array_push($errorRowArr[303], $rowNumber);
    //                             array_push($rowErrorArr, 303);
    //                         }

    //                         if($dataSave['date_of_registry'] != "" && $dataSave['date_of_registry'] != NULL){
    //                             if (!preg_match('/^\d{2}-\d{2}-\d{4}$/', $dataSave['date_of_registry'])) {
    //                                 array_push($errorRowArr[1001], $rowNumber);
    //                                 array_push($rowErrorArr, 1001);
    //                             }
    //                         }

    //                         if(isset($checkOwnershipFlatArr[$dataSave['flat']])){
    //                             $dataSave['ownership_flat_slug'] = $checkOwnershipFlatArr[$dataSave['flat']]['ownership_flat_slug'];
    //                             $dataSave['ownership_flat_id'] = $checkOwnershipFlatArr[$dataSave['flat']]['ownership_flat_id'];
    //                         } else {
    //                             $dataSave['ownership_flat_slug'] = random_string();
    //                             $dataSave['ownership_flat_id'] = '';
    //                         }
                            
    //                     } else {
    //                         $checkOwnershipFlatArr[$dataSave['flat']] = $ownershipFlatArr[$dataSave['flat']];
    //                         // $checkOwnershipFlatArr[$dataSave['flat']]['need_to_insert'] = 0;
    //                         $dataSave['ownership_flat_slug'] = $checkOwnershipFlatArr[$dataSave['flat']]['ownership_flat_slug'];
    //                         $dataSave['ownership_flat_id'] = $checkOwnershipFlatArr[$dataSave['flat']]['ownership_flat_id'];
    //                         $dataSave['flat_id'] =  $checkOwnershipFlatArr[$dataSave['flat']]['flat_id'];
    //                         $dataSave['index_no'] =  $checkOwnershipFlatArr[$dataSave['flat']]['index_no'];
    //                         $dataSave['date_of_registry'] =  $checkOwnershipFlatArr[$dataSave['flat']]['date_of_registry'];
    //                     }
    //                 } else {
    //                     array_push($errorRowArr[101], $rowNumber);
    //                     array_push($rowErrorArr, 101);
    //                 }

    //                 if(isset($checkOwnershipFlatArr[$dataSave['flat']])){
    //                     $dataSave['members_phone_no'] = $checkOwnershipFlatArr[$dataSave['flat']]['members_phone_no'];
    //                     $flatExistsMobileNoArr = explode(",",$checkOwnershipFlatArr[$dataSave['flat']]['members_phone_no']);
    //                     // printArray($flatExistsMobileNoArr);
    //                     if(!empty($dataSave['mobile_no'])){
    //                         if(in_array($dataSave['mobile_no'],$flatExistsMobileNoArr)){
    //                             array_push($errorRowArr[204], $rowNumber);
    //                             array_push($rowErrorArr, 204);
    //                         }else{
    //                             if(!empty($dataSave['mobile_no'])){
    //                                 $dataSave['members_phone_no'] = $checkOwnershipFlatArr[$dataSave['flat']]['members_phone_no'].",".$dataSave['mobile_no'];
    //                             }
    //                         }
    //                     }
    //                 }

    //                 if(empty($rowErrorArr)){
    //                     if($dataSave['mobile_no'] != "" && $dataSave['mobile_no'] != NULL){
    //                         // printArray($dataSave['members_phone_no']);

    //                         if (!preg_match('/^\d{10}$/', $dataSave['mobile_no'])) {
    //                             array_push($errorRowArr[201], $rowNumber);
    //                             array_push($rowErrorArr, 201);
    //                         }
    
    //                         if(isset($existsResourceDataArr[$dataSave['mobile_no']])){
    //                             array_push($errorRowArr[202], $rowNumber);
    //                             array_push($rowErrorArr, 202);
    //                         } else if(isset($existsManagerDataArr[$dataSave['mobile_no']])){
    //                             array_push($errorRowArr[203], $rowNumber);
    //                             array_push($rowErrorArr, 203);
    //                         } else if(isset($existsMemberDataArr[$dataSave['mobile_no']])) {
    //                             $dataSave['member_id'] = $existsMemberDataArr[$dataSave['mobile_no']]['member_id'];
    //                             $dataSave['member_slug'] = $existsMemberDataArr[$dataSave['mobile_no']]['member_slug'];
    //                         } else {
    //                             $dataSave['member_id'] = '';
    //                             if(isset($memberMobileNoArr[$dataSave['mobile_no']])){
    //                                 $dataSave['member_slug'] = $memberMobileNoArr[$dataSave['mobile_no']]['member_slug'];
    //                                 $dataSave['member_id'] = $memberMobileNoArr[$dataSave['mobile_no']]['member_id'];
    //                             } else {
    //                                 $dataSave['member_slug'] = random_string();
    //                             }
    //                             $memberMobileNoArr[$dataSave['mobile_no']] = array(
    //                                 'member_slug' => $dataSave['member_slug'],
    //                                 'mobile_no' => $dataSave['mobile_no'],
    //                                 'member_id' => $dataSave['member_id'],
    //                             );
    //                         }
    //                     } else {
    //                         $dataSave['member_id'] = '';
    //                         $dataSave['member_slug'] = random_string();
    //                     }
    //                 }

    //                 if($dataSave['name'] == "" && $dataSave['name'] == NULL){
    //                     array_push($errorRowArr[301], $rowNumber);
    //                     array_push($rowErrorArr, 301);
    //                 }

    //                 if($dataSave['email_id'] != "" && $dataSave['email_id'] != NULL){
    //                     if(!filter_var($dataSave['email_id'], FILTER_VALIDATE_EMAIL)){
    //                         array_push($errorRowArr[401], $rowNumber);
    //                         array_push($rowErrorArr, 401);
    //                     }
    //                 }

    //                 if ($dataSave['gender'] != "" && $dataSave['gender'] != NULL) {
    //                     if(!isset($genderData[strtolower($dataSave['gender'])])){
    //                         array_push($errorRowArr[501], $rowNumber);
    //                         array_push($rowErrorArr, 501);
    //                     }else{
    //                         $dataSave['gender'] = strtolower($dataSave['gender']);
    //                     }
    //                 }else{
    //                     array_push($errorRowArr[502], $rowNumber);
    //                     array_push($rowErrorArr, 502);
    //                 }

    //                 if ($dataSave['relation'] != "" && $dataSave['relation'] != NULL) {
    //                     if(!isset($relationData[strtolower($dataSave['relation'])])){
    //                         array_push($errorRowArr[601], $rowNumber);
    //                         array_push($rowErrorArr, 601);
    //                     }else{
    //                         $dataSave['relation'] = strtolower($dataSave['relation']);
    //                     }
    //                 }

    //                 if ($dataSave['blood_group'] != "" && $dataSave['blood_group'] != NULL) {
    //                     if(!isset($bloodGroupData[$dataSave['blood_group']])){
    //                         array_push($errorRowArr[701], $rowNumber);
    //                         array_push($rowErrorArr, 701);
    //                     }else{
    //                         $dataSave['blood_group'] = ($dataSave['blood_group']);
    //                     }
    //                 }

    //                 if ($dataSave['is_owner'] != "" && $dataSave['is_owner'] != NULL) {
    //                     if(strtolower($dataSave['is_owner']) != 'y' && strtolower($dataSave['is_owner']) != 'n'){
    //                         array_push($errorRowArr[801], $rowNumber);
    //                         array_push($rowErrorArr, 801);
    //                     }else{
    //                         $dataSave['is_owner'] = strtolower($dataSave['is_owner']) == 'y' ? 1 : 0;
    //                     }
    //                 }



    //             }

    //             if(empty($rowErrorArr)){
    //                 $successEntries++;
    //                 // printArray(isset($dataSave['members_phone_no']));
    //                 // $this->maxWipModel->saveCsv($dataSave, $userId);
    //                 // if(!empty($dataSave['mobile_no'])){
    //                 //     $mobileNoArr[$dataSave['member_slug']] = $dataSave['mobile_no'];
    //                 // }
    //                 // $mobileNoArr[] = !empty($dataSave['mobile_no']) ? $dataSave['mobile_no']
    //                 $checkOwnershipFlatArr[$dataSave['flat']] = array(
    //                     'flat' => $dataSave['flat'],
    //                     'flat_id' => $dataSave['flat_id'],
    //                     'ownership_flat_slug' => $dataSave['ownership_flat_slug'],
    //                     'index_no' => $dataSave['index_no'],
    //                     'date_of_registry' => $dataSave['date_of_registry'],
    //                     'ownership_flat_id' => $dataSave['ownership_flat_id'],
    //                     'members_phone_no' => isset($dataSave['members_phone_no']) ? $dataSave['members_phone_no'] : $dataSave['mobile_no'],
    //                     // 'is_owner' => isset($dataSave['is_owner']) ? $dataSave['is_owner'] : 0,
    //                 );

    //                 if(!empty($dataSave['mobile_no'])){
    //                     $memberMobileNoArr[$dataSave['mobile_no']]['member_id'] = $dataSave['member_id'];
    //                     $memberMobileNoArr[$dataSave['mobile_no']]['member_slug'] = $dataSave['member_slug'];
    //                     $memberMobileNoArr[$dataSave['mobile_no']]['name'] = $dataSave['name'];
    //                     $memberMobileNoArr[$dataSave['mobile_no']]['email_id'] = $dataSave['email_id'];
    //                     $memberMobileNoArr[$dataSave['mobile_no']]['gender'] = $dataSave['gender'];
    //                     $memberMobileNoArr[$dataSave['mobile_no']]['relation'] = $dataSave['relation'];
    //                     $memberMobileNoArr[$dataSave['mobile_no']]['birth_year'] = $dataSave['birth_year'];
    //                     $memberMobileNoArr[$dataSave['mobile_no']]['blood_group'] = $dataSave['blood_group'];
    //                 } else {
    //                     $withoutMobileNoMemberInsertArr[] = array(  
    //                         'member_id' => $dataSave['member_id'],
    //                         'member_slug' => $dataSave['member_slug'],
    //                         'name' => $dataSave['name'],
    //                         'email_id' => $dataSave['email_id'],
    //                         'gender' => $dataSave['gender'],
    //                         'relation' => $dataSave['relation'],
    //                         'birth_year' => $dataSave['birth_year'],
    //                         'blood_group' => $dataSave['blood_group'],
    //                     );
    //                 }

    //                 $memberMergeArr = array_merge($memberMobileNoArr,$withoutMobileNoMemberInsertArr);
    //                 $dataSave['row_number'] = $rowNumber;
    //                 $dataSaveBatch[] = $dataSave;
    //                 // printArray($dataResponse);
    //                 // printArray($checkOwnershipFlatArr);
    //                 // printArray($memberMobileNoArr);
    //                 // printArray($withoutMobileNoMemberInsertArr);
    //                 // printArray($memberMergeArr);
    //                 // printArray($dataSaveBatch);
    //             }else{

    //                 $errorPrintExcel = array();
    //                 foreach ($rowErrorArr as $eachError){
    //                     $errorPrintExcel[] = $customErrors[$eachError];
    //                 }
    //                 $errorPrintExcel = implode("\n\n", $errorPrintExcel);
    //                 $dataRowResponse['remarks'] = $errorPrintExcel;
    //                 $dataResponse[] = $dataRowResponse;
    //                 $failedEntries++;
    //             }

    //         }
    //         // printArray($dataResponse,1);
    //         // printArray($checkOwnershipFlatArr);
    //         // printArray($memberMobileNoArr);
    //         // printArray($withoutMobileNoMemberInsertArr);
    //         // printArray($memberMergeArr);
    //         // printArray($dataSaveBatch);
    //         // printArray($mobileNoArr,1);

    //         $reponsePath = $dirAbsPath . $filePrefix . '_RESPONSE.csv';
    //         $reponseRelativePath = $dirRelPath . $filePrefix . '_RESPONSE.csv';

    //         $csvFileName = $dirAbsPath . $filePrefix . '.csv'; 
    //         $zipFileName = $dirRelPath . $filePrefix . '.zip'; 
    //         $csvResponseFileName = $dirAbsPath . $filePrefix . '_RESPONSE.csv'; 
    //         $zipResponseFileName = $dirRelPath . $filePrefix . '_RESPONSE.zip';
            
    //         if(MAKE_ZIP){
    //             $zipFileName = $dirRelPath . $filePrefix . '.zip';
    //             $zipResponseFileName = $dirRelPath . $filePrefix . '_RESPONSE.zip';
    //         } else {
    //             $zipFileName = $dirRelPath . $filePrefix . '.csv';
    //             $zipResponseFileName = $dirRelPath . $filePrefix . '_RESPONSE.csv';
    //         }

    //         $errorMessageDb = '';
    //         if (!$this->dt_ci_common->checkError($errorRowArr)) {
    //             $response['result'] = "data_error";
    //             $errorMessage = "<a class='alert-link' href='javascript:void(0)'>There was an error while uploading file!</a><a href='" . base_url($zipResponseFileName) . "' class='pull-xs-right btn btn-danger' style='color: white;' target='_blank'>Download Response File</a><br></b>";

    //             foreach ($errorRowArr as $key => $value) {
    //                 if (count($value) > 0) {
    //                     if (SHOW_UPLOAD_ERROR) {
    //                         $errorMessage .= '<a href="javascript:void(0)">' . $customErrors[$key] . '</a> in <a class="alert-link" href="javascript:void(0)">ROW# ' . implode(", ", $value) . "</a><br><br>";
    //                     }
    //                 }
    //             }
    //             $response['errorMessage'] = $errorMessage;
    //         } else {
    //             $response['result'] = $errorMessageDb = "ok";
    //         }

    //         $ownershipFlatInsertArr = array();
    //         $insertedOwnerFlatArr = array();
    //         if(!empty($checkOwnershipFlatArr)){
    //             foreach ($checkOwnershipFlatArr as $key => $value) {
    //                 if(empty($value['ownership_flat_id'])){
    //                     $ownershipFlatInsertArr[] = array(
    //                         'flat_id' => $value['flat_id'],
    //                         'ownership_flat_slug' => $value['ownership_flat_slug'],
    //                         'index_no' => $value['index_no'],
    //                         'date_of_registry' => DMYToYMD($value['date_of_registry']),
    //                         'ownership_flat_id' => $value['ownership_flat_id'],
    //                         'purchased_from_id' => '-1',
    //                         'society_id' => $this->session->get('society_id'),
    //                         'is_active' => '1',
    //                         'is_latest' => '1',
    //                         'type' => 'first_owner',
    //                         'resident' => 'Self',
    //                         'created_by' => $userId,
    //                         'updated_by' => $userId,
    //                         'created_at' => date("Y-m-d H:i:s"),
    //                         'updated_at' => date("Y-m-d H:i:s"),
    //                     );
    //                 }
    //                 $insertedOwnerFlatArr[] = $value['ownership_flat_slug'];
    //             }
    //         }

    //         $memberInsertArr = array();
    //         $memberUpdateArr = array();
    //         $insertedMemberArr = array();
    //         if(!empty($memberMergeArr)){
    //             foreach ($memberMergeArr as $key => $value) {
    //                 if(!empty($value['mobile_no'])){
    //                     $mobileNoArr[$value['member_slug']] = $value['mobile_no'];
    //                 }
    //                 if(empty($value['member_id'])){
    //                     $memberInsertArr[] = array(
    //                         'member_slug' => $value['member_slug'],
    //                         'name' => $value['name'],
    //                         'member_id' => $value['member_id'],
    //                         'email_id' => $value['email_id'],
    //                         'gender' => $value['gender'],
    //                         // 'relation' => $value['relation'],
    //                         'birth_date' => DMYToYMD($value['birth_year']),
    //                         // 'society_id' => $this->session->get('society_id'),
    //                         'created_by' => $userId,
    //                         'updated_by' => $userId,
    //                         'created_at' => date("Y-m-d H:i:s"),
    //                         'updated_at' => date("Y-m-d H:i:s"),
    //                     );
    //                 } else {
    //                     $memberUpdateArr[] = array(
    //                         'member_slug' => $value['member_slug'],
    //                         'name' => $value['name'],
    //                         'member_id' => $value['member_id'],
    //                         'email_id' => $value['email_id'],
    //                         'gender' => $value['gender'],
    //                         // 'relation' => $value['relation'],
    //                         'birth_date' => DMYToYMD($value['birth_year']),
    //                         // 'society_id' => $this->session->get('society_id'),
    //                         'created_by' => $userId,
    //                         'updated_by' => $userId,
    //                         'created_at' => date("Y-m-d H:i:s"),
    //                         'updated_at' => date("Y-m-d H:i:s"),
    //                     );
    //                 }
    //                 $insertedMemberArr[] = $value['member_slug'];
    //             }
    //         }

    //         $ownershipFlatMemberInsertArr = array();
    //         if(!empty($dataSaveBatch)){
    //             foreach ($dataSaveBatch as $dataSaveElement) {
    //                 $ownershipFlatMemberInsertArr[] = array(
    //                     'ownership_flat_member_id' => '',
    //                     'ownership_flat_id' => $dataSaveElement['ownership_flat_id'],
    //                     'ownership_flat_slug' => $dataSaveElement['ownership_flat_slug'],
    //                     'name' => $dataSaveElement['name'],
    //                     'member_id' => $dataSaveElement['member_id'],
    //                     'member_slug' => $dataSaveElement['member_slug'],
    //                     'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
    //                     'type' => 'ownership_flat',
    //                     'type_id' => $dataSaveElement['ownership_flat_id'],
    //                     'is_owner' => $dataSave['is_owner'],
    //                     'relation' => $dataSave['relation'],
    //                     'society_id' => $this->session->get('society_id'),
    //                     'created_by' => $userId,
    //                     'updated_by' => $userId,
    //                     'created_at' => date("Y-m-d H:i:s"),
    //                     'updated_at' => date("Y-m-d H:i:s"),
    //                 );
    //             }
    //         }
        
    //         if (isset($ownershipFlatInsertArr) && !empty($ownershipFlatInsertArr)) {
    //             $this->ownershipFlatModel->insertBulkUpload($ownershipFlatInsertArr,'tbl_ownership_flat');
    //         }

    //         if (isset($memberInsertArr) && !empty($memberInsertArr)) {
    //             $this->ownershipFlatModel->insertBulkUpload($memberInsertArr,MASTER_DB.'.tbl_member');
    //         }

    //         if (isset($memberUpdateArr) && !empty($memberUpdateArr)) {
    //             $this->ownershipFlatModel->updateBulkUpload($memberUpdateArr,'member_id',MASTER_DB.'.tbl_member');
    //         }

    //         if (isset($ownershipFlatMemberInsertArr) && !empty($ownershipFlatMemberInsertArr)) {
    //             $this->ownershipFlatModel->insertBulkUpload($ownershipFlatMemberInsertArr,'tbl_ownership_flat_member');
    //         }

    //         $this->ownershipFlatModel->updateOwenrshipFLatId();
    //         $this->ownershipFlatModel->updateMemberId();

    //         $getLatestInsertedArr = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
    //             'is_multiple' => 1,
    //             'is_active' => 1,
    //             'member_slug' => $insertedMemberArr,
    //             'ownership_flat_slug' => $insertedOwnerFlatArr,
    //             'society_id' => $this->session->get('society_id'),
    //         ));

    //         // printArray($getLatestInsertedArr);

    //         $societyId = $this->session->get('society_id');
    //         $tblUsrInsertArr = [];
    //         $tblUsrSocietyInsertArr = [];
    //         $tblUsrGroupArr = [];
    //         $tblUsrPermissionArr = [];
    //         if(!empty($getLatestInsertedArr)){
    //             foreach ($getLatestInsertedArr as $key => &$value) {

    //                 $value['mobile_no'] = isset($mobileNoArr[$value['member_slug']]) ? $mobileNoArr[$value['member_slug']] : '';
    //                 if(!empty($value['mobile_no'])){
    //                     if(!isset($existsMemberDataSocietyWiseArr[$societyId."|".$value['mobile_no']])){
    //                         $password = PASSWORD;
    //                         $slug = random_string();
    //                         $slugSociety = random_string();
    //                         $tblUsrInsertArr[$value['member_id']] = [
    //                             'username' => $value['email_id'],
    //                             'email' => $value['email_id'],
    //                             'first_name' => $value['name'],
    //                             // 'phone' => $value['mobile_no'],
    //                             'user_type_id' => $value['member_id'],
    //                             'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
    //                             'password' => $this->ionAuthModel->hashPassword($password),
    //                             'active' => 1,
    //                             'slug' => $slug,
    //                         ];
                    
    //                         $tblUsrGroupArr[$value['member_id']] = [
    //                             'id' => '',
    //                             'group_id' => $groupId,
    //                             'slug' => $slug,
    //                             'society_slug' => $slugSociety,
    //                         ];
                    
    //                         $tblUsrSocietyInsertArr[$value['member_id']] = [
    //                             'user_society_id' => '',
    //                             'society_id' => $this->session->get('society_id'),
    //                             'phone' => $value['mobile_no'],
    //                             'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
    //                             'type_id' => $value['member_id'],
    //                             'slug' => $slug,
    //                             'is_active' => 1,
    //                             'society_slug' => $slugSociety,
    //                         ];
                    
    //                         foreach ($permissionLabel as $labelData) {
    //                             list($permissionValue, $controller, $label) = explode("|dt|", $labelData);
    //                             if (in_array($permissionValue, $permissionArray)) {
    //                                 $tblUsrPermissionArr[] = [
    //                                     'controller_name' => $controller,
    //                                     'permission_name' => $permissionValue,
    //                                     'permission_label' => $label,
    //                                     'group_id' => $resourceTypeMemberData['group_id'],
    //                                     'slug' => $slug,
    //                                     'society_slug' => $slugSociety,
    //                                     'created_at' => date('Y-m-d H:i:s'),
    //                                     'created_by' => $userId,
    //                                     'updated_at' => date('Y-m-d H:i:s'),
    //                                     'updated_by' => $userId,
    //                                 ];
    //                             }
    //                         }

    //                         $existsMemberDataSocietyWiseArr[$societyId."|".$value['mobile_no']] = $tblUsrSocietyInsertArr[$value['member_id']];
    //                     }
    //                 }
    //             }
    //         }

    //         // printArray($tblUsrInsertArr);
    //         // printArray($tblUsrGroupArr);
    //         // printArray($tblUsrSocietyInsertArr);
    //         // printArray($tblUsrPermissionArr,1);

    //         if (!empty($tblUsrInsertArr)) {
    //             $this->resourceModel->batchInsert($tblUsrInsertArr, MASTER_DB.'.tbl_users');
    //         }
    //         if (!empty($tblUsrGroupArr)) {
    //             $this->resourceModel->batchInsert($tblUsrGroupArr, MASTER_DB.'.tbl_users_groups');
    //         }
    //         if (!empty($tblUsrSocietyInsertArr)) {
    //             $this->resourceModel->batchInsert($tblUsrSocietyInsertArr, MASTER_DB.'.tbl_user_society');
    //         }
    //         if (!empty($tblUsrPermissionArr)) {
    //             $this->resourceModel->batchInsert($tblUsrPermissionArr, MASTER_DB.'.tbl_user_permission');
    //         }

    //         $this->resourceTypeModel->updateUserGroupId();
    //         $this->resourceTypeModel->updateUserSocietyId();
    //         $this->resourceTypeModel->updateUserPermissionId();
    //         $this->resourceTypeModel->updateUserPermissionSocietyId();
    //         $this->resourceTypeModel->updateUserSocietyGroupId();

    //         $this->dt_ci_common->printResponseCsv($reponsePath, $dataResponse);

    //         $fileArray = array(
    //             'file' => $dirAbsPath . $filePrefix . '.csv',
    //             'response_file' => $reponsePath,
    //         );

    //         createZipFromFile($fileArray);

    //         $fileDbResponse = array(
    //             "text" => $errorMessageDb,
    //             "success" => $successEntries,
    //             "failed" => $failedEntries,
    //             "duplicates" => 0,
    //         );
    //         $resourceTypeManagerId = getResourceTypeId(RESOURCE_TYPE_MANAGER,$societyId);
    //         $fileUploadData = array(
    //             "file_type" => $masterType,
    //             // "filepath" => $dirRelPath . $uploadData->getName(),
    //             "filepath" => $zipFileName,
    //             "user_id" => $userId,
    //             "start_time" => $startTime,
    //             "end_time" => date('Y-m-d H:i:s'),
    //             "response_path" => $zipResponseFileName,
    //             "response" => json_encode($fileDbResponse),
    //             'society_id' => $this->session->get('society_id'),
    //             "auto_upload" => !is_array($file) && $file != "" ? 1 : 0,
    //         );

    //         $this->fileUploadModel->saveData($fileUploadData);
    //     }

    //     if (!$return) {
    //         echo json_encode($response);
    //     } else {
    //         if (isset($fileUploadData)) $response['file_upload_data'] = $fileUploadData;
    //         return $response;
    //     }
    // }

    public function uploadOwnershipFlatMember($userId, $return = false, $file = array())
{
    $transactionDate = "";
    $firstRecord = true;
    $startTime = date('Y-m-d H:i:s');
    checkAndCreatePath(OWNERSHIP_FLAT_MEMBER_ABS_PATH);

    $dirAbsPath = OWNERSHIP_FLAT_MEMBER_ABS_PATH;
    $dirRelPath = OWNERSHIP_FLAT_MEMBER_RELATIVE_PATH;

    $masterType = "ownership flat Member";

    // exists Owner Flat data
    $ownershipFlatData = $this->ownershipFlatModel->getOwnershipFlatData(array(
        'is_multiple' => 1,
        'is_latest' => 1,
    ));

    $ownershipTowerFlatArr = array();
    $ownershipFlatArr = array();
    $ownershipFlatIndexArr = array();
    if(!empty($ownershipFlatData)){
        foreach ($ownershipFlatData as $oKey => $oValue) {
            $ownershipFlatArr[$oValue['ownership_flat_no']] = $oValue;
            $ownershipTowerFlatArr[$oValue['clubbed_tower_flat_name']] = $oValue;
            $ownershipFlatIndexArr[$oValue['clubbed_tower_flat_index_no']] = $oValue;
        }
    }

    // exists Flat Data
    $flatArr = array();
    $flatData = $this->flatModel->getFlatData(array(
        'is_multiple' => 1
    ));
    if(!empty($flatData)){
        foreach ($flatData as $fKey => $fValue) {
            $flatArr[$fValue['clubbed_tower_flat_name']] = $fValue;
        }
    }

    // Tower Data
    $towerArr = array();
    $towerData = $this->towerModel->getTowerData(array(
        'is_multiple' => 1
    ));
    if(!empty($towerData)){
        foreach ($towerData as $tKey => $tValue) {
            $towerArr[$tValue['tower_name']] = $tValue;
        }
    }

    // exists Resource Data
    $existsResourceDataArr = array();
    $existsResourceData = $this->resourceModel->getResourceData(array(
        "society_id" => $this->session->get('society_id'),
        "is_multiple" => 1,
    ));
    if(!empty($existsResourceData)){
        foreach ($existsResourceData as $rKey => $rValue) {
            $existsResourceDataArr[$rValue['resource_mobile_no']] = $rValue;
        }
    }

    // Get Resource Type
    $resourceTypeManagerId = getResourceTypeId(RESOURCE_TYPE_MANAGER);
    $resourceTypeMemberId = getResourceTypeId(RESOURCE_TYPE_MEMBER);

    $resourceTypeMemberData = $this->resourceTypeModel->getResourceTypeData(array(
        "resource_type_name" => RESOURCE_TYPE_MEMBER,
        "society_id" => $this->session->get('society_id'),
    ));

    $groupData = $this->commonWebserviceModel->getGroupsData([
        'group_id' => $resourceTypeMemberData['group_id'],
        'society_id' => $this->session->get('society_id'),
    ]);
    $groupId = $groupData['id'] ?? '';
    $permissions = $groupData['permissions'] ?? '';
    $permissionArray = unserialize($permissions);
    $permissionLabel = [];
    $controllers_methods = $this->dt_ci_acl->getPermissableMethods();
    
    foreach ($controllers_methods as $controller_name => $methods_arr) {
        foreach ($methods_arr as $method) {
            $methodDisplay = is_array($method) ? reset($method) : $method;
            $methodActual = is_array($method) ? key($method) : $method;
            $inputName = "$controller_name|$methodActual";
            $permissionLabel[] = "$inputName|dt|$controller_name|dt|$methodDisplay";
        }
    }
    
    // Get manager Data
    $existsManagerDataArr = array();
    $userManagerDataArray = $this->commonWebserviceModel->getUserSocietyData(array(
        'resource_type_id' => $resourceTypeManagerId,
        'society_id' => $resourceTypeManagerId,
        'is_multiple' => 1
    ));
    if(!empty($userManagerDataArray)){
        foreach ($userManagerDataArray as $maKey => $maValue) {
            $existsManagerDataArr[$maValue['phone']] = $maValue;
        }
    }

    // get member data
    $existsMemberDataArr = array();
    $existsMemberDataSocietyWiseArr = array();
    $userMemberDataArray = $this->commonWebserviceModel->getUserSocietyData(array(
        'is_member' => 1,
        'is_multiple' => 1,
    ));
    if(!empty($userMemberDataArray)){
        foreach ($userMemberDataArray as $uMKey => $uMValue) {
            $existsMemberDataArr[$uMValue['phone']] = $uMValue;
            $existsMemberDataSocietyWiseArr[$uMValue['society_id']."|".$uMValue['phone']] = $uMValue;
        }
    }

    $userDataArray = $this->commonWebserviceModel->getUserSocietyData(array(
        'is_multiple' => 1,
        'is_active' => 1,
    ));
    $existsUserDataArr = array();
    $existsUserMobileNoWiseArr = array();
    $existsUserMobileNoSocietyWiseArr = array();
    if(!empty($userDataArray)){
        foreach($userDataArray as $existsUser) {
            $comboKey = $existsUser['society_id']."|".$existsUser['resource_type_id']."|".$existsUser['type_id'];
            $existsUserDataArr[$comboKey] = $existsUser;
            $existsUserMobileNoWiseArr[$existsUser['phone']][] = $existsUser;
            $existsUserMobileNoSocietyWiseArr[$existsUser['phone']][$existsUser['society_id']][] = $existsUser;
        }
    }

    $genderData = genderType();
    $bloodGroupData = bloodGroupType();
    $relationData = relation();

    $customErrors = array(
        "101" => "Flat No required",
        "102" => "Flat No Invalid",
        "201" => "Mobile No Should have 10 digits",
        "202" => "This Mobile No already used by resource in this society",
        "203" => "This Mobile No already used by manager in this society",
        "204" => "Members Can't use same mobile no in same flat",
        "301" => "Name Required",
        "302" => "Index No is Already there",
        "303" => "Index No Required",
        "401" => "Invalid Email Formate",
        "501" => "Invalid gender Type",
        "502" => "Gender required",
        "601" => "Invalid relation Type",
        "701" => "Invalid blood group Type",
        "801" => "Is Owner should be Y Or N Only",
        "901" => "Tower required",
        "902" => "Tower Invalid",
        "1001" => "Invalid formate for date of registory",
        "1101" => "At least one member must be marked as owner (is_owner = Y) for this flat",
    );
    
    $response = $this->dt_ci_common->uploadMasterFile($_FILES, $dirAbsPath, $file);

    if ($response['result'] == 'ok') {
        $dataExcel = $response['unset_data']['data_excel'];
        $uploadData = $response['unset_data']['upload_data'];
        $filePrefix = $response['unset_data']['file_prefix'];
        unset($response['unset_data']);

        $successEntries = 0;
        $failedEntries = 0;

        $errorRowArr = array();
        $dataSaveBatch = array();
        $dataResponse = array();
        $ownershipFlatInsertArr = array();
        $checkOwnershipFlatArr = array();
        $memberMobileNoArr = array();
        $withoutMobileNoMemberInsertArr = array();
        $mobileNoArr = array();

        foreach ($customErrors as $cErrKey => $cErrMessage) {
            $errorRowArr[$cErrKey] = array();
        }
        
        foreach ($dataExcel['values'] as $rowNumber => $row) {

            $dataSave = array();
            $rowErrorArr = array();

            $columnMap = array(
                'A'  => 'tower',
                'B'  => 'flat',
                'C'  => 'index_no',
                'D'  => 'date_of_registry',
                'E'  => 'mobile_no',
                'F'  => 'name',
                'G'  => 'email_id',
                'H'  => 'gender',
                'I'  => 'relation',
                'J'  => 'birth_year',
                'K'  => 'blood_group',
                'L'  => 'is_owner',
            );

            //load dataSave with data in db columns
            foreach ($columnMap as $excelCol => $colMKey) {
                $dataSave[$colMKey] = isset($row[$excelCol]) ? $row[$excelCol] : "";
            }
            $dataRowResponse = $dataSave;
            $dataSave = array_map('trim', $dataSave);

            if (empty($rowErrorArr)) {

                if($dataSave['flat'] != "" && $dataSave['flat'] != NULL){
                    if(!isset($ownershipFlatArr[$dataSave['flat']])){

                        if($dataSave['tower'] != "" && $dataSave['tower'] != NULL){
                            if(!isset($towerArr[$dataSave['tower']])){
                                array_push($errorRowArr[902], $rowNumber);
                                array_push($rowErrorArr, 902);
                            }
                        } else {
                            array_push($errorRowArr[901], $rowNumber);
                            array_push($rowErrorArr, 901);
                        }

                        if($dataSave['flat'] != "" && $dataSave['flat'] != NULL){
                            $towerClubIndex = $dataSave['tower']."|".$dataSave['flat'];
                            if(!isset($flatArr[$towerClubIndex])){
                                array_push($errorRowArr[102], $rowNumber);
                                array_push($rowErrorArr, 102);
                            }else if(isset($ownershipFlatArr[$towerClubIndex])){
                                array_push($errorRowArr[203], $rowNumber);
                                array_push($rowErrorArr, 203);
                            }else {
                                $dataSave['flat_id'] = $flatArr[$towerClubIndex]['flat_id'];
                            }
                        } else {
                            array_push($errorRowArr[101], $rowNumber);
                            array_push($rowErrorArr, 101);
                        }

                        if($dataSave['index_no'] != "" && $dataSave['index_no'] != NULL){
                            $towerIndexClubIndex = $dataSave['tower']."|".$dataSave['index_no'];
                            if(isset($ownershipFlatIndexArr[$towerIndexClubIndex])){
                                array_push($errorRowArr[302], $rowNumber);
                                array_push($rowErrorArr, 302);
                            }
                        } else {
                            array_push($errorRowArr[303], $rowNumber);
                            array_push($rowErrorArr, 303);
                        }

                        if($dataSave['date_of_registry'] != "" && $dataSave['date_of_registry'] != NULL){
                            if (!preg_match('/^\d{2}-\d{2}-\d{4}$/', $dataSave['date_of_registry'])) {
                                array_push($errorRowArr[1001], $rowNumber);
                                array_push($rowErrorArr, 1001);
                            }
                        }

                        if(isset($checkOwnershipFlatArr[$dataSave['flat']])){
                            $dataSave['ownership_flat_slug'] = $checkOwnershipFlatArr[$dataSave['flat']]['ownership_flat_slug'];
                            $dataSave['ownership_flat_id'] = $checkOwnershipFlatArr[$dataSave['flat']]['ownership_flat_id'];
                        } else {
                            $dataSave['ownership_flat_slug'] = random_string();
                            $dataSave['ownership_flat_id'] = '';
                        }
                        
                    } else {
                        $checkOwnershipFlatArr[$dataSave['flat']] = $ownershipFlatArr[$dataSave['flat']];
                        $dataSave['ownership_flat_slug'] = $checkOwnershipFlatArr[$dataSave['flat']]['ownership_flat_slug'];
                        $dataSave['ownership_flat_id'] = $checkOwnershipFlatArr[$dataSave['flat']]['ownership_flat_id'];
                        $dataSave['flat_id'] =  $checkOwnershipFlatArr[$dataSave['flat']]['flat_id'];
                        $dataSave['index_no'] =  $checkOwnershipFlatArr[$dataSave['flat']]['index_no'];
                        $dataSave['date_of_registry'] =  $checkOwnershipFlatArr[$dataSave['flat']]['date_of_registry'];
                    }
                } else {
                    array_push($errorRowArr[101], $rowNumber);
                    array_push($rowErrorArr, 101);
                }

                if(isset($checkOwnershipFlatArr[$dataSave['flat']])){
                    $dataSave['members_phone_no'] = $checkOwnershipFlatArr[$dataSave['flat']]['members_phone_no'];
                    $flatExistsMobileNoArr = explode(",",$checkOwnershipFlatArr[$dataSave['flat']]['members_phone_no']);
                    if(!empty($dataSave['mobile_no'])){
                        if(in_array($dataSave['mobile_no'],$flatExistsMobileNoArr)){
                            array_push($errorRowArr[204], $rowNumber);
                            array_push($rowErrorArr, 204);
                        }else{
                            if(!empty($dataSave['mobile_no'])){
                                $dataSave['members_phone_no'] = $checkOwnershipFlatArr[$dataSave['flat']]['members_phone_no'].",".$dataSave['mobile_no'];
                            }
                        }
                    }
                }

                if(empty($rowErrorArr)){
                    if($dataSave['mobile_no'] != "" && $dataSave['mobile_no'] != NULL){

                        if (!preg_match('/^\d{10}$/', $dataSave['mobile_no'])) {
                            array_push($errorRowArr[201], $rowNumber);
                            array_push($rowErrorArr, 201);
                        }

                        if(isset($existsResourceDataArr[$dataSave['mobile_no']])){
                            array_push($errorRowArr[202], $rowNumber);
                            array_push($rowErrorArr, 202);
                        } else if(isset($existsManagerDataArr[$dataSave['mobile_no']])){
                            array_push($errorRowArr[203], $rowNumber);
                            array_push($rowErrorArr, 203);
                        } else if(isset($existsMemberDataArr[$dataSave['mobile_no']])) {
                            $dataSave['member_id'] = $existsMemberDataArr[$dataSave['mobile_no']]['member_id'];
                            $dataSave['member_slug'] = $existsMemberDataArr[$dataSave['mobile_no']]['member_slug'];
                        } else {
                            $dataSave['member_id'] = '';
                            if(isset($memberMobileNoArr[$dataSave['mobile_no']])){
                                $dataSave['member_slug'] = $memberMobileNoArr[$dataSave['mobile_no']]['member_slug'];
                                $dataSave['member_id'] = $memberMobileNoArr[$dataSave['mobile_no']]['member_id'];
                            } else {
                                $dataSave['member_slug'] = random_string();
                            }
                            $memberMobileNoArr[$dataSave['mobile_no']] = array(
                                'member_slug' => $dataSave['member_slug'],
                                'mobile_no' => $dataSave['mobile_no'],
                                'member_id' => $dataSave['member_id'],
                            );
                        }
                    } else {
                        $dataSave['member_id'] = '';
                        $dataSave['member_slug'] = random_string();
                    }
                }

                if($dataSave['name'] == "" && $dataSave['name'] == NULL){
                    array_push($errorRowArr[301], $rowNumber);
                    array_push($rowErrorArr, 301);
                }

                if($dataSave['email_id'] != "" && $dataSave['email_id'] != NULL){
                    if(!filter_var($dataSave['email_id'], FILTER_VALIDATE_EMAIL)){
                        array_push($errorRowArr[401], $rowNumber);
                        array_push($rowErrorArr, 401);
                    }
                }

                if ($dataSave['gender'] != "" && $dataSave['gender'] != NULL) {
                    if(!isset($genderData[strtolower($dataSave['gender'])])){
                        array_push($errorRowArr[501], $rowNumber);
                        array_push($rowErrorArr, 501);
                    }else{
                        $dataSave['gender'] = strtolower($dataSave['gender']);
                    }
                }else{
                    array_push($errorRowArr[502], $rowNumber);
                    array_push($rowErrorArr, 502);
                }

                if ($dataSave['relation'] != "" && $dataSave['relation'] != NULL) {
                    if(!isset($relationData[strtolower($dataSave['relation'])])){
                        array_push($errorRowArr[601], $rowNumber);
                        array_push($rowErrorArr, 601);
                    }else{
                        $dataSave['relation'] = strtolower($dataSave['relation']);
                    }
                }

                if ($dataSave['blood_group'] != "" && $dataSave['blood_group'] != NULL) {
                    if(!isset($bloodGroupData[$dataSave['blood_group']])){
                        array_push($errorRowArr[701], $rowNumber);
                        array_push($rowErrorArr, 701);
                    }else{
                        $dataSave['blood_group'] = ($dataSave['blood_group']);
                    }
                }

                if ($dataSave['is_owner'] != "" && $dataSave['is_owner'] != NULL) {
                    if(strtolower($dataSave['is_owner']) != 'y' && strtolower($dataSave['is_owner']) != 'n'){
                        array_push($errorRowArr[801], $rowNumber);
                        array_push($rowErrorArr, 801);
                    }else{
                        $dataSave['is_owner'] = strtolower($dataSave['is_owner']) == 'y' ? 1 : 0;
                    }
                }

            }

            if(empty($rowErrorArr)){
                $successEntries++;
                
                // Store row number for owner validation
                $dataSave['row_number'] = $rowNumber;
                
                $checkOwnershipFlatArr[$dataSave['flat']] = array(
                    'flat' => $dataSave['flat'],
                    'flat_id' => $dataSave['flat_id'],
                    'ownership_flat_slug' => $dataSave['ownership_flat_slug'],
                    'index_no' => $dataSave['index_no'],
                    'date_of_registry' => $dataSave['date_of_registry'],
                    'ownership_flat_id' => $dataSave['ownership_flat_id'],
                    'members_phone_no' => isset($dataSave['members_phone_no']) ? $dataSave['members_phone_no'] : $dataSave['mobile_no'],
                );

                if(!empty($dataSave['mobile_no'])){
                    $memberMobileNoArr[$dataSave['mobile_no']]['member_id'] = $dataSave['member_id'];
                    $memberMobileNoArr[$dataSave['mobile_no']]['member_slug'] = $dataSave['member_slug'];
                    $memberMobileNoArr[$dataSave['mobile_no']]['name'] = $dataSave['name'];
                    $memberMobileNoArr[$dataSave['mobile_no']]['email_id'] = $dataSave['email_id'];
                    $memberMobileNoArr[$dataSave['mobile_no']]['gender'] = $dataSave['gender'];
                    $memberMobileNoArr[$dataSave['mobile_no']]['relation'] = $dataSave['relation'];
                    $memberMobileNoArr[$dataSave['mobile_no']]['birth_year'] = $dataSave['birth_year'];
                    $memberMobileNoArr[$dataSave['mobile_no']]['blood_group'] = $dataSave['blood_group'];
                } else {
                    $withoutMobileNoMemberInsertArr[] = array(  
                        'member_id' => $dataSave['member_id'],
                        'member_slug' => $dataSave['member_slug'],
                        'name' => $dataSave['name'],
                        'email_id' => $dataSave['email_id'],
                        'gender' => $dataSave['gender'],
                        'relation' => $dataSave['relation'],
                        'birth_year' => $dataSave['birth_year'],
                        'blood_group' => $dataSave['blood_group'],
                    );
                }

                $memberMergeArr = array_merge($memberMobileNoArr,$withoutMobileNoMemberInsertArr);
                $dataSaveBatch[] = $dataSave;
            }else{

                $errorPrintExcel = array();
                foreach ($rowErrorArr as $eachError){
                    $errorPrintExcel[] = $customErrors[$eachError];
                }
                $errorPrintExcel = implode("\n\n", $errorPrintExcel);
                $dataRowResponse['remarks'] = $errorPrintExcel;
                $dataResponse[] = $dataRowResponse;
                $failedEntries++;
            }

        }
        
        // ========== NEW OWNER VALIDATION LOGIC START ==========
        // Validate that each new flat has at least one owner
        $flatOwnerValidation = array();

        // Build ownership tracking from processed data
        foreach ($dataSaveBatch as $dataSaveElement) {
            $flatKey = $dataSaveElement['flat'];
            
            // Only check new flats (those not in $ownershipFlatArr)
            if (!isset($ownershipFlatArr[$flatKey])) {
                if (!isset($flatOwnerValidation[$flatKey])) {
                    $flatOwnerValidation[$flatKey] = array(
                        'has_owner' => false,
                        'row_numbers' => array(),
                        'row_data' => array()
                    );
                }
                
                // Track if this flat has an owner
                if (isset($dataSaveElement['is_owner']) && $dataSaveElement['is_owner'] == 1) {
                    $flatOwnerValidation[$flatKey]['has_owner'] = true;
                }
                
                // Store row number and data for error reporting
                $flatOwnerValidation[$flatKey]['row_numbers'][] = $dataSaveElement['row_number'];
                $flatOwnerValidation[$flatKey]['row_data'][] = $dataSaveElement;
            }
        }

        // Check for flats without owners and mark errors
        $flatsToRemove = array();
        foreach ($flatOwnerValidation as $flatKey => $validation) {
            if (!$validation['has_owner']) {
                // Add error for all rows of this flat
                foreach ($validation['row_numbers'] as $rowNum) {
                    if (!in_array($rowNum, $errorRowArr[1101])) {
                        array_push($errorRowArr[1101], $rowNum);
                    }
                }
                
                // Prepare error response for all rows of this flat
                foreach ($validation['row_data'] as $item) {
                    $errorRowData = array(
                        'tower' => $item['tower'] ?? '',
                        'flat' => $item['flat'] ?? '',
                        'index_no' => $item['index_no'] ?? '',
                        'date_of_registry' => $item['date_of_registry'] ?? '',
                        'mobile_no' => $item['mobile_no'] ?? '',
                        'name' => $item['name'] ?? '',
                        'email_id' => $item['email_id'] ?? '',
                        'gender' => $item['gender'] ?? '',
                        'relation' => $item['relation'] ?? '',
                        'birth_year' => $item['birth_year'] ?? '',
                        'blood_group' => $item['blood_group'] ?? '',
                        'is_owner' => isset($item['is_owner']) && $item['is_owner'] == 1 ? 'Y' : 'N',
                        'remarks' => $customErrors[1101]
                    );
                    $dataResponse[] = $errorRowData;
                }
                
                // Adjust counters
                $failedCount = count($validation['row_numbers']);
                $successEntries -= $failedCount;
                $failedEntries += $failedCount;
                
                // Mark flat for removal
                $flatsToRemove[] = $flatKey;
                
                // Remove from checkOwnershipFlatArr to prevent insertion
                unset($checkOwnershipFlatArr[$flatKey]);
                
                // Clean up memberMobileNoArr for members only in this flat
                foreach ($validation['row_data'] as $item) {
                    if (!empty($item['mobile_no'])) {
                        // Check if this mobile is used only in this flat
                        $mobileUsedElsewhere = false;
                        foreach ($dataSaveBatch as $checkItem) {
                            if ($checkItem['flat'] != $flatKey && 
                                isset($checkItem['mobile_no']) && 
                                $checkItem['mobile_no'] == $item['mobile_no']) {
                                $mobileUsedElsewhere = true;
                                break;
                            }
                        }
                        if (!$mobileUsedElsewhere) {
                            unset($memberMobileNoArr[$item['mobile_no']]);
                        }
                    }
                }
            }
        }

        // Remove failed entries from dataSaveBatch
        if (!empty($flatsToRemove)) {
            $dataSaveBatch = array_filter($dataSaveBatch, function($item) use ($flatsToRemove) {
                return !in_array($item['flat'], $flatsToRemove);
            });
            
            // Reindex array
            $dataSaveBatch = array_values($dataSaveBatch);
            
            // Rebuild memberMergeArr
            $memberMergeArr = array_merge($memberMobileNoArr, $withoutMobileNoMemberInsertArr);
        }
        // ========== NEW OWNER VALIDATION LOGIC END ==========

        $reponsePath = $dirAbsPath . $filePrefix . '_RESPONSE.csv';
        $reponseRelativePath = $dirRelPath . $filePrefix . '_RESPONSE.csv';

        $csvFileName = $dirAbsPath . $filePrefix . '.csv'; 
        $zipFileName = $dirRelPath . $filePrefix . '.zip'; 
        $csvResponseFileName = $dirAbsPath . $filePrefix . '_RESPONSE.csv'; 
        $zipResponseFileName = $dirRelPath . $filePrefix . '_RESPONSE.zip';
        
        if(MAKE_ZIP){
            $zipFileName = $dirRelPath . $filePrefix . '.zip';
            $zipResponseFileName = $dirRelPath . $filePrefix . '_RESPONSE.zip';
        } else {
            $zipFileName = $dirRelPath . $filePrefix . '.csv';
            $zipResponseFileName = $dirRelPath . $filePrefix . '_RESPONSE.csv';
        }

        $errorMessageDb = '';
        if (!$this->dt_ci_common->checkError($errorRowArr)) {
            $response['result'] = "data_error";
            $errorMessage = "<a class='alert-link' href='javascript:void(0)'>There was an error while uploading file!</a><a href='" . base_url($zipResponseFileName) . "' class='pull-xs-right btn btn-danger' style='color: white;' target='_blank'>Download Response File</a><br></b>";

            foreach ($errorRowArr as $key => $value) {
                if (count($value) > 0) {
                    if (SHOW_UPLOAD_ERROR) {
                        $errorMessage .= '<a href="javascript:void(0)">' . $customErrors[$key] . '</a> in <a class="alert-link" href="javascript:void(0)">ROW# ' . implode(", ", $value) . "</a><br><br>";
                    }
                }
            }
            $response['errorMessage'] = $errorMessage;
        } else {
            $response['result'] = $errorMessageDb = "ok";
        }

        $ownershipFlatInsertArr = array();
        $insertedOwnerFlatArr = array();
        if(!empty($checkOwnershipFlatArr)){
            foreach ($checkOwnershipFlatArr as $key => $value) {
                if(empty($value['ownership_flat_id'])){
                    $ownershipFlatInsertArr[] = array(
                        'flat_id' => $value['flat_id'],
                        'ownership_flat_slug' => $value['ownership_flat_slug'],
                        'index_no' => $value['index_no'],
                        'date_of_registry' => DMYToYMD($value['date_of_registry']),
                        'ownership_flat_id' => $value['ownership_flat_id'],
                        'purchased_from_id' => '-1',
                        'society_id' => $this->session->get('society_id'),
                        'is_active' => '1',
                        'is_latest' => '1',
                        'type' => 'first_owner',
                        'resident' => 'Self',
                        'created_by' => $userId,
                        'updated_by' => $userId,
                        'created_at' => date("Y-m-d H:i:s"),
                        'updated_at' => date("Y-m-d H:i:s"),
                    );
                }
                $insertedOwnerFlatArr[] = $value['ownership_flat_slug'];
            }
        }

        $memberInsertArr = array();
        $memberUpdateArr = array();
        $insertedMemberArr = array();
        if(!empty($memberMergeArr)){
            foreach ($memberMergeArr as $key => $value) {
                if(!empty($value['mobile_no'])){
                    $mobileNoArr[$value['member_slug']] = $value['mobile_no'];
                }
                if(empty($value['member_id'])){
                    $memberInsertArr[] = array(
                        'member_slug' => $value['member_slug'],
                        'name' => $value['name'],
                        'member_id' => $value['member_id'],
                        'email_id' => $value['email_id'],
                        'gender' => $value['gender'],
                        'birth_date' => DMYToYMD($value['birth_year']),
                        'created_by' => $userId,
                        'updated_by' => $userId,
                        'created_at' => date("Y-m-d H:i:s"),
                        'updated_at' => date("Y-m-d H:i:s"),
                    );
                } else {
                    $memberUpdateArr[] = array(
                        'member_slug' => $value['member_slug'],
                        'name' => $value['name'],
                        'member_id' => $value['member_id'],
                        'email_id' => $value['email_id'],
                        'gender' => $value['gender'],
                        'birth_date' => DMYToYMD($value['birth_year']),
                        'created_by' => $userId,
                        'updated_by' => $userId,
                        'created_at' => date("Y-m-d H:i:s"),
                        'updated_at' => date("Y-m-d H:i:s"),
                    );
                }
                $insertedMemberArr[] = $value['member_slug'];
            }
        }

        $ownershipFlatMemberInsertArr = array();
        if(!empty($dataSaveBatch)){
            foreach ($dataSaveBatch as $dataSaveElement) {
                $ownershipFlatMemberInsertArr[] = array(
                    'ownership_flat_member_id' => '',
                    'ownership_flat_id' => $dataSaveElement['ownership_flat_id'],
                    'ownership_flat_slug' => $dataSaveElement['ownership_flat_slug'],
                    'name' => $dataSaveElement['name'],
                    'member_id' => $dataSaveElement['member_id'],
                    'member_slug' => $dataSaveElement['member_slug'],
                    'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                    'type' => 'ownership_flat',
                    'type_id' => $dataSaveElement['ownership_flat_id'],
                    'is_owner' => $dataSaveElement['is_owner'],
                    'relation' => $dataSaveElement['relation'],
                    'society_id' => $this->session->get('society_id'),
                    'created_by' => $userId,
                    'updated_by' => $userId,
                    'created_at' => date("Y-m-d H:i:s"),
                    'updated_at' => date("Y-m-d H:i:s"),
                );
            }
        }
    
        if (isset($ownershipFlatInsertArr) && !empty($ownershipFlatInsertArr)) {
            $this->ownershipFlatModel->insertBulkUpload($ownershipFlatInsertArr,'tbl_ownership_flat');
        }

        if (isset($memberInsertArr) && !empty($memberInsertArr)) {
            $this->ownershipFlatModel->insertBulkUpload($memberInsertArr,MASTER_DB.'.tbl_member');
        }

        if (isset($memberUpdateArr) && !empty($memberUpdateArr)) {
            $this->ownershipFlatModel->updateBulkUpload($memberUpdateArr,'member_id',MASTER_DB.'.tbl_member');
        }

        if (isset($ownershipFlatMemberInsertArr) && !empty($ownershipFlatMemberInsertArr)) {
            $this->ownershipFlatModel->insertBulkUpload($ownershipFlatMemberInsertArr,'tbl_ownership_flat_member');
        }

        $this->ownershipFlatModel->updateOwenrshipFLatId();
        $this->ownershipFlatModel->updateMemberId();

        $getLatestInsertedArr = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
            'is_multiple' => 1,
            'is_active' => 1,
            'member_slug' => $insertedMemberArr,
            'ownership_flat_slug' => $insertedOwnerFlatArr,
            'society_id' => $this->session->get('society_id'),
        ));

        $societyId = $this->session->get('society_id');
        $tblUsrInsertArr = [];
        $tblUsrSocietyInsertArr = [];
        $tblUsrGroupArr = [];
        $tblUsrPermissionArr = [];
        if(!empty($getLatestInsertedArr)){
            foreach ($getLatestInsertedArr as $key => &$value) {

                $value['mobile_no'] = isset($mobileNoArr[$value['member_slug']]) ? $mobileNoArr[$value['member_slug']] : '';
                if(!empty($value['mobile_no'])){
                    if(!isset($existsMemberDataSocietyWiseArr[$societyId."|".$value['mobile_no']])){
                        $password = PASSWORD;
                        $slug = random_string();
                        $slugSociety = random_string();
                        $tblUsrInsertArr[$value['member_id']] = [
                            'username' => $value['email_id'],
                            'email' => $value['email_id'],
                            'first_name' => $value['name'],
                            'user_type_id' => $value['member_id'],
                            'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                            'password' => $this->ionAuthModel->hashPassword($password),
                            'active' => 1,
                            'slug' => $slug,
                        ];
                
                        $tblUsrGroupArr[$value['member_id']] = [
                            'id' => '',
                            'group_id' => $groupId,
                            'slug' => $slug,
                            'society_slug' => $slugSociety,
                        ];
                
                        $tblUsrSocietyInsertArr[$value['member_id']] = [
                            'user_society_id' => '',
                            'society_id' => $this->session->get('society_id'),
                            'phone' => $value['mobile_no'],
                            'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                            'type_id' => $value['member_id'],
                            'slug' => $slug,
                            'is_active' => 1,
                            'society_slug' => $slugSociety,
                        ];
                
                        foreach ($permissionLabel as $labelData) {
                            list($permissionValue, $controller, $label) = explode("|dt|", $labelData);
                            if (in_array($permissionValue, $permissionArray)) {
                                $tblUsrPermissionArr[] = [
                                    'controller_name' => $controller,
                                    'permission_name' => $permissionValue,
                                    'permission_label' => $label,
                                    'group_id' => $resourceTypeMemberData['group_id'],
                                    'slug' => $slug,
                                    'society_slug' => $slugSociety,
                                    'created_at' => date('Y-m-d H:i:s'),
                                    'created_by' => $userId,
                                    'updated_at' => date('Y-m-d H:i:s'),
                                    'updated_by' => $userId,
                                ];
                            }
                        }

                        $existsMemberDataSocietyWiseArr[$societyId."|".$value['mobile_no']] = $tblUsrSocietyInsertArr[$value['member_id']];
                    }
                }
            }
        }

        if (!empty($tblUsrInsertArr)) {
            $this->resourceModel->batchInsert($tblUsrInsertArr, MASTER_DB.'.tbl_users');
        }
        if (!empty($tblUsrGroupArr)) {
            $this->resourceModel->batchInsert($tblUsrGroupArr, MASTER_DB.'.tbl_users_groups');
        }
        if (!empty($tblUsrSocietyInsertArr)) {
            $this->resourceModel->batchInsert($tblUsrSocietyInsertArr, MASTER_DB.'.tbl_user_society');
        }
        if (!empty($tblUsrPermissionArr)) {
            $this->resourceModel->batchInsert($tblUsrPermissionArr, MASTER_DB.'.tbl_user_permission');
        }

        $this->resourceTypeModel->updateUserGroupId();
        $this->resourceTypeModel->updateUserSocietyId();
        $this->resourceTypeModel->updateUserPermissionId();
        $this->resourceTypeModel->updateUserPermissionSocietyId();
        $this->resourceTypeModel->updateUserSocietyGroupId();

        $this->dt_ci_common->printResponseCsv($reponsePath, $dataResponse);

        $fileArray = array(
            'file' => $dirAbsPath . $filePrefix . '.csv',
            'response_file' => $reponsePath,
        );

        createZipFromFile($fileArray);

        $fileDbResponse = array(
            "text" => $errorMessageDb,
            "success" => $successEntries,
            "failed" => $failedEntries,
            "duplicates" => 0,
        );
        $resourceTypeManagerId = getResourceTypeId(RESOURCE_TYPE_MANAGER,$societyId);
        $fileUploadData = array(
            "file_type" => $masterType,
            "filepath" => $zipFileName,
            "user_id" => $userId,
            "start_time" => $startTime,
            "end_time" => date('Y-m-d H:i:s'),
            "response_path" => $zipResponseFileName,
            "response" => json_encode($fileDbResponse),
            'society_id' => $this->session->get('society_id'),
            "auto_upload" => !is_array($file) && $file != "" ? 1 : 0,
        );

        $this->fileUploadModel->saveData($fileUploadData);
    }

    if (!$return) {
        echo json_encode($response);
    } else {
        if (isset($fileUploadData)) $response['file_upload_data'] = $fileUploadData;
        return $response;
    }
}


//     public function uploadOwnershipFlatMember($userId, $return = false, $file = array())
// {
//     $transactionDate = "";
//     $firstRecord = true;
//     $startTime = date('Y-m-d H:i:s');
//     checkAndCreatePath(OWNERSHIP_FLAT_MEMBER_ABS_PATH);

//     $dirAbsPath = OWNERSHIP_FLAT_MEMBER_ABS_PATH;
//     $dirRelPath = OWNERSHIP_FLAT_MEMBER_RELATIVE_PATH;

//     $masterType = "ownership flat Member";

//     // exists Owner Flat data
//     $ownershipFlatData = $this->ownershipFlatModel->getOwnershipFlatData(array(
//         'is_multiple' => 1,
//         'is_latest' => 1,
//     ));

//     $ownershipTowerFlatArr = array();
//     $ownershipFlatArr = array();
//     $ownershipFlatIndexArr = array();
//     if(!empty($ownershipFlatData)){
//         foreach ($ownershipFlatData as $oKey => $oValue) {
//             $ownershipFlatArr[$oValue['ownership_flat_no']] = $oValue;
//             $ownershipTowerFlatArr[$oValue['clubbed_tower_flat_name']] = $oValue;
//             $ownershipFlatIndexArr[$oValue['clubbed_tower_flat_index_no']] = $oValue;
//         }
//     }

//     // exists Flat Data
//     $flatArr = array();
//     $flatData = $this->flatModel->getFlatData(array(
//         'is_multiple' => 1
//     ));
//     if(!empty($flatData)){
//         foreach ($flatData as $fKey => $fValue) {
//             $flatArr[$fValue['clubbed_tower_flat_name']] = $fValue;
//         }
//     }

//     // Tower Data
//     $towerArr = array();
//     $towerData = $this->towerModel->getTowerData(array(
//         'is_multiple' => 1
//     ));
//     if(!empty($towerData)){
//         foreach ($towerData as $tKey => $tValue) {
//             $towerArr[$tValue['tower_name']] = $tValue;
//         }
//     }

//     // exists Resource Data
//     $existsResourceDataArr = array();
//     $existsResourceData = $this->resourceModel->getResourceData(array(
//         "society_id" => $this->session->get('society_id'),
//         "is_multiple" => 1,
//     ));
//     if(!empty($existsResourceData)){
//         foreach ($existsResourceData as $rKey => $rValue) {
//             $existsResourceDataArr[$rValue['resource_mobile_no']] = $rValue;
//         }
//     }
    
//     // Get Resource Type
//     $resourceTypeManagerId = getResourceTypeId(RESOURCE_TYPE_MANAGER);
//     $resourceTypeMemberId = getResourceTypeId(RESOURCE_TYPE_MEMBER);

//     $resourceTypeMemberData = $this->resourceTypeModel->getResourceTypeData(array(
//         "resource_type_name" => RESOURCE_TYPE_MEMBER,
//         "society_id" => $this->session->get('society_id'),
//     ));

//     $groupData = $this->commonWebserviceModel->getGroupsData([
//         'group_id' => $resourceTypeMemberData['group_id'],
//         'society_id' => $this->session->get('society_id'),
//     ]);
//     $groupId = $groupData['id'] ?? '';
//     $permissions = $groupData['permissions'] ?? '';
//     $permissionArray = unserialize($permissions);
//     $permissionLabel = [];
//     $controllers_methods = $this->dt_ci_acl->getPermissableMethods();
    
//     foreach ($controllers_methods as $controller_name => $methods_arr) {
//         foreach ($methods_arr as $method) {
//             $methodDisplay = is_array($method) ? reset($method) : $method;
//             $methodActual = is_array($method) ? key($method) : $method;
//             $inputName = "$controller_name|$methodActual";
//             $permissionLabel[] = "$inputName|dt|$controller_name|dt|$methodDisplay";
//         }
//     }
    
//     // Get manager Data
//     $existsManagerDataArr = array();
//     $userManagerDataArray = $this->commonWebserviceModel->getUserSocietyData(array(
//         'resource_type_id' => $resourceTypeManagerId,
//         'society_id' => $resourceTypeManagerId,
//         'is_multiple' => 1
//     ));
//     if(!empty($userManagerDataArray)){
//         foreach ($userManagerDataArray as $maKey => $maValue) {
//             $existsManagerDataArr[$maValue['phone']] = $maValue;
//         }
//     }

//     // get member data
//     $existsMemberDataArr = array();
//     $existsMemberDataSocietyWiseArr = array();
//     $userMemberDataArray = $this->commonWebserviceModel->getUserSocietyData(array(
//         'is_member' => 1,
//         'is_multiple' => 1,
//     ));
//     if(!empty($userMemberDataArray)){
//         foreach ($userMemberDataArray as $uMKey => $uMValue) {
//             $existsMemberDataArr[$uMValue['phone']] = $uMValue;
//             $existsMemberDataSocietyWiseArr[$uMValue['society_id']."|".$uMValue['phone']] = $uMValue;
//         }
//     }

//     $userDataArray = $this->commonWebserviceModel->getUserSocietyData(array(
//         'is_multiple' => 1,
//         'is_active' => 1,
//     ));
//     $existsUserDataArr = array();
//     $existsUserMobileNoWiseArr = array();
//     $existsUserMobileNoSocietyWiseArr = array();
//     if(!empty($userDataArray)){
//         foreach($userDataArray as $existsUser) {
//             $comboKey = $existsUser['society_id']."|".$existsUser['resource_type_id']."|".$existsUser['type_id'];
//             $existsUserDataArr[$comboKey] = $existsUser;
//             $existsUserMobileNoWiseArr[$existsUser['phone']][] = $existsUser;
//             $existsUserMobileNoSocietyWiseArr[$existsUser['phone']][$existsUser['society_id']][] = $existsUser;
//         }
//     }

//     $genderData = genderType();
//     $bloodGroupData = bloodGroupType();
//     $relationData = relation();

//     $customErrors = array(
//         "101" => "Flat No required",
//         "102" => "Flat No Invalid",
//         "201" => "Mobile No Should have 10 digits",
//         "202" => "This Mobile No already used by resource in this society",
//         "203" => "This Mobile No already used by manager in this society",
//         "204" => "Members Can't use same mobile no in same flat",
//         "301" => "Name Required",
//         "302" => "Index No is Already there",
//         "303" => "Index No Required",
//         "401" => "Invalid Email Formate",
//         "501" => "Invalid gender Type",
//         "502" => "Gender required",
//         "601" => "Invalid relation Type",
//         "701" => "Invalid blood group Type",
//         "801" => "Is Owner should be Y Or N Only",
//         "901" => "Tower required",
//         "902" => "Tower Invalid",
//         "1001" => "Invalid formate for date of registory",
//         "1101" => "At least one member must be selected as owner for the flat", // New error code
//     );
    
//     $response = $this->dt_ci_common->uploadMasterFile($_FILES, $dirAbsPath, $file);

//     if ($response['result'] == 'ok') {
//         $dataExcel = $response['unset_data']['data_excel'];
//         $uploadData = $response['unset_data']['upload_data'];
//         $filePrefix = $response['unset_data']['file_prefix'];
//         unset($response['unset_data']);

//         $successEntries = 0;
//         $failedEntries = 0;

//         $errorRowArr = array();
//         $dataSaveBatch = array();
//         $dataResponse = array();
//         $ownershipFlatInsertArr = array();
//         $checkOwnershipFlatArr = array();
//         $memberMobileNoArr = array();
//         $withoutMobileNoMemberInsertArr = array();
//         $mobileNoArr = array();

        
//         // Track owners per flat
//         $flatOwners = array();
//         $flatRowNumbers = array(); // Track which rows belong to which flat

//         foreach ($customErrors as $cErrKey => $cErrMessage) {
//             $errorRowArr[$cErrKey] = array();
//         }
        
//         foreach ($dataExcel['values'] as $rowNumber => $row) {

//             $dataSave = array();
//             $rowErrorArr = array();

//             $columnMap = array(
//                 'A'  => 'tower',
//                 'B'  => 'flat',
//                 'C'  => 'index_no',
//                 'D'  => 'date_of_registry',
//                 'E'  => 'mobile_no',
//                 'F'  => 'name',
//                 'G'  => 'email_id',
//                 'H'  => 'gender',
//                 'I'  => 'relation',
//                 'J'  => 'birth_year',
//                 'K'  => 'blood_group',
//                 'L'  => 'is_owner',
//             );

//             //load dataSave with data in db columns
//             foreach ($columnMap as $excelCol => $colMKey) {
//                 $dataSave[$colMKey] = isset($row[$excelCol]) ? $row[$excelCol] : "";
//             }
//             $dataRowResponse = $dataSave;
//             $dataSave = array_map('trim', $dataSave);

//             // Track row numbers for each flat
//             if (!empty($dataSave['flat'])) {
//                 if (!isset($flatRowNumbers[$dataSave['flat']])) {
//                     $flatRowNumbers[$dataSave['flat']] = array();
//                 }
//                 $flatRowNumbers[$dataSave['flat']][] = $rowNumber;
//             }

//             if (empty($rowErrorArr)) {

//                 if($dataSave['flat'] != "" && $dataSave['flat'] != NULL){
//                     if(!isset($ownershipFlatArr[$dataSave['flat']])){
//                         if($dataSave['tower'] != "" && $dataSave['tower'] != NULL){
//                             if(!isset($towerArr[$dataSave['tower']])){
//                                 array_push($errorRowArr[902], $rowNumber);
//                                 array_push($rowErrorArr, 902);
//                             }
//                         } else {
//                             array_push($errorRowArr[901], $rowNumber);
//                             array_push($rowErrorArr, 901);
//                         }

//                         if($dataSave['flat'] != "" && $dataSave['flat'] != NULL){
//                             $towerClubIndex = $dataSave['tower']."|".$dataSave['flat'];
//                             if(!isset($flatArr[$towerClubIndex])){
//                                 array_push($errorRowArr[102], $rowNumber);
//                                 array_push($rowErrorArr, 102);
//                             }else if(isset($ownershipFlatArr[$towerClubIndex])){
//                                 array_push($errorRowArr[203], $rowNumber);
//                                 array_push($rowErrorArr, 203);
//                             }else {
//                                 $dataSave['flat_id'] = $flatArr[$towerClubIndex]['flat_id'];
//                             }
//                         } else {
//                             array_push($errorRowArr[101], $rowNumber);
//                             array_push($rowErrorArr, 101);
//                         }

//                         if($dataSave['index_no'] != "" && $dataSave['index_no'] != NULL){
//                             $towerIndexClubIndex = $dataSave['tower']."|".$dataSave['index_no'];
//                             if(isset($ownershipFlatIndexArr[$towerIndexClubIndex])){
//                                 array_push($errorRowArr[302], $rowNumber);
//                                 array_push($rowErrorArr, 302);
//                             }
//                         } else {
//                             array_push($errorRowArr[303], $rowNumber);
//                             array_push($rowErrorArr, 303);
//                         }

//                         if($dataSave['date_of_registry'] != "" && $dataSave['date_of_registry'] != NULL){
//                             if (!preg_match('/^\d{2}-\d{2}-\d{4}$/', $dataSave['date_of_registry'])) {
//                                 array_push($errorRowArr[1001], $rowNumber);
//                                 array_push($rowErrorArr, 1001);
//                             }
//                         }

//                         if(isset($checkOwnershipFlatArr[$dataSave['flat']])){
//                             $dataSave['ownership_flat_slug'] = $checkOwnershipFlatArr[$dataSave['flat']]['ownership_flat_slug'];
//                             $dataSave['ownership_flat_id'] = $checkOwnershipFlatArr[$dataSave['flat']]['ownership_flat_id'];
//                         } else {
//                             $dataSave['ownership_flat_slug'] = random_string();
//                             $dataSave['ownership_flat_id'] = '';
//                         }
                        
//                     } else {
//                         $checkOwnershipFlatArr[$dataSave['flat']] = $ownershipFlatArr[$dataSave['flat']];
//                         $dataSave['ownership_flat_slug'] = $checkOwnershipFlatArr[$dataSave['flat']]['ownership_flat_slug'];
//                         $dataSave['ownership_flat_id'] = $checkOwnershipFlatArr[$dataSave['flat']]['ownership_flat_id'];
//                         $dataSave['flat_id'] =  $checkOwnershipFlatArr[$dataSave['flat']]['flat_id'];
//                         $dataSave['index_no'] =  $checkOwnershipFlatArr[$dataSave['flat']]['index_no'];
//                         $dataSave['date_of_registry'] =  $checkOwnershipFlatArr[$dataSave['flat']]['date_of_registry'];
//                     }
//                 } else {
//                     array_push($errorRowArr[101], $rowNumber);
//                     array_push($rowErrorArr, 101);
//                 }

//                 if(isset($checkOwnershipFlatArr[$dataSave['flat']])){
//                     $dataSave['members_phone_no'] = $checkOwnershipFlatArr[$dataSave['flat']]['members_phone_no'];
//                     $flatExistsMobileNoArr = explode(",",$checkOwnershipFlatArr[$dataSave['flat']]['members_phone_no']);
//                     if(!empty($dataSave['mobile_no'])){
//                         if(in_array($dataSave['mobile_no'],$flatExistsMobileNoArr)){
//                             array_push($errorRowArr[204], $rowNumber);
//                             array_push($rowErrorArr, 204);
//                         }else{
//                             if(!empty($dataSave['mobile_no'])){
//                                 $dataSave['members_phone_no'] = $checkOwnershipFlatArr[$dataSave['flat']]['members_phone_no'].",".$dataSave['mobile_no'];
//                             }
//                         }
//                     }
//                 }

//                 if(empty($rowErrorArr)){
//                     if($dataSave['mobile_no'] != "" && $dataSave['mobile_no'] != NULL){
//                         if (!preg_match('/^\d{10}$/', $dataSave['mobile_no'])) {
//                             array_push($errorRowArr[201], $rowNumber);
//                             array_push($rowErrorArr, 201);
//                         }

//                         if(isset($existsResourceDataArr[$dataSave['mobile_no']])){
//                             array_push($errorRowArr[202], $rowNumber);
//                             array_push($rowErrorArr, 202);
//                         } else if(isset($existsManagerDataArr[$dataSave['mobile_no']])){
//                             array_push($errorRowArr[203], $rowNumber);
//                             array_push($rowErrorArr, 203);
//                         } else if(isset($existsMemberDataArr[$dataSave['mobile_no']])) {
//                             $dataSave['member_id'] = $existsMemberDataArr[$dataSave['mobile_no']]['member_id'];
//                             $dataSave['member_slug'] = $existsMemberDataArr[$dataSave['mobile_no']]['member_slug'];
//                         } else {
//                             $dataSave['member_id'] = '';
//                             if(isset($memberMobileNoArr[$dataSave['mobile_no']])){
//                                 $dataSave['member_slug'] = $memberMobileNoArr[$dataSave['mobile_no']]['member_slug'];
//                                 $dataSave['member_id'] = $memberMobileNoArr[$dataSave['mobile_no']]['member_id'];
//                             } else {
//                                 $dataSave['member_slug'] = random_string();
//                             }
//                             $memberMobileNoArr[$dataSave['mobile_no']] = array(
//                                 'member_slug' => $dataSave['member_slug'],
//                                 'mobile_no' => $dataSave['mobile_no'],
//                                 'member_id' => $dataSave['member_id'],
//                             );
//                         }
//                     } else {
//                         $dataSave['member_id'] = '';
//                         $dataSave['member_slug'] = random_string();
//                     }
//                 }

//                 if($dataSave['name'] == "" && $dataSave['name'] == NULL){
//                     array_push($errorRowArr[301], $rowNumber);
//                     array_push($rowErrorArr, 301);
//                 }

//                 if($dataSave['email_id'] != "" && $dataSave['email_id'] != NULL){
//                     if(!filter_var($dataSave['email_id'], FILTER_VALIDATE_EMAIL)){
//                         array_push($errorRowArr[401], $rowNumber);
//                         array_push($rowErrorArr, 401);
//                     }
//                 }

//                 if ($dataSave['gender'] != "" && $dataSave['gender'] != NULL) {
//                     if(!isset($genderData[strtolower($dataSave['gender'])])){
//                         array_push($errorRowArr[501], $rowNumber);
//                         array_push($rowErrorArr, 501);
//                     }else{
//                         $dataSave['gender'] = strtolower($dataSave['gender']);
//                     }
//                 }else{
//                     array_push($errorRowArr[502], $rowNumber);
//                     array_push($rowErrorArr, 502);
//                 }

//                 if ($dataSave['relation'] != "" && $dataSave['relation'] != NULL) {
//                     if(!isset($relationData[strtolower($dataSave['relation'])])){
//                         array_push($errorRowArr[601], $rowNumber);
//                         array_push($rowErrorArr, 601);
//                     }else{
//                         $dataSave['relation'] = strtolower($dataSave['relation']);
//                     }
//                 }

//                 if ($dataSave['blood_group'] != "" && $dataSave['blood_group'] != NULL) {
//                     if(!isset($bloodGroupData[$dataSave['blood_group']])){
//                         array_push($errorRowArr[701], $rowNumber);
//                         array_push($rowErrorArr, 701);
//                     }else{
//                         $dataSave['blood_group'] = ($dataSave['blood_group']);
//                     }
//                 }

//                 if ($dataSave['is_owner'] != "" && $dataSave['is_owner'] != NULL) {
//                     if(strtolower($dataSave['is_owner']) != 'y' && strtolower($dataSave['is_owner']) != 'n'){
//                         array_push($errorRowArr[801], $rowNumber);
//                         array_push($rowErrorArr, 801);
//                     }else{
//                         $dataSave['is_owner'] = strtolower($dataSave['is_owner']) == 'y' ? 1 : 0;
                        
//                         // Track owner status for the flat
//                         if ($dataSave['is_owner'] == 1) {
//                             if (!isset($flatOwners[$dataSave['flat']])) {
//                                 $flatOwners[$dataSave['flat']] = 0;
//                             }
//                             $flatOwners[$dataSave['flat']]++;
//                         }
//                     }
//                 } else {
//                     $dataSave['is_owner'] = 0;
//                 }

//             }

//             if(empty($rowErrorArr)){
//                 $successEntries++;
                
//                 $checkOwnershipFlatArr[$dataSave['flat']] = array(
//                     'flat' => $dataSave['flat'],
//                     'flat_id' => $dataSave['flat_id'],
//                     'ownership_flat_slug' => $dataSave['ownership_flat_slug'],
//                     'index_no' => $dataSave['index_no'],
//                     'date_of_registry' => $dataSave['date_of_registry'],
//                     'ownership_flat_id' => $dataSave['ownership_flat_id'],
//                     'members_phone_no' => isset($dataSave['members_phone_no']) ? $dataSave['members_phone_no'] : $dataSave['mobile_no'],
//                 );

//                 if(!empty($dataSave['mobile_no'])){
//                     $memberMobileNoArr[$dataSave['mobile_no']]['member_id'] = $dataSave['member_id'];
//                     $memberMobileNoArr[$dataSave['mobile_no']]['member_slug'] = $dataSave['member_slug'];
//                     $memberMobileNoArr[$dataSave['mobile_no']]['name'] = $dataSave['name'];
//                     $memberMobileNoArr[$dataSave['mobile_no']]['email_id'] = $dataSave['email_id'];
//                     $memberMobileNoArr[$dataSave['mobile_no']]['gender'] = $dataSave['gender'];
//                     $memberMobileNoArr[$dataSave['mobile_no']]['relation'] = $dataSave['relation'];
//                     $memberMobileNoArr[$dataSave['mobile_no']]['birth_year'] = $dataSave['birth_year'];
//                     $memberMobileNoArr[$dataSave['mobile_no']]['blood_group'] = $dataSave['blood_group'];
//                     $memberMobileNoArr[$dataSave['mobile_no']]['is_owner'] = $dataSave['is_owner'];
//                 } else {
//                     $withoutMobileNoMemberInsertArr[] = array(  
//                         'member_id' => $dataSave['member_id'],
//                         'member_slug' => $dataSave['member_slug'],
//                         'name' => $dataSave['name'],
//                         'email_id' => $dataSave['email_id'],
//                         'gender' => $dataSave['gender'],
//                         'relation' => $dataSave['relation'],
//                         'birth_year' => $dataSave['birth_year'],
//                         'blood_group' => $dataSave['blood_group'],
//                         'is_owner' => $dataSave['is_owner'],
//                     );
//                 }

//                 $memberMergeArr = array_merge($memberMobileNoArr,$withoutMobileNoMemberInsertArr);
//                 $dataSaveBatch[$rowNumber] = $dataSave;
//             } else {
//                 $errorPrintExcel = array();
//                 foreach ($rowErrorArr as $eachError){
//                     $errorPrintExcel[] = $customErrors[$eachError];
//                 }
//                 $errorPrintExcel = implode("\n\n", $errorPrintExcel);
//                 $dataRowResponse['remarks'] = $errorPrintExcel;
//                 $dataResponse[] = $dataRowResponse;
//                 $failedEntries++;
//             }
//         }

//         // NEW VALIDATION: Check if each flat has at least one owner
//         $flatOwnerValidationErrors = array();
//         foreach ($checkOwnershipFlatArr as $flat => $flatData) {
//             if (!isset($flatOwners[$flat]) || $flatOwners[$flat] == 0) {
//                 $flatOwnerValidationErrors[$flat] = true;
//                 // Add this error to errorRowArr for proper error tracking
//                 if (isset($flatRowNumbers[$flat])) {
//                     foreach ($flatRowNumbers[$flat] as $errorRowNumber) {
//                         array_push($errorRowArr[1101], $errorRowNumber);
//                     }
//                 }
//             }
//         }

//         // If there are flats without owners, mark all rows for those flats as errors
//         if (!empty($flatOwnerValidationErrors)) {
//             foreach ($dataSaveBatch as $rowNumber => $dataSave) {
//                 if (isset($flatOwnerValidationErrors[$dataSave['flat']])) {
//                     // Remove from success count and add to failed count
//                     $successEntries--;
//                     $failedEntries++;
                    
//                     // Update the dataResponse with the error
//                     $dataRowResponse = $dataSave;
//                     $existingRemarks = isset($dataResponse[$rowNumber]['remarks']) ? $dataResponse[$rowNumber]['remarks'] . "\n\n" : "";
//                     $dataRowResponse['remarks'] = $existingRemarks . $customErrors[1101];
//                     $dataResponse[$rowNumber] = $dataRowResponse;
                    
//                     // Remove from dataSaveBatch
//                     unset($dataSaveBatch[$rowNumber]);
                    
//                     // Also remove from tracking arrays to prevent insertion
//                     if (!empty($dataSave['mobile_no']) && isset($memberMobileNoArr[$dataSave['mobile_no']])) {
//                         unset($memberMobileNoArr[$dataSave['mobile_no']]);
//                     }
                    
//                     // Remove from checkOwnershipFlatArr to prevent flat creation
//                     if (isset($checkOwnershipFlatArr[$dataSave['flat']])) {
//                         unset($checkOwnershipFlatArr[$dataSave['flat']]);
//                     }
//                 }
//             }
//             // Reindex dataSaveBatch after unsetting elements
//             $dataSaveBatch = array_values($dataSaveBatch);
//         }

//         // printArray($dataResponse,1);

//         $reponsePath = $dirAbsPath . $filePrefix . '_RESPONSE.csv';
//         $reponseRelativePath = $dirRelPath . $filePrefix . '_RESPONSE.csv';

//         $csvFileName = $dirAbsPath . $filePrefix . '.csv'; 
//         $zipFileName = $dirRelPath . $filePrefix . '.zip'; 
//         $csvResponseFileName = $dirAbsPath . $filePrefix . '_RESPONSE.csv'; 
//         $zipResponseFileName = $dirRelPath . $filePrefix . '_RESPONSE.zip';
        
//         if(MAKE_ZIP){
//             $zipFileName = $dirRelPath . $filePrefix . '.zip';
//             $zipResponseFileName = $dirRelPath . $filePrefix . '_RESPONSE.zip';
//         } else {
//             $zipFileName = $dirRelPath . $filePrefix . '.csv';
//             $zipResponseFileName = $dirRelPath . $filePrefix . '_RESPONSE.csv';
//         }

//         $errorMessageDb = '';
//         if (!$this->dt_ci_common->checkError($errorRowArr)) {
//             $response['result'] = "data_error";
//             $errorMessage = "<a class='alert-link' href='javascript:void(0)'>There was an error while uploading file!</a><a href='" . base_url($zipResponseFileName) . "' class='pull-xs-right btn btn-danger' style='color: white;' target='_blank'>Download Response File</a><br></b>";

//             foreach ($errorRowArr as $key => $value) {
//                 if (count($value) > 0) {
//                     if (SHOW_UPLOAD_ERROR) {
//                         $errorMessage .= '<a href="javascript:void(0)">' . $customErrors[$key] . '</a> in <a class="alert-link" href="javascript:void(0)">ROW# ' . implode(", ", $value) . "</a><br><br>";
//                     }
//                 }
//             }
//             $response['errorMessage'] = $errorMessage;
//         } else {
//             $response['result'] = $errorMessageDb = "ok";
//         }

//         // printArray($response['result'],1);

//         // Rest of your existing code for database operations remains the same...
//         $ownershipFlatInsertArr = array();
//         $insertedOwnerFlatArr = array();
//         if(!empty($checkOwnershipFlatArr)){
//             foreach ($checkOwnershipFlatArr as $key => $value) {
//                 if(empty($value['ownership_flat_id'])){
//                     $ownershipFlatInsertArr[] = array(
//                         'flat_id' => $value['flat_id'],
//                         'ownership_flat_slug' => $value['ownership_flat_slug'],
//                         'index_no' => $value['index_no'],
//                         'date_of_registry' => DMYToYMD($value['date_of_registry']),
//                         'ownership_flat_id' => $value['ownership_flat_id'],
//                         'purchased_from_id' => '-1',
//                         'society_id' => $this->session->get('society_id'),
//                         'is_active' => '1',
//                         'is_latest' => '1',
//                         'type' => 'first_owner',
//                         'resident' => 'Self',
//                         'created_by' => $userId,
//                         'updated_by' => $userId,
//                         'created_at' => date("Y-m-d H:i:s"),
//                         'updated_at' => date("Y-m-d H:i:s"),
//                     );
//                 }
//                 $insertedOwnerFlatArr[] = $value['ownership_flat_slug'];
//             }
//         }

//         $memberInsertArr = array();
//         $memberUpdateArr = array();
//         $insertedMemberArr = array();
//         if(!empty($memberMergeArr)){
//             foreach ($memberMergeArr as $key => $value) {
//                 if(!empty($value['mobile_no'])){
//                     $mobileNoArr[$value['member_slug']] = $value['mobile_no'];
//                 }
//                 if(empty($value['member_id'])){
//                     $memberInsertArr[] = array(
//                         'member_slug' => $value['member_slug'],
//                         'name' => $value['name'],
//                         'member_id' => $value['member_id'],
//                         'email_id' => $value['email_id'],
//                         'gender' => $value['gender'],
//                         'birth_date' => DMYToYMD($value['birth_year']),
//                         'created_by' => $userId,
//                         'updated_by' => $userId,
//                         'created_at' => date("Y-m-d H:i:s"),
//                         'updated_at' => date("Y-m-d H:i:s"),
//                     );
//                 } else {
//                     $memberUpdateArr[] = array(
//                         'member_slug' => $value['member_slug'],
//                         'name' => $value['name'],
//                         'member_id' => $value['member_id'],
//                         'email_id' => $value['email_id'],
//                         'gender' => $value['gender'],
//                         'birth_date' => DMYToYMD($value['birth_year']),
//                         'created_by' => $userId,
//                         'updated_by' => $userId,
//                         'created_at' => date("Y-m-d H:i:s"),
//                         'updated_at' => date("Y-m-d H:i:s"),
//                     );
//                 }
//                 $insertedMemberArr[] = $value['member_slug'];
//             }
//         }

//         $ownershipFlatMemberInsertArr = array();
//         if(!empty($dataSaveBatch)){
//             foreach ($dataSaveBatch as $dataSaveElement) {
//                 $ownershipFlatMemberInsertArr[] = array(
//                     'ownership_flat_member_id' => '',
//                     'ownership_flat_id' => $dataSaveElement['ownership_flat_id'],
//                     'ownership_flat_slug' => $dataSaveElement['ownership_flat_slug'],
//                     'name' => $dataSaveElement['name'],
//                     'member_id' => $dataSaveElement['member_id'],
//                     'member_slug' => $dataSaveElement['member_slug'],
//                     'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
//                     'type' => 'ownership_flat',
//                     'type_id' => $dataSaveElement['ownership_flat_id'],
//                     'is_owner' => $dataSaveElement['is_owner'],
//                     'relation' => $dataSaveElement['relation'],
//                     'society_id' => $this->session->get('society_id'),
//                     'created_by' => $userId,
//                     'updated_by' => $userId,
//                     'created_at' => date("Y-m-d H:i:s"),
//                     'updated_at' => date("Y-m-d H:i:s"),
//                 );
//             }
//         }
    
//         if (isset($ownershipFlatInsertArr) && !empty($ownershipFlatInsertArr)) {
//             $this->ownershipFlatModel->insertBulkUpload($ownershipFlatInsertArr,'tbl_ownership_flat');
//         }

//         if (isset($memberInsertArr) && !empty($memberInsertArr)) {
//             $this->ownershipFlatModel->insertBulkUpload($memberInsertArr,MASTER_DB.'.tbl_member');
//         }

//         if (isset($memberUpdateArr) && !empty($memberUpdateArr)) {
//             $this->ownershipFlatModel->updateBulkUpload($memberUpdateArr,'member_id',MASTER_DB.'.tbl_member');
//         }

//         if (isset($ownershipFlatMemberInsertArr) && !empty($ownershipFlatMemberInsertArr)) {
//             $this->ownershipFlatModel->insertBulkUpload($ownershipFlatMemberInsertArr,'tbl_ownership_flat_member');
//         }

//         $this->ownershipFlatModel->updateOwenrshipFLatId();
//         $this->ownershipFlatModel->updateMemberId();

//         $getLatestInsertedArr = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
//             'is_multiple' => 1,
//             'is_active' => 1,
//             'member_slug' => $insertedMemberArr,
//             'ownership_flat_slug' => $insertedOwnerFlatArr,
//             'society_id' => $this->session->get('society_id'),
//         ));

//         // Rest of your existing code for user creation remains the same...
//         $societyId = $this->session->get('society_id');
//         $tblUsrInsertArr = [];
//         $tblUsrSocietyInsertArr = [];
//         $tblUsrGroupArr = [];
//         $tblUsrPermissionArr = [];
//         if(!empty($getLatestInsertedArr)){
//             foreach ($getLatestInsertedArr as $key => &$value) {

//                 $value['mobile_no'] = isset($mobileNoArr[$value['member_slug']]) ? $mobileNoArr[$value['member_slug']] : '';
//                 if(!empty($value['mobile_no'])){
//                     if(!isset($existsMemberDataSocietyWiseArr[$societyId."|".$value['mobile_no']])){
//                         $password = PASSWORD;
//                         $slug = random_string();
//                         $slugSociety = random_string();
//                         $tblUsrInsertArr[$value['member_id']] = [
//                             'username' => $value['email_id'],
//                             'email' => $value['email_id'],
//                             'first_name' => $value['name'],
//                             'user_type_id' => $value['member_id'],
//                             'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
//                             'password' => $this->ionAuthModel->hashPassword($password),
//                             'active' => 1,
//                             'slug' => $slug,
//                         ];
                
//                         $tblUsrGroupArr[$value['member_id']] = [
//                             'id' => '',
//                             'group_id' => $groupId,
//                             'slug' => $slug,
//                             'society_slug' => $slugSociety,
//                         ];
                
//                         $tblUsrSocietyInsertArr[$value['member_id']] = [
//                             'user_society_id' => '',
//                             'society_id' => $this->session->get('society_id'),
//                             'phone' => $value['mobile_no'],
//                             'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
//                             'type_id' => $value['member_id'],
//                             'slug' => $slug,
//                             'is_active' => 1,
//                             'society_slug' => $slugSociety,
//                         ];
                
//                         foreach ($permissionLabel as $labelData) {
//                             list($permissionValue, $controller, $label) = explode("|dt|", $labelData);
//                             if (in_array($permissionValue, $permissionArray)) {
//                                 $tblUsrPermissionArr[] = [
//                                     'controller_name' => $controller,
//                                     'permission_name' => $permissionValue,
//                                     'permission_label' => $label,
//                                     'group_id' => $resourceTypeMemberData['group_id'],
//                                     'slug' => $slug,
//                                     'society_slug' => $slugSociety,
//                                     'created_at' => date('Y-m-d H:i:s'),
//                                     'created_by' => $userId,
//                                     'updated_at' => date('Y-m-d H:i:s'),
//                                     'updated_by' => $userId,
//                                 ];
//                             }
//                         }

//                         $existsMemberDataSocietyWiseArr[$societyId."|".$value['mobile_no']] = $tblUsrSocietyInsertArr[$value['member_id']];
//                     }
//                 }
//             }
//         }

//         if (!empty($tblUsrInsertArr)) {
//             $this->resourceModel->batchInsert($tblUsrInsertArr, MASTER_DB.'.tbl_users');
//         }
//         if (!empty($tblUsrGroupArr)) {
//             $this->resourceModel->batchInsert($tblUsrGroupArr, MASTER_DB.'.tbl_users_groups');
//         }
//         if (!empty($tblUsrSocietyInsertArr)) {
//             $this->resourceModel->batchInsert($tblUsrSocietyInsertArr, MASTER_DB.'.tbl_user_society');
//         }
//         if (!empty($tblUsrPermissionArr)) {
//             $this->resourceModel->batchInsert($tblUsrPermissionArr, MASTER_DB.'.tbl_user_permission');
//         }

//         $this->resourceTypeModel->updateUserGroupId();
//         $this->resourceTypeModel->updateUserSocietyId();
//         $this->resourceTypeModel->updateUserPermissionId();
//         $this->resourceTypeModel->updateUserPermissionSocietyId();
//         $this->resourceTypeModel->updateUserSocietyGroupId();

//         $this->dt_ci_common->printResponseCsv($reponsePath, $dataResponse);

//         $fileArray = array(
//             'file' => $dirAbsPath . $filePrefix . '.csv',
//             'response_file' => $reponsePath,
//         );

//         createZipFromFile($fileArray);

//         $fileDbResponse = array(
//             "text" => $errorMessageDb,
//             "success" => $successEntries,
//             "failed" => $failedEntries,
//             "duplicates" => 0,
//         );
//         $resourceTypeManagerId = getResourceTypeId(RESOURCE_TYPE_MANAGER,$societyId);
//         $fileUploadData = array(
//             "file_type" => $masterType,
//             "filepath" => $zipFileName,
//             "user_id" => $userId,
//             "start_time" => $startTime,
//             "end_time" => date('Y-m-d H:i:s'),
//             "response_path" => $zipResponseFileName,
//             "response" => json_encode($fileDbResponse),
//             'society_id' => $this->session->get('society_id'),
//             "auto_upload" => !is_array($file) && $file != "" ? 1 : 0,
//         );

//         $this->fileUploadModel->saveData($fileUploadData);
//     }

//     if (!$return) {
//         echo json_encode($response);
//     } else {
//         if (isset($fileUploadData)) $response['file_upload_data'] = $fileUploadData;
//         return $response;
//     }
// }
    public function uploadEmergencyContact($userId, $return = false, $file = array())
    {

        $startTime = date('Y-m-d H:i:s');
        checkAndCreatePath(OWNERSHIP_FLAT_EMERGENCY_CONTACT_ABS_PATH);

        $dirAbsPath = OWNERSHIP_FLAT_EMERGENCY_CONTACT_ABS_PATH;
        $dirRelPath = OWNERSHIP_FLAT_EMERGENCY_CONTACT_RELATIVE_PATH;

        $masterType = "ownership flat";

        $ownershipFlatData = $this->ownershipFlatModel->getOwnershipFlatData(array(
            'is_multiple' => 1,
            // 'society_id' => 1
        ));

        $ownershipFlatArr = array();
        $ownershipFlatIndexArr = array();
        if(!empty($ownershipFlatData)){
            foreach ($ownershipFlatData as $oKey => $oValue) {
                $ownershipFlatArr[$oValue['clubbed_tower_flat_name']] = $oValue;
                $ownershipFlatIndexArr[$oValue['clubbed_tower_flat_index_no']] = $oValue;
            }
        }

        // Tower Data
        $towerArr = array();
        $towerData = $this->towerModel->getTowerData(array(
            'is_multiple' => 1
            // 'is_multiple' => 1
        ));
        if(!empty($towerData)){
            foreach ($towerData as $tKey => $tValue) {
                $towerArr[$tValue['tower_name']] = $tValue;
            }
        }

        $flatArr = array();
        $flatData = $this->flatModel->getFlatData(array(
            'is_multiple' => 1
            // 'is_multiple' => 1
        ));
        if(!empty($flatData)){
            foreach ($flatData as $fKey => $fValue) {
                $flatArr[$fValue['clubbed_tower_flat_name']] = $fValue;
            }
        }

        $relationData = relation();

        // printArray($towerArr);
        // printArray($flatArr);
        // printArray($ownershipFlatArr,1);

        $customErrors = array(
            "101" => "Tower required",
            "102" => "Tower Invalid",
            "201" => "Flat required",
            "202" => "Flat Invalid",
            "203" => "Ownership Flat Invalid",
            "301" => "Name Required",
            "302" => "Name Invalid",
            "401" => "Place Required",
            "501" => "Relation Invalid",
            "601" => "Mobile No Required",
            "602" => "Mobile No Should have 10 digits",
        );
        $response = $this->dt_ci_common->uploadMasterFile($_FILES, $dirAbsPath, $file);
        // printArray($response,1);

        if ($response['result'] == 'ok') {
            $dataExcel = $response['unset_data']['data_excel'];
            $uploadData = $response['unset_data']['upload_data'];
            $filePrefix = $response['unset_data']['file_prefix'];
            unset($response['unset_data']);

            $successEntries = 0;
            $failedEntries = 0;

            $errorRowArr = array();
            $dataSaveBatch = array();
            $dataResponse = array();
            $ownershipFlatInsertArr = array();

            foreach ($customErrors as $cErrKey => $cErrMessage) {
                $errorRowArr[$cErrKey] = array();
            }
            foreach ($dataExcel['values'] as $rowNumber => $row) {

                $dataSave = array();
                $rowErrorArr = array();

                $columnMap = array(
                    'A'  => 'tower',
                    'B'  => 'flat',
                    'C'  => 'name',
                    'D'  => 'place',
                    'E'  => 'relation',
                    'F'  => 'mobile_no',
                );

                //load dataSave with data in db columns
                foreach ($columnMap as $excelCol => $colMKey) {
                    $dataSave[$colMKey] = isset($row[$excelCol]) ? $row[$excelCol] : "";
                }
                $dataRowResponse = $dataSave;
                $dataSave = array_map('trim', $dataSave);

                if (empty($rowErrorArr)) {

                    if($dataSave['tower'] != "" && $dataSave['tower'] != NULL){
                        if(!isset($towerArr[$dataSave['tower']])){
                            array_push($errorRowArr[102], $rowNumber);
                            array_push($rowErrorArr, 102);
                        }
                    } else {
                        array_push($errorRowArr[101], $rowNumber);
                        array_push($rowErrorArr, 101);
                    }

                    if($dataSave['flat'] != "" && $dataSave['flat'] != NULL){
                        $towerClubIndex = $dataSave['tower']."|".$dataSave['flat'];
                        if(!isset($flatArr[$towerClubIndex])){
                            array_push($errorRowArr[202], $rowNumber);
                            array_push($rowErrorArr, 202);
                        }else if(!isset($ownershipFlatArr[$towerClubIndex])){
                            array_push($errorRowArr[203], $rowNumber);
                            array_push($rowErrorArr, 203);
                        }else {
                            $dataSave['ownership_flat_id'] = $ownershipFlatArr[$towerClubIndex]['ownership_flat_id'];
                        }
                    } else {
                        array_push($errorRowArr[201], $rowNumber);
                        array_push($rowErrorArr, 201);
                    }

                    if($dataSave['name'] == "" && $dataSave['name'] == NULL){
                        array_push($errorRowArr[301], $rowNumber);
                        array_push($rowErrorArr, 301);
                    }

                    if($dataSave['place'] == "" && $dataSave['place'] == NULL){
                        array_push($errorRowArr[401], $rowNumber);
                        array_push($rowErrorArr, 401);
                    }

                    if ($dataSave['relation'] != "" && $dataSave['relation'] != NULL) {
                        if(!isset($relationData[strtolower($dataSave['relation'])])){
                            array_push($errorRowArr[501], $rowNumber);
                            array_push($rowErrorArr, 501);
                        }else{
                            $dataSave['relation'] = strtolower($dataSave['relation']);
                        }
                    }

                    if($dataSave['mobile_no'] != "" && $dataSave['mobile_no'] != NULL){
                        if (!preg_match('/^\d{10}$/', $dataSave['mobile_no'])) {
                            array_push($errorRowArr[602], $rowNumber);
                            array_push($rowErrorArr, 602);
                        }
                    } else {
                        array_push($errorRowArr[601], $rowNumber);
                        array_push($rowErrorArr, 601);
                    }

                }

                if(empty($rowErrorArr)){
                    $successEntries++;
                    $dataSaveBatch[] = $dataSave;
                }else{

                    $errorPrintExcel = array();
                    foreach ($rowErrorArr as $eachError){
                        $errorPrintExcel[] = $customErrors[$eachError];
                    }
                    $errorPrintExcel = implode("\n\n", $errorPrintExcel);
                    $dataRowResponse['remarks'] = $errorPrintExcel;
                    $dataResponse[] = $dataRowResponse;
                    $failedEntries++;
                }

            }
            // printArray($dataSaveBatch,1);

            $reponsePath = $dirAbsPath . $filePrefix . '_RESPONSE.csv';
            $reponseRelativePath = $dirRelPath . $filePrefix . '_RESPONSE.csv';

            $csvFileName = $dirAbsPath . $filePrefix . '.csv'; 
            $zipFileName = $dirRelPath . $filePrefix . '.zip'; 
            $csvResponseFileName = $dirAbsPath . $filePrefix . '_RESPONSE.csv'; 
            $zipResponseFileName = $dirRelPath . $filePrefix . '_RESPONSE.zip';
            
            if(MAKE_ZIP){
                $zipFileName = $dirRelPath . $filePrefix . '.zip';
                $zipResponseFileName = $dirRelPath . $filePrefix . '_RESPONSE.zip';
            } else {
                $zipFileName = $dirRelPath . $filePrefix . '.csv';
                $zipResponseFileName = $dirRelPath . $filePrefix . '_RESPONSE.csv';
            }

            $errorMessageDb = '';
            if (!$this->dt_ci_common->checkError($errorRowArr)) {
                $response['result'] = "data_error";
                $errorMessage = "<a class='alert-link' href='javascript:void(0)'>There was an error while uploading file!</a><a href='" . base_url($zipResponseFileName) . "' class='pull-xs-right btn btn-danger' style='color: white;' target='_blank'>Download Response File</a><br></b>";

                foreach ($errorRowArr as $key => $value) {
                    if (count($value) > 0) {
                        if (SHOW_UPLOAD_ERROR) {
                            $errorMessage .= '<a href="javascript:void(0)">' . $customErrors[$key] . '</a> in <a class="alert-link" href="javascript:void(0)">ROW# ' . implode(", ", $value) . "</a><br><br>";
                        }
                    }
                }
                $response['errorMessage'] = $errorMessage;
            } else {
                $response['result'] = $errorMessageDb = "ok";
            }

            $emergencyContactArr = array();
            if (!empty($dataSaveBatch)) {
                foreach ($dataSaveBatch as $dataSaveElement) {
                    $emergencyContactArr[] = array(
                        'ownership_flat_emergency_contact_id' => '',
                        'type' => 'ownership_flat',
                        'type_id' => $dataSaveElement['ownership_flat_id'],
                        'name' => $dataSaveElement['name'],
                        'place' => $dataSaveElement['place'],
                        'relation' => $dataSaveElement['relation'],
                        'mobile_no' => $dataSaveElement['mobile_no'],
                        'created_by' => $userId,
                        'updated_by' => $userId,
                        'created_at' => date("Y-m-d H:i:s"),
                        'updated_at' => date("Y-m-d H:i:s"),
                    );
                }
            }

            if (isset($emergencyContactArr) && !empty($emergencyContactArr)) {
                $this->ownershipFlatModel->insertBulkUpload($emergencyContactArr,'tbl_ownership_flat_emergency_contact');
            }

            $this->dt_ci_common->printResponseCsv($reponsePath,$dataResponse);

            $fileArray = array(
                'file' => $dirAbsPath . $filePrefix . '.csv',
                'response_file' => $reponsePath,
            );

            createZipFromFile($fileArray);

            $fileDbResponse = array(
                "text" => $errorMessageDb,
                "success" => $successEntries,
                "failed" => $failedEntries,
                "duplicates" => 0,
            );

            $fileUploadData = array(
                "file_type" => $masterType,
                "filepath" => $zipFileName,
                "user_id" => $userId,
                "start_time" => $startTime,
                "end_time" => date('Y-m-d H:i:s'),
                "response_path" => $zipResponseFileName,
                "response" => json_encode($fileDbResponse),
                'society_id' => $this->session->get('society_id'),
                "auto_upload" => !is_array($file) && $file != "" ? 1 : 0,
            );

            $this->fileUploadModel->saveData($fileUploadData);
        }

        if (!$return) {
            echo json_encode($response);
        } else {
            if (isset($fileUploadData)) $response['file_upload_data'] = $fileUploadData;
            return $response;
        }
    }

    public function uploadVehicleInfo($userId, $return = false, $file = array())
    {

        $startTime = date('Y-m-d H:i:s');
        checkAndCreatePath(OWNERSHIP_FLAT_VEHICLE_ABS_PATH);

        $dirAbsPath = OWNERSHIP_FLAT_VEHICLE_ABS_PATH;
        $dirRelPath = OWNERSHIP_FLAT_VEHICLE_RELATIVE_PATH;

        $masterType = "ownership flat";

        $ownershipFlatData = $this->ownershipFlatModel->getOwnershipFlatData(array(
            'is_multiple' => 1,
            // 'society_id' => 1
        ));

        $ownershipFlatArr = array();
        $ownershipFlatIndexArr = array();
        if(!empty($ownershipFlatData)){
            foreach ($ownershipFlatData as $oKey => $oValue) {
                $ownershipFlatArr[$oValue['clubbed_tower_flat_name']] = $oValue;
                $ownershipFlatIndexArr[$oValue['clubbed_tower_flat_index_no']] = $oValue;
            }
        }

        // Tower Data
        $towerArr = array();
        $towerData = $this->towerModel->getTowerData(array(
            'is_multiple' => 1
            // 'is_multiple' => 1
        ));
        if(!empty($towerData)){
            foreach ($towerData as $tKey => $tValue) {
                $towerArr[$tValue['tower_name']] = $tValue;
            }
        }

        $flatArr = array();
        $flatData = $this->flatModel->getFlatData(array(
            'is_multiple' => 1
            // 'is_multiple' => 1
        ));
        if(!empty($flatData)){
            foreach ($flatData as $fKey => $fValue) {
                $flatArr[$fValue['clubbed_tower_flat_name']] = $fValue;
            }
        }

        $slotArr = array();
        $slotFlatArr = array();
        $slotData = $this->parkingSlotModel->getParkingSlotData(array(
            'is_multiple' => 1
            // 'is_multiple' => 1
        ));
        if(!empty($slotData)){
            foreach ($slotData as $fKey => $sValue) {
                $slotArr[$sValue['number']] = $sValue;
                if(!empty($sValue['flat_id'])){
                    $slotFlatArr[$sValue['flat_id']][$sValue['number']] = $sValue;
                }
            }
        }

        $occupiedParkingDataArr = array();
        $occupiedParkingData = $this->ownershipFlatModel->getOwnershipFlatParkingData(array(
            'is_multiple' => 1
        ));
        if(!empty($occupiedParkingData)){
            foreach ($occupiedParkingData as $oKey => $oValue) {
                if(!empty($oValue['parking_slot_id'])){
                    $occupiedParkingDataArr[$oValue['flat_id']][$oValue['number']] = $oValue;
                }
            }
        }

        // printArray($slotData);
        // printArray($slotArr);
        // printArray($slotFlatArr);
        // printArray($occupiedParkingDataArr);
        
        $relationData = relation();
        $vehicleData = vehicleType();

        // printArray($towerArr);
        // printArray($flatArr);
        // printArray($ownershipFlatArr,1);

        $customErrors = array(
            "101" => "Tower required",
            "102" => "Tower Invalid",
            "201" => "Flat required",
            "202" => "Flat Invalid",
            "203" => "Ownership Flat Invalid",
            "301" => "Vehicle Type Required",
            "302" => "Vehicle Type Invalid",
            "401" => "Vehicle No Required",
            "501" => "Parking Slot Required",
            "502" => "Parking Slot Invalid",
            "503" => "This Parking slot not available for this flat",
            "504" => "This Parking slot not for this vehicle type",
            "505" => "This Parking slot has been already used",
            "601" => "Token No Required",
            "701" => "Is Electric should be Y Or N Only",
        );
        $response = $this->dt_ci_common->uploadMasterFile($_FILES, $dirAbsPath, $file);
        // printArray($response,1);

        if ($response['result'] == 'ok') {
            $dataExcel = $response['unset_data']['data_excel'];
            $uploadData = $response['unset_data']['upload_data'];
            $filePrefix = $response['unset_data']['file_prefix'];
            unset($response['unset_data']);

            $successEntries = 0;
            $failedEntries = 0;

            $errorRowArr = array();
            $dataSaveBatch = array();
            $dataResponse = array();
            $ownershipFlatInsertArr = array();

            foreach ($customErrors as $cErrKey => $cErrMessage) {
                $errorRowArr[$cErrKey] = array();
            }
            foreach ($dataExcel['values'] as $rowNumber => $row) {

                $dataSave = array();
                $rowErrorArr = array();

                $columnMap = array(
                    'A'  => 'tower',
                    'B'  => 'flat',
                    'C'  => 'vehicle_type',
                    'D'  => 'vehicle_no',
                    'E'  => 'parking_slot',
                    'F'  => 'token_no',
                    'G'  => 'is_electric',
                );

                //load dataSave with data in db columns
                foreach ($columnMap as $excelCol => $colMKey) {
                    $dataSave[$colMKey] = isset($row[$excelCol]) ? $row[$excelCol] : "";
                }
                $dataRowResponse = $dataSave;
                $dataSave = array_map('trim', $dataSave);

                if (empty($rowErrorArr)) {

                    if($dataSave['tower'] != "" && $dataSave['tower'] != NULL){
                        if(!isset($towerArr[$dataSave['tower']])){
                            array_push($errorRowArr[102], $rowNumber);
                            array_push($rowErrorArr, 102);
                        }
                    } else {
                        array_push($errorRowArr[101], $rowNumber);
                        array_push($rowErrorArr, 101);
                    }

                    if($dataSave['flat'] != "" && $dataSave['flat'] != NULL){
                        $towerClubIndex = $dataSave['tower']."|".$dataSave['flat'];
                        if(!isset($flatArr[$towerClubIndex])){
                            array_push($errorRowArr[202], $rowNumber);
                            array_push($rowErrorArr, 202);
                        }else if(!isset($ownershipFlatArr[$towerClubIndex])){
                            array_push($errorRowArr[203], $rowNumber);
                            array_push($rowErrorArr, 203);
                        }else {
                            $dataSave['ownership_flat_id'] = $ownershipFlatArr[$towerClubIndex]['ownership_flat_id'];
                            $dataSave['flat_id'] = $ownershipFlatArr[$towerClubIndex]['flat_id'];
                        }
                    } else {
                        array_push($errorRowArr[201], $rowNumber);
                        array_push($rowErrorArr, 201);
                    }

                    if ($dataSave['vehicle_type'] != "" && $dataSave['vehicle_type'] != NULL) {
                        
                        // if($vehicleData[strtolower($dataSave['vehicle_type'])]){
                        if(!array_search($dataSave['vehicle_type'],$vehicleData)){
                            array_push($errorRowArr[302], $rowNumber);
                            array_push($rowErrorArr, 302);
                        }else{
                            $dataSave['vehicle_type'] = array_search($dataSave['vehicle_type'],$vehicleData);
                        }
                    } else {
                        array_push($errorRowArr[301], $rowNumber);
                        array_push($rowErrorArr, 301);
                    }

                    
                    if($dataSave['vehicle_no'] == "" && $dataSave['vehicle_no'] == NULL){
                        array_push($errorRowArr[401], $rowNumber);
                        array_push($rowErrorArr, 401);
                    }

                    if ($dataSave['parking_slot'] != "" && $dataSave['parking_slot'] != NULL) {
                        // if(!empty($slotData)){
                        //     foreach ($slotData as $fKey => $sValue) {
                        //         if($dataSave['parking_slot'] == $sValue['number']){
                        //             $dataSave['parking_slot_id'] = $sValue['parking_slot_id'];
                        //             break;
                        //         }
                        //     }

                        //     if(!isset($dataSave['parking_slot_id'])){
                        //         array_push($errorRowArr[502], $rowNumber);
                        //         array_push($rowErrorArr, 502);
                        //     }
                        // }

                        if(isset($slotArr[$dataSave['parking_slot']])){
                            if(isset($slotFlatArr[$dataSave['flat_id']][$dataSave['parking_slot']])){
                                if($slotFlatArr[$dataSave['flat_id']][$dataSave['parking_slot']]['vehicle_type'] == $dataSave['vehicle_type']){
                                    if(!isset($occupiedParkingDataArr[$dataSave['flat_id']][$dataSave['parking_slot']])){
                                        $dataSave['parking_slot_id'] = $slotArr[$dataSave['parking_slot']]['parking_slot_id'];
                                    }else{
                                        array_push($errorRowArr[505], $rowNumber);
                                        array_push($rowErrorArr,505);
                                    }
                                }else{
                                    array_push($errorRowArr[504], $rowNumber);
                                    array_push($rowErrorArr,504);
                                }
                            }else{
                                array_push($errorRowArr[503], $rowNumber);
                                array_push($rowErrorArr,503);
                            }
                        }else{
                            array_push($errorRowArr[502], $rowNumber);
                            array_push($rowErrorArr, 502);
                        }

                    }else{
                        array_push($errorRowArr[501], $rowNumber);
                        array_push($rowErrorArr, 501);
                    }

                    if ($dataSave['is_electric'] != "" && $dataSave['is_electric'] != NULL) {

                        if(strtolower($dataSave['is_electric']) != 'y' && strtolower($dataSave['is_electric']) != 'n'){
                            array_push($errorRowArr[701], $rowNumber);
                            array_push($rowErrorArr, 701);
                        }else{
                            $dataSave['is_electric'] = strtolower($dataSave['is_electric']) == 'y' ? 1 : 0;
                        }
                    }

                }

                if(empty($rowErrorArr)){
                    $successEntries++;
                    $dataSaveBatch[] = $dataSave;
                    $occupiedParkingDataArr[$dataSave['flat_id']][$dataSave['parking_slot']] = array(
                        'parking_slot_id' => $dataSave['parking_slot_id'],
                        'number' => $dataSave['parking_slot'],
                        'flat_id' => $dataSave['flat_id'],
                        'vehicle_type' => $dataSave['vehicle_type'],
                    );
                }else{

                    $errorPrintExcel = array();
                    foreach ($rowErrorArr as $eachError){
                        $errorPrintExcel[] = $customErrors[$eachError];
                    }
                    $errorPrintExcel = implode("\n\n", $errorPrintExcel);
                    $dataRowResponse['remarks'] = $errorPrintExcel;
                    $dataResponse[] = $dataRowResponse;
                    $failedEntries++;
                }

            }
            // printArray($dataResponse);
            // printArray($dataSaveBatch);
            // printArray($occupiedParkingDataArr,1);

            $reponsePath = $dirAbsPath . $filePrefix . '_RESPONSE.csv';
            $reponseRelativePath = $dirRelPath . $filePrefix . '_RESPONSE.csv';

            $csvFileName = $dirAbsPath . $filePrefix . '.csv'; 
            $zipFileName = $dirRelPath . $filePrefix . '.zip'; 
            $csvResponseFileName = $dirAbsPath . $filePrefix . '_RESPONSE.csv'; 
            $zipResponseFileName = $dirRelPath . $filePrefix . '_RESPONSE.zip';
            
            if(MAKE_ZIP){
                $zipFileName = $dirRelPath . $filePrefix . '.zip';
                $zipResponseFileName = $dirRelPath . $filePrefix . '_RESPONSE.zip';
            } else {
                $zipFileName = $dirRelPath . $filePrefix . '.csv';
                $zipResponseFileName = $dirRelPath . $filePrefix . '_RESPONSE.csv';
            }

            $errorMessageDb = '';
            if (!$this->dt_ci_common->checkError($errorRowArr)) {
                $response['result'] = "data_error";
                $errorMessage = "<a class='alert-link' href='javascript:void(0)'>There was an error while uploading file!</a><a href='" . base_url($zipResponseFileName) . "' class='pull-xs-right btn btn-danger' style='color: white;' target='_blank'>Download Response File</a><br></b>";

                foreach ($errorRowArr as $key => $value) {
                    if (count($value) > 0) {
                        if (SHOW_UPLOAD_ERROR) {
                            $errorMessage .= '<a href="javascript:void(0)">' . $customErrors[$key] . '</a> in <a class="alert-link" href="javascript:void(0)">ROW# ' . implode(", ", $value) . "</a><br><br>";
                        }
                    }
                }
                $response['errorMessage'] = $errorMessage;
            } else {
                $response['result'] = $errorMessageDb = "ok";
            }

            $emergencyContactArr = array();
            if (!empty($dataSaveBatch)) {
                foreach ($dataSaveBatch as $dataSaveElement) {
                    $emergencyContactArr[] = array(
                        'ownership_flat_parking_id' => '',
                        'ownership_flat_id' => $dataSaveElement['ownership_flat_id'],
                        'type' => 'ownership_flat',
                        'type_id' => $dataSaveElement['ownership_flat_id'],
                        'vehicle_type' => $dataSaveElement['vehicle_type'],
                        'parking_slot_id' => $dataSaveElement['parking_slot_id'],
                        'vehicle_no' => $dataSaveElement['vehicle_no'],
                        'token_no' => $dataSaveElement['token_no'],
                        'is_electric' => $dataSaveElement['is_electric'],
                        'created_by' => $userId,
                        'updated_by' => $userId,
                        'created_at' => date("Y-m-d H:i:s"),
                        'updated_at' => date("Y-m-d H:i:s"),
                    );
                }
            }

            if (isset($emergencyContactArr) && !empty($emergencyContactArr)) {
                $this->ownershipFlatModel->insertBulkUpload($emergencyContactArr,'tbl_ownership_flat_parking');
            }

            $this->ownershipFlatModel->updateOwnershipFlatParkingId();

            $this->dt_ci_common->printResponseCsv($reponsePath,$dataResponse);

            $fileArray = array(
                'file' => $dirAbsPath . $filePrefix . '.csv',
                'response_file' => $reponsePath,
            );

            createZipFromFile($fileArray);

            $fileDbResponse = array(
                "text" => $errorMessageDb,
                "success" => $successEntries,
                "failed" => $failedEntries,
                "duplicates" => 0,
            );

            $fileUploadData = array(
                "file_type" => $masterType,
                "filepath" => $zipFileName,
                "user_id" => $userId,
                "start_time" => $startTime,
                "end_time" => date('Y-m-d H:i:s'),
                "response_path" => $zipResponseFileName,
                "response" => json_encode($fileDbResponse),
                'society_id' => $this->session->get('society_id'),
                "auto_upload" => !is_array($file) && $file != "" ? 1 : 0,
            );

            $this->fileUploadModel->saveData($fileUploadData);
        }

        if (!$return) {
            echo json_encode($response);
        } else {
            if (isset($fileUploadData)) $response['file_upload_data'] = $fileUploadData;
            return $response;
        }
    }
}