<?php
if (!function_exists('companyPdfHeader')) {
	function companyPdfHeader($companyData)
	{
		$companyName = '';
		$companyTaxId = '';
		$companyAddress = '';
		$companyEmail = '';
		$companyPhone = '';
		$companyHeader = '';
		$documentTitle = '';
		if(isset($companyData['document_title'])){
			$documentTitle = $companyData['document_title'];
		}
		if(isset($companyData['company_name'])){
			$companyName = $companyData['company_name'];
		}
		if(isset($companyData['gst_no'])){
			$companyTaxId = $companyData['gst_no'];
		}
		if(isset($companyData['address'])){
			$companyAddress = $companyData['address'];
		}
		if(isset($companyData['email'])){
			$companyEmail = $companyData['email'];
		}
		if(isset($companyData['mobile_no'])){
			$companyPhone = $companyData['mobile_no'];
		}
		if(isset($companyData['company_logo']) && file_exists(COMPANY_LOGO_PATH.$companyData['company_logo'])){
			$companyHeader = site_url().COMPANY_LOGO_PATH.$companyData['company_logo'];
		}

		$header = '<table class="table" width="100%">
                    <tbody>
                    <tr>';
		if($companyHeader != '') {
			$header .= '<td width = "20%"><img src = "'.$companyHeader.'" style = "width:150px;height:150px" ></td>';
		} else {
			$header .= '<td width = "20%"></td>';
		}

		$header .= '<td width="80%" align="right" class="text-right"><p style="font-size: 18px;font-weight: bold">'.$documentTitle.'</p><br>';

		$header .= '<p style="font-size: 14px;margin-top: 5px!important;font-weight: bold">'.$companyName.'</p>';

		if($companyAddress != ''){
			$header .= '<p style="font-size: 10px">'.$companyAddress.'</p>';
		}

		if($companyTaxId != ''){
			$header .= '<p style="font-size: 10px">GSTIN NO - '.$companyTaxId.'</p>';
		}

		if($companyEmail != ''){
			$header .= '<p style="font-size: 10px">'.$companyEmail.'</p>';
		}

		if($companyPhone != ''){
			$header .= '<p style="font-size: 10px">'.$companyPhone.'</p>';
		}

		$header .= '</td></tr>';
//		$header .= '</td><td width="20%"></td></tr>';
		$header .= '</tbody></table>';
		$header .= '<table class="table"><tbody>';
//		$header .= '<tr>
//                        <td width="20%"></td>
//                        <td width="60%" align="center" class="text-center"><strong style="text-decoration: underline;font-size: 14px">'.$documentTitle.'</strong></td>
//                        <td width="20%"></td>
//                    </tr>';
		$header .= '</tbody></table>';
		return $header;
	}
}

if (!function_exists('pdfFooter')) {
	function pdfFooter($signature = 0,$signatureDetails = array())
	{
		$footer = '';
		$documentNumber = '';
		$documentDate = '';
		//$companyData = isset($signatureDetails['company_data']) ? $signatureDetails['company_data'] : "";
		if(isset($signatureDetails['document_number']) && $signatureDetails['document_number'] != ''){
			$documentNumber = $signatureDetails['document_number'];
		}
		if(isset($signatureDetails['document_date']) && $signatureDetails['document_date'] != ''){
			$documentDate = $signatureDetails['document_date'];
		}
		// if(isset($companyData['company_logo']) && file_exists(COMPANY_LOGO_PATH.$companyData['company_logo'])){
		// 	$companyFooter = site_url().COMPANY_LOGO_PATH.$companyData['company_logo'];
		// }
		if($signature == 1){
			$footer .= '<table class="table">
                        <tbody>
                        <tr>
                        <td class="text-center">';
			if (isset($signatureDetails['created_by']) && $signatureDetails['created_by'] != "") {
				$footer .= $signatureDetails['created_by'];
			} else {
				$footer .= "<p class='text-center'>&nbsp;</p>";
			}
			$footer .= '<hr>
                        <strong>'.lang("CommonMessage.common_created_by").'</strong>
                        </td>';

//			$footer .= '<td class="text-center">';
//			if (isset($signatureDetails['approved_by']) && $signatureDetails['approved_by'] != " ") {
//				$footer .= $signatureDetails['approved_by'];
//			} else {
//				$footer .= "<p class='text-center'>&nbsp;</p>";
//			}
//			$footer .= '<hr>
//                        <strong>'.lang("common_approved_by").'</strong>
//                        </td>';

			$footer .= '<td class="text-center">';
			$footer .= "<p class='text-center'>&nbsp;</p>";
			$footer .= '<hr>
                        <strong>'.lang("CommonMessage.common_owner_sign").'</strong>
                        </td>';

			$footer .= '</tr>
                        </tbody>
                        </table>';

		}
		$footer .= '<table class="table">
                    <tbody>';

		$footer .= '<tr>';
		if($signature == 1) {
			$footer .= '<td class="text-center">Page No {PAGENO} of {nbpg}- ' . $documentNumber . ' - ' . $documentDate . '</td>';
		} else {
			$footer .= '<td class="text-center">Page No {PAGENO} of {nbpg} </td>';
		}
		$footer .= '</tr>';

		$footer .= '</tbody>
                    </table>';

		return $footer;
	}
}

if (!function_exists('pdfVoucherFooter')) {
	function pdfVoucherFooter($signature = 0, $signatureDetails = array())
	{
		$documentNumber = isset($signatureDetails['document_number']) ? $signatureDetails['document_number'] : '';
		$documentDate = isset($signatureDetails['document_date']) ? $signatureDetails['document_date'] : '';

		// Signature fields: prefer explicit keys, fallback to older keys
		$passedBy = isset($signatureDetails['passed_by']) ? $signatureDetails['passed_by'] : '';
		$authorized = isset($signatureDetails['authorized']) ? $signatureDetails['authorized'] : '';
		$receiver = isset($signatureDetails['receiver']) ? $signatureDetails['receiver'] : '';

		// Inline CSS for footer (no external CSS dependency)
		$style = '
		<style>
			.pdf-footer-table { width:100%; border-collapse:collapse; border:0; font-size:10px; }
			.pdf-footer-table td { border:0; padding:6px 8px; vertical-align:bottom; text-align:center; }
			.signature-cell { padding-top:4px; vertical-align:bottom; }
			.signature-line { display:block; margin:14px auto 4px; border-top:1px solid #000; width:80%; height:1px; }
			.footer-meta { font-size:9px; text-align:center; padding-top:4px; }
		</style>
		';
		$style = '';

		$footer = $style;

		// Signature area (only when $signature == 1)
		if ($signature == 1) {
			$footer .= '<table class="pdf-footer-table" cellpadding="0" cellspacing="0">';
			$footer .= '<tr>';
			// Passed By
			$footer .= '<td width="33%" class="signature-cell">';
			$footer .= '<strong>' . (!empty($passedBy) ? htmlspecialchars($passedBy) : '&nbsp;') . '</strong>';
			$footer .= '<span class="signature-line"></span>';
			$footer .= '<div>' . htmlspecialchars(lang("CommonMessage.common_passed_by") ?? 'Passed By') . '</div>';
			$footer .= '</td>';

			// Authorised
			$footer .= '<td width="33%" class="signature-cell">';
			$footer .= '<strong>' . (!empty($authorized) ? htmlspecialchars($authorized) : '&nbsp;') . '</strong>';
			$footer .= '<span class="signature-line"></span>';
			$footer .= '<div>' . htmlspecialchars(lang("CommonMessage.common_authorized") ?? 'Authorized') . '</div>';
			$footer .= '</td>';

			// Receiver
			$footer .= '<td width="33%" class="signature-cell">';
			$footer .= '<strong>' . (!empty($receiver) ? htmlspecialchars($receiver) : '&nbsp;') . '</strong>';
			$footer .= '<span class="signature-line"></span>';
			$footer .= '<div>' . htmlspecialchars(lang("CommonMessage.common_receiver") ?? 'Receiver') . '</div>';
			$footer .= '</td>';

			$footer .= '</tr>';
			$footer .= '</table>';
		}

		// Page number / document info (always show)
		$footer .= '<table class="pdf-footer-table" cellpadding="0" cellspacing="0">';
		$footer .= '<tr>';
		$meta = 'Page No {PAGENO} of {nbpg}';
		if (!empty($documentNumber) || !empty($documentDate)) {
			$meta .= ' - ' . ($documentNumber ?: '') . ($documentNumber && $documentDate ? ' - ' : '') . ($documentDate ?: '');
		}
		$footer .= '<td class="footer-meta">' . htmlspecialchars($meta) . '</td>';
		$footer .= '</tr>';
		$footer .= '</table>';

		return $footer;
	}
}

?>
