<?php

namespace App\Filters;



use CodeIgniter\Filters\FilterInterface;

use CodeIgniter\HTTP\RequestInterface;

use CodeIgniter\HTTP\ResponseInterface;

class LoginFilter implements FilterInterface

{

    public function before(RequestInterface $request, $arguments = null)

    {
     

        $ionAuth    = new \App\Libraries\IonAuth();

        $ionAuthModel =  new \App\Models\IonAuthModel();

        $session       = \Config\Services::session();

        // $userId = $ionAuth->getUserId();

        // if(!$ionAuth->loggedIn()) {

        //     return redirect()->to('Admin/Auth/login');

        // }

        // $currentPath = strtolower(trim($request->getUri()->getPath(), '/'));

        $currentPath = $request->getPath();
        $allowedPaths = ['Admin/Auth/login', 'SuperAdmin'];

        if (in_array($currentPath, $allowedPaths)) {
            return; // allow login pages
        }



        if (!$ionAuth->loggedIn()) {
            if (str_contains($currentPath, 'SuperAdmin')) {
                return redirect()->to('/SuperAdmin');
            } else {
                return redirect()->to('/Admin/Auth/login');
            }
        }

    }



    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null)

    {

        // Do something here

    }

}

?>