<?php
namespace App\Filters;

use CodeIgniter\Filters\FilterInterface;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Firebase\JWT\JWT;
use Firebase\JWT\Key;
class AuthFilter implements FilterInterface
{
    public function before(RequestInterface $request, $arguments = null)
    {
        $key = getenv('JWT_SECRET');
        $header = $request->getHeader("Authorization");
        $token = null;
        // $apiUserId = $request->getVar('user_id');
        $apiUserId = $request->getVar('user_society_id');
        $ionAuthModel = new \App\Models\IonAuthModel();
        // $getUserData = $ionAuthModel->getUserData(array('user_id' => $apiUserId));
        $getUserData = $ionAuthModel->userSociety(array('user_society_id' => $apiUserId));

        // extract the token from the header
        if(!empty($header)) {
            if (preg_match('/Bearer\s(\S+)/', $header, $matches)) {
                $token = $matches[1];
            }
        }

//        echo "DSdsd";
//        echo $token;
//        die();
        // check if token is null or empty
        if(is_null($token) || empty($token)) {
            $response = service('response');
            //$response->setBody('Access denied');
            //$response->setStatusCode(401);
            //return $response;
            $data = [
                'status'  => false,
                'message' => "Access denied",
                'data' => [],
                "response_code" => 401
            ];
            $response->setStatusCode(401);
            return $response->setJSON($data);
        }

        // if($getUserData['jwt_token'] != $token) {
        //     $response = service('response');
        //     //$response->setBody('Access denied');
        //     //$response->setStatusCode(401);
        //     //return $response;
        //     $data = [
        //         'status'  => false,
        //         'message' => "Access denied",
        //         'data' => [],
        //         "response_code" => 401
        //     ];
        //     $response->setStatusCode(401);
        //     return $response->setJSON($data);
        // }
        try {
            // $decoded = JWT::decode($token, $key, array("HS256"));
            $decoded = JWT::decode($token, new Key($key, 'HS256'));
            // $apiUserId = $request->getVar('user_id');
            $apiUserId = $request->getVar('user_society_id');

            $tokenDecodeData = json_decode(json_encode($decoded), true);
            if(isset($apiUserId) && !empty($apiUserId)){
                $tokenUserId = isset($tokenDecodeData['user_id']) ? $tokenDecodeData['user_id']: 0;
                if($apiUserId != $tokenUserId){
                    $response = service('response');
                    $data = [
                        'status'  => false,
                        'message' => "Invalid Login User Id",
                        'data' => [],
                        "response_code" => 401
                    ];
                    $response->setStatusCode(401);
                    return $response->setJSON($data);
                }

                $ionAuthModel = new \App\Models\IonAuthModel();
                $getUserData = $ionAuthModel->userSociety(array('user_society_id' => $apiUserId));
                if(empty($getUserData)){
                    $response = service('response');
                    $data = [
                        'status'  => false,
                        'message' => "Login User Not Found",
                        'data' => [],
                        "response_code" => 401
                    ];
                    $response->setStatusCode(401);
                    return $response->setJSON($data);
                }
            }
        } catch (\Exception $ex) {
            $response = service('response');
            //$response->setBody('Access denied');
            //$response->setStatusCode(401);
            //return $response;
            $data = [
                'status'  => false,
                'message' => "Access denied",
                'data' => [],
                "response_code" => 401
            ];
            $response->setStatusCode(401);
            return $response->setJSON($data);
        }
    }

    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null)
    {
        // Do something here
    }
}

?>