<?php
namespace App\Controllers\Api;

use App\Libraries\Dt_mpdf;
use CodeIgniter\RESTful\ResourceController;
use App\Models;
use Firebase\JWT\JWT;
use Firebase\JWT\Key;
use DateTime;
Helper("Dt_ci_pdf_helper.php");

class ManagerApi extends ResourceController
{
    public function __construct()
    {
        helper('Dt_ci_site_helper');
        $this->validation = \Config\Services::validation();
        $this->startRtime = microtime(TRUE);
        $this->db = \Config\Database::connect();
        $this->generatorModel = new Models\GeneratorModel();
        $this->resourceModel = new Models\ResourceModel();
        $this->organicWasteRecordModel = new Models\OrganicWasteRecordModel();
        $this->menPowerAttendanceModel = new Models\MenPowerAttendanceModel();
        $this->generatorReadingModel = new Models\GeneratorReadingModel();
        $this->commonWebserviceModel = new Models\CommonWebServiceModel();
        $this->waterMeterReadingModel = new Models\WaterMeterReadingModel();
        $this->waterTankModel = new Models\WaterTankModel();
        $this->ownershipFlatModel = new Models\OwnershipFlatModel();
        $this->societyModel = new Models\SocietyModel();
        $this->pollModel = new Models\PollModel();
        $this->resourceTypeModel = new Models\ResourceTypeModel();
        $this->managementCommitteeModel = new Models\ManagementCommitteeModel();
    }

    public function __destruct()
    {
        // Get the current timestamp
        $this->endRtime = microtime(TRUE);
        // Log the loading time to the log table
        if (REST_ENABLE_LOGGING == TRUE) {
            $this->logAccessTime();
        }
    }

    public function addEditPoll()
    {
        $dt_ci_file_upload = new \App\Libraries\Dt_ci_file_upload();
        $pollId = $this->request->getVar('poll_id');
        $startDate = $this->request->getVar('start_date');
        $endDate = $this->request->getVar('end_date');
        $pollType = $this->request->getVar('poll_type');
        $pollTitle = $this->request->getVar('poll_title');
        $pollOptionData = $this->request->getVar('poll_option_data');
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $userId = $this->request->getVar('user_id');

        $this->validation->setRule('start_date', lang('CommonWebService.start_date'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('end_date', lang('CommonWebService.end_date'), 'required');
        $this->validation->setRule('poll_title', lang('CommonWebService.poll_title'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');

        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {
            if (strtotime($startDate) > strtotime($endDate)){
                return $this->response(array(
                    'status' => FALSE,
                    'message' => lang('Poll.poll_start_date_to_end_date_message'),
                    'data' => null,
                    'response_code' => 400,
                ), 400);
            }
            $pollOptionDataArray = json_decode($pollOptionData, true);
            $pollArray = array(
                'poll_id' => $pollId,
                'poll_title' => $pollTitle,
                'poll_type' => $pollType,
                'society_id' => $societyId,
            );
            if (!empty($startDate)) {
                $pollArray['start_date'] = DMYToYMD($startDate);
            }
            if (!empty($endDate)) {
                $pollArray['end_date'] = DMYToYMD($endDate);
            }
            $extraData = array();
            $extraObj['api_user_id'] = $userSocietyId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $pollData = $this->commonWebserviceModel->insertUpdateRecord($pollArray, 'poll_id', 'tbl_poll', 1, '', array(), $extraData);
            $lastPollId = $pollData['lastInsertedId'];

            if(!empty($pollOptionDataArray) && is_array($pollOptionDataArray)){
                $pollOptionArray = array();
                foreach ($pollOptionDataArray as $pollOptionElement) {
                    $pollOptionArray[] = array(
                        'poll_option_id' => '',
                        'poll_id' => $lastPollId,
                        'poll_option' => $pollOptionElement['poll_option'],
                        'sort_order' => $pollOptionElement['sort_order'],
                        'created_by' => $userSocietyId,
                        'updated_by' => $userSocietyId,
                        'created_at' => date("Y-m-d H:i:s"),
                        'updated_at' => date("Y-m-d H:i:s"),
                    );
                }
                if(!empty($pollOptionArray)){
                    $this->commonWebserviceModel->batchInsert($pollOptionArray, 'tbl_poll_option');
                }
            }

            $pollInsertData = $this->pollModel->getPollData(array(
                'is_multiple' => 1,
                'poll_id' => $lastPollId,
                'society_id' => $societyId,
            ));

            $pollOptionDataWise = array();
            $pollIdArray = array();
            if (!empty($pollInsertData)) {
                foreach ($pollInsertData as $pollElement) {
                    $pollIdArray[] = $pollElement['poll_id'];
                }
                if (!empty($pollIdArray)) {
                    $pollOptionData = $this->pollModel->getPollOptionData(array(
                        "poll_id" => $pollIdArray,
                        "is_multiple" => 1
                    ));
                    if (!empty($pollOptionData)) {
                        foreach ($pollOptionData as $pollOptionElement) {
                            $pollOptionDataWise[$pollOptionElement['poll_id']][] = $pollOptionElement;
                        }
                    }
                }
            }
            if (!empty($pollInsertData)) {
                foreach ($pollInsertData as $pKey => $poll) {
                    $pollInsertData[$pKey]["start_date_display"] = isValidDate($poll['start_date']) ? date('d M Y', strtotime($poll["start_date"])) : "";
                    $pollInsertData[$pKey]["end_date_display"] = isValidDate($poll['end_date']) ? date('d M Y', strtotime($poll["end_date"])) : "";
                    $pollInsertData[$pKey]['created_at'] = YMDToDMY($poll["created_at"], true);
                    $pollInsertData[$pKey]['updated_at'] = YMDToDMY($poll["updated_at"], true);
                    $pollInsertData[$pKey]['created_at_display'] = time_elapsed_string($poll['created_at']);
                    $pollInsertData[$pKey]['updated_at_display'] = time_elapsed_string($poll['updated_at']);
                    $pollInsertData[$pKey]['poll_option_data'] = array_key_exists($poll['poll_id'], $pollOptionDataWise) ? $pollOptionDataWise[$poll['poll_id']] : array();
                }
            }
            $memberIdArray = array();
            $userSocietyIdArray = array();
            $customerDataArray = array();
            $batchNotificationDataArray = array();
            $sendNotificationDataArray = array();
            $notificationMergeArray = array();
            $notificationArray = array(
                'notification_title' => 'New Poll Launched',
                'description' => 'A new poll on '.$pollTitle.' has been launched. Your input matters! Please cast your vote through the app before '.$endDate.'.',
            );
            $deviceIdArray = array();
            $iosDeviceIdArray = array();
            $customerData['title_name'] = isset($notificationArray['notification_title']) ? $notificationArray['notification_title'] : "";
            $customerData['description'] = isset($notificationArray['description']) ? $notificationArray['description'] : "";
            $resourceTypeData = $this->resourceTypeModel->getResourceTypeData(array(
                'resource_type_name' => RESOURCE_TYPE_MEMBER,
                'society_id' => $societyId,
            ));
            if($pollType == 'all_member'){
                $userType = MEMBER_APP;
                $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    'society_id' => $societyId,
                    'is_active' => 1,
                    'is_multiple' => 1
                ));
                if(!empty($ownershipFlatMemberData)){
                    foreach ($ownershipFlatMemberData as $ownershipFlatMember) {
                        $memberIdArray[] = $ownershipFlatMember['member_id'];
                    }
                }
                if(!empty($memberIdArray)){
                    $userSocietyData = $this->commonWebserviceModel->getUserSocietyData(array(
                        "type_id" => $memberIdArray,
                        "resource_type_id" => $resourceTypeData['resource_type_id'],
                        'society_id' => $societyId,
                        'is_multiple' => 1
                    ));
                    if(!empty($userSocietyData)){
                        foreach ($userSocietyData as $userElement) {
                            $userSocietyIdArray[] = $userElement['user_society_id'];
                        }
                    }
                }
            }
            if($pollType == 'committee'){
                $userType = MEMBER_APP;
                $managementCommitteeData = $this->managementCommitteeModel->getManagementCommitteeData(array(
                    'society_id' => $societyId,
                    'is_active' => 1,
                    'is_api' => 1,
                    'is_multiple' => 1
                ));
                if(!empty($managementCommitteeData)){
                    foreach($managementCommitteeData as $managementCommitteeElement){
                        $ownershipFlatMemberIdArray[] = $managementCommitteeElement['member_id'];
                    }
                }
                if(!empty($ownershipFlatMemberIdArray)){
                    $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                        'ownership_flat_member_id' => $ownershipFlatMemberIdArray,
                        'is_show_all_member' => 1,
                        'is_multiple' => 1,
                        'is_active' => 1
                    ));
                    if(!empty($ownershipFlatMemberData)){
                        foreach ($ownershipFlatMemberData as $ownershipFlatMember) {
                            $memberIdArray[] = $ownershipFlatMember['member_id'];
                        }
                    }
                    $userSocietyCommitteeData = $this->commonWebserviceModel->getUserSocietyData(array(
                        'society_id' => $societyId,
                        'resource_type_id' => $resourceTypeData['resource_type_id'],
                        'type_id' => $memberIdArray,
                        'user_id_not' => $userId,
                        'is_multiple' => 1
                    ));
                    if (!empty($userSocietyCommitteeData)) {
                        foreach ($userSocietyCommitteeData as $userSocietyCommitteeElement) {
                            $userSocietyIdArray[] = isset($userSocietyCommitteeElement['user_society_id']) ? $userSocietyCommitteeElement['user_society_id'] : 0;
                        }
                    }
                }
            }
            if($pollType == 'manager'){
                $userType = MANAGER_APP;
                $resourceTypeManagerData = $this->resourceTypeModel->getResourceTypeData(array(
                    'resource_type_name' => RESOURCE_TYPE_MANAGER,
                    'society_id' => $societyId,
                ));
                $userManagerData = $this->commonWebserviceModel->getUserSocietyData(array(
                    'society_id' => $societyId,
                    'resource_type_id' =>  $resourceTypeManagerData['resource_type_id'],
                    'user_id_not' => $userId,
                    'is_active' => 1,
                    'is_multiple' => 1
                ));
                if (!empty($userManagerData)) {
                    foreach ($userManagerData as $userManagerCommittee) {
                        $userSocietyIdArray[] = isset($userManagerCommittee['user_society_id']) ? $userManagerCommittee['user_society_id'] : 0;
                    }
                }
            }
            if(!empty($userSocietyIdArray)){
                $userDeviceArray = $this->commonWebserviceModel->deviceData(array(
                    "user_society_id" => $userSocietyIdArray,
                    'user_type' => $userType,
                    "is_latest" => 1,
                    "is_multiple" => 1,
                ));
                if(!empty($userDeviceArray)){
                    foreach($userDeviceArray as $userDevice){
                        $notificationOtherArray = array(
                            'notification_id' => '',
                            'society_id' => $societyId,
                            'notification_date' => TODAY_DATE_YMD,
                            'notification_for' => (isset($userDevice['device_type'])) ? strtolower($userDevice['device_type']) : "",
                            'type' => 'poll',
                            'type_id' => $lastPollId,
                            // 'module' => 'poll',
                            'created_by' => $userId,
                            'updated_by' => $userId,
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                        $notificationOtherArray['send_for_notification'] = 'manager';
                        $notificationOtherArray['send_for_notification_id'] = $userId;
                        $notificationOtherArray['receive_for_notification'] = $userDevice['user_type'];
                        $notificationOtherArray['receive_for_notification_id'] = $userDevice['user_type_id'];
                        if(!empty($notificationArray)){
                            $notificationMergeArray = array_merge($notificationArray,$notificationOtherArray);
                            $extraDataJsonArray = $notificationMergeArray;
                            $extraDataJsonArray['module'] = 'poll';
                            $extraDataJsonArray['status'] = 'poll';
                            $extraDatajson = json_encode($extraDataJsonArray);
                            $notificationMergeArray['extra_data'] = $extraDatajson;
                            $customerData['extra_data'] = $extraDatajson;
                            $customerData['app_url'] = MEMBER_URL .'poll/current';
                            //send notification data
                            $deviceToken = $userDevice['one_signal_id'];
                            $deviceId = $userDevice['device_id'];
                            $batchNotificationDataArray[] = $notificationMergeArray;

                            $sendNotificationDataArray[] = array(
                                'notification_title' => 'New Poll Launched',
                                'description' => 'A new poll on '.$pollTitle.' has been launched. Your input matters! Please cast your vote through the app before '.$endDate.'.',
                                'extra_data_json' => $extraDatajson,
                                'app_url' => MEMBER_URL .'poll/current',
                                'notification_for' => (isset($userDevice['device_type'])) ? strtolower($userDevice['device_type']) : "",
                                'device_id' => $userDevice['device_id'],
                                'type' => 'poll',
                            );
                        }
                    }
                }
                if(!empty($batchNotificationDataArray)){
                    $this->ownershipFlatModel->batchInsert($batchNotificationDataArray,'tbl_notification');
                }
                if(!empty($sendNotificationDataArray)){
                    sendNotification($sendNotificationDataArray);
                }
            }
            if (isset($pollId) && !empty($pollId)) {
                if (isset($pollData['success']) && $pollData['success']) {
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.document_updated'), lang('CommonWebService.poll')),
                        'data' => $pollInsertData
                    ), 200);
                } else {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_update'), lang('CommonWebService.poll')),
                        'data' => null
                    ), 404);
                }
            } else {
                if (isset($pollData['success']) && $pollData['success']) {
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.new_created'), lang('CommonWebService.poll')),
                        'data' => $pollInsertData
                    ), 200);
                } else {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_create'), lang('CommonWebService.poll')),
                        'data' => null
                    ), 400);
                }
            }
        }
    }

    public function getVehicleList()
    {
        $appType = $this->request->getVar('app_type');
        $search = $this->request->getVar('search');
        $societyId = $this->request->getVar('society_id');
        $userId = $this->request->getVar('user_id');
        $start = $this->request->getVar('start');
        $type = $this->request->getVar('type');
        $ownershipFlatParkingId = $this->request->getVar('ownership_flat_parking_id');

        
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);

            $filterArray = array(
                'is_show_all_member' => 1,
                'is_active' => 1,
                'is_multiple' => 1,
            );
            $vehicleData = array();
            $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData($filterArray);
            if (!empty($ownershipFlatMemberData)) {
                $type = isset($ownershipFlatMemberData['type']) ? $ownershipFlatMemberData['type'] : '';
                $typeId = isset($ownershipFlatMemberData['type_id']) ? $ownershipFlatMemberData['type_id'] : 0;
                $vehicleData = $this->ownershipFlatModel->getOwnershipFlatParkingData(array(
                    'search' => $search,
                    'type' => $type,
                    'type_id' => $typeId,
                    'start' => $start,
                    'ownership_flat_parking_id' => $ownershipFlatParkingId,
                    'is_multiple' => 1,
                    'is_show_all_parking' => 1
                ));
            }

            if (!empty($vehicleData)) {
                foreach ($vehicleData as $vKey => $vehicle) {
                    $formattedVehicleType = getFunctionKeyValue($vehicle['vehicle_type'], vehicleType());
                    $vehiclePath = site_url('uploads/no_image.png');
                    $thumbnailVehiclePath = site_url('uploads/no_image.png');
                    if ($vehicle['vehicle_image'] != '' && file_exists(VEHICLE_IMAGE_PATH . $vehicle['vehicle_image'])) {
                        $vehiclePath = site_url() . VEHICLE_IMAGE_PATH . $vehicle['vehicle_image'];
                    }

                    if ($vehicle['vehicle_image'] != '' && file_exists(THUMBNAIL_VEHICLE_IMAGE_PATH . $vehicle['vehicle_image'])) {
                        $thumbnailVehiclePath = site_url() . THUMBNAIL_VEHICLE_IMAGE_PATH . $vehicle['vehicle_image'];
                    }
                    $vehicleData[$vKey]['vehicle_image'] = $vehiclePath;
                    $vehicleData[$vKey]['thumbnail_vehicle_image'] = $thumbnailVehiclePath;
                    $vehicleData[$vKey]['vehicle_type_display'] = underscoreToUcWord($vehicle["vehicle_type"]);
                    $vehicleData[$vKey]['vehicle_type'] = $formattedVehicleType;
                }
            }

            if (!empty($vehicleData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.vehicle_listing_successfully'),
                    'data' => $vehicleData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $vehicleData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getGeneratorList()
    {
        $search = $this->request->getVar('search');
        $generatorId = $this->request->getVar('generator_id');
        $societyId = $this->request->getVar('society_id');
        $userId = $this->request->getVar('user_id');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $filterArray = array(
                'is_multiple' => 1,
                'is_active' => 1,
                'search' => $search,
                'generator_id' => $generatorId,
                'society_id' => $societyId,
                'user_id' => $userId,
            );

            $generatorData = $this->generatorModel->getGeneratorData($filterArray);

            if (!empty($generatorData)) {
                foreach ($generatorData as $gKey => $generatorElement) {
                    $formattedReadingType = getFunctionKeyValue($generatorElement['reading_type'], readingType());
                    $generatorData[$gKey]['created_at'] = isValidDate($generatorElement['created_at']) ? YMDToDMY($generatorElement["created_at"], true) : "";
                    $generatorData[$gKey]['updated_at'] = isValidDate($generatorElement['updated_at']) ? YMDToDMY($generatorElement["updated_at"], true) : "";
                    $generatorData[$gKey]['created_at_display'] = time_elapsed_string($generatorElement['created_at']);
                    $generatorData[$gKey]['updated_at_display'] = time_elapsed_string($generatorElement['updated_at']);
                    $generatorData[$gKey]['reading_type_display'] = underscoreToUcWord($generatorElement["reading_type"]);
                    $generatorData[$gKey]['reading_type'] = $formattedReadingType;
                }
            }
            if (!empty($generatorData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.generator_listing_successfully'),
                    'data' => $generatorData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $generatorData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getGeneratorReadingList()
    {
        $search = $this->request->getVar('search');
        $generatorReadingId = $this->request->getVar('generator_reading_id');
        $generatorId = $this->request->getVar('generator_id');
        $societyId = $this->request->getVar('society_id');
        $userId = $this->request->getVar('user_id');
        $start = $this->request->getVar('start');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'is_active' => 1,
                'search' => $search,
                'generator_reading_id' => $generatorReadingId,
                'generator_id' => $generatorId,
                'society_id' => $societyId,
                'user_id' => $userId,
                'start' => $start,
            );
            $generatorReadingData = $this->generatorReadingModel->getGeneratorReadingData($filterArray);
            if (!empty($generatorReadingData)) {
                foreach ($generatorReadingData as $grkey => $generatorReadingElement) {
                    $generatorReadingData[$grkey]['reading_type_display'] = underscoreToUcWord($generatorReadingElement["reading_type"]);
                    if($generatorReadingData[$grkey]["generator_usage_hours"] != ""){
                        $generatorReadingData[$grkey]["generator_usage_hours"] = number_format($generatorReadingElement["generator_usage_hours"], 2, '.', '');
                    } else {
                        $generatorReadingData[$grkey]["generator_usage_hours"] = '-';
                    }
                    $generatorReadingData[$grkey]["generator_start_date_display"] = isValidDate($generatorReadingElement['generator_start_date']) ? date('d F, Y', strtotime($generatorReadingElement["generator_start_date"])) : "";
                    $generatorReadingData[$grkey]["generator_start_time_display"] = isValidDate($generatorReadingElement['generator_start_time']) ? date('h:i A', strtotime($generatorReadingElement["generator_start_time"])) : "";
                    $generatorReadingData[$grkey]["generator_end_time_display"] = isValidDate($generatorReadingElement['generator_end_time']) ? date('h:i A', strtotime($generatorReadingElement["generator_end_time"])) : "";
                    $generatorReadingData[$grkey]["generator_start_date_time"] = isValidDate($generatorReadingElement['generator_start_date']) ? $generatorReadingElement['generator_start_date'] ." ". $generatorReadingElement['generator_start_time']: "";
                    $generatorReadingData[$grkey]["generator_end_date_time"] = isValidDate($generatorReadingElement['generator_start_date']) ? $generatorReadingElement['generator_start_date'] ." ". $generatorReadingElement['generator_end_time']: "";
                }
            }
            if (!empty($generatorReadingData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.generator_reading_listing_successfully'),
                    'data' => $generatorReadingData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $generatorReadingData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function addEditGeneratorReading()
    {
        $this->db->transStart();
        $generatorReadingId = $this->request->getVar('generator_reading_id');
        $generatorId = $this->request->getVar('generator_id');
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $generatorStartDate = $this->request->getVar('generator_start_date');
        $generatorStartTime = $this->request->getVar('generator_start_time');
        $generatorEndTime = $this->request->getVar('generator_end_time');
        $generatorUsageHours = $this->request->getVar('generator_usage_hours');
        $filledLiter = $this->request->getVar('filled_liter');
        $availableLiter = $this->request->getVar('available_liter');
        $userId = $this->request->getVar('user_id');
        $readingType = $this->request->getVar('reading_type');
        $this->validation->setRule('generator_id', lang('GeneratorReading.generator'), 'required');
        $this->validation->setRule('generator_start_date', lang('GeneratorReading.generator_start_date'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');

        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {

            if (strtotime($generatorStartTime) > strtotime($generatorEndTime)){
                return $this->response(array(
                    'status' => true,
                    'response_code' => 200,
                    'message' => lang('GeneratorReading.generator_reading_end_time_message'),
                    'data' => null
                ), 200);
            }


            $hours = '';
            if (!empty($generatorStartTime) && !empty($generatorEndTime)) {

                $startDateTime = $generatorStartDate . ' ' . $generatorStartTime;
                $endDateTime = $generatorStartDate . ' ' . $generatorEndTime;


                $startTimestamp = strtotime($startDateTime);
                $endTimestamp = strtotime($endDateTime);
                $timeDifference = $endTimestamp - $startTimestamp;
                $hours = $timeDifference / 3600;
            }

            $generatorReadingUpdateArray = array();
            $generatorReadingArray = array(
                'generator_reading_id' => $generatorReadingId,
                'generator_id' => $generatorId,
                'society_id' => $societyId,
                'generator_start_date' => DMYToYMD($generatorStartDate),
                'generator_start_time' => $generatorStartTime,
                'generator_end_time' => $generatorEndTime,
                'generator_usage_hours' => $hours,
                'filled_liter' => $filledLiter,
                'available_liter' => $availableLiter,
                'reading_type' => $readingType,
            );
            if (!empty($generatorReadingId)) {
                $generatorReadingUpdateArray = $this->generatorReadingModel->getGeneratorReadingData(array(
                    'generator_reading_id' => $generatorReadingId,
                ));
                $generatorReadingUpdateArray = compareArray($generatorReadingArray, $generatorReadingUpdateArray);
            }
            $extraData = array();
            $extraObj['api_user_id'] = $userSocietyId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $generatorReadingData = $this->commonWebserviceModel->insertUpdateRecord($generatorReadingArray, 'generator_reading_id', 'tbl_generator_reading', 1, '', array(), $extraData, $generatorReadingUpdateArray);
            $lastGeneratorReadingId = $generatorReadingData['lastInsertedId'];

            $generatorReadingFilterArray = array(
                'generator_reading_id' => $lastGeneratorReadingId,
            );
            $generatorReadingInsertData = $this->generatorReadingModel->getGeneratorReadingData($generatorReadingFilterArray);
            if (!empty($generatorReadingInsertData)) {
                $generatorReadingInsertData['reading_type_display'] = underscoreToUcWord($generatorReadingInsertData["reading_type"]);
                if($generatorReadingInsertData["generator_usage_hours"] != ""){
                    $generatorReadingInsertData["generator_usage_hours"] = number_format($generatorReadingInsertData["generator_usage_hours"], 2, '.', '');
                } else {
                    $generatorReadingInsertData["generator_usage_hours"] = '-';
                }
                $generatorReadingInsertData["generator_start_date_display"] = isValidDate($generatorReadingInsertData['generator_start_date']) ? date('d F, Y', strtotime($generatorReadingInsertData["generator_start_date"])) : "";
                $generatorReadingInsertData["generator_start_time_display"] = isValidDate($generatorReadingInsertData['generator_start_time']) ? date('h:i A', strtotime($generatorReadingInsertData["generator_start_time"])) : "";
                $generatorReadingInsertData["generator_end_time_display"] = isValidDate($generatorReadingInsertData['generator_end_time']) ? date('h:i A', strtotime($generatorReadingInsertData["generator_end_time"])) : "";
                $generatorReadingInsertData["generator_start_date_time"] = isValidDate($generatorReadingInsertData['generator_start_date']) ? $generatorReadingInsertData['generator_start_date'] ." ". $generatorReadingInsertData['generator_start_time']: "";
                $generatorReadingInsertData["generator_end_date_time"] = isValidDate($generatorReadingInsertData['generator_start_date']) ? $generatorReadingInsertData['generator_start_date'] ." ". $generatorReadingInsertData['generator_end_time']: "";  
            }
            $transactionStatus = $this->db->transComplete();
            if (isset($generatorReadingId) && !empty($generatorReadingId)) {
                if ((isset($generatorReadingData['success']) && $generatorReadingData['success']) && ($transactionStatus == 1)) {
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.document_updated'), lang('GeneratorReading.generator_reading')),
                        'data' => $generatorReadingInsertData
                    ), 200);
                } else {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_update'), lang('GeneratorReading.generator_reading')),
                        'data' => null
                    ), 404);
                }
            } else {
                if ((isset($generatorReadingData['success']) && $generatorReadingData['success']) && ($transactionStatus == 1)) {
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.new_created'), lang('GeneratorReading.generator_reading')),
                        'data' => $generatorReadingInsertData
                    ), 200);
                } else {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_create'), lang('GeneratorReading.generator_reading')),
                        'data' => null
                    ), 400);
                }
            }
        }
    }


    public function deleteGeneratorReading()
    {
        $userId = $this->request->getVar('user_id');
        $generatorReadingId = $this->request->getVar('generator_reading_id');
        $societyId = $this->request->getVar('society_id');

        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('generator_reading_id', lang('GeneratorReading.generator_reading_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        } else {
            $this->db->transStart();
            $generatorReadingId = ($generatorReadingId != '') ? explode(",", $generatorReadingId) : '';
            $generatorReadingData = $this->generatorReadingModel->deleteRecord($generatorReadingId, $userId,$societyId);
            if ($generatorReadingData) {
                $this->db->transComplete();
                $data = array(
                    'status' => TRUE,
                    'message' => sprintf(lang('CommonMessage.delete_record'), lang('GeneratorReading.generator_reading')),
                    'response_code' => 200,
                    'data' => null,);

                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => False,
                    'message' => sprintf(lang('CommonMessage.error_delete_record'), lang('GeneratorReading.generator_reading')),
                    'response_code' => 404,
                    'data' => null,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getResourceList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $resourceId = $this->request->getVar('resource_id');
        $userId = $this->request->getVar('user_id');
        $societyId = $this->request->getVar('society_id');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'start' => $start,
                'search' => $search,
                'resource_id' => $resourceId,
                'society_id' => $societyId,
            );
            $resourceData = $this->resourceModel->getResourceData($filterArray);
            if (!empty($resourceData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.resource_listing_successfully'),
                    'data' => $resourceData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $resourceData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getMenPowerAttendanceList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $menPowerAttendnaceId = $this->request->getVar('men_power_attendance_id');
        $userId = $this->request->getVar('user_id');
        $societyId = $this->request->getVar('society_id');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => true,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                )
                , 200);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'start' => $start,
                'search' => $search,
                'men_power_attendance_id' => $menPowerAttendnaceId,
                'society_id' => $societyId,
                'is_active' => 1,
            );
            $menPowerAttendanceData = $this->menPowerAttendanceModel->getMenPowerAttendanceData($filterArray);
            if (!empty($menPowerAttendanceData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.men_power_attendance_listing_successfully'),
                    'data' => $menPowerAttendanceData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $menPowerAttendanceData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function addEditMenPowerAttendance()
    {
        $menPowerAttendnaceId = $this->request->getVar('men_power_attendance_id');
        $menPowerAttendnaceDate = $this->request->getVar('men_power_attendance_date');
        $resourceId = $this->request->getVar('resource_id');
        $inTime = $this->request->getVar('in_time');
        $outTime = $this->request->getVar('out_time');
        $societyId = $this->request->getVar('society_id');
        $userId = $this->request->getVar('user_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        
        $this->validation->setRule('men_power_attendance_date', lang('CommonWebService.men_power_attendance_date'), 'required');
        $this->validation->setRule('resource_id', lang('CommonWebService.resource_id'), 'required');
        $this->validation->setRule('in_time', lang('CommonWebService.in_time'), 'required');
        $this->validation->setRule('out_time', lang('CommonWebService.out_time'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {

            if (strtotime($inTime) > strtotime($outTime)){
				return $this->response(array(
                        'status' => false,
                        'response_code' => 400,
                        'message' => lang('MenPowerAttendance.men_power_in_out_time_message'),
                        'data' => null
                    ), 400);
			}

            $menPowerAttendanceUpdateArray = array();
            $menPowerAttendanceArray = array(
                'men_power_attendance_id' => $menPowerAttendnaceId,
                'men_power_attendance_date' => DMYToYMD($menPowerAttendnaceDate),
                'society_id' => $societyId,
                'resource_id' => $resourceId,
                'in_time' => $inTime,
                'out_time' => $outTime,
                'is_active' => 1,
            );
            if (!empty($menPowerAttendnaceId)) {
                $menPowerAttendanceUpdateData = $this->menPowerAttendanceModel->getMenPowerAttendanceData(array(
                    'men_power_attendance_id' => $menPowerAttendnaceId,
                ));
                $menPowerAttendanceUpdateArray = compareArray($menPowerAttendanceArray, $menPowerAttendanceUpdateData);
            }
            $extraData = array();
            //$extraObj['is_api_call'] = 1;
            $extraObj['api_user_id'] = $userSocietyId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $menPowerAttendanceData = $this->commonWebserviceModel->insertUpdateRecord($menPowerAttendanceArray, 'men_power_attendance_id', 'tbl_men_power_attendance', 1, '', array(), $extraData, $menPowerAttendanceUpdateArray);

            $lastMenPowerAttendanceId = $menPowerAttendanceData['lastInsertedId'];
            $menPowerAttendanceFilterArray = array(
                'men_power_attendance_id' => $lastMenPowerAttendanceId,
            );
            $menPowerAttendanceInsertData = $this->menPowerAttendanceModel->getMenPowerAttendanceData($menPowerAttendanceFilterArray);
            
            if (isset($menPowerAttendnaceId) && !empty($menPowerAttendnaceId)) {
                if (isset($menPowerAttendanceData['success']) && $menPowerAttendanceData['success']) {
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.document_updated'), lang('CommonWebService.men_power_attendance')),
                        'data' => $menPowerAttendanceInsertData
                    ), 200);
                } else {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_update'), lang('CommonWebService.men_power_attendance')),
                        'data' => null
                    ), 404);
                }
            } else {
                if (isset($menPowerAttendanceData['success']) && $menPowerAttendanceData['success']) {
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.new_created'), lang('CommonWebService.men_power_attendance')),
                        'data' => $menPowerAttendanceInsertData
                    ), 200);
                } else {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_create'), lang('CommonWebService.men_power_attendance')),
                        'data' => null
                    ), 400);
                }
            }
        }
    }

    public function deleteMenPowerAttendance()
    {
        $userId = $this->request->getVar('user_id');
        $menPowerAttendnaceId = $this->request->getVar('men_power_attendance_id');
        $societyId = $this->request->getVar('society_id');

        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('men_power_attendance_id', lang('CommonWebService.men_power_attendance_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');

        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        } else {
            $this->db->transStart();
            $menPowerAttendnaceId = ($menPowerAttendnaceId != '') ? explode(",", $menPowerAttendnaceId) : '';
            $menPowerAttendanceData = $this->menPowerAttendanceModel->deleteRecord($menPowerAttendnaceId, $userId,$societyId);
            if ($menPowerAttendanceData) {
                $this->db->transComplete();
                $data = array(
                    'status' => TRUE,
                    'message' => sprintf(lang('CommonMessage.delete_record'), lang('CommonWebService.water_meter_reading')),
                    'response_code' => 200,
                    'data' => null,);

                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => False,
                    'message' => sprintf(lang('CommonMessage.error_delete_record'), lang('CommonWebService.water_meter_reading')),
                    'response_code' => 404,
                    'data' => null,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getWaterTankList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $waterTankId = $this->request->getVar('water_tank_id');
        $waterMeterReadingId = $this->request->getVar('water_meter_reading_id');
        $userId = $this->request->getVar('user_id');
        $societyId = $this->request->getVar('society_id');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'start' => $start,
                'search' => $search,
                'water_tank_id' => $waterTankId,
                'water_meter_reading_id' => $waterMeterReadingId,
                'society_id' => $societyId,
                'is_active' => 1,
                'is_api' => 1,
            );
            $waterTankData = $this->waterTankModel->getWaterTankData($filterArray);

            if (!empty($waterTankData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.water_tank_listing_successfully'),
                    'data' => $waterTankData,
                    // 'water_meter_reading_data' => $waterMeterReadingData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $waterTankData,
                    // 'water_meter_reading_data' => $waterMeterReadingData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function addEditWaterMeterReading()
    {
        $waterMeterReadingId = $this->request->getVar('water_meter_reading_id');
        $waterTankId = $this->request->getVar('water_tank_id');
        $readingDateTime = $this->request->getVar('reading_date_time');
        $source = $this->request->getVar('source');
        $remarks = $this->request->getVar('remarks');
        $societyId = $this->request->getVar('society_id');
        $availabilityVolume = $this->request->getVar('availability_volume');
        $supplyVolume = $this->request->getVar('supply_volume');
        $userId = $this->request->getVar('user_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        
        $this->validation->setRule('water_tank_id', lang('CommonWebService.water_tank_id'), 'required');
        $this->validation->setRule('reading_date_time', lang('CommonWebService.reading_date_time'), 'required');
        // $this->validation->setRule('availability_volume', lang('CommonWebService.availability_volume'), 'required');
        // $this->validation->setRule('supply_volume', lang('CommonWebService.supply_volume'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $waterMeterReadingUpdateArray = array();
            $waterMeterReadingArray = array(
                'water_meter_reading_id' => $waterMeterReadingId,
                'water_tank_id' => $waterTankId,
                'society_id' => $societyId,
                'remarks' => $remarks,
                'source' => $source,
                'reading_date_time' => DMYToYMD($readingDateTime, true, true),
                'availability_volume' => $availabilityVolume,
                'supply_volume' => $supplyVolume,
                'is_active' => 1,
            );
            // if (!empty($waterMeterReadingId)) {
            //     $waterMeterReadingUpdateData = $this->waterMeterReadingModel->getWaterMeterReadingData(array(
            //         'water_meter_reading_id' => $waterMeterReadingId,
            //         'is_api_call' => 1,
            //     ));
            //     $waterMeterReadingUpdateArray = compareArray($waterMeterReadingArray, $waterMeterReadingUpdateData);
            // }
            $extraData = array();
            $extraObj['is_api_call'] = 1;
            $extraObj['api_user_id'] = $userSocietyId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $waterMeterReadingData = $this->commonWebserviceModel->insertUpdateRecord($waterMeterReadingArray, 'water_meter_reading_id', 'tbl_water_meter_reading', 1, '', array(), $extraData, $waterMeterReadingUpdateArray);
            $lastWaterMeterReadingId = $waterMeterReadingData['lastInsertedId'];
            $waterMeterReadingFilterArray = array(
                'water_meter_reading_id' => $lastWaterMeterReadingId,
                'is_api_call' => 1,
            );
            $waterMeterReadingInsertData = $this->waterMeterReadingModel->getWaterMeterReadingData($waterMeterReadingFilterArray);
            if (!empty($waterMeterReadingInsertData)) {
                $formattedSource = getFunctionKeyValue($waterMeterReadingInsertData['source'], source());
                $waterMeterReadingInsertData['created_at'] = YMDToDMY($waterMeterReadingInsertData["created_at"], true);
                $waterMeterReadingInsertData['updated_at'] = YMDToDMY($waterMeterReadingInsertData["updated_at"], true);
                $waterMeterReadingInsertData['created_at_display'] = time_elapsed_string($waterMeterReadingInsertData['created_at']);
                $waterMeterReadingInsertData['updated_at_display'] = time_elapsed_string($waterMeterReadingInsertData['updated_at']);
                $waterMeterReadingInsertData["display_reading_date_time"] = YMDToDMY($waterMeterReadingInsertData["reading_date_time"], true);
                $waterMeterReadingInsertData["display_reading_date"] = isValidDate($waterMeterReadingInsertData['reading_date_time']) ? date('d F, Y', strtotime($waterMeterReadingInsertData['reading_date_time'])) : "";;
                $path = site_url('uploads/no_image.png');
                $waterMeterReadingInsertData['source'] = $formattedSource; 
            }
            
            if (isset($waterMeterReadingId) && !empty($waterMeterReadingId)) {
                if (isset($waterMeterReadingData['success']) && $waterMeterReadingData['success']) {
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.document_updated'), lang('CommonWebService.water_meter_reading')),
                        'data' => $waterMeterReadingInsertData
                    ), 200);
                } else {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_update'), lang('CommonWebService.water_meter_reading')),
                        'data' => null
                    ), 404);
                }
            } else {
                if (isset($waterMeterReadingData['success']) && $waterMeterReadingData['success']) {
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.new_created'), lang('CommonWebService.water_meter_reading')),
                        'data' => $waterMeterReadingInsertData
                    ), 200);
                } else {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_create'), lang('CommonWebService.water_meter_reading')),
                        'data' => null
                    ), 400);
                }
            }
        }
    }

    function getWaterMeterReadingList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $waterMeterReadingId = $this->request->getVar('water_meter_reading_id');
        $waterTankId = $this->request->getVar('water_tank_id');
        $societyId = $this->request->getVar('society_id');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'start' => $start,
                'search' => $search,
                'society_id' => $societyId,
                'water_meter_reading_id' => $waterMeterReadingId,
                'water_tank_id' => $waterTankId,
                'is_active' => 1,
                'is_api_call' => 1,
            );
            $waterMeterReadingData = $this->waterMeterReadingModel->getWaterMeterReadingData($filterArray);
            if (!empty($waterMeterReadingData)) {
                foreach ($waterMeterReadingData as $bkey => $waterMeterReading) {
                    $formattedSource = getFunctionKeyValue($waterMeterReading['source'], source());
                    $waterMeterReadingData[$bkey]['created_at'] = YMDToDMY($waterMeterReading["created_at"], true);
                    $waterMeterReadingData[$bkey]['updated_at'] = YMDToDMY($waterMeterReading["updated_at"], true);
                    $waterMeterReadingData[$bkey]['created_at_display'] = time_elapsed_string($waterMeterReading['created_at']);
                    $waterMeterReadingData[$bkey]['updated_at_display'] = time_elapsed_string($waterMeterReading['updated_at']);
                    $waterMeterReadingData[$bkey]["display_reading_date_time"] = YMDToDMY($waterMeterReading["reading_date_time"], true);
                    $waterMeterReadingData[$bkey]["display_reading_date"] = isValidDate($waterMeterReading['reading_date_time']) ? date('d F, Y', strtotime($waterMeterReading['reading_date_time'])) : "";
                    $waterMeterReadingData[$bkey]["display_reading_time"] = isValidDate($waterMeterReading['reading_date_time']) ? date('h:i A', strtotime($waterMeterReading['reading_date_time'])) : "";
                    $path = site_url('uploads/no_image.png');
                    $waterMeterReadingData[$bkey]['source'] = $formattedSource;
                }
            }
            if (!empty($waterMeterReadingData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.water_meter_reading_listing_successfully'),
                    'data' => $waterMeterReadingData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                //return $this->respond($data,200);
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $waterMeterReadingData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                //return $this->respond($data,404);
                return $this->response($data, 404);
            }
        }
    }

    public function deleteWaterMeterReading()
    {
        $userId = $this->request->getVar('user_id');
        $waterMeterReadingId = $this->request->getVar('water_meter_reading_id');
        $societyId = $this->request->getVar('society_id');

        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('water_meter_reading_id', lang('CommonWebService.water_meter_reading_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        } else {
            $this->db->transStart();
            $waterMeterReadingId = ($waterMeterReadingId != '') ? explode(",", $waterMeterReadingId) : '';
            $waterMeterReadingData = $this->waterMeterReadingModel->deleteRecord($waterMeterReadingId, $userId,$societyId);
            if ($waterMeterReadingData) {
                $this->db->transComplete();
                $data = array(
                    'status' => TRUE,
                    'message' => sprintf(lang('CommonMessage.delete_record'), lang('CommonWebService.water_meter_reading')),
                    'response_code' => 200,
                    'data' => null,);

                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => False,
                    'message' => sprintf(lang('CommonMessage.error_delete_record'), lang('CommonWebService.water_meter_reading')),
                    'response_code' => 404,
                    'data' => null,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getOrganicWasteRecordList()
    {
        $start = $this->request->getVar('start');
        // $search = $this->request->getVar('search');
        $organicWasteRecordId = $this->request->getVar('organic_waste_record_id');
        $recordDate = $this->request->getVar('record_date');
        $startDate = $this->request->getVar('start_date');
        $endDate = $this->request->getVar('end_date');
        $userId = $this->request->getVar('user_id');
        $societyId = $this->request->getVar('society_id');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'start' => $start,
                // 'search' => $search,
                'organic_waste_record_id' => $organicWasteRecordId,
                'record_date' => $recordDate,
                'society_id' => $societyId,
                'is_active' => 1,
                'is_api_call' => 1,
            );
            if (!empty($startDate)) {
                $filterArray['start_date'] = DMYToYMD($startDate);
            }
            if (!empty($endDate)) {
                $filterArray['end_date'] = DMYToYMD($endDate);
            }
            $organicWasteRecordData = $this->organicWasteRecordModel->getOrganicWasteRecordData($filterArray);
            if (!empty($organicWasteRecordData)) {
                foreach ($organicWasteRecordData as $bkey => $organicWasteRecord) {
                    $organicWasteRecordData[$bkey]['record_date_display'] = date("d M Y",strtotime($organicWasteRecord["record_date"]));
                    $organicWasteRecordData[$bkey]['created_at'] = YMDToDMY($organicWasteRecord["created_at"], true);
                    $organicWasteRecordData[$bkey]['updated_at'] = YMDToDMY($organicWasteRecord["updated_at"], true);
                    $organicWasteRecordData[$bkey]['total_waste'] = $organicWasteRecord['kitchen_waste'] + $organicWasteRecord['processed_compost'] + $organicWasteRecord['sawdust'];
                    $organicWasteRecordData[$bkey]['total_compost'] = $organicWasteRecord['bacteria'] + $organicWasteRecord['ready_compost'];
                }
            }
            
            if (!empty($organicWasteRecordData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.organic_waste_record_listing_successfully'),
                    'data' => $organicWasteRecordData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $organicWasteRecordData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function addEditOrganicWasteRecord()
    {
        $organicWasteRecordId = $this->request->getVar('organic_waste_record_id');
        $recordDate = $this->request->getVar('record_date');
        $kitchenWaste = $this->request->getVar('kitchen_waste');
        $processedCompost = $this->request->getVar('processed_compost');
        $sawdust = $this->request->getVar('sawdust');
        $bacteria = $this->request->getVar('bacteria');
        $readyCompost = $this->request->getVar('ready_compost');
        $societyId = $this->request->getVar('society_id');
        $userId = $this->request->getVar('user_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        
        $this->validation->setRule('record_date', lang('CommonWebService.record_date'), 'required');
        $this->validation->setRule('kitchen_waste', lang('CommonWebService.kitchen_waste'), 'required');
        $this->validation->setRule('processed_compost', lang('CommonWebService.processed_compost'), 'required');
        $this->validation->setRule('sawdust', lang('CommonWebService.sawdust'), 'required');
        $this->validation->setRule('bacteria', lang('CommonWebService.bacteria'), 'required');
        $this->validation->setRule('ready_compost', lang('CommonWebService.ready_compost'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {

            $existsOrganicWasteRecordData = $this->organicWasteRecordModel->getOrganicWasteRecordData(array(
                'record_date' => $recordDate,
                'is_api_call' => 1,
            ));

            if(!empty($existsOrganicWasteRecordData)){
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => lang("CommonWebService.record_exists"),
                    'data' => null
                ), 404);
            }
            $organicWasteRecordUpdateArray = array();
            $organicWasteRecordArray = array(
                'organic_waste_record_id' => $organicWasteRecordId,
                'record_date' => DMYToYMD($recordDate),
                'kitchen_waste' => $kitchenWaste,
                'processed_compost' => $processedCompost,
                'sawdust' => $sawdust,
                'bacteria' => $bacteria,
                'ready_compost' => $readyCompost,
                'society_id' => $societyId,
            );
            if (!empty($organicWasteRecordId)) {
                $organicWasteRecordUpdateData = $this->organicWasteRecordModel->getOrganicWasteRecordData(array(
                    'organic_waste_record_id' => $organicWasteRecordId,
                    'is_api_call' => 1,
                ));
                $organicWasteRecordUpdateArray = compareArray($organicWasteRecordArray, $organicWasteRecordUpdateData);
            }
            $extraData = array();
            $extraObj['is_api_call'] = 1;
            $extraObj['api_user_id'] = $userSocietyId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $organicWasteRecordData = $this->commonWebserviceModel->insertUpdateRecord($organicWasteRecordArray, 'organic_waste_record_id', 'tbl_organic_waste_record', 1, '', array(), $extraData, $organicWasteRecordUpdateArray);
            $lastOrganicWasteRecordId = $organicWasteRecordData['lastInsertedId'];
            $organicWasteRecordFilterArray = array(
                'organic_waste_record_id' => $organicWasteRecordId,
                'is_api_call' => 1,
            );
            $organicWasteRecordInsertData = $this->organicWasteRecordModel->getOrganicWasteRecordData($organicWasteRecordFilterArray);
            if (!empty($organicWasteRecordInsertData)) {
                $organicWasteRecordInsertData['record_date_display'] = date("d M Y",strtotime($organicWasteRecordInsertData["record_date"]));
                $organicWasteRecordInsertData['created_at'] = YMDToDMY($organicWasteRecordInsertData["created_at"], true);
                $organicWasteRecordInsertData['updated_at'] = YMDToDMY($organicWasteRecordInsertData["updated_at"], true);
                $organicWasteRecordInsertData['total_waste'] = $organicWasteRecordInsertData['kitchen_waste'] + $organicWasteRecordInsertData['processed_compost'] + $organicWasteRecordInsertData['sawdust'];
                $organicWasteRecordInsertData['total_compost'] = $organicWasteRecordInsertData['bacteria'] + $organicWasteRecordInsertData['ready_compost'];
            }
            
            if (isset($organicWasteRecordId) && !empty($organicWasteRecordId)) {
                if (isset($organicWasteRecordData['success']) && $organicWasteRecordData['success']) {
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.document_updated'), lang('CommonWebService.organic_waste_record')),
                        'data' => $organicWasteRecordInsertData
                    ), 200);
                } else {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_update'), lang('CommonWebService.organic_waste_record')),
                        'data' => null
                    ), 404);
                }
            } else {
                if (isset($organicWasteRecordData['success']) && $organicWasteRecordData['success']) {
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.new_created'), lang('CommonWebService.organic_waste_record')),
                        'data' => $organicWasteRecordInsertData
                    ), 200);
                } else {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_create'), lang('CommonWebService.organic_waste_record')),
                        'data' => null
                    ), 400);
                }
            }
        }
    }

    public function deleteOrganicWasteRecord()
    {
        $userId = $this->request->getVar('user_id');
        $organicWasteRecordId = $this->request->getVar('organic_waste_record_id');
        $societyId = $this->request->getVar('society_id');

        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('organic_waste_record_id', lang('CommonWebService.organic_waste_record_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        } else {
            $this->db->transStart();
            $organicWasteRecordId = ($organicWasteRecordId != '') ? explode(",", $organicWasteRecordId) : '';
            $organicWasteRecordData = $this->organicWasteRecordModel->deleteRecord($organicWasteRecordId);
            if ($organicWasteRecordData) {
                $this->db->transComplete();
                $data = array(
                    'status' => TRUE,
                    'message' => sprintf(lang('CommonMessage.delete_record'), lang('CommonWebService.organic_waste_record')),
                    'response_code' => 200,
                    'data' => null,);

                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => False,
                    'message' => sprintf(lang('CommonMessage.error_delete_record'), lang('CommonWebService.organic_waste_record')),
                    'response_code' => 404,
                    'data' => null,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getOrganicWasteRecordPdf() {

        // printArray($_GET,1);
        $userId = $this->request->getVar('user_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $societyId = $this->request->getVar('society_id');
        $startDate = $this->request->getVar('start_date');
        $endDate = $this->request->getVar('end_date');
        
        $header = $this->request->getVar('Authorization');
        $key = getenv('JWT_SECRET');
        $token = null;

        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('Authorization', lang('CommonWebService.Authorization'), 'required');
        $this->validation->setRule('start_date', lang('CommonWebService.start_date'), 'required');
        $this->validation->setRule('end_date', lang('CommonWebService.end_date'), 'required');

        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        } else {

            // extract the token from the header
            if(!empty($header)) {
                if (preg_match('/Bearer\s(\S+)/', $header, $matches)) {
                    $token = $matches[1];
                }
            }
            // check if token is null or empty
            if(is_null($token) || empty($token)) {
                $data = [
                    'status'  => false,
                    'message' => "Access denied",
                    'data' => [],
                    "response_code" => 401
                ];
                return $this->response($data, 401);
            }

            try {
                // $decoded = JWT::decode($token, $key, array("HS256"));
                $decoded = JWT::decode($token, new Key($key, 'HS256'));
                $apiUserSocietyId = $userSocietyId;
    
                $tokenDecodeData = json_decode(json_encode($decoded), true);
                if(isset($apiUserSocietyId) && !empty($apiUserSocietyId)){
                    $tokenUserSocietyId = isset($tokenDecodeData['user_society_id']) ? $tokenDecodeData['user_society_id']: 0;
                    if($apiUserSocietyId != $tokenUserSocietyId){
                        $data = [
                            'status'  => false,
                            'message' => "Invalid Login User Id",
                            'data' => [],
                            "response_code" => 401
                        ];
                        return $this->response($data, 401);
                    }
    
                    $ionAuthModel = new \App\Models\IonAuthModel();
                    $getUserData = $ionAuthModel->getUserSocietyData(array('user_society_id' => $apiUserSocietyId));
                    
                    if(empty($getUserData)){
                        $data = [
                            'status'  => false,
                            'message' => "Login User Not Found",
                            'data' => [],
                            "response_code" => 401
                        ];
                        return $this->response($data, 401);
                    }
                }
            } catch (\Exception $ex) {
                $data = [
                    'status'  => false,
                    'message' => "Access denied",
                    'data' => [],
                    "response_code" => 401
                ];
                return $this->response($data, 401);
            }

            $societyData = $this->societyModel->getSocietyData(array(
                "society_id" => $societyId,
            ));
            $filterData = array(
                "is_multiple" => 1,
                "is_api_call" => 1,
                "society_id" => $societyId,
            );
            if (!empty($startDate)) {
                $filterData['start_date'] = DMYToYMD($startDate);
            }
            if (!empty($endDate)) {
                $filterData['end_date'] = DMYToYMD($endDate);
            }
            $recordData = $this->organicWasteRecordModel->getOrganicWasteRecordData($filterData);
            if (!empty($recordData)) {
                $data['organic_waste_record_data'] = $recordData;
                $data['society_data'] = $societyData;
                $data['start_date'] = $startDate;
                $data['end_date'] = $endDate;
                $data['name'] = lang("OrganicWasteRecord.organic_waste_record"). ".pdf";
                $printHeader = '';
                // $printFooter = '';
                $printFooter = pdfFooter( 0, array());
                $html = view('Admin/OrganicWasteRecord/Pdf/OrganicWasteRecordPdfView', $data);
                generate_pdf($html, $data['name'], false, $printFooter, '', $printHeader, '', 'P');
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $recordData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }


    function _remap($method)
    {
        // Sure it exists, but can they do anything with it?
        if (!method_exists($this, $method)) {
            $data = array(
                'status' => false,
                'message' => "Unknown method",
                'response_code' => 405,
                'data' => null,
            );
            return $this->response($data, 405);
        }

        if (method_exists($this, $method)) {
            $this->logRequest($authorized = TRUE);
            return $this->$method();
        }
    }

    protected function logRequest($authorized = FALSE, $response = "")
    {
        $request = request();
        $header = $request->Header('Authorization');
        if ($header != '') {
            if (!empty($header)) {
                if (preg_match('/Bearer\s(\S+)/', $header, $matches)) {
                    $token = $matches[1];
                }
            }
            $requestArray = array();
            $requestArray = $request->getVar();
            $requestArray['Authorization'] = $token;
            $params = $requestArray;
        } else {
            $params = $request->getVar();
        }

        $builder = $this->db->table('tbl_logs');
        $data['uri'] = uri_string();
        $data['method'] = $this->request->getMethod();
        $data['params'] = json_encode($params);
        $data['api_key'] = '';
        $data['ip_address'] = $request->getIPAddress();
        $data['time'] = time();
        $data['authorized'] = $authorized;
        $data['response'] = $response;
        $data['request_time'] = date("Y-m-d H:i:s");
        // Insert the request into the log table
        $builder->insert($data);
        $this->insertId = $this->db->insertID();

    }

    protected function logAccessTime()
    {
        if ($this->insertId == '') {
            return false;
        }

        $payload['rtime'] = $this->endRtime - $this->startRtime;
        $builder = $this->db->table('tbl_logs');

        $builder->where('id', $this->insertId);
        $builder->update($payload);
    }

    protected function logResponseCode($http_code, $output)
    {
        if ($this->insertId == '') {
            return false;
        }

        $payload['response_code'] = $http_code;
        $payload['response'] = $output;
        $payload['responsetime'] = time();
        $payload['response_time'] = date("Y-m-d H:i:s");

        $builder = $this->db->table('tbl_logs');

        $builder->where('id', $this->insertId);
        $builder->update($payload);
    }

    function response($data = array(), $http_code = NULL, $continue = FALSE)
    {

        if ($http_code !== NULL) {
            // So as to be safe later on in the process
            $http_code = (int)$http_code;
        }
        // Set the output as NULL by default
        $output = NULL;

        // If data is NULL and no HTTP status code provided, then display, error and exit
        if ($data === NULL && $http_code === NULL) {
            $http_code = 404;
        } // If data is not NULL and a HTTP status code provided, then continue
        elseif ($data !== NULL) {
            $output = json_encode($data);
        }

        // If not greater than zero, then set the HTTP status code as 200 by default
        // Though perhaps 500 should be set instead, for the developer not passing a
        // correct HTTP status code
        $http_code > 0 || $http_code = 200;
        // JC: Log response code only if rest logging enabled
        if (REST_ENABLE_LOGGING === TRUE) {
            $this->logResponseCode($http_code, $output);
        }
        return $this->respond($data, $http_code);
    }

}


?>
