<?php
namespace App\Controllers\Admin;
use App\Models\SocietyModel;
use CodeIgniter\Controller;
use App\Models\WarrantyModel;
use App\Models\VendorModel;
class Warranty extends BaseController
{
    protected $warranty_model;
    public function __construct() {
        $this->warranty_model = new WarrantyModel();
        $this->vendor_model = new VendorModel();
        $this->society_model = new SocietyModel();
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );
        $data['title'] = 'Warranty';
        return $this->dt_ci_template->load("Admin","Warranty/WarrantyView",$data);
    }

    public function getWarrantyListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $this->datatables->table("tbl_warranty as tw");
        $this->datatables->select("tw.warranty_id,tw.is_active,tw.warranty_period_from,tw.warranty_period_to,tw.warranty_for");
        $this->datatables->select("ts.society_name,COALESCE(tm.manufacturer_name,'') as manufacturer_name,COALESCE(ti.item_name,'') as item_name,COALESCE(tv.vendor_name,'') as vendor_name");
        $this->datatables->select("tw.updated_at,concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");

        $this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = tw.society_id","left");
        $this->datatables->join("tbl_manufacturer as tm","tm.manufacturer_id = tw.manufacturer_id","left");
        $this->datatables->join("tbl_item as ti","ti.item_id = tw.item_id","left");
        $this->datatables->join("tbl_vendor as tv","tv.vendor_id = tw.vendor_id","left");
        $this->datatables->join("society_user_master_view as tupdate","tupdate.user_society_id = tw.updated_by","left");
        $this->datatables->groupBy("tw.warranty_id");
        accessFilter($this->datatables, array("society" => "tw.society_id"));

        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "warranty_id" => isset($displayData['warranty_id']) ? $displayData['warranty_id'] : ""
                );
                $data[$key]['action_button'] = warrantyActionButton($actionButtonFilter);
                $data[$key]['warranty_period_from'] = siteDateFormat($displayData['warranty_period_from']);
                $data[$key]['warranty_for'] = underscoreToUcWord($displayData['warranty_for']);
                $data[$key]['warranty_period_to'] = siteDateFormat($displayData['warranty_period_to']);
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }

    public function manage($warrantyId = '')
    {

        $data['extra_js'] = array(
            "js/jquery.form.min.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/bootstrap-datepicker/bootstrap-datepicker.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
        );
        if ($warrantyId != '') {
            $filterData = array(
                "warranty_id" => $warrantyId
            );
            $data['warranty_data'] = $this->warranty_model->getWarrantyData($filterData);

            $vendorContactData = $this->warranty_model->getWarrantyVendorContactData(array(
                'warranty_id' => $warrantyId,
                'is_multiple' => 1
            ));
            $data['vendor_mobile_data'] = $vendorContactData;

            if (empty($data['warranty_data'])) {
                return redirect()->to('Admin/Warranty');
            }
        }
        if ($warrantyId != '') {
            $data['title'] = 'Edit Warranty';
        } else {
            $data['title'] = 'Add Warranty';
        }
        if ((isset($data['warranty_data']['society_id']) && $data['warranty_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/Warranty');
        }
        $data['vendor_contact_table'] = view('Admin/Warranty/VendorContactTableView', isset($data) ? $data : array());
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Ajax)? $select2Ajax : array());
        $this->dt_ci_template->load("Admin","Warranty/WarrantyManageView",$data);
    }
    public function save()
    {
        $this->db->transStart();
        $validation = \Config\Services::validation();
        $warrantyId = $this->request->getVar('warranty_id');
        $warrantyFor = $this->request->getVar('warranty_for');
        $itemId = $this->request->getVar('item_id');
        $manufacturerId = $this->request->getVar('manufacturer_id');
        $warrantyPeriodFrom = $this->request->getVar('warranty_period_from');
        $warrantyPeriodTo = $this->request->getVar('warranty_period_to');
        $isActive = $this->request->getVar('is_active');
        $vendorId = $this->request->getVar('vendor_id');
        $warrantyVendorContactIdArray = $this->request->getVar('warranty_vendor_mobile_id');
        $vendorMobileNoArray = $this->request->getVar('vendor_mobile_no');
        $vendorPersonNameArray = $this->request->getVar('vendor_person_name');
        $vendorDesignationArray = $this->request->getVar('vendor_designation');
        $vendorMobileIdArray = $this->request->getVar('vendor_mobile_id');

        
       $validation->setRule('warranty_for', lang('Warranty.warranty_for'), 'required');
       $validation->setRule('item_id', lang('Warranty.item_id'), 'required');
       $validation->setRule('manufacturer_id', lang('Warranty.manufacturer'), 'required');
       $validation->setRule('warranty_period_from', lang('Warranty.warranty_period_from'), 'required');
       $validation->setRule('warranty_period_to', lang('Warranty.warranty_period_to'), 'required');

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {
            if (strtotime($warrantyPeriodFrom) > strtotime($warrantyPeriodTo)){
                $response['success'] = false;
                $response['msg'] = lang('Warranty.warranty_warranty_period_from_date_to_date_message');
                echo json_encode($response);
                exit;
            }

            $warrantyUpdateArray = array();
            $warrantyArray = array(
                'warranty_id' => $warrantyId,
                'warranty_for' => $warrantyFor,
                'item_id' => $itemId,
                'vendor_id' => $vendorId,
                'society_id' => $this->session->get('society_id'),
                'manufacturer_id' => $manufacturerId,
                'warranty_period_from' => DMYToYMD($warrantyPeriodFrom),
                'warranty_period_to' => DMYToYMD($warrantyPeriodTo),
                'is_active' => isset($isActive) ? 1 : 0,
            );

            if(!empty($warrantyId)){
                $warrantyUpdateData = $this->warranty_model->getWarrantyData(array(
                    'warranty_id' => $warrantyId,
                ));
                $warrantyUpdateArray = compareArray($warrantyArray,$warrantyUpdateData);
            }
            $warrantyData = $this->warranty_model->insertUpdateRecord($warrantyArray,'warranty_id','tbl_warranty', 1,'',array(),array(),$warrantyUpdateArray);
            $lastWarrantyId = $warrantyData['lastInsertedId'];

            if (!empty($warrantyVendorContactIdArray)) {
                if($warrantyId != ''){
                    $this->warranty_model->deleteWarrantyVendorContactRecord($lastWarrantyId);
                }

                foreach ($warrantyVendorContactIdArray as $vcKey =>  $warrantyVendorContactId) {
                    $vendorMobileId = array_key_exists($vcKey, $vendorMobileIdArray) ? $vendorMobileIdArray[$vcKey] : '';
                    $vendorMobileNo = array_key_exists($vcKey, $vendorMobileNoArray) ? $vendorMobileNoArray[$vcKey] : '';
                    $vendorPersonName = array_key_exists($vcKey, $vendorPersonNameArray) ? $vendorPersonNameArray[$vcKey] : '';
                    $vendorDesignation = array_key_exists($vcKey, $vendorDesignationArray) ? $vendorDesignationArray[$vcKey] : '';

                    $vendorContactInsertArray[$vcKey] = array(
                        'warranty_vendor_contact_id' => '',
                        'warranty_id' => $lastWarrantyId,
                        'vendor_mobile_id' => $vendorMobileId,
                        'vendor_person_name' => $vendorPersonName,
                        'vendor_designation' => $vendorDesignation,
                        'vendor_mobile_no' => $vendorMobileNo,
                        'created_by' => $this->data['userId'],
                        'updated_by' => $this->data['userId'],
                        'created_at' => date("Y-m-d H:i:s"),
                        'updated_at' => date("Y-m-d H:i:s"),
                    );
                }

                $vendorContactExtraDataArray = array();
                $vendorContactExtraDataArray['module_id'] = $lastWarrantyId;
                $vendorContactExtraDataArray['module'] = 'Warranty Vendor Contact';
                $vendorContactExtraDataArray['type'] = 'Warranty';
                $vendorContactExtraDataArray['old_data'] = array();
                $vendorContactExtraDataArray['user_id'] = $this->data['userId'];
                $vendorContactExtraDataArray['society_id'] = $this->session->get('society_id');
                if (!empty($vendorContactInsertArray)) {
                    $this->warranty_model->batchInsert($vendorContactInsertArray, 'tbl_warranty_vendor_contact',$vendorContactExtraDataArray);
                }

            }
            $transactionStatus = $this->db->transComplete();
            if (isset($warrantyId) && $warrantyId != '') {
                if (($warrantyData['success']) && ($transactionStatus == 1)) {
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('Warranty.warranty'));
                } else {
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('Warranty.warranty'));
                }
            } else {
                if (($warrantyData['success']) && ($transactionStatus == 1)) {
                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('Warranty.warranty'));
                } else {
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('Warranty.warranty'));
                }
            }
            echo json_encode($response);
            exit();
        }

    }

    public function changeStatus()
    {
        $warrantyId = $this->request->getVar('warranty_id');
        $status = $this->request->getVar('status');

        $return = $this->warranty_model->statusChange($warrantyId,$status,'warranty_id','tbl_warranty');
        if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('Warranty.warranty'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('Warranty.warranty'));
        }
        echo json_encode($response);
        exit();
    }


    public function delete()
    {
        $this->db->transStart();
        $warrantyId = $this->request->getVar('warranty_id');
        $warrantyData  = $this->warranty_model->deleteRecord($warrantyId);
        $transactionStatus = $this->db->transComplete();
        if (($warrantyData)  && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Warranty.warranty'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang('Warranty.warranty'));
        }
        echo json_encode($response);
        exit;
    }
    public function view($id = null)
    {
        $warrantyId = $this->request->getVar("view_id");
        if($warrantyId == "" && $warrantyId == null){
            return redirect()->to('Admin/Warranty');
        }
        else {
            $id = $warrantyId;
            $filterData = array(
                "warranty_id" => $warrantyId
            );
            $data['warranty_data'] = $this->warranty_model->getWarrantyData($filterData);
            $flatView = view("Admin/Warranty/WarrantyModelView", $data);
            $response['view_title'] = "Warranty Details";
            $response['view_detail'] = $flatView;
            $response['success'] = true;
            echo json_encode($response);
        }
    }
    public function excelExportWarranty()
    {
        $fileName ='warranty-' . DATETIMEFORMAT;
        $sheetName = 'Warranty-' . DATEFORMAT;
        $excelHeaderName = 'Warranty';
        $tableData = $this->getWarrantyListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            lang('Warranty.warranty_for'),
            lang('Warranty.item'),
            lang('Warranty.manufacturer'),
            lang('Warranty.vendor'),
            lang('Warranty.warranty_period_from'),
            lang('Warranty.warranty_period_to'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                $row["warranty_for"],
                $row["item_name"],
                $row["manufacturer_name"],
                $row["vendor_name"],
                $row["warranty_period_from"],
                $row["warranty_period_to"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'H';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }
    public function getVendorContactTableRow()
    {
        $vendorId = $this->request->getVar('vendor_id');
        $vendorMobileData = $this->vendor_model->getVendorMobileData(array(
            'vendor_id' => $vendorId,
            'is_multiple' => 1
        ));
        $vendorRowHtml = '';
        if (!empty($vendorMobileData)) {
            if (isset($vendorMobileData) && !empty($vendorMobileData)) {
                foreach ($vendorMobileData as $key => $vendorData) {
                    $data["row_number"] = $key + 1;
                    $data["vendor_mobile_data"] = $vendorData;
                    $vendorRowHtml .= view('Admin/Warranty/VendorContactTableRowView', isset($data) ? $data : array());
                }
            }
            $response['success'] = true;
            $response['vendor_row_data'] = $vendorRowHtml;
            echo json_encode($response);
            exit;
        } else {
            $vendorRowHtml .= view('Admin/Warranty/VendorContactTableRowView', isset($data) ? $data : array());
            $response['success'] = false;
            $response['message'] = '';
            $response['vendor_row_data'] = $vendorRowHtml;
            echo json_encode($response);
            exit;
        }
        $memberRow = view('Admin/Warranty/VendorContactTableRowView', isset($data) ? $data : array());
        echo $memberRow;
    }

    public function warrantyPdf()
    {
        if(!$this->dt_ci_acl->checkAccess('Warranty|pdf')){
            return show_error(NO_ACCESS_SECTION);
        } else {
            $societyData = $this->society_model->getSocietyData(array(
                "society_id" => $this->session->get('society_id'),
            ));
            
            $filterData = array(
                'society_id' => $this->session->get('society_id'),
                'is_multiple' => 1, 
            );
            $warrantyData = $this->warranty_model->getWarrantyData($filterData);
            $societyDataArray = array();
            $residentsDataArray =array();
            foreach($warrantyData as $warranty){
                if($warranty['warranty_for'] == 'society'){
                    $societyDataArray[] = $warranty;
                }
                else{
                    $residentsDataArray[] = $warranty;
                }
            }
            
            $data['society_data'] = $societyData;
            $data['warranty_data'] = $warrantyData;
            $data['society_warranty_data'] = $societyDataArray;
            $data['residents_warranty_data'] = $residentsDataArray;
            // printArray($warrantyData,1);   

            $data['name'] = lang("Warranty.warranty_pdf") . ".pdf";
            $printHeader = '';
            $printFooter = '';
            $printFooter = pdfFooter( 0, array());
            $html = view('Admin/Warranty/pdf/WarrantyPdfView', $data);
            // echo($html);
            // die();
            generate_pdf($html, $data['name'], false, $printFooter, '', $printHeader, '', 'P');
        }
    }

}
