<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\VisitModel;
use App\Models\SocietyModel;
use App\Models\VendorModel;
use App\Models\AMCModel;
use App\Models\FinancialYearModel;
class Visit extends BaseController {
    protected $visit_model;
    protected $amc_model;
    protected $society_model;
    public function __construct() {
        $this->visit_model = new VisitModel();
        $this->amc_model = new AMCModel();
        $this->society_model = new SocietyModel();
        $this->vendor_model = new VendorModel();
    }
    public function index()
	{
		$data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
			"vendor/libs/moment/moment.js",
			"vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
		$data['title'] = 'Visit';
		$dataFilters['filters'] = array(
            array(
                "type" => "multi_select",
                "dynamic" => true,
                "class" => "vendorDd",
                "id" => "filter_vendor_id",
                "name" => "filter_vendor_id",
                "title" => "Visit.service_provider",
            ),
            array(
                "type" => "multi_select",
                "dynamic" => true,
                "class" => "amcDd",
                "id" => "filter_amc_id",
                "name" => "filter_amc_id",
                "title" => "Visit.amc",
            ),
			array(
                "type" => "visit_type",
                "id" => "filter_visit_type",
                "name" => "filter_visit_type",
                "title" => "Visit.visit_type",
            ),
			array(
                "type" => "daterange",
                "id" => "filter_visit_date_time",
                "name" => "filter_visit_date_time",
                "title" => "Visit.visit_date_time",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_created_at",
                "name" => "filter_created_at",
                "title" => "CommonMessage.common_created_at",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_updated_at",
                "name" => "filter_updated_at",
                "title" => "CommonMessage.common_updated_at",
            ),
        );

        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Ajax)? $select2Ajax : array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());    
		$this->dt_ci_template->load("Admin","Visit/VisitView",$data);
    }

    public function manage($visitId = '')
	{
		$data['extra_js'] = array(
			"js/jquery.form.min.js",
			"vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
			"js/validate.min.js",
			"js/additional_methods.min.js",
		);

        if ($visitId != '') {
			$filterData = array(
				"visit_id" => $visitId
			);
			$data['visit_data'] = $this->visit_model->getVisitData($filterData);

			if (empty($data['visit_data'])) {
                return redirect()->to('Admin/Visit');;
            }
		}

		if ($visitId != '') {
			$data['title'] = 'Edit Visit';
		} else {
			$data['title'] = 'Add Visit';
		}
		$data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
		if ((isset($data['visit_data']['society_id']) && $data['visit_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/Visit');
        }
		$this->dt_ci_template->load("Admin","Visit/VisitManageView",$data);
	}

    public function getVisitListing($return = false,$filterData=array())
    {
    	if($return == TRUE){
			$filterData['length'] = '';
			$_POST = $filterData;
		}
		$createdAt = $this->request->getVar("filter_created_at");
		$updatedAt = $this->request->getVar("filter_updated_at");
		$vendorId = $this->request->getVar("filter_vendor_id");
		$amcId = $this->request->getVar("filter_amc_id");
		$visitDateTime = $this->request->getVar("filter_visit_date_time");
		$visitType = $this->request->getVar("filter_visit_type");
		
        $this->datatables->table("tbl_visit as tvi");

        
		$this->datatables->select("tvi.amc_id,tvi.visit_id,tvi.visit_date_time,tvi.amount,tvi.is_active,tvi.remarks,tvi.created_at,tvi.updated_at,tvi.visit_type");
		$this->datatables->select("COALESCE(ts.society_name,'') as society_name");
		$this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $this->datatables->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
		$this->datatables->select("COALESCE(tad.amc_type,'') as amc_type");
		$this->datatables->select("COALESCE(tad.particular,'') as particular");
        $this->datatables->select("COALESCE(tv.vendor_name,'') as service_provider,tad.period_from,tad.period_upto");

        $this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = tvi.society_id","left");
		$this->datatables->join("tbl_amc_detail as tad","tad.amc_id = tvi.amc_id","left");
		$this->datatables->join("tbl_vendor as tv","tv.vendor_id = tvi.vendor_id","left");
		$this->datatables->join("society_user_master_view as tupdate","tupdate.user_society_id = tvi.updated_by","left");
        $this->datatables->join("society_user_master_view as tcreate","tcreate.user_society_id = tvi.created_by","left");


		if(isset($vendorId)) {
            if(is_array($vendorId)){
                $this->datatables->whereIn("tvi.vendor_id",$vendorId);
            } else {
                $this->datatables->where("tvii.vendor_id",$vendorId);
            }
        }

        if(isset($amcId)) {
            if(is_array($amcId)){
                $this->datatables->whereIn("tvi.amc_id",$amcId);
            } else {
                $this->datatables->where("tvi.amc_id",$amcId);
            }
        }

        if(isset($visitType)) {
            if(is_array($visitType)){
                $this->datatables->whereIn("tvi.visit_type",$visitType);
            } else {
                $this->datatables->where("tvi.visit_type",$visitType);
            }
        }

		if($visitDateTime != ''){
			list($fromDate,$toDate) = explode(" - ",$visitDateTime);
			$fromDate = DMYToYMD($fromDate);
			$toDate = DMYToYMD($toDate);
			if(strtotime($fromDate) != strtotime($toDate)){
				$this->datatables->where("date_format(tvi.visit_date_time,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
				$this->datatables->where("date_format(tvi.visit_date_time,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
			} else {
				$this->datatables->where("date_format(tvi.visit_date_time,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
			}
		}

        if($createdAt != ''){
            list($fromDate,$toDate) = explode(" - ",$createdAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tvi.created_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tvi.created_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tvi.created_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }
        if($updatedAt != ''){
            list($fromDate,$toDate) = explode(" - ",$updatedAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tvi.updated_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tvi.updated_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tvi.updated_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }

		accessFilter($this->datatables, array("society" => "tvi.society_id"));

		$this->datatables->groupBy("tvi.visit_id");
		
        $dataReport =  $this->datatables->generate();
		$dataReport = json_decode($dataReport, true);
		$data       = $dataReport['data'];
		if(count($data) > 0){
			foreach($data as $key => $displayData){
				$actionButtonFilter = array(
					"visit_id" => isset($displayData['visit_id']) ? $displayData['visit_id'] : ""
				);
				$data[$key]['action_button'] = visitActionButton($actionButtonFilter);
				$data[$key]['particular'] = underscoreToUcWord($displayData['particular']);
				$data[$key]['visit_type'] = underscoreToUcWord($displayData['visit_type']);
				$data[$key]['amount'] = isset($displayData['amount']) ? indianMoneyFormat($displayData['amount'],2,1) : '-';
				$data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
				$data[$key]['visit_date_time'] = isValidDate($displayData['visit_date_time']) ? siteDateFormat($displayData['visit_date_time'],true) : "";
				$data[$key]['period_from'] = isValidDate($displayData['period_from']) ? YMDToDMY($displayData['period_from']) : "";
				$data[$key]['period_to'] = isValidDate($displayData['period_upto']) ? YMDToDMY($displayData['period_upto']) : "";
                if($displayData['amc_id'] != 0){
                    $data[$key]['amc_period'] =  $data[$key]['period_from'].' / '.$data[$key]['period_to'];
                } else{
                    $data[$key]['amc_period'] = '';
                }

			}
		}

		if($return){
			return $data;
		}else{
			$dataReport['data'] = $data;
			echo json_encode($dataReport);
			exit;
		}
        
    }

    public function changeStatus(){
        $visitId = $this->request->getVar('visit_id');
        $status = $this->request->getVar('status');
        $return = $this->visit_model->statusChange($visitId,$status,'visit_id','tbl_visit');
		if ($return == 1) {
			$response['success'] = true;
			$response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('Visit.visit'));
		} else {
			$response['success'] = false;
			$response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('Visit.visit'));
		}
		echo json_encode($response);
		exit;
    }

    public function save()
	{
		$this->db->transStart();
		$validation = \Config\Services::validation();
        
		$visitId = $this->request->getVar('visit_id');
		$amcId = $this->request->getVar('amc_id');
		$vendorId = $this->request->getVar('vendor_id');
		$visitDateTime = $this->request->getVar('visit_date_time');
		$visitType = $this->request->getVar('visit_type');
		$amount = $this->request->getVar('amount');
		$remarks = $this->request->getVar('remarks');
		$isActive = $this->request->getVar('is_active');

        // echo($visitDateTime);
        // die();
		// $validation->setRule('amc_id', lang('AMC.amc_id'), 'required');
		$validation->setRule('visit_date_time', lang('Visit.visit_date_time'), 'required');
		$validation->setRule('vendor_id', lang('Visit.company_person'), 'required');
		$validation->setRule('visit_type', lang('Visit.visit_type'), 'required');
        if($visitType == 'paid'){
            $validation->setRule('amount', lang('Visit.amount'), 'required');
        }

		if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

			// if (strtotime($periodFrom) > strtotime($periodTo)){
			// 	$response['success'] = false;
			// 	$response['msg'] = lang('AMC.amc_period_from_date_to_date_message');
			// 	echo json_encode($response);
			// 	exit;
			// }
			$visitUpdateArray = array();
			$visitArray = array(
				'visit_id' => $visitId,
				'amc_id' => $amcId,
				'society_id' => $this->session->get('society_id'),
				'visit_date_time' => DMYToYMD($visitDateTime,true,true),
				'visit_type' => $visitType,
				'remarks' => $remarks,
				'vendor_id' => $vendorId,
				'amount' => isset($amount) ? $amount : 0,
				'is_active' => isset($isActive) ? 1 : 0,
			);
			if(!empty($visitId)){
                $visitUpdateData = $this->visit_model->getVisitData(array(
                    'visit_id' => $visitId,
                ));
                $visitUpdateArray = compareArray($visitArray,$visitUpdateData);
            }
			$visitData = $this->visit_model->insertUpdateRecord($visitArray, 'visit_id', 'tbl_visit', 1,'',array(),array(),$visitUpdateArray);
			$lastVisitId = $visitData['lastInsertedId'];
			$transactionStatus = $this->db->transComplete();
			if (isset($visitId) && $visitId != '') {
				if (($visitData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.update_record'), lang("Visit.visit"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.update_record_error'), lang("Visit.visit"));
				}
			} else {
				if (($visitData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.create_record'), lang("Visit.visit"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.create_record_error'), lang("Visit.visit"));
				}
			}
			echo json_encode($response);
			exit;
		}
	}

    public function delete()
    {
    	$this->db->transStart();
		$visitId = $this->request->getVar('visit_id');
		$visitData = $this->visit_model->deleteRecord($visitId);
		$transactionStatus = $this->db->transComplete();
        if (($visitData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg'] = sprintf(lang('CommonMessage.delete_record'), lang("Visit.visit"));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'), lang("Visit.visit"));
        }
        echo json_encode($response);
        exit;
    }
    
    public function view($id = null)
	{
		$visitId = $this->request->getVar("view_id");
		if($visitId == "" && $visitId == null){
            return redirect()->to('Admin/Visit');
		}
		else {
			$id = $visitId;
			$filterData = array(
				"visit_id" => $visitId
			);
			$data['visit_data'] = $this->visit_model->getVisitData($filterData);
			$visitView = view("Admin/Visit/VisitModelView", $data);

			$response['view_title'] = lang('Visit.visit_detail');
			$response['view_detail'] = $visitView;
			$response['success'] = true;
			echo json_encode($response);
		}
	}

	public function excelExportVisit()
	{
		$fileName ='visit-' . DATETIMEFORMAT;
		$sheetName = 'Visit-' . DATEFORMAT;
		$excelHeaderName = 'Visit';
		$tableData = $this->getVisitListing(true, $_GET);
		$dataRows = array();
		$dataRows[] = array(
			lang('Visit.visit_date_time'),
			lang('Visit.service_provider'),
			lang('Visit.amc'),
			lang('Visit.amc_period'),
			lang('Visit.visit_type'),
			lang('Visit.amount'),
			lang('Visit.remarks'),
			lang('CommonMessage.common_updated_by'),
			lang('CommonMessage.common_updated_at')
		);
		foreach ($tableData as $row) {
            $amcPeriod = '';
			$amount = '';
            if($row['amc_id'] != 0){
                $amcPeriod = $row['period_from']." / ".  $row['period_to'];

			if($row["visit_type"] == 'Paid'){
				$amount = $row["amount"];
			}
            }
			$dataRows[] = array(
				$row["visit_date_time"],
				$row["service_provider"],
				$row["particular"],
                $amcPeriod,
				$row["visit_type"],
				$amount,
				$row["remarks"],
				$row["updated_by"],
				$row["updated_at"]
			);
		}
		$subTotalCellValueArray = [];
		$toColumn = 'I';
		$excelFilterData = array(
			'file_name' => $fileName,
			'sheet_name' => $sheetName,
			'excel_header_name' => $excelHeaderName,
			'data_row' => $dataRows,
			'sub_total_cell_value_array' => $subTotalCellValueArray,
			'to_column' => $toColumn,
			'skip_header' => false,
			'ignore_currency_symbols_sub_total_cell_value_array' => array(),
			'row_cell_currency_format' => array()
		);
		//excelExport($filename,$sheetName,$excelHeaderName,$dataRows,$subTotalCellValueArray,$toColumn,false,array(),array());
		excelExport($excelFilterData);
	}

	public function visitPdf()
    {
        if(!$this->dt_ci_acl->checkAccess('Visit|pdf')){
            return show_error(NO_ACCESS_SECTION);
        } else {
            $societyData = $this->society_model->getSocietyData(array(
                "society_id" => $this->session->get('society_id'),
            ));
            
            $filterData = array(
                'visit_id' => $this->session->get('visit_id'),
                'is_multiple' => 1, 
            );
            $visitData = $this->visit_model->getVisitData($filterData);
            $data['society_data'] = $societyData;
            $data['visit_data'] = $visitData;
            // printArray($visitData,1);

            $data['name'] = lang("Visit.visit_pdf") . ".pdf";
            $printHeader = '';
            $printFooter = '';
            $printFooter = pdfFooter( 0, array());
            $html = view('Admin/Visit/pdf/VisitPdfView', $data);
            // echo($html);
            // die();
            generate_pdf($html, $data['name'], false, $printFooter, '', $printHeader, '', 'P');
        }
    }
}