<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\VendorModel;
use App\Models\SocietyModel;
class Vendor extends BaseController
{
    protected $vendor_model;
    public function __construct() {
        $this->vendor_model = new VendorModel();
        $this->society_model = new SocietyModel();
    }

    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/moment/moment.js",
            "vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
        $data['title'] = 'Vendor';
        $dataFilters['filters'] = array(
            array(
                "type" => "multi_select",
                "dynamic" => true,
                "class" => "vendorDd",
                "id" => "filter_vendor_id",
                "name" => "filter_vendor_id",
                "title" => "Vendor.vendor_name",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_created_at",
                "name" => "filter_created_at",
                "title" => "CommonMessage.common_created_at",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_updated_at",
                "name" => "filter_updated_at",
                "title" => "CommonMessage.common_updated_at",
            ),
        );
        
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
        $this->dt_ci_template->load("Admin","Vendor/VendorView",$data);
    }

    public function manage($vendorId = '')
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );

        if ($vendorId != '') {
            $filterData = array(
                "vendor_id" => $vendorId
            );
            $data['vendor_data'] = $this->vendor_model->getVendorData($filterData);

            $vendorMobileData = $this->vendor_model->getVendorMobileData(array(
                'vendor_id' => $vendorId,
                'is_multiple' => 1
            ));
            $data['vendor_mobile_data'] = $vendorMobileData;

            $vendorCategoryData = $this->vendor_model->getVendorCategoryData(array(
                'vendor_id' => $vendorId,
                'is_multiple' => 1
            ));
            $data['vendor_category_data'] = $vendorCategoryData;

            if (empty($data['vendor_data'])) {
                return redirect()->to('Admin/Vendor');
            }
        }
        if ($vendorId != '') {
            $data['title'] = 'Edit Vendor';
        } else {
            $data['title'] = 'Add Vendor';
        }
        $data['vendor_mobile_table'] = view('Admin/Vendor/VendorMobileView', isset($data) ? $data : array());
        if ((isset($data['vendor_data']['society_id']) && $data['vendor_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/Vendor');
        }
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
        $this->dt_ci_template->load("Admin","Vendor/VendorManageView",$data);
    }

    public function getVendorListing($return = false,$filterData=array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $createdAt = $this->request->getVar("filter_created_at");
        $updatedAt = $this->request->getVar("filter_updated_at");
        $vendorId = $this->request->getVar("filter_vendor_id");
        
        $this->datatables->table("tbl_vendor as tv");
        $this->datatables->select("tv.vendor_id, tv.vendor_name, tv.is_active,tv.society_id,COALESCE(ts.society_name,'') as society_name");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tv.updated_at,GROUP_CONCAT(distinct(tc.category_name) SEPARATOR ', ') as category_name");
        $this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = tv.society_id","left");
        $this->datatables->join("society_user_master_view as tupdate","tupdate.user_society_id = tv.updated_by","left");
        $this->datatables->join("tbl_vendor_category as tvc","tvc.vendor_id = tv.vendor_id","left");
        $this->datatables->join("tbl_category as tc","tc.category_id = tvc.category_id","left");

        if(isset($vendorId)) {
            if(is_array($vendorId)){
                $this->datatables->whereIn("tv.vendor_id",$vendorId);
            } else {
                $this->datatables->where("tv.vendor_id",$vendorId);
            }
        }
        if($createdAt != ''){
            list($fromDate,$toDate) = explode(" - ",$createdAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tv.created_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tv.created_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tv.created_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }
        if($updatedAt != ''){
            list($fromDate,$toDate) = explode(" - ",$updatedAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tv.updated_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tv.updated_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tv.updated_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }
        accessFilter($this->datatables, array("society" => "tv.society_id"));
        $this->datatables->groupBy("tv.vendor_id");
        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "vendor_id" => isset($displayData['vendor_id']) ? $displayData['vendor_id'] : ""
                );
                $data[$key]['action_button'] = vendorActionButton($actionButtonFilter);
                $data[$key]['updated_at'] = isValidDate($data[$key]['updated_at']) ? siteDateFormat($data[$key]['updated_at'],true) : "";
            }
        }

        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
        
    }

    public function changeStatus(){
        $vendorId = $this->request->getVar('vendor_id');
        $status = $this->request->getVar('status');
        $return = $this->vendor_model->statusChange($vendorId,$status,'vendor_id','tbl_vendor');
        if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('Vendor.vendor'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('Vendor.vendor'));
        }
        echo json_encode($response);
        exit;
    }

    public function save()
    {
        $this->db->transStart();
        $validation = \Config\Services::validation();
        $vendorId = $this->request->getVar('vendor_id');
        $vendorName = $this->request->getVar('vendor_name');
        $isActive = $this->request->getVar('is_active');


        $validation->setRule('vendor_name', lang('Vendor.vendor_name'), 'required');
        $validation->setRule('vendor_mobile_no.*', lang('Vendor.mobile'), 'required');
        
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {
            $oldCategoryData = array();
            if(!empty($vendorId)) {
                $oldCategoryData = $this->vendor_model->getVendorCategoryData(array(
                    'vendor_id' => $vendorId,
                    'is_multiple' => 1
                ));
            }

            $oldVendorMobileData = array();
            if(!empty($vendorId)){
                $oldVendorMobileData = $this->vendor_model->getVendorMobileData(array(
                    'vendor_id' => $vendorId,
                    'is_multiple' => 1
                ));
            }

            //get vendor mobile data
            $vendorMobileNoArray = $this->request->getVar('vendor_mobile_no');
            $vendorPersonNameArray = $this->request->getVar('vendor_person_name');
            $vendorDesignationArray = $this->request->getVar('vendor_designation');
            $vendorMobileIdArray = $this->request->getVar('vendor_mobile_id');

            $vendorUpdateArray = array();
            $vendorArray = array(
                'vendor_id' => $vendorId,
                'society_id' => $this->session->get('society_id'),
                'vendor_name' => $vendorName,
                'is_active' => isset($isActive) ? 1 : 0,
            );
            if(!empty($vendorId)){
                $vendorUpdateData = $this->vendor_model->getVendorData(array(
                    'vendor_id' => $vendorId,
                ));
                $vendorUpdateArray = compareArray($vendorArray,$vendorUpdateData);
            }
            $vendorData = $this->vendor_model->insertUpdateRecord($vendorArray, 'vendor_id', 'tbl_vendor', 1,'',array(),array(),$vendorUpdateArray);
            $lastVendorId = $vendorData['lastInsertedId'];

            $categoryIdArray = $this->request->getVar('category_id[]');
             if(isset($vendorId) && $vendorId != ''){
                $this->vendor_model->deleteCategoryRecord($vendorId);
            }
            if(isset($categoryIdArray)&& $categoryIdArray != ''){
                $categoryForArray = array();
                foreach($categoryIdArray as $categoryId){
                    $categoryForArray[] = array(
                        'vendor_category_id' => '',
                        'vendor_id' => $lastVendorId,
                        'category_id' => $categoryId,
                        'created_at' => date('Y-m-d H:i:s'),
                        'updated_at' => date('Y-m-d H:i:s'),
                        'created_by' => $this->data['userId'],
                        'updated_by' => $this->data['userId']
                    );
                }
                //printArray($documentForArray);

                $vendorCategoryExtraDataArray = array();
                $vendorCategoryExtraDataArray['module_id'] = $lastVendorId;
                $vendorCategoryExtraDataArray['module'] = 'Vendor Category';
                $vendorCategoryExtraDataArray['type'] = 'Vendor';
                $vendorCategoryExtraDataArray['old_data'] = $oldCategoryData;
                $vendorCategoryExtraDataArray['user_id'] = $this->data['userId'];
                $vendorCategoryExtraDataArray['society_id'] = $this->session->get('society_id');

                if(!empty($categoryForArray)){
                     $this->vendor_model->batchInsert($categoryForArray,'tbl_vendor_category',$vendorCategoryExtraDataArray);
                }
            }

            if (!empty($vendorMobileIdArray)) {
                foreach ($vendorMobileIdArray as $fkey => $vendorMobileId) {
                    $vendorMobileNo = array_key_exists($fkey, $vendorMobileNoArray) ? $vendorMobileNoArray[$fkey] : '';
                    $vendorPersonName = array_key_exists($fkey, $vendorPersonNameArray) ? $vendorPersonNameArray[$fkey] : '';
                    $vendorDesignation = array_key_exists($fkey, $vendorDesignationArray) ? $vendorDesignationArray[$fkey] : '';

                    if ($vendorMobileId == '' && array_key_exists($fkey, $vendorMobileNoArray)) {
                        $vendorMobileInsertArray[$fkey] = array(
                            'vendor_mobile_id' => '',
                            'vendor_id' => $lastVendorId,
                            'vendor_person_name' => $vendorPersonName,
                            'vendor_designation' => $vendorDesignation,
                            'vendor_mobile_no' => $vendorMobileNo,
                            'created_by' => $this->data['userId'],
                            'updated_by' => $this->data['userId'],
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                    } else {
                        $vendorMobileUpdateArray[$fkey] = array(
                            'vendor_mobile_id' => $vendorMobileId,
                            'vendor_id' => $lastVendorId,
                            'vendor_person_name' => $vendorPersonName,
                            'vendor_designation' => $vendorDesignation,
                            'vendor_mobile_no' => $vendorMobileNo,
                            'updated_by' => $this->data['userId'],
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                    }
                }
//              printArray($oldVendorMobileData,1);
                $vendorMobileExtraDataArray = array();
                $vendorMobileExtraDataArray['module_id'] = $lastVendorId;
                $vendorMobileExtraDataArray['module'] = 'Vendor Mobile';
                $vendorMobileExtraDataArray['type'] = 'Vendor';
                $vendorMobileExtraDataArray['old_data'] = $oldVendorMobileData;
                $vendorMobileExtraDataArray['user_id'] = $this->data['userId'];
                $vendorMobileExtraDataArray['society_id'] = $this->session->get('society_id');
                if (!empty($vendorMobileInsertArray)) {
                    $this->vendor_model->batchInsert($vendorMobileInsertArray, 'tbl_vendor_mobile',$vendorMobileExtraDataArray);
                }
                if (!empty($vendorMobileUpdateArray)) {
                    $this->vendor_model->batchUpdate($vendorMobileUpdateArray, "vendor_mobile_id", 'tbl_vendor_mobile',$vendorMobileExtraDataArray);
                }
            }

            $transactionStatus = $this->db->transComplete();
            if (isset($vendorId) && $vendorId != '') {
                if (($vendorData['success']) && ($transactionStatus == 1)) {
                    $response['success'] = true;
                    $response['msg'] = sprintf(lang('CommonMessage.update_record'), lang("Vendor.vendor"));
                } else {
                    $response['success'] = false;
                    $response['msg'] = sprintf(lang('CommonMessage.update_record_error'), lang("Vendor.vendor"));
                }
            } else {
                if (($vendorData['success']) && ($transactionStatus == 1)) {
                    $response['success'] = true;
                    $response['msg'] = sprintf(lang('CommonMessage.create_record'), lang("Vendor.vendor"));
                } else {
                    $response['success'] = false;
                    $response['msg'] = sprintf(lang('CommonMessage.create_record_error'), lang("Vendor.vendor"));
                }
            }
            echo json_encode($response);
            exit;
        }
    }

    public function delete()
    {
        $this->db->transStart();
        $vendorId = $this->request->getVar('vendor_id');
         if( isReferenceInTable( 'vendor_id','tbl_amc_detail', $vendorId) ||
             isReferenceInTable( 'vendor_id','tbl_service', $vendorId) ||
             isReferenceInTable( 'vendor_id','tbl_visit', $vendorId) ||
             isReferenceInTable( 'vendor_id','tbl_warranty', $vendorId)
             ){
             if(!empty($vendorId)){
                 foreach($vendorId as $documentElement){
                     $deleteDataArray['module'] = 'Vendor';
                     $deleteDataArray['activity'] = "Tried to Delete Vendor ";
                     $deleteDataArray['module_id'] = $documentElement;
                     logActivity('Tried to delete Vendor [VendorID: ' . $documentElement . ']',$this->data['userId'],'Vendor',$documentElement,json_encode($deleteDataArray),'','Vendor',$documentElement);
                 }
             }


             $response['success'] = false;
             $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
             echo json_encode($response);
             exit;
         }
        $vendorData = $this->vendor_model->deleteRecord($vendorId);
        $transactionStatus = $this->db->transComplete();
        if (($vendorData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg'] = sprintf(lang('CommonMessage.delete_record'), lang("Vendor.vendor"));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'), lang("Vendor.vendor"));
        }
        echo json_encode($response);
        exit;
    }

    public function addVendorMobileRow()
    {
        $data['row_number'] = $this->request->getVar("row_number");
        $mobileRow = view('Admin/Vendor/VendorMobileRowView', $data);
        echo $mobileRow;
    }

    public function deleteVendorMobileRow()
    {
        $vendorMobileId = $this->request->getVar('vendor_mobile_id');
        $vendorId = $this->request->getVar('vendor_id');

        $vendorMobileData = $this->vendor_model->deleteVendorMobileRecord($vendorMobileId,$vendorId);

        if ($vendorMobileData) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Vendor.vendor_mobile'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('Vendor.vendor_mobile'));
        }
        echo json_encode($response);
        exit();
    }

    public function view($id = null)
    {
        $vendorId = $this->request->getVar("view_id");
        if($vendorId == "" && $vendorId == null){
            return redirect()->to('Admin/Vendor');
        }
        else {
            $id = $vendorId;
            $filterData = array(
                "vendor_id" => $vendorId
            );
            $data['vendor_data'] = $this->vendor_model->getVendorData($filterData);

            $vendorMobileData = $this->vendor_model->getVendorMobileData(array(
                'vendor_id' => $vendorId,
                'is_multiple' => 1
            ));
            $data['vendor_mobile_data'] = $vendorMobileData;
            $vendorView = view("Admin/Vendor/VendorModelView", $data);

            $response['view_title'] = lang('Vendor.vendor_detail');
            $response['view_detail'] = $vendorView;
            $response['success'] = true;
            echo json_encode($response);
        }
    }

    public function excelExportVendor()
    {
        $fileName ='vendor-' . DATETIMEFORMAT;
        $sheetName = 'Vendor-' . DATEFORMAT;
        $excelHeaderName = 'Vendor';
        $tableData = $this->getVendorListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            lang('Vendor.category'),
            lang('Vendor.vendor_name'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                 $row["category_name"],
                $row["vendor_name"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'D';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        //excelExport($filename,$sheetName,$excelHeaderName,$dataRows,$subTotalCellValueArray,$toColumn,false,array(),array());
        excelExport($excelFilterData);
    }

    public function vendorPdf()
    {
        if(!$this->dt_ci_acl->checkAccess('AMC|pdf')){
            return show_error(NO_ACCESS_SECTION);
        } else {

            $filterData = array(
                'is_multiple' => 1
            );
            $vendorData = $this->vendor_model->getVendorData($filterData);
//          $vendorIdArray = [];
//          if (!empty($vendorData)) {
//              foreach ($vendorData as $vKey => $displayData) {
//                  array_push($vendorIdArray,$displayData['vendor_id']);
//              }
//          }
//          $vendorMobileData = $this->vendor_model->getVendorMobileData(array(
//              'vendor_id' => $vendorIdArray,
//              'is_multiple' => 1
//          ));
//          $vendorMobileDataArray = [];
//          if (isset($vendorMobileData) && !empty($vendorMobileData)) {
//              foreach ($vendorMobileData as  $vendorMobile) {
//                  $vendorMobileDataArray[$vendorMobile['vendor_id']][] = $vendorMobile;
//              }
//          }
//          if (!empty($vendorData)) {
//              foreach ($vendorData as $vKey => $displayData) {
//                  $vendorData[$vKey]['vendor_mobile_data'] = array_key_exists($displayData['vendor_id'], $vendorMobileDataArray) ? $vendorMobileDataArray[$displayData['vendor_id']] : array();
//              }
//          }
            $societyData = $this->society_model->getSocietyData(array(
                "society_id" => $this->session->get('society_id'),
            ));
            $data['society_data'] = $societyData;
//          $getCurrentFinancialYear = currentFinancialYear();
//
//          $financialYearData = array();
//          if($getCurrentFinancialYear != '') {
//              list($fromDate, $toDate) = explode(" - ", $getCurrentFinancialYear);
//              $fromDate = DMYToYMD($fromDate);
//              $toDate = DMYToYMD($toDate);
//              $financialYearData = $this->Mdl_financial_year->getFinancialYearData(array(
//                  "start_date" => $fromDate,
//                  "end_date" => $toDate
//              ));
//          }
            //$data['financial_year_data'] = $financialYearData;
            $data['vendor_data'] = $vendorData;
            $data['name'] = lang("Vendor.vendor_pdf") . ".pdf";
            $printHeader = '';
            $printFooter = '';
            $printFooter = pdfFooter( 0, array());
            $html = view('Admin/Vendor/Pdf/VendorPdfView', $data);
            generate_pdf($html, $data['name'], false, $printFooter, '', $printHeader, '', 'P');

        }


    }

    public function getVendorDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page = $this->request->getVar('page');
        $vendorId = $this->request->getVar('vendor_id');
        $filterData = array(
            'vendor_id' => $vendorId,
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'is_active' => 1,
            'limit' => DATA_LIMIT
        );

        echo $this->vendor_model->getVendor($filterData);
    }
}
