<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\BankModel;
class Bank extends BaseController
{
    protected $bank_model;
    public function __construct() {
        $this->bank_model = new BankModel();
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );
        $data['title'] = 'Bank';
        $data['bank_model_view'] = view('Admin/Bank/BankModalView', $data);
        return $this->dt_ci_template->load("Admin","Bank/BankView",$data);
    }

    public function getBankListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $this->datatables->table("tbl_bank as tt");
        $this->datatables->select("tt.bank_id, tt.bank_name, tt.is_active");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $this->datatables->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by,tt.created_at,tt.updated_at");
        $this->datatables->join("society_user_master_view as tupdate","tupdate.user_society_id = tt.updated_by","left");
        $this->datatables->join("society_user_master_view as tcreate","tcreate.user_society_id = tt.created_by","left");

        $this->datatables->groupBy("tt.bank_id");
        accessFilter($this->datatables, array("society" => "tt.society_id"));
        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "bank_id" => isset($displayData['bank_id']) ? $displayData['bank_id'] : ""
                );
                $data[$key]['action_button'] = bankActionButton($actionButtonFilter);
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
                $data[$key]['created_at'] = isValidDate($displayData['created_at']) ? siteDateFormat($displayData['created_at'],true) : "";
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }
    public function addEdit()
    {
        $this->db->transStart();
        $validation = \Config\Services::validation();
        $bankId = $this->request->getVar('bank_id');
        $bankName = $this->request->getVar('bank_name');
        $isActive = $this->request->getVar('is_active');

        if (isset($bankId) && $bankId == '') {
            $validation->setRule('bank_name', lang('Bank.bank_name'), 'required|combination_unique[tbl_bank.bank_name.'.$this->session->get('society_id').'.]');
        } else {
            $validation->setRule('bank_name', lang('Bank.bank_name'), 'required|edit_unique[tbl_bank.bank_name.' . $bankId . '.'. $this->session->get('society_id').']');
        }


        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {
            $bankUpdateArray = array();
            $bankArray = array(
                'bank_id' => $bankId,
                'bank_name' => $bankName,
                'is_active' => isset($isActive) ? 1 : 0,
                'society_id' => $this->session->get('society_id'),
            );
            if(!empty($bankId)){
                $bankUpdateData = $this->bank_model->getBankData(array(
                    'bank_id' => $bankId,
                ));
                $bankUpdateArray = compareArray($bankArray,$bankUpdateData);
            }

            $bankData = $this->bank_model->insertUpdateRecord($bankArray,'bank_id','tbl_bank', 1,'',array(),array(),$bankUpdateArray);
            $transactionStatus = $this->db->transComplete();
            if (isset($bankId) && $bankId != '') {
                if (($bankData['success']) && ($transactionStatus == 1)) {
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('Bank.bank'));
                } else {
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('Bank.bank'));
                }
            } else {
                if (($bankData['success']) && ($transactionStatus == 1)) {
                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('Bank.bank'));
                } else {
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('Bank.bank'));
                }
            }
            echo json_encode($response);
            exit();
        }

    }

    public function changeStatus()
    {
        $bankId = $this->request->getVar('bank_id');
        $status = $this->request->getVar('status');

        $return = $this->bank_model->statusChange($bankId,$status,'bank_id','tbl_bank');
        if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('Bank.bank'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('Bank.bank'));
        }
        echo json_encode($response);
        exit();
    }


    public function delete()
    {
        $this->db->transStart();
        $bankId = $this->request->getVar('bank_id');
        if (isReferenceInTable('bank_id', 'tbl_bank_account', $bankId) ||
            isReferenceInTable('bank_id', 'tbl_investments', $bankId)
        ) {
            if (!empty($bankId)) {
                foreach ($bankId as $bank) {
                    $deleteDataArray['module'] = 'Bank';
                    $deleteDataArray['activity'] = "Tried to delete Bank ";
                    $deleteDataArray['module_id'] = $bank;
                    logActivity('Tried to delete Bank [BankID: ' . $bank . ']', $this->data['userId'], 'Bank', $bank, json_encode($deleteDataArray), '', 'Bank', $bank);
                }
            }
            $response['success'] = false;
            $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
            echo json_encode($response);
            exit;
        }
        $bankData = $this->bank_model->deleteRecord($bankId);
        $transactionStatus = $this->db->transComplete();
        if (($bankData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg'] = sprintf(lang('CommonMessage.delete_record'), lang('Bank.bank'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'), lang('Bank.bank'));
        }
        echo json_encode($response);
        exit;
    }

    public function getBankDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page            = $this->request->getVar('page');
        $bankId = $this->request->getVar('bank_id');

        $filterData = array(
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT,
            'is_active' => 1,
            'bank_id' => $bankId,

        );
        echo $this->bank_model->getBank($filterData);
    }

    public function excelExportBank()
    {
        $fileName ='Bank-' . DATETIMEFORMAT;
        $sheetName = 'Bank-' . DATEFORMAT;
        $excelHeaderName = 'Bank';
        $tableData = $this->getBankListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            lang('Bank.bank'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                $row["bank_name"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'C';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }
}
