<?php

namespace App\Controllers\Admin;

use CodeIgniter\RESTful\ResourceController;

class TenantApiController extends ResourceController
{
    
    protected $tenantDB;

    public function initController(\CodeIgniter\HTTP\RequestInterface $request, 
                                    \CodeIgniter\HTTP\ResponseInterface $response, 
                                    \Psr\Log\LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);

        $societyId = $this->request->getGet('society_id') 
                    ?? $this->request->getPost('society_id') 
                    ?? $this->request->getHeaderLine('society_id');

        printArray($societyId,1);

        $centralDB = \Config\Database::connect(); // Default central DB
        if ($societyId) {
            $society = $centralDB
                ->table('tbl_society')
                ->where('society_id', $societyId)
                ->get()
                ->getRow();

            if ($society) {
                $tenantConfig = [
                    'hostname' => $society->db_host,
                    'username' => $society->db_user,
                    'password' => $society->db_pass,
                    'database' => $society->db_name,
                    'DBDriver' => 'MySQLi',
                    'DBPrefix' => '',
                    'pConnect' => false,
                    'DBDebug'  => (ENVIRONMENT !== 'production'),
                    'charset'  => 'utf8',
                    'DBCollat' => 'utf8_general_ci',
                ];

                $this->tenantDB = \Config\Database::connect($tenantConfig, false);
            }
        }
    }
}
