<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\TagAssignModel;
class TagAssign extends BaseController
{
    protected $tag_assign_model;
    public function __construct() {
        $this->tag_assign_model = new TagAssignModel();
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );
        $data['title'] = 'Tag Assign';
        return $this->dt_ci_template->load("Admin","TagAssign/TagAssignView",$data);
    }
    public function manage($tagAssignId = '')
	{

		$data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "vendor/libs/flatpickr/flatpickr.js",
            "js/additional_methods.min.js"
        );

        if ($tagAssignId != '') {
			$filterData = array(
				"tag_assign_id" => $tagAssignId
			);
			$data['tag_assign_data'] = $this->tag_assign_model->getTagAssignData($filterData);
		}
		if ($tagAssignId != '') {
			$data['title'] = 'Edit Tag Assign';
		} else {
			$data['title'] = 'Add Tag Assign';
		}
        if ((isset($data['tag_assign_data']['society_id']) && $data['tag_assign_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/TagAssign');
        }
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Ajax)? $select2Ajax : array());
		return $this->dt_ci_template->load("Admin","TagAssign/TagAssignManageView",$data);
	}

    public function getTagAssignListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $this->datatables->table("tbl_tag_assign as tta");
        $this->datatables->select("tta.tag_assign_id,tta.tag_id,tta.flat_id,tt.tag_no,tta.issue_date");
		$this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tta.updated_at");
        $this->datatables->select("concat(COALESCE(tto.tower_name,''),'-',COALESCE(tf.flat_no,'') ) as flat_no");
        $this->datatables->join("society_user_master_view as tupdate","tupdate.user_society_id = tta.updated_by","left");
        $this->datatables->join("tbl_flat as tf","tf.flat_id = tta.flat_id","left");
        $this->datatables->join("tbl_tower as tto","tto.tower_id = tf.tower_id","left");
        $this->datatables->join("tbl_tag as tt","tt.tag_id = tta.tag_id","left");
        $this->datatables->groupBy("tta.tag_assign_id");
        accessFilter($this->datatables, array("society" => "tta.society_id"));

        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "tag_assign_id" => isset($displayData['tag_assign_id']) ? $displayData['tag_assign_id'] : "",
                );
                $data[$key]['action_button'] = tagAssignActionButton($actionButtonFilter);
				$data[$key]['issue_date'] = isValidDate($displayData['issue_date']) ? siteDateFormat($displayData['issue_date']) : "";
				$data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
                $data[$key]['excel_flat_no'] = isset($displayData['flat_no']) ?  $displayData['flat_no'] : "";
                $data[$key]['flat_no'] = isset($displayData['flat_no']) ?  flatDocumentToHtml($displayData['flat_no'],$displayData['flat_id']) : "";
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }
    public function save()
    {
        $this->db->transStart();
        $validation = \Config\Services::validation();

        $tagAssignId = $this->request->getVar('tag_assign_id');
        $tagId = $this->request->getVar('tag_id');
        $flatId = $this->request->getVar('flat_id');
        $issueDate = $this->request->getVar('issue_date');

        $filterData = array(
            "flat_id" => $flatId,
            "tag_id" => $tagId,
            'tag_assign_id_not' => $tagAssignId,
            'society_id' => $this->session->get('society_id'),
            "is_multiple" => 1
        );
        $tagAssignData = $this->tag_assign_model->getTagAssignData($filterData);
        // printArray($tagAssignData,1);       
        // die();
        if(!empty($tagAssignData)){
            $response['success'] = false;
            $response['msg'] = "Can/t Select Same Tag For Same Flat";
            echo json_encode($response);
            die();
        }

		$validation->setRule('tag_id', lang('TagAssign.tag'), 'required');
		$validation->setRule('flat_id', lang('TagAssign.flat'), 'required');
		$validation->setRule('issue_date', lang('TagAssign.issue_date'), 'required');

        // if (isset($tagId) && $tagId == '') {
        //     $validation->setRule('tag_no', lang('Tag.tag_no'), 'required|is_unique[tbl_tag.tag_no]',array('is_unique' => 'This {field} Already Exists'));
        // } else {
        //     $validation->setRule('tag_no', lang('Tag.tag_no'), 'required|is_unique[tbl_tag.tag_no,tag_id,'.$tagId.']',array('is_unique' => 'This {field} Already Exists'));
        // }

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

        	// $tagForNoCheck = $this->tag_assign_model->checkTagNoExist(array('tag_id' => $tagId,'tag_no' => $tagNo,'tag_for' => $tagFor));

            $tagAssignUpdateArray = array();
			$tagAssignArray = array(
				'tag_assign_id' => $tagAssignId,
				'tag_id' => $tagId,
				'flat_id' => $flatId,
				'issue_date' => DMYToYMD($issueDate),
                'society_id' => $this->session->get('society_id'),
			);
			if(!empty($tagAssignId)){
                $tagAssignUpdateData = $this->tag_assign_model->getTagAssignData(array(
                    'tag_assign_id' => $tagAssignId,
                ));
                $tagAssignUpdateArray = compareArray($tagAssignArray,$tagAssignUpdateData);
            }
			$tagAssignData = $this->tag_assign_model->insertUpdateRecord($tagAssignArray, 'tag_assign_id', 'tbl_tag_assign', 1,'',array(),array(),$tagAssignUpdateArray);
			$lastTagAssignId = $tagAssignData['lastInsertedId'];
            $transactionStatus = $this->db->transComplete();
            if (isset($tagAssignId) && $tagAssignId != '') {
                if (($tagAssignData['success']) && ($transactionStatus == 1)) {
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('TagAssign.tag_assign'));
                } else {
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('TagAssign.tag_assign'));
                }
            } else {
                if (($tagAssignData['success']) && ($transactionStatus == 1)) {
                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('TagAssign.tag_assign'));
                } else {
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('TagAssign.tag_assign'));
                }
            }
            echo json_encode($response);
            exit();
        }

    }

    // public function changeStatus()
    // {
    //     $tagId = $this->request->getVar('tag_id');
    //     $status = $this->request->getVar('status');

    //     $return = $this->tag_assign_model->statusChange($tagId,$status,'tag_id','tbl_tag');
    //     if ($return == 1) {
    //         $response['success'] = true;
    //         $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('Tag.tag'));
    //     } else {
    //         $response['success'] = false;
    //         $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('Tag.tag'));
    //     }
    //     echo json_encode($response);
    //     exit();
    // }


    public function delete()
    {
        $this->db->transStart();
        $tagAssignId = $this->request->getVar('tag_assign_id');
        //  if( isReferenceInTable( 'tag_id','tbl_rentals', $tagId)||
        //      isReferenceInTable( 'tag_id','tbl_complain', $tagId)
        //  ) {

        //  	if(!empty($tagId)){
		// 	 	foreach($tagId as $tag){
		// 	 		$deleteDataArray['module'] = 'Tag';
        //      		$deleteDataArray['activity'] = "Tag Deleted";
		// 	 		$deleteDataArray['module_id'] = $tag;
		// 	 		logActivity('Tag Deleted [TagID: ' . $tag . ']',$this->data['userId'],'Tag',$tag,json_encode($deleteDataArray),'','Tag',$tag);
		// 	 	}
		// 	 }
        //      $response['success'] = false;
        //      $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
        //      echo json_encode($response);
        //      exit;
        //  }
        $tagAssignData = $this->tag_assign_model->deleteRecord($tagAssignId);
        $transactionStatus = $this->db->transComplete();
        if (($tagAssignData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('TagAssign.tag_assign'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang('TagAssign.tag_assign'));
        }
        echo json_encode($response);
        exit;
    }

    public function getTagAssignDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page            = $this->request->getVar('page');
        $tagAssignId = $this->request->getVar('tag_assign_id');

        $filterData = array(
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT,
            'is_active' => 1,
            'tag_assign_id' => $tagAssignId,

        );
        echo $this->tag_assign_model->getTagAssign($filterData);
    }

    public function excelExportTagAssign()
    {
        $fileName ='tag-assign-' . DATETIMEFORMAT;
        $sheetName = 'Tag-Assign-' . DATEFORMAT;
        $excelHeaderName = 'Tag Assign';
        $tableData = $this->getTagAssignListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            lang('TagAssign.flat_no'),
            lang('TagAssign.tag_no'),
            lang('TagAssign.issue_date'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                $row["excel_flat_no"],
                $row["tag_no"],
                $row["issue_date"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'E';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }
}
