<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\TagModel;
class Tag extends BaseController
{
    protected $tag_model;
    public function __construct() {
        $this->tag_model = new TagModel();
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );
        $data['title'] = 'Tag';
        return $this->dt_ci_template->load("Admin","Tag/TagView",$data);
    }

    public function manage($tagId = '')
	{

		$data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );

        if ($tagId != '') {
			$filterData = array(
				"tag_id" => $tagId
			);
			$data['tag_data'] = $this->tag_model->getTagData($filterData);
		}
		if ($tagId != '') {
			$data['title'] = 'Edit Tag';
		} else {
			$data['title'] = 'Add Tag';
		}
        if ((isset($data['tag_data']['society_id']) && $data['tag_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/Tag');
        }
		return $this->dt_ci_template->load("Admin","Tag/TagManageView",$data);
	}

    public function getTagListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $this->datatables->table("tbl_tag as tt");
        $this->datatables->select("tt.tag_id,tt.tag_no,tt.tag_type");
		$this->datatables->select("tt.is_active,concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tt.updated_at");
        $this->datatables->join("society_user_master_view as tupdate","tupdate.user_society_id = tt.updated_by","left");
        $this->datatables->groupBy("tt.tag_id");
        accessFilter($this->datatables, array("society" => "tt.society_id"));

        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "tag_id" => isset($displayData['tag_id']) ? $displayData['tag_id'] : "",
                );
                $data[$key]['action_button'] = tagActionButton($actionButtonFilter);
                $data[$key]['tag_type'] = underscoreToUcWord($displayData['tag_type']);
				$data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }
    public function save()
    {
        $this->db->transStart();
        $validation = \Config\Services::validation();

        $tagId = $this->request->getVar('tag_id');
        $tagType = $this->request->getVar('tag_type');
        $tagNo = $this->request->getVar('tag_no');
        $isActive = $this->request->getVar('is_active');

		$validation->setRule('tag_type', lang('Tag.tag_type'), 'required');

        // if (isset($tagId) && $tagId == '') {
        //     $validation->setRule('tag_no', lang('Tag.tag_no'), 'required|is_unique[tbl_tag.tag_no]',array('is_unique' => 'This {field} Already Exists'));
        // } else {
        //     $validation->setRule('tag_no', lang('Tag.tag_no'), 'required|is_unique[tbl_tag.tag_no,tag_id,'.$tagId.']',array('is_unique' => 'This {field} Already Exists'));
        // }

        $filterData = array(
            "tag_id_not" => $tagId,
            "tag_no" => $tagNo,
            "tag_type" => $tagType,
            "society_id" => $this->session->get('society_id'),
            "is_multiple" => 1
        );
        $tagData = $this->tag_model->getTagData($filterData);
        if(!empty($tagData)){
            $response['success'] = false;
            //$response['msg'] = "Can/t Select Same Area For Same Flat";
            $response['msg'] = "Tag No. Already Exists!!";
            echo json_encode($response);
            die();
        }
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

        	// $tagForNoCheck = $this->tag_model->checkTagNoExist(array('tag_id' => $tagId,'tag_no' => $tagNo,'tag_for' => $tagFor));

            $tagUpdateArray = array();
			$tagArray = array(
				'tag_id' => $tagId,
				'tag_type' => $tagType,
				'tag_no' => $tagNo,
				'is_active' => isset($isActive) ? 1 : 0,
                'society_id' => $this->session->get('society_id'),
			);
			if(!empty($tagId)){
                $tagUpdateData = $this->tag_model->getTagData(array(
                    'tag_id' => $tagId,
                ));
                $tagUpdateArray = compareArray($tagArray,$tagUpdateData);
            }
			$tagData = $this->tag_model->insertUpdateRecord($tagArray, 'tag_id', 'tbl_tag', 1,'',array(),array(),$tagUpdateArray);
			$lastTagId = $tagData['lastInsertedId'];
            $transactionStatus = $this->db->transComplete();
            if (isset($tagId) && $tagId != '') {
                if (($tagData['success']) && ($transactionStatus == 1)) {
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('Tag.tag'));
                } else {
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('Tag.tag'));
                }
            } else {
                if (($tagData['success']) && ($transactionStatus == 1)) {
                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('Tag.tag'));
                } else {
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('Tag.tag'));
                }
            }
            echo json_encode($response);
            exit();
        }

    }

    public function changeStatus()
    {
        $tagId = $this->request->getVar('tag_id');
        $status = $this->request->getVar('status');

        $return = $this->tag_model->statusChange($tagId,$status,'tag_id','tbl_tag');
        if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('Tag.tag'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('Tag.tag'));
        }
        echo json_encode($response);
        exit();
    }


    public function delete()
    {
        $this->db->transStart();
        $tagId = $this->request->getVar('tag_id');
        if( isReferenceInTable( 'tag_id','tbl_tag_assign', $tagId)
        ) {
         	if(!empty($tagId)){
			 	foreach($tagId as $tag){
			 		$deleteDataArray['module'] = 'Tag';
             		$deleteDataArray['activity'] = "Tried to delete Tag";
			 		$deleteDataArray['module_id'] = $tag;
			 		logActivity('Tried to delete Tag [TagID: ' . $tag . ']',$this->data['userId'],'Tag',$tag,json_encode($deleteDataArray),'','Tag',$tag);
			 	}
			}
            $response['success'] = false;
            $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
            echo json_encode($response);
            exit;
        }
        $tagData = $this->tag_model->deleteRecord($tagId);
        $transactionStatus = $this->db->transComplete();
        if (($tagData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Tag.tag'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang('Tag.tag'));
        }
        echo json_encode($response);
        exit;
    }

    public function getTagDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page            = $this->request->getVar('page');
        $tagId = $this->request->getVar('tag_id');

        $filterData = array(
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT,
            'is_active' => 1,
            'tag_id' => $tagId,

        );
        echo $this->tag_model->getTag($filterData);
    }

    public function excelExportTag()
    {
        $fileName ='tag-' . DATETIMEFORMAT;
        $sheetName = 'Tag-' . DATEFORMAT;
        $excelHeaderName = 'Tag';
        $tableData = $this->getTagListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            lang('Tag.tag_type'),
            lang('Tag.tag_no'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                $row["tag_type"],
                $row["tag_no"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'D';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }
}
