<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\StatusModel;
class Status extends BaseController
{
    protected $status_model;
    public function __construct() {
        $this->status_model = new StatusModel();
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );
        $data['title'] = 'Status';
        return $this->dt_ci_template->load("Admin","Status/StatusView",$data);
    }

    public function manage($statusId = '')
	{

		$data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );

        if ($statusId != '') {
			$filterData = array(
				"status_id" => $statusId
			);
			$data['status_data'] = $this->status_model->getStatusData($filterData);
		}
		if ($statusId != '') {
			$data['title'] = 'Edit Status';
		} else {
			$data['title'] = 'Add Status';
		}
		return $this->dt_ci_template->load("Admin","Status/StatusManageView",$data);
	}

    public function getStatusListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $this->datatables->table("tbl_status as ts");
        $this->datatables->select("ts.status_id,ts.status_name,ts.status_for,ts.is_open, ts.is_close,ts.is_default,ts.is_resolved");
		$this->datatables->select("ts.is_active,concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,ts.updated_at");
        $this->datatables->join("society_user_master_view as tupdate","tupdate.user_society_id = ts.updated_by","left");
        $this->datatables->groupBy("ts.status_id");
        accessFilter($this->datatables, array("society" => "ts.society_id"));
        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "status_id" => isset($displayData['status_id']) ? $displayData['status_id'] : "",
                );
                $data[$key]['action_button'] = statusActionButton($actionButtonFilter);
                $data[$key]['status_for'] = underscoreToUcWord($displayData['status_for']);
				$data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";

				$data[$key]['excel_is_open'] = ($displayData['is_open'] == 1) ? "Yes" : "No";
				$data[$key]['excel_is_default'] = ($displayData['is_default'] == 1) ? "Yes" : "No";
				$data[$key]['excel_is_close'] = ($displayData['is_close'] == 1) ? "Yes" : "No";
				$data[$key]['excel_is_resolved'] = ($displayData['is_resolved'] == 1) ? "Yes" : "No";
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }
    public function save()
    {
        $this->db->transStart();
        $this->centralDB->transStart();
        $validation = \Config\Services::validation();

        $statusId = $this->request->getVar('status_id');
        $statusFor = $this->request->getVar('status_for');
        $statusName = $this->request->getVar('status_name');
        $isActive = $this->request->getVar('is_active');
        $isOpen = $this->request->getVar('is_open');
		$isClose = $this->request->getVar('is_close');
		$isResolved = $this->request->getVar('is_resolved');
		$isDefault = $this->request->getVar('is_default');

		$validation->setRule('status_for', lang('Society.status_for'), 'required');
		$validation->setRule('status_name', lang('Society.status_name'), 'required');
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

        	$statusForNameCheck = $this->status_model->checkStatusNameExist(array('status_id' => $statusId,'status_name' => $statusName,'status_for' => $statusFor));

            if(!empty($statusForNameCheck)){
                $response['success'] = false;
                $response['msg'] = "This Status For ".underscoreToUcWord($statusForNameCheck['status_for']). " Status Name ". $statusName. " Already Exists";
                echo json_encode($response);
                exit();
            }
            if(isset($isDefault)) {
                $updateData = array(
                    "is_default" => 0
                );
                $builder = $this->db->table('tbl_status');
                $builder->where('status_for', $statusFor);
                $builder->update( $updateData);
            }

            if(isset($isOpen)) {
                $updateData = array(
                    "is_open" => 0
                );
                $builder = $this->db->table('tbl_status');
                $builder->where('status_for', $statusFor);
                $builder->update( $updateData);
            }

            if(isset($isClose)) {
                $updateData = array(
                    "is_close" => 0
                );
                $builder = $this->db->table('tbl_status');
                $builder->where('status_for', $statusFor);
                $builder->update( $updateData);
            }

            if(isset($isResolved)) {
                $updateData = array(
                    "is_resolved" => 0
                );
                $builder = $this->db->table('tbl_status');
                $builder->where('status_for', $statusFor);
                $builder->update( $updateData);
            }

            $statusUpdateArray = array();
			$statusArray = array(
				'status_id' => $statusId,
				'status_name' => $statusName,
				'status_for' => $statusFor,
				'is_active' => isset($isActive) ? 1 : 0,
				'is_open' => isset($isOpen) ? 1 : 0,
				'is_default' => isset($isDefault) ? 1 : 0,
				'is_close' => isset($isClose) ? 1 : 0,
				'is_resolved' => isset($isResolved) ? 1 : 0,
                'society_id' => $this->session->get('society_id'),
			);
			if(!empty($statusId)){
                $statusUpdateData = $this->status_model->getStatusData(array(
                    'status_id' => $statusId,
                ));
                $statusUpdateArray = compareArray($statusArray,$statusUpdateData);
            }
			$statusData = $this->status_model->insertUpdateRecord($statusArray, 'status_id', 'tbl_status', 1,'',array(),array(),$statusUpdateArray);
			$lastStatusId = $statusData['lastInsertedId'];
            $transactionStatus = $this->db->transComplete();
            $transactionCentralStatus = $this->centralDB->transComplete();
            if (isset($statusId) && $statusId != '') {
                if (($statusData['success']) && ($transactionStatus == 1 && $transactionCentralStatus == 1)) {
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('Status.status'));
                } else {
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('Status.status'));
                }
            } else {
                if (($statusData['success']) && ($transactionStatus == 1 && $transactionCentralStatus == 1)) {
                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('Status.status'));
                } else {
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('Status.status'));
                }
            }
            echo json_encode($response);
            exit();
        }

    }

    public function changeStatus()
    {
        $statusId = $this->request->getVar('status_id');
        $status = $this->request->getVar('status');

        $return = $this->status_model->statusChange($statusId,$status,'status_id','tbl_status');
        if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('Status.status'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('Status.status'));
        }
        echo json_encode($response);
        exit();
    }


    public function delete()
    {
        $this->db->transStart();
        $statusId = $this->request->getVar('status_id');
         if( isReferenceInTable( 'status_id','tbl_rentals', $statusId)||
            isReferenceInTable( 'status_id','tbl_complain_history', $statusId)||
            isReferenceInTable( 'status_id','tbl_sos_emergency', $statusId)||
            isReferenceInTable( 'status_id','tbl_complain', $statusId)
         ) {

         	if(!empty($statusId)){
			 	foreach($statusId as $status){
			 		$deleteDataArray['module'] = 'Status';
             		$deleteDataArray['activity'] = "Status Deleted";
			 		$deleteDataArray['module_id'] = $status;
			 		logActivity('Status Deleted [StatusID: ' . $status . ']',$this->data['userId'],'Status',$status,json_encode($deleteDataArray),'','Status',$status);
			 	}
			 }
             $response['success'] = false;
             $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
             echo json_encode($response);
             exit;
         }
        $statusData = $this->status_model->deleteRecord($statusId);
        $transactionStatus = $this->db->transComplete();
        if (($statusData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Status.status'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang('Status.status'));
        }
        echo json_encode($response);
        exit;
    }

    public function getStatusDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page            = $this->request->getVar('page');
        $statusId = $this->request->getVar('status_id');
        $statusFor = $this->request->getVar('status_for');

        $filterData = array(
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT,
            'is_active' => 1,
            'status_id' => $statusId,
            'status_for' => $statusFor,

        );
        echo $this->status_model->getStatus($filterData);
    }

    public function excelExportStatus()
    {
        $fileName ='status-' . DATETIMEFORMAT;
        $sheetName = 'Status-' . DATEFORMAT;
        $excelHeaderName = 'Status';
        $tableData = $this->getStatusListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            lang('Status.status'),
            lang('Status.is_default'),
            lang('Status.is_open'),
            lang('Status.is_close'),
            lang('Status.is_resolved'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                $row["status_name"],
                $row["is_default"],
                $row["is_open"],
                $row["is_close"],
                $row["is_resolved"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'G';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }
}
