<?php
namespace App\Controllers\Admin;

use App\Models\SosEmergencyModel;
use CodeIgniter\Controller;
class SosEmergency extends BaseController
{
    protected $sos_emergency_model;
    public function __construct() {
        $this->sos_emergency_model = new SosEmergencyModel;
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );
        $data['title'] = 'SosEmergency';
        return $this->dt_ci_template->load("Admin","SosEmergency/SosEmergencyView",$data);
    }

    public function getSosEmergencyListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $this->datatables->table("tbl_sos_emergency as tse");
        $this->datatables->select("tse.sos_emergency_id,tse.is_deleted,tst.status_name,tc.category_name");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tse.updated_at");
        $this->datatables->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by,tse.created_at");
        $this->datatables->select("GROUP_CONCAT(distinct(tsen.sos_emergency_type) SEPARATOR ', ') as sos_emergency_type");

        $this->datatables->select("(select count(*) from tbl_notification as tn where tn.type_id = tse.sos_emergency_id AND tn.type = 'sos_emergency') as total_notification");

        $this->datatables->select("(select count(*) from tbl_notification as tn where tn.type_id = tse.sos_emergency_id AND tn.type = 'sos_emergency' AND tn.action_type = 'accept') as total_accept");

        $this->datatables->select("(select count(*) from tbl_notification as tn where tn.type_id = tse.sos_emergency_id AND tn.type = 'sos_emergency' AND tn.action_type = 'reject') as total_reject");


        $this->datatables->join("society_user_master_view as tupdate","tupdate.user_society_id = tse.updated_by","left");
        $this->datatables->join("society_user_master_view as tcreate","tcreate.user_society_id = tse.created_by","left");
        $this->datatables->join("tbl_category as tc","tc.category_id = tse.category_id","left");
        $this->datatables->join("tbl_sos_emergency_notification as tsen","tsen.sos_emergency_id = tse.sos_emergency_id","left");
        $this->datatables->join("tbl_status as tst","tst.status_id = tse.status_id","left");
        $this->datatables->groupBy("tse.sos_emergency_id");
        $this->datatables->where("tse.is_deleted = 0");

        accessFilter($this->datatables, array("society" => "tse.society_id"));

        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                // $actionButtonFilter = array(
                //     "sos_emergency_id" => isset($displayData['sos_emergency_id']) ? $displayData['sos_emergency_id'] : ""
                // );
                // $data[$key]['action_button'] = sosActionButton($actionButtonFilter);
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
                $data[$key]['created_at'] = isValidDate($displayData['created_at']) ? siteDateFormat($displayData['created_at'],true) : "";
                $data[$key]['sos_emergency_type'] = isset($displayData['sos_emergency_type']) ? underscoreToUcWord($displayData['sos_emergency_type']) : "";
            }
        }

        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }

    // public function excelExportSosEmergency()
    // {
    //     $fileName ='sos-' . DATETIMEFORMAT;
    //     $sheetName = 'SosEmergency-' . DATEFORMAT;
    //     $excelHeaderName = 'SosEmergency';
    //     $tableData = $this->getSosEmergencyListing(true, $_GET);
    //     $dataRows = array();
    //     $dataRows[] = array(
    //         // lang('SosEmergency.society'),
    //         lang('SosEmergency.sos_emergency_name'),
    //         lang('CommonMessage.common_updated_by'),
    //         lang('CommonMessage.common_updated_at')
    //     );
    //     foreach ($tableData as $row) {
    //         $dataRows[] = array(
    //             // $row["society_name"],
    //             $row["sos_emergency_name"],
    //             $row["excel_tower_name"],
    //             $row["updated_by"],
    //             $row["updated_at"]
    //         );
    //     }
    //     $subTotalCellValueArray = [];
    //     $toColumn = 'D';
    //     $excelFilterData = array(
    //         'file_name' => $fileName,
    //         'sheet_name' => $sheetName,
    //         'excel_header_name' => $excelHeaderName,
    //         'data_row' => $dataRows,
    //         'sub_total_cell_value_array' => $subTotalCellValueArray,
    //         'to_column' => $toColumn,
    //         'skip_header' => false,
    //         'ignore_currency_symbols_sub_total_cell_value_array' => array(),
    //         'row_cell_currency_format' => array()
    //     );
    //     excelExport($excelFilterData);
    // }

}
