<?php
namespace App\Controllers\Admin;

use App\Models\SosModel;
use CodeIgniter\Controller;
class Sos extends BaseController
{
    protected $sos_model;
    public function __construct() {
        $this->sos_model = new SosModel;
        // checkAndCreatePath(THUMBNAIL_SOS_IMAGE_PATH);
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );
        $data['title'] = 'Sos';
        return $this->dt_ci_template->load("Admin","Sos/SosView",$data);
    }

    public function getSosListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $this->datatables->table("tbl_sos as ts");
        $this->datatables->select("ts.sos_id,ts.sos_name,ts.is_active,ts.is_deleted");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,ts.updated_at");
        $this->datatables->join("society_user_master_view as tupdate","tupdate.user_society_id = ts.updated_by","left");
        $this->datatables->groupBy("ts.sos_id");
        $this->datatables->where("ts.is_deleted = 0");

        // accessFilter($this->datatables, array("society" => "ts.society_id"));

        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "sos_id" => isset($displayData['sos_id']) ? $displayData['sos_id'] : ""
                );
                $data[$key]['action_button'] = sosActionButton($actionButtonFilter);
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }

    public function manage($sosId = '')
    {

        $data['extra_js'] = array(
            "js/jquery.form.min.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/bootstrap-datepicker/bootstrap-datepicker.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
        );

        if ($sosId != '') {
            $filterData = array(
                "sos_id" => $sosId
            );
            $data['sos_data'] = $this->sos_model->getSosData($filterData);

            if ((isset($data['sos_data']['is_deleted']) && $data['sos_data']['is_deleted'] != 0)) {
                return redirect()->to('Admin/Sos');
            }

            if (empty($data['sos_data'])) {
                return redirect()->to('Admin/Sos');
            }
        }
        if ($sosId != '') {
            $data['title'] = 'Edit Sos';
        } else {
            $data['title'] = 'Add Sos';
        }
        // if ((isset($data['sos_data']['society_id']) && $data['sos_data']['society_id'] != $this->session->get('society_id'))) {
        //     return redirect()->to('Admin/Sos');
        // }
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Ajax)? $select2Ajax : array());
        $this->dt_ci_template->load("Admin","Sos/SosManageView",$data);
    }

    public function save()
    {
        // printArray($_POST);
        // printArray($_FILES,1);
        $validation = \Config\Services::validation();

        $sosId = $this->request->getVar('sos_id');
        $sosName = $this->request->getVar('sos_name');
        $isActive = $this->request->getVar('is_active');

        $validation->setRule('sos_name', lang('Sos.sos_name'), 'required');

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {
            
            $sosImage = array();
			if (isset($_FILES["sos_image"])) {
				$sosImagePath = SOS_IMAGE_PATH;
				$sosImage = $this->dt_ci_file_upload->uploadFile('sos_image', MAX_IMAGE_SIZE_LIMIT, $sosImagePath, true, true, array('jpeg', 'png', 'jpg', 'JPG'));
				if ($sosImage['success'] == false) {
					$response['success'] = false;
					$response['msg'] = strip_tags($sosImage['message']);
					echo json_encode($response);
					die();
				}
                else{
                    unset($sosImage['success']);
                    $thumbnailResult =  $this->dt_ci_file_upload->ThumbnailUploadFile($sosImage, SOS_IMAGE_PATH, THUMBNAIL_SOS_IMAGE_PATH);
                }
			}

            if ($sosId != '') {
                $sosImageData = $this->sos_model->getSosData(array("sos_id" => $sosId));
                $imageUrl = '';
                if(isset($sosImageData['sos_image']) && $sosImageData['sos_image'] != '') {
                    $imageUrl = SOS_IMAGE_PATH. $sosImageData['sos_image'];
                }
                if (file_exists($imageUrl)) {
                    unlink($imageUrl);
                }

                $thumbnailImageUrl = '';
                if(isset($sosImageData['sos_image']) && $sosImageData['sos_image'] != '') {
                    $thumbnailImageUrl = THUMBNAIL_SOS_IMAGE_PATH. $sosImageData['sos_image'];
                }
                if (file_exists($thumbnailImageUrl)) {
                    unlink($thumbnailImageUrl);
                }
            }

            // printArray($sosImage,1);

            $sosUpdateArray = array();
            if(!empty($sosImage)){
                $sosArray = array(
                    'sos_id' => $sosId,
                    'sos_name' => $sosName,
                    'sos_image' => $sosImage['file_name'],
                    'is_active' => isset($isActive) ? 1 : 0,
                );
            } else {
                $sosArray = array(
                    'sos_id' => $sosId,
                    'sos_name' => $sosName,
                    'is_active' => isset($isActive) ? 1 : 0,
                );
            }

            if(!empty($sosId)){
                $sosUpdateData = $this->sos_model->getSosData(array(
                    'sos_id' => $sosId,
                ));
                $sosUpdateArray = compareArray($sosArray,$sosUpdateData);
            }

            
            $sosData = $this->sos_model->insertUpdateRecord($sosArray,'sos_id','tbl_sos', 1,'',array(),array(),$sosUpdateArray);
            if (isset($sosId) && $sosId != '') {
                if ($sosData['success']) {
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('Sos.sos'));
                } else {
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('Sos.sos'));
                }
            } else {
                if ($sosData['success']) {
                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('Sos.sos'));
                } else {
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('Sos.sos'));
                }
            }
            echo json_encode($response);
            exit();
        }
    }

    public function changeStatus()
    {
        $sosId = $this->request->getVar('sos_id');
        $status = $this->request->getVar('status');

        $return = $this->sos_model->statusChange($sosId,$status,'sos_id','tbl_sos');
        if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('Sos.sos'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('Sos.sos'));
        }
        echo json_encode($response);
        exit();
    }


    public function delete()
    {
        $sosId = $this->request->getVar('sos_id');

        if( isReferenceInTable( 'sos_id','tbl_sos_emergency', $sosId)
        ){
            if(!empty($sosId)){
                foreach($sosId as $sos){
                    $deleteDataArray['module'] = 'Sos';
                    $deleteDataArray['activity'] = "Tried to delete Sos ";
                    $deleteDataArray['module_id'] = $sos;
                    logActivity('Tried to delete Sos [SosID: ' . $sos . ']',$this->data['userId'],'Sos',$sos,json_encode($deleteDataArray),'','Sos',$sos);
                }
            }
            $response['success'] = false;
            $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
            echo json_encode($response);
            exit;
        }

        $userId = $this->data['userId'];

        $sosImageData = $this->sos_model->getSosData(array(
            'sos_id' => $sosId,
            'is_multiple' => 1
        ));

        if(is_array($sosImageData) && !empty($sosImageData)){
            foreach ($sosImageData as $image){
                $fileUrl = '';
                if(isset($image['sos_image']) && $image['sos_image'] != '') {
                    $fileUrl = SOS_IMAGE_PATH . $image['sos_image'];
                }
                if (file_exists($fileUrl)) {
                    unlink($fileUrl);
                }

                $thumbnailFileUrl = '';
                if(isset($image['sos_image']) && $image['sos_image'] != '') {
                    $thumbnailFileUrl = THUMBNAIL_SOS_IMAGE_PATH . $image['sos_image'];
                }
                if (file_exists($thumbnailFileUrl)) {
                    unlink($thumbnailFileUrl);
                }
            }
        }
        
        $sosData = $this->sos_model->deleteRecord($sosId,$userId);
        if ($sosData) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Sos.sos'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang('Sos.sos'));
        }
        echo json_encode($response);
        exit;
    }

    public function getSosDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page            = $this->request->getVar('page');
        $sosId = $this->request->getVar('sos_id');

        $filterData = array(
            'sos_id' => $sosId,
            'is_active' => 1,
            'is_deleted' => 0,
        );
        echo $this->sos_model->getSos($filterData);
    }

    public function view($id = null)
    {
        $sosId = $this->request->getVar("view_id");
        if($sosId == "" && $sosId == null){
            return redirect()->to('Admin/Sos');
        }
        else {
            $id = $sosId;
            $filterData = array(
                "sos_id" => $sosId
            );
            $data['sos_data'] = $this->sos_model->getSosData($filterData);
            $sosView = view("Admin/Sos/SosModelView", $data);
            $response['view_title'] = "Sos Details";
            $response['view_detail'] = $sosView;
            $response['success'] = true;
            echo json_encode($response);
        }
    }

    // public function excelExportSos()
    // {
    //     $fileName ='sos-' . DATETIMEFORMAT;
    //     $sheetName = 'Sos-' . DATEFORMAT;
    //     $excelHeaderName = 'Sos';
    //     $tableData = $this->getSosListing(true, $_GET);
    //     $dataRows = array();
    //     $dataRows[] = array(
    //         // lang('Sos.society'),
    //         lang('Sos.sos_name'),
    //         lang('CommonMessage.common_updated_by'),
    //         lang('CommonMessage.common_updated_at')
    //     );
    //     foreach ($tableData as $row) {
    //         $dataRows[] = array(
    //             // $row["society_name"],
    //             $row["sos_name"],
    //             $row["excel_tower_name"],
    //             $row["updated_by"],
    //             $row["updated_at"]
    //         );
    //     }
    //     $subTotalCellValueArray = [];
    //     $toColumn = 'D';
    //     $excelFilterData = array(
    //         'file_name' => $fileName,
    //         'sheet_name' => $sheetName,
    //         'excel_header_name' => $excelHeaderName,
    //         'data_row' => $dataRows,
    //         'sub_total_cell_value_array' => $subTotalCellValueArray,
    //         'to_column' => $toColumn,
    //         'skip_header' => false,
    //         'ignore_currency_symbols_sub_total_cell_value_array' => array(),
    //         'row_cell_currency_format' => array()
    //     );
    //     excelExport($excelFilterData);
    // }

}
