<?php
namespace App\Controllers\Admin;
use App\Models\AmenitiesModel;
use App\Models\BankAccountModel;
use App\Models\ChargesModel;
use CodeIgniter\Controller;
use App\Models\CommonWebServiceModel;
use App\Models\SocietyModel;
helper('Dt_ci_sms_helper');
class Society extends BaseController
{
    protected $society_model;
    public function __construct() {
        $this->society_model = new SocietyModel();
        $this->bank_account_model = new BankAccountModel();
        $this->amenities_model = new AmenitiesModel();
        $this->charges_model = new ChargesModel();
        $this->common_web_service_model = new CommonWebServiceModel();
        checkAndCreatePath(SOCIETY_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_SOCIETY_IMAGE_PATH);

    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/ckeditor/ckeditor_classic.js",
			"vendor/libs/jquery-timepicker/jquery-timepicker.js",
        );
        $data['title'] = 'Society';
        return $this->dt_ci_template->load("Admin","Society/SocietyView",$data);
    }

    public function manage($societyId = '')
    {
        // return redirect()->to('Admin/Society');

        $data['extra_js'] = array(
            "js/jquery.form.min.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/bootstrap-datepicker/bootstrap-datepicker.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/ckeditor/ckeditor_classic.js",
			"vendor/libs/jquery-timepicker/jquery-timepicker.js",
        );

        if ($societyId != '') {
            $filterData = array(
                "society_id" => $societyId
            );
            $data['society_data'] = $this->society_model->getSocietyData($filterData);

            $data['image_data'] = $this->society_model->getSocietyImageData(array(
				"society_id" => $societyId,
				"is_multiple" => 1
			));

            if (empty($data['society_data'])) {
                return redirect()->to('Admin/Society');
            }
        }
        if ($societyId != '') {
            $data['title'] = 'Edit Society';
        } else {
            $data['title'] = 'Add Society';
        }
        $this->dt_ci_template->load("Admin","Society/SocietyManageView",$data);
    }

    public function getSocietyListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $isSuperAdmin = session('is_super_admin');
        $this->datatables->table(MASTER_DB.".tbl_society as ts");
        $this->datatables->select("ts.society_id, ts.society_name, ts.is_active,ts.form_submit,ts.s_no,ts.tp_no,ts.fp_no,ts.area,ts.taluka,ts.district,ts.registration_no,ts.tan,ts.pan,ts.gst, ts.postal_address,ts.towers,ts.flats,ts.sf_area,ts.updated_at");
        if (!$isSuperAdmin) {
            $this->datatables->select("(select count(*) from tbl_tower as tt where tt.society_id = ts.society_id) as total_tower");
            $this->datatables->select("(select count(*) from tbl_flat as tf where tf.society_id = ts.society_id) as total_flats");
        }
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $this->datatables->join("society_user_master_view as tupdate","tupdate.user_society_id = ts.updated_by","left"); 
        $this->datatables->groupBy("ts.society_id");
        if (!$isSuperAdmin) {
            accessFilter($this->datatables, array("society" => "ts.society_id"));  
        }

        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "society_id" => isset($displayData['society_id']) ? $displayData['society_id'] : "",
                    "is_super_admin" => isset($isSuperAdmin) ? $isSuperAdmin : 0,
                );
                $data[$key]['action_button'] = societyActionButton($actionButtonFilter);
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";

            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }
    public function save()
    {
        $this->db->transStart();
        $validation = \Config\Services::validation();
        $societyId = $this->request->getVar('society_id');
        $societyName = $this->request->getVar('society_name');
        $sNo = $this->request->getVar('s_no');
        $tpNo = $this->request->getVar('tp_no');
        $fpNo = $this->request->getVar('fp_no');
        $area = $this->request->getVar('area');
        $taluka = $this->request->getVar('taluka');
        $district = $this->request->getVar('district');
        $state = $this->request->getVar('state');
        $postalAddress = $this->request->getVar('postal_address');
        $towers = $this->request->getVar('towers');
        $flats = $this->request->getVar('flats');
        $sfArea = $this->request->getVar('sf_area');
        $registrationNo = $this->request->getVar('registration_no');
        $opp = $this->request->getVar('opp');
        $tan = $this->request->getVar('tan');
        $pan = $this->request->getVar('pan');
        $gst = $this->request->getVar('gst');
        $isActive = $this->request->getVar('is_active');

        // if (isset($societyId) && $societyId == '') {
        //     $validation->setRule('society_name', lang('Society.society_name'), 'required|is_unique[tbl_society.society_name]',array('is_unique' => 'This {field} Already Exists'));
        // } else {
        //     $validation->setRule('society_name', lang('Society.society_name'), 'required|is_unique[tbl_society.society_name,society_id,'.$societyId.']',array('is_unique' => 'This {field} Already Exists'));
        // }

        $validation->setRule('society_name', lang('Society.society_name'), 'required');
        $validation->setRule('s_no', lang('Society.s_no'), 'required');
        $validation->setRule('tp_no', lang('Society.tp_no'), 'required');
        $validation->setRule('fp_no', lang('Society.fp_no'), 'required');
        $validation->setRule('area', lang('Society.area'), 'required');
        $validation->setRule('taluka', lang('Society.taluka'), 'required');
        $validation->setRule('district', lang('Society.district'), 'required');
        $validation->setRule('state', lang('Society.state'), 'required');
        $validation->setRule('postal_address', lang('Society.postal_address'), 'required');
        $validation->setRule('towers', lang('Society.towers'), 'required');
        $validation->setRule('flats', lang('Society.flats'), 'required');
        $validation->setRule('sf_area', lang('Society.sf_area'), 'required');
        $validation->setRule('registration_no', lang('Society.registration_no'), 'required');
        $validation->setRule('tan', lang('Society.tan'), 'required');
        $validation->setRule('pan', lang('Society.pan'), 'required');
        $validation->setRule('gst', lang('Society.gst'), 'required');
        $validation->setRule('opp', lang('Society.opp'), 'required');

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

            $existsSocietyData = $this->society_model->getSocietyData(array(
                'society_name' => $societyName,
                'society_id_not' => $societyId,
            ));

            if(!empty($existsSocietyData)){
                $response['success'] = false;
				$response['msg'] = sprintf(lang('CommonMessage.common_already_exists'),lang('Society.society_name'));
				echo json_encode($response);
				exit();
            }

            $societyImage = array();
			if (isset($_FILES["society_image"])) {
				$societyImagePath = SOCIETY_IMAGE_PATH;
				$societyImage = $this->dt_ci_file_upload->UploadMultipleFile('society_image', MAX_IMAGE_SIZE_LIMIT, $societyImagePath, true, true, array('jpeg', 'png', 'jpg', 'JPG'));
				if ($societyImage['success'] == false) {
					$response['success'] = false;
					$response['msg'] = strip_tags($societyImage['message']);
					echo json_encode($response);
					die();
				}
				else{
                    unset($societyImage['success']);
                    $thumbnailResult =  $this->dt_ci_file_upload->ThumbnailMultipleUploadFile($societyImage, SOCIETY_IMAGE_PATH, THUMBNAIL_SOCIETY_IMAGE_PATH);
                }
			}

            if (isset($_FILES["logo"])) {
				$societylogoPath = SOCIETY_IMAGE_PATH;
				$societylogo = $this->dt_ci_file_upload->uploadFile('logo', MAX_IMAGE_SIZE_LIMIT, $societylogoPath, true, true, array('jpeg', 'png', 'jpg', 'JPG'));
				if ($societylogo['success'] == false) {
					$response['success'] = false;
					$response['msg'] = strip_tags($societylogo['message']);
					echo json_encode($response);
					die();
				}
				else{
                    unset($societylogo['success']);
                    $thumbnailResult =  $this->dt_ci_file_upload->ThumbnailUploadFile($societylogo, SOCIETY_IMAGE_PATH, THUMBNAIL_SOCIETY_IMAGE_PATH);
                }
			}


            $societyUpdateArray = array();
            $societyArray = array(
                'society_id' => $societyId,
                'society_name' => $societyName,
                's_no' => $sNo,
                'tp_no' => $tpNo,
                'fp_no' => $fpNo,
                'area' => $area,
                'taluka' => $taluka,
                'district' => $district,
                'state' => $state,
                'postal_address' => $postalAddress,
                'towers' => $towers,
                'flats' => $flats,
                'sf_area' => $sfArea,
                'registration_no' => $registrationNo,
                'tan' => $tan,
                'pan' => $pan,
                'gst' => $gst,
                'opp' => $opp,
                // 'logo' => $societylogo['file_name'],
                'is_active' => isset($isActive) ? 1 : 0,
            );

            if(isset($societylogo) && !empty($societylogo)){
                $societyArray['logo'] = $societylogo['file_name'];
            }
            // printArra

            if(!empty($societyId)){
                $societyUpdateData = $this->society_model->getSocietyData(array(
                    'society_id' => $societyId,
                ));
                $societyUpdateArray = compareArray($societyArray,$societyUpdateData);
            }

            $societyData = $this->society_model->insertUpdateRecord($societyArray,'society_id',MASTER_DB.'.tbl_society', 1,'',array(),array(),$societyUpdateArray);
            $lastSocietyId = $societyData['lastInsertedId'];


            if($lastSocietyId != ''){
                if(isset($societyImage) && count($societyImage) > 0){
                    $batchArray = array();
                    unset($societyImage['success']);
                    foreach ($societyImage as $key => $imageData) {
                        $dataArray = array(
                            'society_image_id' =>   '',
                            'society_id' => $lastSocietyId,
                            'society_image' => isset($imageData['file_name']) ? $imageData['file_name'] : "",
                        );
                        array_push($batchArray, $dataArray);
                    }

                    $societyImageExtraDataArray = array();
                    $societyImageExtraDataArray['module_id'] = $lastSocietyId;
                    $societyImageExtraDataArray['module'] = 'Society Image';
                    $societyImageExtraDataArray['type'] = 'Society';
                    $societyImageExtraDataArray['old_data'] = array();
                    $societyImageExtraDataArray['user_id'] = $this->data['userId'];
                    $societyImageExtraDataArray['society_id'] = $this->session->get('society_id');

					// printArray($batchArray,1);
                    $this->society_model->batchInsert($batchArray, MASTER_DB.'.tbl_society_image',$societyImageExtraDataArray);
                }
			}

            $allPermissionLabel = $this->dt_ci_acl->getPermissableMethods();

            $permissionGuardArray = [];
            $counter = 0;

            foreach ($allPermissionLabel as $key => $permissions) {
                foreach ($permissions as $permission) {
                    foreach ($permission as $action => $label) {
                        $permissionGuardArray[$counter] = $key . "|" . $action;
                        $counter++;
                    }
                }
            }

            if(!empty($societyId) && $societyId != ''){
                $memberGroupData = $this->common_web_service_model->getGroupsData(array(
                    'name' => GUARD_GROUP,
                    'societyId' => $lastSocietyId,
                ));

                if(!empty($memberGroupData)){
                    $groupGuardId = $memberGroupData['id'];
                }
                else{
                    $groupGuardId = '';
                }
            }
            else{
                $groupGuardId = '';
            }

            
            $groupGuardArray = array(
                'id' => $groupGuardId,
                'name' => GUARD_GROUP,
                'description' => GUARD_GROUP,
                'society_id' => $lastSocietyId,
                'permissions' => serialize($permissionGuardArray),
            );
            $this->society_model->insertUpdateRecord($groupGuardArray,'id',MASTER_DB.'.tbl_groups', 1);
            

            $permissionsToCheck = customerAppPermission();
            // Convert associative array keys to "MobileCustomerApp|key"
            $permissionsArray = array_map(fn($key) => "MobileCustomerApp|$key", array_keys($permissionsToCheck));

            if(!empty($societyId) && $societyId != ''){
                $memberGroupData = $this->common_web_service_model->getGroupsData(array(
                    'name' => MEMBER_GROUP,
                    'societyId' => $lastSocietyId,
                ));
                if(!empty($memberGroupData)){
                    $groupId = $memberGroupData['id'];
                }
                else{
                    $groupId = '';
                }
            }
            else{
                $groupId = '';
            }

            $groupMemberArray = array(
                'id' => $groupId,
                'name' => MEMBER_GROUP,
                'description' => MEMBER_GROUP,
                'society_id' => $lastSocietyId,
                'permissions' => serialize($permissionsArray),
            ); 

            $groupMemberData = $this->society_model->insertUpdateRecord($groupMemberArray,'id',MASTER_DB.'.tbl_groups', 1);
            $lastInsertedMemberGroupId = $groupMemberData['lastInsertedId'];

            // if(empty($societyId)){
            //     $resourceTypeInsertArr[] = array(
            //         'resource_type_id' => '',
            //         'resource_type_name' => RESOURCE_TYPE_MEMBER,
            //         'society_id' => $lastSocietyId,
            //         'group_id' => $lastInsertedMemberGroupId,
            //         'is_active' => 1,
            //         'is_show' => 0,
            //         'created_at' => date('Y-m-d H:i:s'),
            //         'created_by' => $this->data['userId'],
            //         'updated_at' => date('Y-m-d H:i:s'),
            //         'updated_by' => $this->data['userId'],
            //     );

            //     $resourceTypeInsertArr[] = array(
            //         'resource_type_id' => '',
            //         'resource_type_name' => RESOURCE_TYPE_MANAGER,
            //         'society_id' => $lastSocietyId,
            //         'group_id' => 0,
            //         'is_active' => 1,
            //         'is_show' => 0,
            //         'created_at' => date('Y-m-d H:i:s'),
            //         'created_by' => $this->data['userId'],
            //         'updated_at' => date('Y-m-d H:i:s'),
            //         'updated_by' => $this->data['userId'],
            //     );

            //     $this->society_model->batchInsert($resourceTypeInsertArr,'tbl_resource_type');
            // }
            $transactionStatus = $this->db->transComplete();
            if (isset($societyId) && $societyId != '') {
                if (($societyData['success']) && ($transactionStatus == 1)) {
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('Society.society'));
                } else {
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('Society.society'));
                }
            } else {
                if (($societyData['success']) && ($transactionStatus == 1)) {
                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('Society.society'));
                } else {
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('Society.society'));
                }
            }
            echo json_encode($response);
            exit();
        }

    }

    public function changeStatus()
    {
        $societyId = $this->request->getVar('society_id');
        $status = $this->request->getVar('status');

        // $status         = ($status == 0) ? 1 : 0;
        $return = $this->society_model->statusChange($societyId,$status,'society_id',MASTER_DB.'.tbl_society');
        if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('Society.society'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('Society.society'));
        }
        echo json_encode($response);
        exit();
    }


    public function delete()
    {
        $this->db->transStart();
        $societyId = $this->request->getVar('society_id');
        if( isReferenceInTable( 'society_id','tbl_amc_detail', $societyId) ||
            isReferenceInTable( 'society_id','tbl_amenities', $societyId) ||
            isReferenceInTable( 'society_id','tbl_area', $societyId) ||
            isReferenceInTable( 'society_id','tbl_bookmark', $societyId) ||
            isReferenceInTable( 'society_id','tbl_banner', $societyId) ||
            isReferenceInTable( 'society_id','tbl_budget', $societyId) ||
            isReferenceInTable( 'society_id','tbl_booking', $societyId) ||
            isReferenceInTable( 'society_id','tbl_bank_account', $societyId) ||
            isReferenceInTable( 'society_id','tbl_broker_society', $societyId) ||
            isReferenceInTable( 'society_id','tbl_user_society', $societyId) ||
            isReferenceInTable( 'society_id','tbl_common_area', $societyId) ||
            isReferenceInTable( 'society_id','tbl_material', $societyId) ||
            isReferenceInTable( 'society_id','tbl_common_keys', $societyId) ||
            isReferenceInTable( 'society_id','tbl_emergency_number', $societyId) ||
            isReferenceInTable( 'society_id','tbl_event', $societyId) ||
            isReferenceInTable( 'society_id','tbl_event_booking', $societyId) ||
            isReferenceInTable( 'society_id','tbl_faq', $societyId) ||
            isReferenceInTable( 'society_id','tbl_gate', $societyId) ||
            isReferenceInTable( 'society_id','tbl_generator', $societyId) ||
            isReferenceInTable( 'society_id','tbl_generator_reading', $societyId) ||
            isReferenceInTable( 'society_id','tbl_item', $societyId) ||
            isReferenceInTable( 'society_id','tbl_item_balance', $societyId) ||
            isReferenceInTable( 'society_id','tbl_item_ledger', $societyId) ||
            isReferenceInTable( 'society_id','tbl_key_issue', $societyId) ||
            isReferenceInTable( 'society_id','tbl_account', $societyId) ||
            isReferenceInTable( 'society_id','tbl_sub_account', $societyId) ||
            isReferenceInTable( 'society_id','tbl_complain', $societyId) ||
            isReferenceInTable( 'society_id','tbl_flat', $societyId) ||
            isReferenceInTable( 'society_id','tbl_intercom', $societyId) ||
            isReferenceInTable( 'society_id','tbl_investments', $societyId) ||
            isReferenceInTable( 'society_id','tbl_management_committee', $societyId) ||
            isReferenceInTable( 'society_id','tbl_meeting', $societyId) ||
            isReferenceInTable( 'society_id','tbl_notice', $societyId) ||
            isReferenceInTable( 'society_id','tbl_organic_waste_record', $societyId) ||
            isReferenceInTable( 'society_id','tbl_tag', $societyId) ||
            isReferenceInTable( 'society_id','tbl_poll', $societyId) ||
            isReferenceInTable( 'society_id','tbl_visit', $societyId) ||
            isReferenceInTable( 'society_id','tbl_visitor', $societyId) ||
            isReferenceInTable( 'society_id','tbl_warranty', $societyId) ||
            isReferenceInTable( 'society_id','tbl_management_committee_responsibilities', $societyId) ||
            isReferenceInTable( 'society_id','tbl_men_power_attendance', $societyId) ||
            isReferenceInTable( 'society_id','tbl_ownership_flat', $societyId) ||
            isReferenceInTable( 'society_id','tbl_rentals', $societyId) ||
            isReferenceInTable( 'society_id','tbl_service', $societyId) ||
            isReferenceInTable( 'society_id','tbl_resource', $societyId) ||
            isReferenceInTable( 'society_id','tbl_time_slot', $societyId) ||
            isReferenceInTable( 'society_id','tbl_tower', $societyId) ||
            isReferenceInTable( 'society_id','tbl_vendor', $societyId) ||
            isReferenceInTable( 'society_id','tbl_charges', $societyId) ||
            isReferenceInTable( 'society_id','tbl_water_meter_reading', $societyId) ||
            isReferenceInTable( 'society_id','tbl_water_tank', $societyId) ||
            isReferenceInTable( 'society_id','tbl_manufacturer', $societyId) ||
            isReferenceInTable( 'society_id','tbl_parking_slot', $societyId)
        ){

            if(!empty($societyId)){
                foreach($societyId as $society){
                    $deleteDataArray['module'] = 'Society';
                    $deleteDataArray['activity'] = "Tried to delete Society ";
                    $deleteDataArray['module_id'] = $society;
                    logActivity('Tried to delete Society [SocietyID: ' . $society . ']',$this->data['userId'],'Society',$society,json_encode($deleteDataArray),'','Society',$society);
                }
            }

            $response['success'] = false;
            $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
            echo json_encode($response);
            exit;
        }

        $imageData = $this->society_model->getSocietyImageData(array(
            "society_id" => $societyId,
            "is_multiple" =>1,
        ));
        if(is_array($imageData) && !empty($imageData)){
            foreach ($imageData as $image){
                $FileUrl = '';
                if(isset($image['society_image']) && $image['society_image'] != '') {
                    $FileUrl = SOCIETY_IMAGE_PATH . $image['society_image'];
                }
                if (file_exists($FileUrl)) {
                    unlink($FileUrl);
                }
                $thumbnailFileUrl = '';
                if(isset($image['society_image']) && $image['society_image'] != '') {
                    $thumbnailFileUrl = THUMBNAIL_SOCIETY_IMAGE_PATH . $image['society_image'];
                }
                if (file_exists($thumbnailFileUrl)) {
                    unlink($thumbnailFileUrl);
                }
            }
        }


        $societyData = $this->society_model->deleteRecord($societyId);
        $transactionStatus = $this->db->transComplete();
        if (($societyData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Society.society'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang('Society.society'));
        }
        echo json_encode($response);
        exit;
    }

    public function getSocietyDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page            = $this->request->getVar('page');
        $societyId = $this->request->getVar('society_id');

        $filterData = array(
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT,
            'is_active' => 1,
            'society_id' => $societyId,

        );
        echo $this->society_model->getSociety($filterData);
    }

    public function view($id = null)
    {
        $societyId = $this->request->getVar("view_id");

        if($societyId == "" && $societyId == null){
            return redirect()->to('Admin/Society');
        }
        else {
            $id = $societyId;
            $filterData = array(
                "society_id" => $societyId
            );
            $data['society_data'] = $this->society_model->getSocietyData($filterData);
            // printArray($data['society_data'],1);
            $societyView = view("Admin/Society/SocietyModelView", $data);
            $response['view_title'] = "Society Details";
            $response['view_detail'] = $societyView;
            $response['success'] = true;
            echo json_encode($response);
        }
    }

    public function excelExportSociety()
    {
        $fileName ='society-' . DATETIMEFORMAT;
        $sheetName = 'Society-' . DATEFORMAT;
        $excelHeaderName = 'Society';
        $tableData = $this->getSocietyListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            lang('Society.society'),
            lang('Society.s_no'),
            lang('Society.tp_no'),
            lang('Society.fp_no'),
            lang('Society.area'),
            lang('Society.taluka'),
            lang('Society.district'),
            lang('Society.postal_address'),
            lang('Society.towers'),
            lang('Society.flats'),
            lang('Society.sf_area'),
            lang('Society.registration_no'),
            lang('Society.tan'),
            lang('Society.pan'),
            lang('Society.gst'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                $row["society_name"],
                $row["s_no"],
                $row["tp_no"],
                $row["fp_no"],
                $row["area"],
                $row["taluka"],
                $row["district"],
                $row["postal_address"],
                $row["towers"],
                $row["flats"],
                $row["sf_area"],
                $row["registration_no"],
                $row["tan"],
                $row["pan"],
                $row["gst"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'Q';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }

    public function pdf($id = null, $view = null, $save_bufffer = null,$zipPdf = 0)
    {
        if(empty($id)){
            $response['success'] = false;
            $response['msg'] = lang('Society.society_data_required');
            echo json_encode($response);
            exit;
        }
        $filterData = array(
            "society_id" => $id,
            // 'is_multiple' => 1
        );
        $societyData = $this->society_model->getSocietyData($filterData); 
        if(!empty($societyData)) {

            $bankData = $this->bank_account_model->getBankAccountData(array(
                'society_id' => $societyData['society_id'],
                'is_multiple' => 1
            ));
            $amenitiesData = $this->amenities_model->getAmenitiesData(array(
                'society_id' => $societyData['society_id'],
                'is_multiple' => 1
            ));

            $amenitiesDataArray = array();
            $facilitiesDataArray =array();
            foreach($amenitiesData as $amenities){
                if($amenities['type'] == 'amenities'){
                    $amenitiesDataArray[] = $amenities;
                }
                else{
                    $facilitiesDataArray[] = $amenities;
                }
            }

            $chargesData = $this->charges_model->getChargesData(array(
                'society_id' => $societyData['society_id'],
                'is_multiple' => 1
            ));

            $chargesDataArray = array();
            $penaltiesDataArray = array();
            foreach($chargesData as $charges){
                if($charges['fee_type'] == 'fee_and_charges'){
                    $chargesDataArray[] = $charges;
                }
                else{
                    $penaltiesDataArray[] = $charges;
                }
            }
            // printArray($chargesDataArray,1);
                
                $data['society_data'] = $societyData;
                $data['bank_data'] = $bankData;
                $data['amenities_data'] = $amenitiesDataArray;
                $data['facilities_data'] = $facilitiesDataArray;
                $data['charges_data'] = $chargesDataArray;
                $data['penalties_data'] = $penaltiesDataArray;
                $data['name'] = lang("Society.society_pdf") . "_" . str_replace('/', '_', $data['society_data']['society_name']) . ".pdf";
                $printHeader = '';
                $printFooter = '';
                $html = view('Admin/Society/pdf/SocietyPdfView', $data);
                // echo($html);
                // die();
                generate_pdf($html, $data['name'], false, $printFooter, '', $printHeader, '', 'P');
            
        }
    }

    public function deleteSocietyImage()
    {
        $this->db->transStart();
        $societyImageId = $this->request->getVar('society_image_id');
        $imageData = $this->society_model->getSocietyImageData(array(
            "society_image_id" => $societyImageId,
            "is_multiple" => 1
        ));
        if(is_array($imageData) && !empty($imageData)){
            foreach ($imageData as $image){
                $FileUrl = '';
                if(isset($image['society_image']) && $image['society_image'] != '') {
                    $FileUrl = SOCIETY_IMAGE_PATH . $image['society_image'];
                }
                if (file_exists($FileUrl)) {
                    unlink($FileUrl);
                } 

                $thumbnailFileUrl = '';
                if(isset($image['society_image']) && $image['society_image'] != '') {
                    $thumbnailFileUrl = THUMBNAIL_SOCIETY_IMAGE_PATH . $image['society_image'];
                }
                if (file_exists($thumbnailFileUrl)) {
                    unlink($thumbnailFileUrl);
                }
            }
        }
        //delete setting location
        $imageData = $this->society_model->deleteSocietyImage($societyImageId);      
        if ($imageData) {
            $ids = is_array($societyImageId) ? implode(',',$societyImageId) : $societyImageId;
            $deleteDataArray['module'] = 'Society Image';
            $deleteDataArray['activity'] = "Society Image Deleted";
            $deleteDataArray['module_id'] = $societyImageId;
            logActivity('Society Image Deleted [SocietyImageID: ' . $ids . ']',$this->data['userId'],'Society Image',$ids,json_encode($deleteDataArray),'','Society',$societyImageId);
            $transactionStatus = $this->db->transComplete();
            if($transactionStatus == 1){
                $response['success'] = true;
                $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Society.society_image'));
            }
            else{
                $response['success'] = false;
                $response['msg']     = sprintf(lang('CommonMessage.delete_error'),lang('Society.society_image'));
            }
            
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('Society.society_image'));
        }
        echo json_encode($response);
        exit();
    }

    public function sendSms(){
        $smsMessage = "Dear 9512688651 , Your OTP is 1234, Globe Yoursonly.";
        sendSms("9512688651",$smsMessage);
    }
}
