<?php
namespace App\Controllers\Admin;

use CodeIgniter\Controller;
use App\Models\ShareFeeReceivedModel;

class ShareFeeReceived extends BaseController
{
    protected $share_fee_received_model;
    public function __construct() {
        $this->share_fee_received_model = new ShareFeeReceivedModel();

    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/moment/moment.js",
            "vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
        $data['title'] = lang('ShareFeeReceived.share_fee_received');
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Ajax)? $select2Ajax : array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
        return $this->dt_ci_template->load("Admin","ShareFeeReceived/ShareFeeReceivedView",$data);
    }

    public function manage($shareFeeReceivedId = '')
	{
		$data['extra_js'] = array(
			"js/jquery.form.min.js",
			"vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
			"vendor/libs/flatpickr/flatpickr.js",
			"js/validate.min.js",
			"js/additional_methods.min.js",
		);

        if ($shareFeeReceivedId != '') {
			$filterData = array(
				"id" => $shareFeeReceivedId
			);
			$data['share_fee_received_data'] = $this->share_fee_received_model->getShareFeeReceivedData($filterData);
            
            // if ((isset($data['share_fee_received_data']['is_deleted']) && $data['share_fee_received_data']['is_deleted'] != 0)) {
            //     return redirect()->to('Admin/ShareFeeReceived');
            // }

			if (empty($data['share_fee_received_data'])) {
                return redirect()->to('Admin/ShareFeeReceived');
            }
		}
		if ($shareFeeReceivedId != '') {
			$data['title'] = lang('ShareFeeReceived.edit_share_fee_received');
		} else {
			$data['title'] = lang('ShareFeeReceived.add_share_fee_received');
		}
		$data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Condition) ? $select2Condition : array());
		if ((isset($data['share_fee_received_data']['society_id']) && $data['share_fee_received_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/ShareFeeReceived');
        }
		$this->dt_ci_template->load("Admin","ShareFeeReceived/ShareFeeReceivedManageView",$data);
	}

    public function getShareFeeReceivedListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }

        $this->datatables->table('tbl_share_fee_received as tsfr');
        $this->datatables->select('tsfr.id, tsfr.receipt_date, tsfr.amount, tsfr.cheque_no, IF(tsfr.membership_form = 1,"Yes","No") AS membership_form, IF(tsfr.index_copy = 1,"Yes","No") AS index_copy, IF(tsfr.application_for_membership = 1,"Yes","No") AS application_for_membership, IF(tsfr.photo = 1,"Yes","No") AS photo, IF(tsfr.pan_card = 1,"Yes","No") AS pan_card, IF(tsfr.adhar_card = 1,"Yes","No") AS adhar_card, IF(tsfr.cheque = 1,"Yes","No") AS cheque');
        $this->datatables->select('tf.flat_no');
        $this->datatables->select('tba.bank_account_no,tb.bank_name');
        $this->datatables->join("tbl_flat as tf","tf.flat_id = tsfr.flat_id","left");
        $this->datatables->join("tbl_bank_account as tba","tba.bank_account_id = tsfr.bank_account_id","left");
        $this->datatables->join("tbl_bank as tb","tb.bank_id = tba.bank_id","left");

        accessFilter($this->datatables, array("society" => "tsfr.society_id"));

        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
					"id" => isset($displayData['id']) ? $displayData['id'] : ""
				);
                $data[$key]['action_button'] = shareFeeReceivedActionButton($actionButtonFilter);
                $data[$key]['receipt_date'] = isValidDate($displayData['receipt_date']) ? siteDateFormat($displayData['receipt_date']) : '-';
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }

    public function changeStatus(){
        $shareFeeReceivedId = $this->request->getVar('id');
        $status = $this->request->getVar('status');
        $return = $this->share_fee_received_model->statusChange($shareFeeReceivedId,$status,'id','tbl_share_fee_received');
		if ($return == 1) {
			$response['success'] = true;
			$response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('ShareFeeReceived.share_fee_received'));
		} else {
			$response['success'] = false;
			$response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('ShareFeeReceived.share_fee_received'));
		}
		echo json_encode($response);
		exit;
    }

    public function save()
	{
        // printArray($_POST,1);
        // exit;
        $this->db->transStart();
		$validation = \Config\Services::validation();
		$shareFeeReceivedId = $this->request->getVar('id');
		$receiptDate = $this->request->getVar('receipt_date');
		$flatId = $this->request->getVar('flat_id');
		$bankAccountId = $this->request->getVar('bank_account_id');
		$chequeNo = $this->request->getVar('cheque_no');
		$amount = $this->request->getVar('amount');
        $membershipForm = $this->request->getVar('membership_form');
        $indexCopy = $this->request->getVar('index_copy');
        $applicationForMembership = $this->request->getVar('application_for_membership');
        $photo = $this->request->getVar('photo');
        $panCard = $this->request->getVar('pan_card');
        $adharCard = $this->request->getVar('adhar_card');
        $cheque = $this->request->getVar('cheque');

		$validation->setRule('receipt_date', lang('ShareFeeReceived.receipt_date'), 'required');
		$validation->setRule('flat_id', lang('ShareFeeReceived.flat_id'), 'required');
		$validation->setRule('bank_account_id', lang('ShareFeeReceived.bank_account_id'), 'required');
		$validation->setRule('cheque_no', lang('ShareFeeReceived.cheque_no'), 'required');
		$validation->setRule('amount', lang('ShareFeeReceived.amount'), 'required');

		if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {
			$shareFeeReceivedUpdateArray = array();
			$shareFeeReceivedArray = array(
				'id' => $shareFeeReceivedId,
				'receipt_date' => DMYToYMD($receiptDate),
				'flat_id' => $flatId,
				'bank_account_id' => $bankAccountId,
				'cheque_no' => $chequeNo,
				'amount' => $amount,
				'membership_form' => ($membershipForm == 1) ? 1 : 0,
				'index_copy' => ($indexCopy == 1) ? 1 : 0,
				'application_for_membership' => ($applicationForMembership == 1) ? 1 : 0,
				'photo' => ($photo == 1) ? 1 : 0,
				'pan_card' => ($panCard == 1) ? 1 : 0,
				'adhar_card' => ($adharCard == 1) ? 1 : 0,
				'cheque' => ($cheque == 1) ? 1 : 0,
				'society_id' => $this->session->get('society_id'),
			);
			if(!empty($shareFeeReceivedId)){
                $shareFeeReceivedUpdateData = $this->share_fee_received_model->getShareFeeReceivedData(array(
                    'id' => $shareFeeReceivedId,
                ));
                $shareFeeReceivedUpdateArray = compareArray($shareFeeReceivedArray,$shareFeeReceivedUpdateData);
            }
			$shareFeeReceivedData = $this->share_fee_received_model->insertUpdateRecord($shareFeeReceivedArray, 'id', 'tbl_share_fee_received', 1,'',array(),array(),$shareFeeReceivedUpdateArray);
			$lastShareFeeReceivedId = $shareFeeReceivedData['lastInsertedId'];
            $transactionStatus = $this->db->transComplete();
			if (isset($shareFeeReceivedId) && $shareFeeReceivedId != '') {
				if (($shareFeeReceivedData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.update_record'), lang("ShareFeeReceived.share_fee_received"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.update_record_error'), lang("ShareFeeReceived.share_fee_received"));
				}
			} else {
				if (($shareFeeReceivedData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.create_record'), lang("ShareFeeReceived.share_fee_received"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.create_record_error'), lang("ShareFeeReceived.share_fee_received"));
				}
			}
			echo json_encode($response);
			exit;
		}
	}

    public function delete()
    {
        $this->db->transStart();
		$shareFeeReceivedId = $this->request->getVar('id');
        $userId =  $this->data['userId'];
		$ShareFeeReceivedData = $this->share_fee_received_model->deleteRecord($shareFeeReceivedId,$userId);
        $transactionStatus = $this->db->transComplete();
        if (($ShareFeeReceivedData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg'] = sprintf(lang('CommonMessage.delete_record'), lang("ShareFeeReceived.share_fee_received"));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'), lang("ShareFeeReceived.share_fee_received"));
        }
        echo json_encode($response);
        exit;
    }

    public function excelExportShareFeeReceived()
    {
        $fileName ='share_fee_received-' . DATETIMEFORMAT;
        $sheetName = 'ShareFeeReceived-' . DATEFORMAT;
        $excelHeaderName = 'ShareFeeReceived';
        $tableData = $this->getShareFeeReceivedListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            lang('ShareFeeReceived.receipt_date'),
            lang('ShareFeeReceived.flat_no'),
            lang('ShareFeeReceived.bank_account_no'),
            lang('ShareFeeReceived.cheque_no'),
            lang('ShareFeeReceived.amount')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                $row["receipt_date"],
                $row["flat_no"],
                $row["bank_account_no"],
                $row["cheque_no"],
                $row["amount"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'E';

        // printArray($dataRows,1);
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }

    // public function view($id = null)
    // {
    //     $shareFeeReceivedId = $this->request->getVar("view_id");
    //     if($shareFeeReceivedId == "" && $shareFeeReceivedId == null){
    //         return redirect()->to('Admin/ShareFeeReceived');
    //     }
    //     else {
    //         $id = $shareFeeReceivedId;
    //         $filterData = array(
    //             "emergency_number_id" => $shareFeeReceivedId
    //         );
    //         $data['share_fee_received_data'] = $this->share_fee_received_model->getShareFeeReceivedData($filterData);
    //         if (empty($data['share_fee_received_data'])) {
    //             return redirect()->to('Admin/ShareFeeReceived');
    //         }

    //         $data['image_data'] = $this->visitor_model->getDocumentImageData(array(
    //             "document_type_id" => $shareFeeReceivedId,
    //             "document_type" => 'forum',
    //             "is_multiple" => 1
    //         ));
    //         // printArray($data['image_data'],1);

    //         $forumView = view("Admin/ShareFeeReceived/ShareFeeReceivedModelView", $data);
    //         $response['view_title'] = "ShareFeeReceived Details";
    //         $response['view_detail'] = $forumView;
    //         $response['success'] = true;
    //         echo json_encode($response);
    //     }
    // }
}