<?php
namespace App\Controllers\Admin;
use App\Models\AmenitiesModel;
use App\Models\BankAccountModel;
use App\Models\ChargesModel;
use CodeIgniter\Controller;
use App\Models\CommonWebServiceModel;
use App\Models\ShareCertificateModel;
use App\Models\SocietyModel;
class ShareCertificate extends BaseController
{
    protected $share_certificate_model;
    public function __construct() {
        $this->share_certificate_model = new ShareCertificateModel();
        $this->society_model = new SocietyModel();
        $this->bank_account_model = new BankAccountModel();
        $this->amenities_model = new AmenitiesModel();
        $this->charges_model = new ChargesModel();
        $this->common_web_service_model = new CommonWebServiceModel();
        checkAndCreatePath(SOCIETY_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_SOCIETY_IMAGE_PATH);

    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/moment/moment.js",
            "vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
        $data['title'] = lang('ShareCertificate.share_certificate');
        return $this->dt_ci_template->load("Admin","ShareCertificate/ShareCertificateView",$data);
    }

    public function manage($shareCertificateId = '')
    {
        // return redirect()->to('Admin/Society');

        $data['extra_js'] = array(
            "js/jquery.form.min.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/bootstrap-datepicker/bootstrap-datepicker.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/moment/moment.js",
            "vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );

        if ($shareCertificateId != '') {
            $filterData = array(
                "share_certificate_id" => $shareCertificateId
            );
            $data['share_certificate_data'] = $this->share_certificate_model->getShareCertificateData($filterData);
            $data['society_data'] = $this->society_model->getSocietyData(array(
                "society_id" => $this->session->get('society_id')
            ));

            if (empty($data['share_certificate_data'])) {
                return redirect()->to('Admin/ShareCertificate');
            }
        }
        if ($shareCertificateId != '') {
            $data['title'] = lang('ShareCertificate.edit_share_certificate');
        } else {
            $data['title'] = lang('ShareCertificate.add_share_certificate');
        }
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", array());
        $this->dt_ci_template->load("Admin","ShareCertificate/ShareCertificateManageView",$data);
    }

    public function getShareCertificateListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        // $isSuperAdmin = session('is_super_admin');
        $this->datatables->table("tbl_share_certificate as tsc");
        $this->datatables->select("tsc.id, tsc.certificate_no, tsc.no_of_shares,tsc.share_holder_name,tsc.flat_id,tsc.holder_of,tsc.from_date,tsc.to_date,tsc.certificate_date,tsc.created_at,tsc.created_by,tsc.updated_at,tsc.updated_by");
        $this->datatables->select("tf.flat_no");
        $this->datatables->join("tbl_flat as tf","tf.flat_id = tsc.flat_id","left"); 
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = tsc.society_id","left"); 
        $this->datatables->join("society_user_master_view as tupdate","tupdate.user_society_id = tsc.updated_by","left");
        $this->datatables->groupBy("tsc.id");

        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "share_certificate_id" => isset($displayData['id']) ? $displayData['id'] : "",
                );
                $data[$key]['action_button'] = shareCertificateActionButton($actionButtonFilter);
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";

            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }
    public function save()
    {
        $this->db->transStart();
        $validation = \Config\Services::validation();
        $shareCertificateId = $this->request->getVar('id');
        $certificateNo = $this->request->getVar('certificate_no');
        $membersRegistrationNo = $this->request->getVar('members_registration_no');
        $flatId = $this->request->getVar('flat_id');
        $noOfShares = $this->request->getVar('no_of_shares');
        $shareHolderName= $this->request->getVar('share_holder_name');
        $holderOf = $this->request->getVar('holder_of');
        $fromDate = $this->request->getVar('from_date');
        $toDate = $this->request->getVar('to_date');
        $certificateDate = $this->request->getVar('certificate_date');

        // if (isset($societyId) && $societyId == '') {
        //     $validation->setRule('society_name', lang('Society.society_name'), 'required|is_unique[tbl_society.society_name]',array('is_unique' => 'This {field} Already Exists'));
        // } else {
        //     $validation->setRule('society_name', lang('Society.society_name'), 'required|is_unique[tbl_society.society_name,society_id,'.$societyId.']',array('is_unique' => 'This {field} Already Exists'));
        // }

        $validation->setRule('certificate_no', lang('Society.certificate_no'), 'required');
        $validation->setRule('members_registration_no', lang('Society.members_registration_no'), 'required');
        $validation->setRule('flat_id', lang('Society.flat_id'), 'required');
        $validation->setRule('no_of_shares', lang('Society.no_of_shares'), 'required');
        $validation->setRule('share_holder_name', lang('Society.share_holder_name'), 'required');
        $validation->setRule('holder_of', lang('Society.holder_of'), 'required');
        $validation->setRule('from_date', lang('Society.from_date'), 'required');
        $validation->setRule('to_date', lang('Society.to_date'), 'required');
        $validation->setRule('certificate_date', lang('Society.certificate_date'), 'required');

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

            $checkDupShareCertificateData = $this->share_certificate_model->getShareCertificateData(array(
                'share_certificate_id_not' => $shareCertificateId,
                'flat_id' => $flatId,
            ));

            if(!empty($checkDupShareCertificateData)){
                $response['success'] = false;
                $response['msg'] = "Certificate has been already created for this flat";
                echo json_encode($response);
                exit;
            }

            $ShareCertificateUpdateArray = array();
            $ShareCertificateArray = array(
                'id' => $shareCertificateId,
                'certificate_no' => $certificateNo,
                'members_registration_no' => $membersRegistrationNo,
                'flat_id' => $flatId,
                'no_of_shares' => $noOfShares,
                'share_holder_name' => $shareHolderName,
                'holder_of' => $holderOf,
                'from_date' => DMYToYMD($fromDate),
                'to_date' => DMYToYMD($toDate),
                'certificate_date' => DMYToYMD($certificateDate),
                'society_id' => $this->session->get('society_id'),
                
            );
            if(!empty($shareCertificateId)){
                $ShareCertificateUpdateData = $this->share_certificate_model->getShareCertificateData(array(
                    'id' => $shareCertificateId,
                ));
                $ShareCertificateUpdateArray = compareArray($ShareCertificateArray,$ShareCertificateUpdateData);
            }

            $ShareCertificateData = $this->share_certificate_model->insertUpdateRecord($ShareCertificateArray,'id','tbl_share_certificate', 1,'',array(),array(),$ShareCertificateUpdateArray);
            $lastId = $ShareCertificateData['lastInsertedId'];

            $transactionStatus = $this->db->transComplete();
            if (isset($shareCertificateId) && $shareCertificateId != '') {
                if (($ShareCertificateData['success']) && ($transactionStatus == 1)) {
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('ShareCertificate.share_certificate'));
                } else {
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('ShareCertificate.share_certificate'));
                }
            } else {
                if (($ShareCertificateData['success']) && ($transactionStatus == 1)) {
                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('ShareCertificate.share_certificate'));
                } else {
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('ShareCertificate.share_certificate'));
                }
            }
            echo json_encode($response);
            exit();
        }

    }

    public function delete()
    {
        $this->db->transStart();
        $id = $this->request->getVar('id');

        $certificateData = $this->share_certificate_model->deleteRecord($id);
        $transactionStatus = $this->db->transComplete();
        if (($certificateData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('ShareCertificate.share_certificate'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang('ShareCertificate.share_certificate'));
        }
        echo json_encode($response);
        exit;
    }

    public function pdf($id = null, $view = null, $save_buffer = null, $zipPdf = 0)
    {
        if (empty($id)) {
            $response['success'] = false;
            $response['msg']     = lang('ShareCertificate.share_certificate_data');
            echo json_encode($response);
            exit;
        }

        $filterData = [
            "share_certificate_id" => $id
        ];
        $shareCertificateData = $this->share_certificate_model->getShareCertificateData($filterData);

        if (empty($shareCertificateData)) {
            $response['success'] = false;
            $response['msg']     = lang('ShareCertificate.share_certificate_data');
            echo json_encode($response);
            exit;
        }

        // $shareCertificateData should already contain society + flat fields
        $data['share_certificate_data'] = $shareCertificateData;

        $data['name'] = 'ShareCertificate_' .
            str_replace('/', '_', $shareCertificateData['certificate_no']) . '.pdf';

        $printHeader = '';
        $printFooter = '';

        $html = view('Admin/ShareCertificate/pdf/ShareCertificatePdfView', $data);
        // printArray($html,1);

        // Orientation: use 'L' if you want more width, otherwise 'P'
        generate_pdf($html, $data['name'], false, $printFooter, '', $printHeader, '', 'L');
    }

}
