<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\ServiceModel;
class Service extends BaseController
{
    protected $service_model;
    public function __construct() {
        $this->service_model = new ServiceModel();
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/moment/moment.js",
            "vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
        $data['title'] = 'Service';
        $dataFilters['filters'] = array(
            array(
                "type" => "multi_select",
                "dynamic" => true,
                "class" => "vendorDd",
                "id" => "filter_vendor_id",
                "name" => "filter_vendor_id",
                "title" => "Service.vendor",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_service_date_time",
                "name" => "filter_service_date_time",
                "title" => "Service.service_date_time",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_created_at",
                "name" => "filter_created_at",
                "title" => "CommonMessage.common_created_at",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_updated_at",
                "name" => "filter_updated_at",
                "title" => "CommonMessage.common_updated_at",
            ),
        );

        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
        return $this->dt_ci_template->load("Admin","Service/ServiceView",$data);
    }

    public function getServiceListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }

        $createdAt = $this->request->getVar("filter_created_at");
        $updatedAt = $this->request->getVar("filter_updated_at");
        $vendorId = $this->request->getVar("filter_vendor_id");
        $serviceDateTime =  $this->request->getVar("filter_service_date_time");


        $this->datatables->table("tbl_service as tser");
        $this->datatables->select("tser.service_id,ts.society_name,ts.society_name,tser.is_active,tv.vendor_name,tser.service_date_time,tser.remarks");
        $this->datatables->select("tv.vendor_id");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $this->datatables->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by,tser.created_at,tser.updated_at");
        $this->datatables->join("society_user_master_view as tupdate","tupdate.user_society_id = tser.updated_by","left");
        $this->datatables->join("society_user_master_view as tcreate","tcreate.user_society_id = tser.created_by","left");
        $this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = tser.society_id","left");
        $this->datatables->join("tbl_vendor as tv","tv.vendor_id = tser.vendor_id","left");
        $this->datatables->groupBy("tser.service_id");


        if(isset($vendorId)) {
            if(is_array($vendorId)){
                $this->datatables->whereIn("tser.vendor_id",$vendorId);
            } else {
                $this->datatables->where("tser.vendor_id",$vendorId);
            }
        }
        if($serviceDateTime != ''){
            list($fromDate,$toDate) = explode(" - ",$serviceDateTime);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tser.service_date_time,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tser.service_date_time,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tser.service_date_time,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }
        if($createdAt != ''){
            list($fromDate,$toDate) = explode(" - ",$createdAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tser.created_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tser.created_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tser.created_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }
        if($updatedAt != ''){
            list($fromDate,$toDate) = explode(" - ",$updatedAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tser.updated_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tser.updated_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tser.updated_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }


        accessFilter($this->datatables, array("society" => "tser.society_id"));
        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "service_id" => isset($displayData['service_id']) ? $displayData['service_id'] : ""
                );
                $data[$key]['action_button'] = serviceActionButton($actionButtonFilter);
                $data[$key]['service_date_time'] = isValidDate($displayData['service_date_time']) ? siteDateFormat($displayData['service_date_time'],true) : "";
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
                $data[$key]['created_at'] = isValidDate($displayData['created_at']) ? siteDateFormat($displayData['created_at'],true) : "";
                $data[$key]['excel_vendor_name'] = isset($displayData['vendor_name']) ?  $displayData['vendor_name'] : "";
                $data[$key]['vendor_name'] = isset($displayData['vendor_name']) ?  vendorDocumentToHtml($displayData['vendor_name'],$displayData['vendor_id']) : "";
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }

    public function manage($serviceId = '')
    {

        $data['extra_js'] = array(
            "js/jquery.form.min.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/bootstrap-datepicker/bootstrap-datepicker.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
        );

        if ($serviceId != '') {
            $filterData = array(
                "service_id" => $serviceId
            );
            $data['service_data'] = $this->service_model->getServiceData($filterData);

            if (empty($data['service_data'])) {
                return redirect()->to('Admin/Service');
            }
        }
        if ($serviceId != '') {
            $data['title'] = 'Edit Service';
        } else {
            $data['title'] = 'Add Service';
        }
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Condition) ? $select2Condition : array());
        if ((isset($data['service_data']['society_id']) && $data['service_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/Service');
        }
        $this->dt_ci_template->load("Admin","Service/ServiceManageView",$data);
    }
    public function save()
    {
        $validation = \Config\Services::validation();

        $serviceId = $this->request->getVar('service_id');
        $vendorId = $this->request->getVar("vendor_id");
        $serviceDateTime = $this->request->getVar("service_date_time");
        $remarks = $this->request->getVar("remarks");
        $isActive = $this->request->getVar("is_active");


        $validation->setRule('vendor_id', lang('Service.vendor'), 'required');
        // $validation->setRule('item_id', lang('Service.item'), 'required');
        $validation->setRule('service_date_time', lang('Service.service_date_time'), 'required');
        $validation->setRule('remarks', lang('Service.remarks'), 'required');
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {
            $serviceUpdateArray = array();
            $serviceArray = array(
                'service_id' => $serviceId,
                'vendor_id' => $vendorId,
                'society_id' => $this->session->get('society_id'),
                'remarks' => $remarks,
                'service_date_time' => DMYToYMD($serviceDateTime,true,true),
                'is_active' => isset($isActive) ? 1 : 0,
            );

            if(!empty($serviceId)){
                $serviceUpdateData = $this->service_model->getServiceData(array(
                    'service_id' => $serviceId,
                ));
                $serviceUpdateArray = compareArray($serviceArray,$serviceUpdateData);
            }

            $serviceData = $this->service_model->insertUpdateRecord($serviceArray, 'service_id', 'tbl_service', 1,'',array(),array(),$serviceUpdateArray);
            if (isset($serviceId) && $serviceId != '') {
                if ($serviceData['success']) {
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('Service.service'));
                } else {
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('Service.service'));
                }
            } else {
                if ($serviceData['success']) {
                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('Service.service'));
                } else {
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('Service.service'));
                }
            }
            echo json_encode($response);
            exit();
        }

    }

    public function changeStatus()
    {
        $serviceId = $this->request->getVar('service_id');
        $status = $this->request->getVar('status');

        $return = $this->service_model->statusChange($serviceId,$status,'service_id','tbl_service');
        if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('Service.service'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('Service.service'));
        }
        echo json_encode($response);
        exit();
    }


    public function delete()
    {
        $this->db->transStart();
        $serviceId = $this->request->getVar('service_id');

        $serviceData  = $this->service_model->deleteRecord($serviceId);
        $transactionStatus = $this->db->transComplete();
        if (($serviceData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Service.service'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang('Service.service'));
        }
        echo json_encode($response);
        exit;
    }

    public function excelExportService()
    {
        $fileName ='service-' . DATETIMEFORMAT;
        $sheetName = 'Service-' . DATEFORMAT;
        $excelHeaderName = 'Service';
        $tableData = $this->getServiceListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            // lang('Service.society'),
            lang('Service.vendor'),
            lang('Service.service_date_time'),
            lang('Service.remarks'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                // $row["society_name"],
                $row["excel_vendor_name"],
                $row["service_date_time"],
                $row["remarks"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'E';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }
}
