<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
// use App\Models\MaterialModel;
use App\Models\RsvpMeetingModel;

class RsvpMeeting extends BaseController
{
    protected $rsvp_meeting_model;
    public function __construct() {
        // $this->material_model = new MaterialModel();
        // $this->rsvp_meeting_model = new RsvpMeetingModel();

    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/moment/moment.js",
            "vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
        $data['title'] = 'Meeting Consent';
        $dataFilters['filters'] = array(
            array(
                "type" => "multi_select",
                "dynamic" => true,
                "class" => "commonAreaDd",
                "id" => "filter_common_area_id",
                "name" => "filter_common_area_id",
                "title" => "RsvpMeeting.common_area",
            ),
            array(
                "type" => "multi_select",
                "dynamic" => true,
                "class" => "itemDd",
                "id" => "filter_item_id",
                "name" => "filter_item_id",
                "title" => "RsvpMeeting.item",
            ),
            array(
                "type" => "multi_select",
                "dynamic" => true,
                "class" => "financialYearDd",
                "id" => "filter_financial_year_id",
                "name" => "filter_financial_year_id",
                "title" => "RsvpMeeting.financial_year",
            ),
            array(
                "type" => "transaction_type",
                "id" => "filter_transaction_type",
                "name" => "filter_transaction_type",
                "title" => "RsvpMeeting.transaction_type",
            ),
        );
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Ajax)? $select2Ajax : array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
        return $this->dt_ci_template->load("Admin","RsvpMeeting/RsvpMeetingView",$data);
    }

    public function getRsvpMeetingListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }

        $commonAreaId = $this->request->getVar("filter_common_area_id");
        $financialYearId = $this->request->getVar("filter_financial_year_id");
        $itemId = $this->request->getVar("filter_item_id");
        $transactionType = $this->request->getVar("filter_transaction_type");

        $this->datatables->table("tbl_rsvp_meeting as trm");

        $this->datatables->select("trm.rsvp_meeting_id,trm.meeting_id,tm.meeting_title,trm.rsvp_status");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,trm.updated_at,tm.name");
        
        $this->datatables->join("tbl_meeting as tm","tm.meeting_id = trm.meeting_id","left");
        $this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = trm.society_id","left");
        $this->datatables->join("tbl_ownership_flat_member as tofm","trm.ownership_flat_member_id = tofm.ownership_flat_member_id","left");
        $this->datatables->join(MASTER_DB.".tbl_member as tm","tm.member_id = tofm.member_id","left");
        $this->datatables->join("society_user_master_view as tupdate","tupdate.user_society_id = trm.updated_by","left");
        
        if(isset($commonAreaId)) {
            if(is_array($commonAreaId)){
                $this->datatables->whereIn("trm.common_area_id",$commonAreaId);
            } else {
                $this->datatables->where("trm.common_area_id",$commonAreaId);
            }
        }
        if(isset($itemId)) {
            if(is_array($itemId)){
                $this->datatables->whereIn("trm.item_id",$itemId);
            } else {
                $this->datatables->where("trm.item_id",$itemId);
            }
        }
        if(isset($financialYearId)) {
            if(is_array($financialYearId)){
                $this->datatables->whereIn("trm.item_id",$financialYearId);
            } else {
                $this->datatables->where("trm.item_id",$financialYearId);
            }
        }
        if(isset($transactionType)) {
            if(is_array($transactionType)){
                $this->datatables->whereIn("trm.transaction_type",$transactionType);
            } else {
                $this->datatables->where("trm.transaction_type",$transactionType);
            }
        }

        $this->datatables->groupBy("trm.rsvp_meeting_id");

        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        // printArray($data,1);
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                // $actionButtonFilter = array(
                //     "common_area_id" => isset($displayData['common_area_id']) ? $displayData['common_area_id'] : "",
                // );
                // $data[$key]['action_button'] = commonAreaActionButton($actionButtonFilter);
                // $data[$key]['posting_date_time'] = isValidDate($displayData['posting_date_time']) ? siteDateFormat($displayData['posting_date_time'],true) : '-';
                // $data[$key]['transaction_for'] = isset($displayData['transaction_for']) ? underscoreToUcWord($displayData['transaction_for']) : '-';
                // $data[$key]['transaction_type'] = isset($displayData['transaction_type']) ? underscoreToUcWord($displayData['transaction_type']) : '-';
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }

    public function excelExportRsvpMeeting()
    {
        $fileName ='rsvp meeting-' . DATETIMEFORMAT;
        $sheetName = 'RsvpMeeting-' . DATEFORMAT;
        $excelHeaderName = 'RsvpMeeting';
        $tableData = $this->getRsvpMeetingListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            lang('RsvpMeeting.meeting_title'),
            lang('RsvpMeeting.name'),
            lang('RsvpMeeting.status'),
        );
        foreach ($tableData as $row) {

            $rsvpText = $row["rsvp_status"] == 0 ? 'Pending' : ($row["rsvp_status"] == -1 ? 'No' : 'Yes');

            $dataRows[] = array(
                $row["meeting_title"],
                $row["name"],
                $rsvpText,
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'C';

        // printArray($dataRows,1);
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }
}