<?php
namespace App\Controllers\Admin;
use App\Models\CommonWebServiceModel;
use App\Models\DocumentModel;
use CodeIgniter\Controller;
use App\Models\ResourceModel;
use App\Models\ResourceTypeModel;
use App\Models\SocietyModel;
use App\Models\StaffModel;
use App\Models\VisitorModel;


class Resource extends BaseController
{
    protected $resource_model;
    public function __construct() {
        $this->resource_model = new ResourceModel();
        $this->society_model = new SocietyModel();
        $this->document_model = new DocumentModel();
        $this->staff_model = new StaffModel();
        $this->resource_type_model = new ResourceTypeModel();
        $this->visitor_model = new VisitorModel();
        $this->common_web_service_model = new CommonWebServiceModel();
//         checkAndCreatePath(THUMBNAIL_DOCUMENT_IMAGE_PATH);

    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/moment/moment.js",
            "vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
        // $data['title'] = lang('Resource.resource');
        $data['title'] = 'Men Power';

        $dataFilters['filters'] = array(
            array(
                "type" => "multi_select",
                "dynamic" => true,
                "class" => "resourceTypeDd",
                "id" => "filter_resource_type_id",
                "name" => "filter_resource_type_id",
                "title" => "Resource.resource_type",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_created_at",
                "name" => "filter_created_at",
                "title" => "CommonMessage.common_created_at",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_updated_at",
                "name" => "filter_updated_at",
                "title" => "CommonMessage.common_updated_at",
            ),
        );
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
        return $this->dt_ci_template->load("Admin","Resource/ResourceView",$data);
    }

    public function getResourceListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $resourceTypeId = $this->request->getVar("filter_resource_type_id");
        $createdAt = $this->request->getVar("filter_created_at");
        $updatedAt = $this->request->getVar("filter_updated_at");
//        $formSubmit = $this->request->getVar("filter_form_submit");
//        $materialType = $this->request->getVar("filter_material_type");
//        $materialDate = $this->request->getVar("filter_material_date");
        $this->datatables->table("tbl_resource as tr");
        $this->datatables->select("tr.resource_id,tr.resource_name,tr.resource_mobile_no,tr.address,tr.is_deleted,tr.resource_type_id,trt.resource_type_name,tr.notification_to_all");
        $this->datatables->select("tr.father_name, tr.date_of_birth, tr.gender, tr.work, tr.present_address, tr.permanent_address, tr.reference,GROUP_CONCAT(distinct(tg.gate_name) SEPARATOR ', ') as gate_name,tvendor.vendor_name");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tr.updated_at");

        $this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = tr.society_id","left");
        $this->datatables->join("society_user_master_view as tupdate","tupdate.user_society_id = tr.updated_by","left");

        $this->datatables->join("tbl_resource_type as trt","trt.resource_type_id = tr.resource_type_id","left");
        $this->datatables->join("tbl_resource_guard as trg","trg.resource_id = tr.resource_id","left");
        $this->datatables->join("tbl_gate as tg","tg.gate_id = trg.gate_id","left");
        $this->datatables->join("tbl_vendor as tvendor","tvendor.vendor_id = tr.vendor_id","left");

        // $this->datatables->where("tr.is_deleted = 0");


        if(isset($resourceTypeId)) {
            if(is_array($resourceTypeId)){
                $this->datatables->whereIn("tr.resource_type_id",$resourceTypeId);
            } else {
                $this->datatables->where("tr.resource_type_id",$resourceTypeId);
            }
        }

        if($createdAt != ''){
            list($fromDate,$toDate) = explode(" - ",$createdAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tr.created_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tr.created_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tr.created_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }
        if($updatedAt != ''){
            list($fromDate,$toDate) = explode(" - ",$updatedAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tr.updated_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tr.updated_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tr.updated_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }
        accessFilter($this->datatables, array("society" => "tr.society_id"));
        $this->datatables->groupBy("tr.resource_id");
        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "resource_id" => isset($displayData['resource_id']) ? $displayData['resource_id'] : "",
                );
                $data[$key]['action_button'] = resourceActionButton($actionButtonFilter);
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
                $data[$key]['date_of_birth'] = siteDateFormat($displayData['date_of_birth']);
                $data[$key]['gender'] = underscoreToUcWord($displayData['gender']);
                $data[$key]['is_outsourced'] = (isset($displayData['is_outsourced']) && $displayData['is_outsourced'] == 1) ? "Yes" : "No";
                // $data[$key]['is_login'] = (isset($displayData['is_login']) && $displayData['is_login'] == 1) ? "Yes" : "No";
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }

    public function manage($resourceId = '',$view = '')
    {
        $request    = \Config\Services::request();
        $data['extra_js'] = array(
            "js/jquery.form.min.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/flatpickr/flatpickr.js",
            "vendor/libs/select2/select2.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
        );
        if ($resourceId != '') {
            $filterData = array(
                "society_id" =>  $this->session->get('society_id'),
                "resource_id" => $resourceId,
                'is_deleted' => 0,
            );
            $data['resource_data'] = $this->resource_model->getResourceData($filterData);

            if (empty($data['resource_data'])) {
                return redirect()->to('Admin/Resource');
            }

            if ((isset($data['resource_data']['is_deleted']) && $data['resource_data']['is_deleted'] != 0)) {
                return redirect()->to('Admin/Resource');
            }

            $data['image_data'] = $this->visitor_model->getDocumentImageData(array(
                "document_type_id" => $resourceId,
                "document_type" => 'resource',
                "is_multiple" => 1
            ));

            $resourceGuardData = $this->resource_model->getResourceGuardData(array(
                'resource_id' => $resourceId,
                'is_multiple' => 1
            ));
            $data['resource_guard_data'] = $resourceGuardData;

            $resourceFlatData = $this->resource_model->getResourceFlatData(array(
                "resource_id" => $resourceId,
                'is_multiple' => 1,
                'is_deleted' => 0,
            ));

            $resourceFlatWorkingDayData = $this->resource_model->getResourceWorkingDayData(array(
                "resource_id" => $resourceId,
                'is_multiple' => 1,
                'is_deleted' => 0,
            ));
            $rfwDataFlatIdWise = array();
            if(!empty($resourceFlatWorkingDayData)){
                foreach ($resourceFlatWorkingDayData as $resourceFlatWorkingDayElement){
                    $rfwDataFlatIdWise[$resourceFlatWorkingDayElement['resource_flat_id']][] = $resourceFlatWorkingDayElement;
                }
            }
            if(!empty($resourceFlatData)){
                foreach ($resourceFlatData as $rfKey => $resourceFlatElement){
                    $resourceFlatData[$rfKey]['weekday_data'] = !empty($rfwDataFlatIdWise) && array_key_exists($resourceFlatElement['resource_flat_id'],$rfwDataFlatIdWise) ? $rfwDataFlatIdWise[$resourceFlatElement['resource_flat_id']]: array();
                }
            }
            $data['resource_flat_data'] = $resourceFlatData;
            // printArray($data['resource_flat_data'],1);

            $documentData = $this->document_model->getDocumentData(array(
                'document_for' => 'resource',
                'is_active' => 1,
                'is_multiple' => 1,

            ));
            if(!empty($documentData)){
                foreach ($documentData as $key => $displayData) {
                    $document = $this->staff_model->getDocument(array(
                        'document_id' => $displayData['document_id'],
                    ));
                    if(!empty($document)){
                        $documentData[$key]['module_document_id'] = $document['module_document_id'];
                        $documentData[$key]['input_box'] = $document['input_box'];
                        $documentData[$key]['document_expiry_date'] = $document['document_expiry_date'];
                    }
                    $documentImageData = $this->staff_model->getDocumentImage(array(
                        "document_id" => isset($displayData['document_id']) ? $displayData['document_id'] : "",
                        'module_id' => $resourceId,
                        'module' => 'resource',
                        "is_multiple" => 1,
                    ));
                    $documentData[$key]['module_image_data'] = $documentImageData;
                }
            }
            $data['document_data'] = $documentData;
        }
        else{
            $documentType = $this->document_model->getDocumentData(array(
                'document_for' => 'resource',
                'is_active' => 1,
                'is_multiple' => 1,

            ));
            $iKey = 0;
            if(!empty($documentType)){
                foreach($documentType as $imageType){
                    $documentTypeData[$iKey] = $imageType;
                    $iKey = $iKey + 1;
                }
            }
            if(!empty($documentTypeData)){
                $data['document_data'] = $documentTypeData;
            }
        }

        if ($resourceId != '') {
            // $data['title'] = lang('Resource.edit_resource');
            $data['title'] = lang('Resource.edit_resource');
        } else {
            // $data['title'] = lang('Resource.add_resource');
            $data['title'] = lang('Resource.add_resource');
        }

        $data['resource_data']['view'] = (isset($view) && $view != '' ? 1 : 0);
        $data['document_table'] = view('Admin/Staff/DocumentView', isset($data) ? $data : array());
        $data['resource_flat_table'] = view('Admin/Resource/ResourceFlatView', isset($data) ? $data : array());

        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Condition) ? $select2Condition : array());
        if ((isset($data['resource_data']['society_id']) && $data['resource_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/Resource');
        }



        $this->dt_ci_template->load("Admin","Resource/ResourceManageView",$data);
    }

    public function changeNotificationToAll()
    {
        $resourceId = $this->request->getVar('resource_id');
        $status = $this->request->getVar('status');

        $return = $this->resource_model->notificationToAllChange($resourceId,$status,'resource_id','tbl_resource');
        if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.notification_to_all_change'),lang('Resource.resource'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.notification_to_all_change_change_error'),lang('Resource.resource'));
        }
        echo json_encode($response);
        exit();
    }

    public function save()
    {
        $this->db->transStart();
        $this->centralDB->transStart();
        $validation = \Config\Services::validation();
        $resourceId = $this->request->getVar('resource_id');
        $resourceTypeId = $this->request->getVar('resource_type_id');
        $resourceName = $this->request->getVar('resource_name');
        $resourceMobileNo = $this->request->getVar('resource_mobile_no');
        // $address = $this->request->getVar('address');
        $fatherName = $this->request->getVar('father_name');
        $dateOfBirth = $this->request->getVar('date_of_birth');
        $gender = $this->request->getVar('gender');
        $work = $this->request->getVar('work');
        $presentAddress = $this->request->getVar('present_address');
        $permanentAddress = $this->request->getVar('permanent_address');
        $reference = $this->request->getVar('reference');
        $isOutsourced = $this->request->getVar('is_outsourced');
        $isLogin = $this->request->getVar('is_login');
        $groupId = $this->request->getVar('group_id');
        $vendorId = $this->request->getVar('vendor_id');
        $isGuard = $this->request->getVar('is_guard');
        $userSocietyId = $this->request->getVar('user_society_id');
        $notificationToALL = $this->request->getVar('notification_to_all');

        $validation->setRule('resource_type_id', lang('Resource.resource_type'), 'required');
        $validation->setRule('resource_name', lang('Resource.resource_name'), 'required');
        $validation->setRule('resource_mobile_no', lang('Resource.mobile_no'), 'required');
        $validation->setRule('father_name', lang('Resource.father_name'), 'required');
        $validation->setRule('date_of_birth', lang('Resource.date_of_birth'), 'required');
        $validation->setRule('gender', lang('Resource.gender'), 'required');
        $validation->setRule('work', lang('Resource.work'), 'required');
        $validation->setRule('present_address', lang('Resource.present_address'), 'required');
        $validation->setRule('permanent_address', lang('Resource.permanent_address'), 'required');
        // $validation->setRule('address', lang('Resource.address'), 'required');

        if($isGuard == 0){
            // $validation->setRule('flat_id.*', lang('Resource.flat'), 'required');
            // $validation->setRule('working_day_id.*', lang('Resource.working_days'), 'required');
            $validation->setRule('in_time.*', lang('Resource.in_time'), 'required');
            $validation->setRule('out_time.*', lang('Resource.out_time'), 'required');
        }


        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {
            $resourceData = $this->resource_model->getResourceData(array(
                'resource_mobile_no' => $resourceMobileNo,
                'resource_id_not' => $resourceId,
                'society_id' => $this->session->get("society_id"),
            ));

            $resourceTypeData = $this->resource_type_model->getResourceTypeData(array(
                'resource_type_name' => array(RESOURCE_TYPE_MANAGER,RESOURCE_TYPE_MEMBER),
                'is_multiple' => 1
            ));

            $resourceTypeIdArray = array_column($resourceTypeData,'resource_type_id');

            $userData = $this->common_web_service_model->getUserSocietyData(array(
                'phone' => $resourceMobileNo,
                'resource_type_id' => $resourceTypeIdArray,
                'society_id' => $this->session->get("society_id"),
            ));

            if((!empty($resourceData)) || (!empty($userData))){
                $response['success'] = false;
                $response['msg'] = lang("Resource.mobile_no_already_exist");
                echo json_encode($response);
                exit;
            }
            //Get Resource Flat data
            $resourceFlatIdArray = $this->request->getVar('resource_flat_id');
            $typeIdArray = $this->request->getVar('type_id');
            $typeArray = $this->request->getVar('flat_type');
            $workingDayIdArray = $this->request->getVar('working_day_id');
            $inTimeArray = $this->request->getVar('in_time');
            $outTimeArray = $this->request->getVar('out_time');

            // printArray($resourceFlatIdArray);
            // printArray($flatIdArray);
            // printArray($workingDayIdArray);
            // printArray($inTimeArray);
            // printArray($outTimeArray);
            // die();

            if($isGuard == 0){
                if (!empty($resourceFlatIdArray)) {
                    $dayWiseTimeSlots = [];  // Store time slots grouped by working days
                
                    foreach ($resourceFlatIdArray as $fkey => $resourceFlatId) {
                        $inTime = array_key_exists($fkey, $inTimeArray) ? $inTimeArray[$fkey] : '';
                        $outTime = array_key_exists($fkey, $outTimeArray) ? $outTimeArray[$fkey] : '';
                        $workingDayIdData = array_key_exists($fkey, $workingDayIdArray) ? $workingDayIdArray[$fkey] : array();
                
                        // Convert times to timestamps
                        $inTimeStamp = strtotime($inTime);
                        $outTimeStamp = strtotime($outTime);
                
                        // Explicit validation: Out-Time should not be less than In-Time unless crossing midnight
                        if ($outTimeStamp <= $inTimeStamp) {
                            $response['success'] = false;
                            $response['msg'] = "Out-Time Can/t Be Earlier Than Or Equal To In-Time At Row : ". ($fkey);
                            echo json_encode($response);
                            exit;
                        }
                
                        // Adjust Out-Time if it is earlier than In-Time (crosses midnight)
                        if ($outTimeStamp < $inTimeStamp) {
                            $outTimeStamp += 24 * 60 * 60; // Add 24 hours to Out-Time
                        }
                
                        $weekDays = weekDays();
                        // Validate against all the working days specified in the current row
                        foreach ($workingDayIdData as $day) {
                            if (!isset($dayWiseTimeSlots[$day])) {
                                $dayWiseTimeSlots[$day] = [];
                            }
                
                            // Check for overlap with existing time slots on the same working day
                            foreach ($dayWiseTimeSlots[$day] as $slot) {
                                list($existingInTime, $existingOutTime) = explode('-', $slot);
                                $existingInTimeStamp = strtotime($existingInTime);
                                $existingOutTimeStamp = strtotime($existingOutTime);
                
                                // Adjust existing Out-Time if it crosses midnight
                                if ($existingOutTimeStamp < $existingInTimeStamp) {
                                    $existingOutTimeStamp += 24 * 60 * 60;
                                }
                
                                if (($inTimeStamp < $existingOutTimeStamp) && ($outTimeStamp > $existingInTimeStamp)) {
                                    $response['success'] = false;
                                    $response['msg'] = "Time Slot Overlaps On Working Day At Row " .($fkey) . " With Another Entry.";
                                    echo json_encode($response);
                                    exit;
                                }
                            }
                
                            // Store the current time slot under the current working day
                            $dayWiseTimeSlots[$day][] = $inTime . '-' . $outTime;
                        }
                    }
                }
            }
            //     $flatIdDuplicateArray = array();
            //     $flatIdUniqueArray = array();
            //     $flatKey = 0;
    
            //     if(!empty($resourceFlatIdArray)) {
            //         foreach ($resourceFlatIdArray as $pbpkey => $resourceFlatId) {
            //             $flatKey = $flatKey + 1;
            //             $flatId = array_key_exists($pbpkey, $typeIdArray) ? $typeIdArray[$pbpkey] : '';
            //             $typeArray = array_key_exists($pbpkey, $typeArray) ? $typeArray[$pbpkey] : '';
        
    
            //             if($flatId != ''){
            //                 if (!in_array($flatId, $flatIdUniqueArray)) {
            //                    $flatIdUniqueArray[$flatKey] = $flatId;
            //                 } else {
            //                     $flatIdDuplicateObject = array();
            //                     $flatIdDuplicateObject['row_no'] = $flatKey;
            //                     $flatIdDuplicateArray[$flatKey] = $flatIdDuplicateObject;
            //                 }
            //             }
            //         }
            //     }
            //     $findDuplicatieFaltArray = array();
            //     if(!empty($flatIdDuplicateArray)){
            //         foreach($flatIdDuplicateArray as $flatIdDuplicateElement){
            //             $findDuplicatieFaltArray[] = $flatIdDuplicateElement['row_no'] .   " Flat Duplicate ";
            //         }
            //     }
    
            //     if(!empty($findDuplicatieFaltArray)){
            //         $response['success'] = false;
            //         $response['msg'] = implode("\n", $findDuplicatieFaltArray);
            //         echo json_encode($response);
            //         exit;
            //     }
            // }

            $flatIdDuplicateArray = array();
            $flatIdUniqueArray = array();
            $flatKey = 0;

            if(!empty($resourceFlatIdArray)) {
                foreach ($resourceFlatIdArray as $pbpkey => $resourceFlatId) {
                    $flatKey = $flatKey + 1;
                    $flatId = array_key_exists($pbpkey, $typeIdArray) ? $typeIdArray[$pbpkey] : '';
                    $type = array_key_exists($pbpkey, $typeArray) ? $typeArray[$pbpkey] : '';
                    
                    // Determine which ID to check based on type
                    $idToCheck = '';
                    if($type == 'flat' && !empty($flatId)) {
                        $idToCheck = 'flat_' . $flatId; // Prefix to distinguish between types
                    } elseif($type == 'common_area' && !empty($flatId)) {
                        $idToCheck = 'common_' . $flatId; // Using flatId variable which contains common_area_id
                    }

                    if($idToCheck != ''){
                        if (!in_array($idToCheck, $flatIdUniqueArray)) {
                           $flatIdUniqueArray[$flatKey] = $idToCheck;
                        } else {
                            $flatIdDuplicateObject = array();
                            $flatIdDuplicateObject['row_no'] = $flatKey;
                            $flatIdDuplicateObject['type'] = $type;
                            $flatIdDuplicateArray[$flatKey] = $flatIdDuplicateObject;
                        }
                    }
                }
            }

            $findDuplicatieFaltArray = array();
            if(!empty($flatIdDuplicateArray)){
                foreach($flatIdDuplicateArray as $flatIdDuplicateElement){
                    $typeLabel = ($flatIdDuplicateElement['type'] == 'flat') ? 'Flat' : 'Common Area';
                    $findDuplicatieFaltArray[] = "Working Day Information Row : " . $flatIdDuplicateElement['row_no'] . " " . $typeLabel . " Duplicate";
                }
            }

            if(!empty($findDuplicatieFaltArray)){
                $response['success'] = false;
                $response['msg'] = implode("\n", $findDuplicatieFaltArray);
                echo json_encode($response);
                exit;
            }
            $imageFormatsForThumbnail = array('jpg', 'jpeg', 'png', 'JPG'); // Only these formats will have thumbnails
            $moduleDocumentResult = array();
            if (isset($_FILES["document_image"])) {
                $moduleDocumentResult  = $this->dt_ci_file_upload->MultipleFileUpload('document_image', MAX_IMAGE_SIZE_LIMIT, DOCUMENT_IMAGE_PATH, true, true, array('jpeg', 'png', 'jpg', 'JPG','pdf'));

                // printArray($moduleDocumentResult,1);
                if ($moduleDocumentResult['success'] == false) {
                    $response['success'] = false;
                    $response['msg'] = strip_tags($moduleDocumentResult['message']);
                    echo json_encode($response);
                    die();
                }
                else{
                    unset($moduleDocumentResult['success']);
                    foreach ($moduleDocumentResult as $file) {
                        $extension = pathinfo($file['file_name'], PATHINFO_EXTENSION);
                        if (in_array(strtolower($extension), $imageFormatsForThumbnail)) {
                            $thumbnailResult = $this->dt_ci_file_upload->ThumbnailUploadFile($file, DOCUMENT_IMAGE_PATH, THUMBNAIL_DOCUMENT_IMAGE_PATH);
                        }
                    }
                }
            }

            $imageResultArray = array();
            if(!empty($moduleDocumentResult)){
                foreach ($moduleDocumentResult as $keyImage => $imageResultData){
                    list($fromKey) = explode("_",$keyImage);
                    $imageResultArray[$fromKey][] = $imageResultData;
                }
            }
            $resourceImage = array();
            if (isset($_FILES["resource_image"])) {
                $resourceImagePath = DOCUMENT_IMAGE_PATH;
                $resourceImage = $this->dt_ci_file_upload->UploadMultipleFile('resource_image', MAX_IMAGE_SIZE_LIMIT, $resourceImagePath, true, true, array('jpeg', 'png', 'jpg', 'JPG'));
                if ($resourceImage['success'] == false) {
                    $response['success'] = false;
                    $response['msg'] = strip_tags($resourceImage['message']);
                    echo json_encode($response);
                    die();
                }
                else{
                    unset($resourceImage['success']);
                    $thumbnailResult =  $this->dt_ci_file_upload->ThumbnailMultipleUploadFile($resourceImage, DOCUMENT_IMAGE_PATH, THUMBNAIL_DOCUMENT_IMAGE_PATH);
                }
            }

            $resourceUpdateArray = array();
            $resourceArray = array(
                'resource_id' => $resourceId,
                'society_id' => $this->session->get('society_id'),
                'resource_name' => $resourceName,
                'resource_mobile_no' => $resourceMobileNo,
                // 'address' => $address,
                'resource_type_id' => $resourceTypeId,
                'father_name' => $fatherName,
                'date_of_birth' => DMYToYMD($dateOfBirth),
                'gender' => $gender,
                'work' => $work,
                'present_address' => $presentAddress,
                'permanent_address' => $permanentAddress,
                'reference' => $reference,
                'is_outsourced' => isset($isOutsourced) ? 1 : 0,
                'notification_to_all' => isset($notificationToALL) ? 1 : 0,
                // 'is_login' => isset($isLogin) ? 1 : 0,
            );

            if(isset($isOutsourced)){
                $resourceArray['vendor_id'] = $vendorId;
            } else {
                $resourceArray['vendor_id'] = 0;
            }
            if($isGuard == 0){
                if ($resourceId == '') {
                    $resourceArray['status'] = 'approved';
                    $resourceArray['qr_code_number'] = GenRandomNumber(6);
                    $combineQRCodeType = $resourceArray['qr_code_number'];
                    $codeContents = $combineQRCodeType;
                    qrcode('text', $codeContents, 4, '', $combineQRCodeType);
                    $resourceArray['qr_code_image'] = $combineQRCodeType . '.png';
                }
            }

            if(!empty($resourceId)){
                $resourceUpdateData = $this->resource_model->getResourceData(array(
                    'resource_id' => $resourceId
                ));
                $resourceUpdateArray = compareArray($resourceArray,$resourceUpdateData);
            }
            $resourceData = $this->resource_model->insertUpdateRecord($resourceArray, 'resource_id', 'tbl_resource', 1,'',array(),array(),$resourceUpdateArray);
            $lastResourceId = $resourceData['lastInsertedId'];

            if($lastResourceId != ''){
                if(isset($resourceImage) && count($resourceImage) > 0){
                    $batchArray = array();
                    unset($resourceImage['success']);
                    foreach ($resourceImage as $key => $imageData) {
                        $dataArray = array(
                            'document_image_id' => '',
                            'document_type' => 'resource',
                            'document_type_id' => $lastResourceId,
                            'document_image' => isset($imageData['file_name']) ? $imageData['file_name'] : "",
                        );
                        array_push($batchArray, $dataArray);
                    }

                    $resourceImageExtraDataArray = array();
                    $resourceImageExtraDataArray['module_id'] = $lastResourceId;
                    $resourceImageExtraDataArray['module'] = 'Resource Image';
                    $resourceImageExtraDataArray['type'] = 'Resource';
                    $resourceImageExtraDataArray['old_data'] = array();
                    $resourceImageExtraDataArray['user_id'] = $this->data['userId'];
                    $resourceImageExtraDataArray['society_id'] = $this->session->get('society_id');

                    // printArray($batchArray,1);
                    $this->resource_model->batchInsert($batchArray, 'tbl_document_image',$resourceImageExtraDataArray);
                }
            }

            $resourceGuardData = array();
            if(!empty($resourceId)) {
                $resourceGuardData = $this->resource_model->getResourceGuardData(array(
                    'resource_id' => $resourceId,
                    'is_multiple' => 1
                ));
            }

            $gateIdArray = $this->request->getVar('gate_id[]');
            if(isset($resourceId) && $resourceId != ''){
                $this->resource_model->deleteGuardRecord($resourceId);
            }
            if(isset($gateIdArray)&& $gateIdArray != ''){
                $gateForArray = array();
                foreach($gateIdArray as $gateId){
                    $gateForArray[] = array(
                        'resource_guard_id' => '',
                        'resource_id' => $lastResourceId,
                        'gate_id' => $gateId,
                        'created_at' => date('Y-m-d H:i:s'),
                        'updated_at' => date('Y-m-d H:i:s'),
                        'created_by' => $this->data['userId'],
                        'updated_by' => $this->data['userId']
                    );
                }
                $resourceSocietyExtraDataArray = array();
                $resourceSocietyExtraDataArray['module_id'] = $lastResourceId;
                $resourceSocietyExtraDataArray['module'] = 'Resource Guard';
                $resourceSocietyExtraDataArray['type'] = 'Resource';
                $resourceSocietyExtraDataArray['old_data'] = $resourceGuardData;
                $resourceSocietyExtraDataArray['user_id'] = $this->data['userId'];
                $resourceSocietyExtraDataArray['society_id'] = $this->session->get('society_id');

                if(!empty($gateForArray)){
                    $this->resource_model->batchInsert($gateForArray,'tbl_resource_guard',$resourceSocietyExtraDataArray);
                }
            }
            $moduleDocumentUpdateArray = array();
            $documentIdArray = $this->request->getVar('document_id');
            $moduleDocumentIdArray = $this->request->getVar('module_document_id');
            $inputBoxArray = $this->request->getVar('input_box');
            $documentExpiryDateArray = $this->request->getVar('document_expiry_date');
            if (!empty($moduleDocumentIdArray)) {
                foreach ($moduleDocumentIdArray as $fkey => $moduleDocumentId) {
                    $moduleDocumentsId = array_key_exists($fkey, $moduleDocumentIdArray) ? $moduleDocumentIdArray[$fkey] : 0;
                    $documentId = array_key_exists($fkey, $documentIdArray) ? $documentIdArray[$fkey] : 0;
                    $inputBox = array_key_exists($fkey, $inputBoxArray) ? $inputBoxArray[$fkey] : 0;
                    $documentExpiryDate = (isset($documentExpiryDateArray) && array_key_exists($fkey, $documentExpiryDateArray)) ? $documentExpiryDateArray[$fkey] : 0;
                    $moduleDocumentImage = array_key_exists($fkey, $imageResultArray) ? $imageResultArray[$fkey] : [];
                    $moduleDocumentInsertArray = array(
                        'module_document_id' => $moduleDocumentsId,
                        'module_id' => $lastResourceId,
                        'module' => 'resource',
                        'document_id' => $documentId,
                        'input_box' => $inputBox,
                        'document_expiry_date' => DMYToYMD($documentExpiryDate),
                        'created_by' => $this->data['userId'],
                        'updated_by' => $this->data['userId'],
                        'created_at' => date("Y-m-d H:i:s"),
                        'updated_at' => date("Y-m-d H:i:s"),
                    );
                    if(!empty($moduleDocumentId)){
                        $documentUpdateData = $this->staff_model->getDocument(array(
                            'module_document_id' => $moduleDocumentId,
                        ));
                        $moduleDocumentUpdateArray = compareArray($moduleDocumentInsertArray,$documentUpdateData);
                        $moduleDocumentUpdateArray['type'] = 'resource';
                        $moduleDocumentUpdateArray['type_id']  = $lastResourceId;
                    }
                    $moduleDocumentData = $this->resource_model->insertUpdate($moduleDocumentInsertArray, 'module_document_id', 'tbl_module_document', 1,$moduleDocumentUpdateArray);
                    $lastModuleDocumentId = $moduleDocumentData['lastInsertedId'];


                    // printArray($moduleDocumentImage);
                    $imageDataArray = array();
                    if(!empty($moduleDocumentImage)){
                        unset($imageResultArray['success']);
                        foreach ($moduleDocumentImage as  $mdImageElement){
                            $imageDataArray[] = array(
                                'module_document_image_id' =>   '',
                                'module_id' => $lastResourceId,
                                'module' => 'resource',
                                'document_id' => $documentId,
                                'module_document_id' => $lastModuleDocumentId,
                                'document_image' => isset($mdImageElement['file_name']) ? $mdImageElement['file_name'] : "",
                                'created_at' => date('Y-m-d H:i:s'),
                                'updated_at' => date('Y-m-d H:i:s'),
                                'created_by' => $this->data['userId'],
                                'updated_by' => $this->data['userId']
                            );
                        }
                        $moduleImageExtraDataArray = array();
                        $moduleImageExtraDataArray['module_id'] = $lastResourceId;
                        $moduleImageExtraDataArray['module'] = 'Resource Document Image';
                        $moduleImageExtraDataArray['type'] = 'Resource';
                        $moduleImageExtraDataArray['old_data'] = array();
                        $moduleImageExtraDataArray['user_id'] = $this->data['userId'];
                        $moduleImageExtraDataArray['society_id'] = $this->session->get('society_id');
                        $this->resource_model->batchInsert($imageDataArray, 'tbl_module_document_image',$moduleImageExtraDataArray);
                    }
                }
            }

            if($isGuard == 0){

                if (!empty($resourceFlatIdArray)) {
                    $this->resource_model->deleteResourceFlatWorkingDay($lastResourceId);
                    foreach ($resourceFlatIdArray as $fkey => $resourceFlatId) {
                        $typeId = array_key_exists($fkey, $typeIdArray) ? $typeIdArray[$fkey] : '';
                        $type = array_key_exists($fkey, $typeArray) ? $typeArray[$fkey] : '';
                        $workingDayIdData = array_key_exists($fkey, $workingDayIdArray) ? $workingDayIdArray[$fkey] : array();
                        $inTime = array_key_exists($fkey, $inTimeArray) ? $inTimeArray[$fkey] : '';
                        $outTime = array_key_exists($fkey, $outTimeArray) ? $outTimeArray[$fkey] : '';

                        
                        $ownershipFlatMemberId = 0;
                        $ownershipFlatId = 0;
                        $towerId = 0;
                        if($type == 'flat'){
                            $ownerFlatData = $this->resource_model->getFlatToGetOwnerFlatData(array('flat_id' => $typeId));
                            if(!empty($ownerFlatData)){
                                $ownershipFlatMemberId = isset($ownerFlatData['ownership_flat_member_id']) ? $ownerFlatData['ownership_flat_member_id'] : 0;
                                $ownershipFlatId = isset($ownerFlatData['ownership_flat_id']) ? $ownerFlatData['ownership_flat_id'] : 0;
                                $towerId = isset($ownerFlatData['tower_id']) ? $ownerFlatData['tower_id'] : 0;
                            }
                        }

                        $resourceFlatInsertUpdateArray = array(
                            'resource_flat_id' => $resourceFlatId,
                            'resource_id' => $lastResourceId,
                            'tower_id' => $towerId,
                            'flat_type' => $type,
                            'type_id' => $typeId,
                            'ownership_flat_member_id' => $ownershipFlatMemberId,
                            'ownership_flat_id' => $ownershipFlatId,
                            'resource_in_time' => date('H:i', strtotime($inTime)),
                            'resource_out_time' => date('H:i', strtotime($outTime)),
                        );

                        // printArray($resourceFlatInsertUpdateArray,1);

                        $resourceFlatData = $this->resource_model->insertUpdateRecord($resourceFlatInsertUpdateArray, 'resource_flat_id', 'tbl_resource_flat', 1,'',array(),array());
                        $lastResourceFlatId = $resourceFlatData['lastInsertedId'];

                        // $resourceFlatWorkingDayData = $this->resource_model->getResourceWorkingDayData(array(
                        //     "resource_id" => $lastResourceId,
                        //     "resource_flat_id" => $lastResourceFlatId,
                        //     'is_multiple' => 1,
                        //     'is_deleted' => 0,
                        // ));
                        // $this->resource_model->deleteResourceFlatWorkingDay($lastResourceId);
                        foreach ($workingDayIdData as $workingDayElement) {
                            $resourceFlatWeekDayInsertUpdateArray = array(
                                'resource_working_day_id' => '',
                                'resource_id' => $lastResourceId,
                                'resource_flat_id' => $lastResourceFlatId,
                                'working_day_id' => $workingDayElement,
                                'working_day_name' => "Mon",
                                'resource_in_time' => $inTime,
                                'resource_out_time' => $outTime,
                                'created_by' => $this->data['userId'],
                                'updated_by' => $this->data['userId'],
                                'created_at' => date("Y-m-d H:i:s"),
                                'updated_at' => date("Y-m-d H:i:s"),
                            );
                            $this->resource_model->insertUpdate($resourceFlatWeekDayInsertUpdateArray, 'resource_working_day_id', 'tbl_resource_working_day', 1);
                        }
                    }
                }
            }

            if(($isLogin == 1) && !empty($isLogin)){
                $userResourceTypeId = $resourceTypeId;
                
                $groupData = $this->common_web_service_model->getGroupsData(array(
                    'id' => $groupId,
                    'society_id' => $this->session->get('society_id'),
                ));
                $groupId = isset($groupData['id']) ? $groupData['id'] : '';
                $permissions = isset($groupData['permissions']) ? $groupData['permissions'] :'';
                $permissionArray = unserialize($permissions);
                $permissionLabel = array();
                $controllers_methods = $this->dt_ci_acl->getPermissableMethods();
                foreach ($controllers_methods as $controller_name => $methods_arr) {
                    foreach ($methods_arr as $method) {
                        $methodDisplay = "";
                        $methodActual = "";
                        if (is_array($method)) {
                            reset($method);
                            $methodActual = key($method);
                            $methodDisplay = $method[$methodActual];
                        } else {
                            $methodDisplay = $method;
                            $methodActual = $method;
                        }
                        $inputName = $controller_name . "|" . $methodActual;
                        $checked = "";
                        $permissionLabel[] = $inputName . "|dt|" . $controller_name . "|dt|" . $methodDisplay;
                    }
                }
                $lastUserId = '';
                if(empty($resourceId)) {
                    
                    $userDataFilter = $this->common_web_service_model->getUserSocietyData(array(
                        'phone' => $resourceMobileNo
                    ));
                    if(!empty($userDataFilter)){
                        $lastUserId = $userDataFilter['user_id'];
                    }
                }
                else{
                    if(!empty($userSocietyId)){
                        $userDataFilter = $this->common_web_service_model->getUserSocietyData(array(
                            'user_society_id' => $userSocietyId
                        ));
                        $lastUserId = $userDataFilter['user_id'];
                    }
                }

                // printArray($isNewUserCreate,1);
                if(empty($userDataFilter)){
                    $userArray = array(
                        'id' => '',
                        'first_name' => $resourceName,
                        'active' => 1
                    );
                    $userData = $this->resource_model->insertUpdateRecord($userArray, 'id', MASTER_DB.'.tbl_users', 1,'',array(),array(),array());
                    $lastUserId = $userData['lastInsertedId'];
                }
                

                $userSocietyArray = array(
                    'user_society_id' => $userSocietyId,
                    'user_id' => $lastUserId,
                    'society_id' => $this->session->get('society_id'),
                    'phone' => $resourceMobileNo,
                    'resource_type_id' => $userResourceTypeId,
                    'type_id' => $lastResourceId,
                    'is_active' => 1,
                );
                $userSocietyData = $this->resource_model->insertUpdateRecord($userSocietyArray, 'user_society_id', MASTER_DB.'.tbl_user_society',1);
                $userSocietyId = $userSocietyData['lastInsertedId'];

                $userGroupDataArray = $this->common_web_service_model->getUserGroupData(array(
                    'user_society_id' => $userSocietyId,
                ));
                if(!empty($userGroupDataArray)){
                    $id = $userGroupDataArray['id'];
                }
                else{
                    $id = '';
                }

                $userGroupArray = array(
                    'id' => $id,
                    'user_id' => $lastUserId,
                    'group_id' => $groupId,
                    'user_society_id' => $userSocietyId,
                );

                // printArray($userGroupArray,1);
                $userGroupData = $this->resource_model->insertUpdate($userGroupArray, 'id',  MASTER_DB.'.tbl_users_groups',1);

                if(!empty($resourceId)){
                    $this->common_web_service_model->deleteUserSocietyPermissionRecord($userSocietyId); 
                }

                if(is_array($permissionLabel) && count($permissionLabel) > 0){
                    $labelArray = array();
                    foreach ($permissionLabel as $labelData){
                        list($permissionValue,$controller,$label) = explode("|dt|",$labelData);
                        if(in_array($permissionValue,$permissionArray)) {
                            $labelArray[] = array(
                                'controller_name' => $controller,
                                'permission_name' => $permissionValue,
                                'permission_label' => $label,
                                'user_id' =>    $lastUserId,
                                'group_id' =>    $groupId,
                                'user_society_id' =>    $userSocietyId,
                                'created_at'        => date('Y-m-d H:i:s'),
                                'created_by'        => $this->session->get('user_id'),
                                'updated_at'        => date('Y-m-d H:i:s'),
                                'updated_by'        => $this->session->get('user_id'),
                            );
                        }
                    }
                    $this->resource_model->batchInsert($labelArray, MASTER_DB.".tbl_user_permission");
                }
            }
            else{
                if(!empty($resourceId)){
                    $oldIsLogin = $resourceUpdateData['is_login'];
                    if($oldIsLogin != $isLogin){
                        $userSocietyData = $this->common_web_service_model->getUserSocietyData(array(
                            'society_id' => $this->session->get("society_id"),
                            'user_society_id' => $userSocietyId,
                        ));
                        if(!empty($userSocietyData)){
                            $this->common_web_service_model->userSocietyStatusChange($userSocietyId,$this->data['userId']);    
                        }
                    }
                }
            }
            $transactionStatus = $this->db->transComplete();
            $transactionCentralStatus = $this->centralDB->transComplete();
            if (isset($resourceId) && $resourceId != '') {
                if (($resourceData['success']) && ($transactionStatus == 1 && $transactionCentralStatus == 1)) {
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('Resource.resource'));
                } else {
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('Resource.resource'));
                }
            } else {
                if (($resourceData['success']) && ($transactionStatus == 1 && $transactionCentralStatus == 1)) {
                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('Resource.resource'));
                } else {
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('Resource.resource'));
                }
            }
            echo json_encode($response);
            exit();
        }
    }

    // public function delete()
    // {
    //     $this->db->transBegin();
    //     $materialId  = $this->request->getVar('material_id');
    //     $materialDataArray = $this->material_model->getMaterialData(array(
    //         'material_id' => $materialId,
    //         'is_multile' => 1
    //     ));
    //     $materialApprovedError = array();
    //     if(!empty($materialDataArray)){
    //         if($materialDataArray['form_submit'] == 'approved') {
    //             $materialApprovedError[] =  $materialDataArray['document_number'] ;
    //         }
            
    //     }
    //     if(!empty($materialApprovedError)){
    //         $materialNumber = implode(',', $materialApprovedError);
    //         $response['success'] = false;
    //         $response['msg'] = "You Can't Deleted This Material ". $materialNumber ." Because Already Approved";
    //         echo json_encode($response);
    //         exit;
    //     };

    //     $materialData = $this->material_model->deleteRecord($materialId);
    //     if ($materialData) {
    //         $this->db->transCommit();
    //         $response['success'] = true;
    //         $response['msg'] = sprintf(lang('CommonMessage.delete_record'), lang("Material.material"));
    //     } else {
    //         $this->db->transRollback();
    //         $response['success'] = false;
    //         $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'), lang("Material.material"));
    //     }
    //     echo json_encode($response);
    //     exit;
    // }

    public function addResourceFlatRow()
    {
        $data['row_number'] = $this->request->getVar("row_number");
        $flatRow = view('Admin/Resource/ResourceFlatRowView', $data);
        echo $flatRow;
    }

    public function deleteResourceFlatRow()
    {
        $this->db->transStart();
        $resourceFlatId  = $this->request->getVar('resource_flat_id');
        $resourceId = $this->request->getVar('resource_id');
        $userId =  $this->data['userId'];
        $this->resource_model->deleteAdminPanelFlatWeekDayRecord($resourceFlatId,$userId);
        $resourceFaltData = $this->resource_model->deleteAdminPanelFlatRecord($resourceFlatId,$userId);

        if ($resourceFaltData) {
            if(!empty($resourceFaltData)){
                foreach($resourceFaltData as $documentElement){
                    $deleteDataArray['module'] = 'Resource Flat';
                    $deleteDataArray['activity'] = "Resource Flat Deleted";
                    $deleteDataArray['module_id'] = $documentElement;
                    logActivity('Resource Flat Deleted [ResourceFlatID: ' . $documentElement . ']',$this->data['userId'],'Resource Flat',$documentElement,json_encode($deleteDataArray),'','Resource',$resourceId);
                }
            }

            $transactionStatus = $this->db->transComplete();
            if($transactionStatus == 1){
                $response['success'] = true;
                $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Material.material_item'));
            }
            else{
                $response['success'] = false;
                $response['msg']     = sprintf(lang('CommonMessage.delete_error'),lang('Material.material_item'));
            }
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('Material.material_item'));
        }
        echo json_encode($response);
        exit();
    }


    public function view($id = null)
    {
        $resourceId = $this->request->getVar("view_id");
        if($resourceId == "" && $resourceId == null){
            return redirect()->to('Admin/Resource');
        }
        else {
            $id = $resourceId;
            $filterData = array(
                "resource_id" => $resourceId
            );
            $data['resource_data'] = $this->resource_model->getResourceData($filterData);
            if (empty($data['resource_data'])) {
                return redirect()->to('Admin/Resource');
            }
            $resourceFlatData = $this->resource_model->getResourceFlatData(array(
                "resource_id" => $resourceId,
                'is_multiple' => 1,
                'is_deleted' => 0,
            ));

            $resourceFlatWorkingDayData = $this->resource_model->getResourceWorkingDayData(array(
                "resource_id" => $resourceId,
                'is_multiple' => 1,
                'is_deleted' => 0,
            ));
            $rfwDataFlatIdWise = array();
            if(!empty($resourceFlatWorkingDayData)){
                foreach ($resourceFlatWorkingDayData as $resourceFlatWorkingDayElement){
                    $rfwDataFlatIdWise[$resourceFlatWorkingDayElement['resource_flat_id']][] = $resourceFlatWorkingDayElement;
                }
            }
            if(!empty($resourceFlatData)){
                foreach ($resourceFlatData as $rfKey => $resourceFlatElement){
                    $resourceFlatData[$rfKey]['weekday_data'] = !empty($rfwDataFlatIdWise) && array_key_exists($resourceFlatElement['resource_flat_id'],$rfwDataFlatIdWise) ? $rfwDataFlatIdWise[$resourceFlatElement['resource_flat_id']]: array();
                }
            }
            $data['resource_flat_data'] = $resourceFlatData;

            $data['image_data'] = $this->visitor_model->getDocumentImageData(array(
                "document_type_id" => $resourceId,
                "document_type" => 'resource',
                "is_multiple" => 1
            ));

            $resourceGuardData = $this->resource_model->getResourceGuardData(array(
                'resource_id' => $resourceId,
                'is_multiple' => 1
            ));
            $data['resource_guard_data'] = $resourceGuardData;

            $documentData = $this->document_model->getDocumentData(array(
                'document_for' => 'resource',
                'is_active' => 1,
                'is_multiple' => 1,

            ));
            if(!empty($documentData)){
                foreach ($documentData as $key => $displayData) {

                    $documentImageData = $this->staff_model->getDocumentImage(array(
                        "document_id" => isset($displayData['document_id']) ? $displayData['document_id'] : "",
                        'module_id' => $resourceId,
                        'module' => 'resource',
                        "is_multiple" => 1,
                    ));
                    $documentData[$key]['module_image_data'] = $documentImageData;
                }
            }
            $data['document_data'] = $documentData;

            // printArray($data['resource_data']);
            // printArray($data['resource_flat_data']);
            // printArray($data['document_data'],1);

            $resourceView = view("Admin/Resource/ResourceModelView", $data);
            $response['view_title'] = "Resource Details";
            $response['view_detail'] = $resourceView;
            $response['success'] = true;
            echo json_encode($response);
        }
    }



    public function excelExportResource()
    {
        $fileName ='resource-' . DATETIMEFORMAT;
        $sheetName = 'Resource-' . DATEFORMAT;
        $excelHeaderName = 'Resource';
        $tableData = $this->getResourceListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            lang('Resource.resource_type'),
            lang('Resource.gate'),
            lang('Resource.resource_name'),
            lang('Resource.father_name'),
            lang('Resource.date_of_birth'),
            lang('Resource.gender'),
            lang('Resource.work'),
            lang('Resource.mobile_no'),
            lang('Resource.present_address'),
            lang('Resource.permanent_address'),
            lang('Resource.reference'),
            lang('Resource.is_outsourced'),
            lang('Resource.vendor'),
            // lang('Resource.resource_can_login'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                $row["resource_type_name"],
                $row["gate_name"],
                $row["resource_name"],
                $row["father_name"],
                $row["date_of_birth"],
                $row["gender"],
                $row["work"],
                $row["resource_mobile_no"],
                $row["present_address"],
                $row["permanent_address"],
                $row["reference"],
                $row["is_outsourced"],
                $row["vendor_name"],
                // $row["is_login"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'P';

        // printArray($dataRows,1);
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }

    public function deleteResourceImage()
    {
        $this->db->transStart();
        $documentImageId = $this->request->getVar('document_image_id');
        $documentTypeId = $this->request->getVar('document_type_id');
        $documentType = $this->request->getVar('document_type');
        $imageData = $this->visitor_model->getDocumentImageData(array(
            "document_image_id" => $documentImageId,
            "is_multiple" => 1
        ));
        if(is_array($imageData) && !empty($imageData)){
            foreach ($imageData as $image){
                $FileUrl = '';
                if(isset($image['document_image']) && $image['document_image'] != '') {
                    $FileUrl = DOCUMENT_IMAGE_PATH . $image['document_image'];
                }
                if (file_exists($FileUrl)) {
                    unlink($FileUrl);
                } 

                $thumbnailFileUrl = '';
                if(isset($image['document_image']) && $image['document_image'] != '') {
                    $thumbnailFileUrl = THUMBNAIL_DOCUMENT_IMAGE_PATH . $image['document_image'];
                }
                if (file_exists($thumbnailFileUrl)) {
                    unlink($thumbnailFileUrl);
                }
            }
        }
        //delete setting location
        $imageData = $this->visitor_model->deleteDocumentImage($documentImageId,"resource");      
        if ($imageData) {
            $ids = is_array($documentImageId) ? implode(',',$documentImageId) : $documentImageId;
            $deleteDataArray['module'] = 'Resource Image';
            $deleteDataArray['activity'] = "Resource Image Deleted";
            $deleteDataArray['module_id'] = $documentImageId;
            logActivity('Resource Image Deleted [ResourceImageID: ' . $ids . ']',$this->data['userId'],'Resource Image',$ids,json_encode($deleteDataArray),'','Resource',$documentTypeId);
            $transactionStatus = $this->db->transComplete();
            if($transactionStatus == 1){
                $response['success'] = true;
                $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Resource.resource_image'));
            }
            else{
                $response['success'] = false;
                $response['msg']     = sprintf(lang('CommonMessage.delete_error'),lang('Resource.resource_image'));
            }
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('Resource.resource_image'));
        }
        echo json_encode($response);
        exit();
    }

    public function getResourceDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page = $this->request->getVar('page');
        $resourceId = $this->request->getVar('resource_id');
        $resourceType = $this->request->getVar('resource_type_id');
        $filterResourceType = $this->request->getVar('filter_resource_type_id');
        $societyId = $this->request->getVar('society_id');
        $filterData = array(
            'resource_id' => $resourceId,
            'resource_type_id' => $resourceType,
            'filter_resource_type_id' => $filterResourceType,
            'society_id' => $this->session->get('society_id'),
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'is_active' => 1,
            'limit' => DATA_LIMIT
        );
        echo $this->resource_model->getResource($filterData);
    }

}
