<?php
namespace App\Controllers\Admin;
use App\Models\PollModel;
use CodeIgniter\Controller;
use App\Models\MaterialModel;
use App\Models\ItemBalanceModel;
use App\Models\CommonWebServiceModel;
use App\Models\SocietyModel;
use App\Models\OwnershipFlatModel;
use App\Models\ResourceTypeModel;
use App\Models\ManagementCommitteeModel;

class Poll extends BaseController
{

    protected $poll_model;
    public function __construct() {
        $this->poll_model = new PollModel();
        $this->society_model = new SocietyModel();
        $this->common_web_service_model = new CommonWebServiceModel();
        $this->ownership_flat_model = new OwnershipFlatModel();
        $this->resource_type_model = new ResourceTypeModel();
        $this->management_committee_model = new ManagementCommitteeModel();
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/moment/moment.js",
            "vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
        $data['title'] = lang('Poll.poll');

        $dataFilters['filters'] = array(
            array(
                "type" => "daterange",
                "id" => "filter_start_date",
                "name" => "filter_start_date",
                "title" => "Visitor.start_date",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_end_date",
                "name" => "filter_end_date",
                "title" => "Visitor.end_date",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_created_at",
                "name" => "filter_created_at",
                "title" => "CommonMessage.common_created_at",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_updated_at",
                "name" => "filter_updated_at",
                "title" => "CommonMessage.common_updated_at",
            ),
        );
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
        return $this->dt_ci_template->load("Admin","Poll/PollView",$data);
    }

    public function getPollListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }

        $startDate = $this->request->getVar("filter_start_date");
        $endDate = $this->request->getVar("filter_end_date");
        $createdAt = $this->request->getVar("filter_created_at");
        $updatedAt = $this->request->getVar("filter_updated_at");

        $this->datatables->table("tbl_poll as tp");
        $this->datatables->select("tp.poll_id,tp.poll_title,tp.start_date,tp.end_date,ts.society_name");

        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tp.updated_at");
        $this->datatables->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by,tp.created_at");

        $this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = tp.society_id","left");
        $this->datatables->join("society_user_master_view as tupdate","tupdate.user_society_id = tp.updated_by","left");
        $this->datatables->join("society_user_master_view as tcreate","tcreate.user_society_id = tp.created_by","left");

        if($startDate != ''){
            list($fromDate,$toDate) = explode(" - ",$startDate);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tp.start_date,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tp.start_date,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tp.start_date,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }

        if($endDate != ''){
            list($fromDate,$toDate) = explode(" - ",$endDate);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tp.end_date,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tp.end_date,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tp.end_date,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }
        
        if($createdAt != ''){
            list($fromDate,$toDate) = explode(" - ",$createdAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tp.created_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tp.created_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tp.created_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }

        if($updatedAt != ''){
            list($fromDate,$toDate) = explode(" - ",$updatedAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tp.updated_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tp.updated_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tp.updated_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }

        accessFilter($this->datatables, array("society" => "tp.society_id"));
        $this->datatables->groupBy("tp.poll_id");
        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "poll_id" => isset($displayData['poll_id']) ? $displayData['poll_id'] : "",
                );
                $data[$key]['action_button'] = pollActionButton($actionButtonFilter);
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
                $data[$key]['created_at'] = isValidDate($displayData['created_at']) ? siteDateFormat($displayData['created_at'],true) : "";
                $data[$key]['start_date'] = isValidDate($displayData['start_date']) ? YMDToDMY($displayData['start_date']) : "";
                $data[$key]['end_date'] = isValidDate($displayData['end_date']) ? YMDToDMY($displayData['end_date']) : "";
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }

    public function manage($pollId = '',$view = '')
    {
        $request    = \Config\Services::request();
        $data['extra_js'] = array(
            "js/jquery.form.min.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/flatpickr/flatpickr.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
        );
        if ($pollId != '') {
            $filterData = array(
                "poll_id" => $pollId
            );
            $data['poll_data'] = $this->poll_model->getPollData($filterData);
            if (empty($data['poll_data'])) {
                return redirect()->to('Admin/Material');
            }

            $pollOptionData = $this->poll_model->getPollOptionData(array(
                "poll_id" => $pollId,
                'is_multiple' => 1
            ));
            $data['poll_option_data'] = $pollOptionData;
        }

        if ($pollId != '') {
            $data['title'] = lang('Poll.edit_poll');
        } else {
            $data['title'] =  lang('Poll.add_poll');
        }

        $data['poll_data']['view'] = (isset($view) && $view != '' ? 1 : 0);

        $data['poll_option_table'] = view('Admin/Poll/PollOptionView', isset($data) ? $data : array());
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Condition) ? $select2Condition : array());
        if ((isset($data['poll_data']['society_id']) && $data['poll_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/Poll');
        }

        $this->dt_ci_template->load("Admin","Poll/PollManageView",$data);
    }

    public function save()
    {
        $this->db->transStart();
        $validation = \Config\Services::validation();
        $pollId = $this->request->getVar('poll_id');
        $startDate = $this->request->getVar('start_date');
        $endDate = $this->request->getVar('end_date');
        $title = $this->request->getVar('title');
        $pollType = $this->request->getVar('poll_type');
        $validation->setRule('title', lang('Poll.question'), 'required');
        $validation->setRule('start_date', lang('Poll.start_date'), 'required');
        $validation->setRule('end_date', lang('Poll.end_date'), 'required');
        $validation->setRule('poll_type', lang('Poll.poll_type'), 'required');

        $validation->setRule('option.*', lang('Material.item'), 'required');
        $validation->setRule('sort_order.*', lang('Material.quantity'), 'required');


        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

            if (strtotime($startDate) > strtotime($endDate)){
				$response['success'] = false;
				$response['msg'] = lang('Poll.poll_start_date_to_end_date_message');
				echo json_encode($response);
				exit;
			}
            //get poll option data
            $pollOptionIdArray = $this->request->getVar('poll_option_id');
            $optionArray = $this->request->getVar('option');
            $sortOrderArray = $this->request->getVar('sort_order');


            $pollUpdateArray = array();
            $pollArray = array(
                'poll_id' => $pollId,
                'society_id' => $this->session->get('society_id'),
                'start_date' => DMYToYMD($startDate),
                'end_date' => DMYToYMD($endDate),
                'poll_title' => $title,
                'poll_type' => $pollType,
            );

            if (!empty($pollId)) {
                $pollUpdateData = $this->poll_model->getPollData(array(
                    "poll_id" => $pollId
                ));
                $pollUpdateArray = compareArray($pollArray, $pollUpdateData);
            }
            $pollData = $this->poll_model->insertUpdateRecord($pollArray, 'poll_id', 'tbl_poll', 1, '', array(), array(), $pollUpdateArray);
            $lastPollId = $pollData['lastInsertedId'];


            if (!empty($pollOptionIdArray)) {
                foreach ($pollOptionIdArray as $fkey => $pollOptionId) {
                    $option = array_key_exists($fkey, $optionArray) ? $optionArray[$fkey] : '';
                    $sortOrder = array_key_exists($fkey, $sortOrderArray) ? $sortOrderArray[$fkey] : '';

                    if ($pollOptionId == '') {
                        $optionInsertArray[$fkey] = array(
                            'poll_option_id' => '',
                            'poll_id' => $lastPollId,
                            'poll_option' => $option,
                            'sort_order' => $sortOrder,
                            'created_by' => $this->data['userId'],
                            'updated_by' => $this->data['userId'],
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                    } else {
                        $optionUpdateArray[$fkey] = array(
                            'poll_option_id' => $pollOptionId,
                            'poll_id' => $lastPollId,
                            'poll_option' => $option,
                            'sort_order' => $sortOrder,
                            'updated_by' => $this->data['userId'],
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                    }
                }

                if (!empty($optionInsertArray)) {
                    $this->poll_model->batchInsert($optionInsertArray, 'tbl_poll_option', array());
                }
                if (!empty($optionUpdateArray)) {
                    $this->poll_model->batchUpdate($optionUpdateArray, "poll_option_id", 'tbl_poll_option', array());
                }
            }
            $transactionStatus = $this->db->transComplete();
            if (isset($pollId) && $pollId != '') {
                if (($pollData['success']) && ($transactionStatus == 1)) {
                    $response['success'] = true;
                    $response['msg'] = sprintf(lang('CommonMessage.update_record'), lang('Poll.poll'));
                } else {
                    $response['success'] = false;
                    $response['msg'] = sprintf(lang('CommonMessage.update_record_error'), lang('Poll.poll'));
                }
            } else {
                if (($pollData['success']) && ($transactionStatus == 1)) {
                    $memberIdArray = array();
                    $userSocietyIdArray = array();
                    $customerDataArray = array();
                    $batchNotificationDataArray = array();
                    $sendNotificationDataArray = array();
                    $notificationMergeArray = array();
                    $notificationArray = array(
                        'notification_title' => 'New Poll Launched',
                        'description' => 'A new poll on '.$title.' has been launched. Your input matters! Please cast your vote through the app before '.$endDate.'.',
                    );
                    $deviceIdArray = array();
                    $iosDeviceIdArray = array();
                    $customerData['title_name'] = isset($notificationArray['notification_title']) ? $notificationArray['notification_title'] : "";
                    $customerData['description'] = isset($notificationArray['description']) ? $notificationArray['description'] : "";
                    $resourceTypeData = $this->resource_type_model->getResourceTypeData(array(
                        'resource_type_name' => RESOURCE_TYPE_MEMBER,
                        'society_id' => $this->session->get('society_id'),
                    ));
                    if($pollType == 'all_member'){
                        $userType = MEMBER_APP;
                        $ownershipFlatMemberData = $this->ownership_flat_model->getOwnershipFlatMemberData(array(
                            'society_id' => $this->session->get('society_id'),
                            'is_active' => 1,
                            'is_multiple' => 1
                        ));
                        if(!empty($ownershipFlatMemberData)){
                            foreach ($ownershipFlatMemberData as $ownershipFlatMember) {
                                $memberIdArray[] = $ownershipFlatMember['member_id'];
                            }
                        }

                        if(!empty($memberIdArray)){
                            $userSocietyData = $this->common_web_service_model->getUserSocietyData(array(
                                "type_id" => $memberIdArray,
                                "resource_type_id" => $resourceTypeData['resource_type_id'],
                                'society_id' => $this->session->get('society_id'),
                                'is_multiple' => 1
                            ));
                            if(!empty($userSocietyData)){
                                foreach ($userSocietyData as $userElement) {
                                    $userSocietyIdArray[] = $userElement['user_society_id'];
                                }
                            }
                        }
                    }

                    if($pollType == 'committee'){
                        $userType = MEMBER_APP;
                        
                        $managementCommitteeData = $this->management_committee_model->getManagementCommitteeData(array(
                            'society_id' => $this->session->get('society_id'),
                            'is_active' => 1,
                            'is_api' => 1,
                            'is_multiple' => 1
                        ));
                        if(!empty($managementCommitteeData)){
                            foreach($managementCommitteeData as $managementCommitteeElement){
                                $ownershipFlatMemberIdArray[] = $managementCommitteeElement['member_id'];
                            }
                        }

                        if(!empty($ownershipFlatMemberIdArray)){
                            $ownershipFlatMemberData = $this->ownership_flat_model->getOwnershipFlatMemberData(array(
                                'ownership_flat_member_id' => $ownershipFlatMemberIdArray,
                                'is_show_all_member' => 1,
                                'is_multiple' => 1,
                                'is_active' => 1
                            ));
                            if(!empty($ownershipFlatMemberData)){
                                foreach ($ownershipFlatMemberData as $ownershipFlatMember) {
                                    $memberIdArray[] = $ownershipFlatMember['member_id'];
                                }
                            }
                            $userSocietyCommitteeData = $this->common_web_service_model->getUserSocietyData(array(
                                'society_id' => $this->session->get('society_id'),
                                'resource_type_id' => $resourceTypeData['resource_type_id'],
                                'type_id' => $memberIdArray,
                                'user_society_id_not' => $this->data['userId'],
                                'is_multiple' => 1
                            ));

                            if (!empty($userSocietyCommitteeData)) {
                                foreach ($userSocietyCommitteeData as $userSocietyCommitteeElement) {
                                    $userSocietyIdArray[] = isset($userSocietyCommitteeElement['user_society_id']) ? $userSocietyCommitteeElement['user_society_id'] : 0;
                                }
                            }
                        }
                    }

                    if($pollType == 'manager'){
                        $userType = MANAGER_APP;
                        
                        $resourceTypeManagerData = $this->resource_type_model->getResourceTypeData(array(
                            'resource_type_name' => RESOURCE_TYPE_MANAGER,
                            'society_id' => $this->session->get('society_id'),
                        ));

                        $userManagerData = $this->common_web_service_model->getUserSocietyData(array(
                            'society_id' => $this->session->get('society_id'),
                            'resource_type_id' =>  $resourceTypeManagerData['resource_type_id'],
                            'user_society_id_not' => $this->data['userId'],
                            'is_active' => 1,
                            'is_multiple' => 1
                        ));

                        if (!empty($userManagerData)) {
                            foreach ($userManagerData as $userManagerCommittee) {
                                $userSocietyIdArray[] = isset($userManagerCommittee['user_society_id']) ? $userManagerCommittee['user_society_id'] : 0;
                            }
                        }
                    }

                    if(!empty($userSocietyIdArray)){
                        $userDeviceArray = $this->common_web_service_model->deviceData(array(
                            "user_society_id" => $userSocietyIdArray,
                            'user_type' => $userType,
                            "is_latest" => 1,
                            "is_multiple" => 1,
                        ));
                        
                        if(!empty($userDeviceArray)){
                            foreach($userDeviceArray as $userDevice){
                                $notificationOtherArray = array(
                                    'notification_id' => '',
                                    'society_id' => $this->session->get('society_id'),
                                    'notification_date' => TODAY_DATE_YMD,
                                    'notification_for' => (isset($userDevice['device_type'])) ? strtolower($userDevice['device_type']) : "",
                                    'type' => 'poll',
                                    'type_id' => $lastPollId,
                                    // 'module' => 'poll',
                                    'created_by' => $this->data['userId'],
                                    'updated_by' => $this->data['userId'],
                                    'created_at' => date("Y-m-d H:i:s"),
                                    'updated_at' => date("Y-m-d H:i:s"),
                                );
                                $notificationOtherArray['send_for_notification'] = 'manager';
                                $notificationOtherArray['send_for_notification_id'] = $this->data['userId'];
                                $notificationOtherArray['receive_for_notification'] = $userDevice['user_type'];
                                $notificationOtherArray['receive_for_notification_id'] = $userDevice['user_type_id'];
                                if(!empty($notificationArray)){
                                    $notificationMergeArray = array_merge($notificationArray,$notificationOtherArray);
                                    $extraDataJsonArray = $notificationMergeArray;
                                    $extraDataJsonArray['module'] = 'poll';
                                    $extraDataJsonArray['status'] = 'poll';
                                    $extraDatajson = json_encode($extraDataJsonArray);
                                    $notificationMergeArray['extra_data'] = $extraDatajson;
                                    $customerData['extra_data'] = $extraDatajson;
                                    $customerData['app_url'] = MEMBER_URL .'poll/current';
                                    //send notification data
                                    $deviceToken = $userDevice['one_signal_id'];
                                    $deviceId = $userDevice['device_id'];
                                    $batchNotificationDataArray[] = $notificationMergeArray;

                                    $sendNotificationDataArray[] = array(
                                        'notification_title' => 'New Poll Launched',
                                        'description' => 'A new poll on '.$title.' has been launched. Your input matters! Please cast your vote through the app before '.$endDate.'.',
                                        'extra_data_json' => $extraDatajson,
                                        'app_url' => MEMBER_URL .'poll/current',
                                        'notification_for' => (isset($userDevice['device_type'])) ? strtolower($userDevice['device_type']) : "",
                                        'device_id' => $userDevice['device_id'],
                                        'type' => 'poll',
                                    );

                                    // if(strtolower($userDevice['device_type']) == 'android'){
                                    //     if (!empty($deviceId)) {
                                    //         array_push($deviceIdArray,$deviceId);
                                    //     }
                                    // } else {
                                    //     if (!empty($deviceId)) {
                                    //         array_push($iosDeviceIdArray,$deviceId);
                                    //     }
                                    // }
                                }
                            }
                        }
                        if(!empty($batchNotificationDataArray)){
                            $this->ownership_flat_model->batchInsert($batchNotificationDataArray,'tbl_notification');
                        }
                        // $sendNotificationData = array();
                        if(!empty($sendNotificationDataArray)){
                            // $customerData['device_id'] = $deviceIdArray;
                            // $sendNotificationData = $customerData;
                            sendNotification($sendNotificationDataArray);
                        }
                        // $sendNotificationIOSData = array();
                        // if(!empty($iosDeviceIdArray)){
                        //     $customerData['device_id'] = $iosDeviceIdArray;
                        //     $sendNotificationIOSData = $customerData;
                        //     sendNotificationIOS($sendNotificationIOSData);
                        // }
                    }
                    $response['success'] = true;
                    $response['msg'] = sprintf(lang('CommonMessage.create_record'), lang('Poll.poll'));
                } else {
                    $response['success'] = false;
                    $response['msg'] = sprintf(lang('CommonMessage.create_record_error'), lang('Poll.poll'));
                }
            }
            echo json_encode($response);
            exit();
        }
    }

    public function delete()
    {
        $this->db->transStart();
        $pollId  = $this->request->getVar('poll_id');

        $pollData = $this->poll_model->deleteRecord($pollId);
        $transactionStatus = $this->db->transComplete();
        if (($pollData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg'] = sprintf(lang('CommonMessage.delete_record'), lang("Poll.poll"));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'), lang("Poll.poll"));
        }
        echo json_encode($response);
        exit;
    }

    public function addPollOptionRow()
    {
        $data['row_number'] = $this->request->getVar("row_number");
        $memberRow = view('Admin/Poll/PollOptionRowView', $data);
        echo $memberRow;
    }

    public function deletePollOptionRow()
    {
        $this->db->transStart();
        $pollOptionId  = $this->request->getVar('poll_option_id');
        $pollId = $this->request->getVar('poll_id');

        $pollOptionData = $this->poll_model->deletePollOptionRecord($pollOptionId);

        if ($pollOptionData) {
            if(!empty($pollOptionData)){
                foreach($pollOptionData as $documentElement){
                    $deleteDataArray['module'] = 'Poll Option';
                    $deleteDataArray['activity'] = "Poll Option Deleted";
                    $deleteDataArray['module_id'] = $documentElement;
                    logActivity('Poll Option Deleted [PollOptionID: ' . $documentElement . ']',$this->data['userId'],'Poll Option',$documentElement,json_encode($deleteDataArray),'','Poll',$pollId);
                }
            }
            $transactionStatus = $this->db->transComplete();
            if($transactionStatus == 1){
                $response['success'] = true;
                $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Poll.poll_option'));
            }
            else{
                $response['success'] = false;
                $response['msg']     = sprintf(lang('CommonMessage.delete_error'),lang('Poll.poll_option'));
            }
        } else {
            $this->db->transRollback();
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('Poll.poll_option'));
        }
        echo json_encode($response);
        exit();
    }

    public function view($id = null)
    {
        $pollId = $this->request->getVar("view_id");
        if($pollId == "" && $pollId == null){
            return redirect()->to('Admin/Poll');
        }
        else {
            $id = $pollId;
            $filterData = array(
                "poll_id" => $pollId
            );
            $data['poll_data'] = $this->poll_model->getPollData($filterData);
            if (empty($data['poll_data'])) {
                return redirect()->to('Admin/Material');
            }

            $pollOptionData = $this->poll_model->getPollOptionData(array(
                "poll_id" => $pollId,
                'is_multiple' => 1
            ));
            $data['poll_option_data'] = $pollOptionData;

            // printArray($data['poll_data']);
            // printArray($data['poll_option_data'],1);

            $pollView = view("Admin/Poll/PollModelView", $data);
            $response['view_title'] = "Poll Details";
            $response['view_detail'] = $pollView;
            $response['success'] = true;
            echo json_encode($response);
        }
    }

    public function getPollDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page = $this->request->getVar('page');
        $pollId = $this->request->getVar('poll_id');
        $filterData = array(
            'poll_id' => $pollId,
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT
        );
        echo $this->poll_model->getPoll($filterData);
    }

    public function getPollOptionDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page = $this->request->getVar('page');
        $pollOptionId = $this->request->getVar('poll_option_id');
        $filterData = array(
            'poll_option_id' => $pollOptionId,
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT
        );
        echo $this->poll_model->getPollOption($filterData);
    }

}
