<?php
namespace App\Controllers\Admin;
use App\Models\ParkingSlotModel;
use CodeIgniter\Controller;
use App\Models\ParkingAreaModel;
class ParkingArea extends BaseController
{
    protected $parking_area_model;
    public function __construct() {
        $this->parking_area_model = new ParkingAreaModel();
        $this->parking_slot_model = new ParkingSlotModel();
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );
        $data['title'] = 'Parking Area';
        return $this->dt_ci_template->load("Admin","ParkingArea/ParkingAreaView",$data);
    }

    public function getParkingAreaListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $this->datatables->table("tbl_parking_area as ta");
        $this->datatables->select("ta.parking_area_id, ta.parking_area_name,ta.is_active");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $this->datatables->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by,ta.created_at,ta.updated_at");
        $this->datatables->join("society_user_master_view as tupdate","tupdate.user_society_id = ta.updated_by","left");
        $this->datatables->join("society_user_master_view as tcreate","tcreate.user_society_id = ta.created_by","left");
        $this->datatables->groupBy("ta.parking_area_id");
        accessFilter($this->datatables, array("society" => "ta.society_id"));

        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "parking_area_id" => isset($displayData['parking_area_id']) ? $displayData['parking_area_id'] : "",
                );
                $data[$key]['action_button'] = parkingAreaActionButton($actionButtonFilter);
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
                $data[$key]['created_at'] = isValidDate($displayData['created_at']) ? siteDateFormat($displayData['created_at'],true) : "";
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }

    public function manage($parkingAreaId = '',$view = '')
    {
        $request    = \Config\Services::request();
        $data['extra_js'] = array(
            "js/jquery.form.min.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/flatpickr/flatpickr.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
        );
        if ($parkingAreaId != '') {
            $filterData = array(
                "parking_area_id" => $parkingAreaId
            );
            $data['parking_area_data'] = $this->parking_area_model->getParkingAreaData($filterData);

            $parkingVehicle = $this->parking_area_model->getParkingVehicleData(array(
                'parking_area_id' => $parkingAreaId,
                'is_multiple' => 1
            ));
            $data['parking_vehicle_data'] = $parkingVehicle;
            if (empty($data['parking_area_data'])) {
                return redirect()->to('Admin/ParkingArea');
            }
        }

        if ($parkingAreaId != '') {
            $data['title'] = lang('ParkingArea.edit_parking_area');
        } else {
            $data['title'] = lang('ParkingArea.add_parking_area');
        }

        $data['parking_area_data']['view'] = (isset($view) && $view != '' ? 1 : 0);
        if ((isset($data['parking_area_data']['society_id']) && $data['parking_area_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/ParkingArea');
        }
        $data['parking_vehicle_table'] = view('Admin/ParkingArea/ParkingVehicleTableView', isset($data) ? $data : array());
        $this->dt_ci_template->load("Admin","ParkingArea/ParkingAreaManageView",$data);
    }

    public function save()
    {
        $this->db->transStart();
        $validation = \Config\Services::validation();
        $parkingAreaId = $this->request->getVar('parking_area_id');
        $parkingAreaName = $this->request->getVar('parking_area_name');
        $parkingVehicleIdArray = $this->request->getVar('parking_vehicle_id');
        $slotArray = $this->request->getVar('slot');
        $vehicleTypeArray = $this->request->getVar('vehicle_type');
        $numberTypeArray = $this->request->getVar('number_type');
        $rangeLabelArray = $this->request->getVar('range_label');
        $rangeStartFromArray = $this->request->getVar('range_start_from');
        $isActive = $this->request->getVar('is_active');

        if (isset($parkingAreaId) && $parkingAreaId == '') {
			//$validation->setRule('area_name', lang('ParkingArea.area_name'), 'required|combination_unique[tbl_Parkingarea.area_name.'.$this->session->get('society_id').'.]',array('combination_unique' => 'This {field} Already Exists'));
        } else {
			//$validation->setRule('area_name', lang('ParkingArea.area_name'), 'required|edit_unique[tbl_Parkingarea.area_name.' . $parkingAreaId . '.'. $this->session->get('society_id').']',array('edit_unique' => 'This {field} Already Exists'));
        }

        $filterData = array(
            "parking_area_id" => $parkingAreaId,
            "parking_area_name" => $parkingAreaName,
            // "vehicle_type" => $vehicleType,
            "society_id" => $this->session->get('society_id'),
            'parking_area_id_not' => $parkingAreaId,
            "is_multiple" => 1
        );
        $parkingAreaData = $this->parking_area_model->getParkingAreaData($filterData);
        // printArray($areaData,1);
        if(!empty($parkingAreaData)){
            $response['success'] = false;
            $response['msg'] = "Can/t Enter Same Parking number from Same Parking Area And Same Flat";
            echo json_encode($response);
            die();
        }

        $validation->setRule('parking_area_name', lang('ParkingArea.parking_area_name'), 'required');
        $validation->setRule('slot', lang('ParkingArea.slot'), 'required');
        $validation->setRule('vehicle_type', lang('ParkingArea.vehicle_type'), 'required');
        $validation->setRule('number_type', lang('ParkingArea.number_type'), 'required');

        // if($numberType == 'range'){
        //     // $validation->setRule('range_label', lang('ParkingArea.range_label'), 'required');
        //     $validation->setRule('range_start_from', lang('ParkingArea.range_start_from'), 'required');
        // }
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

            $duplicateVehicleTypeSelectedArray = array();
            if(!empty($parkingVehicleIdArray)){
                foreach ($parkingVehicleIdArray as $fcKey => $parkingVehicleId) {
                    $vehicleType = (!empty($vehicleTypeArray) && array_key_exists($fcKey, $vehicleTypeArray)) ? $vehicleTypeArray[$fcKey] : '';
                    if(!in_array($vehicleType,$duplicateVehicleTypeSelectedArray)){
                        $duplicateVehicleTypeSelectedArray[] = $vehicleType;
                    } else {
                        $response['success'] = false;
                        $response['msg'] = 'Duplicated Vehicle Type Selected for - ' . underscoreToUcWord($vehicleType);
                        echo json_encode($response);
                        exit;
                    }
                }
            }

            // $changeSlot = 0;
            // if(isset($parkingAreaId) && $parkingAreaId != ''){
            //     $filterData = array(
            //         "parking_area_id" => $parkingAreaId,
            //         "society_id" => $this->session->get('society_id'),
            //     );
            //     $parkingAreaData = $this->parking_area_model->getParkingAreaData($filterData);
            //     // printArray($parkingAreaData,1);
            //     if(!empty($parkingAreaData)){
            //         if ($parkingAreaData['slot'] != $slot) {
            //             $changeSlot = $slot - $parkingAreaData['slot'];
            //             if($changeSlot > 0){
            //                     if($numberType == 'range'){
            //                         $endRangeForm = $rangeStartFrom +$changeSlot;
            //                         for($j = $rangeStartFrom; $j<$endRangeForm; $j++) {
            //                             $parkingSlotArray = array(
            //                                 'parking_slot_id' => '',
            //                                 'parking_area_id' => $parkingAreaId,
            //                                 'number' => $rangeLabel.$j,
            //                                 'society_id' => $this->session->get('society_id'),
            //                                 'flat_id' => 0,
            //                                 'is_active' => isset($isActive) ? 1 : 0,
            //                             );
            //                             // printArray($parkingSlotArray,1);
            //                             $parkingSlotData = $this->parking_area_model->insertUpdateRecord($parkingSlotArray,'parking_slot_id','tbl_parking_slot', 1,'',array(),array(),array());
            //                         }
            //                     }
            //                     if($numberType == 'manual'){
            //                         for($j = 0; $j<$changeSlot; $j++) {
            //                             $parkingSlotArray = array(
            //                                 'parking_slot_id' => '',
            //                                 'parking_area_id' => $parkingAreaId,
            //                                 'number' => '',
            //                                 'society_id' => $this->session->get('society_id'),
            //                                 'flat_id' => 0,
            //                                 'is_active' => isset($isActive) ? 1 : 0,
            //                             );
            //                             $parkingSlotData = $this->parking_area_model->insertUpdateRecord($parkingSlotArray,'parking_slot_id','tbl_parking_slot', 1,'',array(),array(),array());
            //                         }
            //                     }
            //             } else {
            //                 $filterData = array(
            //                     'parking_area_id' => $parkingAreaId,
            //                     'society_id' => $this->session->get('society_id'),
            //                 );
            //                 $parkingSlotData = $this->parking_slot_model->getParkingSlotData($filterData);
            //                 if(!empty($parkingSlotData) && $parkingSlotData['flat_id'] != 0) {
            //                     $response['success'] = false;
            //                     $response['msg'] = lang("ParkingArea.flat_already_assigned");
            //                     echo json_encode($response);
            //                     exit;
            //                 } else {
            //                     $filterData = array(
            //                         'parking_area_id' => $parkingAreaId,
            //                         'society_id' => $this->session->get('society_id'),
            //                         'assigned_flat_id' => 0,
            //                         'is_multiple' => 1,
            //                     );
            //                     $notAssignedParkingSlotData = $this->parking_slot_model->getParkingSlotData($filterData);
            //                     if(!empty($notAssignedParkingSlotData) && count($notAssignedParkingSlotData) > abs($changeSlot)){
            //                         $notAssignedParkingSlotIdArray = array();
            //                         foreach ($notAssignedParkingSlotData as $key => $value) {
            //                             if($key < abs($changeSlot)) {
            //                                 $notAssignedParkingSlotIdArray[] = $value['parking_slot_id'];
            //                             }
            //                         }
            //                         $this->parking_slot_model->deleteRecord($notAssignedParkingSlotIdArray);
            //                     } else {
            //                         $response['success'] = false;
            //                         $response['msg'] = lang("ParkingArea.flat_already_assigned");
            //                         echo json_encode($response);
            //                         exit;
            //                     }
            //                 }
            //             }
            //         }
            //     }
            // }
            // printArray($changeSlot,1);   

            $parkingAreaUpdateArray = array();
            $parkingAreaArray = array(
                'parking_area_id' => $parkingAreaId,
                'parking_area_name' => $parkingAreaName,
                // 'vehicle_type' => $vehicleType,
                // 'slot' => $slot,
                // 'number_type' => $numberType,
                //'range_label' => $rangeLabel,
               //'range_start_from' => $rangeStartFrom,
                'society_id' => $this->session->get('society_id'),
                'is_active' => isset($isActive) ? 1 : 0,
            );

            // if($numberType == 'range'){
            //     $parkingAreaArray['range_label'] = $rangeLabel;
            //     $parkingAreaArray['range_start_from'] = $rangeStartFrom;
            // }
            if(!empty($parkingAreaId)){
                $parkingAreaUpdateData = $this->parking_area_model->getParkingAreaData(array(
                    'parking_area_id' => $parkingAreaId,
                ));
                $parkingAreaUpdateArray = compareArray($parkingAreaArray,$parkingAreaUpdateData);
            }
            $parkingAreaData = $this->parking_area_model->insertUpdateRecord($parkingAreaArray,'parking_area_id','tbl_parking_area', 1,'',array(),array(),$parkingAreaUpdateArray);
            $lastParkingAreaId = $parkingAreaData['lastInsertedId'];

            if (!empty($parkingVehicleIdArray)) {
                foreach ($parkingVehicleIdArray as $fkey => $parkingVehicleId) {
                    if(isset($parkingAreaId) && $parkingAreaId != ''){
                        if(!empty($parkingVehicleId)){
                            $filterData = array(
                                "parking_area_id" => $parkingAreaId,
                                "parking_vehicle_id" => $parkingVehicleId,
                                "society_id" => $this->session->get('society_id'),
                            );
                            $parkingAreaVehicleData = $this->parking_area_model->getParkingVehicleData($filterData);
                        }
                    }
                    $slot = array_key_exists($fkey, $slotArray) ? $slotArray[$fkey] : '';
                    $vehicleType = array_key_exists($fkey, $vehicleTypeArray) ? $vehicleTypeArray[$fkey] : '';
                    $numberType = array_key_exists($fkey, $numberTypeArray) ? $numberTypeArray[$fkey] : '';
                    $rangeLabel = array_key_exists($fkey, $rangeLabelArray) ? $rangeLabelArray[$fkey] : '';
                    $rangeStartFrom = array_key_exists($fkey, $rangeStartFromArray) ? $rangeStartFromArray[$fkey] : '';
                    
                    $parkingVehicleInsertUpdateArray = array(
                        'parking_vehicle_id' => $parkingVehicleId,
                        'parking_area_id' => $lastParkingAreaId,
                        'vehicle_type' => $vehicleType,
                        'slot' => $slot,
                        'number_type' => $numberType,
                        'range_label' => $rangeLabel,
                        'range_start_from' => $rangeStartFrom,
                        'created_by' => $this->data['userId'],
                        'updated_by' => $this->data['userId'],
                        'created_at' => date("Y-m-d H:i:s"),
                        'updated_at' => date("Y-m-d H:i:s"),
                    );
                    

                    $parkingVehicleData = $this->parking_area_model->insertUpdateRecord($parkingVehicleInsertUpdateArray, 'parking_vehicle_id', 'tbl_parking_vehicle', 1,'',array(),array(),array());
                    $lastParkingVehicleId = $parkingVehicleData['lastInsertedId'];

                    if($parkingVehicleId == ''){
                        if($numberType == 'range'){
                            $endRangeForm = $rangeStartFrom +$slot;
                            for($i = $rangeStartFrom; $i<$endRangeForm; $i++) {
                                $parkingSlotArray = array(
                                    'parking_slot_id' => '',
                                    'parking_area_id' => $lastParkingAreaId,
                                    'parking_vehicle_id' => $lastParkingVehicleId,
                                    'number' => $rangeLabel."-".$i,
                                    'society_id' => $this->session->get('society_id'),
                                    'flat_id' => 0,
                                    'is_active' => 1,
                                );
                                $parkingSlotData = $this->parking_area_model->insertUpdateRecord($parkingSlotArray,'parking_slot_id','tbl_parking_slot', 1,'',array(),array(),array());
                            }
                        }
                        if($numberType == 'manual'){
                            for($i = 1; $i<=$slot; $i++) {
                                $parkingSlotArray = array(
                                    'parking_slot_id' => '',
                                    'parking_area_id' => $lastParkingAreaId,
                                    'parking_vehicle_id' => $lastParkingVehicleId,
                                    'number' => '',
                                    'flat_id' => 0,
                                    'society_id' => $this->session->get('society_id'),
                                    'is_active' =>  1,
                                );
                                $parkingSlotData = $this->parking_area_model->insertUpdateRecord($parkingSlotArray,'parking_slot_id','tbl_parking_slot', 1,'',array(),array(),array());
                            }
                        }
                    }
                    else{
                        $changeSlot = 0;
                        if(isset($parkingAreaId) && $parkingAreaId != ''){
                            // printArray($parkingAreaVehicleData,1);
                            if(!empty($parkingAreaVehicleData)){
                                if ($parkingAreaVehicleData['slot'] != $slot) {
                                    $changeSlot = $slot - $parkingAreaVehicleData['slot'];
                                    if($changeSlot > 0){
                                            if($numberType == 'range'){
                                                $endRangeForm = $rangeStartFrom +$changeSlot;
                                                for($j = $rangeStartFrom; $j<$endRangeForm; $j++) {
                                                    $parkingSlotArray = array(
                                                        'parking_slot_id' => '',
                                                        'parking_area_id' => $parkingAreaId,
                                                        'parking_vehicle_id' => $lastParkingVehicleId,
                                                        'number' => $rangeLabel.$j,
                                                        'society_id' => $this->session->get('society_id'),
                                                        'flat_id' => 0,
                                                        'is_active' => isset($isActive) ? 1 : 0,
                                                    );
                                                    // printArray($parkingSlotArray,1);
                                                    $parkingSlotData = $this->parking_area_model->insertUpdateRecord($parkingSlotArray,'parking_slot_id','tbl_parking_slot', 1,'',array(),array(),array());
                                                }
                                            }
                                            if($numberType == 'manual'){
                                                for($j = 0; $j<$changeSlot; $j++) {
                                                    $parkingSlotArray = array(
                                                        'parking_slot_id' => '',
                                                        'parking_area_id' => $parkingAreaId,
                                                        'parking_vehicle_id' => $lastParkingVehicleId,
                                                        'number' => '',
                                                        'society_id' => $this->session->get('society_id'),
                                                        'flat_id' => 0,
                                                        'is_active' => isset($isActive) ? 1 : 0,
                                                    );
                                                    $parkingSlotData = $this->parking_area_model->insertUpdateRecord($parkingSlotArray,'parking_slot_id','tbl_parking_slot', 1,'',array(),array(),array());
                                                }
                                            }
                                    } else {
                                        $filterData = array(
                                            'parking_area_id' => $parkingAreaId,
                                            "parking_vehicle_id" => $parkingVehicleId,
                                            'society_id' => $this->session->get('society_id'),
                                            'assigned_flat_id' => 0,
                                            'is_multiple' => 1,
                                        );
                                        $notAssignedParkingSlotData = $this->parking_slot_model->getParkingSlotData($filterData);
                                        if(!empty($notAssignedParkingSlotData) && count($notAssignedParkingSlotData) >= abs($changeSlot)){
                                            $notAssignedParkingSlotIdArray = array();
                                            foreach ($notAssignedParkingSlotData as $key => $value) {
                                                if($key < abs($changeSlot)) {
                                                    $notAssignedParkingSlotIdArray[] = $value['parking_slot_id'];
                                                }
                                            }
                                            $this->parking_slot_model->deleteRecord($notAssignedParkingSlotIdArray);
                                        } else {
                                            $response['success'] = false;
                                            $response['msg'] = lang("ParkingArea.flat_already_assigned");
                                            echo json_encode($response);
                                            exit;
                                        } 
                                    }
                                }
                            }
                        }
                    }
                }
            }
            
            
            // if($parkingAreaId == ''){
            //     if($numberType == 'range'){
            //         $endRangeForm = $rangeStartFrom +$slot;
            //         for($i = $rangeStartFrom; $i<$endRangeForm; $i++) {
            //             $parkingSlotArray = array(
            //                 'parking_slot_id' => '',
            //                 'parking_area_id' => $lastParkingAreaId,
            //                 'number' => $rangeLabel.$i,
            //                 'society_id' => $this->session->get('society_id'),
            //                 'flat_id' => 0,
            //                 'is_active' => isset($isActive) ? 1 : 0,
            //             );
            //             $parkingSlotData = $this->parking_area_model->insertUpdateRecord($parkingSlotArray,'parking_slot_id','tbl_parking_slot', 1,'',array(),array(),array());
            //         }
            //     }
            //     if($numberType == 'manual'){
            //         for($i = 0; $i<$slot; $i++) {
            //             $parkingSlotArray = array(
            //                 'parking_slot_id' => '',
            //                 'parking_area_id' => $lastParkingAreaId,
            //                 'number' => '',
            //                 'society_id' => $this->session->get('society_id'),
            //                 'flat_id' => 0,
            //                 'is_active' => isset($isActive) ? 1 : 0,
            //             );
            //             $parkingSlotData = $this->parking_area_model->insertUpdateRecord($parkingSlotArray,'parking_slot_id','tbl_parking_slot', 1,'',array(),array(),array());
            //         }
            //     }
            // }
            $transactionStatus = $this->db->transComplete();
            if (isset($parkingAreaId) && $parkingAreaId != '') {
                if (($parkingAreaData['success']) && ($transactionStatus == 1)) {
                    $this->db->transCommit();
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('ParkingArea.parking_area'));
                } else {
                    $this->db->transRollback();
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('ParkingArea.parking_area'));
                }
            } else {
                if (($parkingAreaData['success']) && ($transactionStatus == 1)) {
                    $this->db->transCommit();
                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('ParkingArea.parking_area'));
                } else {
                    $this->db->transRollback();
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('ParkingArea.parking_area'));
                }
            }
            echo json_encode($response);
            exit();
        }

    }

    public function changeStatus()
    {
        $parkingAreaId = $this->request->getVar('parking_area_id');
        $status = $this->request->getVar('status');

        //$status         = ($status == 0) ? 1 : 0;
        $return = $this->parking_area_model->statusChange($parkingAreaId,$status,'parking_area_id','tbl_parking_area');
        if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('ParkingArea.parking_area'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('ParkingArea.parking_area'));
        }
        echo json_encode($response);
        exit();
    }


    public function delete()
    {
        $this->db->transStart();
        $parkingAreaId = $this->request->getVar('parking_area_id');
        if( isReferenceInTable('parking_area_id', 'tbl_parking_slot', $parkingAreaId)) {
            if (!empty($parkingAreaId)) {
                foreach ($parkingAreaId as $parkingArea) {
                    $deleteDataArray['module'] = 'Parking Area';
                    $deleteDataArray['activity'] = "Tried to delete Parking Area ";
                    $deleteDataArray['module_id'] = $parkingArea;
                    logActivity('Tried to delete Parking Area [ParkingAreaID: ' . $parkingArea . ']', $this->data['userId'], 'Parking Area', $parkingArea, json_encode($deleteDataArray), '', 'Parking Area', $parkingArea);
                }
            }

            $response['success'] = false;
            $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
            echo json_encode($response);
            exit;
        }
        $parkingAreaData = $this->parking_area_model->deleteRecord($parkingAreaId);
        $transactionStatus = $this->db->transComplete();
        if (($parkingAreaData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('ParkingArea.parking_area'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang('ParkingArea.parking_area'));
        }
        echo json_encode($response);
        exit;
    }

    public function getParkingAreaDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page            = $this->request->getVar('page');
        $parkingAreaId = $this->request->getVar('parking_area_id');

        $filterData = array(
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT,
            'is_active' => 1,
            'parking_area_id' => $parkingAreaId,

        );
        echo $this->parking_area_model->getParkingArea($filterData);
    }

    public function getParkingVehicleDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page            = $this->request->getVar('page');
        $parkingVehicleId = $this->request->getVar('parking_vehicle_id');
        $parkingAreaId = $this->request->getVar('parking_area_id');

        $filterData = array(
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT,
            'is_active' => 1,
            'parking_vehicle_id' => $parkingVehicleId,
            'parking_area_id' => $parkingAreaId,

        );
        echo $this->parking_area_model->getParkingVehicle($filterData);
    }

    public function excelExportParkingArea()
    {
        $fileName ='parking-area-' . DATETIMEFORMAT;
        $sheetName = 'Parking Area-' . DATEFORMAT;
        $excelHeaderName = 'Parking Area';
        $tableData = $this->getParkingAreaListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            lang('ParkingArea.parking_area'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                $row["parking_area_name"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'C';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }

    public function addParkingVehicleRow()
    {
        $data['row_number'] = $this->request->getVar("row_number");
        $memberRow = view('Admin/ParkingArea/ParkingVehicleTableRowView', $data);
        echo $memberRow;
    }

    public function deleteParkingVehicleRow()
    {
        $this->db->transStart();
        $parkingVehicleId  = $this->request->getVar('parking_vehicle_id');
        $parkingAreaId = $this->request->getVar('parking_area_id');

        $parkingSlotData = $this->parking_slot_model->getParkingSlotData(array(
            'parking_vehicle_id' => $parkingVehicleId,
            'parking_area_id' => $parkingAreaId,
            'is_multiple' => 1,
        ));

        if(count($parkingSlotData) > 0){
            $response['success'] = false;
            $response['msg'] = lang('CommonMessage.reference_other_module');
            echo json_encode($response);
            exit;
        };
        if( isReferenceInTable('parking_area_id', 'tbl_parking_slot', $parkingAreaId)) {
            if (!empty($parkingAreaId)) {
                foreach ($parkingAreaId as $parkingArea) {
                    $deleteDataArray['module'] = 'Parking Area';
                    $deleteDataArray['activity'] = "Tried to delete Parking Area ";
                    $deleteDataArray['module_id'] = $parkingArea;
                    logActivity('Tried to delete Parking Area [ParkingAreaID: ' . $parkingArea . ']', $this->data['userId'], 'Parking Area', $parkingArea, json_encode($deleteDataArray), '', 'Parking Area', $parkingArea);
                }
            }

            $response['success'] = false;
            $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
            echo json_encode($response);
            exit;
        }


        $parkingVehicleData = $this->parking_area_model->deleteParkingVehicleRecord($parkingVehicleId);
        if ($parkingVehicleData) {
            if(!empty($parkingVehicleId)){
                foreach($parkingVehicleId as $documentElement){
                    $deleteDataArray['module'] = 'Parking Vehicle';
                    $deleteDataArray['activity'] = "Parking Vehicle Deleted";
                    $deleteDataArray['module_id'] = $documentElement;
                    logActivity('Parking Vehicle Deleted [ParkingVehicleID: ' . $documentElement . ']',$this->data['userId'],'Parking Vehicle',$documentElement,json_encode($deleteDataArray),'','Parking Vehicle',$parkingAreaId);
                }
            }
            $transactionStatus = $this->db->transComplete();
            if($transactionStatus == 1){
                $response['success'] = true;
                $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('ParkingArea.parking_vehicle'));
            }
            else{
                $response['success'] = false;
                $response['msg']     = sprintf(lang('CommonMessage.delete_error'),lang('ParkingArea.parking_vehicle'));
            }
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('ParkingArea.parking_vehicle'));
        }
        echo json_encode($response);
        exit();
    }
}
