<?php
namespace App\Controllers\Admin;

use App\Models\MediaModel;
use App\Models\NoticeModel;
use CodeIgniter\Controller;
use App\Models\SocietyModel;
use App\Models\CommonWebServiceModel;
use App\Models\OwnershipFlatModel;
use App\Models\ManagementCommitteeModel;
use App\Models\RentalsModel;
use App\Models\ResourceTypeModel;
class Notice extends BaseController
{
    protected $notice_model;
    public function __construct() {
        $this->notice_model = new NoticeModel();
        $this->media_model = new MediaModel();
        $this->society_model = new SocietyModel();
        $this->common_web_service_model = new CommonWebServiceModel();
        $this->ownership_flat_model = new OwnershipFlatModel();
        $this->resource_type_model = new ResourceTypeModel();
        $this->rentals_model = new RentalsModel();
        $this->management_committee_model = new ManagementCommitteeModel();
        checkAndCreatePath(THUMBNAIL_MEDIA_IMAGE_PATH);
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );
        $data['title'] = 'Notice';
        return $this->dt_ci_template->load("Admin","Notice/NoticeView",$data);
    }

    public function getNoticeListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $this->datatables->table("tbl_notice as tn");
        $this->datatables->select("tn.notice_id,tn.notice_title,tn.notice_date,tn.expiry_date,tn.recipient,tn.description,tn.society_id,ts.society_name");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tn.updated_at");
        $this->datatables->select("GROUP_CONCAT(distinct(tc.category_name) SEPARATOR ',') as category_name");
        $this->datatables->select("(select count(*) from tbl_notification as tnoti where tnoti.society_id = tn.society_id AND tnoti.type_id = tn.notice_id AND tnoti.type = 'notice') as notification_count");
        $this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = tn.society_id","left");
        $this->datatables->join("society_user_master_view as tupdate","tupdate.user_society_id = tn.updated_by","left");
        $this->datatables->join("tbl_notice_category as tnc","tnc.notice_id = tn.notice_id","left");
        $this->datatables->join("tbl_category as tc","tc.category_id = tnc.category_id","left");
        $this->datatables->groupBy("tn.notice_id");

        accessFilter($this->datatables, array("society" => "tn.society_id"));

        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "notice_id" => isset($displayData['notice_id']) ? $displayData['notice_id'] : ""
                );
                $data[$key]['action_button'] = noticeActionButton($actionButtonFilter);
                $data[$key]['notice_date'] = isValidDate($displayData['notice_date']) ? siteDateFormat($displayData['notice_date']) : "";
                $data[$key]['expiry_date'] = isValidDate($displayData['expiry_date']) ? siteDateFormat($displayData['expiry_date']) : "";
                $data[$key]['recipient'] = isset($displayData['recipient']) ? underscoreToUcWord($displayData['recipient']) : "";
                $data[$key]['category_name'] = isset($displayData['category_name']) ? underscoreToUcWord($displayData['category_name']) : "";
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }

    public function manage($noticeId = '')
    {

        $data['extra_js'] = array(
            "js/jquery.form.min.js",
			"vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
			"vendor/libs/flatpickr/flatpickr.js",
			"js/validate.min.js",
			"js/additional_methods.min.js",
            "vendor/libs/ckeditor/ckeditor_classic.js",
        );

        if ($noticeId != '') {
            $filterData = array(
                "notice_id" => $noticeId
            );
            $data['notice_data'] = $this->notice_model->getNoticeData($filterData);

            $data['media_data'] = $this->media_model->getMediaData(array(
                "media_for" => 'notice',
                "media_for_id" => $noticeId,
                'is_multiple' => 1
            ));

            $noticeCategoryData = $this->notice_model->getNoticeCategoryData(array(
				"notice_id" => $noticeId,
				'is_multiple' => 1
			));
			$data['notice_category_data'] = $noticeCategoryData;

            $noticeTowerData = $this->notice_model->getNoticeTowerData(array(
				"notice_id" => $noticeId,
				'is_multiple' => 1
			));
			$data['notice_tower_data'] = $noticeTowerData;

            $noticeFlatData = $this->notice_model->getNoticeFlatData(array(
				"notice_id" => $noticeId,
				'is_multiple' => 1
			));
			$data['notice_flat_data'] = $noticeFlatData;

            if (empty($data['notice_data'])) {
                return redirect()->to('Admin/Notice');
            }
        }
        if ($noticeId != '') {
            $data['title'] = 'Edit Notice';
        } else {
            $data['title'] = 'Add Notice';
        }
        if ((isset($data['notice_data']['society_id']) && $data['notice_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/Notice');
        }
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Ajax)? $select2Ajax : array());
        $data['media_table'] = view('Admin/Media/MediaTableView', isset($data) ? $data : array());
        $this->dt_ci_template->load("Admin","Notice/NoticeManageView",$data);
    }

    public function save()
    {
        $this->db->transStart();
        $validation = \Config\Services::validation();

        $noticeId = $this->request->getVar('notice_id');
        $noticeTitle = $this->request->getVar('notice_title');
        $recipient = $this->request->getVar('recipient');
        $noticeDate = $this->request->getVar('notice_date');
        $expiryDate = $this->request->getVar('expiry_date');
        $description = $this->request->getVar('description');
        $notifiedTo = $this->request->getVar('notified_to');

        $validation->setRule('notice_title', lang('Notice.notice_title'), 'required');
        $validation->setRule('recipient', lang('Notice.recipient'), 'required');
        $validation->setRule('notice_date', lang('Notice.notice_date'), 'required');
        $validation->setRule('expiry_date', lang('Notice.expiry_date'), 'required');
        $validation->setRule('description', lang('Notice.description'), 'required');
        $validation->setRule('notified_to', lang('Notice.notified_to'), 'required');

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {
    
            // mediaValidation($_FILES);
            $mediaTitleArray = $this->request->getVar('media_title');
            $mediaSortOrderArray =$this->request->getVar('sort_order');
            $mediaIdArray = $this->request->getVar('media_id');
            $mediaTypeArray = $this->request->getVar('media_type');
            $mediaFileArray = $this->request->getVar('media_file');
            $commonMediaArray = $this->request->getVar('common_media');
            $mediaValidationArray = array(
                'media_file' => $mediaFileArray,
                'common_media' => $commonMediaArray,
                'media_type' => $mediaTypeArray,
                'media_id' => $mediaIdArray,
            );
            mediaValidation($_FILES,$mediaValidationArray);

            $imageFormatsForThumbnail = array('jpg', 'jpeg', 'png', 'JPG'); // Only these formats will have thumbnails
            $imageFormat = array_merge($imageFormatsForThumbnail, array('pdf','mp4','mp3'));
            $imageExtension = imageExtension($imageFormat);
            $mediaResult = array();
            if (isset($_FILES["media_file"])) {
                $mediaPath = MEDIA_IMAGE_PATH;
                $mediaResult = $this->dt_ci_file_upload->UploadMultipleFile('media_file', MAX_IMAGE_SIZE_LIMIT, $mediaPath, true, true, $imageExtension, true);
                if ($mediaResult['success'] == false) {
                    $response['success'] = false;
                    $response['msg'] = strip_tags($mediaResult['message']);
                    echo json_encode($response);
                    die();
                }
                else{
                    unset($mediaResult['success']);
                    foreach ($mediaResult as $file) {
                        $extension = pathinfo($file['file_name'], PATHINFO_EXTENSION);
                        if (in_array(strtolower($extension), $imageFormatsForThumbnail)) {
                            $thumbnailResult = $this->dt_ci_file_upload->ThumbnailUploadFile($file, MEDIA_IMAGE_PATH, THUMBNAIL_MEDIA_IMAGE_PATH);
                        }
                    }
                }
            }

            $noticeUpdateArray = array();
            $noticeArray = array(
                'notice_id' => $noticeId,
                'notice_title' => $noticeTitle,
                'recipient' => $recipient,
                'notified_to' => $notifiedTo,
                'notice_date' => DMYToYMD($noticeDate),
                'expiry_date' => DMYToYMD($expiryDate),
                'description' => $description,
                'society_id' => $this->session->get('society_id'),
            );

            if($recipient == 'all_management_committee_members(only_mc_members)'){
                $noticeArray['notified_to'] = 'complete_society';
            }

            if(!empty($noticeId)){
                $noticeUpdateData = $this->notice_model->getNoticeData(array(
                    'notice_id' => $noticeId,
                ));
                $noticeUpdateArray = compareArray($noticeArray,$noticeUpdateData);
            }

            
            $noticeData = $this->notice_model->insertUpdateRecord($noticeArray,'notice_id','tbl_notice', 1,'',array(),array(),$noticeUpdateArray);

            $lastNoticeId   = $noticeData['lastInsertedId'];
            $mediaFor = 'notice';
            $mediaForId = $lastNoticeId;

            include_once (APPPATH."Views/Admin/Media/v_media_insert_update.php");

            $noticeCategoryData = array();
            if(!empty($noticeId)) {
                $noticeCategoryData = $this->notice_model->getNoticeCategoryData(array(
                    'notice_id' => $noticeId,
                    'is_multiple' => 1
                ));
            }

			$categoryIdArray = $this->request->getVar('category_id[]');
            if(isset($noticeId) && $noticeId != ''){
                $this->notice_model->deleteNoticeCategoryRecord($noticeId);
            }

            if(isset($categoryIdArray)&& $categoryIdArray != ''){
                $categoryForArray = array();
                foreach($categoryIdArray as $categoryId){
                    $categoryForArray[] = array(
                        'notice_category_id' => '',
                        'notice_id' => $lastNoticeId,
                        'category_id' => $categoryId,
                        'created_at' => date('Y-m-d H:i:s'),
                        'updated_at' => date('Y-m-d H:i:s'),
                        'created_by' => $this->data['userId'],
                        'updated_by' => $this->data['userId']
                    );
                }
                $noticeSocietyExtraDataArray = array();
                $noticeSocietyExtraDataArray['module_id'] = $lastNoticeId;
                $noticeSocietyExtraDataArray['module'] = 'notice category';
                $noticeSocietyExtraDataArray['type'] = 'notice';
                $noticeSocietyExtraDataArray['old_data'] = $noticeCategoryData;
                $noticeSocietyExtraDataArray['user_id'] = $this->data['userId'];
                $noticeSocietyExtraDataArray['society_id'] = $this->session->get('society_id');

                if(!empty($categoryForArray)){
                    $this->notice_model->batchInsert($categoryForArray,'tbl_notice_category',$noticeSocietyExtraDataArray);
                }
            }

            $noticeTowerData = array();
            if(!empty($noticeId)) {
                $noticeTowerData = $this->notice_model->getNoticeTowerData(array(
                    'notice_id' => $noticeId,
                    'is_multiple' => 1
                ));
            }
            $towerIdArray = $this->request->getVar('tower_id[]');
            if(isset($noticeId) && $noticeId != ''){
                $this->notice_model->deleteNoticeTowerRecord($noticeId);
            }

            if(isset($notifiedTo) && $notifiedTo == 'selected_towers'){
                if(isset($towerIdArray)&& $towerIdArray != ''){
                    $towerArray = array();
                    foreach($towerIdArray as $towerId){
                        $towerArray[] = array(
                            'notice_tower_id' => '',
                            'notice_id' => $lastNoticeId,
                            'tower_id' => $towerId,
                            'created_at' => date('Y-m-d H:i:s'),
                            'updated_at' => date('Y-m-d H:i:s'),
                            'created_by' => $this->data['userId'],
                            'updated_by' => $this->data['userId']
                        );
                    }
                    $noticeSocietyExtraDataArray = array();
                    $noticeSocietyExtraDataArray['module_id'] = $lastNoticeId;
                    $noticeSocietyExtraDataArray['module'] = 'notice tower';
                    $noticeSocietyExtraDataArray['type'] = 'notice';
                    $noticeSocietyExtraDataArray['old_data'] = $noticeTowerData;
                    $noticeSocietyExtraDataArray['user_id'] = $this->data['userId'];
                    $noticeSocietyExtraDataArray['society_id'] = $this->session->get('society_id');
                    if(!empty($towerArray)){
                        $this->notice_model->batchInsert($towerArray,'tbl_notice_tower',$noticeSocietyExtraDataArray);
                    }
                }
            }
            
            $noticeFlatData = array();
            if(!empty($noticeId)) {
                $noticeFlatData = $this->notice_model->getNoticeFlatData(array(
                    'notice_id' => $noticeId,
                    'is_multiple' => 1
                ));
            }

            $flatIdArray = $this->request->getVar('flat_id[]');
            if(isset($noticeId) && $noticeId != ''){
                $this->notice_model->deleteNoticeFlatRecord($noticeId);
            }

            if(isset($notifiedTo) && $notifiedTo == 'selected_flats'){
                if(isset($flatIdArray)&& $flatIdArray != ''){
                    $flatArray = array();
                    foreach($flatIdArray as $flatId){
                        $flatArray[] = array(
                            'notice_flat_id' => '',
                            'notice_id' => $lastNoticeId,
                            'flat_id' => $flatId,
                            'created_at' => date('Y-m-d H:i:s'),
                            'updated_at' => date('Y-m-d H:i:s'),
                            'created_by' => $this->data['userId'],
                            'updated_by' => $this->data['userId']
                        );
                    }
                    $noticeSocietyExtraDataArray = array();
                    $noticeSocietyExtraDataArray['module_id'] = $lastNoticeId;
                    $noticeSocietyExtraDataArray['module'] = 'notice flat';
                    $noticeSocietyExtraDataArray['type'] = 'notice';
                    $noticeSocietyExtraDataArray['old_data'] = $noticeFlatData;
                    $noticeSocietyExtraDataArray['user_id'] = $this->data['userId'];
                    $noticeSocietyExtraDataArray['society_id'] = $this->session->get('society_id');
                    if(!empty($flatArray)){
                        $this->notice_model->batchInsert($flatArray,'tbl_notice_flat',$noticeSocietyExtraDataArray);
                    }
                }
            }
        }
        $transactionStatus = $this->db->transComplete();
            if (isset($noticeId) && $noticeId != '') {
                if (($noticeData['success']) && ($transactionStatus == 1)) {
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('Notice.notice'));
                } else {
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('Notice.notice'));
                }
            } else {
                if (($noticeData['success']) && ($transactionStatus == 1)) {

                    $userSocietyIdArray = array();
                    $customerDataArray = array();
                    $batchNotificationDataArray = array();
                    $notificationArray = array(
                        'notification_title' => 'New Notice Published',
                        'description' => 'A new notice titled '.$noticeTitle.' has been published by the management. Please check the app to read the full details.',
                    );
                    $deviceIdArray = array();
                    $iosDeviceIdArray = array();
                    $customerData['title_name'] = isset($notificationArray['notification_title']) ? $notificationArray['notification_title'] : "";
                    $customerData['description'] = isset($notificationArray['description']) ? $notificationArray['description'] : "";
                    $ownerUserSocietyIdArray = array();
                    $batchNotificationDataArray = array();
                    $rentalMemberIdArray = array();
                    $mobileNoArray = array();
                    $ownerMemberIdArray = array();
                    $rentalMobileNoArray = array();
                    $notificationMergeArray = array();
                    $userMergeData = array();
                    $memberIdArray = array();
                    $sendNotificationDataArray = array();

                    $resourceTypeMemberData = $this->resource_type_model->getResourceTypeData(array(
                        'resource_type_name' => RESOURCE_TYPE_MEMBER,
                        'society_id' => $this->session->get('society_id'),
                    ));

                    $resourceTypeManagerData = $this->resource_type_model->getResourceTypeData(array(
                        'resource_type_name' => RESOURCE_TYPE_MANAGER,
                        'society_id' => $this->session->get('society_id'),
                    ));

                    if($recipient == 'all_residents(owners_and_tenants)'){
                        if($notifiedTo == 'complete_society'){
                            $completeSocietyFilteredArray = array(
                                'society_id' => $this->session->get('society_id'),
                                'is_active' => 1,
                                'is_multiple' => 1
                            );

                            $ownershipFlatMemberData = $this->ownership_flat_model->getOwnershipFlatMemberData($completeSocietyFilteredArray);
                            if(!empty($ownershipFlatMemberData)){
                                foreach ($ownershipFlatMemberData as $ownershipFlatMember) {
                                    $memberIdArray[] = $ownershipFlatMember['member_id'];
                                }
                            }
                            if(!empty($memberIdArray)){
                                $userSocietyData = $this->common_web_service_model->getUserSocietyData(array(
                                    "type_id" => $memberIdArray,
                                    "resource_type_id" => $resourceTypeMemberData['resource_type_id'],
                                    'society_id' => $this->session->get('society_id'),
                                    'is_multiple' => 1
                                ));
                                if(!empty($userSocietyData)){
                                    foreach ($userSocietyData as $userElement) {
                                        $userSocietyIdArray[] = $userElement['user_society_id'];
                                    }
                                }
                            }
                        }
                        else{
                            if($notifiedTo == 'selected_towers'){
                                $allResidentFilterArray = array(
                                    'tower_id' => $towerId,
                                    'is_show_all_member' => 1,
                                    'is_multiple' => 1,
                                    'is_active' => 1
                                ); 
                            }
                            else if($notifiedTo == 'selected_flats'){
                                $allResidentFilterArray = array(
                                    'flat_id' => $flatId,
                                    'is_show_all_member' => 1,
                                    'is_multiple' => 1,
                                    'is_active' => 1
                                );
                            } 

                            $ownershipFlatMemberData = $this->ownership_flat_model->getOwnershipFlatMemberData($allResidentFilterArray);
                            
                            if(!empty($ownershipFlatMemberData)){
                                foreach ($ownershipFlatMemberData as $ownershipFlatMember) {
                                    $memberIdArray[] = $ownershipFlatMember['member_id'];
                                }
                            }
                            if(!empty($memberIdArray)){
                                $userSocietyData = $this->common_web_service_model->getUserSocietyData(array(
                                    "type_id" => $memberIdArray,
                                    "resource_type_id" => $resourceTypeMemberData['resource_type_id'],
                                    'society_id' => $this->session->get('society_id'),
                                    'is_multiple' => 1
                                ));
                                if(!empty($userSocietyData)){
                                    foreach ($userSocietyData as $userElement) {
                                        $userSocietyIdArray[] = $userElement['user_society_id'];
                                    }
                                }
                            }
                        }
                    }
                    if($recipient == 'all_management_committee_members(only_mc_members)'){
                        $userSocietyData = array();
                        $managementCommitteeData = $this->management_committee_model->getManagementCommitteeData(array(
                            'society_id' => $this->session->get('society_id'),
                            'is_active' => 1,
                            'is_multiple' => 1
                        ));
                        if(!empty($managementCommitteeData)){
                            foreach($managementCommitteeData as $managementCommitteeElement){
                                $memberIdArray[] = $managementCommitteeElement['member_id'];
                            }
                        }
                        if(!empty($memberIdArray)){
                            
                            $ownershipFlatMemberData = $this->ownership_flat_model->getOwnershipFlatMemberData(array(
                                'ownership_flat_member_id' => $memberIdArray,
                                'is_show_all_member' => 1,
                                'is_multiple' => 1,
                                'is_active' => 1
                            ));
                            if(!empty($ownershipFlatMemberData)){
                                foreach ($ownershipFlatMemberData as $ownershipFlatMember) {
                                    $memberIdArray[] = $ownershipFlatMember['member_id'];
                                }
                            }
                            if(!empty($ownershipFlatMemberData)){
                                $userSocietyData = $this->common_web_service_model->getUserSocietyData(array(
                                    "type_id" => $memberIdArray,
                                    "resource_type_id" => $resourceTypeMemberData['resource_type_id'],
                                    'society_id' => $this->session->get('society_id'),
                                    'is_multiple' => 1 
                                ));
                            }
                            if(!empty($userSocietyData)){
                                foreach ($userSocietyData as $userElement) {
                                    $userSocietyIdArray[] = $userElement['user_society_id'];
                                }
                            }
                        }
                    }
                    else{
                        if($notifiedTo == 'selected_towers'){
                            $allOwnerFilterArray = array(
                                'is_latest' => 1,
                                'is_show_all_member' => 1,
                                'is_multiple' => 1,
                                'is_owner' => 1,
                                'is_active' => 1,
                                'tower_id' => $towerId,
                            );
                        }
                        else if($notifiedTo == 'selected_flats'){
                            $allOwnerFilterArray = array(
                                'is_latest' => 1,
                                'is_show_all_member' => 1,
                                'is_multiple' => 1,
                                'is_owner' => 1,
                                'is_active' => 1,
                                'flat_id' => $flatId,
                            );
                        }
                        else{
                            $allOwnerFilterArray = array(
                                'is_latest' => 1,
                                'is_show_all_member' => 1,
                                'is_multiple' => 1,
                                'is_owner' => 1,
                                'is_active' => 1
                            ); 
                        }
                        $ownershipFlatMemberData = $this->ownership_flat_model->getOwnershipFlatMemberData($allOwnerFilterArray);
                        if(!empty($ownershipFlatMemberData)){
                            foreach ($ownershipFlatMemberData as $ownershipFlatMember) {
                                $ownerMemberIdArray[] = $ownershipFlatMember['member_id'];
                            }
                        }
                        
                        if($recipient == 'all_owners_and_tenants(resident_and_non_resident)'){
                            if($notifiedTo == 'selected_towers'){
                                $allRentalsFilterArray = array(
                                    'check_rental_start' => 1,
                                    'is_multiple' => 1,
                                    'is_active' => 1,
                                    'tower_id' => $towerId,
                                );
                            }
                            else if($notifiedTo == 'selected_flats'){
                                $allRentalsFilterArray = array(
                                    'check_rental_start' => 1,
                                    'is_multiple' => 1,
                                    'is_active' => 1,
                                    'flat_id' => $flatId,
                                );
                            }
                            else{
                                $allRentalsFilterArray = array(
                                    'check_rental_start' => 1,
                                    'is_multiple' => 1,
                                    'is_active' => 1
                                ); 
                            }
                            $rentalMemberData = $this->rentals_model->getRentalsMemberData($allRentalsFilterArray);
                            if(!empty($rentalMemberData)){
                                foreach ($rentalMemberData as $rentalMember) {
                                    $rentalMemberIdArray[] = $rentalMember['member_id'];
                                }
                            }
                            $memberIdArray = array_merge($ownerMemberIdArray,$rentalMemberIdArray);
                        }
                        else{
                            $memberIdArray = $ownerMemberIdArray;
                        }
                    
                        if(!empty($ownershipFlatMemberData)){
                            $userSocietyData = $this->common_web_service_model->getUserSocietyData(array(
                                "type_id" => $memberIdArray,
                                'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                                'society_id' => $this->session->get('society_id'),
                                'is_multiple' => 1
                            ));
                            if(!empty($userSocietyData)){
                                foreach ($userSocietyData as $userElement) {
                                    $userSocietyIdArray[] = $userElement['user_society_id'];
                                }
                            }
                        }
                    }
                    if(!empty($userSocietyIdArray)){
                        $userDeviceArray = $this->common_web_service_model->deviceData(array(
                            "user_society_id" => $userSocietyIdArray,
                            "is_latest" => 1,
                            "is_multiple" => 1,
                        ));

                        
                    }
                    if(!empty($userDeviceArray)){

                        foreach($userDeviceArray as $userDevice){
                            $notificationOtherArray = array(
                                'notification_id' => '',
                                'society_id' => $this->session->get('society_id'),
                                'notification_date' => TODAY_DATE_YMD,
                                'notification_for' => (isset($userDevice['device_type'])) ? strtolower($userDevice['device_type']) : "",
                                'type' => 'notice',
                                'type_id' => $lastNoticeId,
                                // 'module' => 'poll',
                                'created_by' => $this->data['userId'],
                                'updated_by' => $this->data['userId'],
                                'created_at' => date("Y-m-d H:i:s"),
                                'updated_at' => date("Y-m-d H:i:s"),
                            );
                            $notificationOtherArray['send_for_notification'] = 'manager';
                            $notificationOtherArray['send_for_notification_id'] = $this->data['userId'];
                            $notificationOtherArray['receive_for_notification'] = $userDevice['user_type'];
                            $notificationOtherArray['receive_for_notification_id'] = $userDevice['user_type_id'];
                            if(!empty($notificationArray)){
                                $notificationMergeArray = array_merge($notificationArray,$notificationOtherArray);
                                $extraDataJsonArray = $notificationMergeArray;
                                $extraDataJsonArray['module'] = 'notice';
                                $extraDatajson = json_encode($extraDataJsonArray);
                                $notificationMergeArray['extra_data'] = $extraDatajson;
                                $customerData['extra_data'] = $extraDatajson;
                                //send notification data
                                $deviceToken = $userDevice['one_signal_id'];
                                $deviceId = $userDevice['device_id'];
                                $batchNotificationDataArray[] = $notificationMergeArray;
                                // if(strtolower($userDevice['device_type']) == 'android'){
                                //     if (!empty($deviceId)) {
                                //         array_push($deviceIdArray,$deviceId);
                                //     }
                                // } else {
                                //     if (!empty($deviceId)) {
                                //         array_push($iosDeviceIdArray,$deviceId);
                                //     }
                                // }

                                $sendNotificationDataArray[] = array(
                                    'notification_title' => 'New Notice Published',
                                    'description' => 'A new notice titled '.$noticeTitle.' has been published by the management. Please check the app to read the full details.',
                                    'extra_data_json' => $extraDatajson,
                                    'app_url' => MEMBER_URL .'notice_board_detail/' . $lastNoticeId,
                                    'notification_for' => (isset($userDevice['device_type'])) ? strtolower($userDevice['device_type']) : "",
                                    'device_id' => $userDevice['device_id'],
                                    'type' => 'notice',
                                );
                            }
                        }
                    }
                    if(!empty($batchNotificationDataArray)){
                        $this->ownership_flat_model->batchInsert($batchNotificationDataArray,'tbl_notification');
                    }
                    if(!empty($sendNotificationDataArray)){
                        sendNotification($sendNotificationDataArray);
                    }
                    // $sendNotificationData = array();
                    // if(!empty($deviceIdArray)){
                    //     $customerData['device_id'] = $deviceIdArray;
                    //     $customerData['app_url'] = MEMBER_URL .'notice_board_detail/' . $lastNoticeId;
                    //     $sendNotificationData = $customerData;
                    //     sendNotificationAndroid($sendNotificationData);
                    // }
                    // $sendNotificationIOSData = array();
                    // if(!empty($iosDeviceIdArray)){
                    //     $customerData['device_id'] = $iosDeviceIdArray;
                    //     $sendNotificationIOSData = $customerData;
                    //     sendNotificationIOS($sendNotificationIOSData);
                    // }
                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('Notice.notice'));
                } else {
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('Notice.notice'));
                }
            }
            echo json_encode($response);
            exit();
        }


    public function delete()
    {
        $this->db->transStart();
        $noticeId = $this->request->getVar('notice_id');
        $noticeImageData = $this->media_model->getMediaData(array(
            "media_for" => 'notice',
            "media_for_id" => $noticeId,
            'is_multiple' => 1
        ));
        if(is_array($noticeImageData) && !empty($noticeImageData)){
            foreach ($noticeImageData as $image){
                $fileUrl = '';
                if(isset($image['media_file']) && $image['media_file'] != '') {
                    $fileUrl = MEDIA_IMAGE_PATH . $image['media_file'];
                }
                if (file_exists($fileUrl)) {
                    unlink($fileUrl);
                }

                $thumbnailFileUrl = '';
                if(isset($image['media_file']) && $image['media_file'] != '') {
                    $thumbnailFileUrl = THUMBNAIL_MEDIA_IMAGE_PATH . $image['media_file'];
                }
                if (file_exists($thumbnailFileUrl)) {
                    unlink($thumbnailFileUrl);
                }
            }
        }
        $noticeData = $this->notice_model->deleteRecord($noticeId);
        $noticeCategoryData = $this->notice_model->deleteNoticeCategoryRecord($noticeId);
        $noticeTowerData = $this->notice_model->deleteNoticeTowerRecord($noticeId);
        $noticeFlatData = $this->notice_model->deleteNoticeFlatRecord($noticeId);

        $filterData = array(
            "media_for" => "notice",
            "media_for_id" => $noticeId
        );
        $deleteMedia = $this->media_model->deleteRecordMedia($filterData);
        $transactionStatus = $this->db->transComplete();
        if (($noticeData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Notice.notice'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang('Notice.notice'));
        }
        echo json_encode($response);
        exit;
    }

    public function getNoticeDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page            = $this->request->getVar('page');
        $noticeId = $this->request->getVar('notice_id');
        $societyId = $this->request->getVar('society_id');

        $filterData = array(
            'notice_id' => $noticeId,
            'society_id' => $societyId,
        );
        echo $this->notice_model->getNotice($filterData);
    }


    public function view($id = null)
    {
        $noticeId = $this->request->getVar("view_id");     
        if($noticeId == "" && $noticeId == null){
            return redirect()->to('Admin/Notice');
        }
        else {
            
            $filterData = array(
                "notice_id" => $noticeId
            );
           
            $data['notice_data'] = $this->notice_model->getNoticeData($filterData);

            $data['media_data'] = $this->media_model->getMediaData(array(
                "media_for" => 'notice',
                "media_for_id" => $noticeId,
                'is_multiple' => 1
            ));

            $noticeCategoryData = $this->notice_model->getNoticeCategoryData(array(
				"notice_id" => $noticeId,
				'is_multiple' => 1
			)); 
			$data['notice_category_data'] = $noticeCategoryData;
           

            $noticeTowerData = $this->notice_model->getNoticeTowerData(array(
				"notice_id" => $noticeId,
				'is_multiple' => 1
			));
			$data['notice_tower_data'] = $noticeTowerData;

            $noticeFlatData = $this->notice_model->getNoticeFlatData(array(
				"notice_id" => $noticeId,
				'is_multiple' => 1
			));
			$data['notice_flat_data'] = $noticeFlatData;
            

            $noticeView = view("Admin/Notice/NoticeModelView", $data);
            $response['view_title'] = "Notice Details";
            $response['view_detail'] = $noticeView;
            $response['success'] = true;
            echo json_encode($response);
        }
    }

    public function excelExportNotice()
    {
        $fileName ='notice-' . DATETIMEFORMAT;
        $sheetName = 'Notice-' . DATEFORMAT;
        $excelHeaderName = 'Notice';
        $tableData = $this->getNoticeListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            // lang('Notice.society'),
            lang('Notice.notice_title'),
            lang('Notice.category'),
            lang('Notice.recipients'),
            lang('Notice.notice_date'),
            lang('Notice.expiry_date'),
            lang('Notice.description'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                // $row["society_name"],
                $row["notice_title"],
                $row["category_name"],
                $row["recipient"],
                $row["notice_date"],
                $row["expiry_date"],
                $row["description"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'H';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }

   
    public function addMediaRow()
    {
        $data['row_number'] = $this->request->getVar("row_number");
        $itemRow = view('Admin/Media/MediaTableRowView', $data);
        echo $itemRow;
    }

    public function deleteMediaRow()
    {
        $this->db->transStart();
        $mediaId = $this->request->getVar('row_id');
        $mediaResponse = $this->media_model->getMediaData(array('media_id' => $mediaId));
        $imageUrl = '';
        if (isset($mediaResponse['media_file']) && $mediaResponse['media_file'] != '') {
            $imageUrl = MEDIA_IMAGE_PATH. $mediaResponse['media_file'];
        }
        if (file_exists($imageUrl)) {
            unlink($imageUrl);
        }

        $thumbnailImageUrl = '';
        if (isset($mediaResponse['media_file']) && $mediaResponse['media_file'] != '') {
            $thumbnailImageUrl = THUMBNAIL_MEDIA_IMAGE_PATH. $mediaResponse['media_file'];
        }
        if (file_exists($thumbnailImageUrl)) {
            unlink($thumbnailImageUrl);
        }

        $deleteResponse = $this->media_model->deleteMediaRecord($mediaId);
        $transactionStatus = $this->db->transComplete();
        if ((isset($deleteResponse['success']) && $deleteResponse['success']) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg'] = sprintf(lang('CommonMessage.delete_record'), lang("CommonMessage.common_media"));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'), lang("CommonMessage.common_media"));
        }

        echo json_encode($response);
        exit;
    }
}
