<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\MenPowerAttendanceModel;
class MenPowerAttendance extends BaseController
{
	protected $men_power_attendance_model;
    public function __construct() {
        $this->men_power_attendance_model = new MenPowerAttendanceModel();
    }
	public function index()
	{
		$data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
			"vendor/libs/moment/moment.js",
			"vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
        $data['title'] = 'Men Power Attendance';
		$dataFilters['filters'] = array(
            array(
                "type" => "multi_select",
                "dynamic" => true,
                "class" => "resourceTypeDd",
                "id" => "filter_resource_type_id",
                "name" => "filter_resource_type_id",
                "title" => "MenPowerAttendance.resource_type",
            ),
            array(
                "type" => "multi_select",
                "dynamic" => true,
                "class" => "resourceDd",
                "id" => "filter_resource_id",
                "name" => "filter_resource_id",
                "title" => "MenPowerAttendance.resource",
            ),
			array(
                "type" => "daterange",
                "id" => "filter_date",
                "name" => "filter_date",
                "title" => "MenPowerAttendance.date",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_created_at",
                "name" => "filter_created_at",
                "title" => "CommonMessage.common_created_at",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_updated_at",
                "name" => "filter_updated_at",
                "title" => "CommonMessage.common_updated_at",
            ),
        );

        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Ajax)? $select2Ajax : array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());    
        return $this->dt_ci_template->load("Admin","MenPowerAttendance/MenPowerAttendanceView",$data);
	}

	public function manage($menPowerAttendanceId = '')
	{

		$data['extra_js'] = array(
            "js/jquery.form.min.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/bootstrap-datepicker/bootstrap-datepicker.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
        );

        if ($menPowerAttendanceId != '') {
			$filterData = array(
				"men_power_attendance_id" => $menPowerAttendanceId
			);
			$data['men_power_attendance_data'] = $this->men_power_attendance_model->getMenPowerAttendanceData($filterData);
		}
		if ($menPowerAttendanceId != '') {
			$data['title'] = 'Edit Men Power Attendance';
		} else {
			$data['title'] = 'Add Men Power Attendance';
		}

		if ((isset($data['men_power_attendance_data']['society_id']) && $data['men_power_attendance_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/MenPowerAttendance');
        }
		$data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Ajax)? $select2Ajax : array());
		return $this->dt_ci_template->load("Admin","MenPowerAttendance/MenPowerAttendanceManageView",$data);
	}

    public function getMenPowerAttendanceListing($return = false,$filterData=array())
    {
    	if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }

		$createdAt = $this->request->getVar("filter_created_at");
		$updatedAt = $this->request->getVar("filter_updated_at");
		$resourceTypeId = $this->request->getVar("filter_resource_type_id");
		$date = $this->request->getVar("filter_date");
        $this->datatables->table("tbl_men_power_attendance as tmpa");
		$this->datatables->select("tmpa.men_power_attendance_id,ts.society_name,ts.society_name,tmpa.is_active,tmpa.in_time,tmpa.out_time,tmpa.men_power_attendance_date,tresource.resource_name,trt.resource_type_name");
		$this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tmpa.updated_at,tmpa.resource_id");
		$this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = tmpa.society_id","left");
		$this->datatables->join("tbl_resource as tresource","tresource.resource_id = tmpa.resource_id","left");
        $this->datatables->join("tbl_resource_type as trt","trt.resource_type_id = tresource.resource_type_id","left");
		$this->datatables->join("society_user_master_view as tupdate","tupdate.user_society_id = tmpa.updated_by","left");

        if (isset($resourceTypeId)) {
            if (is_array($resourceTypeId)) {
                $this->datatables->whereIn("tresource.resource_type_id", $resourceTypeId);
            } else {
                $this->datatables->where("tresource.resource_type_id", $resourceTypeId);
            }
        }

		if(isset($resourceId)) {
            if(is_array($resourceId)){
                $this->datatables->whereIn("tmpa.resource_id",$resourceId);
            } else {
                $this->datatables->where("tmpa.resource_id",$resourceId);
            }
        }

		if($date != ''){
            list($fromDate,$toDate) = explode(" - ",$date);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tmpa.men_power_attendance_date,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tmpa.men_power_attendance_date,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tmpa.men_power_attendance_date,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }
		if($createdAt != ''){
            list($fromDate,$toDate) = explode(" - ",$createdAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tmpa.created_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tmpa.created_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tmpa.created_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }
        if($updatedAt != ''){
            list($fromDate,$toDate) = explode(" - ",$updatedAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tmpa.updated_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tmpa.updated_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tmpa.updated_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }

		$this->datatables->groupBy("tmpa.men_power_attendance_id");
		accessFilter($this->datatables, array("society" => "tmpa.society_id"));
		$dataReport =  $this->datatables->generate();
		$dataReport = json_decode($dataReport, true);
		$data       = $dataReport['data'];
		if(count($data) > 0){
			foreach($data as $key => $displayData){
				$actionButtonFilter = array(
					"men_power_attendance_id" => isset($data[$key]['men_power_attendance_id']) ? $data[$key]['men_power_attendance_id'] : ""
				);
				$data[$key]['action_button'] = menPowerAttendanceActionButton($actionButtonFilter);
				$data[$key]['men_power_attendance_date'] = isValidDate($data[$key]['men_power_attendance_date']) ? siteDateFormat($data[$key]['men_power_attendance_date']) : "";
				$data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
				$data[$key]['in_time'] = isset($displayData['in_time']) ? date("H:i", strtotime($displayData['in_time'])) : '';
				$data[$key]['in_time_display'] = isset($displayData['in_time']) ? date("h:i A", strtotime($displayData['in_time'])) : '';
				$data[$key]['out_time'] = isset($displayData['out_time']) ? date("H:i", strtotime($displayData['out_time'])) : '';
				$data[$key]['out_time_display'] = isset($displayData['out_time']) ? date("h:i A", strtotime($displayData['out_time'])) : '';
				$data[$key]['excel_resource_name'] = isset($displayData['resource_name']) ?  $displayData['resource_name'] : "";
				$data[$key]['resource_name'] = isset($displayData['resource_name']) ?  resourceDocumentToHtml($displayData['resource_name'],$displayData['resource_id']) : "";
                $data[$key]['resource_type'] = isset($displayData['resource_type']) ?  underscoreToUcWord($displayData['resource_type']) : "";
			}
		}

		if($return){
			return $data;
		}else{
			$dataReport['data'] = $data;
			echo json_encode($dataReport);
			exit;
		}
        
    }

    public function changeStatus(){
        $menPowerAttendanceId = $this->request->getVar('men_power_attendance_id');
        $status = $this->request->getVar('status');
        $return = $this->men_power_attendance_model->statusChange($menPowerAttendanceId,$status,'men_power_attendance_id','tbl_men_power_attendance');
		if ($return == 1) {
			$response['success'] = true;
			$response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('MenPowerAttendance.men_power_attendance'));
		} else {
			$response['success'] = false;
			$response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('MenPowerAttendance.men_power_attendance'));
		}
		echo json_encode($response);
		exit;
    }

    public function save()
	{
		$validation = \Config\Services::validation();
		$menPowerAttendanceId = $this->request->getVar('men_power_attendance_id');
		$resourceId = $this->request->getVar("resource_id");
		$menPowerAttendanceDate = $this->request->getVar("men_power_attendance_date");
		$inTime = $this->request->getVar("in_time");
		$outTime = $this->request->getVar("out_time");
		$isActive = $this->request->getVar("is_active");

		$validation->setRule('men_power_attendance_date', lang('MenPowerAttendance.men_power_attendance_date'), 'required');
		// $validation->setRule('resource_id', lang('MenPowerAttendance.resource_id'), 'required');
		$validation->setRule('in_time', lang('MenPowerAttendance.in_time'), 'required');
		$validation->setRule('out_time', lang('MenPowerAttendance.out_time'), 'required');
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {
			if (strtotime($inTime) > strtotime($outTime)){
				$response['success'] = false;
				$response['msg'] = lang('MenPowerAttendance.men_power_in_out_time_message');
				echo json_encode($response);
				exit;
			}
			
			$menPowerAttendanceUpdateArray = array();
			$menPowerAttendanceArray = array(
				'men_power_attendance_id' => $menPowerAttendanceId,
				'in_time' => date('H:i',strtotime($inTime)),
				'out_time' => date('H:i',strtotime($outTime)),
				'society_id' => $this->session->get('society_id'),
				'resource_id' => $resourceId,
				'men_power_attendance_date' => DMYToYMD($menPowerAttendanceDate),
				'is_active' => isset($isActive) ? 1 : 0,
			);
			if(!empty($menPowerAttendanceId)){
                $menPowerAttendanceUpdateData = $this->men_power_attendance_model->getMenPowerAttendanceData(array(
                    'men_power_attendance_id' => $menPowerAttendanceId,
                ));
                $menPowerAttendanceUpdateArray = compareArray($menPowerAttendanceArray,$menPowerAttendanceUpdateData);
            }
			$menPowerAttendanceData = $this->men_power_attendance_model->insertUpdateRecord($menPowerAttendanceArray, 'men_power_attendance_id', 'tbl_men_power_attendance', 1,'',array(),array(),$menPowerAttendanceUpdateArray);
			$lastMenPowerAttendanceId = $menPowerAttendanceData['lastInsertedId'];
			if (isset($menPowerAttendanceId) && $menPowerAttendanceId != '') {
				if ($menPowerAttendanceData['success']) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.update_record'), lang("MenPowerAttendance.men_power_attendance"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.update_record_error'), lang("MenPowerAttendance.men_power_attendance"));
				}
			} else {
				if ($menPowerAttendanceData['success']) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.create_record'), lang("MenPowerAttendance.men_power_attendance"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.create_record_error'), lang("MenPowerAttendance.men_power_attendance"));
				}
			}
			echo json_encode($response);
			exit;
		}
	}

    public function delete()
    {
        $this->db->transStart();
        $menPowerAttendanceId = $this->request->getVar('men_power_attendance_id');
        $menPowerAttendanceData = $this->men_power_attendance_model->deleteRecord($menPowerAttendanceId);
        $transactionStatus = $this->db->transComplete();
        if (($menPowerAttendanceData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg'] = sprintf(lang('CommonMessage.delete_record'), lang("MenPowerAttendance.men_power_attendance"));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'), lang("MenPowerAttendance.men_power_attendance"));
        }
        echo json_encode($response);
        exit;
    }

    public function excelExportMenPowerAttendance()
    {
        $fileName ='mpa-' . DATETIMEFORMAT;
        $sheetName = 'MPA-' . DATEFORMAT;
        $excelHeaderName = 'Men Power Attendance';
        $tableData = $this->getMenPowerAttendanceListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            // lang('MenPowerAttendance.society'),
            lang('MenPowerAttendance.resource'),
            lang('MenPowerAttendance.men_power_attendance_date'),
            lang('MenPowerAttendance.in_time'),
            lang('MenPowerAttendance.out_time'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                // $row["society_name"],
                $row["excel_resource_name"],
                $row["men_power_attendance_date"],
                $row["in_time_display"],
                $row["out_time_display"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'F';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }

}
