<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\MaterialModel;
use App\Models\ItemBalanceModel;
use App\Models\SocietyModel;

class Material extends BaseController
{
    protected $material_model;
    public function __construct() {
        $this->material_model = new MaterialModel();
        $this->item_balance_model = new ItemBalanceModel();
        $this->society_model = new SocietyModel();

    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/moment/moment.js",
            "vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
        $data['title'] = 'Material';

        $dataFilters['filters'] = array(
            array(
                "type" => "multi_select",
                "dynamic" => true,
                "class" => "commonAreaDd",
                "id" => "filter_common_area_id",
                "name" => "filter_common_area_id",
                "title" => "Material.common_area",
            ),
            array(
                "type" => "material_type",
                "id" => "filter_material_type",
                "name" => "filter_material_type",
                "title" => "Material.material_type",
            ),
            array(
                "type" => "common_filter_form_submit",
                "id" => "filter_form_submit",
                "name" => "filter_form_submit",
                "title" => "CommonMessage.common_form_submit",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_material_date",
                "name" => "filter_material_date",
                "title" => "Material.material_date",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_created_at",
                "name" => "filter_created_at",
                "title" => "CommonMessage.common_created_at",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_updated_at",
                "name" => "filter_updated_at",
                "title" => "CommonMessage.common_updated_at",
            ),
        );

        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
        return $this->dt_ci_template->load("Admin","Material/MaterialView",$data);
    }

    public function getMaterialListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $commonAreaId = $this->request->getVar("filter_common_area_id");
        $createdAt = $this->request->getVar("filter_created_at");
        $updatedAt = $this->request->getVar("filter_updated_at");
        $formSubmit = $this->request->getVar("filter_form_submit");
        $materialType = $this->request->getVar("filter_material_type");
        $materialDate = $this->request->getVar("filter_material_date");

        $this->datatables->table("tbl_material as tm");
        $this->datatables->select("concat(tm.prefix,tm.series) as document_number");
        $this->datatables->select("tm.material_id,tm.material_date,tm.material_type,tm.form_submit,ts.society_name,tm.material_for");

        $this->datatables->select("COALESCE(tca.common_area_name,'') as common_area_name");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tm.updated_at");

        $this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = tm.society_id","left");
        $this->datatables->join("tbl_common_area as tca","tca.common_area_id = tm.common_area_id","left");
        $this->datatables->join("society_user_master_view as tupdate","tupdate.user_society_id = tm.updated_by","left");

        if(isset($formSubmit)) {
            if(is_array($formSubmit)){
                $this->datatables->whereIn("tm.form_submit",$formSubmit);
            } else {
                $this->datatables->where("tm.form_submit",$formSubmit);
            }
        }

        if($materialDate != ''){
			list($fromDate,$toDate) = explode(" - ",$materialDate);
			$fromDate = DMYToYMD($fromDate);
			$toDate = DMYToYMD($toDate);
			if(strtotime($fromDate) != strtotime($toDate)){
				$this->datatables->where("date_format(tm.material_date,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
				$this->datatables->where("date_format(tm.material_date,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
			} else {
				$this->datatables->where("date_format(tm.material_date,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
			}
		}

        if(isset($materialType)) {
            if(is_array($materialType)){
                $this->datatables->whereIn("tm.material_type",$materialType);
            } else {
                $this->datatables->where("tm.material_type",$materialType);
            }
        }

        if(isset($commonAreaId)) {
            if(is_array($commonAreaId)){
                $this->datatables->whereIn("tm.common_area_id",$commonAreaId);
            } else {
                $this->datatables->where("tm.common_area_id",$commonAreaId);
            }
        }

        if($createdAt != ''){
            list($fromDate,$toDate) = explode(" - ",$createdAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tm.created_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tm.created_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tm.created_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }
        if($updatedAt != ''){
            list($fromDate,$toDate) = explode(" - ",$updatedAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tm.updated_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tm.updated_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tm.updated_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }
        accessFilter($this->datatables, array("society" => "tm.society_id"));
        $this->datatables->groupBy("tm.material_id");
        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){


                $approvedButtonFilter = array(
                    "button_id" => isset($displayData['material_id']) ? $displayData['material_id'] : "",
                    "form_submit" => isset($displayData['form_submit']) ? $displayData['form_submit'] : "",
                    "permission_label" => 'Material',
                    "permission_name" => $this->dt_ci_acl->checkAccess("Material|submitForm"),
                    "approved_module" => "material",
                );
                $data[$key]['approved_button'] = approvedButton($approvedButtonFilter);

                $actionButtonFilter = array(
                    "material_id" => isset($displayData['material_id']) ? $displayData['material_id'] : "",
                    "form_submit" => isset($displayData['form_submit']) ? $displayData['form_submit'] : "",
                );

                $data[$key]['action_button'] = materialActionButton($actionButtonFilter);
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
                $data[$key]['material_date'] = isValidDate($displayData['material_date']) ? YMDToDMY($displayData['material_date']) : "";
                $data[$key]['material_type'] = isset($displayData['material_type']) ? underscoreToUcWord($displayData['material_type']) : "";
                $data[$key]['material_for'] = isset($displayData['material_for']) ? underscoreToUcWord($displayData['material_for']) : "";

            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }

    public function manage($materialId = '',$view = '')
    {
        $request    = \Config\Services::request();
        $data['extra_js'] = array(
            "js/jquery.form.min.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/flatpickr/flatpickr.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
        );
        if ($materialId != '') {
            $filterData = array(
                "material_id" => $materialId
            );
            $data['material_data'] = $this->material_model->getMaterialData($filterData);
            if (empty($data['material_data'])) {
                return redirect()->to('Admin/Material');
            }

            $materialItemData = $this->material_model->getMaterialItemData(array(
                "material_id" => $materialId,
                'is_multiple' => 1
            ));
            $data['material_item_data'] = $materialItemData;

            $data['material_reference_data'] = $this->material_model->getMaterialReferenceData(array(
                "material_id" => $materialId,
                "is_multiple" => 1
            ));
        }

        if ($materialId != '') {
            $data['title'] = 'Edit Material';
        } else {
            $data['title'] = 'Add Material';
        }

        $data['material_data']['view'] = (isset($view) && $view != '' ? 1 : 0);

        //printArray(  $data['material_data'],1);

        $data['material_item_table'] = view('Admin/Material/MaterialItemView', isset($data) ? $data : array());

        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Condition) ? $select2Condition : array());
        if ((isset($data['material_data']['society_id']) && $data['material_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/Material');
        }

        if (((isset($data['material_data']['form_submit']) && $data['material_data']['form_submit'] == 'approved')  && $data['material_data']['view'] != 1)) {
            return redirect()->to('Admin/Material');
        }
        $this->dt_ci_template->load("Admin","Material/MaterialManageView",$data);
    }

    public function save()
    {
        $this->db->transStart();
        $validation = \Config\Services::validation();
        $materialId = $this->request->getVar('material_id');
        $prefix = $this->request->getVar('prefix');
        $series = $this->request->getVar('series');
        $materialDate = $this->request->getVar('material_date');
        $commonAreaId = $this->request->getVar('common_area_id');
        $materialType = $this->request->getVar('material_type');
        $materialFor = $this->request->getVar('material_for');
        $financialYearId = $this->request->getVar('financial_year_id');
        $materialReturnIdArray = $this->request->getVar('material_return_id');

       $validation->setRule('prefix', lang('Material.prefix'), 'required');
       $validation->setRule('series', lang('Material.series'), 'required');

       $validation->setRule('material_date', lang('Material.material_date'), 'required');
       $validation->setRule('common_area_id', lang('Material.common_area'), 'required');
       $validation->setRule('material_type', lang('Material.material_type'), 'required');
       $validation->setRule('financial_year_id', lang('Material.financial_year'), 'required');

       $validation->setRule('item_id.*', lang('Material.item'), 'required');
       $validation->setRule('quantity.*', lang('Material.quantity'), 'required');

       if($materialType == 'inwards' && $materialFor == 'return'){
           $validation->setRule('material_return_id.*', lang('Material.material_return'), 'required');
       }

        if($materialType == 'inwards'){
            $validation->setRule('material_for', lang('Material.material_for'), 'required');
        }


        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {
            $oldMaterialItemData = array();
            if(!empty($materialId)) {
                $oldMaterialItemData = $this->material_model->getMaterialItemData(array(
                    'material_id' => $materialId,
                    'is_multiple' => 1
                ));
            }

            //get material item data
            $materialItemIdArray = $this->request->getVar('material_item_id');
            $itemIdArray = $this->request->getVar('item_id');
            $quantityArray = $this->request->getVar('quantity');
            $itemNameArray = $this->request->getVar('item_name');
            $documentTypeArray = $this->request->getVar('document_type');
            $documentTypeIdArray = $this->request->getVar('document_type_id');
            $documentTypeItemIdArray = $this->request->getVar('document_type_item_id');

            if ($materialType == 'outwards') {
                $itemIdStockArray = array();
                $itemBalanceDataArray = array();
                $excessItemBalanceArr = array();
                $newCombinedItemWiseArray = array();
                $combinedItemDataWise = array();
                if (!empty($materialItemIdArray)) {
                    foreach ($materialItemIdArray as $fkey => $materialItemId) {
                        $quantity = array_key_exists($fkey, $quantityArray) ? $quantityArray[$fkey] : 0;
                        $itemId = array_key_exists($fkey, $itemIdArray) ? $itemIdArray[$fkey] : 0;
                        $itemName = array_key_exists($fkey, $itemNameArray) ? $itemNameArray[$fkey] : 0;
                        $newCombinedItemArray[] = array(
                            'item_id' => $itemId,
                            'item_name' => $itemName,
                            'quantity' => $quantity,
                        );
                    }

                    if (!empty($newCombinedItemArray)) {
                        foreach ($newCombinedItemArray as $newCombinedItemArrayElement) {
                            if (($key = array_search($newCombinedItemArrayElement['item_id'], array_column($combinedItemDataWise, 'item_id'))) !== false) {
                                $combinedItemDataWise[$key]['quantity'] += $newCombinedItemArrayElement['quantity'];
                            } else {
                                $combinedItemDataWise[] = $newCombinedItemArrayElement;
                            }
                        }
                    }

                    foreach ($materialItemIdArray as $fkey => $materialItemId) {
                        $itemId = array_key_exists($fkey, $itemIdArray) ? $itemIdArray[$fkey] : 0;
                        array_push($itemIdStockArray, $itemId);
                    }

                    if (!empty($itemIdStockArray)) {
                        $getItemData = $this->item_balance_model->getItemBalanceData(array(
                            'item_id' => $itemIdStockArray,
                            'common_area_id' => $commonAreaId,
                            'is_multiple' => 1
                        ));

                        if (!empty($getItemData)) {
                            foreach ($getItemData as $displayData) {
                                $itemBalanceDataArray[$displayData['item_id']] = $displayData;
                            }
                        }

                        foreach ($combinedItemDataWise as $combinedItemElement) {
                            $quantity = isset($combinedItemElement['quantity']) ? $combinedItemElement['quantity'] : 0;
                            $itemId = isset($combinedItemElement['item_id']) ? $combinedItemElement['item_id'] : 0;
                            $itemName = isset($combinedItemElement['item_name']) ? $combinedItemElement['item_name'] : 0;
                            $pendingQty = array_key_exists($itemId, $itemBalanceDataArray) ? $itemBalanceDataArray[$itemId]['actual_quantity'] : 0;
                            if ($quantity > $pendingQty) {
                                $excessItemBalanceArr[] = lang('CommonMessage.common_item_information_line_item') . $itemName . " Item : " . roundNumber($pendingQty) . " Quantity Available";
                            }
                        }
                    }
                }


                if (!empty($excessItemBalanceArr)) {
                    $response['success'] = false;
                    $response['msg'] = implode("\n", $excessItemBalanceArr);
                    echo json_encode($response);
                    exit();
                }
            }



            if ($materialType == 'inwards' && $materialFor == 'return') {
                $excessItemArr = [];

                $materialReturnItemData = $this->material_model->getMaterialItemPullMRData(array(
                    'material_return_id' => $materialReturnIdArray,
                    'material_id' => $materialId,
                    'is_multiple' => 1
                ));

                $materialReturnDataArray = array();
                if (!empty($materialReturnItemData)) {
                    foreach ($materialReturnItemData as $displayData) {
                        $materialReturnDataArray[$displayData['material_item_id']] = $displayData;
                    }
                }

                if (!empty($materialItemIdArray)) {
                    foreach ($materialItemIdArray as $fkey => $materialItemId) {
                        $quantity = array_key_exists($fkey, $quantityArray) ? $quantityArray[$fkey] : 0;
                        $itemId = array_key_exists($fkey, $itemIdArray) ? $itemIdArray[$fkey] : 0;
                        $itemName = array_key_exists($fkey, $itemNameArray) ? $itemNameArray[$fkey] : 0;
                        $documentTypeItemId = array_key_exists($fkey, $documentTypeItemIdArray) ? $documentTypeItemIdArray[$fkey] : 0;
                        $pendingQty = (!empty($materialReturnDataArray) && array_key_exists($documentTypeItemId,$materialReturnDataArray)) ? $materialReturnDataArray[$documentTypeItemId]['quantity'] : 0 ;

                        if ($quantity > $pendingQty) {
                            $excessItemArr[] = lang('CommonMessage.common_item_information_line_item') . " ". $fkey . " ".$itemName ." Item : Total " . $pendingQty . " QTY pending";
                        }
                    }
                }

                if (!empty($excessItemArr)) {
                    $response['success'] = false;
                    $response['msg'] = implode("\n", $excessItemArr);
                    echo json_encode($response);
                    exit();
                }
            }



            $materialUpdateArray = array();
            $documentPrefix = MATERIAL_PREFIX;
            $prefix = $documentPrefix;
            $nextSeries = 'getNextSeries("material", "' . $prefix . '","'.$this->session->get('society_id').'")';
            $materialArray = array(
                'material_id' => $materialId,
                'society_id' => $this->session->get('society_id'),
                'material_date' => DMYToYMD($materialDate),
                'financial_year_id' => $financialYearId,
                'common_area_id' => $commonAreaId,
                'material_type' => $materialType,
                'material_for' => $materialFor,
            );

            if (isset($materialId) && $materialId == '') {
                $materialArray['prefix'] = $prefix;
                $materialArray['series'] = $nextSeries;
            }
            if(!empty($materialId)){
                $materialUpdateData = $this->material_model->getMaterialData(array(
                    "material_id" => $materialId
                ));
                $materialUpdateArray = compareArray($materialArray,$materialUpdateData);
            }
            $materialData = $this->material_model->insertUpdateRecord($materialArray, 'material_id', 'tbl_material', 1,'',array("series"),array(),$materialUpdateArray);
            $lastMaterialId = $materialData['lastInsertedId'];

            if(!empty($materialReturnIdArray)){
                if(!empty($materialId)){
                    $this->material_model->deleteMaterialReturnReference($materialId);
                }
                $materialReturnArray = array();
                foreach ($materialReturnIdArray as $materialReturnId){
                    $materialReturnArray[] = array(
                        'material_id' => $lastMaterialId,
                        'reference_type_id' => $materialReturnId,
                        'reference_type' => 'material_return',
                        'created_by' => $this->data['userId'],
                        'updated_by' => $this->data['userId'],
                        'created_at' => date("Y-m-d H:i:s"),
                        'updated_at' => date("Y-m-d H:i:s"),
                    );
                }
                if(!empty($materialReturnArray)){
                    $this->material_model->batchInsert($materialReturnArray, 'tbl_material_reference');
                }
            }


            if (!empty($materialItemIdArray)) {
                if(!empty($materialId)){
                    $this->material_model->deleteMaterialItem($materialId);
                    $deleteDataArray['module'] = 'Material Item';
                    $deleteDataArray['activity'] = "Material Item Deleted";
                    $deleteDataArray['module_id'] = $materialId;
                    logActivity('Edit Record To Material Item Deleted [MaterialID: ' . $materialId . ']',$this->data['userId'],'Material Item',$materialId,json_encode($deleteDataArray),'','Material',$materialId);
                }
                foreach ($materialItemIdArray as $fkey => $materialItemId) {
                    $itemId = array_key_exists($fkey, $itemIdArray) ? $itemIdArray[$fkey] : '';
                    $itemName = array_key_exists($fkey, $itemNameArray) ? $itemNameArray[$fkey] : '';
                    $quantity = array_key_exists($fkey, $quantityArray) ? $quantityArray[$fkey] : '';
                    $documentType = array_key_exists($fkey, $documentTypeArray) ? $documentTypeArray[$fkey] : 0;
                    $documentTypeId = array_key_exists($fkey, $documentTypeIdArray) ? $documentTypeIdArray[$fkey] : 0;
                    $documentTypeItemId = array_key_exists($fkey, $documentTypeItemIdArray) ? $documentTypeItemIdArray[$fkey] : 0;


                    //if ($materialItemId == '' && array_key_exists($fkey, $itemIdArray)) {
                        $itemInsertArray[$fkey] = array(
                            'material_item_id' => '',
                            'material_id' => $lastMaterialId,
                            'document_type' => (isset($documentType) && $documentType != '')  ? $documentType : 'direct' ,
                            'document_type_id' => $documentTypeId,
                            'document_type_item_id' => $documentTypeItemId,
                            'item_id' => $itemId,
                            'quantity' => $quantity,
                            'item_name' => $itemName,
                            'created_by' => $this->data['userId'],
                            'updated_by' => $this->data['userId'],
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                  //  } else {
//                        $itemUpdateArray[$fkey] = array(
//                            'material_item_id' => $materialItemId,
//                            'material_id' => $lastMaterialId,
//                            'document_type' => (isset($documentType) && $documentType != '')  ? $documentType : 'direct' ,
//                            'document_type_id' => $documentTypeId,
//                            'document_type_item_id' => $documentTypeItemId,
//                            'item_id' => $itemId,
//                            'quantity' => $quantity,
//                            'item_name' => $itemName,
//                            'updated_by' => $this->data['userId'],
//                            'updated_at' => date("Y-m-d h:i:s"),
//                        );
                  //  }
                }
                $itemExtraDataArray = array();
                $itemExtraDataArray['module_id'] = $lastMaterialId;
                $itemExtraDataArray['module'] = 'Material Item';
                $itemExtraDataArray['type'] = 'Material';
                $itemExtraDataArray['old_data'] = $oldMaterialItemData;
                $itemExtraDataArray['user_id'] = $this->data['userId'];
                $itemExtraDataArray['society_id'] = $this->session->get('society_id');

                if (!empty($itemInsertArray)) {
                    $this->material_model->batchInsert($itemInsertArray, 'tbl_material_item',$itemExtraDataArray);
                }
//                if (!empty($itemUpdateArray)) {
//                    $this->material_model->batchUpdate($itemUpdateArray, "material_item_id", 'tbl_material_item',$itemExtraDataArray);
//                }
            }
            $transactionStatus = $this->db->transComplete();
            if (isset($materialId) && $materialId != '') {
                if (($materialData['success']) && ($transactionStatus == 1)) {
                    $this->db->transCommit();
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('Material.material'));
                } else {
                    $this->db->transRollback();
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('Material.material'));
                }
            } else {
                if (($materialData['success']) && ($transactionStatus == 1)) {
                    $this->db->transCommit();
                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('Material.material'));
                } else {
                    $this->db->transRollback();
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('Material.material'));
                }
            }
            echo json_encode($response);
            exit();
        }

    }

    public function delete()
    {
        $this->db->transStart();
        $materialId  = $this->request->getVar('material_id');
        $materialDataArray = $this->material_model->getMaterialData(array(
            'material_id' => $materialId,
            'is_multile' => 1
        ));
        $materialApprovedError = array();
        if(!empty($materialDataArray)){
            if($materialDataArray['form_submit'] == 'approved') {
                $materialApprovedError[] =  $materialDataArray['document_number'] ;
            }
            
        }
        if(!empty($materialApprovedError)){
            $materialNumber = implode(',', $materialApprovedError);
            $response['success'] = false;
            $response['msg'] = "You Can't Deleted This Material ". $materialNumber ." Because Already Approved";
            echo json_encode($response);
            exit;
        };

        $this->material_model->deleteMaterialReturnReference($materialId);
        $materialData = $this->material_model->deleteRecord($materialId);
        $transactionStatus = $this->db->transComplete();
        if (($materialData) && ($transactionStatus == 1)) {
            $this->db->transCommit();
            $response['success'] = true;
            $response['msg'] = sprintf(lang('CommonMessage.delete_record'), lang("Material.material"));
        } else {
            $this->db->transRollback();
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'), lang("Material.material"));
        }
        echo json_encode($response);
        exit;
    }

    public function addMaterialItemRow()
    {
        $data['row_number'] = $this->request->getVar("row_number");
        $memberRow = view('Admin/Material/MaterialItemRowView', $data);
        echo $memberRow;
    }

    public function deleteMaterialItemRow()
    {
        $this->db->transStart();
        $materialItemId  = $this->request->getVar('material_item_id');
        $materialId = $this->request->getVar('material_id');

        $materialItemData = $this->material_model->deleteMaterialItemRecord($materialItemId);

        if ($materialItemData) {
            if(!empty($materialItemId)){
                foreach($materialItemId as $documentElement){
                    $deleteDataArray['module'] = 'Material Item';
                    $deleteDataArray['activity'] = "Material Item Deleted";
                    $deleteDataArray['module_id'] = $documentElement;
                    logActivity('Material Item Deleted [MaterialItemID: ' . $documentElement . ']',$this->data['userId'],'Material Item',$documentElement,json_encode($deleteDataArray),'','Material',$materialId);
                }
            }

            $transactionStatus = $this->db->transComplete();
            if($transactionStatus == 1){
                $response['success'] = true;
                $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Material.material_item'));
            }
            else{
                $response['success'] = false;
                $response['msg']     = sprintf(lang('CommonMessage.delete_error'),lang('Material.material_item'));
            }
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('Material.material_item'));
        }
        echo json_encode($response);
        exit();
    }


    public function view($id = null)
    {
        $materialId = $this->request->getVar("view_id");
        if($materialId == "" && $materialId == null){
            return redirect()->to('Admin/Material');
        }
        else {
            $id = $materialId;
            $filterData = array(
                "material_id" => $materialId
            );
            $data['material_data'] = $this->material_model->getMaterialData($filterData);
            if (empty($data['material_data'])) {
                return redirect()->to('Admin/Material');
            }
            $data['material_reference_data'] = $this->material_model->getMaterialReferenceData(array(
                "material_id" => $materialId,
                "is_multiple" => 1
            ));
            $materialItemData = $this->material_model->getMaterialItemData(array(
                "material_id" => $materialId,
                'is_multiple' => 1
            ));
            $data['material_item_data'] = $materialItemData;
            // printArray($materialItemData,1);
            $materialView = view("Admin/Material/MaterialModelView", $data);
            $response['view_title'] = "Material Details";
            $response['view_detail'] = $materialView;
            $response['success'] = true;
            echo json_encode($response);
        }
    }



    public function excelExportMaterial()
    {
        $fileName ='material-' . DATETIMEFORMAT;
        $sheetName = 'Material-' . DATEFORMAT;
        $excelHeaderName = 'Material';
        $tableData = $this->getMaterialListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            lang('Material.material_number'),
            lang('Material.material_date'),
            lang('Material.common_area'),
            lang('Material.form_submit'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                $row["document_number"],
                $row["material_date"],
                $row["common_area_name"],
                underscoreToUcWord($row["form_submit"]),
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'F';

        // printArray($dataRows,1);
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }

    public function pdf($id = null, $view = null, $save_bufffer = null,$zipPdf = 0)
    {
        if(empty($id)){
            $response['success'] = false;
            $response['msg'] = lang('Material.materials_data_required');
            echo json_encode($response);
            exit;
        }
        $filterData = array(
            "material_id" => $id,
            'is_multiple' => 1
        );
        $materialData = $this->material_model->getMaterialData($filterData);
        // printArray($materialData,1);
        if(!empty($materialData)) {
            foreach ($materialData as $mkey => $material) {

                $societyData = $this->society_model->getSocietyData(array(
                    "society_id" => isset($societyData['society_id']) ? $societyData['society_id'] : "-1",
                ));
                // $materialReturnItemData = array();
                $materialItemData = $this->material_model->getMaterialItemData(array(
                    "material_id" => $material["material_id"],
                    'is_multiple' => 1
                ));

                $materialReferenceData = $this->material_model->getMaterialReferenceData(array(
                    "material_id" => $material["material_id"],
                    'is_multiple' => 1
                ));
                $data['material_reference_data'] = $materialReferenceData;
                $data['material_item_data'] = $materialItemData;
                $data['society_data'] = $societyData;
                $data['material_data'] = $material;
                $data['name'] = lang("Material.material_pdf") . "_" . str_replace('/', '_', $data['material_data']['document_number']) . ".pdf";
                $printHeader = '';
                $printFooter = '';
                // $signatureDetails = array(
                //     "created_by" => isset($material['created_by']) ? $material['created_by'] : "",
                //     "approved_by" =>  "",
                //     "document_number" => isset($material['document_number'])  ? lang("material")."# ".$material['document_number']  : "",
                //     "document_date" => isset($material['created_at']) ? siteDateFormat($material['created_at']) : "",
                //     "print_for" => "Material",
                // );
                // if (isset($material['material_id'])) {
                //     $printFooter = pdfFooter( 1, $signatureDetails);
                // }
                $html = view('Admin/Material/pdf/MaterialPdfView', $data);
                // printArray($material,1);
                // echo($html);
                // die();
                generate_pdf($html, $data['name'], false, $printFooter, '', $printHeader, '', 'P');
            }
        }
    }


    public function submitForm()
    {

        $materialId = $this->request->getVar('material_id');
        $formStatus = $this->request->getVar('form_status');
         $checkStatus = checkFormStatus('tbl_material', 'material_id', $materialId, 'approved');
        if ($checkStatus) {
        $this->db->transBegin();

        if ($formStatus == 'approved') {
            $materialDataArray = $this->material_model->getMaterialData(array(
                'material_id' => $materialId,
                'is_multiple' => 1
            ));

            $materialArray = array();
            foreach ($materialDataArray as $materialData) {
                if (isset($materialData['form_submit']) && ($materialData['form_submit'] == $formStatus)) {
                    $response['success'] = false;
                    $response['msg'] = sprintf(lang('CommonMessage.status_change_error'), lang('Material.material'));
                    echo json_encode($response);
                    exit;
                }

                $materialItemData = $this->material_model->getMaterialItemData(array(
                    'material_id' => $materialData['material_id'],
                    'is_multiple' => 1
                ));

                if (is_array($materialItemData) && empty($materialItemData)) {
                    $this->db->transRollback();
                    $response['success'] = false;
                    $response['msg'] = sprintf(lang('CommonMessage.common_data_not_available_error'), lang('Material.material_item'));
                    echo json_encode($response);
                    exit;
                }

                $excessItemArr = [];
                $newCombinedItemWiseArray = array();
                $combinedItemDataWise = array();
                if($materialData['material_type'] == 'outwards'){
                    $itemIdStockArray = array();
                    if (!empty($materialItemData)) {

                        foreach ($materialItemData as $materialItemElement) {
                            $quantity = isset($materialItemElement['quantity']) ? $materialItemElement['quantity'] : 0;
                            $itemId = isset($materialItemElement['item_id']) ? $materialItemElement['item_id'] : 0;
                            $itemName = isset($materialItemElement['item_name']) ? $materialItemElement['item_name'] : '';
                            $newCombinedItemArray[] = array(
                                'item_id' => $itemId,
                                'item_name' => $itemName,
                                'quantity' => $quantity,
                            );
                        }

                        if (!empty($newCombinedItemArray)) {
                            foreach ($newCombinedItemArray as $newCombinedItemArrayElement) {
                                if (($key = array_search($newCombinedItemArrayElement['item_id'], array_column($combinedItemDataWise, 'item_id'))) !== false) {
                                    $combinedItemDataWise[$key]['quantity'] += $newCombinedItemArrayElement['quantity'];
                                } else {
                                    $combinedItemDataWise[] = $newCombinedItemArrayElement;
                                }
                            }
                        }
                        
                        foreach ($materialItemData as $materialItemElement) {
                            array_push($itemIdStockArray,$materialItemElement['item_id']);
                        }
                    }
                    $itemBalanceDataArray = array();

                    if(!empty($itemIdStockArray)) {
                        $getItemData = $this->item_balance_model->getItemBalanceData(array(
                            'item_id' => $itemIdStockArray,
                            'common_area_id' => $materialData["common_area_id"],
                            'is_multiple'=> 1
                        ));

                        if (!empty($getItemData)) {
                            foreach ($getItemData as $displayData) {
                                $itemBalanceDataArray[$displayData['item_id']] = $displayData;
                            }
                        }

                        foreach ($combinedItemDataWise as $combinedItemElement) {
                            $pendingQty = array_key_exists($combinedItemElement['item_id'],$itemBalanceDataArray) ? $itemBalanceDataArray[$combinedItemElement['item_id']]['actual_quantity'] : 0;
                            if($combinedItemElement['quantity'] > $pendingQty){
                                $excessItemArr[] = lang('CommonMessage.common_item_information_line_item') .$combinedItemElement['item_name']." Item : ".roundNumber($pendingQty,0)." Quantity Available";
                            }
                        }
                    }

                    if(!empty($excessItemArr)) {
                        $response['success'] = false;
                        $response['msg'] = implode("\n", $excessItemArr);
                        echo json_encode($response);
                        exit();
                    }
                }

                foreach ($materialItemData as $key => $itemValue) {
                    // get item balance Data
                    $getItemData = $this->item_balance_model->getItemBalanceData(array(
                        'item_id' => $itemValue['item_id'],
                        'common_area_id' => $materialData['common_area_id'],
                    ));

                    if($materialData['material_type'] == 'inwards'){
                        if (!empty($getItemData)) {
                            $cumulativeQuantityBefore = floatval($getItemData['actual_quantity']);
                            $cumulativeQuantityAfter = floatval($cumulativeQuantityBefore) + floatval($itemValue['quantity']);
                        } else {
                            $cumulativeQuantityBefore = 0;
                            $cumulativeQuantityAfter = floatval($cumulativeQuantityBefore) + floatval($itemValue['quantity']);
                        }
                    }
                    else {
                        if (!empty($getItemData)) {
                            $cumulativeQuantityBefore = floatval($getItemData['actual_quantity']);
                            $cumulativeQuantityAfter = floatval($cumulativeQuantityBefore) - floatval($itemValue['quantity']);
                        } else {
                            $cumulativeQuantityBefore = 0;
                            $cumulativeQuantityAfter = floatval($cumulativeQuantityBefore) - floatval($itemValue['quantity']);
                        }
                    }


                    $itemDataArray = array(
                        'item_id' => $itemValue['item_id'],
                        'society_id' => $this->session->get('society_id'),
                        'financial_year_id' => $materialData['financial_year_id'],
                        'common_area_id' => $materialData['common_area_id'],
                        'document_number' => $materialData['document_number'],
                        'transaction_for_id' => $itemValue['material_id'],
                        'transaction_for_item_id' => $itemValue['material_item_id'],
                        'actual_qty' => $itemValue['quantity'],
                        'cumulative_quantity_before' => $cumulativeQuantityBefore,
                        'cumulative_quantity_after' => $cumulativeQuantityAfter,
                    );
                    $itemDataArray['transaction_for'] = 'material';
                    if($materialData['material_type'] == 'inwards') {
                        $itemDataArray['transaction_type'] = 'material_inwards';
                    } else {
                        $itemDataArray['transaction_type'] = 'material_outwards';
                    }
                    $productResponse = itemInOut($itemDataArray);
                }


                $materialArray[] = array(
                    'material_id' => $materialData['material_id'],
                    'form_submit' => $formStatus,
                    'approved_by' => $this->data['userId'],
                    'approved_at' => DATE_TIME_DATABASE,
                    'updated_by' => $this->data['userId'],
                    'updated_at' => DATE_TIME_DATABASE
                );
            }
        }

        $materialResponse = $this->material_model->batchUpdate($materialArray, 'material_id', 'tbl_material');

        if (isset($materialResponse['success']) && $materialResponse['success']) {
            $this->db->transCommit();
            $response['title'] = lang('CommonMessage.common_success');
            $response['msg'] = lang('CommonMessage.common_approved_success');
            $response['success'] = true;
        } else {
            $this->db->transRollback();
            $response['title'] = lang('common_error');
            $response['success'] = false;
            $response['msg'] = lang('common_approved_error');
        }
        } else {
            $response['title'] = lang('CommonMessage.common_error');
            $response['success'] = false;
            $response['msg'] = lang('common_approved_already_error');
        }
        echo json_encode($response);
    }

    public function getMaterialReturnDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page            = $this->request->getVar('page');
        $materialId = $this->request->getVar('material_id');
        $commonAreaId = $this->request->getVar('common_area_id');

        $filterData = array(
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT,
            'is_active' => 1,
            'material_id' => $materialId,
            'material_type'=>'outwards',
            'common_area_id' => $commonAreaId
        );
        echo $this->material_model->getMaterialReturn($filterData);
    }

    public function getItemTableRow()
    {
        $validation = \Config\Services::validation();

        $data['row_number'] = $this->request->getVar("row_number");
        $materialReturnId = $this->request->getVar('material_return_id');
        $commonAreaId = $this->request->getVar('common_area_id');
        $materialId = $this->request->getVar('material_id');

        $validation->setRule('material_return_id', lang('Material.material_return'), 'required',array("required" => lang('Material.material_return')." Is Required"));

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        }  else {
                $materialReturnItemData = $this->material_model->getMaterialItemPullMRData(array(
                    'material_return_id' => $materialReturnId,
                    'material_id' => $materialId,
                    'common_area_id' => $commonAreaId,
                    'is_multiple' => 1
                ));
                $itemRowHtml = '';
                if (!empty($materialReturnItemData)) {
                    if (isset($materialReturnItemData) && !empty($materialReturnItemData)) {
                        foreach ($materialReturnItemData as $key => $itemData) {
                            $itemData['document_type'] = 'material_return';
                            $itemData['document_type_id'] = isset($itemData['material_id']) ? $itemData['material_id'] : '';
                            $itemData['document_type_item_id'] = isset($itemData['material_item_id']) ? $itemData['material_item_id'] : '';
                            $itemData['document_code_name'] = isset($itemData['material_number']) ? $itemData['material_number'] : '';
                            $itemData['material_item_id'] =  '';
                            $data["row_number"] = $key + 1;
                            $data["material_item_data"] = $itemData;
                            $itemRowHtml .= view('Admin/Material/MaterialItemRowView', isset($data) ? $data : array());
                        }
                    }
                    $response['success'] = true;
                    $response['item_row_data'] = $itemRowHtml;
                    echo json_encode($response);
                    exit;
                } else {
                    $itemRowHtml .= view('Admin/Material/MaterialItemRowView', isset($data) ? $data : array());
                    $response['success'] = false;
                    $response['msg'] = lang('Material.material_return_item_all_quantities_are_pulled');
                    $response['item_row_data'] = $itemRowHtml;
                    echo json_encode($response);
                    exit;
                }
            }
            $itemRow = view('Admin/Material/MaterialItemRowView', isset($data) ? $data : array());
            echo $itemRow;
    }


    public function materialButNotReturnDetailed()
    {
        $data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/moment/moment.js",
            "vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
        $data['title'] = 'Material But Not Return Detailed';
        $dataFilters['filters'] = array(
            array(
                "type" => "multi_select",
                "dynamic" => true,
                "class" => "commonAreaDd",
                "id" => "filter_common_area_id",
                "name" => "filter_common_area_id",
                "title" => "Material.common_area",
            ),
            array(
                "type" => "material_type",
                "id" => "filter_material_type",
                "name" => "filter_material_type",
                "title" => "Material.material_type",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_material_date",
                "name" => "filter_material_date",
                "title" => "Material.material_date",
            ),
            array(
                "type" => "multi_select",
                "dynamic" => true,
                "class" => "itemDd",
                "id" => "filter_item_id",
                "name" => "filter_item_id",
                "title" => "ItemLedger.item",
            ),
        );

        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Ajax)? $select2Ajax : array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
        return $this->dt_ci_template->load("Admin","Material/MaterialButNotReturnDetailedView",$data);
    }


    public function getMaterialButNotReturnDetailedListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $commonAreaId = $this->request->getVar("filter_common_area_id");
        $itemId = $this->request->getVar("filter_item_id");
        $materialType = $this->request->getVar("filter_material_type");
        $materialDate = $this->request->getVar("filter_material_date");

        // $this->datatables->table("tbl_material as tm");
        // $this->datatables->select("concat(tm.prefix,tm.series) as document_number");
        // $this->datatables->select("tm.material_id,tm.material_date,tm.material_type,tm.form_submit,ts.society_name");

        // $this->datatables->select("COALESCE(ts.society_name,'') as society_name,COALESCE(tca.common_area_name,'') as common_area_name");
        // $this->datatables->select("COALESCE(ti.item_name,'') as item_name");
        // $this->datatables->select("(COALESCE(SUM(tmi.quantity),0)) as material_quantity");

        // $this->datatables->select("(COALESCE((v_tmir.material_return_quantity),0)) as material_return_quantity");

        // $this->datatables->select("(COALESCE(SUM(tmi.quantity),0)) - (COALESCE((v_tmir.material_return_quantity),0)) as pending_quantity");

        // $this->datatables->join("tbl_society as ts","ts.society_id = tm.society_id","left");
        // $this->datatables->join("tbl_common_area as tca","tca.common_area_id = tm.common_area_id","left");
        // $this->datatables->join("tbl_material_item as tmi","tmi.material_id = tm.material_id","left");
        // $this->datatables->join("tbl_item as ti","ti.item_id = tmi.item_id","left");

        // $this->datatables->join("(SELECT SUM(tmir.quantity) AS material_return_quantity,tmir.document_type_item_id,tmir.document_type_id,tmir.item_id
        //                            FROM  tbl_material_item as tmir
        //                            WHERE tmir.document_type='material_return'
        //                            GROUP BY tmir.material_item_id,tmir.item_id ) AS v_tmir", 'v_tmir.document_type_item_id = tmi.material_item_id AND v_tmir.item_id = tmi.item_id', "left");


        // $this->datatables->whereIn("tm.material_type",array('outwards'));
        // $this->datatables->groupBy("tmi.material_item_id");
        // $this->datatables->groupBy("tmi.item_id");
        // $this->datatables->having("(COALESCE(SUM(tmi.quantity),0)) - (SELECT COALESCE(SUM(tmir.quantity),0) from tbl_material_item as tmir where tmir.document_type_item_id = tmi.material_item_id  AND tmir.item_id = tmi.item_id AND tmir.document_type='material_return') > 0");

        $this->datatables->table("tbl_material as tm");
        $this->datatables->select("concat(tm.prefix, tm.series) as document_number");
        $this->datatables->select("tm.material_id, tm.material_date, tm.material_type, tm.form_submit, ts.society_name");
        $this->datatables->select("COALESCE(ts.society_name, '') as society_name, COALESCE(tca.common_area_name, '') as common_area_name");
        $this->datatables->select("COALESCE(ti.item_name, '') as item_name");
        $this->datatables->select("COALESCE(SUM(tmi.quantity), 0) as material_quantity");
        $this->datatables->select("COALESCE(v_tmir.material_return_quantity, 0) as material_return_quantity");
        $this->datatables->select("COALESCE(SUM(tmi.quantity), 0) - COALESCE(v_tmir.material_return_quantity, 0) as pending_quantity");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tm.updated_at");

        $this->datatables->join(MASTER_DB.".tbl_society as ts", "ts.society_id = tm.society_id", "left");
        $this->datatables->join("tbl_common_area as tca", "tca.common_area_id = tm.common_area_id", "left");
        $this->datatables->join("tbl_material_item as tmi", "tmi.material_id = tm.material_id", "left");
        $this->datatables->join("tbl_item as ti", "ti.item_id = tmi.item_id", "left");
        $this->datatables->join("society_user_master_view as tupdate","tupdate.id = tm.updated_by AND tupdate.society_id = tm.society_id","left");

        $this->datatables->join("(SELECT SUM(tmir.quantity) AS material_return_quantity, tmir.document_type_item_id, tmir.item_id
                                FROM tbl_material_item as tmir
                                WHERE tmir.document_type='material_return'
                                GROUP BY tmir.document_type_item_id, tmir.item_id) AS v_tmir", 
                                'v_tmir.document_type_item_id = tmi.material_item_id AND v_tmir.item_id = tmi.item_id', "left");

        $this->datatables->whereIn("tm.material_type", array('outwards'));

        // Group by all necessary columns
        //$this->datatables->groupBy("tm.prefix, tm.series, tm.material_id, tm.material_date, tm.material_type, tm.form_submit, ts.society_name, tca.common_area_name, ti.item_name, v_tmir.material_return_quantity, tmi.material_item_id, tmi.item_id");
        $this->datatables->groupBy("v_tmir.material_return_quantity, tmi.material_item_id, tmi.item_id");

        $this->datatables->having("(COALESCE(SUM(tmi.quantity), 0)) - COALESCE(v_tmir.material_return_quantity, 0) > 0");

        // $this->datatables->orderBy("document_number", "DESC");
        // $this->datatables->limit(10);

        if($materialDate != ''){
            list($fromDate,$toDate) = explode(" - ",$materialDate);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tm.material_date,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tm.material_date,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tm.material_date,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }

        if(isset($materialType)) {
            if(is_array($materialType)){
                $this->datatables->whereIn("tm.material_type",$materialType);
            } else {
                $this->datatables->where("tm.material_type",$materialType);
            }
        }

        if(isset($commonAreaId)) {
            if(is_array($commonAreaId)){
                $this->datatables->whereIn("tm.common_area_id",$commonAreaId);
            } else {
                $this->datatables->where("tm.common_area_id",$commonAreaId);
            }
        }

        if(isset($itemId)) {
            if(is_array($itemId)){
                $this->datatables->whereIn("tmi.item_id",$itemId);
            } else {
                $this->datatables->where("tmi.item_id",$itemId);
            }
        }

        accessFilter($this->datatables, array("society" => "tm.society_id"));
        // $this->datatables->groupBy("tmi.material_item_id");
        // $this->datatables->groupBy("tmi.item_id");


        // $this->datatables->having("(COALESCE(SUM(tmi.quantity),0)) - (SELECT COALESCE(SUM(tmir.quantity),0) from tbl_material_item as tmir where tmir.document_type_item_id = tmi.material_item_id  AND tmir.item_id = tmi.item_id AND tmir.document_type='material_return') > 0");

        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){

                $data[$key]['material_date'] = isValidDate($displayData['material_date']) ? YMDToDMY($displayData['material_date']) : "";
                $data[$key]['material_type'] = isset($displayData['material_type']) ? underscoreToUcWord($displayData['material_type']) : "";
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";

            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }

    public function excelExportMaterialButNotReturn()
    {
        $fileName ='material-return-detailed-' . DATETIMEFORMAT;
        $sheetName = 'Return-' . DATEFORMAT;
        $excelHeaderName = 'Material But Not Return Detailed';
        $tableData = $this->getMaterialButNotReturnDetailedListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            lang('Material.material_number'),
            lang('Material.material_date'),
            lang('Material.material_date'),
            lang('Material.material_type'),
            lang('Material.item'),
            lang('Material.material_quantity'),
            lang('Material.material_return_quantity'),
            lang('Material.pending_quantity'),
        );
        foreach ($tableData as $row) {
            // printArray($row,1);
            $dataRows[] = array(
                $row["document_number"],
                $row["material_date"],
                $row["common_area_name"],
                $row["material_type"],
                $row["item_name"],
                $row["material_quantity"],
                $row["material_return_quantity"],
                $row["pending_quantity"]
            );
        }
        $subTotalCellValueArray = [];
        $ignoreCurrencySymbolSubTotalCellValueArray = [];
        $toColumn = 'H';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => $ignoreCurrencySymbolSubTotalCellValueArray,
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }


}
