<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\ManufacturerModel;
class Manufacturer extends BaseController
{
    protected $manufacturer_model;
    public function __construct() {
        $this->manufacturer_model = new ManufacturerModel();
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );
        $data['title'] = 'Manufacturer';
        $data['manufacturer_modal_view'] = view('Admin/Manufacturer/ManufacturerModalView', $data);
        return $this->dt_ci_template->load("Admin","Manufacturer/ManufacturerView",$data);
    }

    public function getManufacturerListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $this->datatables->table("tbl_manufacturer as tm");
        $this->datatables->select("tm.manufacturer_id, tm.manufacturer_name, tm.is_active");
         $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tm.updated_at");
        $this->datatables->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by,tm.created_at");
        $this->datatables->join("society_user_master_view as tupdate","tupdate.user_society_id = tm.updated_by","left");
        $this->datatables->join("society_user_master_view as tcreate","tcreate.user_society_id = tm.created_by","left");
        $this->datatables->groupBy("tm.manufacturer_id");
        accessFilter($this->datatables, array("society" => "tm.society_id"));

        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "manufacturer_id" => isset($displayData['manufacturer_id']) ? $displayData['manufacturer_id'] : "",
                );
                $data[$key]['action_button'] = manufacturerActionButton($actionButtonFilter);
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
                $data[$key]['created_at'] = isValidDate($displayData['created_at']) ? siteDateFormat($displayData['created_at'],true) : "";
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }
    public function addEdit()
    {
        $this->db->transStart();
        $validation = \Config\Services::validation();

        $manufacturerId = $this->request->getVar('manufacturer_id');
        $manufacturerName = $this->request->getVar('manufacturer_name');
        $isActive = $this->request->getVar('is_active');

        if (isset($manufacturerId) && $manufacturerId == '') {
			$validation->setRule('manufacturer_name', lang('Manufacturer.manufacturer_name'), 'required|combination_unique[tbl_manufacturer.manufacturer_name.'.$this->session->get('society_id').'.]',array('combination_unique' => 'This {field} Already Exists'));
        } else {
			$validation->setRule('manufacturer_name', lang('Manufacturer.manufacturer_name'), 'required|edit_unique[tbl_manufacturer.manufacturer_name.' . $manufacturerId . '.'. $this->session->get('society_id').']',array('edit_unique' => 'This {field} Already Exists'));
        }
        // $validation->setRule('manufacturer_name', lang('Manufacturer.manufacturer_name'), 'required');

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {
            $manufacturerUpdateArray = array();
            $manufacturerArray = array(
                'manufacturer_id' => $manufacturerId,
                'manufacturer_name' => $manufacturerName,
                'society_id' => $this->session->get('society_id'),
                'is_active' => isset($isActive) ? 1 : 0,
            );
            // $manufacturerData = $this->manufacturer_model->insertUpdateRecord($manufacturerArray,'manufacturer_id','tbl_manufacturer', 1,'',array());
            if(!empty($manufacturerId)){
                $manufacturerUpdateData = $this->manufacturer_model->getManufacturerData(array(
                    'manufacturer_id' => $manufacturerId,
                ));
                $manufacturerUpdateArray = compareArray($manufacturerArray,$manufacturerUpdateData);
            }
            $manufacturerData = $this->manufacturer_model->insertUpdateRecord($manufacturerArray,'manufacturer_id','tbl_manufacturer', 1,'',array(),array(),$manufacturerUpdateArray);
            $transactionStatus = $this->db->transComplete();
            if (isset($manufacturerId) && $manufacturerId != '') {
                if (($manufacturerData['success']) && ($transactionStatus == 1)) {
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('Manufacturer.manufacturer'));
                } else {
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('Manufacturer.manufacturer'));
                }
            } else {
                if (($manufacturerData['success']) && ($transactionStatus == 1)) {
                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('Manufacturer.manufacturer'));
                } else {
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('Manufacturer.manufacturer'));
                }
            }
            echo json_encode($response);
            exit();
        }

    }

    public function changeStatus()
    {
        $manufacturerId = $this->request->getVar('manufacturer_id');
        $status = $this->request->getVar('status');

        //$status         = ($status == 0) ? 1 : 0;
        $return = $this->manufacturer_model->statusChange($manufacturerId,$status,'manufacturer_id','tbl_manufacturer');
        if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('Manufacturer.manufacturer'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('Manufacturer.manufacturer'));
        }
        echo json_encode($response);
        exit();
    }


    public function delete()
    {
        $this->db->transStart();
        $manufacturerId = $this->request->getVar('manufacturer_id');
        if( isReferenceInTable('manufacturer_id', 'tbl_item', $manufacturerId) ||
            isReferenceInTable('manufacturer_id', 'tbl_warranty', $manufacturerId)
        ) {

            if (!empty($manufacturerId)) {
                foreach ($manufacturerId as $manufacturer) {
                    $deleteDataArray['module'] = 'Manufacturer';
                    $deleteDataArray['activity'] = "Tried to delete Manufacturer ";
                    $deleteDataArray['module_id'] = $manufacturer;
                    logActivity('Tried to delete Manufacturer [ManufacturerID: ' . $manufacturer . ']', $this->data['userId'], 'Manufacturer', $manufacturer, json_encode($deleteDataArray), '', 'Manufacturer', $manufacturer);
                }
            }

            $response['success'] = false;
            $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
            echo json_encode($response);
            exit;
        }
        $manufacturerData = $this->manufacturer_model->deleteRecord($manufacturerId);
        $transactionStatus = $this->db->transComplete();
        if (($manufacturerData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Manufacturer.manufacturer'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang('Manufacturer.manufacturer'));
        }
        echo json_encode($response);
        exit;
    }

    public function getManufacturerDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page            = $this->request->getVar('page');
        $manufacturerId = $this->request->getVar('manufacturer_id');
        $societyId = $this->request->getVar('society_id');

        $filterData = array(
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT,
            'is_active' => 1,
            'manufacturer_id' => $manufacturerId,
            'society_id' => $this->session->get('society_id'),
        );
        echo $this->manufacturer_model->getManufacturer($filterData);
    }

    public function excelExportManufacturer()
    {
        $fileName ='manufacturer-' . DATETIMEFORMAT;
        $sheetName = 'Manufacturer-' . DATEFORMAT;
        $excelHeaderName = 'Manufacturer';
        $tableData = $this->getManufacturerListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            lang('Manufacturer.manufacturer_name'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                $row["manufacturer_name"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'C';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }
}
