<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\ManagementCommitteeModel;
use App\Models\FinancialYearModel;
use App\Models\SocietyModel;
class ManagementCommittee extends BaseController
{
    protected $management_committee_model;
    protected $society_model;
    protected $financial_year_model;
    public function __construct() {
        $this->management_committee_model = new ManagementCommitteeModel();
        $this->society_model = new SocietyModel();
        $this->financial_year_model = new FinancialYearModel();
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
			"vendor/libs/moment/moment.js",
			"vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
        $data['title'] = 'Management Committee';
		$dataFilters['filters'] = array(
			array(
				"type" => "multi_select",
				"dynamic" => true,
				"class" => "financialYearDd",
				"id" => "filter_financial_year_id",
				"name" => "filter_financial_year_id",
				"title" => "ManagementCommittee.financial_year",
			),
			array(
				"type" => "multi_select",
				"dynamic" => true,
				"class" => "flatDd",
				"id" => "filter_flat_id",
				"name" => "filter_flat_id",
				"title" => "ManagementCommittee.flat",
			),
			array(
				"type" => "multi_select",
				"dynamic" => true,
				"class" => "ownershipFlatMemberDd",
				"id" => "filter_owner_member_id",
				"name" => "filter_owner_member_id",
				"title" => "ManagementCommittee.member",
			),
			array(
				"type" => "multi_select",
				"dynamic" => true,
				"class" => "managementCommitteeResponsibilitiesDd",
				"id" => "filter_management_committee_responsibilities_id",
				"name" => "filter_management_committee_responsibilities_id",
				"title" => "ManagementCommittee.responsibilities",
			),
			array(
				"type" => "daterange",
				"id" => "filter_created_at",
				"name" => "filter_created_at",
				"title" => "CommonMessage.common_created_at",
			),
			array(
				"type" => "daterange",
				"id" => "filter_updated_at",
				"name" => "filter_updated_at",
				"title" => "CommonMessage.common_updated_at",
			),
		);
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
        
        return $this->dt_ci_template->load("Admin","ManagementCommittee/ManagementCommitteeView",$data);
    }

    public function getManagementCommitteeListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $flatId = $this->request->getVar("filter_flat_id");
		$createdAt = $this->request->getVar("filter_created_at");
		$financialYearId = $this->request->getVar("filter_financial_year_id");
		$updatedAt = $this->request->getVar("filter_updated_at");
		$ownerMemberId = $this->request->getVar("filter_owner_member_id");
		$mcrId = $this->request->getVar("filter_management_committee_responsibilities_id");

        $this->datatables->table("tbl_management_committee as tmc");
        
        $this->datatables->select("tmc.management_committee_id,ts.society_name,ts.society_name,tmc.is_active,concat(tt.tower_name,' - ',tf.flat_no) as tower_flat_name,tfy.financial_year_prefix,tmc.mobile_no,tmc.designation, tm.name as member_name,tmc.flat_id");
		$this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tmc.updated_at");
		$this->datatables->select("GROUP_CONCAT(distinct(tm.management_committee_responsibilities_name) SEPARATOR ', ') as responsibilities");
		$this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = tmc.society_id","left");
		$this->datatables->join("tbl_flat as tf","tf.flat_id = tmc.flat_id","left");
		$this->datatables->join("tbl_tower as tt","tt.tower_id = tf.tower_id","left");
		$this->datatables->join("tbl_ownership_flat_member as tofm","tofm.ownership_flat_member_id = tmc.member_id","left");
		$this->datatables->join("tbl_financial_year as tfy","tfy.financial_year_id = tmc.financial_year_id","left");
		$this->datatables->join("society_user_master_view as tupdate","tupdate.user_society_id = tmc.updated_by","left");
        $this->datatables->join('tbl_management_committee_muliple_responsibilities tmcmr', 'tmcmr.management_committee_id = tmc.management_committee_id', 'left');
		$this->datatables->join("tbl_management_committee_responsibilities as tm","tm.management_committee_responsibilities_id = tmcmr.management_committee_responsibilities_id","left");
		$this->datatables->join(MASTER_DB.".tbl_member as tm", "tm.member_id = tofm.member_id",  "left");


        if(isset($flatId)) {
			if(is_array($flatId)){
				$this->datatables->whereIn("tmc.flat_id",$flatId);
			} else {
				$this->datatables->where("tmc.flat_id",$flatId);
			}
		}

		if(isset($ownerMemberId)) {
			if(is_array($ownerMemberId)){
				$this->datatables->whereIn("tmc.member_id",$ownerMemberId);
			} else {
				$this->datatables->where("tmc.member_id",$ownerMemberId);
			}
		}

		if(isset($mcrId)) {
			if(is_array($mcrId)){
				$this->datatables->whereIn("tmcmr.management_committee_responsibilities_id",$mcrId);
			} else {
				$this->datatables->where("tmcmr.management_committee_responsibilities_id",$mcrId);
			}
		}

		if(isset($financialYearId)) {
			if(is_array($financialYearId)){
				$this->datatables->whereIn("tmc.financial_year_id",$financialYearId);
			} else {
				$this->datatables->where("tmc.financial_year_id",$financialYearId);
			}
		}

		if($createdAt != ''){
			list($fromDate,$toDate) = explode(" - ",$createdAt);
			$fromDate = DMYToYMD($fromDate);
			$toDate = DMYToYMD($toDate);
			if(strtotime($fromDate) != strtotime($toDate)){
				$this->datatables->where("date_format(tmc.created_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
				$this->datatables->where("date_format(tmc.created_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
			} else {
				$this->datatables->where("date_format(tmc.created_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
			}
		}
		if($updatedAt != ''){
			list($fromDate,$toDate) = explode(" - ",$updatedAt);
			$fromDate = DMYToYMD($fromDate);
			$toDate = DMYToYMD($toDate);
			if(strtotime($fromDate) != strtotime($toDate)){
				$this->datatables->where("date_format(tmc.updated_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
				$this->datatables->where("date_format(tmc.updated_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
			} else {
				$this->datatables->where("date_format(tmc.updated_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
			}
		}
		$this->datatables->groupBy("tmc.management_committee_id");

		accessFilter($this->datatables, array("society" => "tmc.society_id"));

		$dataReport =  $this->datatables->generate();
		$dataReport = json_decode($dataReport, true);
		$data       = $dataReport['data'];
		if(count($data) > 0){
			foreach($data as $key => $displayData){
				$actionButtonFilter = array(
					"management_committee_id" => isset($displayData['management_committee_id']) ? $displayData['management_committee_id'] : ""
				);
				$data[$key]['action_button'] = managementCommitteeActionButton($actionButtonFilter);
				$data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
				$data[$key]['excel_flat_no'] = isset($displayData['tower_flat_name']) ?  $displayData['tower_flat_name'] : "";
				$data[$key]['tower_flat_name'] = isset($displayData['tower_flat_name']) ?  flatDocumentToHtml($displayData['tower_flat_name'],$displayData['flat_id']) : "";
			}
		}

		if($return){
			return $data;
		}else{
			$dataReport['data'] = $data;
			echo json_encode($dataReport);
			exit;
		}
    }

    public function manage($managementCommitteeId = '')
	{

		$data['extra_js'] = array(
            "js/jquery.form.min.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/bootstrap-datepicker/bootstrap-datepicker.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
        );

        if ($managementCommitteeId != '') {
			$filterData = array(
				"management_committee_id" => $managementCommitteeId
			);
			$data['management_committee_data'] = $this->management_committee_model->getManagementCommitteeData($filterData);

            //printArray($data['management_committee_data'],1);

			$mananagementCommitteeResponsibilitiesData = $this->management_committee_model->getManagementCommitteeResponsibilitiesData(array(
				'management_committee_id' => $managementCommitteeId,
				'is_multiple' => 1
			));
			$data['management_committee_responsibilites_data'] = $mananagementCommitteeResponsibilitiesData;

			if (empty($data['management_committee_data'])) {
                return redirect()->to('Admin/ManagementCommittee');
            }
		}
		if ($managementCommitteeId != '') {
			$data['title'] = 'Edit Management Committee';
		} else {
			$data['title'] = 'Add Management Committee';
		}
		$data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Condition) ? $select2Condition : array());
		if ((isset($data['management_committee_data']['society_id']) && $data['management_committee_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/ManagementCommittee');
        }
		// $data['select2_ajax'] = $this->load->view("admin/CommonMaster/v_select2", isset($select2Condition) ? $select2Condition : array(), true);
		return $this->dt_ci_template->load("Admin","ManagementCommittee/ManagementCommitteeManageView",$data);
	}

    public function save()
	{
		$this->db->transStart();
        $validation = \Config\Services::validation();
        $managementCommitteeId = $this->request->getVar('management_committee_id');
		$memberId = $this->request->getVar("member_id");
		// $mcrId = $this->request->getVar("management_committee_responsibilities_id");
		$flatId = $this->request->getVar("flat_id");
		$designation = $this->request->getVar("designation");
		$mobileNo = $this->request->getVar("mobile_no");
		$financialYearId = $this->request->getVar("financial_year_id");
		$isActive = $this->request->getVar("is_active");

		$validation->setRule('flat_id', lang('ManagementCommittee.flat'), 'required');
		$validation->setRule('designation', lang('ManagementCommittee.designation'), 'required');
		$validation->setRule('mobile_no', lang('ManagementCommittee.mobile_no'), 'required');
		$validation->setRule('financial_year_id', lang('ManagementCommittee.financial_year_id'), 'required');
		

		if (!$validation->withRequest($this->request)->run()) {
			$errors = $validation->getErrors();
            $response['success'] = false;
			$response['msg'] = implode("\n", $errors);
			echo json_encode($response);
			exit;
		} else {


			$managementCommitteeFlatData = $this->management_committee_model->getManagementCommitteeData(array('flat_id'=> $flatId,'management_committee_id_not' => $managementCommitteeId));

			if(!empty($managementCommitteeFlatData)){
				$response['success'] = false;
				$response['msg'] = 'Flat '.$managementCommitteeFlatData['tower_flat_name'].' Management Committee Member Already Assign';
				echo json_encode($response);
				exit;
			}

			$managementCommitteeUpdateArray = array();
			$managementCommitteeArray = array(
				'management_committee_id' => $managementCommitteeId,
				'member_id' => $memberId,
				// 'management_committee_responsibilities_id' => $mcrId,
				'society_id' => $this->session->get('society_id'),
				'flat_id' => $flatId,
				'designation' => $designation,
				'mobile_no' => $mobileNo,
				'financial_year_id' => $financialYearId,
				'is_active' => isset($isActive) ? 1 : 0,
			);

			if(!empty($managementCommitteeId)){
                $managementCommitteeUpdateData = $this->management_committee_model->getManagementCommitteeData(array(
                    'management_committee_id' => $managementCommitteeId,
                ));
                $managementCommitteeUpdateArray = compareArray($managementCommitteeArray,$managementCommitteeUpdateData);
            }

			// printArray($managementCommitteeArray,1);
			$managementCommitteeData = $this->management_committee_model->insertUpdateRecord($managementCommitteeArray, 'management_committee_id', 'tbl_management_committee', 1,'',array(),array(),$managementCommitteeUpdateArray);
			$lastManagementCommitteeId = $managementCommitteeData['lastInsertedId'];


			$managementCommitteeResponsibitiesData = array();
            if(!empty($managementCommitteeId)) {
                $managementCommitteeResponsibitiesData = $this->management_committee_model->getManagementCommitteeResponsibilitiesData(array(
                    'management_committee_id' => $managementCommitteeId,
                    'is_multiple' => 1
                ));
            }

			$managementCommitteeResponsibitiesIdArray = $this->request->getVar('management_committee_responsibilities_id[]');
            if(isset($managementCommitteeId) && $managementCommitteeId != ''){
                $this->management_committee_model->deleteResponsibilitiesRecord($managementCommitteeId);
            }

			// printArray($managementCommitteeResponsibitiesIdArray,1);

            if(isset($managementCommitteeResponsibitiesIdArray)&& $managementCommitteeResponsibitiesIdArray != ''){
                $managementCommitteeResponsibitiesForArray = array();
                foreach($managementCommitteeResponsibitiesIdArray as $managementCommitteeResponsibitiesId){
                    $managementCommitteeResponsibitiesForArray[] = array(
                        'management_committee_muliple_responsibilities_id' => '',
                        'management_committee_id' => $lastManagementCommitteeId,
                        'management_committee_responsibilities_id' => $managementCommitteeResponsibitiesId,
                        'created_at' => date('Y-m-d H:i:s'),
                        'updated_at' => date('Y-m-d H:i:s'),
                        'created_by' => $this->data['userId'],
                        'updated_by' => $this->data['userId']
                    );
                }
                $ResponsibilitiesSocietyExtraDataArray = array();
                $ResponsibilitiesSocietyExtraDataArray['module_id'] = $lastManagementCommitteeId;
                $ResponsibilitiesSocietyExtraDataArray['module'] = 'Management Committee Responsibilities';
                $ResponsibilitiesSocietyExtraDataArray['type'] = 'Management Committee';
                $ResponsibilitiesSocietyExtraDataArray['old_data'] = $managementCommitteeResponsibitiesData;
                $ResponsibilitiesSocietyExtraDataArray['user_id'] = $this->data['userId'];
                $ResponsibilitiesSocietyExtraDataArray['society_id'] = $this->session->get('society_id');

				// printArray($managementCommitteeResponsibitiesForArray,1);
                if(!empty($managementCommitteeResponsibitiesForArray)){
                    $this->management_committee_model->batchInsert($managementCommitteeResponsibitiesForArray,'tbl_management_committee_muliple_responsibilities',$ResponsibilitiesSocietyExtraDataArray);
                }
            }
            $transactionStatus = $this->db->transComplete();
			if (isset($managementCommitteeId) && $managementCommitteeId != '') {
				if (($managementCommitteeData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.update_record'), lang("ManagementCommittee.management_committee"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.update_record_error'), lang("ManagementCommittee.management_committee"));
				}
			} else {
				if (($managementCommitteeData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.create_record'), lang("ManagementCommittee.management_committee"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.create_record_error'), lang("ManagementCommittee.management_committee"));
				}
			}
			echo json_encode($response);
			exit;
		}
	}
    public function changeStatus()
    {
        $managementCommitteeId = $this->request->getVar('management_committee_id');
        $status = $this->request->getVar('status');

        //$status         = ($status == 0) ? 1 : 0;
        $return = $this->management_committee_model->statusChange($managementCommitteeId,$status,'management_committee_id','tbl_management_committee');
        if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('ManagementCommittee.management_committee'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('ManagementCommittee.management_committee'));
        }
        echo json_encode($response);
        exit();
    }


    public function delete()
    {
    	$this->db->transStart();
        $managementCommitteeId = $this->request->getVar('management_committee_id');
        $ids = is_array($managementCommitteeId) ? implode(',', $managementCommitteeId) : $managementCommitteeId;
        $this->management_committee_model->deleteResponsibilitiesRecord($managementCommitteeId);
        $managementCommitteeData = $this->management_committee_model->deleteRecord($managementCommitteeId);
        $transactionStatus = $this->db->transComplete();
        if (($managementCommitteeData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('ManagementCommittee.management_committee'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang('ManagementCommittee.management_committee'));
        }
        echo json_encode($response);
        exit;
    }

    public function view($id = null)
	{
		$managementCommitteeId = $this->request->getVar("view_id");
		if($managementCommitteeId == "" && $managementCommitteeId == null){
            return redirect()->to('Admin/ManagementCommittee');
		}
		else {
			$id = $managementCommitteeId;
			$filterData = array(
				"management_committee_id" => $managementCommitteeId
			);
			$data['management_committee_data'] = $this->management_committee_model->getManagementCommitteeData($filterData);
			$managementCommitteeView = view("Admin/ManagementCommittee/ManagementCommitteeModelView", $data);
			$response['view_title'] = "Management Committee Details";
			$response['view_detail'] = $managementCommitteeView;
			$response['success'] = true;
			echo json_encode($response);
		}
	}

    public function excelExportManagementCommittee()
	{
		$fileName ='mc-' . DATETIMEFORMAT;
		$sheetName = 'MC-' . DATEFORMAT;
		$excelHeaderName = 'Management Committee';
		$tableData = $this->getManagementCommitteeListing(true, $_GET);
		$dataRows = array();
		$dataRows[] = array(
			// lang('ManagementCommittee.society'),
			lang('ManagementCommittee.financial_year'),
			lang('ManagementCommittee.responsibilities'),
			lang('ManagementCommittee.flat'),
			lang('ManagementCommittee.member'),
			lang('ManagementCommittee.designation'),
			lang('ManagementCommittee.mobile_no'),
			lang('CommonMessage.common_updated_by'),
			lang('CommonMessage.common_updated_at')
		);
		foreach ($tableData as $row) {
			$dataRows[] = array(
				// $row["society_name"],
				$row["financial_year_prefix"],
				$row["responsibilities"],
				$row["excel_flat_no"],
				$row["member_name"],
				$row["designation"],
				$row["mobile_no"],
				$row["updated_by"],
				$row["updated_at"]
			);
		}
		$subTotalCellValueArray = [];
		$toColumn = 'H';
		$excelFilterData = array(
			'file_name' => $fileName,
			'sheet_name' => $sheetName,
			'excel_header_name' => $excelHeaderName,
			'data_row' => $dataRows,
			'sub_total_cell_value_array' => $subTotalCellValueArray,
			'to_column' => $toColumn,
			'skip_header' => false,
			'ignore_currency_symbols_sub_total_cell_value_array' => array(),
			'row_cell_currency_format' => array()
		);
		//excelExport($filename,$sheetName,$excelHeaderName,$dataRows,$subTotalCellValueArray,$toColumn,false,array(),array());
		excelExport($excelFilterData);
	}

    public function managementCommitteePdf()
	{
		if(!$this->dt_ci_acl->checkAccess('ManagementCommittee|pdf')){
			return NO_ACCESS_SECTION;
		} else {
			
			
			$societyData = $this->society_model->getSocietyData(array(
				"society_id" => $this->session->get('society_id'),
			));
			$data['society_data'] = $societyData;

			$getCurrentFinancialYear = currentFinancialYear();
			$financialYearData = array();
			if($getCurrentFinancialYear != ''){
				list($fromDate,$toDate) = explode(" - ",$getCurrentFinancialYear);
				$fromDate = DMYToYMD($fromDate);
				$toDate = DMYToYMD($toDate);

				$financialYearData = $this->financial_year_model->getFinancialYearData(array(
					"start_date" => $fromDate,
					"end_date" => $toDate
				));
			}
			$data['financial_year_data'] = $financialYearData;

			$filterData = array(
				'is_multiple' => 1,
				'financial_year_id' => isset($financialYearData['financial_year_id']) ? $financialYearData['financial_year_id']: '',
			);
			$managementCommitteeData = $this->management_committee_model->getManagementCommitteeData($filterData);
			$data['management_committee_data'] = $managementCommitteeData;
			$data['name'] = lang("ManagementCommittee.management_committee_pdf") . ".pdf";
			$printHeader = '';
			$printFooter = '';

			$printFooter = pdfFooter( 0, array());

			$html = view('Admin/ManagementCommittee/pdf/ManagementCommitteePdfView', $data);
			generate_pdf($html, $data['name'], false, $printFooter, '', $printHeader, '', 'P');
		}
	}


    public function getFlatMemberDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page = $this->request->getVar('page');

        $filterData = array(
            'filter_param' => $filterParameter,
            'page' => $page,
            'is_active'=> 1,
            'start' => 0,
            'limit' => DATA_LIMIT
        );

        echo $this->management_committee_model->getFlatMember($filterData);
    }
}
