<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\MakeModel;
class Make extends BaseController
{
    protected $make_model;
    public function __construct() {
        $this->make_model = new MakeModel();
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );
        $data['title'] = 'Make';
        $data['make_modal_view'] = view('Admin/Make/MakeModalView', $data);
        return $this->dt_ci_template->load("Admin","Make/MakeView",$data);
    }

    public function getMakeListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $this->datatables->table("tbl_make as tm");
        $this->datatables->select("tm.make_id, tm.make_name, tm.is_active");
         $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tm.updated_at");
        $this->datatables->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by,tm.created_at");
        $this->datatables->join("society_user_master_view as tupdate","tupdate.user_society_id = tm.updated_by","left");
        $this->datatables->join("society_user_master_view as tcreate","tcreate.user_society_id = tm.created_by","left");
        $this->datatables->groupBy("tm.make_id");
        accessFilter($this->datatables, array("society" => "tm.society_id"));

        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "make_id" => isset($displayData['make_id']) ? $displayData['make_id'] : "",
                );
                $data[$key]['action_button'] = makeActionButton($actionButtonFilter);
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
                $data[$key]['created_at'] = isValidDate($displayData['created_at']) ? siteDateFormat($displayData['created_at'],true) : "";
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }
    public function addEdit()
    {
        $this->db->transStart();
        $validation = \Config\Services::validation();

        $makeId = $this->request->getVar('make_id');
        $makeName = $this->request->getVar('make_name');
        $isActive = $this->request->getVar('is_active');

        if (isset($makeId) && $makeId == '') {
			$validation->setRule('make_name', lang('Make.make_name'), 'required|combination_unique[tbl_make.make_name.'.$this->session->get('society_id').'.]',array('combination_unique' => 'This {field} Already Exists'));
        } else {
			$validation->setRule('make_name', lang('Make.make_name'), 'required|edit_unique[tbl_make.make_name.' . $makeId . '.'. $this->session->get('society_id').']',array('edit_unique' => 'This {field} Already Exists'));
        }
        // $validation->setRule('make_name', lang('Make.make_name'), 'required');

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {
            $makeUpdateArray = array();
            $makeArray = array(
                'make_id' => $makeId,
                'make_name' => $makeName,
                'society_id' => $this->session->get('society_id'),
                'is_active' => isset($isActive) ? 1 : 0,
            );
            // $makeData = $this->make_model->insertUpdateRecord($makeArray,'make_id','tbl_make', 1,'',array());
            if(!empty($makeId)){
                $makeUpdateData = $this->make_model->getMakeData(array(
                    'make_id' => $makeId,
                ));
                $makeUpdateArray = compareArray($makeArray,$makeUpdateData);
            }
            $makeData = $this->make_model->insertUpdateRecord($makeArray,'make_id','tbl_make', 1,'',array(),array(),$makeUpdateArray);
            $transactionStatus = $this->db->transComplete();
            if (isset($makeId) && $makeId != '') {
                if (($makeData['success']) && ($transactionStatus == 1)) {
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('Make.make'));
                } else {
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('Make.make'));
                }
            } else {
                if (($makeData['success']) && ($transactionStatus == 1)) {
                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('Make.make'));
                } else {
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('Make.make'));
                }
            }
            echo json_encode($response);
            exit();
        }

    }

    public function changeStatus()
    {
        $makeId = $this->request->getVar('make_id');
        $status = $this->request->getVar('status');

        //$status         = ($status == 0) ? 1 : 0;
        $return = $this->make_model->statusChange($makeId,$status,'make_id','tbl_make');
        if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('Make.make'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('Make.make'));
        }
        echo json_encode($response);
        exit();
    }


    public function delete()
    {
        $this->db->transStart();
        $makeId = $this->request->getVar('make_id');
        if( isReferenceInTable('make_id', 'tbl_item', $makeId) ||
            isReferenceInTable('make_id', 'tbl_warranty', $makeId)
        ) {

            if (!empty($makeId)) {
                foreach ($makeId as $make) {
                    $deleteDataArray['module'] = 'Make';
                    $deleteDataArray['activity'] = "Tried to delete Make ";
                    $deleteDataArray['module_id'] = $make;
                    logActivity('Tried to delete Make [MakeID: ' . $make . ']', $this->data['userId'], 'Make', $make, json_encode($deleteDataArray), '', 'Make', $make);
                }
            }

            $response['success'] = false;
            $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
            echo json_encode($response);
            exit;
        }
        $makeData = $this->make_model->deleteRecord($makeId);
        $transactionStatus = $this->db->transComplete();
        if (($makeData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Make.make'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang('Make.make'));
        }
        echo json_encode($response);
        exit;
    }

    public function getMakeDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page            = $this->request->getVar('page');
        $makeId = $this->request->getVar('make_id');
        $societyId = $this->request->getVar('society_id');

        $filterData = array(
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT,
            'is_active' => 1,
            'make_id' => $makeId,
            'society_id' => $this->session->get('society_id'),
        );
        echo $this->make_model->getMake($filterData);
    }

    public function excelExportMake()
    {
        $fileName ='make-' . DATETIMEFORMAT;
        $sheetName = 'Make-' . DATEFORMAT;
        $excelHeaderName = 'Make';
        $tableData = $this->getMakeListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            lang('Make.make_name'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                $row["make_name"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'C';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }
}
