<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\MaintenanceCalculationModel;
use App\Models\CommonWebServiceModel;
use App\Models\OwnershipFlatModel;
use App\Models\RentalsModel;
use App\Models\SocietyModel;
use App\Models\TaxModel;

class MaintenanceCalculation extends BaseController
{
    protected $invoice_model;
    public function __construct() {
        $this->invoice_model = new MaintenanceCalculationModel();
        $this->common_web_service_model = new CommonWebServiceModel();
        $this->ownership_flat_model = new OwnershipFlatModel();
        $this->rentals_model = new RentalsModel();
        $this->society_model = new SocietyModel();
        $this->tax_model = new TaxModel();
    }

    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/moment/moment.js",
            "vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
        $data['title'] = lang('MaintenanceCalculation.maintenance_calculation');
        $dataFilters['filters'] = array(
            array(
                "type" => "daterange",
                "id" => "filter_created_at",
                "name" => "filter_created_at",
                "title" => "CommonMessage.common_created_at",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_updated_at",
                "name" => "filter_updated_at",
                "title" => "CommonMessage.common_updated_at",
            ),
        );
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
        return $this->dt_ci_template->load("Admin","MaintenanceCalculation/MaintenanceCalculationView",$data);
    }

    public function manage($id = '',$view = '')
    {
        $data['extra_js'] = array(
            "js/jquery.form.min.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/bootstrap-datepicker/bootstrap-datepicker.js",
            "vendor/libs/flatpickr/flatpickr.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/jquery-timepicker/jquery-timepicker.js",
            "vendor/libs/moment/moment.js",
            "vendor/libs/ckeditor/ckeditor_classic.js",
        );

        if ($id != '') {
            $filterData = array(
                "id" => $id
            );
            $data['maintenance_calculation_data'] = $this->invoice_model->getMaintenanceCalculationData($filterData);

            if (empty($data['maintenance_calculation_data'])) {
                return redirect()->to('Admin/MaintenanceCalculation');
            }else {
                $data['maintenance_calculation_flat_data'] = $this->invoice_model->getMaintenanceCalculationFlatData(array(
                    'maintenance_id' => $id,
                    'is_multiple' => 1,
                ));
            }
        }

        if ($id != '') {
            $data['title'] = 'Edit Maintenance Calculation';
        } else {
            $data['title'] = 'Add Maintenance Calculation';
        }
        if ((isset($data['maintenance_calculation_data']['society_id']) && $data['maintenance_calculation_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/MaintenanceCalculation');
        }

        // printArray($data,1);

        $data['flat_table'] = view('Admin/MaintenanceCalculation/MaintenanceCalculationFlatView', isset($data) ? $data : array());
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Ajax)? $select2Ajax : array());
        $this->dt_ci_template->load("Admin","MaintenanceCalculation/MaintenanceCalculationManageView",$data);
    }

    public function getMaintenanceCalculationListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }

        $createdAt = $this->request->getVar("filter_created_at");
        $updatedAt = $this->request->getVar("filter_updated_at");

        $societyId = $this->session->get('society_id');

        $this->datatables->table("tbl_maintenance as tm");
        $this->datatables->select("tm.id, tm.calculation_date,tm.unit_of_measurement,tm.is_select_all,tm.society_id");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tm.updated_at");

        $this->datatables->join("society_user_master_view as tupdate","tupdate.user_society_id = tm.updated_by","left");
        $this->datatables->join(MASTER_DB.".tbl_society as tsoc","tsoc.society_id = tm.society_id","left");
        accessFilter($this->datatables, array("society" => "tm.society_id"));

        if(isset($societyId) && !empty($societyId)) {
            if (is_array($societyId)) {
                $this->datatables->whereIn('tm.society_id', $societyId);
            } else {
                $this->datatables->where('tm.society_id', $societyId);
            }
        }

        if($createdAt != ''){
            list($fromDate,$toDate) = explode(" - ",$createdAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tm.created_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tm.created_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tm.created_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }
        if($updatedAt != ''){
            list($fromDate,$toDate) = explode(" - ",$updatedAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tm.updated_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tm.updated_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tm.updated_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }

        $this->datatables->groupBy("tm.id");

        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "maintenance_calculation_id" => isset($displayData['id']) ? $displayData['id'] : "",
                );
                $data[$key]['action_button'] = maintenanceCalculationActionButton($actionButtonFilter);
                $data[$key]['calculation_date'] = siteDateFormat($displayData['calculation_date']);
                $data[$key]['unit_of_measurement'] = underscoreToUcWord($displayData['unit_of_measurement']);
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }

    public function save()
    {
        // printArray($_POST,1);
        $this->db->transStart();
        $validation = \Config\Services::validation();

        $maintenanceCalculationId = $this->request->getVar('maintenance_calculation_id');
        $calculationDate = $this->request->getVar('calculation_date');
        $unitOfMeasurement = $this->request->getVar('unit_of_measurement');
        $isSelectAll = $this->request->getVar('is_select_all');
        
        // particular
        $maintenanceCalculationFlatIdArr = $this->request->getVar('maintenance_flat_id');
        $flatIdArr = $this->request->getVar('flat_id');
        $sqrFtArr = $this->request->getVar('sqr_ft');
        $maintenanceArr = $this->request->getVar('maintenance');
        $rateArr = $this->request->getVar('rate');
        $gstArr = $this->request->getVar('gst');
        $dueDateArr = $this->request->getVar('due_date');
        $receivedDateArr = $this->request->getVar('received_date');
        $dayArr = $this->request->getVar('day');
        $penaltyArr = $this->request->getVar('penalty');
        $totalArr = $this->request->getVar('total');
        $deleteMaintenanceCalculationFlatId = $this->request->getVar('delete_maintenance_calculation_flat_id');


        $validation->setRule('calculation_date', lang('MaintenanceCalculation.calculation_date'), 'required');
        $validation->setRule('unit_of_measurement', lang('MaintenanceCalculation.unit_of_measurement'), 'required');


        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

            // printArray($deleteMaintenanceCalculationFlatId,1);

            $societyId = $this->session->get('society_id');
            $maintenanceUpdateArray = array();
            $maintenanceArray = array(
                'id' => $maintenanceCalculationId,
                'calculation_date' => DMYToYMD($calculationDate),
                'unit_of_measurement' => $unitOfMeasurement,
                'is_select_all' => isset($isSelectAll) ? 1 : 0,
                'society_id' => $societyId,
            );

            if(!empty($maintenanceCalculationId)){
                $maintenanceUpdateData = $this->invoice_model->getMaintenanceCalculationData(array(
                    'id' => $maintenanceCalculationId,
                ));
                $maintenanceUpdateArray = compareArray($maintenanceArray,$maintenanceUpdateData);
            }

            $invoiceData = $this->invoice_model->insertUpdateRecord($maintenanceArray,'id','tbl_maintenance', 1,'',array(),array(),$maintenanceUpdateArray);
            $lastMaintenanceCalculationId = $invoiceData['lastInsertedId'];

            $maintenanceCalculationInsertUpdateArray = array();
            if (!empty($maintenanceCalculationFlatIdArr)) {
                $this->invoice_model->deleteParticularTaXId($lastMaintenanceCalculationId);

                foreach ($maintenanceCalculationFlatIdArr as $iPkey => $maintenanceCalculationFlatId) {
                    $flatId = array_key_exists($iPkey, $flatIdArr) ? $flatIdArr[$iPkey] : '';
                    $sqrFt = array_key_exists($iPkey, $sqrFtArr) ? $sqrFtArr[$iPkey] : '';
                    $maintenance = array_key_exists($iPkey, $maintenanceArr) ? $maintenanceArr[$iPkey] : '';
                    $rate = array_key_exists($iPkey, $rateArr) ? $rateArr[$iPkey] : '';
                    $gst = array_key_exists($iPkey, $gstArr) ? $gstArr[$iPkey] : '';
                    $dueDate = array_key_exists($iPkey, $dueDateArr) ? $dueDateArr[$iPkey] : '';
                    $receivedDate = array_key_exists($iPkey, $receivedDateArr) ? $receivedDateArr[$iPkey] : '';
                    $day = array_key_exists($iPkey, $dayArr) ? $dayArr[$iPkey] : '';
                    $penalty = array_key_exists($iPkey, $penaltyArr) ? $penaltyArr[$iPkey] : '';
                    $total = array_key_exists($iPkey, $totalArr) ? $totalArr[$iPkey] : '';
                        
                    $maintenanceCalculationInsertUpdateArray[] = array(
                        'maintenance_flat_id' => $maintenanceCalculationFlatId,
                        'maintenance_id' => $lastMaintenanceCalculationId,
                        'flat_id' => $flatId,
                        'sqr_ft' => $sqrFt,
                        'maintenance' => $maintenance,
                        'rate' => $rate,
                        'gst' => $gst,
                        'due_date' => DMYToYMD($dueDate),
                        'received_date' => DMYToYMD($receivedDate),
                        'day' => $day,
                        'penalty' => $penalty,
                        'total' => $total,
                        'created_by' => $this->data['userId'],
                        'updated_by' => $this->data['userId'],
                        'created_at' => date("Y-m-d H:i:s"),
                        'updated_at' => date("Y-m-d H:i:s"),
                    );
                }

                if(!empty($maintenanceCalculationInsertUpdateArray)){
                    // printArray($maintenanceCalculationInsertUpdateArray,1);
                    $this->invoice_model->batchInsert($maintenanceCalculationInsertUpdateArray,'tbl_maintenance_flat',array());
                }

                if(!empty($deleteMaintenanceCalculationFlatId)){
                    // printArray($deleteMaintenanceCalculationFlatId,1);
                    $this->invoice_model->deleteMultipleParticularId($deleteMaintenanceCalculationFlatId);
                }
                
            }

            $transactionStatus = $this->db->transComplete();
            if (isset($maintenanceCalculationId) && $maintenanceCalculationId != '') {
                if (($invoiceData['success']) && ($transactionStatus == 1)) {
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('MaintenanceCalculation.maintenance_calculation'));
                } else {
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('MaintenanceCalculation.maintenance_calculation'));
                }
            } else {
                if (($invoiceData['success']) && ($transactionStatus == 1)) {

                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('MaintenanceCalculation.maintenance_calculation'));
                } else {
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('MaintenanceCalculation.maintenance_calculation'));
                }
            }
            echo json_encode($response);
            exit();
        }

    }

    public function addMaintenanceCalculationFlatRow()
    {
        $data['row_number'] = $this->request->getVar("row_number");
        $transactionRow = view('Admin/MaintenanceCalculation/MaintenanceCalculationFlatRowView', $data);
        echo $transactionRow;
    }

    public function changeStatus()
    {
        $invoiceId = $this->request->getVar('invoice_id');
        $status = $this->request->getVar('status');
        $return = $this->invoice_model->statusChange($invoiceId,$status,'invoice_id','tbl_invoice');
        if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('MaintenanceCalculation.amenities'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('MaintenanceCalculation.amenities'));
        }
        echo json_encode($response);
        exit();
    }

    public function addMaintenanceCalculationParticularRow()
    {
        $data['row_number'] = $this->request->getVar("row_number");
        $transactionRow = view('Admin/MaintenanceCalculation/MaintenanceCalculationParticularRowView', $data);
        echo $transactionRow;
    }

    public function delete()
    {
        $this->db->transStart();
        $calculationId = $this->request->getVar('calculation_id');
        $ids = is_array($calculationId) ? implode(',', $calculationId) : $calculationId;


        $calculationData = $this->invoice_model->deleteRecord($calculationId);
        $this->invoice_model->deleteParticularTaXId($calculationId);
        $transactionStatus = $this->db->transComplete();
        if (($calculationData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('MaintenanceCalculation.maintenance_calculation'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang('MaintenanceCalculation.maintenance_calculation'));
        }
        echo json_encode($response);
        exit;
    }

    public function excelExportMaintenanceCalculation()
    {
        $fileName ='invoice-' . DATETIMEFORMAT;
        $sheetName = 'MaintenanceCalculation-' . DATEFORMAT;
        $excelHeaderName = 'MaintenanceCalculation';
        $tableData = $this->getMaintenanceCalculationListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            lang('MaintenanceCalculation.invoice_number'),
            lang('MaintenanceCalculation.invoice_date'),
            lang('MaintenanceCalculation.due_date'),
            lang('MaintenanceCalculation.flat_no'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                $row["document_number"],
                YMDToDMY($row["invoice_date"]),
                YMDToDMY($row["due_date"]),
                $row["flat_no"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'F';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }

    public function view($id = null)
    {
        $invoiceId = $this->request->getVar("view_id");
        if($invoiceId == "" && $invoiceId == null){
            return redirect()->to('Admin/MaintenanceCalculation');
        }
        else {
            $id = $invoiceId;
            $filterData = array(
                "invoice_id" => $invoiceId
            );
            $data['invoice_data'] = $this->invoice_model->getMaintenanceCalculationData($filterData);

            if (empty($data['invoice_data'])) {
                return redirect()->to('Admin/MaintenanceCalculation');
            }
            
            $invoiceView = view("Admin/MaintenanceCalculation/MaintenanceCalculationModelView", $data);
            $response['view_title'] = "MaintenanceCalculation Details";
            $response['view_detail'] = $invoiceView;
            $response['success'] = true;
            echo json_encode($response);
        }
    }

    public function pdf($id = null, $view = null,$save_bufffer = null,$zipPdf = 0){
        $invoiceId = $id;
        $societyId = $this->session->get('society_id');

        $societyData = $this->society_model->getSocietyData(array(
            "society_id" => $societyId
        ));

        $filterData = array(
            "id" => $id
        );
        $data['maintenance_calculation_data'] = $this->invoice_model->getMaintenanceCalculationData($filterData);

        if (empty($data['maintenance_calculation_data'])) {
            // return redirect()->to('Admin/MaintenanceCalculation');
        } else {
            $data['maintenance_calculation_flat_data'] = $this->invoice_model->getMaintenanceCalculationFlatData(array(
                'maintenance_id' => $id,
                'is_multiple' => 1,
            ));
        }

        $data['society_data'] = $societyData;

        $data['name'] = lang("MaintenanceCalculation.maintenance_calculation") . "_" .siteDateFormat($data['maintenance_calculation_data']['calculation_date']). ".pdf";
        $printHeader = '';
        $printFooter = '';
        // $signatureDetails = array(
        //     "created_by" => isset($voucher['created_by']) ? $voucher['created_by'] : "",
        //     "approved_by" =>  "",
        //     "document_number" => isset($voucher['flat_no'])  ? lang("Voucher.voucher")."# ".$voucher['flat_no']  : "",
        //     "document_date" => isset($voucher['created_at']) ? siteDateFormat($voucher['created_at']) : "",
        //     "print_for" => "Voucher",
        // );
        // if (isset($voucher['voucher_id'])) {
        //     $printFooter = pdfFooter( 1, $signatureDetails);
        // }
        $html = view('Admin/MaintenanceCalculation/pdf/MaintenanceCalculationPdfView', $data);
        
        // echo($html);
        // die();
        generate_pdf($html, $data['name'], false, $printFooter, '', $printHeader, '', 'P');
    }
}
