<?php
namespace App\Controllers\Admin;

use App\Models\LetterHeadModel;
use CodeIgniter\Controller;
class LetterHead extends BaseController
{
    protected $letter_head_model;
    public function __construct() {
        $this->letter_head_model = new LetterHeadModel();
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );
        $data['title'] = 'Letter Head';
        return $this->dt_ci_template->load("Admin","LetterHead/LetterHeadView",$data);
    }

    public function getLetterHeadListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $this->datatables->table("tbl_letter_head as tlh");
        $this->datatables->select("tlh.letter_head_id,tlh.letter_head_title,tlh.letter_head_date");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tlh.updated_at");
        $this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = tlh.society_id","left");
        $this->datatables->join("society_user_master_view as tupdate","tupdate.user_society_id = tlh.updated_by","left");
        $this->datatables->groupBy("tlh.letter_head_id");

        accessFilter($this->datatables, array("society" => "tlh.society_id"));

        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "letter_head_id" => isset($displayData['letter_head_id']) ? $displayData['letter_head_id'] : ""
                );
                $data[$key]['action_button'] = letterHeadActionButton($actionButtonFilter);
                $data[$key]['letter_head_date'] = isValidDate($displayData['letter_head_date']) ? siteDateFormat($displayData['letter_head_date']) : "";
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }

    public function manage($letterHeadId = '')
    {

        $data['extra_js'] = array(
            "js/jquery.form.min.js",
			"vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
			"vendor/libs/flatpickr/flatpickr.js",
			"js/validate.min.js",
			"js/additional_methods.min.js",
            "vendor/libs/ckeditor/ckeditor_classic.js",
        );

        if ($letterHeadId != '') {
            $filterData = array(
                "letter_head_id" => $letterHeadId
            );
            $data['letter_head_data'] = $this->letter_head_model->getLetterHeadData($filterData);

            if (empty($data['letter_head_data'])) {
                return redirect()->to('Admin/LetterHead');
            }
        }
        if ($letterHeadId != '') {
            $data['title'] = 'Edit Letter Head';
        } else {
            $data['title'] = 'Add Letter Head';
        }
        if ((isset($data['letter_head_data']['society_id']) && $data['letter_head_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/LetterHead');
        }
        $this->dt_ci_template->load("Admin","LetterHead/LetterHeadManageView",$data);
    }

    public function save()
    {
        $this->db->transStart();
        $validation = \Config\Services::validation();

        $letterHeadId = $this->request->getVar('letter_head_id');
        $letterHeadTitle = $this->request->getVar('letter_head_title');
        $letterHeadDate = $this->request->getVar('letter_head_date');
        $description = $this->request->getVar('description');

        $validation->setRule('letter_head_title', lang('LetterHead.letter_head_title'), 'required');
        $validation->setRule('letter_head_date', lang('LetterHead.letter_head_date'), 'required');
        $validation->setRule('description', lang('LetterHead.description'), 'required');
        

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

            $letterHeadUpdateArray = array();
            $letterHeadArray = array(
                'letter_head_id' => $letterHeadId,
                'letter_head_title' => $letterHeadTitle,
                'letter_head_date' => DMYToYMD($letterHeadDate),
                'description' => $description,
                'society_id' => $this->session->get('society_id'),
            );

            if(!empty($letterHeadId)){
                $letterHeadUpdateData = $this->letter_head_model->getLetterHeadData(array(
                    'letter_head_id' => $letterHeadId,
                ));
                $letterHeadUpdateArray = compareArray($letterHeadArray,$letterHeadUpdateData);
            }

            
            $letterHeadData = $this->letter_head_model->insertUpdateRecord($letterHeadArray,'letter_head_id','tbl_letter_head', 1,'',array(),array(),$letterHeadUpdateArray);
            
        }
        $transactionStatus = $this->db->transComplete();
            if (isset($letterHeadId) && $letterHeadId != '') {
                if (($letterHeadData['success']) && ($transactionStatus == 1)) {
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('LetterHead.letter_head'));
                } else {
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('LetterHead.letter_head'));
                }
            } else {
                if (($letterHeadData['success']) && ($transactionStatus == 1)) {
                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('LetterHead.letter_head'));
                } else {
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('LetterHead.letter_head'));
                }
            }
            echo json_encode($response);
            exit();
        }


    public function delete()
    {
        $this->db->transStart();
        $letterHeadId = $this->request->getVar('letter_head_id');
        
        $letterHeadData = $this->letter_head_model->deleteRecord($letterHeadId);
        $transactionStatus = $this->db->transComplete();
        if (($letterHeadData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('LetterHead.letter_head'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang('LetterHead.letter_head'));
        }
        echo json_encode($response);
        exit;
    }
}
