<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
// use App\Models\MaterialModel;
use App\Models\ItemLedgerModel;

class ItemLedger extends BaseController
{
    protected $item_ledger_model;
    public function __construct() {
        // $this->material_model = new MaterialModel();
        $this->item_ledger_model = new ItemLedgerModel();

    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/moment/moment.js",
            "vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
        $data['title'] = 'Item Ledger';
        $dataFilters['filters'] = array(
            array(
                "type" => "multi_select",
                "dynamic" => true,
                "class" => "commonAreaDd",
                "id" => "filter_common_area_id",
                "name" => "filter_common_area_id",
                "title" => "ItemLedger.common_area",
            ),
            array(
                "type" => "multi_select",
                "dynamic" => true,
                "class" => "itemDd",
                "id" => "filter_item_id",
                "name" => "filter_item_id",
                "title" => "ItemLedger.item",
            ),
            array(
                "type" => "multi_select",
                "dynamic" => true,
                "class" => "financialYearDd",
                "id" => "filter_financial_year_id",
                "name" => "filter_financial_year_id",
                "title" => "ItemLedger.financial_year",
            ),
            array(
                "type" => "transaction_type",
                "id" => "filter_transaction_type",
                "name" => "filter_transaction_type",
                "title" => "ItemLedger.transaction_type",
            ),
        );
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Ajax)? $select2Ajax : array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
        return $this->dt_ci_template->load("Admin","ItemLedger/ItemLedgerView",$data);
    }

    public function getItemLedgerListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }

        $commonAreaId = $this->request->getVar("filter_common_area_id");
        $financialYearId = $this->request->getVar("filter_financial_year_id");
        $itemId = $this->request->getVar("filter_item_id");
        $transactionType = $this->request->getVar("filter_transaction_type");

        $this->datatables->table("tbl_item_ledger as til");

        $this->datatables->select("til.item_ledger_id, til.transaction_for,til.document_number,COALESCE(til.transaction_type,'') as transaction_type,til.cumulative_quantity_before,til.actual_qty,til.cumulative_quantity_after,til.posting_date_time,til.qty_after_transaction");

        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,til.updated_at");
        $this->datatables->select("COALESCE(ti.item_name,'') as item_name");
        $this->datatables->select("COALESCE(tfy.financial_year_prefix,'') as financial_year_prefix");
        $this->datatables->select("COALESCE(tca.common_area_name,'') as common_area_name");
        $this->datatables->select("COALESCE(ts.society_name,'') as society_name");
       
        $this->datatables->join("tbl_item as ti","ti.item_id = til.item_id","left");
        $this->datatables->join("tbl_common_area as tca","tca.common_area_id = til.common_area_id","left");
        $this->datatables->join("tbl_financial_year as tfy","tfy.financial_year_id = til.financial_year_id","left");
        $this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = til.society_id","left");
        $this->datatables->join("society_user_master_view as tupdate","tupdate.user_society_id = til.updated_by","left");
        
        if(isset($commonAreaId)) {
            if(is_array($commonAreaId)){
                $this->datatables->whereIn("til.common_area_id",$commonAreaId);
            } else {
                $this->datatables->where("til.common_area_id",$commonAreaId);
            }
        }
        if(isset($itemId)) {
            if(is_array($itemId)){
                $this->datatables->whereIn("til.item_id",$itemId);
            } else {
                $this->datatables->where("til.item_id",$itemId);
            }
        }
        if(isset($financialYearId)) {
            if(is_array($financialYearId)){
                $this->datatables->whereIn("til.item_id",$financialYearId);
            } else {
                $this->datatables->where("til.item_id",$financialYearId);
            }
        }
        if(isset($transactionType)) {
            if(is_array($transactionType)){
                $this->datatables->whereIn("til.transaction_type",$transactionType);
            } else {
                $this->datatables->where("til.transaction_type",$transactionType);
            }
        }

        $this->datatables->groupBy("til.item_ledger_id");

        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                // $actionButtonFilter = array(
                //     "common_area_id" => isset($displayData['common_area_id']) ? $displayData['common_area_id'] : "",
                // );
                // $data[$key]['action_button'] = commonAreaActionButton($actionButtonFilter);
                $data[$key]['posting_date_time'] = isValidDate($displayData['posting_date_time']) ? siteDateFormat($displayData['posting_date_time'],true) : '-';
                $data[$key]['transaction_for'] = isset($displayData['transaction_for']) ? underscoreToUcWord($displayData['transaction_for']) : '-';
                $data[$key]['transaction_type'] = isset($displayData['transaction_type']) ? underscoreToUcWord($displayData['transaction_type']) : '-';
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }

    public function excelExportItemLedger()
    {
        $fileName ='itemledger-' . DATETIMEFORMAT;
        $sheetName = 'ItemLedger-' . DATEFORMAT;
        $excelHeaderName = 'ItemLedger';
        $tableData = $this->getItemLedgerListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            lang('ItemLedger.item_name'),
            lang('ItemLedger.common_area_name'),
            lang('ItemLedger.financial_year_prefix'),
            lang('ItemLedger.transaction_type'),
            lang('ItemLedger.transaction_for'),
            lang('ItemLedger.document_number'),
            lang('ItemLedger.actual_qty'),
            lang('ItemLedger.cumulative_quantity_before'),
            lang('ItemLedger.cumulative_quantity_after'),
            lang('ItemLedger.qty_after_transaction'),
            lang('ItemLedger.posting_date_time'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                $row["item_name"],
                $row["common_area_name"],
                $row["financial_year_prefix"],
                $row["transaction_type"],
                $row["transaction_for"],
                $row["document_number"],
                $row["actual_qty"],
                $row["cumulative_quantity_before"],
                $row["cumulative_quantity_after"],
                $row["qty_after_transaction"],
                $row["posting_date_time"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'M';

        // printArray($dataRows,1);
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }
}