<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\ItemBalanceModel;
use App\Models\SocietyModel;

class ItemBalance extends BaseController
{
    protected $item_balance_model;
    public function __construct() {
        $this->item_balance_model = new ItemBalanceModel();
        $this->society_model = new SocietyModel();

    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/moment/moment.js",
            "vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
        $data['title'] = 'Item Balance';
        $dataFilters['filters'] = array(
            array(
                "type" => "multi_select",
                "dynamic" => true,
                "class" => "commonAreaDd",
                "id" => "filter_common_area_id",
                "name" => "filter_common_area_id",
                "title" => "ItemBalance.common_area",
            ),
            array(
                "type" => "multi_select",
                "dynamic" => true,
                "class" => "itemDd",
                "id" => "filter_item_id",
                "name" => "filter_item_id",
                "title" => "ItemBalance.item",
            ),
        
        );
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Ajax)? $select2Ajax : array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
        return $this->dt_ci_template->load("Admin","ItemBalance/ItemBalanceView",$data);
    }

    public function getItemBalanceListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }

        $commonAreaId = $this->request->getVar("filter_common_area_id");
        $itemId = $this->request->getVar("filter_item_id");
        $societyId = $this->session->get("society_id");

        $this->datatables->table("tbl_item_balance as tib");

        $this->datatables->select("tib.item_balance_id,tib.actual_quantity");

        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tib.updated_at");
        $this->datatables->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by,tib.created_at");
        $this->datatables->select("COALESCE(ti.item_name,'') as item_name");
        $this->datatables->select("COALESCE(tca.common_area_name,'') as common_area_name");
        $this->datatables->select("COALESCE(ts.society_name,'') as society_name");
       
        $this->datatables->join("tbl_item as ti","ti.item_id = tib.item_id","left");
        $this->datatables->join("tbl_common_area as tca","tca.common_area_id = tib.common_area_id","left");
        $this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = tib.society_id","left");
        $this->datatables->join("society_user_master_view as tupdate","tupdate.user_society_id = tib.updated_by","left");
        $this->datatables->join("society_user_master_view as tcreate","tcreate.user_society_id = tib.created_by","left");
        
        if(isset($societyId)) {
            if(is_array($societyId)){
                $this->datatables->whereIn("tib.society_id",$societyId);
            } else {
                $this->datatables->where("tib.society_id",$societyId);
            }
        }
        
        if(isset($commonAreaId)) {
            if(is_array($commonAreaId)){
                $this->datatables->whereIn("tib.common_area_id",$commonAreaId);
            } else {
                $this->datatables->where("tib.common_area_id",$commonAreaId);
            }
        }
        if(isset($itemId)) {
            if(is_array($itemId)){
                $this->datatables->whereIn("tib.item_id",$itemId);
            } else {
                $this->datatables->where("tib.item_id",$itemId);
            }
        }

        $this->datatables->groupBy("tib.item_balance_id");

        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
                $data[$key]['created_at'] = isValidDate($displayData['created_at']) ? siteDateFormat($displayData['created_at'],true) : "";
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }

    public function excelExportItemBalance()
    {
        $fileName ='itembalance-' . DATETIMEFORMAT;
        $sheetName = 'ItemBalance-' . DATEFORMAT;
        $excelHeaderName = 'ItemBalance';
        $tableData = $this->getItemBalanceListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            lang('ItemBalance.item_name'),
            lang('ItemBalance.common_area_name'),
            lang('ItemBalance.actual_quantity'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                $row["item_name"],
                $row["common_area_name"],
                $row["actual_quantity"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'E';

        // printArray($dataRows,1);
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }

    public function itemBalancePdf()
    {
        if(!$this->dt_ci_acl->checkAccess('ItemBalance|pdf')){
            return show_error(NO_ACCESS_SECTION);
        } else {
            $societyData = $this->society_model->getSocietyData(array(
                "society_id" => $this->session->get('society_id'),
            ));
            
            $filterData = array(
                'item_balance_id' => $this->session->get('item_balance_id'),
                'is_multiple' => 1, 
            );
            $itemBalanceData = $this->item_balance_model->getItemBalanceData($filterData);
            $groupedData = array();
            foreach ($itemBalanceData as $item) {
            $commonAreaName = $item['common_area_name'];
            if (!isset($groupedData[$commonAreaName])) {
                $groupedData[$commonAreaName] = array();
            }
            $groupedData[$commonAreaName][] = $item;
            }

            $data['society_data'] = $societyData;
            $data['item_balance_data'] = $groupedData;
            // printArray($groupedData,1);

            $data['name'] = lang("ItemBalance.item_balance_pdf") . ".pdf";
            $printHeader = '';
            $printFooter = '';
            $printFooter = pdfFooter( 0, array());
            $html = view('Admin/ItemBalance/pdf/ItemBalancePdfView', $data);
            // echo($html);
            // die();
            generate_pdf($html, $data['name'], false, $printFooter, '', $printHeader, '', 'P');
        }
    }
}