<?php
namespace App\Controllers\Admin;
use App\Models\SocietyModel;
use CodeIgniter\Controller;
use App\Models\InvestmentsModel;
use App\Models\FinancialYearModel;
class Investments extends BaseController
{
    protected $investments_model;
    protected $society_model;
    protected $financial_year_model;
    public function __construct() {
        $this->investments_model = new InvestmentsModel();
        $this->society_model = new SocietyModel();
        $this->financial_year_model = new FinancialYearModel();
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
			"vendor/libs/moment/moment.js",
			"vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
        $data['title'] = 'Investments';
		$dataFilters['filters'] = array(
			array(
				"type" => "multi_select",
				"dynamic" => true,
				"class" => "financialYearDd",
				"id" => "filter_financial_year_id",
				"name" => "filter_financial_year_id",
				"title" => "Investments.financial_year",
			),
			array(
				"type" => "daterange",
				"id" => "filter_date",
				"name" => "filter_date",
				"title" => "Investments.date",
			),
			array(
				"type" => "multi_select",
				"dynamic" => true,
				"class" => "bankDd",
				"id" => "filter_bank_id",
				"name" => "filter_bank_id",
				"title" => "Investments.bank",
			),
			array(
				"type" => "daterange",
				"id" => "filter_maturity_date",
				"name" => "filter_maturity_date",
				"title" => "Investments.maturity_date",
			),
			array(
				"type" => "daterange",
				"id" => "filter_created_at",
				"name" => "filter_created_at",
				"title" => "CommonMessage.common_created_at",
			),
			array(
				"type" => "daterange",
				"id" => "filter_updated_at",
				"name" => "filter_updated_at",
				"title" => "CommonMessage.common_updated_at",
			),
		);
		$data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
        return $this->dt_ci_template->load("Admin","Investments/InvestmentsView",$data);
    }

    public function getInvestmentsListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        
        $bankId = $this->request->getVar("filter_bank_id");
		$financialYearId = $this->request->getVar("filter_financial_year_id");
		$createdAt = $this->request->getVar("filter_created_at");
		$updatedAt = $this->request->getVar("filter_updated_at");
		$date = $this->request->getVar("filter_date");
		$maturityDate = $this->request->getVar("filter_maturity_date");

        $this->datatables->table(" tbl_investments as ti");

        $this->datatables->select("ti.investments_id,ts.society_name,ti.is_active,tb.bank_name,tfy.financial_year_prefix,ti.date,ti.fdr_no,ti.fdr_amount,ti.term,ti.rate,ti.maturity_amount,ti.maturity_date,ti.acrd_int");
		$this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,ti.updated_at");
		
		$this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = ti.society_id","left");
		$this->datatables->join("tbl_bank as tb","tb.bank_id = ti.bank_id","left");
		$this->datatables->join("tbl_financial_year as tfy","tfy.financial_year_id = ti.financial_year_id","left");
		$this->datatables->join("society_user_master_view as tupdate","tupdate.user_society_id = ti.updated_by","left");
        

		if(isset($bankId)) {
			if(is_array($bankId)){
				$this->datatables->whereIn("ti.bank_id",$bankId);
			} else {
				$this->datatables->where("ti.bank_id",$bankId);
			}
		}

		if(isset($financialYearId)) {
			if(is_array($financialYearId)){
				$this->datatables->whereIn("ti.financial_year_id",$financialYearId);
			} else {
				$this->datatables->where("ti.financial_year_id",$financialYearId);
			}
		}

		if($date != ''){
			list($fromDate,$toDate) = explode(" - ",$date);
			$fromDate = DMYToYMD($fromDate);
			$toDate = DMYToYMD($toDate);
			if(strtotime($fromDate) != strtotime($toDate)){
				$this->datatables->where("date_format(ti.date,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
				$this->datatables->where("date_format(ti.date,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
			} else {
				$this->datatables->where("date_format(ti.date,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
			}
		}

		if($maturityDate != ''){
			list($fromDate,$toDate) = explode(" - ",$maturityDate);
			$fromDate = DMYToYMD($fromDate);
			$toDate = DMYToYMD($toDate);
			if(strtotime($fromDate) != strtotime($toDate)){
				$this->datatables->where("date_format(ti.maturity_date,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
				$this->datatables->where("date_format(ti.maturity_date,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
			} else {
				$this->datatables->where("date_format(ti.maturity_date,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
			}
		}

		if($createdAt != ''){
			list($fromDate,$toDate) = explode(" - ",$createdAt);
			$fromDate = DMYToYMD($fromDate);
			$toDate = DMYToYMD($toDate);
			if(strtotime($fromDate) != strtotime($toDate)){
				$this->datatables->where("date_format(ti.created_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
				$this->datatables->where("date_format(ti.created_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
			} else {
				$this->datatables->where("date_format(ti.created_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
			}
		}
		if($updatedAt != ''){
			list($fromDate,$toDate) = explode(" - ",$updatedAt);
			$fromDate = DMYToYMD($fromDate);
			$toDate = DMYToYMD($toDate);
			if(strtotime($fromDate) != strtotime($toDate)){
				$this->datatables->where("date_format(ti.updated_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
				$this->datatables->where("date_format(ti.updated_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
			} else {
				$this->datatables->where("date_format(ti.updated_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
			}
		}
		$this->datatables->groupBy("ti.investments_id");
		accessFilter($this->datatables, array("society" => "ti.society_id"));
		$dataReport =  $this->datatables->generate();
		$dataReport = json_decode($dataReport, true);
		$data       = $dataReport['data'];
		if(count($data) > 0){
			foreach($data as $key => $displayData){
				$actionButtonFilter = array(
					"investments_id" => isset($displayData['investments_id']) ? $displayData['investments_id'] : ""
				);
				$data[$key]['action_button'] = investmentsActionButton($actionButtonFilter);
				$data[$key]['date'] = siteDateFormat($displayData['date']);
				$data[$key]['maturity_date'] = siteDateFormat($displayData['maturity_date']);
				$data[$key]['updated_at'] = isValidDate($data[$key]['updated_at']) ? siteDateFormat($data[$key]['updated_at'],true) : "";
			}
		}

		if($return){
			return $data;
		}else{
			$dataReport['data'] = $data;
			echo json_encode($dataReport);
			exit;
		}
    
    }
    public function manage($investmentsId = '')
	{

		$data['extra_js'] = array(
            "js/jquery.form.min.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/bootstrap-datepicker/bootstrap-datepicker.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
        );

        if ($investmentsId != '') {
			$filterData = array(
				"investments_id" => $investmentsId
			);
			$data['investments_data'] = $this->investments_model->getInvestmentsData($filterData);
		}
		if ($investmentsId != '') {
			$data['title'] = 'Edit Investments';
		} else {
			$data['title'] = 'Add Investments';
		}

        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Condition)? $select2Condition : array());
		return $this->dt_ci_template->load("Admin","Investments/InvestmentsManageView",$data);
	}

    public function save()
	{
		$this->db->transStart();
        $validation = \Config\Services::validation();

		$investmentsId = $this->request->getVar('investments_id');
		$financialYearId = $this->request->getVar('financial_year_id');
		$date = $this->request->getVar("date");
		$bankId = $this->request->getVar("bank_id");
		$fdrNo = $this->request->getVar("fdr_no");
		$fdrAmount = $this->request->getVar("fdr_amount");
		$term = $this->request->getVar("term");
		$rate = $this->request->getVar("rate");
		$acrdInt = $this->request->getVar("acrd_int");
		$maturityDate = $this->request->getVar("maturity_date");
		$maturityAmount = $this->request->getVar("maturity_amount");
		$isActive = $this->request->getVar("is_active");

		$validation->setRule('date', lang('Investments.start_date'), 'required');
		$validation->setRule('bank_id', lang('Investments.bank_id'), 'required');
		$validation->setRule('fdr_no', lang('Investments.fdr_no'), 'required');
		$validation->setRule('fdr_amount', lang('Investments.fdr_amount'), 'required');
		$validation->setRule('term', lang('Investments.term'), 'required');
		$validation->setRule('rate', lang('Investments.rate'), 'required');
		$validation->setRule('acrd_int', lang('Investments.acrd_int'), 'required');
		$validation->setRule('maturity_date', lang('Investments.maturity_date'), 'required');
		$validation->setRule('maturity_amount', lang('Investments.maturity_amount'), 'required');
		
	

		if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {
			$investmentsUpdateArray = array();
			$investmentsArray = array(
				'investments_id' => $investmentsId,
				'financial_year_id' => $financialYearId,
				'date' => DMYToYMD($date),
				'society_id' => $this->session->get('society_id'),
				'bank_id' => $bankId,
				'fdr_no' => $fdrNo,
				'fdr_amount' => $fdrAmount,
				'term' => $term,
				'rate' => $rate,
				'acrd_int' => $acrdInt,
				'maturity_date' => DMYToYMD($maturityDate),
				'maturity_amount' => $maturityAmount,
				'is_active' => isset($isActive) ? 1 : 0,
			);

			if(!empty($investmentsId)){
                $investmentsUpdateData = $this->investments_model->getInvestmentsData(array(
                    'investments_id' => $investmentsId,
                ));
                $investmentsUpdateArray = compareArray($investmentsArray,$investmentsUpdateData);
            }
			$investmentsData = $this->investments_model->insertUpdateRecord($investmentsArray, 'investments_id', 'tbl_investments', 1,'',array(),array(),$investmentsUpdateArray);
			$lastInvestmentsId = $investmentsData['lastInsertedId'];
			$transactionStatus = $this->db->transComplete();
			if (isset($investmentsId) && $investmentsId != '') {
				if (($investmentsData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.update_record'), lang("Investments.investments"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.update_record_error'), lang("Investments.investments"));
				}
			} else {
				if (($investmentsData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.create_record'), lang("Investments.investments"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.create_record_error'), lang("Investments.investments"));
				}
			}
			echo json_encode($response);
			exit;
	}
}
    public function changeStatus()
    {
        $investmentsId = $this->request->getVar('investments_id');
        $status = $this->request->getVar('status');

        //$status         = ($status == 0) ? 1 : 0;
        $return = $this->investments_model->statusChange($investmentsId,$status,'investments_id','tbl_investments');
        if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('Investments.investments'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('Investments.investments'));
        }
        echo json_encode($response);
        exit();
    }


    public function delete()
    {
    	$this->db->transStart();
        $investmentsId = $this->request->getVar('investments_id');
        $ids = is_array($investmentsId) ? implode(',', $investmentsId) : $investmentsId;
    //    if( isReferenceInTable( 'society_id','tbl_amc_detail', $societyId) ||
    //        isReferenceInTable( 'society_id','tbl_amenities', $societyId) ||
    //        isReferenceInTable( 'society_id','tbl_booking', $societyId) ||
    //        isReferenceInTable( 'society_id','tbl_broker', $societyId) ||
    //        isReferenceInTable( 'society_id','tbl_common_area', $societyId) ||
    //        isReferenceInTable( 'society_id','tbl_complain', $societyId) ||
    //        isReferenceInTable( 'society_id','tbl_flat', $societyId) ||
    //        isReferenceInTable( 'society_id','tbl_flat_square_feet_area', $societyId) ||
    //        isReferenceInTable( 'society_id','tbl_intercom', $societyId) ||
    //        isReferenceInTable( 'society_id','tbl_investments', $societyId) ||
    //        isReferenceInTable( 'society_id','tbl_management_committee', $societyId) ||
    //        isReferenceInTable( 'society_id','tbl_men_power_attendance', $societyId) ||
    //        isReferenceInTable( 'society_id','tbl_ownership_flat', $societyId) ||
    //        isReferenceInTable( 'society_id','tbl_rentals', $societyId) ||
    //        isReferenceInTable( 'society_id','tbl_service', $societyId) ||
    //        isReferenceInTable( 'society_id','tbl_staff', $societyId) ||
    //        isReferenceInTable( 'society_id','tbl_time_slot', $societyId) ||
    //        isReferenceInTable( 'society_id','tbl_tower', $societyId) ||
    //        isReferenceInTable( 'society_id','tbl_vendor', $societyId) ||
    //        isReferenceInTable( 'society_id','tbl_water_meter_reading', $societyId) ||
    //        isReferenceInTable( 'society_id','tbl_parking_place', $societyId)
    //    ){

    //        if(!empty($societyId)){
    //            foreach($societyId as $society){
    //                $deleteDataArray['module'] = 'Society';
    //                $deleteDataArray['activity'] = "Tried to delete Society ";
    //                $deleteDataArray['module_id'] = $society;
    //                logActivity('Tried to delete Society [SocietyID: ' . $society . ']',$this->data['userId'],'Society',$society,json_encode($deleteDataArray),'','Society',$society);
    //            }
    //        }

    //        $response['success'] = false;
    //        $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
    //        echo json_encode($response);
    //        exit;
    //    }
        $investmentsData = $this->investments_model->deleteRecord($investmentsId);
        $transactionStatus = $this->db->transComplete();
        if (($investmentsData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Investments.investments'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang('Investments.investments'));
        }
        echo json_encode($response);
        exit;
    }

    public function getFinancialYearDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page = $this->request->getVar('page');
        $financialYearId = $this->request->getVar('financial_year_id');
        $filterData = array(
            'financial_year_id' => $financialYearId,
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT
        );

        echo $this->investments_model->getFinancialYear($filterData);
    }
    public function view($id = null)
	{
		$investmentsId = $this->request->getVar("view_id");
		if($investmentsId == "" && $investmentsId == null){
            return redirect()->to('Admin/Investment');
		}
		else {
			$id = $investmentsId;
			$filterData = array(
				"investments_id" => $investmentsId
			);
			$data['investments_data'] = $this->investments_model->getInvestmentsData($filterData);
			$investmentsView = view("Admin/Investments/InvestmentsModelView",$data);
			$response['view_title'] = "Investments Details";
			$response['view_detail'] = $investmentsView;
			$response['success'] = true;
			echo json_encode($response);
		}
	}

    public function excelExportInvestments()
	{
		$fileName ='investments-' . DATETIMEFORMAT;
		$sheetName = 'investments-' . DATEFORMAT;
		$excelHeaderName = 'Investments';
		$tableData = $this->getInvestmentsListing(true, $_GET);
		$dataRows = array();
		$dataRows[] = array(
			// lang('Investments.society'),
			lang('Investments.financial_year'),
			lang('Investments.date'),
			lang('Investments.bank'),
			lang('Investments.fdr_no'),
			lang('Investments.fdr_amount'),
			lang('Investments.term'),
			lang('Investments.rate'),
			lang('Investments.acrd_int'),
			lang('Investments.maturity_date'),
			lang('Investments.maturity_amount'),
			lang('CommonMessage.common_updated_by'),
			lang('CommonMessage.common_updated_at')
		);
		foreach ($tableData as $row) {
			$dataRows[] = array(
				// $row["society_name"],
				$row["financial_year_prefix"],
				$row["date"],
				$row["bank_name"],
				$row["fdr_no"],
				$row["fdr_amount"],
				$row["term"],
				$row["rate"],
				$row["acrd_int"],
				$row["maturity_date"],
				$row["maturity_amount"],
				$row["updated_by"],
				$row["updated_at"]
			);
		}
		$subTotalCellValueArray = [];
		$toColumn = 'L';
		$excelFilterData = array(
			'file_name' => $fileName,
			'sheet_name' => $sheetName,
			'excel_header_name' => $excelHeaderName,
			'data_row' => $dataRows,
			'sub_total_cell_value_array' => $subTotalCellValueArray,
			'to_column' => $toColumn,
			'skip_header' => false,
			'ignore_currency_symbols_sub_total_cell_value_array' => array(),
			'row_cell_currency_format' => array()
		);
		//excelExport($filename,$sheetName,$excelHeaderName,$dataRows,$subTotalCellValueArray,$toColumn,false,array(),array());
		excelExport($excelFilterData);
	}

    public function investmentsPdf()
	{
		if(!$this->dt_ci_acl->checkAccess('Investments|pdf')){
			return NO_ACCESS_SECTION;
		} else {
			$societyData = $this->society_model->getSocietyData(array(
				"society_id" => $this->session->get('society_id'),
			));
			$data['society_data'] = $societyData;

			$getCurrentFinancialYear = currentFinancialYear();
			$financialYearData = array();
			if($getCurrentFinancialYear != ''){
				list($fromDate,$toDate) = explode(" - ",$getCurrentFinancialYear);
				$fromDate = DMYToYMD($fromDate);
				$toDate = DMYToYMD($toDate);

				$financialYearData = $this->financial_year_model->getFinancialYearData(array(
					"start_date" => $fromDate,
					"end_date" => $toDate
				));
			}
			$data['financial_year_data'] = $financialYearData;

			$filterData = array(
				'is_multiple' => 1,
				'financial_year_id' => isset($financialYearData['financial_year_id']) ? $financialYearData['financial_year_id'] : '',
			);
			$investmentsData = $this->investments_model->getInvestmentsData($filterData);
			$data['investments_data'] = $investmentsData;
			$data['name'] = lang("Investments.investments_pdf") . ".pdf";
			$printHeader = '';
			$printFooter = '';

			$printFooter = pdfFooter( 0, array());

			$html = view('Admin/Investments/pdf/InvestmentsPdfView', $data);
			generate_pdf($html, $data['name'], false, $printFooter, '', $printHeader, '', 'P');
		}
	}
}
