<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\GeneratorReadingModel;
class GeneratorReading extends BaseController
{
    public function __construct() {
        $this->generator_reading_model = new GeneratorReadingModel();
    }
	public function index()
	{
		$data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
			"vendor/libs/moment/moment.js",
			"vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
        $data['title'] = lang('GeneratorReading.generator_reading');
		$dataFilters['filters'] = array(
            array(
                "type" => "multi_select",
                "dynamic" => true,
                "class" => "generatorDd",
                "id" => "filter_generator_id",
                "name" => "filter_generator_id",
                "title" => "GeneratorReading.generator",
            ),
			array(
                "type" => "daterange",
                "id" => "filter_date",
                "name" => "filter_date",
                "title" => "GeneratorReading.generator_start_date",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_created_at",
                "name" => "filter_created_at",
                "title" => "CommonMessage.common_created_at",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_updated_at",
                "name" => "filter_updated_at",
                "title" => "CommonMessage.common_updated_at",
            ),
        );

        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Ajax)? $select2Ajax : array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
        return $this->dt_ci_template->load("Admin","GeneratorReading/GeneratorReadingView",$data);
	}

	public function manage($generatorReadingId = '')
	{
		$data['extra_js'] = array(
            "js/jquery.form.min.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/bootstrap-datepicker/bootstrap-datepicker.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
        );

        if ($generatorReadingId != '') {
			$filterData = array(
				"generator_reading_id" => $generatorReadingId,
                'society_id' => $this->session->get('society_id'),
			);
			$data['generator_reading_data'] = $this->generator_reading_model->getGeneratorReadingData($filterData);
		}
		if ($generatorReadingId != '') {
			$data['title'] = lang('GeneratorReading.edit_generator_reading');
		} else {
			$data['title'] = lang('GeneratorReading.add_generator_reading');
		}

		if ((isset($data['generator_reading_data']['society_id']) && $data['generator_reading_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/GeneratorReading');
        }
		$data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Ajax)? $select2Ajax : array());
		return $this->dt_ci_template->load("Admin","GeneratorReading/GeneratorReadingManageView",$data);
	}

    public function getGeneratorReadingListing($return = false,$filterData=array())
    {
    	if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }

		$createdAt = $this->request->getVar("filter_created_at");
		$updatedAt = $this->request->getVar("filter_updated_at");
        $generatorId = $this->request->getVar("filter_generator_id");
		$date = $this->request->getVar("filter_date");

        $this->datatables->table("tbl_generator_reading as tgr");
		$this->datatables->select("tgr.generator_reading_id,ts.society_name,ts.society_name,tgr.generator_start_time,tgr.generator_end_time,tgr.generator_start_date");
		$this->datatables->select("tgr.generator_id,COALESCE(tg.generator_name,'') as generator_name,tgr.reading_type");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $this->datatables->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by,tgr.created_at,tgr.updated_at");
		$this->datatables->select("tgr.generator_usage_hours,tgr.filled_liter,tgr.available_liter");
		$this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = tgr.society_id","left");
		$this->datatables->join("tbl_generator as tg","tg.generator_id = tgr.generator_id","left");
        $this->datatables->join("society_user_master_view as tupdate","tupdate.user_society_id = tgr.updated_by","left");
        $this->datatables->join("society_user_master_view as tcreate","tcreate.user_society_id = tgr.created_by","left");

		if(isset($generatorId)) {
            if(is_array($generatorId)){
                $this->datatables->whereIn("tgr.generator_id",$generatorId);
            } else {
                $this->datatables->where("tgr.generator_id",$generatorId);
            }
        }

		if($date != ''){
            list($fromDate,$toDate) = explode(" - ",$date);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tgr.generator_start_date,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tgr.generator_start_date,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tgr.generator_start_date,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }
		if($createdAt != ''){
            list($fromDate,$toDate) = explode(" - ",$createdAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tgr.created_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tgr.created_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tgr.created_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }
        if($updatedAt != ''){
            list($fromDate,$toDate) = explode(" - ",$updatedAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tgr.updated_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tgr.updated_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tgr.updated_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }

		$this->datatables->groupBy("tgr.generator_reading_id");
		accessFilter($this->datatables, array("society" => "tgr.society_id"));
		$dataReport =  $this->datatables->generate();
		$dataReport = json_decode($dataReport, true);
		$data       = $dataReport['data'];
		if(count($data) > 0){
			foreach($data as $key => $displayData){
				$actionButtonFilter = array(
					"generator_reading_id" => isset($data[$key]['generator_reading_id']) ? $data[$key]['generator_reading_id'] : ""
				);
				$data[$key]['action_button'] = GeneratorReadingActionButton($actionButtonFilter);
				$data[$key]['generator_start_date'] = isValidDate($data[$key]['generator_start_date']) ? siteDateFormat($data[$key]['generator_start_date']) : "";
				$data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
                $data[$key]['created_at'] = isValidDate($displayData['created_at']) ? siteDateFormat($displayData['created_at'],true) : "";
				$data[$key]['generator_start_time'] = isset($displayData['generator_start_time']) ? date("H:i", strtotime($displayData['generator_start_time'])) : '';
				$data[$key]['generator_start_time_display'] = isset($displayData['generator_start_time']) ? date("h:i A", strtotime($displayData['generator_start_time'])) : '';
				$data[$key]['generator_end_time'] = isset($displayData['generator_end_time']) ? date("H:i", strtotime($displayData['generator_end_time'])) : '';
				$data[$key]['generator_end_time_display'] = isset($displayData['generator_end_time']) ? date("h:i A", strtotime($displayData['generator_end_time'])) : '';
				$data[$key]['excel_generator_name'] = isset($displayData['generator_name']) ?  $displayData['generator_name'] : "";
				//$data[$key]['generator_name'] = isset($displayData['generator_name']) ?  generatorDocumentToHtml($displayData['generator_name'],$displayData['generator_id']) : "";
			}
		}
		if($return){
			return $data;
		}else{
			$dataReport['data'] = $data;
			echo json_encode($dataReport);
			exit;
		}
    }

    public function save()
	{
        $this->db->transStart();
		$validation = \Config\Services::validation();
		$generatorReadingId = $this->request->getVar('generator_reading_id');
		$generatorId = $this->request->getVar("generator_id");
		$generatorStartDate = $this->request->getVar("generator_start_date");
        $generatorStartTime = $this->request->getVar("generator_start_time");
        $generatorEndTime = $this->request->getVar("generator_end_time");
        $generatorUsageHours = $this->request->getVar("generator_usage_hours");
        $filledLiter = $this->request->getVar("filled_liter");
        $availableLiter = $this->request->getVar("available_liter");
        $readingType = $this->request->getVar("reading_type");


        $validation->setRule('generator_id', lang('GeneratorReading.generator'), 'required');
//		$validation->setRule('generator_start_date', lang('GeneratorReading.generator_start_date'), 'required');
//		$validation->setRule('generator_start_time', lang('GeneratorReading.generator_start_time'), 'required');
//		$validation->setRule('generator_end_time', lang('GeneratorReading.generator_end_time'), 'required');
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {
			if (strtotime($generatorStartTime) >= strtotime($generatorEndTime)){
				$response['success'] = false;
				$response['msg'] = lang('GeneratorReading.generator_reading_end_time_message');
				echo json_encode($response);
				exit;
			}


            $hours = '';
            if (!empty($generatorStartTime) && !empty($generatorEndTime)) {
                $startTimestamp = strtotime($generatorStartTime);
                $endTimestamp = strtotime($generatorEndTime);
                $timeDifference = $endTimestamp - $startTimestamp;
                $hours = $timeDifference / 3600;
            }

            if($readingType == 'usage'){
                $availableLiter = 0;
            }
			
			$generatorReadingUpdateArray = array();
			$generatorReadingArray = array(
				'generator_reading_id' => $generatorReadingId,
                'generator_id' => $generatorId,
                'generator_start_date' => DMYToYMD($generatorStartDate),
                'generator_start_time' => date('H:i',strtotime($generatorStartTime)),
				'generator_end_time' => date('H:i',strtotime($generatorEndTime)),
				'generator_usage_hours' => $hours,
				'filled_liter' => $filledLiter,
				'available_liter' => $availableLiter,
                'reading_type' => $readingType,
				'society_id' => $this->session->get('society_id'),
			);
			if(!empty($generatorReadingId)){
                $generatorReadingUpdateData = $this->generator_reading_model->getGeneratorReadingData(array(
                    'generator_reading_id' => $generatorReadingId,
                ));
                $generatorReadingUpdateArray = compareArray($generatorReadingArray,$generatorReadingUpdateData);
            }
			$generatorReadingData = $this->generator_reading_model->insertUpdateRecord($generatorReadingArray, 'generator_reading_id', 'tbl_generator_reading', 1,'',array(),array(),$generatorReadingUpdateArray);
			$lastGeneratorReadingId = $generatorReadingData['lastInsertedId'];
            $transactionStatus = $this->db->transComplete();
			if (isset($generatorReadingId) && $generatorReadingId != '') {
				if (($generatorReadingData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.update_record'), lang("GeneratorReading.generator_reading"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.update_record_error'), lang("GeneratorReading.generator_reading"));
				}
			} else {
				if (($generatorReadingData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.create_record'), lang("GeneratorReading.generator_reading"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.create_record_error'), lang("GeneratorReading.generator_reading"));
				}
			}
			echo json_encode($response);
			exit;
		}
	}

    public function delete()
    {
        $this->db->transStart();
        $generatorReadingId = $this->request->getVar('generator_reading_id');
        $generatorReadingData = $this->generator_reading_model->deleteRecord($generatorReadingId,$this->data['userId'],$this->session->get('society_id'));
        $transactionStatus = $this->db->transComplete();
        if (($generatorReadingData) && ($transactionStatus)) {
            $response['success'] = true;
            $response['msg'] = sprintf(lang('CommonMessage.delete_record'), lang("GeneratorReading.generator_reading"));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'), lang("GeneratorReading.generator_reading"));
        }
        echo json_encode($response);
        exit;
    }

    public function excelExportGeneratorReading()
    {
        $fileName ='generatorreading-' . DATETIMEFORMAT;
        $sheetName = 'genRead-' . DATEFORMAT;
        $excelHeaderName = 'Generator Reading';
        $tableData = $this->getGeneratorReadingListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            lang('GeneratorReading.Generator'),
            lang('GeneratorReading.generator_start_date'),
            lang('GeneratorReading.generator_start_time'),
            lang('GeneratorReading.generator_end_time'),
            lang('GeneratorReading.generator_usage_hours'),
            lang('GeneratorReading.filled_liter'),
            lang('GeneratorReading.available_liter'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                $row["excel_generator_name"],
                $row["generator_start_date"],
                $row["generator_start_time_display"],
                $row["generator_end_time_display"],
                $row["generator_usage_hours"],
                $row["filled_liter"],
                $row["available_liter"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'I';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }


    public function view($id = null)
    {
        $generatorReadingId = $this->request->getVar("view_id");
        if($generatorReadingId == "" && $generatorReadingId == null){
            return redirect()->to('Admin/GeneratorReading');
        }
        else {
            $filterData = array(
                "generator_reading_id" => $generatorReadingId
            );
            $data['generator_reading_data'] = $this->generator_reading_model->getGeneratorReadingData($filterData);
            
            $generatorReadingView = view("Admin/GeneratorReading/GeneratorReadingModelView", $data);
            $response['view_title'] = "Generator Reading Details";
            $response['view_detail'] = $generatorReadingView;
            $response['success'] = true;
            echo json_encode($response);
        }
    }

}
