<?php
namespace App\Controllers\Admin;

use App\Models\GateModel;
use CodeIgniter\Controller;
use App\Models\TowerModel;
use App\Models\SocietyModel;
class Gate extends BaseController
{
    protected $gate_model;
    public function __construct() {
        $this->gate_model = new GateModel;
        $this->tower_model = new TowerModel();
        $this->society_model = new SocietyModel();
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/moment/moment.js",
            "vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
        $data['title'] = 'Gate';
        return $this->dt_ci_template->load("Admin","Gate/GateView",$data);
    }

    public function getGateListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $this->datatables->table("tbl_gate as tg");
        $this->datatables->select("tg.gate_id,tg.gate_name,tg.gate_type,tg.society_id,tg.is_active,tg.is_delete,ts.society_name,
            tt.tower_name,tt.tower_id");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $this->datatables->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by,tg.created_at,tg.updated_at");
        $this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = tg.society_id","left");
        $this->datatables->join("tbl_tower as tt","tt.tower_id = tg.tower_id","left");
        $this->datatables->join("society_user_master_view as tupdate","tupdate.user_society_id = tg.updated_by","left");
        $this->datatables->join("society_user_master_view as tcreate","tcreate.user_society_id = tg.created_by","left");
        $this->datatables->groupBy("tg.gate_id");
        $this->datatables->where("tg.is_delete = 0");
        accessFilter($this->datatables, array("society" => "tg.society_id"));

        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "gate_id" => isset($displayData['gate_id']) ? $displayData['gate_id'] : ""
                );
                $data[$key]['action_button'] = gateActionButton($actionButtonFilter);
                $data[$key]['excel_tower_name'] = isset($displayData['tower_name']) ?  $displayData['tower_name'] : "";
                $data[$key]['gate_type'] = isset($displayData['gate_type']) ?  underscoreToUcWord($displayData['gate_type']) : "";
                $data[$key]['tower_name'] = isset($displayData['tower_name']) ?  towerDocumentToHtml($displayData['tower_name'],$displayData['tower_id']) : "";
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
                $data[$key]['created_at'] = isValidDate($displayData['created_at']) ? siteDateFormat($displayData['created_at'],true) : "";
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }

    public function manage($gateId = '')
    {

        $data['extra_js'] = array(
            "js/jquery.form.min.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/flatpickr/flatpickr.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
        );

        if ($gateId != '') {
            $filterData = array(
                "gate_id" => $gateId
            );
            $data['gate_data'] = $this->gate_model->getGateData($filterData);

            if ((isset($data['gate_data']['is_delete']) && $data['gate_data']['is_delete'] != 0)) {
                return redirect()->to('Admin/Gate');
            }

            if (empty($data['gate_data'])) {
                return redirect()->to('Admin/Gate');
            }
        }
        if ($gateId != '') {
            $data['title'] = 'Edit Gate';
        } else {
            $data['title'] = 'Add Gate';
        }
        if ((isset($data['gate_data']['society_id']) && $data['gate_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/Gate');
        }
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
        $this->dt_ci_template->load("Admin","Gate/GateManageView",$data);
    }

    public function save()
    {
        $this->db->transStart();
        $validation = \Config\Services::validation();

        $gateId = $this->request->getVar('gate_id');
        $gateName = $this->request->getVar('gate_name');
        $gateType = $this->request->getVar('gate_type');
        $towerId = $this->request->getVar('tower_id');
        $isActive = $this->request->getVar('is_active');

        $validation->setRule('gate_name', lang('Gate.gate_name'), 'required');
        $validation->setRule('gate_type', lang('Gate.gate_type'), 'required');

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

            $filterData = array(
                "gate_id" => $gateId,
                "gate_name" => $gateName,
                "tower_id" => $towerId,
                "gate_type" => $gateType,
                "society_id" => $this->session->get('society_id'),
                'gate_id_not' => $gateId,
                'is_delete' => 0,
                "is_multiple" => 1
            );
            $gateData = $this->gate_model->getGateData($filterData);
            // printArray($gateData,1);
            if(!empty($gateData)){
                $response['success'] = false;
                $response['msg'] = "Same Gate Can/t Be Both Type Inside And Outside";
                echo json_encode($response);
                die();
            }

            $gateUpdateArray = array();
            $gateArray = array(
                'gate_id' => $gateId,
                'gate_name' => $gateName,
                'gate_type' => $gateType,
                'tower_id' => $towerId,
                'society_id' => $this->session->get('society_id'),
                'is_active' => isset($isActive) ? 1 : 0,
            );

            if(!empty($gateId)){
                $gateUpdateData = $this->gate_model->getGateData(array(
                    'gate_id' => $gateId,
                ));
                $gateUpdateArray = compareArray($gateArray,$gateUpdateData);
            }

            
            $gateData = $this->gate_model->insertUpdateRecord($gateArray,'gate_id','tbl_gate', 1,'',array(),array(),$gateUpdateArray);
            $transactionStatus = $this->db->transComplete();
            if (isset($gateId) && $gateId != '') {
                if (($gateData['success']) && ($transactionStatus == 1)) {
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('Gate.gate'));
                } else {
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('Gate.gate'));
                }
            } else {
                if (($gateData['success']) && ($transactionStatus == 1)) {
                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('Gate.gate'));
                } else {
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('Gate.gate'));
                }
            }
            echo json_encode($response);
            exit();
        }
    }

    public function changeStatus()
    {
        $gateId = $this->request->getVar('gate_id');
        $status = $this->request->getVar('status');

        $return = $this->gate_model->statusChange($gateId,$status,'gate_id','tbl_gate');
        if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('Gate.gate'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('Gate.gate'));
        }
        echo json_encode($response);
        exit();
    }


    public function delete()
    {
        $this->db->transStart();
        $gateId = $this->request->getVar('gate_id');
        if( isReferenceInTable( 'gate_id','tbl_resource_guard', $gateId)
        ){
            if(!empty($gateId)){
                foreach($gateId as $gate){
                    $deleteDataArray['module'] = 'Gate';
                    $deleteDataArray['activity'] = "Tried to delete Gate ";
                    $deleteDataArray['module_id'] = $gate;
                    logActivity('Tried to delete Gate [GateID: ' . $gate . ']',$this->data['userId'],'Gate',$gate,json_encode($deleteDataArray),'','Gate',$gate);
                }
            }
            $response['success'] = false;
            $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
            echo json_encode($response);
            exit;
        }
        $gateData = $this->gate_model->deleteRecord($gateId);
        $transactionStatus = $this->db->transComplete();
        if (($gateData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Gate.gate'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang('Gate.gate'));
        }
        echo json_encode($response);
        exit;
    }

    public function getGateDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page            = $this->request->getVar('page');
        $gateId = $this->request->getVar('gate_id');
        $towerId = $this->request->getVar('tower_id');
        $societyId = $this->request->getVar('society_id');

        $filterData = array(
            'gate_id' => $gateId,
            'society_id' => $societyId,
            'tower_id' => $towerId,
            'is_active' => 1,
            'is_delete' => 0,
        );
        echo $this->gate_model->getGate($filterData);
    }

    // public function view($id = null)
    // {
    //     $flatId = $this->request->getVar("view_id");
    //     if($flatId == "" && $flatId == null){
    //         return redirect()->to('Admin/Gate');
    //     }
    //     else {
    //         $id = $flatId;
    //         $filterData = array(
    //             "flat_id" => $flatId
    //         );
    //         $data['flat_data'] = $this->gate_model->getGateData($filterData);
    //         $flatView = view("Admin/Gate/GateModelView", $data);
    //         $response['view_title'] = "Gate Details";
    //         $response['view_detail'] = $flatView;
    //         $response['success'] = true;
    //         echo json_encode($response);
    //     }
    // }

    public function excelExportGate()
    {
        $fileName ='gate-' . DATETIMEFORMAT;
        $sheetName = 'Gate-' . DATEFORMAT;
        $excelHeaderName = 'Gate';
        $tableData = $this->getGateListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            // lang('Gate.society'),
            lang('Gate.gate_name'),
            lang('Gate.gate_type'),
            lang('Gate.tower'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                // $row["society_name"],
                $row["gate_name"],
                $row["gate_type"],
                $row["excel_tower_name"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'E';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }

    // public function flatPdf()
    // {
    //     if(!$this->dt_ci_acl->checkAccess('Gate|pdf')){
    //         return show_error(NO_ACCESS_SECTION);
    //     } else {
    //         $societyData = $this->society_model->getSocietyData(array(
    //             "society_id" => $this->session->get('society_id'),
    //         ));
    //         $data['society_data'] = $societyData;
    //         $filterData = array(
    //             'is_multiple' => 1,
    //             'society_id' => $this->session->get('society_id'),
    //         );
    //         $flatData = $this->gate_model->getGateData($filterData);
    //         $towerIdArray = array();
    //         if(!empty($flatData)){
    //             foreach($flatData as $flatElement){
    //                 array_push($towerIdArray,$flatElement['tower_id']);
    //             }
    //         }
    //         if(!empty($towerIdArray)){
    //             $towerIdArray = array_unique($towerIdArray);
    //         }
           
    //         $data['flat_data'] = $flatData;

    //         $towerData = $this->tower_model->getTowerData(array(
    //             'tower_id' => $towerIdArray,
    //             'is_multiple' => 1
    //         ));
    //         $data['tower_data'] = $towerData;
    //         $towerWiseGateData = [];
    //         foreach ($towerData as $towerElement) {
    //             $towerId = $towerElement['tower_id'];
    //             $towerWiseGateData[] = [
    //                 'tower_name' => $towerElement['tower_name'],
    //                 'flats' => [],
    //             ];
    //             foreach ($flatData as $flatElement) {
    //                 if ($flatElement['tower_id'] === $towerId) {
    //                     $towerWiseGateData[count($towerWiseGateData) - 1]['flats'][] = [
    //                         'flat_id' => $flatElement['flat_id'],
    //                         'flat_no' => $flatElement['flat_no'],
    //                         'bhk' => $flatElement['bhk'],
    //                         'sqr_ft' => $flatElement['sqr_ft'],
    //                     ];
    //                 }
    //             }
    //         }
    //         $data['tower_wise_flat_data'] = $towerWiseGateData;
    //         $data['name'] = lang("Gate.flat_pdf") . ".pdf";
    //         $printHeader = '';
    //         $printFooter = '';
    //         $printFooter = pdfFooter( 0, array());
    //         $html = view('Admin/Gate/Pdf/GatePdfView', $data);
    //         generate_pdf($html, $data['name'], false, $printFooter, '', $printHeader, '', 'P');
    //     }
    // }
}
