<?php
namespace App\Controllers\Admin;

use App\Models\BannerModel;
use CodeIgniter\Controller;
// use App\Models\MaterialModel;
use App\Models\ForumModel;
use App\Models\VisitorModel;
use App\Models\CommonWebServiceModel;
use App\Models\OwnershipFlatModel;
use App\Models\ResourceTypeModel;

class Forum extends BaseController
{
    protected $forum_model;
    public function __construct() {
        // $this->material_model = new MaterialModel();
        $this->forum_model = new ForumModel();
        $this->visitor_model = new VisitorModel();
        $this->banner_model = new BannerModel();
        $this->common_web_service_model = new CommonWebServiceModel();
        $this->ownership_flat_model = new OwnershipFlatModel();
        $this->resource_type_model = new ResourceTypeModel();
        // checkAndCreatePath(THUMBNAIL_DOCUMENT_IMAGE_PATH);

    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/moment/moment.js",
            "vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
        $data['title'] = 'Forum';
        // $dataFilters['filters'] = array(
        //     array(
        //         "type" => "multi_select",
        //         "dynamic" => true,
        //         "class" => "commonAreaDd",
        //         "id" => "filter_common_area_id",
        //         "name" => "filter_common_area_id",
        //         "title" => "Forum.common_area",
        //     ),
        //     array(
        //         "type" => "multi_select",
        //         "dynamic" => true,
        //         "class" => "itemDd",
        //         "id" => "filter_item_id",
        //         "name" => "filter_item_id",
        //         "title" => "Forum.item",
        //     ),
        //     array(
        //         "type" => "multi_select",
        //         "dynamic" => true,
        //         "class" => "financialYearDd",
        //         "id" => "filter_financial_year_id",
        //         "name" => "filter_financial_year_id",
        //         "title" => "Forum.financial_year",
        //     ),
        //     array(
        //         "type" => "transaction_type",
        //         "id" => "filter_transaction_type",
        //         "name" => "filter_transaction_type",
        //         "title" => "Forum.transaction_type",
        //     ),
        // );
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Ajax)? $select2Ajax : array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
        return $this->dt_ci_template->load("Admin","Forum/ForumView",$data);
    }

    public function manage($forumId = '',$view = '')
	{
		$data['extra_js'] = array(
			"js/jquery.form.min.js",
			"vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
			"vendor/libs/flatpickr/flatpickr.js",
			"js/validate.min.js",
			"js/additional_methods.min.js",
		);

        if ($forumId != '') {
			$filterData = array(
				"forum_id" => $forumId
			);
			$data['forum_data'] = $this->forum_model->getForumData($filterData);

            if ((isset($data['forum_data']['is_deleted']) && $data['forum_data']['is_deleted'] != 0)) {
                return redirect()->to('Admin/Forum');
            }

			$data['image_data'] = $this->visitor_model->getDocumentImageData(array(
                "document_type_id" => $forumId,
                "document_type" => 'forum',
                "is_multiple" => 1
            ));

			if (empty($data['forum_data'])) {
                return redirect()->to('Admin/Forum');
            }
		}
		if ($forumId != '') {
			$data['title'] = 'Edit Forum';
		} else {
			$data['title'] = 'Add Forum';
		}
        $data['forum_data']['view'] = (isset($view) && $view != '' ? 1 : 0);
		$data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Condition) ? $select2Condition : array());
		if ((isset($data['forum_data']['society_id']) && $data['forum_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/Forum');
        }
		$this->dt_ci_template->load("Admin","Forum/ForumManageView",$data);
	}

    public function getForumListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }

        // $commonAreaId = $this->request->getVar("filter_common_area_id");
        // $financialYearId = $this->request->getVar("filter_financial_year_id");
        // $itemId = $this->request->getVar("filter_item_id");
        // $transactionType = $this->request->getVar("filter_transaction_type");

        $this->datatables->table("tbl_forum as tf");

        $this->datatables->select("tf.forum_id,tf.title,tf.description,tf.forum_date,tf.is_active");

        $this->datatables->select("(CASE WHEN tf.type = 'admin' THEN concat(COALESCE(tu.first_name,''),' ',COALESCE(tu.last_name,''))
                                    WHEN tf.type = 'member' THEN  COALESCE(tm.name, '') 
                                    END) as member_name,tf.type");


        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tf.updated_at");
        $this->datatables->select("(select count(*) from tbl_comment as tc where tc.type_id = tf.forum_id AND tc.type = 'forum' AND tc.is_deleted = 0 AND tc.parent_comment_id = 0) as total_comment");
       
        $this->datatables->join("tbl_ownership_flat_member as tofw","tofw.ownership_flat_member_id = tf.type_id AND tf.type = 'member'","left");
        $this->datatables->join(MASTER_DB.".tbl_member as tm","tm.member_id = tofw.member_id","left");
        $this->datatables->join("society_user_master_view as tupdate","tupdate.user_society_id = tf.updated_by","left");
        $this->datatables->join("society_user_master_view as tu","tu.user_society_id = tf.type_id AND tf.type = 'admin'","left");
        $this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = tf.society_id","left");

        $this->datatables->where("is_deleted = 0");
        
        // if(isset($commonAreaId)) {
        //     if(is_array($commonAreaId)){
        //         $this->datatables->whereIn("tf.common_area_id",$commonAreaId);
        //     } else {
        //         $this->datatables->where("tf.common_area_id",$commonAreaId);
        //     }
        // }
        // if(isset($itemId)) {
        //     if(is_array($itemId)){
        //         $this->datatables->whereIn("tf.item_id",$itemId);
        //     } else {
        //         $this->datatables->where("tf.item_id",$itemId);
        //     }
        // }
        // if(isset($financialYearId)) {
        //     if(is_array($financialYearId)){
        //         $this->datatables->whereIn("tf.item_id",$financialYearId);
        //     } else {
        //         $this->datatables->where("tf.item_id",$financialYearId);
        //     }
        // }
        // if(isset($transactionType)) {
        //     if(is_array($transactionType)){
        //         $this->datatables->whereIn("tf.transaction_type",$transactionType);
        //     } else {
        //         $this->datatables->where("tf.transaction_type",$transactionType);
        //     }
        // }

        $this->datatables->groupBy("tf.forum_id");
        accessFilter($this->datatables, array("society" => "tf.society_id"));
        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
					"forum_id" => isset($displayData['forum_id']) ? $displayData['forum_id'] : ""
				);
                $data[$key]['action_button'] = forumActionButton($actionButtonFilter);
                $data[$key]['forum_date'] = isValidDate($displayData['forum_date']) ? siteDateFormat($displayData['forum_date']) : '-';
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : '-';
                $data[$key]['type'] = underscoreToUcWord($displayData['type']);
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }

    public function changeStatus(){
        $forumId = $this->request->getVar('forum_id');
        $status = $this->request->getVar('status');
        $return = $this->forum_model->statusChange($forumId,$status,'forum_id','tbl_forum');
		if ($return == 1) {
			$response['success'] = true;
			$response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('Forum.forum'));
		} else {
			$response['success'] = false;
			$response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('Forum.forum'));
		}
		echo json_encode($response);
		exit;
    }

    public function save()
	{
		$this->db->transStart();
		$validation = \Config\Services::validation();
		$forumId = $this->request->getVar('forum_id');
		$title = $this->request->getVar('title');
		$forumDate = $this->request->getVar('forum_date');
		$description = $this->request->getVar('description');
		$isActive = $this->request->getVar('is_active');

		$validation->setRule('title', lang('Forum.title'), 'required');
		$validation->setRule('forum_date', lang('Forum.forum_date'), 'required');
		$validation->setRule('description', lang('Forum.description'), 'required');

		if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {
			$forumImage = array();
			if (isset($_FILES["forum_image"])) {
				$forumImagePath = DOCUMENT_IMAGE_PATH;
				$forumImage = $this->dt_ci_file_upload->UploadMultipleFile('forum_image', MAX_IMAGE_SIZE_LIMIT, $forumImagePath, true, true, array('jpeg', 'png', 'jpg', 'JPG'));
				if ($forumImage['success'] == false) {
					$response['success'] = false;
					$response['msg'] = strip_tags($forumImage['message']);
					echo json_encode($response);
					die();
				}
                else{
                    unset($forumImage['success']);
                    $thumbnailResult =  $this->dt_ci_file_upload->ThumbnailMultipleUploadFile($forumImage, DOCUMENT_IMAGE_PATH, THUMBNAIL_DOCUMENT_IMAGE_PATH);
                }
			}
			$forumUpdateArray = array();
			$forumArray = array(
				'forum_id' => $forumId,
				'title' => $title,
				'forum_date' => DMYToYMD($forumDate),
				'description' => $description,
				'society_id' => $this->session->get('society_id'),
				'is_active' => isset($isActive) ? 1 : 0,
                'type_id' => $this->data['userId'],
                'type' => 'admin',
			);
			if(!empty($forumId)){
                $forumUpdateData = $this->forum_model->getForumData(array(
                    'forum_id' => $forumId,
                ));
                $forumUpdateArray = compareArray($forumArray,$forumUpdateData);
            }
			$forumData = $this->forum_model->insertUpdateRecord($forumArray, 'forum_id', 'tbl_forum', 1,'',array(),array(),$forumUpdateArray);
			$lastForumId = $forumData['lastInsertedId'];

            // $this->banner_model->deleteDocumentImageRecord(array('document_type' => 'forum','document_type_id' => $forumId));

			if($lastForumId != ''){
                if(isset($forumImage) && count($forumImage) > 0){
                    $batchArray = array();
                    unset($forumImage['success']);
                    foreach ($forumImage as $key => $imageData) {
                        $dataArray = array(
                            'document_image_id' =>   '',
                            'document_type' =>   'forum',
                            'document_type_id' => $lastForumId,
                            'document_image' => isset($imageData['file_name']) ? $imageData['file_name'] : "",
                            'created_by' => $this->data['userId'],
                            'updated_by' => $this->data['userId'],
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                        array_push($batchArray, $dataArray);
                    }
                    $forumImageExtraDataArray = array();
                    $forumImageExtraDataArray['module_id'] = $lastForumId;
                    $forumImageExtraDataArray['module'] = 'Forum Image';
                    $forumImageExtraDataArray['type'] = 'Forum';
                    $forumImageExtraDataArray['old_data'] = array();
                    $forumImageExtraDataArray['user_id'] = $this->data['userId'];
                    $forumImageExtraDataArray['society_id'] = $this->session->get('society_id');
                    $this->forum_model->batchInsert($batchArray, 'tbl_document_image',$forumImageExtraDataArray);
                }
			}
            $transactionStatus = $this->db->transComplete();
			if (isset($forumId) && $forumId != '') {
				if (($forumData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.update_record'), lang("Forum.forum"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.update_record_error'), lang("Forum.forum"));
				}
			} else {
				if (($forumData['success']) && ($transactionStatus == 1)) {


                    $userSocietyIdArray = array();
                    $memberIdArray = array();
                    $customerData = array();
                    $batchNotificationDataArray = array();
                    $sendNotificationDataArray = array();
                    $notificationArray = array(
                        'notification_title' => 'New Forum Published',
                        'description' => 'A new Forum titled '.$title.' has been published. Please check the app to read the full details.',
                    );
                    $deviceIdArray = array();
                    $iosDeviceIdArray = array();
                    $customerData['title_name'] = isset($notificationArray['notification_title']) ? $notificationArray['notification_title'] : "";
                    $customerData['description'] = isset($notificationArray['description']) ? $notificationArray['description'] : "";
                    $resourceTypeData = $this->resource_type_model->getResourceTypeData(array(
                        'resource_type_name' => RESOURCE_TYPE_MEMBER,
                        'society_id' => $this->session->get('society_id'),
                    ));
                    $ownershipFlatMemberData = $this->ownership_flat_model->getOwnershipFlatMemberData(array(
                        'society_id' => $this->session->get('society_id'),
                        'is_active' => 1,
                        'is_multiple' => 1
                    ));
                    if(!empty($ownershipFlatMemberData)){
                        foreach ($ownershipFlatMemberData as $ownershipFlatMember) {
                            $memberIdArray[] = $ownershipFlatMember['member_id'];
                        }
                    }
                    if(!empty($memberIdArray)){
                        $userSocietyData = $this->common_web_service_model->getUserSocietyData(array(
                            "type_id" => $memberIdArray,
                            "resource_type_id" => $resourceTypeData['resource_type_id'],
                            'society_id' => $this->session->get('society_id'),
                            'is_multiple' => 1
                        ));
                        if(!empty($userSocietyData)){
                            foreach ($userSocietyData as $userElement) {
                                $userSocietyIdArray[] = $userElement['user_society_id'];
                            }
                        }

                        if(!empty($userSocietyIdArray)){
                            $userDeviceArray = $this->common_web_service_model->deviceData(array(
                                "user_society_id" => $userSocietyIdArray,
                                'user_type' => MEMBER_APP,
                                "is_latest" => 1,
                                "is_multiple" => 1,
                            ));
                        }
                        if(!empty($userDeviceArray)){
                            foreach($userDeviceArray as $userDevice){
                                $notificationOtherArray = array(
                                    'notification_id' => '',
                                    'society_id' => $this->session->get('society_id'),
                                    'notification_date' => TODAY_DATE_YMD,
                                    'notification_for' => (isset($userDevice['device_type'])) ? strtolower($userDevice['device_type']) : "",
                                    'type' => 'forum',
                                    'type_id' => $lastForumId,
                                    // 'module' => 'poll',
                                    'created_by' => $this->data['userId'],
                                    'updated_by' => $this->data['userId'],
                                    'created_at' => date("Y-m-d H:i:s"),
                                    'updated_at' => date("Y-m-d H:i:s"),
                                );
                                $notificationOtherArray['send_for_notification'] = 'manager';
                                $notificationOtherArray['send_for_notification_id'] = $this->data['userId'];
                                $notificationOtherArray['receive_for_notification'] = $userDevice['user_type'];
                                $notificationOtherArray['receive_for_notification_id'] = $userDevice['user_type_id'];
                                if(!empty($notificationArray)){
                                    $notificationArray = array_merge($notificationArray,$notificationOtherArray);
                                    $extraDataJsonArray = $notificationArray;
                                    $extraDataJsonArray['module'] = 'forum';
                                    $extraDatajson = json_encode($extraDataJsonArray);
                                    $notificationArray['extra_data'] = $extraDatajson;
                                    $customerData['extra_data'] = $extraDatajson;
                                    //send notification data
                                    $deviceToken = $userDevice['one_signal_id'];
                                    $deviceId = $userDevice['device_id'];
                                    $batchNotificationDataArray[] = $notificationArray;
                                    // if(strtolower($userDevice['device_type']) == 'android'){
                                    //     if (!empty($deviceId)) {
                                    //         array_push($deviceIdArray,$deviceId);
                                    //     }
                                    // } else {
                                    //     if (!empty($deviceId)) {
                                    //         array_push($iosDeviceIdArray,$deviceId);
                                    //     }
                                    // }

                                    $sendNotificationDataArray[] = array(
                                        'notification_title' => 'New Forum Published',
                                        'description' => 'A new Forum titled '.$title.' has been published. Please check the app to read the full details.',
                                        'extra_data_json' => $extraDatajson,
                                        'app_url' => MEMBER_URL .'forum_detail/' . $lastForumId,
                                        'notification_for' => (isset($userDevice['device_type'])) ? strtolower($userDevice['device_type']) : "",
                                        'device_id' => $userDevice['device_id'],
                                        'type' => 'forum',
                                    );
                                }
                            }
                        }
                        if(!empty($batchNotificationDataArray)){
                            $this->ownership_flat_model->batchInsert($batchNotificationDataArray,'tbl_notification');
                        }
                        if(!empty($sendNotificationDataArray)){
                            sendNotification($sendNotificationDataArray);
                        }
                        // $sendNotificationData = array();
                        // if(!empty($deviceIdArray)){
                        //     $customerData['device_id'] = $deviceIdArray;
                        //     $customerData['app_url'] = MEMBER_URL .'forum_detail/' . $lastForumId;
                        //     $sendNotificationData = $customerData;
                        //     sendNotificationAndroid($sendNotificationData);
                        // }
                        // $sendNotificationIOSData = array();
                        // if(!empty($iosDeviceIdArray)){
                        //     $customerData['device_id'] = $iosDeviceIdArray;
                        //     $sendNotificationIOSData = $customerData;
                        //     sendNotificationIOS($sendNotificationIOSData);
                        // }
                    }
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.create_record'), lang("Forum.forum"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.create_record_error'), lang("Forum.forum"));
				}
			}
			echo json_encode($response);
			exit;
		}
	}

    public function delete()
    {
        $this->db->transStart();
		$forumId = $this->request->getVar('forum_id');
        $userId = $this->data['userId'];

		$imageData = $this->visitor_model->getDocumentImageData(array(
			"document_type_id" => $forumId,
			"document_type" => 'forum',
			"is_multiple" =>1,
		));
		if(is_array($imageData) && !empty($imageData)){
			foreach ($imageData as $image){
				$FileUrl = '';
				if(isset($image['document_image']) && $image['document_image'] != '') {
					$FileUrl = DOCUMENT_IMAGE_PATH . $image['document_image'];
				}
				if (file_exists($FileUrl)) {
					unlink($FileUrl);
				}
                $thumbnailFileUrl = '';
                if(isset($image['document_image']) && $image['document_image'] != '') {
                    $thumbnailFileUrl = THUMBNAIL_DOCUMENT_IMAGE_PATH . $image['document_image'];
                }
                if (file_exists($thumbnailFileUrl)) {
                    unlink($thumbnailFileUrl);
                }
			}
		}

        if( isReferenceInTable( 'type_id','tbl_comment', $forumId)){
            if(!empty($forumId)){
                foreach($forumId as $forum){
                    $deleteDataArray['module'] = 'Forum';
                    $deleteDataArray['activity'] = "Forum Deleted";
                    $deleteDataArray['module_id'] = $forum;
                    logActivity('Forum Deleted [ForumID: ' . $forum . ']',$this->data['userId'],'Forum',$forum,json_encode($deleteDataArray),'','Forum',$forum);
                }
            }
            $response['success'] = false;
            $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
            echo json_encode($response);
            exit;
        }

		$imageData = $this->banner_model->deleteDocumentImageRecord(array('document_type' => 'forum','document_type_id' => $forumId));
        $this->forum_model->deleteForumCommentRecord(array('type' => 'forum','type_id' => $forumId));
		$forumData = $this->forum_model->deleteRecord($forumId,$userId);
        $transactionStatus = $this->db->transComplete();
        if (($forumData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg'] = sprintf(lang('CommonMessage.delete_record'), lang("Forum.forum"));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'), lang("Forum.forum"));
        }
        echo json_encode($response);
        exit;
    }

    public function deleteForumImage()
    {
        $this->db->transStart();
        $documentImageId = $this->request->getVar('document_image_id');
        $documentTypeId = $this->request->getVar('document_type_id');
        $documentType = $this->request->getVar('document_type');
        $imageData = $this->visitor_model->getDocumentImageData(array(
            "document_image_id" => $documentImageId,
            "is_multiple" => 1
        ));
        if(is_array($imageData) && !empty($imageData)){
            foreach ($imageData as $image){
                $FileUrl = '';
                if(isset($image['document_image']) && $image['document_image'] != '') {
                    $FileUrl = DOCUMENT_IMAGE_PATH . $image['document_image'];
                }
                if (file_exists($FileUrl)) {
                    unlink($FileUrl);
                } 

                $thumbnailFileUrl = '';
                if(isset($image['document_image']) && $image['document_image'] != '') {
                    $thumbnailFileUrl = THUMBNAIL_DOCUMENT_IMAGE_PATH . $image['document_image'];
                }
                if (file_exists($thumbnailFileUrl)) {
                    unlink($thumbnailFileUrl);
                }
            }
        }
        //delete setting location
        $imageData = $this->visitor_model->deleteDocumentImage($documentImageId,"forum");      
        if ($imageData) {
			$ids = is_array($documentImageId) ? implode(',',$documentImageId) : $documentImageId;
			$deleteDataArray['module'] = 'Forum Image';
			$deleteDataArray['activity'] = "Forum Image Deleted";
			$deleteDataArray['module_id'] = $documentImageId;
			logActivity('Forum Image Deleted [ForumImageID: ' . $ids . ']',$this->data['userId'],'Forum Image',$ids,json_encode($deleteDataArray),'','Forum',$documentTypeId);
            $transactionStatus = $this->db->transComplete();
            if($transactionStatus == 1){
                $response['success'] = true;
                $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Forum.forum_image'));
            }
            else{
                $response['success'] = false;
                $response['msg']     = sprintf(lang('CommonMessage.delete_error'),lang('Forum.forum_image'));
            }
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('Forum.forum_image'));
        }
        echo json_encode($response);
        exit();
    }

    public function excelExportForum()
    {
        $fileName ='forum-' . DATETIMEFORMAT;
        $sheetName = 'Forum-' . DATEFORMAT;
        $excelHeaderName = 'Forum';
        $tableData = $this->getForumListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            lang('Forum.title'),
            lang('Forum.description'),
            lang('Forum.member_name'),
            lang('Forum.forum_date'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                $row["title"],
                $row["description"],
                $row["member_name"],
                $row["forum_date"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'F';

        // printArray($dataRows,1);
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }

    public function view($id = null)
    {
        $forumId = $this->request->getVar("view_id");
        if($forumId == "" && $forumId == null){
            return redirect()->to('Admin/Forum');
        }
        else {
            $id = $forumId;
            $filterData = array(
                "forum_id" => $forumId
            );
            $data['forum_data'] = $this->forum_model->getForumData($filterData);
            if (empty($data['forum_data'])) {
                return redirect()->to('Admin/Forum');
            }

            $data['image_data'] = $this->visitor_model->getDocumentImageData(array(
                "document_type_id" => $forumId,
                "document_type" => 'forum',
                "is_multiple" => 1
            ));
            // printArray($data['image_data'],1);

            $forumView = view("Admin/Forum/ForumModelView", $data);
            $response['view_title'] = "Forum Details";
            $response['view_detail'] = $forumView;
            $response['success'] = true;
            echo json_encode($response);
        }
    }

    public function getForumDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page            = $this->request->getVar('page');
        $forumId = $this->request->getVar('forum_id');
        $societyId = $this->request->getVar('society_id');

        $filterData = array(
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT,
            'is_active' => 1,
            'forum_id' => $forumId,
            'society_id' => $this->session->get('society_id'),
        );
        echo $this->forum_model->getForum($filterData);
    }
}