<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\FlatModel;
use App\Models\TowerModel;
use App\Models\SocietyModel;
class Flat extends BaseController
{
    protected $flat_model;
    public function __construct() {
        $this->flat_model = new FlatModel();
        $this->tower_model = new TowerModel();
        $this->society_model = new SocietyModel();
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );

        $data['flat_summary'] = $this->flat_model->getTotalFlatDetails();


        $data['title'] = 'Flat';
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Ajax)? $select2Ajax : array());
        // $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
        return $this->dt_ci_template->load("Admin","Flat/FlatView",$data);
    }

    public function getFlatListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $this->datatables->table("tbl_flat as tf");
        $this->datatables->select("tf.flat_id,tf.flat_no,tf.sqr_ft,tf.society_id,tf.is_active,ts.society_name,tf.bhk,
            tt.tower_name,tt.tower_id,tf.carpet_area");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tf.updated_at");
        $this->datatables->select("COALESCE(ttu.unit_group,'') as floor");
        $this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = tf.society_id","left");
        $this->datatables->join("tbl_tower as tt","tt.tower_id = tf.tower_id","left");
        $this->datatables->join("tbl_tower_unit as ttu","ttu.tower_unit_id = tf.floor_id","left");
        $this->datatables->join("society_user_master_view as tupdate","tupdate.user_society_id = tf.updated_by","left");
        $this->datatables->groupBy("tf.flat_id");
        accessFilter($this->datatables, array("society" => "tf.society_id"));

        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "flat_id" => isset($displayData['flat_id']) ? $displayData['flat_id'] : ""
                );
                $data[$key]['action_button'] = flatActionButton($actionButtonFilter);
                $data[$key]['excel_tower_name'] = isset($displayData['tower_name']) ?  $displayData['tower_name'] : "";
                $data[$key]['tower_name'] = isset($displayData['tower_name']) ?  towerDocumentToHtml($displayData['tower_name'],$displayData['tower_id']) : "";
                $data[$key]['sqr_ft'] = roundNumber($data[$key]['sqr_ft']);
                $data[$key]['bhk'] = roundNumber($data[$key]['bhk']);
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }

    public function manage($flatId = '')
    {

        $data['extra_js'] = array(
            "js/jquery.form.min.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/bootstrap-datepicker/bootstrap-datepicker.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
        );

        if ($flatId != '') {
            $filterData = array(
                "flat_id" => $flatId
            );
            $data['flat_data'] = $this->flat_model->getFlatData($filterData);

            if (empty($data['flat_data'])) {
                return redirect()->to('Admin/Flat');
            }
        }
        if ($flatId != '') {
            $data['title'] = 'Edit Flat';
        } else {
            $data['title'] = 'Add Flat';
        }
        if ((isset($data['flat_data']['society_id']) && $data['flat_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/Flat');
        }
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Ajax)? $select2Ajax : array());
        $this->dt_ci_template->load("Admin","Flat/FlatManageView",$data);
    }
    public function save()
    {
        $this->db->transStart();
        $validation = \Config\Services::validation();

        $flatId = $this->request->getVar('flat_id');
        $flatNo = $this->request->getVar('flat_no');
        $sqrFt = $this->request->getVar('sqr_ft');
        $bhk = $this->request->getVar('bhk');
        $carpetArea = $this->request->getVar('carpet_area');
        // $floor = $this->request->getVar('floor');
        $towerId = $this->request->getVar('tower_id');
        $floorId = $this->request->getVar('floor_id');
        $isActive = $this->request->getVar('is_active');

        if (isset($flatId) && $flatId == '') {
            $validation->setRule('flat_no', lang('Flat.flat_no'), 'required|combination_unique_tower[tbl_flat.flat_no.'.$towerId.'.]',array('combination_unique_tower' => 'This {field} Already Exists'));
        } else {
            $validation->setRule('flat_no', lang('Flat.flat_no'), 'required|edit_unique_tower[tbl_flat.flat_no.' . $flatId . '.'. $towerId.']',array('edit_unique_tower' => 'This {field} Already Exists'));
        }
       $validation->setRule('sqr_ft', lang('Flat.sqr_ft'), 'required');
       $validation->setRule('bhk', lang('Flat.bhk'), 'required');
       $validation->setRule('tower_id', lang('Flat.tower'), 'required');
       $validation->setRule('carpet_area', lang('Flat.carpet_area'), 'required');
    //    $validation->setRule('floor', lang('Flat.floor'), 'required');

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {
            $flatUpdateArray = array();
            $flatArray = array(
                'flat_id' => $flatId,
                'flat_no' => $flatNo,
                'sqr_ft' => roundNumber($sqrFt),
                'bhk' => roundNumber($bhk),
                'tower_id' => $towerId,
                'floor_id' => $floorId,
                'carpet_area' => $carpetArea,
                // 'floor' => $floor,
                'society_id' => $this->session->get('society_id'),
                'is_active' => isset($isActive) ? 1 : 0,
            );

            if(!empty($flatId)){
                $flatUpdateData = $this->flat_model->getFlatData(array(
                    'flat_id' => $flatId,
                ));
                $flatUpdateArray = compareArray($flatArray,$flatUpdateData);
            }

            $flatData = $this->flat_model->insertUpdateRecord($flatArray,'flat_id','tbl_flat', 1,'',array(),array(),$flatUpdateArray);

            if(empty($flatId)){
                $towerUnitData = $this->tower_model->getTowerUnitData(array(
                    'tower_unit_id' => $floorId,
                ));
                if(!empty($towerUnitData)){
                    $unit = $towerUnitData['unit'];
                    $towerUnitArray = array(
                        'tower_unit_id' => $floorId,
                        'unit' => $unit + 1,
                    );

                    $this->flat_model->insertUpdateRecord($towerUnitArray,'tower_unit_id','tbl_tower_unit', 1,'',array(),array(),array());
                }
            }
            $transactionStatus = $this->db->transComplete();
            if (isset($flatId) && $flatId != '') {
                if (($flatData['success']) && ($transactionStatus == 1)) {
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('Flat.flat'));
                } else {
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('Flat.flat'));
                }
            } else {
                if (($flatData['success']) && ($transactionStatus == 1)) {
                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('Flat.flat'));
                } else {
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('Flat.flat'));
                }
            }
            echo json_encode($response);
            exit();
        }

    }

    public function changeStatus()
    {
        $flatId = $this->request->getVar('flat_id');
        $status = $this->request->getVar('status');

        $return = $this->flat_model->statusChange($flatId,$status,'flat_id','tbl_flat');
        if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('Flat.flat'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('Flat.flat'));
        }
        echo json_encode($response);
        exit();
    }


    public function delete()
    {
        $this->db->transStart();
        $flatId = $this->request->getVar('flat_id');
        if( isReferenceInTable( 'flat_id','tbl_booking', $flatId) ||
            isReferenceInTable( 'flat_id','tbl_complain', $flatId) ||
            isReferenceInTable( 'flat_id','tbl_intercom', $flatId) ||
            isReferenceInTable( 'flat_id','tbl_management_committee', $flatId) ||
            isReferenceInTable( 'flat_id','tbl_notice_flat', $flatId) ||
            isReferenceInTable( 'flat_id','tbl_tag_assign', $flatId) ||
            isReferenceInTable( 'flat_id','tbl_resource_flat', $flatId) ||
            isReferenceInTable( 'flat_id','tbl_ownership_flat', $flatId) ||
            isReferenceInTable( 'flat_id','tbl_parking_slot', $flatId) ||
            isReferenceInTable( 'flat_id','tbl_tag_assign', $flatId) ||
            isReferenceInTable( 'flat_id','tbl_rentals', $flatId)
        ){
            if(!empty($flatId)){
                foreach($flatId as $flat){
                    $deleteDataArray['module'] = 'Flat';
                    $deleteDataArray['activity'] = "Tried to delete Flat ";
                    $deleteDataArray['module_id'] = $flat;
                    logActivity('Tried to delete Flat [FlatID: ' . $flat . ']',$this->data['userId'],'Flat',$flat,json_encode($deleteDataArray),'','Flat',$flat);
                }
            }
            $response['success'] = false;
            $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
            echo json_encode($response);
            exit;
        }
        $flatInsertData = $this->flat_model->getFlatData(array(
            'flat_id' => $flatId,
            'is_multiple' => 1,
        ));
       
        if(!empty($flatInsertData)){
            $towerUnitArray = array();
            $floorUnitCount = array();
            foreach ($flatInsertData as $displayData) {
                $floorId = $displayData['floor_id'];
                if (!isset($floorUnitCount[$floorId])) {
                    $floorUnitCount[$floorId] = 0;
                }
                $floorUnitCount[$floorId]++;
            }
            foreach ($floorUnitCount as $floorId => $count) {
                $towerUnitArray[] = array(
                    'tower_unit_id' => $floorId,
                    'unit' => ($displayData['unit'] - $count)
                );
            }
            if(!empty($towerUnitArray)){
                $this->flat_model->batchUpdate($towerUnitArray,'tower_unit_id','tbl_tower_unit',array());
            }
        }
        $flatData  = $this->flat_model->deleteRecord($flatId);
        $transactionStatus = $this->db->transComplete();
        if (($flatData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Flat.flat'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang('Flat.flat'));
        }
        echo json_encode($response);
        exit;
    }

    public function getFlatDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page            = $this->request->getVar('page');
        $flatId = $this->request->getVar('flat_id');
        $isTowerFlat = $this->request->getVar('is_tower_flat');
        $societyId = $this->request->getVar('society_id');
        $towerId = $this->request->getVar('tower_id');
        $ownershipFlatId = $this->request->getVar('ownership_flat_id');
        $isOwnershipFlat = $this->request->getVar('is_ownership_flat');

        $intercomId = $this->request->getVar('intercom_id');
        $isIntercomFlat = $this->request->getVar('is_intercom_flat');

        $rentalId = $this->request->getVar('rental_id');
        $isRentalFlat = $this->request->getVar('is_rental_flat');

        $filterData = array(
            'flat_id' => $flatId,
            'society_id' => $societyId,
            'tower_id' => $towerId,
            'is_tower_flat' => $isTowerFlat,
            'is_ownership_flat' =>  $isOwnershipFlat,
            'ownership_flat_id' =>  $ownershipFlatId,

            'is_intercom_flat' =>  $isIntercomFlat,
            'intercom_id' =>  $intercomId,

            'is_rental_flat' =>  $isRentalFlat,
            'rental_id' =>  $rentalId,
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT,
            'is_active' => 1,

        );
        echo $this->flat_model->getFlat($filterData);
    }

    public function view($id = null)
    {
        $flatId = $this->request->getVar("view_id");
        if($flatId == "" && $flatId == null){
            return redirect()->to('Admin/Flat');
        }
        else {
            $id = $flatId;
            $filterData = array(
                "flat_id" => $flatId
            );
            $data['flat_data'] = $this->flat_model->getFlatData($filterData);
            $flatView = view("Admin/Flat/FlatModelView", $data);
            $response['view_title'] = "Flat Details";
            $response['view_detail'] = $flatView;
            $response['success'] = true;
            echo json_encode($response);
        }
    }

    public function excelExportFlat()
    {
        $fileName ='flat-' . DATETIMEFORMAT;
        $sheetName = 'Flat-' . DATEFORMAT;
        $excelHeaderName = 'Flat';
        $tableData = $this->getFlatListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            // lang('Flat.society'),
            lang('Flat.flat_no'),
            lang('Flat.bhk'),
            lang('Flat.sqr_ft'),
            lang('Flat.carpet_area'),
            // lang('Flat.floor'),
            lang('Flat.tower'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                // $row["society_name"],
                $row["flat_no"],
                $row["bhk"],
                $row["sqr_ft"],
                $row["carpet_area"],
                // $row["floor"],
                $row["excel_tower_name"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'G';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }

    public function flatPdf()
    {
        if(!$this->dt_ci_acl->checkAccess('Flat|pdf')){
            return show_error(NO_ACCESS_SECTION);
        } else {
            $societyData = $this->society_model->getSocietyData(array(
                "society_id" => $this->session->get('society_id'),
            ));
            $data['society_data'] = $societyData;
            $filterData = array(
                'is_multiple' => 1,
                'society_id' => $this->session->get('society_id'),
            );
            $flatData = $this->flat_model->getFlatData($filterData);
            $towerIdArray = array();
            if(!empty($flatData)){
                foreach($flatData as $flatElement){
                    array_push($towerIdArray,$flatElement['tower_id']);
                }
            }
            if(!empty($towerIdArray)){
                $towerIdArray = array_unique($towerIdArray);
            }
           
            $data['flat_data'] = $flatData;

            $towerData = $this->tower_model->getTowerData(array(
                'tower_id' => $towerIdArray,
                'is_multiple' => 1
            ));
            $data['tower_data'] = $towerData;
            $towerWiseFlatData = [];
            foreach ($towerData as $towerElement) {
                $towerId = $towerElement['tower_id'];
                $towerWiseFlatData[] = [
                    'tower_name' => $towerElement['tower_name'],
                    'flats' => [],
                ];
                foreach ($flatData as $flatElement) {
                    if ($flatElement['tower_id'] === $towerId) {
                        $towerWiseFlatData[count($towerWiseFlatData) - 1]['flats'][] = [
                            'flat_id' => $flatElement['flat_id'],
                            'flat_no' => $flatElement['flat_no'],
                            'bhk' => $flatElement['bhk'],
                            'sqr_ft' => $flatElement['sqr_ft'],
                        ];
                    }
                }
            }
            $data['tower_wise_flat_data'] = $towerWiseFlatData;
            $data['name'] = lang("Flat.flat_pdf") . ".pdf";
            $printHeader = '';
            $printFooter = '';
            $printFooter = pdfFooter( 0, array());
            $html = view('Admin/Flat/Pdf/FlatPdfView', $data);
            generate_pdf($html, $data['name'], false, $printFooter, '', $printHeader, '', 'P');
        }
    }
}
