<?php
namespace App\Controllers\Admin;
use App\Models\CommonWebServiceModel;
use CodeIgniter\Controller;
use App\Models\EventModel;
use App\Models\DocumentModel;
class Event extends BaseController
{
    protected $event_model;
    public function __construct() {
        $this->event_model = new EventModel();
    }
	public function index()
	{
		$data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
			"vendor/libs/moment/moment.js",
			"vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
		$data['title'] = 'Event';
		// $dataFilters['filters'] = array(
		// 	array(
		// 		"type" => "event_type",
		// 		"id" => "event_type",
		// 		"name" => "event_type",
		// 		"title" => "Event.event_type",
		// 	),
		// 	array(
		// 		"type" => "gender",
		// 		"id" => "gender",
		// 		"name" => "gender",
		// 		"title" => "Event.gender",
		// 	),
		// 	array(
		// 		"type" => "daterange",
		// 		"id" => "filter_date_of_birth",
		// 		"name" => "filter_date_of_birth",
		// 		"title" => "Event.date_of_birth",
		// 	),
		// 	array(
		// 		"type" => "daterange",
		// 		"id" => "filter_created_at",
		// 		"name" => "filter_created_at",
		// 		"title" => "CommonMessage.common_created_at",
		// 	),
		// 	array(
		// 		"type" => "daterange",
		// 		"id" => "filter_updated_at",
		// 		"name" => "filter_updated_at",
		// 		"title" => "CommonMessage.common_updated_at",
		// 	),
		// );
		$data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
        // $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
		$this->dt_ci_template->load("Admin","Event/EventView",$data);
	}

	public function manage($eventId = '', $view = '')
	{
		$data['extra_js'] = array(
            "js/jquery.form.min.js",
			"vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
			"vendor/libs/flatpickr/flatpickr.js",
			"js/validate.min.js",
			"js/additional_methods.min.js",
			"vendor/libs/ckeditor/ckeditor_classic.js",
			"vendor/libs/jquery-timepicker/jquery-timepicker.js",
        );

        if ($eventId != '') {
			$filterData = array(
				"event_id" => $eventId
			);
			$data['event_data'] = $this->event_model->getEventData($filterData);
			// printArray($data['event_data'],1);
			if (empty($data['event_data'])) {
                return redirect()->to('Admin/Event');
            }

			if(isReferenceInTable( 'event_id','tbl_event_booking', $eventId)){
				$data['event_is_booked'] = 1;
			}else {
				$data['event_is_booked'] = 0;
			}

			$eventCategoryData = $this->event_model->getEventCategoryData(array(
				'event_id' => $eventId,
				'is_multiple' => 1
			));
			$data['event_category_data'] = $eventCategoryData;

			$data['event_rate_data'] = $this->event_model->getEventRateData(array(
				"event_id" => $eventId,
				"is_multiple" => 1
			));

			$data['image_data'] = $this->event_model->getEventImageData(array(
                "event_id" => $eventId,
                "is_multiple" => 1
           	));

		}

		if ($eventId != '') {
			$data['title'] = 'Edit Event';
		} else {
			$data['title'] = 'Add Event';
		}

		$data['event_data']['view'] = (isset($view) && $view != '' ? 1 : 0);

		if (((isset($data['event_data']['form_submit']) && $data['event_data']['form_submit'] == 'approved') && $data['event_data']['view'] != 1)) {
            return redirect()->to('Admin/Event');
        }
		
		$data['event_rate_table'] = view('Admin/Event/EventRateTableView', isset($data) ? $data : array());
		$data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
		if ((isset($data['event_data']['society_id']) && $data['event_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/Event');
        }
		$this->dt_ci_template->load("Admin","Event/EventManageView",$data);
	}

    public function getEventListing($return = false,$filterData=array())
    {
    	if($return == TRUE){
			$filterData['length'] = '';
			$_POST = $filterData;
		}

        $this->datatables->table("tbl_event as te");
		$this->datatables->select("te.event_id, te.event_name,tsoc.society_name,te.start_date,te.end_date,te.description,tca.common_area_name,te.terms_and_condition,te.form_submit");
		$this->datatables->select("GROUP_CONCAT(distinct(COALESCE(tc.category_name,'')) SEPARATOR ', ') as category");
		$this->datatables->select("te.is_booking_required,te.is_guest_allowed,te.is_cash_payment_allowed,te.is_cancellation_allowed,te.before_minutes,te.rate_type,te.booking_type,te.max_guest_allowed");
		$this->datatables->select("te.is_active,concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,te.updated_at");
		$this->datatables->join(MASTER_DB.".tbl_society as tsoc","tsoc.society_id = te.society_id","left");
		$this->datatables->join("tbl_common_area as tca","tca.common_area_id = te.common_area_id","left");
		$this->datatables->join("society_user_master_view as tupdate","tupdate.user_society_id = te.updated_by","left");
        $this->datatables->join("tbl_event_category as tec","tec.event_id = te.event_id","left");
        $this->datatables->join("tbl_category as tc","tc.category_id = tec.category_id","left");

		$this->datatables->groupBy("te.event_id");
		accessFilter($this->datatables, array("society" => "te.society_id"));
		$dataReport =  $this->datatables->generate();
		$dataReport = json_decode($dataReport, true);
		$data       = $dataReport['data'];
		if(count($data) > 0){
			foreach($data as $key => $displayData){
				$actionButtonFilter = array(
					"event_id" => isset($data[$key]['event_id']) ? $data[$key]['event_id'] : "",
					"form_submit" => isset($displayData['form_submit']) ? $displayData['form_submit'] : "",
				);
				$data[$key]['action_button'] = eventActionButton($actionButtonFilter);

				$approvedButtonFilter = array(
                    "button_id" => isset($displayData['event_id']) ? $displayData['event_id'] : "",
                    "form_submit" => isset($displayData['form_submit']) ? $displayData['form_submit'] : "",
                    "permission_label" => 'Event',
                    "permission_name" => $this->dt_ci_acl->checkAccess("Event|submitForm"),
                    "unapproved_permission_name" => $this->dt_ci_acl->checkAccess("Event|unapprove"),
                    "view_unapproved_button" => 0,
                    "approved_module" => "event",

                );
                $data[$key]['approved_button'] = approvedButton($approvedButtonFilter);
				$data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
				$data[$key]['start_date'] = isValidDate($displayData['start_date']) ? siteDateFormat($displayData['start_date'],true) : "";
				$data[$key]['end_date'] = isValidDate($displayData['end_date']) ? siteDateFormat($displayData['end_date'],true) : "";
				$data[$key]['rate_type'] = isset($displayData['rate_type']) ? underscoreToUcWord($displayData['rate_type']) : "";
				$data[$key]['booking_type'] = isset($displayData['booking_type']) ? underscoreToUcWord($displayData['booking_type']) : "";
				$data[$key]['is_booking_required'] = (isset($displayData['is_booking_required']) && $displayData['is_booking_required'] != 0) ? "Yes" : "No";
			}
		}

		if($return){
			return $data;
		}else{
			$dataReport['data'] = $data;
			echo json_encode($dataReport);
			exit;
		}
        
    }

    public function changeStatus(){
        $eventId = $this->request->getVar('event_id');
        $status = $this->request->getVar('status');
        $return = $this->event_model->statusChange($eventId,$status,'event_id','tbl_event');
		if ($return == 1) {
			$response['success'] = true;
			$response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('Event.event'));
		} else {
			$response['success'] = false;
			$response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('Event.event'));
		}
		echo json_encode($response);
		exit;
    }

    public function save()
	{
       	$this->db->transStart();
		$validation = \Config\Services::validation();
		$eventId = $this->request->getVar('event_id');
		$eventName = $this->request->getVar('event_name');
		$startDate = $this->request->getVar('start_date');
		$endDate = $this->request->getVar('end_date');
		$commanAreaId = $this->request->getVar('common_area_id');
		$description = $this->request->getVar('description');
		$termsAndCondition = $this->request->getVar('terms_and_condition');
		$isBookingRequired = $this->request->getVar('is_booking_required');
		$isGuestAllowed = $this->request->getVar('is_guest_allowed');
		$isCashPayemenAllowed = $this->request->getVar('is_cash_payment_allowed');
		$isCancellationAllowed = $this->request->getVar('is_cancellation_allowed');
		$beforeMinutes = $this->request->getVar('before_minutes');
		$rateType = $this->request->getVar('rate_type');
		$bookingType = $this->request->getVar('booking_type');
		$maxBooking = $this->request->getVar('max_guest_allowed');
		$isActive = $this->request->getVar('is_active');
		$isPulled = $this->request->getVar('is_pulled');
		$dateArray = $this->request->getVar('date');
		
		$validation->setRule('event_name', lang('Event.event_name'), 'required');
		$validation->setRule('start_date', lang('Event.start_date'), 'required');
		$validation->setRule('end_date', lang('Event.end_date'), 'required');
		$validation->setRule('common_area_id', lang('Event.common_area_id'), 'required');

		if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

			if(isset($isPulled) && $isPulled == 0){
				$response['success'] = false;
            	$response['msg'] = lang("Event.please_press_generate_event_rate_table");
            	echo json_encode($response);
            	exit;
			}

			if(strtotime($startDate) >= strtotime($endDate)){
				$response['success'] = false;
            	$response['msg'] = "Start Date-Time Can't Be Greater Then End Date-Time";
            	echo json_encode($response);
            	exit;
			}

			$eventImage = array();
			if (isset($_FILES["event_image"])) {
				$eventImagePath = EVENT_IMAGE_PATH;
				$eventImage = $this->dt_ci_file_upload->UploadMultipleFile('event_image', MAX_IMAGE_SIZE_LIMIT, $eventImagePath, true, true, array('jpeg', 'png', 'jpg', 'JPG'));
				if ($eventImage['success'] == false) {
					$response['success'] = false;
					$response['msg'] = strip_tags($eventImage['message']);
					echo json_encode($response);
					die();
				}
			}

			if (isset($eventId) && $eventId != '') {
				$this->event_model->deleteRecordEventRate($eventId);
			}

			$eventUpdateArray = array();
			$eventArray = array(
				'event_id' => $eventId,
				'event_name' => $eventName,
				'start_date' => DMYToYMD($startDate,true, true),
				'end_date' => DMYToYMD($endDate,true, true),
				'common_area_id' => $commanAreaId,
				'description' => $description,
				'terms_and_condition' => $termsAndCondition,
				'is_booking_required' => isset($isBookingRequired) ? 1 : 0,
				'society_id' => $this->session->get('society_id'),
				'is_active' => isset($isActive) ? 1 : 0,
			);

			if(isset($isBookingRequired) && $isBookingRequired != 0){
				if(isset($isCancellationAllowed) && $isCancellationAllowed != 0){
					$eventArray['is_guest_allowed'] = (isset($isGuestAllowed) && $isGuestAllowed != 0) ? 1 : 0;
					$eventArray['is_cash_payment_allowed'] = (isset($isCashPayemenAllowed) && $isCashPayemenAllowed != 0) ? 1 : 0;
					$eventArray['is_cancellation_allowed'] = (isset($isCancellationAllowed) && $isCancellationAllowed != 0) ? 1 : 0;
					$eventArray['before_minutes'] = $beforeMinutes;
					$eventArray['rate_type'] = $rateType;
					$eventArray['booking_type'] = $bookingType;
					$eventArray['max_guest_allowed'] = $maxBooking;
				} else {
					$eventArray['is_guest_allowed'] = (isset($isGuestAllowed) && $isGuestAllowed != 0) ? 1 : 0;
					$eventArray['is_cash_payment_allowed'] = (isset($isCashPayemenAllowed) && $isCashPayemenAllowed != 0) ? 1 : 0;
					$eventArray['is_cancellation_allowed'] = (isset($isCancellationAllowed) && $isCancellationAllowed != 0) ? 1 : 0;
					$eventArray['rate_type'] = $rateType;
					$eventArray['booking_type'] = $bookingType;
					$eventArray['max_guest_allowed'] = $maxBooking;
				}
			}
			if(!empty($eventId)){
                $eventUpdateData = $this->event_model->getEventData(array(
                    'event_id' => $eventId,
                ));
                $eventUpdateArray = compareArray($eventArray,$eventUpdateData);
            }

			$eventData = $this->event_model->insertUpdateRecord($eventArray, 'event_id', 'tbl_event', 1,'',array(),array(),$eventUpdateArray);
			$lastEventId = $eventData['lastInsertedId'];

			if (isset($eventData['success']) && $eventData['success']) {
				if (isset($_FILES['event_thumbnail_image'])) {
					$eventImagePath    = THUMBNAIL_EVENT_IMAGE_PATH;
					$imageResult        = $this->dt_ci_file_upload->UploadFile('event_thumbnail_image', MAX_IMAGE_SIZE_LIMIT, $eventImagePath, true, true, array('jpeg', 'png', 'jpg', 'JPG'));
					if ($imageResult['success'] == false) {
						$response['success']    = false;
						$response['msg']        = strip_tags($imageResult['message']);
						echo json_encode($response);
						die();
					} else {
						if ($lastEventId != '') {
							$imageData = $this->event_model->getEventData(array("event_id" => $lastEventId));
							$imageUrl = '';
							if(isset($imageData['event_thumbnail_image']) && $imageData['event_thumbnail_image'] != '') {
								$imageUrl = THUMBNAIL_EVENT_IMAGE_PATH. $imageData['event_thumbnail_image'];
							}
							if (file_exists($imageUrl)) {
								unlink($imageUrl);
							}
						}
						unset($imageResult['success']);
						$imageUpdateArray = array(
							'event_id' => $lastEventId,
							'event_thumbnail_image' => $imageResult['file_name'],
						);
						$this->event_model->insertUpdateRecord($imageUpdateArray, 'event_id','tbl_event');
					}
				}
			}

			if($lastEventId != ''){
                if(isset($eventImage) && count($eventImage) > 0){
                    $batchArray = array();
                    unset($eventImage['success']);
                    foreach ($eventImage as $key => $imageData) {
                        $dataArray = array(
                            'event_image_id' =>   '',
                            'event_id' => $lastEventId,
                            'event_image' => isset($imageData['file_name']) ? $imageData['file_name'] : "",
                        );
                        array_push($batchArray, $dataArray);
                    }
                    $eventImageExtraDataArray = array();
                    $eventImageExtraDataArray['module_id'] = $lastEventId;
                    $eventImageExtraDataArray['module'] = 'Event Image';
                    $eventImageExtraDataArray['type'] = 'Event';
                    $eventImageExtraDataArray['old_data'] = array();
                    $eventImageExtraDataArray['user_id'] = $this->data['userId'];
                    $eventImageExtraDataArray['society_id'] = $this->session->get('society_id');
					$this->event_model->batchInsert($batchArray, 'tbl_event_image',$eventImageExtraDataArray);
                }
			}

			$eventRateIdArray = $this->request->getVar('event_rate_id');
            $adultRateArray = $this->request->getVar('adult_rate');
            $childArray = $this->request->getVar('child_rate');
            $guestArray = $this->request->getVar('guest_rate');
			if (!empty($eventRateIdArray) && (isset($isBookingRequired) && $isBookingRequired != 0) ) {
				if((isset($rateType) && $rateType == 'event_wise')){
					foreach ($eventRateIdArray as $fkey => $eventRateId) {
						$adultRate = array_key_exists($fkey, $adultRateArray) ? $adultRateArray[$fkey] : '';
						$childRate = array_key_exists($fkey, $childArray) ? $childArray[$fkey] : '';
						$guestRate = array_key_exists($fkey, $guestArray) ? $guestArray[$fkey] : '';
						$eventRateInsertUpdateArray = array(
							'event_rate_id' => '',
							'event_id' => $lastEventId,
							'event_type' => $rateType,
							'adult_rate' => $adultRate,
							'child_rate' => $childRate,
							'guest_rate' => $guestRate,
							'created_by' => $this->data['userId'],
							'updated_by' => $this->data['userId'],
							'created_at' => date("Y-m-d H:i:s"),
							'updated_at' => date("Y-m-d H:i:s"),
						);
						$eventRateInsertUpdateData = $this->event_model->insertUpdateRecord($eventRateInsertUpdateArray, 'event_rate_id', 'tbl_event_rate', 1,'',array(),array());
						$lastEventRateId = $eventRateInsertUpdateData['lastInsertedId'];
					}
				} else {
					foreach ($eventRateIdArray as $fkey => $eventRateId) {
						$adultRate = array_key_exists($fkey, $adultRateArray) ? $adultRateArray[$fkey] : '';
						$childRate = array_key_exists($fkey, $childArray) ? $childArray[$fkey] : '';
						$guestRate = array_key_exists($fkey, $guestArray) ? $guestArray[$fkey] : '';
						$date = array_key_exists($fkey, $dateArray) ? $dateArray[$fkey] : '';
							$eventRateInsertUpdateArray = array(
								'event_rate_id' => '',
								'event_id' => $lastEventId,
								'event_type' => $rateType,
								'date' => DMYToYMD($date),
								'adult_rate' => $adultRate,
								'child_rate' => $childRate,
								'guest_rate' => $guestRate,
								'created_by' => $this->data['userId'],
								'updated_by' => $this->data['userId'],
								'created_at' => date("Y-m-d H:i:s"),
								'updated_at' => date("Y-m-d H:i:s"),
							);
							$eventRateInsertUpdateData = $this->event_model->insertUpdateRecord($eventRateInsertUpdateArray, 'event_rate_id', 'tbl_event_rate', 1,'',array(),array());
							$lastEventRateId = $eventRateInsertUpdateData['lastInsertedId'];
					}
				}
			}
			$eventCategoryData = array();
            if(!empty($eventId)) {
                $eventCategoryData = $this->event_model->getEventCategoryData(array(
                    'event_id' => $eventId,
                    'is_multiple' => 1
                ));
            }

			$categoryIdArray = $this->request->getVar('category_id[]');
            if(isset($eventId) && $eventId != ''){
                $this->event_model->deleteCategoryRecord($eventId);
            }
            if(isset($categoryIdArray)&& $categoryIdArray != ''){
                $categoryForArray = array();
                foreach($categoryIdArray as $categoryId){
                    $categoryForArray[] = array(
                        'event_category_id' => '',
                        'event_id' => $lastEventId,
                        'category_id' => $categoryId,
                        'created_at' => date('Y-m-d H:i:s'),
                        'updated_at' => date('Y-m-d H:i:s'),
                        'created_by' => $this->data['userId'],
                        'updated_by' => $this->data['userId']
                    );
                }
                $eventSocietyExtraDataArray = array();
                $eventSocietyExtraDataArray['module_id'] = $lastEventId;
                $eventSocietyExtraDataArray['module'] = 'Event Category';
                $eventSocietyExtraDataArray['type'] = 'Event';
                $eventSocietyExtraDataArray['old_data'] = $eventCategoryData;
                $eventSocietyExtraDataArray['user_id'] = $this->data['userId'];
                $eventSocietyExtraDataArray['society_id'] = $this->session->get('society_id');

                if(!empty($categoryForArray)){
                    $this->event_model->batchInsert($categoryForArray,'tbl_event_category',$eventSocietyExtraDataArray);
                }
            }
		}
		$transactionStatus = $this->db->transComplete();
			if (isset($eventId) && $eventId != '') {
				if (($eventData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.update_record'), lang("Event.event"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.update_record_error'), lang("Event.event"));
				}
			} else {
				if (($eventData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.create_record'), lang("Event.event"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.create_record_error'), lang("Event.event"));
				}
			}
			echo json_encode($response);
			exit;
	}

    public function delete()
    {
        $this->db->transStart();
        $eventId = $this->request->getVar('event_id');
         if( isReferenceInTable( 'event_id','tbl_event_booking', $eventId) || 
     		isReferenceInTable( 'event_id','tbl_event_booking_registration', $eventId)){
			 if(!empty($eventId)){
			 	foreach($eventId as $documentElement){
			 		$deleteDataArray['module'] = 'Event';
			 		$deleteDataArray['activity'] = "Tried to Delete Event ";
			 		$deleteDataArray['module_id'] = $documentElement;
			 		logActivity('Tried to delete Event [EventID: ' . $documentElement . ']',$this->data['userId'],'Event',$documentElement,json_encode($deleteDataArray),'','Event',$documentElement);
			 	}
			 }
             $response['success'] = false;
             $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
             echo json_encode($response);
             exit;
         }
		$eventImageData = $this->event_model->getEventImageData(array(
			"event_id" => $eventId,
			"is_multiple" => 1
		));
		if(is_array($eventImageData) && !empty($eventImageData)){
			foreach ($eventImageData as $image){
				$FileUrl = '';
				if(isset($image['event_image']) && $image['event_image'] != '') {
					$FileUrl = EVENT_IMAGE_PATH . $image['event_image'];
				}
				if (file_exists($FileUrl)) {
					unlink($FileUrl);
				}
			}
		}
        $eventData = $this->event_model->deleteRecord($eventId);
		$this->event_model->deleteCategoryRecord($eventId);
		$transactionStatus = $this->db->transComplete();
        if (($eventData) && ($transactionStatus == 1)) {
            $this->db->transCommit();
            $response['success'] = true;
            $response['msg'] = sprintf(lang('CommonMessage.delete_record'), lang("Event.event"));
        } else {
            $this->db->transRollback();
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'), lang("Event.event"));
        }
        echo json_encode($response);
        exit;
    }

    public function deleteEventImage()
    {
    	$this->db->transStart();
        $eventImageId = $this->request->getVar('event_image_id');
        $eventId = $this->request->getVar('event_id');
        $imageData = $this->event_model->getEventImageData(array(
            "event_image_id" => $eventImageId,
            "is_multiple" => 1
        ));
        if(is_array($imageData) && !empty($imageData)){
            foreach ($imageData as $image){
                $FileUrl = '';
                if(isset($image['event_image']) && $image['event_image'] != '') {
                    $FileUrl = EVENT_IMAGE_PATH . $image['event_image'];
                }
                if (file_exists($FileUrl)) {
                    unlink($FileUrl);
                } 
            }
        }
        //delete setting location
        $imageData = $this->event_model->deleteEventImage($eventImageId);      
        if ($imageData) {
			$ids = is_array($eventImageId) ? implode(',',$eventImageId) : $eventImageId;
			$deleteDataArray['module'] = 'Event Image';
			$deleteDataArray['activity'] = "Event Image Deleted";
			$deleteDataArray['module_id'] = $eventImageId;
			logActivity('Event Image Deleted [EventImageID: ' . $ids . ']',$this->data['userId'],'Event Image',$ids,json_encode($deleteDataArray),'','Event',$eventId);
			$transactionStatus = $this->db->transComplete();
			if($transactionStatus == 1){
				$response['success'] = true;
            	$response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Event.event_image'));
			}
			else{
				$response['success'] = false;
            	$response['msg']     = sprintf(lang('CommonMessage.delete_error'),lang('Event.event_image'));
			}
            
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('Event.event_image'));
        }
        echo json_encode($response);
        exit();
    }
	public function getEventTableRow() {
		// printArray($_POST,1);
		$validation = \Config\Services::validation();
		// $data['row_number'] = $this->request->getVar("row_number");
		$eventType = $this->request->getVar('rate_type');
		$eventId = $this->request->getVar('event_id');
		$startDate = $this->request->getVar('start_date');
		$endDate = $this->request->getVar('end_date');
		
		// Validation rules
		$validation->setRule('rate_type', lang('Event.rate_type'), 'required',array("required" => lang('Event.rate_type')." Is Required"));
		// $validation->setRule('event_id', lang('Event.event_id'), 'required',array("required" => lang('Event.event_id')." Is Required"));

		// Validate the input
		if (!$validation->withRequest($this->request)->run()) {
			$errors = $validation->getErrors();
			$response['success'] = false;
			$response['msg'] = implode("\n", $errors);
			echo json_encode($response);
			exit;
		} else {

			if(strtotime($startDate) >= strtotime($endDate)){
				$response['success'] = false;
				$response['msg'] = "Start Date-Time Can't Be Greater Then End Date-Time";
				echo json_encode($response);
				exit;
			}
			$dates = generateDateRange($startDate, $endDate);
			$data['dates'] = $dates;

			if ($eventType != 'event_wise') {
				$rowsHtml = ''; // Initialize a string to hold all the rows
				
				foreach ($dates as $dateKey => $date) {
					$data["row_number"] = $dateKey + 1;
					// Assign the current date and other event rate data
					$data['event_rate_data'] = [
						'date' => $date, // Pass the current date to the view for non-event_wise
						'event_rate_id' => '', // You can adjust this as per your requirement
						'adult_rate' => '', // You can set default values for the rates
						'child_rate' => '',
						'guest_rate' => '',
						'event_type' => 'date_wise',
						'row_number' => $dateKey,
					];
					
					// Generate HTML for each row dynamically using the view
					$rowsHtml .= view('Admin/Event/EventRateTableRowView', isset($data) ? $data : array());
				}

				// Return the generated rows as the response
				$response['success'] = true;
				$response['event_rate_row_data'] = $rowsHtml;
				echo json_encode($response);
				exit;
			} else {
				// Handle the case when the event type is 'event_wise'
				$data['event_rate_data'] = [
					'event_rate_id' => '', // Adjust as needed
					'adult_rate' => '', // Default values for rates
					'child_rate' => '',
					'guest_rate' => '',
				];
				
				$eventRateRowHtml = view('Admin/Event/EventRateTableRowView', isset($data) ? $data : array());
				$response['success'] = true;
				$response['event_rate_row_data'] = $eventRateRowHtml;
				echo json_encode($response);
				exit;
			}
		}
	}

	public function submitForm()
    {
        $eventId = $this->request->getVar('event_id');
        $formStatus = $this->request->getVar('form_status');
        $this->db->transBegin();

        if ($formStatus == 'approved') {
            $eventDataArray = $this->event_model->getEventData(array(
                'event_id' => $eventId,
                'is_multiple' => 1
            ));

            $eventArray = array();

            foreach ($eventDataArray as $eventData) {

                if (isset($eventData['form_submit']) && ($eventData['form_submit'] == $formStatus)) {
                    $response['success'] = false;
                    $response['msg'] = sprintf(lang('CommonMessage.status_change_error'), lang('Event.event'));
                    echo json_encode($response);
                    exit;
                }

                $eventArray[] = array(
                    'event_id' => $eventData['event_id'],
                    'form_submit' => $formStatus,
                    'approved_by' => $this->data['userId'],
                    'approved_at' => DATE_TIME_DATABASE,
                    'updated_by' => $this->data['userId'],
                    'updated_at' => DATE_TIME_DATABASE
                );
            }
        }

        if ($formStatus == 'saved') {

            $eventDataArray = $this->event_model->getEventData(array(
                'event_id' => $eventId,
                'is_multiple' => 1
            ));

            foreach ($eventDataArray as $eventData) {
                
                if (isset($eventData['form_submit']) && ($eventData['form_submit'] == $formStatus)) {
                    $response['success'] = false;
                    $response['msg'] = sprintf(lang('CommonMessage.status_change_error'), lang('Event.event'));
                    echo json_encode($response);
                    exit;
                }

                $eventArray[] = array(
                    'event_id' => $eventData['event_id'],
                    'form_submit' => $formStatus,
                    'unapproved_by' => $this->data['userId'],
                    'unapproved_at' => DATE_TIME_DATABASE,
                    'updated_by' => $this->data['userId'],
                    'updated_at' => DATE_TIME_DATABASE
                );

            }
        }

        $eventResponse = $this->event_model->batchUpdate($eventArray, 'event_id', 'tbl_event');

        if (isset($eventResponse['success']) && $eventResponse['success']) {
            $this->db->transCommit();
            $response['title'] = lang('CommonMessage.common_success');
            $response['msg'] = lang('CommonMessage.common_approved_success');
            $response['success'] = true;
        } else {
            $this->db->transRollback();
            $response['title'] = lang('common_error');
            $response['success'] = false;
            $response['msg'] = lang('common_approved_error');
        }
        echo json_encode($response);
    }

	public function getEventDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page            = $this->request->getVar('page');
        $eventId = $this->request->getVar('event_id');
        $societyId = $this->request->getVar('society_id');

        $filterData = array(
            'event_id' => $eventId,
            'society_id' => $societyId,
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT,
            'form_submit' => 'approved',
            'is_active' => 1,
            'date_greater_than_equal_to' => TODAY_DATE_YMD,

        );
        echo $this->event_model->getEvent($filterData);
    }

	public function view($id = null)
    {
        $eventId = $this->request->getVar("view_id");
        if($eventId == "" && $eventId == null){
            return redirect()->to('Admin/Event');
        }
        else {
            
            $filterData = array(
                "event_id" => $eventId
            );
           
			$data['event_data'] = $this->event_model->getEventData($filterData);
			// printArray($data['event_data'],1);
			if (empty($data['event_data'])) {
                return redirect()->to('Admin/Event');
            }

			if(isReferenceInTable( 'event_id','tbl_event_booking', $eventId)){
				$data['event_is_booked'] = 'Yes';
			}else {
				$data['event_is_booked'] = 'No';
			}

			$eventCategoryData = $this->event_model->getEventCategoryData(array(
				'event_id' => $eventId,
				'is_multiple' => 1
			));
			$data['event_category_data'] = $eventCategoryData;

			$data['event_rate_data'] = $this->event_model->getEventRateData(array(
				"event_id" => $eventId,
				"is_multiple" => 1
			));
			
			$data['image_data'] = $this->event_model->getEventImageData(array(
                "event_id" => $eventId,
                "is_multiple" => 1
           	));
            // printArray($data['event_rate_data'],1);

            $eventView = view("Admin/Event/EventModelView", $data);
            $response['view_title'] = "Event Details";
            $response['view_detail'] = $eventView;
            $response['success'] = true;
            echo json_encode($response);
        }
    }
}
