<?php

namespace App\Controllers\Admin;
use CodeIgniter\Controller;

use App\Models\DailyReportModel;
class Dashboard extends BaseController
{

    public function __construct() {
        $this->daily_report_model = new DailyReportModel();
    }


    public function index()
    {
        $data['extra_js'] = array(
            "js/vendor/notifications/sweet_alert.min.js",
            "js/vendor/tables/datatables/datatables.min.js",
            "js/vendor/notifications/bootbox.min.js"
        );
        $data['message'] = 	$this->session->getFlashdata('message');
        $data['title'] = 'Dashboard';

        $isSuperAdmin = $this->session->get('is_super_admin');
        if(!$isSuperAdmin){
            $isDailyReportAdded = $this->daily_report_model->getDailyReportData(array(
                'report_date' => date('Y-m-d'),
            ));
    
            $data['isDailyReportAdded'] = $isDailyReportAdded;
        }
        $data['is_super_admin'] = $isSuperAdmin;
        return $this->dt_ci_template->load("Admin","Dashboard/DashboardView",$data);
    }
}
