<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\DailyReportModel;
class DailyReport extends BaseController
{
    protected $daily_report_model;
    public function __construct() {
        $this->daily_report_model = new DailyReportModel();
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/moment/moment.js",
			"vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
        $data['title'] = 'Daily Report';
        $dataFilters['filters'] = array(
            
            array(
                "type" => "daterange",
                "id" => "filter_report_date",
                "name" => "filter_report_date",
                "title" => "DailyReport.report_date",
            ),
        );

        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Ajax)? $select2Ajax : array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());    
        return $this->dt_ci_template->load("Admin","DailyReport/DailyReportView",$data);
    }

    public function getDailyReportListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }

		$reportDate = $this->request->getVar("filter_report_date");
		
        $this->datatables->table("tbl_daily_report as tdr");
        $this->datatables->select("tdr.report_date,tdr.id");
        // $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tba.updated_at");
        // $this->datatables->join("society_user_master_view as tupdate","tupdate.id = tba.updated_by AND tupdate.society_id = tba.society_id","left");
        // $this->datatables->join("tbl_bank as tb","tb.bank_id = tba.bank_id","left");

        

        if($reportDate != ''){
            list($fromDate,$toDate) = explode(" - ",$reportDate);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tdr.report_date,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tdr.report_date,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tdr.report_date,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }
        
        $this->datatables->groupBy("tdr.id");

        accessFilter($this->datatables, array("society" => "tdr.society_id"));
        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        // printArray($data,1);
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "id" => isset($displayData['id']) ? $displayData['id'] : "",
                    "report_date" => isset($displayData['report_date']) ? $displayData['report_date'] : "",
                );
                $data[$key]['action_button'] = dailyReportActionButton($actionButtonFilter);
                $data[$key]['report_date'] = isValidDate($displayData['report_date']) ? siteDateFormat($displayData['report_date']) : '';
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }

    public function manage($id = '')
	{

		$data['extra_js'] = array(
            "js/jquery.form.min.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
			"js/validate.min.js",
			"js/additional_methods.min.js"
        );

        if ($id != '') {
			$filterData = array(
				"id" => $id
			);

            $dailyReportData = $this->daily_report_model->getDailyReportData($filterData);
            // if($dailyReportData['report_date] <= date('Y-m-d')){

            // }
			$data['daily_report_data'] = $dailyReportData;
            $data['existing_data'] = $this->flattenArray(json_decode($data['daily_report_data']['daily_report_json'],true));
            // printArray($this->flattenArray(json_decode($data['daily_report_data']['daily_report_json'],true)));
            
            // printArray($data['daily_report_data'],1);
		}
		if ($id != '') {
			$data['title'] = 'Edit Daily Report';
		} else {
			$data['title'] = 'Add Daily Report';
		}
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Condition)? $select2Condition : array());
		return $this->dt_ci_template->load("Admin","DailyReport/DailyReportManageView",$data);
	}

    public function save()
	{
		// printArray($_POST);
        $this->db->transStart();
        $validation = \Config\Services::validation();
        $id = $this->request->getVar('id');
        $reportDate = $this->request->getVar('report_date');
        // $bankId = $this->request->getVar('bank_id');

        $insertJsonArr = json_decode(dailyReportJson(),true);
        $baseArr = $this->rebuildBaseArrayFromPost($insertJsonArr, $_POST);
        // printArray($baseArr,1);

        // $expectedFields = generateFormFieldNames($insertJsonArr,'',$_POST);
        $insertJson = json_encode($baseArr,1);
        // printArray($expectedFields);
        // printArray($insertJsonArr);

        $validation->setRule('report_date', lang('DailyReport.report_date'), 'required');
		
		if (!$validation->withRequest($this->request)->run()) {
			$errors = $validation->getErrors();
            $response['success'] = false;
			$response['msg'] = implode("\n", $errors);
			echo json_encode($response);
			exit;
		} else {

            $duplicateDailyReportData = $this->daily_report_model->getDailyReportData(array(
                'id_not' => $id,
                'report_date' => DMYToYMD($reportDate),
            ));

            if(!empty($duplicateDailyReportData)){
                $response['success'] = false;
                $response['msg'] = "Daily Report has been already created for ".$reportDate;
                echo json_encode($response);
                exit;
            }

			$bankAccountUpdateArray = array();
			$bankAccountArray = array(
				'id' => $id,
				'report_date' => DMYToYMD($reportDate),
				// 'report_date' => date('Y-m-d'),
				'daily_report_json' => $insertJson,
                'society_id' => $this->session->get("society_id"),
			);
            // printArray($bankAccountArray,1);

			if(!empty($id)){
                // $bankAccountUpdateData = $this->daily_report_model->getDailyReportData(array(
                //     'bank_account_id' => $id,
                // ));
                // $bankAccountUpdateArray = compareArray($bankAccountArray,$bankAccountUpdateData);
            }
			$bankAccountData = $this->daily_report_model->insertUpdateRecord($bankAccountArray, 'id', 'tbl_daily_report', 1,'',array(),array(),array());
			$lastDailyReportId = $bankAccountData['lastInsertedId'];
            $transactionStatus = $this->db->transComplete();
			if (isset($id) && $id != '') {
				if (($bankAccountData['success']) && ($transactionStatus == 1)) {
                    $response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.update_record'),lang('DailyReport.daily_report'));
				} else {
                    $response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.update_record_error'),lang('DailyReport.daily_report'));
				}
			} else {
				if (($bankAccountData['success']) && ($transactionStatus == 1)) {
                    $response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.create_record'),lang('DailyReport.daily_report'));
				} else {
                    $response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.create_record_error'),lang('DailyReport.daily_report'));
				}
			}
			echo json_encode($response);
			exit;
		}
	}
    public function changeStatus()
    {
        $bankAccountId = $this->request->getVar('bank_account_id');
        $status = $this->request->getVar('status');

        //$status         = ($status == 0) ? 1 : 0;
        $return = $this->daily_report_model->statusChange($bankAccountId,$status,'bank_account_id','tbl_bank_account');
        if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('DailyReport.bank_account'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('DailyReport.bank_account'));
        }
        echo json_encode($response);
        exit();
    }


    public function delete()
    {
        $this->db->transStart();
        $id = $this->request->getVar('daily_report_id');
        $ids = is_array($id) ? implode(',', $id) : $id;
        $bankAccountData = $this->daily_report_model->deleteRecord($id);
        $transactionStatus = $this->db->transComplete();
        if (($bankAccountData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('DailyReport.daily_report'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang('DailyReport.daily_report'));
        }
        echo json_encode($response);
        exit;
    }

    public function getDailyReportDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page            = $this->request->getVar('page');
        $bankAccountId = $this->request->getVar('bank_account_id');

        $filterData = array(
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT,
            'is_active' => 1,
            'bank_account_id' => $bankAccountId,

        );
        echo $this->daily_report_model->getDailyReport($filterData);
    }

    public function excelExportDailyReport()
    {
        $fileName ='bank-account-' . DATETIMEFORMAT;
        $sheetName = 'Bank Account-' . DATEFORMAT;
        $excelHeaderName = 'Bank Account';
        $tableData = $this->getDailyReportListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            lang('DailyReport.bank_name'),
            lang('DailyReport.branch'),
            lang('DailyReport.bank_account_no'),
            lang('DailyReport.account_type'),
            lang('DailyReport.ifsc_code'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                $row["bank_name"],
                $row["branch"],
                $row["bank_account_no"],
                $row["bank_account_type"],
                $row["ifsc_code"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'G';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }

    private function flattenArray($array, $prefix = '') {
        $result = [];
        
        foreach ($array as $key => $value) {
            $newKey = $prefix . ($prefix ? '_' : '') . $key;
            
            if (is_array($value)) {
                $result = array_merge($result, $this->flattenArray($value, $newKey));
            } else {
                $result[$newKey] = $value;
            }
        }
        
        return $result;
    }

    public function pdf($id = null, $view = null,$save_bufffer = null,$zipPdf = 0){
        $reportId = $id;
        $societyId = $this->session->get('society_id');

        $filterData = array(
			// "report_date" => date('Y-m-d'),
			"id" => $reportId,
		);
		$data['daily_report_data'] = $this->daily_report_model->getDailyReportData($filterData);
        // $data['existing_data'] = $this->flattenArray(json_decode($data['daily_report_data']['daily_report_json'],true));
        $dailyReportData = isset($data['daily_report_data']['daily_report_json']) ? json_decode($data['daily_report_data']['daily_report_json'],true) : array();
        $data['report_json_data'] = $dailyReportData;

        // $societyData = $this->society_model->getSocietyData(array(
        //     "society_id" => $societyId
        // ));

        // $filterData = array(
        //     "invoice_id" => $invoiceId
        // );
        // $data['invoice_data'] = $this->invoice_model->getInvoiceData($filterData);

        // $invoiceParticularData = $this->invoice_model->getInvoiceParticularData(array(
        //     "invoice_id" => $invoiceId,
        //     "is_multiple" => 1,
        // ));
            
        // $invoiceParticularTaxData = $this->invoice_model->getInvoiceParticularTaxData(array(
        //     "invoice_id" => $invoiceId,
        //     "is_multiple" => 1,
        // ));

        // foreach ($invoiceParticularData as $pKey => $pValue) {
        //     foreach ($invoiceParticularTaxData as $tKey => $tValue) {
        //         if($tValue['invoice_particular_id'] == $pValue['invoice_particular_id']){
        //             $invoiceParticularData[$pKey]['tax_data'][] = $tValue;
        //         }
        //     }
        // }


        // $data['society_data'] = $societyData;
        // $data['invoice_particular_data'] = $invoiceParticularData;

        $data['name'] = lang("DailyReport.daily_report").".pdf";
        $printHeader = '';
        $printFooter = '';
        // $signatureDetails = array(
        //     "created_by" => isset($voucher['created_by']) ? $voucher['created_by'] : "",
        //     "approved_by" =>  "",
        //     "document_number" => isset($voucher['flat_no'])  ? lang("Voucher.voucher")."# ".$voucher['flat_no']  : "",
        //     "document_date" => isset($voucher['created_at']) ? siteDateFormat($voucher['created_at']) : "",
        //     "print_for" => "Voucher",
        // );
        // if (isset($voucher['voucher_id'])) {
        //     $printFooter = pdfFooter( 1, $signatureDetails);
        // }
        $html = view('Admin/DailyReport/pdf/DailyReportPdfView', $data);
        
        // echo($html);
        // die();
        generate_pdf($html, $data['name'], false, $printFooter, '', $printHeader, '', 'P');
    }

    function rebuildBaseArrayFromPost($baseArr, $postData) {
        $result = [];
        
        // Rebuild ensure_working
        $result['ensure_working'] = [];
        foreach ($baseArr['ensure_working'] as $key => $default) {
            $result['ensure_working'][$key] = $postData["ensure_working_{$key}"] ?? $default;
        }
        
        // Rebuild water_meter_reading (dynamic)
        $result['water_meter_reading'] = [];
        foreach ($postData as $key => $value) {
            if (strpos($key, 'water_meter_reading_meter_') === 0) {
                $meterNum = str_replace('water_meter_reading_meter_', '', $key);
                $result['water_meter_reading']["meter_{$meterNum}"] = $value;
            }
        }
        
        // Rebuild collection_description
        $result['collection_description'] = [];
        foreach ($baseArr['collection_description'] as $key => $default) {
            $result['collection_description'][$key] = $postData["collection_description_{$key}"] ?? $default;
        }
        
        // Rebuild cash_with_manager
        $result['cash_with_manager'] = [];
        foreach ($baseArr['cash_with_manager'] as $key => $default) {
            $result['cash_with_manager'][$key] = $postData["cash_with_manager_{$key}"] ?? $default;
        }
        
        // Rebuild daily_work
        $result['daily_work'] = [];
        foreach ($baseArr['daily_work'] as $workKey => $workItem) {
            if (in_array($workKey, ['society_rounds', 'generator_usage'])) {
                // Dynamic time fields
                $timeFields = [];
                foreach ($postData as $key => $value) {
                    if (strpos($key, "daily_work_{$workKey}_time") === 0) {
                        preg_match('/time(\d+)/', $key, $matches);
                        if (isset($matches[1])) {
                            $timeFields["time{$matches[1]}"] = $value;
                        }
                    }
                }
                $result['daily_work'][$workKey] = $timeFields;
            } elseif (is_array($workItem)) {
                // Fixed fields with array structure
                $result['daily_work'][$workKey] = [];
                foreach ($workItem as $columnKey => $default) {
                    $result['daily_work'][$workKey][$columnKey] = $postData["daily_work_{$workKey}_{$columnKey}"] ?? $default;
                }
            } else {
                // Simple string field (like "others")
                $result['daily_work'][$workKey] = $postData["daily_work_{$workKey}"] ?? $workItem;
            }
        }
        
        // Rebuild periodical_works
        $result['periodical_works'] = [];
        foreach ($baseArr['periodical_works'] as $workKey => $workItem) {
            $result['periodical_works'][$workKey] = [
                'scheduled' => $postData["periodical_works_{$workKey}_scheduled"] ?? $workItem['scheduled'],
                'details' => $postData["periodical_works_{$workKey}_details"] ?? $workItem['details']
            ];
        }
        
        // Rebuild service_providers
        $result['service_providers'] = [];
        foreach ($baseArr['service_providers'] as $providerKey => $providerData) {
            if (isset($providerData['required']) && is_array($providerData['required'])) {
                // Complex structure
                $result['service_providers'][$providerKey] = [
                    'required' => [],
                    'available' => []
                ];
                foreach ($providerData['required'] as $column => $default) {
                    $result['service_providers'][$providerKey]['required'][$column] = 
                        $postData["service_providers_{$providerKey}_required_{$column}"] ?? $default;
                }
                foreach ($providerData['available'] as $column => $default) {
                    $result['service_providers'][$providerKey]['available'][$column] = 
                        $postData["service_providers_{$providerKey}_available_{$column}"] ?? $default;
                }
            } else {
                // Simple structure
                $result['service_providers'][$providerKey] = [
                    'required' => $postData["service_providers_{$providerKey}_required"] ?? $providerData['required'],
                    'available' => $postData["service_providers_{$providerKey}_available"] ?? $providerData['available']
                ];
            }
        }
        
        return $result;
    }
}
