<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\CommonWebServiceModel;
class Comment extends BaseController
{
    protected $common_web_service_model;
    public function __construct() {
        $this->common_web_service_model = new CommonWebServiceModel();
    }

    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/moment/moment.js",
            "vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
        $data['title'] = 'Comment';
        $forumId = $this->request->getVar("forum_id");
        $dataFilters['filters'] = array(
            array(
                "type" => "multi_select",
                "dynamic" => false,
                "tbl_name" => "tbl_forum",
                "columns" => array("forum_id","title"),
                "selected" => $forumId,
                "class" => "forumDd",
                "id" => "filter_forum_id",
                "name" => "filter_forum_id",
                "title" => "Comment.forum_title",
            ),

            array(
                "type" => "multi_select",
                "dynamic" => true,
                "class" => "getFlatMemberDd",
                "id" => "filter_flat_member_id",
                "name" => "filter_flat_member_id",
                "title" => "Comment.member_name",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_created_at",
                "name" => "filter_created_at",
                "title" => "CommonMessage.common_created_at",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_updated_at",
                "name" => "filter_updated_at",
                "title" => "CommonMessage.common_updated_at",
            ),
        );
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
        return $this->dt_ci_template->load("Admin","Comment/CommentView",$data);
    }

    public function getCommentListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $forumId = $this->request->getVar("filter_forum_id");
        $createdAt = $this->request->getVar("filter_created_at");
        $updatedAt = $this->request->getVar("filter_updated_at");
        $ownerMemberId = $this->request->getVar("filter_flat_member_id");

        $this->datatables->table("tbl_comment as tc");
        $this->datatables->select("tc.comment_id,tc.type,tc.created_at,tc.updated_at,tc.message,tc.parent_comment_id");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $this->datatables->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by,tm.name as member_name");
        $this->datatables->select("(CASE WHEN tc.type = 'forum' THEN COALESCE(tf.title, '') END) as type_name");
        $this->datatables->join("society_user_master_view as tupdate","tupdate.user_society_id = tc.updated_by","left");
        $this->datatables->join("society_user_master_view as tcreate","tcreate.user_society_id = tc.created_by","left");
        $this->datatables->join("tbl_ownership_flat_member as tofm","tofm.ownership_flat_member_id = tc.ownership_flat_member_id","left");
        $this->datatables->join(MASTER_DB.".tbl_member as tm", "tm.member_id = tofm.member_id",  "left");
        $this->datatables->join("tbl_forum as tf", "tf.forum_id = tc.type_id AND tc.type = 'forum'", "left");
        $this->datatables->where("tc.is_deleted = 0 AND tc.parent_comment_id = 0");
        $this->datatables->groupBy("tc.comment_id");
        accessFilter($this->datatables, array("society" => "tc.society_id"));

        if(isset($ownerMemberId)) {
            if(is_array($ownerMemberId)){
                $this->datatables->whereIn("tc.ownership_flat_member_id",$ownerMemberId);
            } else {
                $this->datatables->where("tc.ownership_flat_member_id",$ownerMemberId);
            }
        }

        if(isset($forumId)) {
            if(is_array($forumId)){
                $this->datatables->whereIn("tc.type = 'forum' AND tc.type_id",$forumId);
            } else {
                $this->datatables->where("tc.type = 'forum' AND tc.type_id",$forumId);
            }
        }

        if($createdAt != ''){
            list($fromDate,$toDate) = explode(" - ",$createdAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tc.created_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tc.created_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tc.created_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }
        if($updatedAt != ''){
            list($fromDate,$toDate) = explode(" - ",$updatedAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tc.updated_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tc.updated_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tc.updated_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }


        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
                $data[$key]['created_at'] = isValidDate($displayData['created_at']) ? siteDateFormat($displayData['created_at'],true) : "";
            }
        }

        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }

    public function getOptionData(){
        $commentId = $this->request->getVar('comment_id');
        $responseType = $this->request->getVar('response_type');
        $data['child_row'] = 1;
        $activityHtml = $this->common_web_service_model->getCommentData(array(
            'parent_comment_id' => $commentId,
            'is_multiple' => 1
        ));
        $response['option_data'] = $activityHtml;
        $response['title'] = "Order History";
        $response['success'] = true;
        if($responseType == 'json') {
            echo json_encode($response);
        } else {
            echo json_encode($response);
        }
    }
}
