<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\BankAccountModel;
class BankAccount extends BaseController
{
    protected $bank_account_model;
    public function __construct() {
        $this->bank_account_model = new BankAccountModel();
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/moment/moment.js",
			"vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
        $data['title'] = 'Bank Account';
        $dataFilters['filters'] = array(
            array(
                "type" => "multi_select",
                "dynamic" => true,
                "class" => "bankDd",
                "id" => "filter_bank_id",
                "name" => "filter_bank_id",
                "title" => "BankAccount.bank",
            ),
			array(
                "type" => "account_type",
                "id" => "filter_account_type",
                "name" => "filter_account_type",
                "title" => "BankAccount.account_type",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_created_at",
                "name" => "filter_created_at",
                "title" => "CommonMessage.common_created_at",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_updated_at",
                "name" => "filter_updated_at",
                "title" => "CommonMessage.common_updated_at",
            ),
        );

        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Ajax)? $select2Ajax : array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());    
        return $this->dt_ci_template->load("Admin","BankAccount/BankAccountView",$data);
    }

    public function getBankAccountListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }

        $createdAt = $this->request->getVar("filter_created_at");
		$updatedAt = $this->request->getVar("filter_updated_at");
		$bankId = $this->request->getVar("filter_bank_id");
		$accountType = $this->request->getVar("filter_account_type");
		
        $this->datatables->table("tbl_bank_account as tba");
        $this->datatables->select("tba.bank_account_id,tb.bank_name,tba.is_active,tba.ifsc_code,tba.bank_account_no,tba.branch,tba.bank_account_type");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tba.updated_at");
        $this->datatables->join("society_user_master_view as tupdate","tupdate.user_society_id = tba.updated_by","left");
        $this->datatables->join("tbl_bank as tb","tb.bank_id = tba.bank_id","left");

        if(isset($bankId)) {
            if(is_array($bankId)){
                $this->datatables->whereIn("tba.bank_id",$bankId);
            } else {
                $this->datatables->where("tba.bank_id",$bankId);
            }
        }

        if(isset($accountType)) {
            if(is_array($accountType)){
                $this->datatables->whereIn("tba.bank_account_type",$accountType);
            } else {
                $this->datatables->where("tba.bank_account_type",$accountType);
            }
        }

        if($createdAt != ''){
            list($fromDate,$toDate) = explode(" - ",$createdAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tba.created_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tba.created_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tba.created_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }
        if($updatedAt != ''){
            list($fromDate,$toDate) = explode(" - ",$updatedAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tba.updated_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tba.updated_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tba.updated_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }
        $this->datatables->groupBy("tba.bank_account_id");

        accessFilter($this->datatables, array("society" => "tba.society_id"));
        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        // printArray($data,1);
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "bank_account_id" => isset($displayData['bank_account_id']) ? $displayData['bank_account_id'] : "",
                );
                $data[$key]['action_button'] = bankAccountActionButton($actionButtonFilter);
                $data[$key]['bank_account_type'] = isset($displayData['bank_account_type']) ? underscoreToUcWord($displayData['bank_account_type']) : "";
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }

    public function manage($bankAccountId = '')
	{

		$data['extra_js'] = array(
            "js/jquery.form.min.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
			"js/validate.min.js",
			"js/additional_methods.min.js"
        );

        if ($bankAccountId != '') {
			$filterData = array(
				"bank_account_id" => $bankAccountId
			);
			$data['bank_account_data'] = $this->bank_account_model->getBankAccountData($filterData);
		}
		if ($bankAccountId != '') {
			$data['title'] = 'Edit Bank Account';
		} else {
			$data['title'] = 'Add Bank Account';
		}
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Condition)? $select2Condition : array());
		return $this->dt_ci_template->load("Admin","BankAccount/BankAccountManageView",$data);
	}

    public function save()
	{
		//printArray($_POST,1);
        $this->db->transStart();
        $validation = \Config\Services::validation();
        $bankAccountId = $this->request->getVar('bank_account_id');
        $bankId = $this->request->getVar('bank_id');
		$bankBranch = $this->request->getVar('branch');
		$bankAccountNo = $this->request->getVar('bank_account_no');
		$bankAccountType = $this->request->getVar('bank_account_type');
		$bankIfscCode = $this->request->getVar('ifsc_code');
		$isActive = $this->request->getVar('is_active');

		if (isset($bankAccountId) && $bankAccountId == '') {
			$validation->setRule('bank_account_no', lang('BankAccount.bank_account_no'), 'required|checkTenantUnique[tbl_bank_account.bank_account_no]');
		} else {
			$validation->setRule('bank_account_no', lang('BankAccount.bank_account_no'), 'required|checkTenantUnique[tbl_bank_account.bank_account_no,bank_account_id,'.$bankAccountId.']');
		}

        $validation->setRule('bank_id', lang('BankAccount.bank_name'), 'required');
        $validation->setRule('bank_account_type', lang('BankAccount.account_type'), 'required');
        $validation->setRule('branch', lang('BankAccount.branch'), 'required');
        $validation->setRule('ifsc_code', lang('BankAccount.ifsc_code'), 'required');
		

		if (!$validation->withRequest($this->request)->run()) {
			$errors = $validation->getErrors();
            $response['success'] = false;
			$response['msg'] = implode("\n", $errors);
			echo json_encode($response);
			exit;
		} else {
			$bankAccountUpdateArray = array();
			$bankAccountArray = array(
				'bank_account_id' => $bankAccountId,
				'bank_id' => $bankId,
				'branch' => $bankBranch,
				'bank_account_no' => $bankAccountNo,
				'bank_account_type' => $bankAccountType,
				'ifsc_code' => $bankIfscCode,
				'is_active' => isset($isActive) ? 1 : 0,
                'society_id' => $this->session->get("society_id"),
			);

			if(!empty($bankAccountId)){
                $bankAccountUpdateData = $this->bank_account_model->getBankAccountData(array(
                    'bank_account_id' => $bankAccountId,
                ));
                $bankAccountUpdateArray = compareArray($bankAccountArray,$bankAccountUpdateData);
            }
			$bankAccountData = $this->bank_account_model->insertUpdateRecord($bankAccountArray, 'bank_account_id', 'tbl_bank_account', 1,'',array(),array(),$bankAccountUpdateArray);
			$lastBankAccountId = $bankAccountData['lastInsertedId'];
            $transactionStatus = $this->db->transComplete();
			if (isset($bankAccountId) && $bankAccountId != '') {
				if (($bankAccountData['success']) && ($transactionStatus == 1)) {
                    $response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.update_record'),lang('BankAccount.bank_account'));
				} else {
                    $response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.update_record_error'),lang('BankAccount.bank_account'));
				}
			} else {
				if (($bankAccountData['success']) && ($transactionStatus == 1)) {
                    $response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.create_record'),lang('BankAccount.bank_account'));
				} else {
                    $response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.create_record_error'),lang('BankAccount.bank_account'));
				}
			}
			echo json_encode($response);
			exit;
		}
	}
    public function changeStatus()
    {
        $bankAccountId = $this->request->getVar('bank_account_id');
        $status = $this->request->getVar('status');

        //$status         = ($status == 0) ? 1 : 0;
        $return = $this->bank_account_model->statusChange($bankAccountId,$status,'bank_account_id','tbl_bank_account');
        if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('BankAccount.bank_account'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('BankAccount.bank_account'));
        }
        echo json_encode($response);
        exit();
    }


    public function delete()
    {
        $this->db->transStart();
        $bankAccountId = $this->request->getVar('bank_account_id');
        $ids = is_array($bankAccountId) ? implode(',', $bankAccountId) : $bankAccountId;
        $bankAccountData = $this->bank_account_model->deleteRecord($bankAccountId);
        $transactionStatus = $this->db->transComplete();
        if (($bankAccountData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('BankAccount.bank_account'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang('BankAccount.bank_account'));
        }
        echo json_encode($response);
        exit;
    }

    public function getBankAccountDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page            = $this->request->getVar('page');
        $bankAccountId = $this->request->getVar('bank_account_id');

        $filterData = array(
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT,
            'is_active' => 1,
            'bank_account_id' => $bankAccountId,

        );
        echo $this->bank_account_model->getBankAccount($filterData);
    }

    public function excelExportBankAccount()
    {
        $fileName ='bank-account-' . DATETIMEFORMAT;
        $sheetName = 'Bank Account-' . DATEFORMAT;
        $excelHeaderName = 'Bank Account';
        $tableData = $this->getBankAccountListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            lang('BankAccount.bank_name'),
            lang('BankAccount.branch'),
            lang('BankAccount.bank_account_no'),
            lang('BankAccount.account_type'),
            lang('BankAccount.ifsc_code'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                $row["bank_name"],
                $row["branch"],
                $row["bank_account_no"],
                $row["bank_account_type"],
                $row["ifsc_code"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'G';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }
}
