<?php
namespace App\Controllers\Admin;
/**
 * Class Auth
 *
 * @property Ion_auth|Ion_auth_model $ion_auth      The ION Auth spark
 * @package  CodeIgniter-Ion-Auth
 * @author   Ben Edmunds <ben.edmunds@gmail.com>
 * @author   Benoit VRIGNAUD <benoit.vrignaud@zaclys.net>
 * @license  https://opensource.org/licenses/MIT	MIT License
 */
class Auth extends \CodeIgniter\Controller
{

	/**
	 *
	 * @var array
	 */
	public $data = [];

	/**
	 * Configuration
	 *
	 * @var \IonAuth\Config\IonAuth
	 */ 
	protected $configIonAuth;

	/**
	 * IonAuth library
	 *
	 * @var \IonAuth\Libraries\IonAuth
	 */
	protected $ionAuth;

	/**
	 * Session
	 *
	 * @var \CodeIgniter\Session\Session
	 */
	protected $session;

	/**
	 * Validation library
	 *
	 * @var \CodeIgniter\Validation\Validation
	 */
	protected $validation;

	/**
	 * Validation list template.
	 *
	 * @var string
	 * @see https://bcit-ci.github.io/CodeIgniter4/libraries/validation.html#configuration
	 */
	protected $validationListTemplate = 'list';

	/**
	 * Views folder
	 * Set it to 'auth' if your views files are in the standard application/Views/auth
	 *
	 * @var string
	 */
	protected $viewsFolder = 'App\Views\Auth';

	/**
	 * Constructor
	 *
	 * @return void
	 */
    public $tables = [];
    public $identityColumn;
	public function __construct()
	{
        $this->config = config('IonAuth');
		$this->ionAuth    = new \App\Libraries\IonAuth();
		$this->ionAuthModel    = new \App\Models\IonAuthModel();
		$this->dt_ci_template    = new \App\Libraries\Dt_ci_template();
        $this->dt_ci_acl    = new \App\Libraries\Dt_ci_acl();
		$this->validation = \Config\Services::validation();
		helper(['form', 'url','Dt_ci_site','Dt_ci_action_button_helper']);
		$this->configIonAuth = config('IonAuth');
		$this->session       = \Config\Services::session();
        $this->datatables    = new \App\Libraries\Datatables();
	    $this->dt_ci_file_upload    = new \App\Libraries\Dt_ci_file_upload();
        $this->resource_type_model = new \App\Models\ResourceTypeModel();
        $this->resource_model = new \App\Models\ResourceModel();
        $this->common_web_service_model = new \App\Models\CommonWebServiceModel();
        $this->db = \Config\Database::connect();
		if (! empty($this->configIonAuth->templates['errors']['list']))
		{
			$this->validationListTemplate = $this->configIonAuth->templates['errors']['list'];
		}
        // initialize db tables data
        $this->tables = $this->config->tables;
        // initialize data
        $this->identityColumn = $this->config->identity;
        $this->data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/forms-selects.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "vendor/libs/select2/select2.js",
            "js/additional_methods.min.js"
        );
	}

	/**
	 * Redirect if needed, otherwise display the user list
	 *
	 * @return string|\CodeIgniter\HTTP\RedirectResponse
	 */
	public function index()
	{
		if (! $this->ionAuth->loggedIn())
		{
			// redirect them to the login page
			return redirect()->to('/Admin/Auth/login');
		}
        //		else if (! $this->ionAuth->isAdmin()) // remove this elseif if you want to enable this for non-admins
        //		{
        //
        //			// redirect them to the home page because they must be an administrator to view this
        //			//show_error('You must be an administrator to view this page.');
        //			throw new \Exception('You must be an administrator to view this page.');
        //		}
		else
		{
            if(!$this->dt_ci_acl->checkAccess('Auth|index')){
                $data['assets'] = base_url() . 'assets/';
                echo view('errors/custom/no_permission', $data);
                exit;
            }


			$this->data['title'] = lang('Auth.index_heading');

			// set the flash data error message if there is one
			$this->data['message'] = $this->validation->getErrors() ? $this->validation->listErrors($this->validationListTemplate) : $this->session->getFlashdata('message');
			//list the users
			//          $this->data['users'] = $this->ionAuth->users()->result();
            //			foreach ($this->data['users'] as $k => $user)
            //			{
            //				$this->data['users'][$k]->groups = $this->ionAuth->getUsersGroups($user->id)->getResult();
            //			}
			//return $this->renderPage($this->viewsFolder . DIRECTORY_SEPARATOR . 'index', $this->data);
            $this->renderPage('Admin/Auth/ManageUsersView', $this->data,'Manage Users',false, 'Admin');

		}
	}

    public function getUsersListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $this->datatables->table(MASTER_DB.".tbl_users as tu");
        $this->datatables->select("tu.id,COALESCE(tus.first_name, '') as first_name,COALESCE(tus.last_name,'') as last_name,tu.email,tu.active");
        // $this->datatables->select("srtv.full_name as first_name");
        
        $this->datatables->select("GROUP_CONCAT(distinct(tg.name) SEPARATOR ', ') as group_name");
        $this->datatables->join(MASTER_DB.'.tbl_users_groups as tug','tug.user_id = tu.id','left');
        $this->datatables->join(MASTER_DB.'.tbl_user_society as tus','tus.user_id = tu.id','left');

        // $this->datatables->join('society_user_master_view as srtv','srtv.user_id = tu.id AND srtv.society_id = tus.society_id','left');
        // $this->datatables->join('tbl_ownership_flat_member as tofm','tofm.member_id = tus.type_id and srtv.society_id = tus.society_id','left');
        // $this->datatables->join('tbl_resource as tr','tr.resource_id = tus.type_id and tr.society_id = tus.society_id','left');
        $this->datatables->join(MASTER_DB.'.tbl_groups as tg','tg.id = tug.group_id','left');
        // $this->datatables->where('tu.user_type = "admin"');

        $isSuperAdmin = session('is_super_admin');

        if (!$isSuperAdmin) {
            accessFilter($this->datatables, array("society" => "tus.society_id"));
            
        } else {
            // For SuperAdmin, show only superadmin groups (assume society_id is NULL or 0)
            $this->datatables->where("tus.is_super_admin", 1); // adjust if your default is NULL or something else
        }

        $this->datatables->groupBy("tu.id");

        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "user_id" => isset($displayData['id']) ? $displayData['id'] : "",
                    "is_super_admin" => isset($isSuperAdmin) ? $isSuperAdmin : 0,
                );
                $data[$key]['action_button'] = userActionButton($actionButtonFilter);
            }
        }

        //printArray($data,1);
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }

    public function changeStatus(){
        $id = $this->request->getVar('user_id');
        $status = $this->request->getVar('status');
//        $status         = ($status == 0) ? 1 : 0;
        $return = $this->ionAuth->changeStatus($id, $status);
        if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('Auth.user'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('Auth.user'));
        }
        echo json_encode($response);
        exit;
    }

	/**
	 * Log the user in
	 *
	 * @return string|\CodeIgniter\HTTP\RedirectResponse
	 */
	public function login()
	{
        $userId = $this->ionAuth->getUserId();
        if($userId != ''){
            return redirect()->to('/Admin/Dashboard');
        }

        $currentPath = $this->request->getPath(); 
        // printArray($currentPath);
        $isSuperAdminRoute = stripos($currentPath, 'SuperAdmin') !== false;
        // printArray($isSuperAdminRoute,1);

        if ($isSuperAdminRoute) {
            // printArray("hii");
            $this->session->set('is_super_admin', 1);
        } else {
            // printArray("Bye");
            $this->session->set('is_super_admin', 0);
        }

        // printArray($isSuperAdminRoute,1);
		if ($currentPath == 'SuperAdmin') {
            $title = lang('Auth.super_admin_login_heading');
		    $this->data['title'] = lang('Auth.super_admin_login_heading');
		    $this->data['is_superadmin'] = true;
		} else {
            $title = lang('Auth.login_heading');
		    $this->data['title'] = lang('Auth.login_heading');
		    $this->data['is_superadmin'] = false;
		}
		// $this->data['title'] = lang('Auth.login_heading');

		// validate form input
		$this->validation->setRule('identity', str_replace(':', '', lang('Auth.login_identity_label')), 'required');
		$this->validation->setRule('password', str_replace(':', '', lang('Auth.login_password_label')), 'required');

		if ($this->request->getPost() && $this->validation->withRequest($this->request)->run())
		{
			// check to see if the user is logging in
			// check for "remember me"
			$remember = (bool)$this->request->getVar('remember');
            $loginData = $this->ionAuth->login($this->request->getVar('identity'), $this->request->getVar('password'), $remember);

            // printArray($loginData,1);
            if ($loginData)
			{
                if ($isSuperAdminRoute == 1) {

                    $emailId = $this->session->get('email');
                    $userId = $this->session->get('userId');

                    if (isset($userId) && $userId != '' && isset($emailId) && $emailId != '') {

                        $builder = $this->db->table($this->tables['users']);
                        $query   = $builder
                            ->select('email, id, password, active, last_login')
                            ->where('email', $emailId)
                            ->limit(1)
                            ->orderBy('id', 'desc')
                            ->get();
                        $user = $query->getRow();                        
                        if ($user) {
                            // printArray($user,1);
                            $loginToken = md5(time());
                            $user->loginToken = $loginToken;

                            $this->ionAuth->setSession($user);

                            // set society_id if passed
                            $societyId = $this->request->getVar('society_id');
                            if ($societyId) {
                                $this->session->set('society_id', $societyId);
                            }
                            $this->ionAuth->updateLastLogin($user->id, $loginToken);
                            $this->session->setFlashdata('message', lang('CommonMessage.login_successfully'));

                            return redirect()->to('/SuperAdmin/Dashboard');
                            // return redirect()->back();
                        }
                    }
                }
				//if the login is successful
				//redirect them back to the home page
                else{
                    if($loginData->is_society_count == 1){
                        $this->session->setFlashdata('message', $this->ionAuth->messages());
                        return redirect()->to('Admin/Dashboard');
                    } else {
                        $this->session->setFlashdata('message', $this->ionAuth->messages());
                        return redirect()->to('Admin/Auth/user_society');
                    }
                }
			}
			else
			{
				// if the login was un-successful
				// redirect them back to the login page
				$this->session->setFlashdata('message', $this->ionAuth->errors($this->validationListTemplate));
				// use redirects instead of loading views for compatibility with MY_Controller libraries
				return redirect()->back()->withInput();
			}
		}
		else
		{
			// the user is not logging in so display the login page
			// set the flash data error message if there is one
			$this->data['message'] = $this->validation->getErrors() ? $this->validation->listErrors($this->validationListTemplate) : $this->session->getFlashdata('message');

//			$this->data['identity'] = [
//				'name'  => 'identity',
//				'id'    => 'identity',
//				'type'  => 'text',
//				'value' => set_value('identity'),
//			];
//
//			$this->data['password'] = [
//				'name' => 'password',
//				'id'   => 'password',
//				'type' => 'password',
//			];
//            echo $this->viewsFolder . DIRECTORY_SEPARATOR . 'login';
//            die();
			//return $this->renderPage($this->viewsFolder . DIRECTORY_SEPARATOR . 'login', $this->data);
            $this->renderPage('/Admin/Auth/LoginView', $this->data,$title);
           // return $this->dt_ci_template->load("auth","auth/login",$this->data);
		}
	}


    //Select User Society Function
    public function user_society()
    {
        /// Check user not login to redirect login page
        $emailId = $this->session->get('email');
        $userId = $this->session->get('userId');

        if (!isset($emailId) && !isset($userId)) {
            return redirect()->to('/Admin/Auth/login');
        }
        /// Check user already login to not display this function
        //        $userId = $this->ionAuth->getUserId();
        //        if ($userId != '') {
        //            return redirect()->to('/Admin/Auth/Dashboard');
        //        }

        $this->data['title'] = "Society";
        $this->validation->setRule('society_id', 'society', 'required');
        $societyId = $this->ionAuthModel->userSociety(array(
            "user_id" => $this->session->get('userId'),
            "is_multiple" => 1
        ));

        $societyIdArray = array();
        if(!empty($societyId)){
            foreach ($societyId as $societyElement){
                array_push($societyIdArray,$societyElement['society_id']);
            }
        }

        $this->data['user_society_data'] = $this->ionAuthModel->userSocietyIdName(array_filter($societyIdArray));


        if ( $this->request->getPost() && $this->validation->withRequest($this->request)->run() == true){
            $userActiveSocietyId = array();
            if (!empty($this->data['user_society_data'])) {
                $userActiveSocietyId = array_column($this->data['user_society_data'], 'society_id');
            }

            $inputSocietyId = $this->request->getVar('society_id');

            if (!in_array($inputSocietyId, $userActiveSocietyId)) {
                return redirect()->to('/Admin/Auth/login');
            }

            $emailId = $this->session->get('email');
            $userId = $this->session->get('userId');

            if (isset($userId) && $userId != '' && isset($emailId) && $emailId != '') {
                //User login and session create code
                $builder = $this->db->table($this->tables['users']);
                $query   = $builder
                    ->select( 'email, id, password, active, last_login')
                    ->where('email', $emailId)
                    ->limit(1)
                    ->orderBy('id', 'desc')
                    ->get();
                $user = $query->getRow();

                $loginToken = md5(time());
                $user->loginToken = $loginToken;

                $this->ionAuth->setSession($user);

                $userSocietyData = $this->ionAuthModel->userSociety(array(
                    "user_id" => $this->session->get('userId'),
                    "society_id" => $this->request->getVar('society_id'),
                    "is_multiple" => 1
                ));

                $this->session->set('society_id', $this->request->getVar('society_id'));
                $this->session->set('user_society_id',$userSocietyData[0]['user_society_id']);
                $this->session->set('user_name',$userSocietyData[0]['first_name']." ".$userSocietyData[0]['last_name']);

                $this->ionAuth->updateLastLogin($user->id, $loginToken);

                // if the User Company was successful
                // redirect them back to the login page
                $this->session->setFlashdata('message', lang('CommonMessage.login_successfully'));
                return redirect()->to('/Admin/Dashboard');// use redirects instead of loading views for compatibility with MY_Controller libraries

            } else {
                // if the User Society was un-successful
                // redirect them back to the OTP Page
                $this->session->setFlashdata('message', "Select Society is invalid");
                return redirect()->to('/Admin/Auth/user_society');// use redirects instead of loading views for compatibility with MY_Controller libraries
            }
        } else {
            // the user is not logging in so display the login page
            // set the flash data error message if there is one
            $this->data['message'] = $this->validation->getErrors() ? $this->validation->listErrors($this->validationListTemplate) : $this->session->getFlashdata('message');
            $this->renderPage('/Admin/Auth/UserSocietyView', $this->data,'Society');
        }
    }


    /**
	 * Log the user out
	 *
	 * @return \CodeIgniter\HTTP\RedirectResponse
	 */
	public function logout()
	{
		$this->data['title'] = 'Logout';
        $isSuperAdmin = $this->session->get('is_super_admin');
		// log the user out
		$this->ionAuth->logout();

		// redirect them to the login page
		$this->session->setFlashdata('message', $this->ionAuth->messages());
//		$this->session->setFlashdata('message','sdsd');
		if ($isSuperAdmin) {
            return redirect()->to('/SuperAdmin')->withCookies();
        } else {
            return redirect()->to('/Admin/Auth/login')->withCookies();
        }
	}

	/**
	 * Change password
	 *
	 * @return string|\CodeIgniter\HTTP\RedirectResponse
	 */
	public function change_password()
	{
		if (! $this->ionAuth->loggedIn())
		{
			return redirect()->to('/Admin/Auth/login');
		}
		
		$this->validation->setRule('old', lang('Auth.change_password_validation_old_password_label'), 'required');
		$this->validation->setRule('new', lang('Auth.change_password_validation_new_password_label'), 'required|min_length[' . $this->configIonAuth->minPasswordLength . ']|matches[new_confirm]');
		$this->validation->setRule('new_confirm', lang('Auth.change_password_validation_new_password_confirm_label'), 'required');

		$user = $this->ionAuth->user()->row();

		//if (! $this->request->getPost() || $this->validation->withRequest($this->request)->run() === false)
		if ( $this->validation->withRequest($this->request)->run() === false)
		{
			// display the form
			// set the flash data error message if there is one
			$this->data['message'] = ($this->validation->getErrors()) ? $this->validation->listErrors($this->validationListTemplate) : $this->session->getFlashdata('message');

			$this->data['minPasswordLength'] = $this->configIonAuth->minPasswordLength;
			$this->data['maxPasswordLength'] = $this->configIonAuth->maxPasswordLength;
            //			$this->data['old_password'] = [
            //				'name' => 'old',
            //				'id'   => 'old',
            //				'type' => 'password',
            //			];
            //			$this->data['new_password'] = [
            //				'name'    => 'new',
            //				'id'      => 'new',
            //				'type'    => 'password',
            //				'pattern' => '^.{' . $this->data['minPasswordLength'] . '}.*$',
            //			];
            //			$this->data['new_password_confirm'] = [
            //				'name'    => 'new_confirm',
            //				'id'      => 'new_confirm',
            //				'type'    => 'password',
            //				'pattern' => '^.{' . $this->data['minPasswordLength'] . '}.*$',
            //			];
            //			$this->data['user_id'] = [
            //				'name'  => 'user_id',
            //				'id'    => 'user_id',
            //				'type'  => 'hidden',
            //				'value' => $user->id,
            //			];
            $this->data['user_id'] = $user->id;
			// render
			//return $this->renderPage($this->viewsFolder . DIRECTORY_SEPARATOR . 'change_password', $this->data);
            $this->renderPage('/Admin/Auth/ChangePasswordView', $this->data,'Change Password', false, 'Admin');

		}
		else
		{
			$identity = $this->session->get('identity');

			$change = $this->ionAuth->changePassword($identity, $this->request->getPost('old'), $this->request->getPost('new'));

			if ($change)
			{
				//if the password was successfully changed
                $response['success'] = true;
                $response['msg'] =  strip_tags($this->ionAuth->messages());
                echo json_encode($response);

                $this->session->setFlashdata('message', $this->ionAuth->messages());
				//return $this->logout();
				$this->logout();
                exit;
			}
			else
			{
                $response['success']=false;
                $response['msg'] = strip_tags($this->ionAuth->errors($this->validationListTemplate));
                echo json_encode($response);
				$this->session->setFlashdata('message', $this->ionAuth->errors($this->validationListTemplate));
				return redirect()->to('/Admin/Auth/change_password');
			}
		}
	}

	/**
	 * Forgot password
	 *
	 * @return string|\CodeIgniter\HTTP\RedirectResponse
	 */
	public function forgot_password()
	{
		$this->data['title'] = lang('Auth.forgot_password_heading');

		// setting validation rules by checking whether identity is username or email
		if ($this->configIonAuth->identity !== 'email')
		{
			$this->validation->setRule('identity', lang('Auth.forgot_password_identity_label'), 'required');
		}
		else
		{
			$this->validation->setRule('identity', lang('Auth.forgot_password_validation_email_label'), 'required|valid_email');
		}

		if (! ($this->request->getPost() && $this->validation->withRequest($this->request)->run()))
		{
			$this->data['type'] = $this->configIonAuth->identity;
			// setup the input
            //			$this->data['identity'] = [
            //				'name' => 'identity',
            //				'id'   => 'identity',
            //			];

			if ($this->configIonAuth->identity !== 'email')
			{
				$this->data['identity_label'] = lang('Auth.forgot_password_identity_label');
			}
			else
			{
				$this->data['identity_label'] = lang('Auth.forgot_password_email_identity_label');
			}

			// set any errors and display the form
			$this->data['message'] = $this->validation->getErrors() ? $this->validation->listErrors($this->validationListTemplate) : $this->session->getFlashdata('message');
			//return $this->renderPage($this->viewsFolder . DIRECTORY_SEPARATOR . 'forgot_password', $this->data);
            return $this->renderPage('Admin/Auth/ForgotPasswordView', $this->data,'Forgot Password', false, 'Auth');
		}
		else
		{
			$identityColumn = $this->configIonAuth->identity;
			$identity = $this->ionAuth->where($identityColumn, $this->request->getPost('identity'))->users()->row();

			if (empty($identity))
			{
				if ($this->configIonAuth->identity !== 'email')
				{
					$this->ionAuth->setError('Auth.forgot_password_identity_not_found');
				}
				else
				{
					$this->ionAuth->setError('Auth.forgot_password_email_not_found');
				}

				$this->session->setFlashdata('message', $this->ionAuth->errors($this->validationListTemplate));
				return redirect()->to('/Admin/Auth/forgot_password');
			}

			// run the forgotten password method to email an activation code to the user
			$forgotten = $this->ionAuth->forgottenPassword($identity->{$this->configIonAuth->identity});

			if ($forgotten)
			{
				// if there were no errors
				$this->session->setFlashdata('message', $this->ionAuth->messages());
				return redirect()->to('/Admin/Auth/login'); //we should display a confirmation page here instead of the login page
			}
			else
			{
				$this->session->setFlashdata('message', $this->ionAuth->errors($this->validationListTemplate));
				return redirect()->to('/Admin/Auth/forgot_password');
			}
		}
	}

	/**
	 * Reset password - final step for forgotten password
	 *
	 * @param string|null $code The reset code
	 *
	 * @return string|\CodeIgniter\HTTP\RedirectResponse
	 */
	public function reset_password($code = null)
	{
		if (! $code)
		{
			throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
		}

		$this->data['title'] = lang('Auth.reset_password_heading');

		$user = $this->ionAuth->forgottenPasswordCheck($code);

		if ($user)
		{
			// if the code is valid then display the password reset form

			$this->validation->setRule('new', lang('Auth.reset_password_validation_new_password_label'), 'required|min_length[' . $this->configIonAuth->minPasswordLength . ']|matches[new_confirm]');
			$this->validation->setRule('new_confirm', lang('Auth.reset_password_validation_new_password_confirm_label'), 'required');

			if (! $this->request->getPost() || $this->validation->withRequest($this->request)->run() === false)
			{
				// display the form

				// set the flash data error message if there is one
				$this->data['message'] = $this->validation->getErrors() ? $this->validation->listErrors($this->validationListTemplate) : $this->session->getFlashdata('message');

				$this->data['minPasswordLength'] = $this->configIonAuth->minPasswordLength;
				$this->data['maxPasswordLength'] = $this->configIonAuth->maxPasswordLength;
                //				$this->data['new_password'] = [
                //					'name'    => 'new',
                //					'id'      => 'new',
                //					'type'    => 'password',
                //					'pattern' => '^.{' . $this->data['minPasswordLength'] . '}.*$',
                //				];
                //				$this->data['new_password_confirm'] = [
                //					'name'    => 'new_confirm',
                //					'id'      => 'new_confirm',
                //					'type'    => 'password',
                //					'pattern' => '^.{' . $this->data['minPasswordLength'] . '}.*$',
                //				];
                //				$this->data['user_id'] = [
                //					'name'  => 'user_id',
                //					'id'    => 'user_id',
                //					'type'  => 'hidden',
                //					'value' => $user->id,
                //				];
                $this->data['user_id'] = $user->id;
				$this->data['code'] = $code;
                $this->data['email'] = $user->email;

				// render
				//return $this->renderPage($this->viewsFolder . DIRECTORY_SEPARATOR . 'reset_password', $this->data);
                return $this->renderPage('Admin/Auth/ResetPasswordView', $this->data,'Reset Password',false, 'Auth');
			}
			else
			{
				$identity = $user->{$this->configIonAuth->identity};

				// do we have a valid request?
				if ($user->id != $this->request->getPost('user_id'))
				{
					// something fishy might be up
					$this->ionAuth->clearForgottenPasswordCode($identity);

					throw new \Exception(lang('Auth.error_security'));
				}
				else
				{
					// finally change the password
					$change = $this->ionAuth->resetPassword($identity, $this->request->getPost('new'));

					if ($change)
					{
                      //  printArray($change,1);
						// if the password was successfully changed
						$this->session->setFlashdata('message', $this->ionAuth->messages());
						return redirect()->to('/Admin/Auth/login');
                        //admin_redirect("auth/login", 'refresh');
					}
					else
					{
						$this->session->setFlashdata('message', $this->ionAuth->errors($this->validationListTemplate));
						return redirect()->to('/Admin/Auth/reset_password/' . $code);
					}
				}
			}
		}
		else
		{
			// if the code is invalid then send them back to the forgot password page
			$this->session->setFlashdata('message', $this->ionAuth->errors($this->validationListTemplate));
			return redirect()->to('/Admin/Auth/forgot_password');
		}
	}

	/**
	 * Activate the user
	 *
	 * @param integer $id   The user ID
	 * @param string  $code The activation code
	 *
	 * @return \CodeIgniter\HTTP\RedirectResponse
	 */
	public function activate(int $id, string $code = ''): \CodeIgniter\HTTP\RedirectResponse
	{
		$activation = false;

		if ($code)
		{
			$activation = $this->ionAuth->activate($id, $code);
		}
		else if ($this->ionAuth->isAdmin())
		{
			$activation = $this->ionAuth->activate($id);
		}

		if ($activation)
		{
			// redirect them to the auth page
			$this->session->setFlashdata('message', $this->ionAuth->messages());
			return redirect()->to('/Admin/auth');
		}
		else
		{
			// redirect them to the forgot password page
			$this->session->setFlashdata('message', $this->ionAuth->errors($this->validationListTemplate));
			return redirect()->to('/Admin/Auth/forgot_password');
		}
	}

	/**
	 * Deactivate the user
	 *
	 * @param integer $id The user ID
	 *
	 * @throw Exception
	 *
	 * @return string|\CodeIgniter\HTTP\RedirectResponse
	 */
	public function deactivate(int $id = 0)
	{
		if (! $this->ionAuth->loggedIn() || ! $this->ionAuth->isAdmin())
		{
			// redirect them to the home page because they must be an administrator to view this
			throw new \Exception('You must be an administrator to view this page.');
			// TODO : I think it could be nice to have a dedicated exception like '\IonAuth\Exception\NotAllowed
		}

		$this->validation->setRule('confirm', lang('Auth.deactivate_validation_confirm_label'), 'required');
		$this->validation->setRule('id', lang('Auth.deactivate_validation_user_id_label'), 'required|integer');

		if (! $this->validation->withRequest($this->request)->run())
		{
			$this->data['user'] = $this->ionAuth->user($id)->row();
			return $this->renderPage($this->viewsFolder . DIRECTORY_SEPARATOR . 'deactivate_user', $this->data);
		}
		else
		{
			// do we really want to deactivate?
			if ($this->request->getPost('confirm') === 'yes')
			{
				// do we have a valid request?
				if ($id !== $this->request->getPost('id', FILTER_VALIDATE_INT))
				{
					throw new \Exception(lang('Auth.error_security'));
				}

				// do we have the right userlevel?
				if ($this->ionAuth->loggedIn() && $this->ionAuth->isAdmin())
				{
					$message = $this->ionAuth->deactivate($id) ? $this->ionAuth->messages() : $this->ionAuth->errors($this->validationListTemplate);
					$this->session->setFlashdata('message', $message);
				}
			}

			// redirect them back to the auth page
			return redirect()->to('/Admin/auth');
		}
	}

	/**
	 * Create a new user
	 *
	 * @return string|\CodeIgniter\HTTP\RedirectResponse
	 */
    public function edit_user($id = 0)
    {
        $isSuperAdmin = $this->session->get("is_super_admin");

        if(!$this->dt_ci_acl->checkAccess('Auth|edit_user')){
            $data['assets'] = base_url() . 'assets/';
            echo view('errors/custom/no_permission', $data);
            exit;
        }

        if ($id != 0) {
            $this->data['title'] = lang('Auth.edit_user_heading');
            $user = $this->ionAuth->getUserData(array('id' => $id));
            $currentGroups = array();
            $userGroupData = [];
            if(empty($isSuperAdmin)){
                $groups = $this->ionAuth->getGroupData(array('society_id'=>$this->session->get("society_id"),'is_multiple' => 1));
                $currentGroups = $this->ionAuth->getUsersGroups($id)->getResult();
            }
            else{
                $groups = $this->ionAuth->getGroupData(array('is_super_admin_group'=>1,'is_multiple' => 1));
                $userGroupDataArray = $this->ionAuth->getUserGroupData(array("user_id" =>  $id,"is_multiple" => 1));

                foreach ($userGroupDataArray as $userGroupDataElement) {
                    $sid = $userGroupDataElement['society_id'];

                    if (!isset($userGroupData[$sid])) {
                        $userGroupData[$sid] = [
                            'society_id' => $sid,
                            'user_society_group_id' => $userGroupDataElement['user_society_id'],
                            'user_group_id' => $userGroupDataElement['id'],
                            'society_name' => $userGroupDataElement['society_name'],
                            'group_user_id' => []
                        ];
                    }

                    $userGroupData[$sid]['group_user_id'][] = $userGroupDataElement['group_id'];
                }
            }
            // pass the user to the view
            $this->data['user'] = $user;
            $this->data['groups'] = $groups;
            $this->data['currentGroups'] = $currentGroups;
            $this->data['user_group_data'] = $userGroupData;
            $this->data['ionAuth'] = $this->ionAuth;
            // $currentUserSociety = $this->ionAuth->userSociety(array('user_id'=>$id,'is_multiple' => 1));
            // $currentUserSocietyId = !empty($currentUserSociety) ? array_column($currentUserSociety,"society_id"): array();
        } else {
            if(empty($isSuperAdmin)){
                $groups = $this->ionAuth->getGroupData(array('society_id'=>$this->session->get("society_id"),'is_multiple' => 1));
            }
            else{
                $groups = $this->ionAuth->getGroupData(array('is_super_admin_group'=>1,'is_multiple' => 1));
            }
            $this->data['groups'] = $groups;
            $this->data['currentGroups'] = array();
            $this->data['title'] = lang('Auth.create_user_heading');
            $this->data['user'] = array();
            // $currentUserSocietyId = array();
        }
        // $this->data['userSociety'] = $currentUserSocietyId;

        //if (!$this->ionAuth->loggedIn() || !$this->ionAuth->isAdmin()) {
        if (!$this->ionAuth->loggedIn()) {
            return redirect()->to('/Admin/Auth');
        }

        $tables = $this->configIonAuth->tables;
        $identityColumn = $this->configIonAuth->identity;
        $this->data['identity_column'] = $identityColumn;

        

        // validate form input
        $this->validation->setRule('first_name', lang('Auth.create_user_validation_fname_label'), 'trim|required');
        $this->validation->setRule('last_name', lang('Auth.create_user_validation_lname_label'), 'trim|required');
        $this->validation->setRule('phone', lang('Auth.create_user_validation_phone_label'), 'trim');
        // $this->validation->setRule('society_id.*', lang('Auth.society'), 'required');
        if ($id == 0) {
            if ($identityColumn !== 'email') {
                $this->validation->setRule('identity', lang('Auth.create_user_validation_identity_label'), 'trim|required|is_unique[' . $tables['users'] . '.' . $identityColumn . ']');
                $this->validation->setRule('email', lang('Auth.create_user_validation_email_label'), 'trim|required|valid_email');
            } else {
                $this->validation->setRule('email', lang('Auth.create_user_validation_email_label'), 'trim|required|valid_email|is_unique[' . $tables['users'] . '.email]');
            }

            $this->validation->setRule('password', lang('Auth.create_user_validation_password_label'), 'required|min_length[' . $this->configIonAuth->minPasswordLength . ']|matches[password_confirm]');
            $this->validation->setRule('password_confirm', lang('Auth.create_user_validation_password_confirm_label'), 'required');
        } else {
            // update the password if it was posted
            if ($this->request->getPost('password'))
            {
                $this->validation->setRule('password', lang('Auth.edit_user_validation_password_label'), 'required|min_length[' . $this->configIonAuth->minPasswordLength . ']|matches[password_confirm]');
                $this->validation->setRule('password_confirm', lang('Auth.edit_user_validation_password_confirm_label'), 'required');
            }
        }

        //$this->validation->setRule('company', lang('Auth.create_user_validation_company_label'), 'trim');
        $imageResult = array();
        if (isset($_FILES['user_image'])) {
			$userImagePath = USER_IMAGE_PATH;
			$imageResult  = $this->dt_ci_file_upload->UploadFile('user_image', MAX_IMAGE_SIZE_LIMIT, $userImagePath, true, true, array('jpeg', 'png', 'jpg', 'JPG'));
			if(!empty($id)){
				$userData = $this->common_web_service_model->getUserData(array("id" => $id));
				if($userData['user_image'] != '' && file_exists(USER_IMAGE_PATH . $userData['user_image'])){
					unlink(USER_IMAGE_PATH.$userData['user_image']);
				}
				if($userData['user_image'] != '' && file_exists(THUMBNAIL_USER_IMAGE_PATH . $userData['user_image'])){
					unlink(THUMBNAIL_USER_IMAGE_PATH.$userData['user_image']);
				}
			}
			if ($imageResult['success'] == false) {
				$response['success']    = false;
				$response['msg']        = strip_tags($imageResult['message']);
				echo json_encode($response);
				die();
			} else {
				unset($imageResult['success']);
            	$thumbnailResult =  $this->dt_ci_file_upload->ThumbnailUploadFile($imageResult, USER_IMAGE_PATH, THUMBNAIL_USER_IMAGE_PATH);
            }
        }

        if(empty($isSuperAdmin)){

            $resourceTypeData = $this->resource_type_model->getResourceTypeData(array(
                'resource_type_name' => RESOURCE_TYPE_MANAGER,
            ));
            if(!empty($resourceTypeData)){
    			$resourceTypeId = $resourceTypeData['resource_type_id'];
            }
        }
        else{

            $groupIdArray = $this->request->getVar("group_user_id[]") ?? [];
            $societyIdArray = $this->request->getVar("user_group_society_id") ?? [];
            $userGroupIdArray = $this->request->getVar("user_group_id") ?? [];

            $validationResponseUserGroupMessage = '';
            $societyCheckList = [];
            $key = 0;
            foreach ($userGroupIdArray as $cpKey => $value) {
                $key++;
                $societyId = isset($societyIdArray[$cpKey]) ? $societyIdArray[$cpKey] : '';
                $groupIds  = isset($groupIdArray[$cpKey]) ? $groupIdArray[$cpKey] : [];

                // Check for duplicate society
                if (!empty($societyId)) {
                    if (in_array($societyId, $societyCheckList)) {
                        $validationResponseUserGroupMessage .= "ROW " . ($key) . " - Society is already selected in another row. Duplicate societies are not allowed.\n";
                    } else {
                        $societyCheckList[] = $societyId;
                    }
                }

                // Check for society + group validation
                if (!empty($societyId) && empty($groupIds)) {
                    $validationResponseUserGroupMessage .= "ROW " . ($key) . " - Please select at least one group for the selected society.\n";
                } 
            }

            if ($validationResponseUserGroupMessage != "") {
                $response['success'] = false;
                $response['msg'] = $validationResponseUserGroupMessage;
                echo json_encode($response);
                exit;
            }
            $resourceTypeId = 0;
        }

        //$this->validation->setRule('company', lang('Auth.create_user_validation_company_label'), 'trim');
        // printArray($imageResult,1);

        if ($id == 0) {
            if ($this->request->getPost()) {
                if ($this->request->getPost() && $this->validation->withRequest($this->request)->run()) {
                    $email = strtolower($this->request->getPost('email'));
                    $identity = ($identityColumn === 'email') ? $email : $this->request->getPost('identity');
                    $password = $this->request->getPost('password');
                    $groupIdArray = $this->request->getVar("group_user_id[]");
                    $societyIdArray = $this->request->getVar("user_group_society_id");
                    $userGroupId = $this->request->getVar("user_group_id");

                    if(empty($isSuperAdmin)){
                        $resourceData = $this->resource_model->getResourceData(array(
    		                'resource_mobile_no' => $this->request->getPost('phone'),
    		                'society_id' => $this->session->get("society_id"),
    		            ));
    		            $userData = $this->common_web_service_model->getUserSocietyData(array(
    		                'phone' => $this->request->getPost('phone'),
    		                'society_id' => $this->session->get("society_id"),
    		            ));
    		            if((!empty($resourceData)) || (!empty($userData))){
    		                $response['success'] = false;
    		                $response['msg'] = lang("Resource.mobile_no_already_exist");
    		                echo json_encode($response);
    		                exit;
    		            }
                    }
                    else{
                        $userData = $this->common_web_service_model->getUserSocietyData(array(
                            'phone' => $this->request->getPost('phone'),
                            'is_super_admin' => 1,
                        ));
                        if((!empty($userData))){
                            $response['success'] = false;
                            $response['msg'] = lang("Resource.mobile_no_already_exist");
                            echo json_encode($response);
                            exit;
                        }
                    }
                    // $permissions = $this->request->getPost('permissions');
                    if(empty($isSuperAdmin)){
                        $additionalData = [
                            'first_name' => $this->request->getPost('first_name'),
                            'last_name' => $this->request->getPost('last_name'),
                            //'company'    => $this->request->getPost('company'),
                            'phone' => $this->request->getPost('phone'),
                            // 'permissions' => isset($permissions) ? serialize($permissions) : serialize(array()),
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s"),
                            'society_id' => $this->session->get('society_id'),
                            // 'user_type' => 'admin',
                            'user_image' => isset($imageResult['file_name']) ? ($imageResult['file_name']) : '',
                        ];
                    }
                    else{
                        $additionalData = [
                            'first_name' => $this->request->getPost('first_name'),
                            'last_name' => $this->request->getPost('last_name'),
                            //'company'    => $this->request->getPost('company'),
                            'phone' => $this->request->getPost('phone'),
                            // 'permissions' => isset($permissions) ? serialize($permissions) : serialize(array()),
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s"),
                            'society_id' => $societyIdArray,
                            // 'user_type' => 'admin',
                            'user_image' => isset($imageResult['file_name']) ? ($imageResult['file_name']) : '',
                        ];
                    }
                } else {
                    $errors = $this->validation->getErrors();
                    $response['success'] = false;
                    $response['msg'] = implode("\n", $errors);
                    echo json_encode($response);
                    exit;
                }
            }

            if ($this->request->getPost()) {
                $groups =  $this->request->getPost('groups');
                // if ($this->validation->withRequest($this->request)->run() && $this->ionAuth->register($identity, $password, $email, $additionalData,$groups)) {
                if(empty($isSuperAdmin)){
               	    $userUpdate =  $this->ionAuth->register($identity, $password, $email, $additionalData,$groups,$resourceTypeId,0);
                }
                else{
                    // printArray($additionalData,1);
                    $userUpdate =  $this->ionAuth->register($identity, $password, $email, $additionalData,array(),$resourceTypeId,1);
                }
               	if($userUpdate){

	           		$userSocietyData = $this->common_web_service_model->getUserSocietyData(array(
	                    'user_id' => $userUpdate,
	                ));
	               	$groupDataArray = $this->common_web_service_model->getGroupsData([
					    'id' => $groups,
					    'is_multiple' => 1
					]);
                    if(empty($isSuperAdmin)){
    					$controllers_methods = $this->dt_ci_acl->getPermissableMethods();
    					if (!empty($groupDataArray)) {
    						$userGroupArray = [];
    					    foreach ($groupDataArray as $groupData) {
				    			$groupId = isset($groupData['id']) ? $groupData['id'] : '';
						        $permissions = isset($groupData['permissions']) ? $groupData['permissions'] : '';
						        $permissionArray = unserialize($permissions);

						        $userGroupArray[] = array(
				                    'id' => '',
				                    'user_id' => $userUpdate,
				                    'group_id' => $groupId,
				                    'user_society_id' => $userSocietyData['user_society_id'],
				                );
						        
						        $permissionLabel = [];

						        foreach ($controllers_methods as $controller_name => $methods_arr) {
						            foreach ($methods_arr as $method) {
						                $methodDisplay = is_array($method) ? reset($method) : $method;
						                $methodActual = is_array($method) ? key($method) : $method;

						                $inputName = $controller_name . "|" . $methodActual;
						                $permissionLabel[] = $inputName . "|dt|" . $controller_name . "|dt|" . $methodDisplay;
						            }
						        }

						        // Process permissions for this group
						        if (is_array($permissionLabel) && count($permissionLabel) > 0) {
						            $labelArray = [];
						            foreach ($permissionLabel as $labelData) {
						                list($permissionValue, $controller, $label) = explode("|dt|", $labelData);
						                if (in_array($permissionValue, $permissionArray)) {
						                    $labelArray[] = [
						                        'controller_name' => $controller,
						                        'permission_name' => $permissionValue,
						                        'permission_label' => $label,
						                        'user_id' => $userUpdate,
						                        'group_id' => $groupId,
						                        'user_society_id' => $userSocietyData['user_society_id'],
						                        'created_at' => date('Y-m-d H:i:s'),
						                        'created_by' => $this->session->get('user_id'),
						                        'updated_at' => date('Y-m-d H:i:s'),
						                        'updated_by' => $this->session->get('user_id'),
						                    ];
						                }
						            }

						            if (!empty($labelArray)) {
						                $builder = $this->db->table(MASTER_DB.'.tbl_user_permission');
						                $builder->insertBatch($labelArray);
						            }
						        }
    					    }

    					    if (!empty($userGroupArray)) {
    			                $builder = $this->db->table(MASTER_DB.'.tbl_users_groups');
    			                $builder->insertBatch($userGroupArray);
    			            }
    					}
                    }
                    else{
                        $groupIdArray = $this->request->getVar("group_user_id[]") ?? [];
                        $societyIdArray = $this->request->getVar("user_group_society_id") ?? [];
                        $userGroupIdArray = $this->request->getVar("user_group_id") ?? [];
                        $userSocietyIdArray = $this->request->getVar("user_society_group_id") ?? [];
                        $id = $userUpdate;

                        $validationResponseUserGroupMessage = '';
                        $societyCheckList = [];
                        $key = 0;
                        foreach ($userGroupIdArray as $cpKey => $value) {
                            $key++;
                            $societyId = isset($societyIdArray[$cpKey]) ? $societyIdArray[$cpKey] : '';
                            $groupIds  = isset($groupIdArray[$cpKey]) ? $groupIdArray[$cpKey] : [];

                            // Check for duplicate society
                            if (!empty($societyId)) {
                                if (in_array($societyId, $societyCheckList)) {
                                    $validationResponseUserGroupMessage .= "ROW " . ($key) . " - Society is already selected in another row. Duplicate societies are not allowed.\n";
                                } else {
                                    $societyCheckList[] = $societyId;
                                }
                            }

                            // Check for society + group validation
                            if (!empty($societyId) && empty($groupIds)) {
                                $validationResponseUserGroupMessage .= "ROW " . ($key) . " - Please select at least one group for the selected society.\n";
                            } 
                        }

                        if ($validationResponseUserGroupMessage != "") {
                            $response['success'] = false;
                            $response['msg'] = $validationResponseUserGroupMessage;
                            echo json_encode($response);
                            exit;
                        }

                        $userSocietyArray= array();
                        if (isset($userSocietyIdArray) && !empty($userSocietyIdArray)) {
                            foreach ($userSocietyIdArray as $key => $userSocietyId) {
                                $societyId = array_key_exists($key, $societyIdArray) ? $societyIdArray[$key] : '';

                                $userSocietyArray[$key] = array(
                                    'user_society_id'  => (isset($userSocietyId)) ? $userSocietyId : '',
                                    'user_id'          => $id,
                                    'resource_type_id'  => 0,
                                    'phone'             => $this->request->getPost('phone'),
                                    'first_name'        => $this->request->getPost('first_name'),
                                    'last_name'         => $this->request->getPost('last_name'),
                                    'user_image' => isset($imageResult['file_name']) ? ($imageResult['file_name']) : '',
                                    'is_active' => 1,
                                    'is_super_admin'    => $isSuperAdmin,
                                    'type_id'           => $id,
                                    'is_active'         => 1,
                                    'society_id'        => $societyId,
                                    'created_at'        => date('Y-m-d H:i:s'),
                                    'created_by'        => $this->session->get('user_id'),
                                    'updated_at'        => date('Y-m-d H:i:s'),
                                    'updated_by'        => $this->session->get('user_id'),
                                );
                            }

                        }

                        if(!empty($userSocietyArray)){
                            $this->common_web_service_model->batchInsert($userSocietyArray, MASTER_DB.'.tbl_user_society');
                        }

                        $userSocietyData = $this->common_web_service_model->getUserSocietyData(array(
                            'id' => $id,
                            'is_super_admin' => 1,
                            'is_multiple' => 1,
                        ));

                        $userSocietyId = array_column($userSocietyData, 'user_society_id');
                        $controllers_methods = $this->dt_ci_acl->getPermissableMethods();

                        $userSocietyArray= array();
                        if (isset($userSocietyIdArray) && !empty($userSocietyIdArray)) {
                            foreach ($userSocietyIdArray as $key => $userSocietyId) {
                                $societyId = array_key_exists($key, $societyIdArray) ? $societyIdArray[$key] : '';
                                if (isset($groupIdArray) && !empty($groupIdArray)) {
                                    $groupIds = array_key_exists($key, $groupIdArray) ? $groupIdArray[$key] : 0;
                                }

                                if(!empty($groupIds)){
                                    foreach ($groupIds as $groupId) {
                                       
                                        $groupDataArray = $this->common_web_service_model->getGroupsData([
                                            'id' => $groupId,
                                            
                                        ]);

                                        $permissions = !empty($group['permissions']) ? unserialize($group['permissions']) : [];

                                        $userGroupArray[] = array(
                                            'id' => '',
                                            'user_id' => $userUpdate,
                                            'group_id' => $groupId,
                                            'user_society_id' => $userSocietyId,
                                            'society_id' => $societyId,
                                        );
                                        $permissionLabel = [];
                                        foreach ($controllers_methods as $controller_name => $methods_arr) {
                                            foreach ($methods_arr as $method) {
                                                $methodDisplay = is_array($method) ? reset($method) : $method;
                                                $methodActual = is_array($method) ? key($method) : $method;
                                                $inputName = $controller_name . "|" . $methodActual;
                                                $permissionLabel[] = $inputName . "|dt|" . $controller_name . "|dt|" . $methodDisplay;
                                            }
                                        }

                                        foreach ($permissionLabel as $labelData) {
                                            list($permissionValue, $controller, $label) = explode("|dt|", $labelData);
                                            if (in_array($permissionValue, $permissions)) {
                                                $labelArray[] = [
                                                    'controller_name' => $controller,
                                                    'permission_name' => $permissionValue,
                                                    'permission_label' => $label,
                                                    'user_id' => $id,
                                                    'group_id' => $groupId,
                                                    'user_society_id' => $userSocietyData['user_society_id'],
                                                    'created_at' => date('Y-m-d H:i:s'),
                                                    'created_by' => $this->session->get('user_id'),
                                                    'updated_at' => date('Y-m-d H:i:s'),
                                                    'updated_by' => $this->session->get('user_id'),
                                                ];
                                            }
                                        }
                                        if (!empty($labelArray)) {
                                            $builder = $this->db->table(MASTER_DB.'.tbl_user_permission');
                                            $builder->insertBatch($labelArray);
                                        }
                                    }
                                }

                                if (!empty($userGroupArray)) {
                                    $builder = $this->db->table(MASTER_DB.'.tbl_users_groups');
                                    $builder->insertBatch($userGroupArray);
                                }
                            }
                        }
                    }
                    // check to see if we are creating the user
                    // redirect them back to the admin page
                    // $this->session->setFlashdata('message', $this->ionAuth->messages());
                    $response['success'] = true;
                    $response['msg'] = $this->ionAuth->messages();
                    echo json_encode($response);
                    exit;
                    //return redirect()->to('/auth');
                } else {
                    //$errors = $this->validation->getErrors();
                    $errors = $this->validation->getErrors() ? $this->validation->listErrors($this->validationListTemplate) : ($this->ionAuth->errors($this->validationListTemplate) ? $this->ionAuth->errors($this->validationListTemplate) : $this->session->getFlashdata('message'));
                    $response['success'] = false;
                    $response['msg'] = implode("\n", $errors);
                    echo json_encode($response);
                    exit;
                }
            }
        }
        else {
        	
            if ($this->request->getPost()) {
                if ($this->validation->withRequest($this->request)->run()) {
                    if(empty($isSuperAdmin)){
                    	$resourceData = $this->resource_model->getResourceData(array(
    		                'resource_mobile_no' => $this->request->getPost('phone'),
    		                'society_id' => $this->session->get("society_id"),
    		            ));

    		            $userData = $this->common_web_service_model->getUserSocietyData(array(
    		                'phone' => $this->request->getPost('phone'),
    		                'society_id' => $this->session->get("society_id"),
    		                'user_society_id_not' => $this->request->getPost('user_society_id')
    		            ));

    		            if((!empty($resourceData)) || (!empty($userData))){
    		                $response['success'] = false;
    		                $response['msg'] = lang("Resource.mobile_no_already_exist");
    		                echo json_encode($response);
    		                exit;
    		            }
                    }
                    else{
                        $userData = $this->common_web_service_model->getUserSocietyData(array(
                            'phone' => $this->request->getPost('phone'),
                            'is_super_admin' => 1,
                            'user_id_not' => $id,
                        ));

                        if((!empty($userData))){
                            $response['success'] = false;
                            $response['msg'] = lang("Resource.mobile_no_already_exist");
                            echo json_encode($response);
                            exit;
                        }
                    }

                    // update the password if it was posted
                    if ($this->request->getPost('password')) {
                        $data['password'] = $this->request->getPost('password');
                    }
                    if(empty($isSuperAdmin)){
                        // Only allow updating groups if user is admin
                        if ($this->ionAuth->isAdmin()) {
                            // Update the groups user belongs to
                            $groupData = $this->request->getPost('groups');

                            if (!empty($groupData)) {
                                $this->ionAuth->removeFromGroup('', $id);

                                foreach ($groupData as $grp) {
                                    $this->ionAuth->addToGroup($grp, $id);
                                }
                            }
                        }
                    }

                    if (!empty($id)) {
                        $userData = $this->common_web_service_model->getUserData(array(
                            'id' => $id,
                            'active' => 1
                        ));

                        if(empty($isSuperAdmin)){
                            $userSocietyArray = array(
                                'user_society_id'  => $this->request->getPost('user_society_id'),
                                'user_id'          => $id,
                                'society_id'        => $this->session->get('society_id'),
                                'type_id'             => $id,
                                'resource_type_id'  => $resourceTypeId,
                                'phone'				=> $this->request->getPost('phone'),
    		                    'first_name'		=> $this->request->getPost('first_name'),
    		                    'last_name'		    => $this->request->getPost('last_name'),
    		                    'user_image' => isset($imageResult['file_name']) ? ($imageResult['file_name']) : '',
    		                    'is_active' => 1,
                                // 'permissions' => isset($permissions) ? serialize($permissions) : serialize(array()),
                                'created_at' 		=> date('Y-m-d H:i:s'),
                                'created_by' 		=> $this->session->get('user_id'),
                                'updated_at' 		=> date('Y-m-d H:i:s'),
                                'updated_by' 		=> $this->session->get('user_id'),
                            );
                            $builder = $this->db->table(MASTER_DB.'.tbl_user_society');
                            $builder->update($userSocietyArray, ['user_society_id' => $this->request->getPost('user_society_id')]);
                            $userPermissionDataArray = $this->common_web_service_model->getUserPermissionData(array(
                                'user_id' => $id,
                                'user_society_id' => $this->request->getPost('user_society_id'),
                                'is_multiple' => 1,
                            ));
                            if(!empty($userPermissionDataArray)){
                                $userPermissionIds = array_column($userPermissionDataArray, 'user_permission_id');
                                $this->common_web_service_model->deleteUserPermission($userPermissionIds);
                            }
                            $this->common_web_service_model->deleteUserGroups($this->request->getPost('user_society_id'));
                        
    		                $userGroupDataArray = $this->common_web_service_model->getUserGroupsData([
    						    'user_id' => $id,
    						    'is_multiple' => 1
    						]);
    						$groupIdArray = array_column($userGroupDataArray, 'group_id');
                            $groupDataArray = $this->common_web_service_model->getGroupsData([
    						    'id' => $groupIdArray,
    						    'is_multiple' => 1
    						]);
						    $controllers_methods = $this->dt_ci_acl->getPermissableMethods();
    						if (!empty($groupDataArray)) {
    							$userGroupArray = [];
    						    foreach ($groupDataArray as $groupData) {
					    			$groupId = isset($groupData['id']) ? $groupData['id'] : '';
							        $permissions = isset($groupData['permissions']) ? $groupData['permissions'] : '';
							        $permissionArray = unserialize($permissions);

							        $userGroupArray[] = array(
					                    'id' => '',
					                    'user_id' => $id,
					                    'group_id' => $groupId,
					                    'user_society_id' => $this->request->getPost('user_society_id'),
					                );
    								        
							        $permissionLabel = [];

							        foreach ($controllers_methods as $controller_name => $methods_arr) {
							            foreach ($methods_arr as $method) {
							                $methodDisplay = is_array($method) ? reset($method) : $method;
							                $methodActual = is_array($method) ? key($method) : $method;

							                $inputName = $controller_name . "|" . $methodActual;
							                $permissionLabel[] = $inputName . "|dt|" . $controller_name . "|dt|" . $methodDisplay;
							            }
							        }

							        // Process permissions for this group
							        if (is_array($permissionLabel) && count($permissionLabel) > 0) {
							            $labelArray = [];
							            foreach ($permissionLabel as $labelData) {
							                list($permissionValue, $controller, $label) = explode("|dt|", $labelData);
							                if (in_array($permissionValue, $permissionArray)) {
							                    $labelArray[] = [
							                        'controller_name' => $controller,
							                        'permission_name' => $permissionValue,
							                        'permission_label' => $label,
							                        'user_id' => $id,
							                        'group_id' => $groupId,
							                        'user_society_id' => $this->request->getPost('user_society_id'),
							                        'created_at' => date('Y-m-d H:i:s'),
							                        'created_by' => $this->session->get('user_id'),
							                        'updated_at' => date('Y-m-d H:i:s'),
							                        'updated_by' => $this->session->get('user_id'),
							                    ];
							                }
							            }

							            if (!empty($labelArray)) {
							                $builder = $this->db->table(MASTER_DB.'.tbl_user_permission');
							                $builder->insertBatch($labelArray);
							            }
							        }
    						    }
    						    if (!empty($userGroupArray)) {
    				                $builder = $this->db->table(MASTER_DB.'.tbl_users_groups');
    				                $builder->insertBatch($userGroupArray);
    				            }
    						}
                            else{
                                $groupIdArray = $this->request->getVar("group_user_id[]");
                                $societyIdArray = $this->request->getVar("user_group_society_id");
                                $userGroupId = $this->request->getVar("user_group_id");

                                $controllers_methods = $this->dt_ci_acl->getPermissableMethods();

                                foreach ($societyIdArray as $societyId) {
                                    $userGroupArray = [];

                                    foreach ($groupIdArray[$societyId] as $groupId) {
                                        $groupDataArray = $this->common_web_service_model->getGroupsData([
                                            'id' => $groupId,
                                            
                                        ]);
                                        $permissions = !empty($group['permissions']) ? unserialize($group['permissions']) : [];
                                        $userGroupArray[] = array(
                                            'id' => '',
                                            'user_id' => $id,
                                            'group_id' => $groupId,
                                            'user_society_id' => $this->request->getPost('user_society_id'),
                                            'society_id' => $societyId,
                                            'is_super_admin' => $isSuperAdmin,
                                        );
                                        $permissionLabel = [];
                                        foreach ($controllers_methods as $controller_name => $methods_arr) {
                                            foreach ($methods_arr as $method) {
                                                $methodDisplay = is_array($method) ? reset($method) : $method;
                                                $methodActual = is_array($method) ? key($method) : $method;
                                                $inputName = $controller_name . "|" . $methodActual;
                                                $permissionLabel[] = $inputName . "|dt|" . $controller_name . "|dt|" . $methodDisplay;
                                            }
                                        }

                                        foreach ($permissionLabel as $labelData) {
                                            list($permissionValue, $controller, $label) = explode("|dt|", $labelData);
                                            if (in_array($permissionValue, $permissions)) {
                                                $labelArray[] = [
                                                    'controller_name' => $controller,
                                                    'permission_name' => $permissionValue,
                                                    'permission_label' => $label,
                                                    'user_id' => $id,
                                                    'group_id' => $groupId,
                                                    'user_society_id' => $this->request->getPost('user_society_id'),
                                                    'created_at' => date('Y-m-d H:i:s'),
                                                    'created_by' => $this->session->get('user_id'),
                                                    'updated_at' => date('Y-m-d H:i:s'),
                                                    'updated_by' => $this->session->get('user_id'),
                                                ];
                                            }
                                        }
                                        if (!empty($labelArray)) {
                                            $builder = $this->db->table(MASTER_DB.'.tbl_user_permission');
                                            $builder->insertBatch($labelArray);
                                        }
                                    }
                                    if (!empty($userGroupArray)) {
                                        $builder = $this->db->table(MASTER_DB.'.tbl_users_groups');
                                        $builder->insertBatch($userGroupArray);
                                    }
                                }
                            }
                            $response['success'] = true;
                            $response['msg'] = lang("IonAuth.update_successful");
                            echo json_encode($response);
                            exit;
                        }
                        else{

                            $groupIdArray = $this->request->getVar("group_user_id[]") ?? [];
                            $societyIdArray = $this->request->getVar("user_group_society_id") ?? [];
                            $userGroupIdArray = $this->request->getVar("user_group_id") ?? [];
                            $userSocietyIdArray = $this->request->getVar("user_society_group_id") ?? [];

                            $validationResponseUserGroupMessage = '';
                            $societyCheckList = [];
                            $key = 0;
                            foreach ($userGroupIdArray as $cpKey => $value) {
                                $key++;
                                $societyId = isset($societyIdArray[$cpKey]) ? $societyIdArray[$cpKey] : '';
                                $groupIds  = isset($groupIdArray[$cpKey]) ? $groupIdArray[$cpKey] : [];

                                // Check for duplicate society
                                if (!empty($societyId)) {
                                    if (in_array($societyId, $societyCheckList)) {
                                        $validationResponseUserGroupMessage .= "ROW " . ($key) . " - Society is already selected in another row. Duplicate societies are not allowed.\n";
                                    } else {
                                        $societyCheckList[] = $societyId;
                                    }
                                }
                                // Check for society + group validation
                                if (!empty($societyId) && empty($groupIds)) {
                                    $validationResponseUserGroupMessage .= "ROW " . ($key) . " - Please select at least one group for the selected society.\n";
                                } 
                            }

                            if ($validationResponseUserGroupMessage != "") {
                                $response['success'] = false;
                                $response['msg'] = $validationResponseUserGroupMessage;
                                echo json_encode($response);
                                exit;
                            }

                            $userSocietyUpdateArray= array();
                            $userSocietyInsertArray= array();
                            if (isset($userSocietyIdArray) && !empty($userSocietyIdArray)) {
                                foreach ($userSocietyIdArray as $key => $userSocietyId) {
                                    $societyId = array_key_exists($key, $societyIdArray) ? $societyIdArray[$key] : '';

                                    if(!empty($userSocietyId)){
                                        $userSocietyUpdateArray[$key] = array(
                                            'user_society_id'  => $userSocietyId,
                                            'user_id'          => $id,
                                            'resource_type_id'  => 0,
                                            'phone'             => $this->request->getPost('phone'),
                                            'first_name'        => $this->request->getPost('first_name'),
                                            'last_name'         => $this->request->getPost('last_name'),
                                            'user_image' => isset($imageResult['file_name']) ? ($imageResult['file_name']) : '',
                                            'is_active' => 1,
                                            'is_super_admin'    => $isSuperAdmin,
                                            'type_id'           => $id,
                                            'is_active'         => 1,
                                            'society_id'        => $societyId,
                                            'created_at'        => date('Y-m-d H:i:s'),
                                            'created_by'        => $this->session->get('user_id'),
                                            'updated_at'        => date('Y-m-d H:i:s'),
                                            'updated_by'        => $this->session->get('user_id'),
                                        );
                                    }
                                    else{
                                        $userSocietyInsertArray[$key] = array(
                                            'user_society_id'  => '',
                                            'user_id'          => $id,
                                            'resource_type_id'  => 0,
                                            'phone'             => $this->request->getPost('phone'),
                                            'first_name'        => $this->request->getPost('first_name'),
                                            'last_name'         => $this->request->getPost('last_name'),
                                            'user_image' => isset($imageResult['file_name']) ? ($imageResult['file_name']) : '',
                                            'is_active' => 1,
                                            'is_super_admin'    => $isSuperAdmin,
                                            'type_id'           => $id,
                                            'is_active'         => 1,
                                            'society_id'        => $societyId,
                                            'created_at'        => date('Y-m-d H:i:s'),
                                            'created_by'        => $this->session->get('user_id'),
                                            'updated_at'        => date('Y-m-d H:i:s'),
                                            'updated_by'        => $this->session->get('user_id'),
                                        );
                                    }
                                }

                            }
                            if(!empty($userSocietyUpdateArray)){
                                $this->common_web_service_model->batchUpdate($userSocietyUpdateArray, 'user_society_id', MASTER_DB.'.tbl_user_society');
                            }

                            if(!empty($userSocietyInsertArray)){
                                $this->common_web_service_model->batchInsert($userSocietyInsertArray, MASTER_DB.'.tbl_user_society');
                            }

                            $userSocietyData = $this->common_web_service_model->getUserSocietyData(array(
                                'user_id' => $id,
                                'is_super_admin' => 1,
                                'is_multiple' => 1,
                            ));

                            $userSocietyId = array_column($userSocietyData, 'user_society_id');

                            $userPermissionDataArray = $this->common_web_service_model->getUserPermissionData(array(
                                'user_id' => $id,
                                'user_society_id' => $userSocietyId,
                                'is_multiple' => 1,
                            ));
                            if(!empty($userPermissionDataArray)){
                                $userPermissionIds = array_column($userPermissionDataArray, 'user_permission_id');
                                $this->common_web_service_model->deleteUserPermission($userPermissionIds);
                            }
                            $this->common_web_service_model->deleteUserGroups($userSocietyId);

                            $controllers_methods = $this->dt_ci_acl->getPermissableMethods();
                           
                            foreach ($userGroupIdArray as  $key => $userGroupId) {
                                $societyId = array_key_exists($key, $societyIdArray) ? $societyIdArray[$key] : '';
                                $userGroupArray = [];

                                if (isset($groupIdArray) && !empty($groupIdArray)) {
                                    $groupIds = array_key_exists($key, $groupIdArray) ? $groupIdArray[$key] : 0;
                                }

                                if(!empty($groupIds)){
                                    foreach ($groupIds as $groupId) {
                                        $groupDataArray = $this->common_web_service_model->getGroupsData([
                                            'id' => $groupId,
                                            
                                        ]);
                                        $permissions = !empty($group['permissions']) ? unserialize($group['permissions']) : [];

                                        $userGroupArray[] = array(
                                            'id' => '',
                                            'user_id' => $id,
                                            'group_id' => $groupId,
                                            'user_society_id' => $this->request->getPost('user_society_id'),
                                            'society_id' => $societyId,
                                            'is_super_admin' => $isSuperAdmin,
                                        );
                                        $permissionLabel = [];
                                        foreach ($controllers_methods as $controller_name => $methods_arr) {
                                            foreach ($methods_arr as $method) {
                                                $methodDisplay = is_array($method) ? reset($method) : $method;
                                                $methodActual = is_array($method) ? key($method) : $method;
                                                $inputName = $controller_name . "|" . $methodActual;
                                                $permissionLabel[] = $inputName . "|dt|" . $controller_name . "|dt|" . $methodDisplay;
                                            }
                                        }

                                        foreach ($permissionLabel as $labelData) {
                                            list($permissionValue, $controller, $label) = explode("|dt|", $labelData);
                                            if (in_array($permissionValue, $permissions)) {
                                                $labelArray[] = [
                                                    'controller_name' => $controller,
                                                    'permission_name' => $permissionValue,
                                                    'permission_label' => $label,
                                                    'user_id' => $id,
                                                    'group_id' => $groupId,
                                                    'user_society_id' => $this->request->getPost('user_society_id'),
                                                    'created_at' => date('Y-m-d H:i:s'),
                                                    'created_by' => $this->session->get('user_id'),
                                                    'updated_at' => date('Y-m-d H:i:s'),
                                                    'updated_by' => $this->session->get('user_id'),
                                                ];
                                            }
                                        }
                                        if (!empty($labelArray)) {
                                            $builder = $this->db->table(MASTER_DB.'.tbl_user_permission');
                                            $builder->insertBatch($labelArray);
                                        }
                                    }
                                }
                                if (!empty($userGroupArray)) {
                                    $builder = $this->db->table(MASTER_DB.'.tbl_users_groups');
                                    $builder->insertBatch($userGroupArray);
                                }
                            }
                            $response['success'] = true;
                            $response['msg'] = lang("IonAuth.update_successful");
                            echo json_encode($response);
                            exit;

                        }
                    } else {
                        $errors = $this->ionAuth->errors($this->validationListTemplate);
                        $response['success'] = false;
                        $response['msg'] = implode("\n", $errors);
                        echo json_encode($response);
                        exit;
                    }
                } else {
                    $errors = $this->validation->getErrors() ? $this->validation->listErrors($this->validationListTemplate) : ($this->ionAuth->errors($this->validationListTemplate) ? $this->ionAuth->errors($this->validationListTemplate) : $this->session->getFlashdata('message'));
                    $response['success'] = false;
                    $response['msg'] = implode("\n", $errors);
                    echo json_encode($response);
                    exit;
                }
            }
        }
        $this->data['controllers_methods'] = $this->dt_ci_acl->getPermissableMethods();
        $this->data['select2_ajax'] = view("Admin/CommonMaster/Select2View", array());
        $this->data['user_group_table'] = view('Admin/Auth/UserGroupTableView', isset($this->data) ? $this->data : array());
        $this->renderPage('Admin/Auth/EditUserView', $this->data, $this->data['title'], false, 'Admin');
    }

    public function deleteUser(){
        $userId =   $this->request->getVar('user_id');

    //    if( isReferenceInTable( 'user_id','tbl_users_groups', $userId)
    //    	// isReferenceInTable( 'salesman_id','tbl_expense', $userId) ||
    //    	// isReferenceInTable( 'call_owner_id','tbl_call', $userId) ||
    //    	// isReferenceInTable( 'task_owner_id','tbl_task', $userId) ||
    //    	// isReferenceInTable( 'salesman_id','tbl_module_salesman', $userId)
    //        ){
    //        $response['success'] = false;
    //        $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
    //        echo json_encode($response);
    //        exit;
    //    }
        $this->ionAuth->deleteUserSociety($userId);
        $userData = $this->ionAuth->deleteUser($userId);
        if ($userData) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Auth.user'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang("Auth.user"));
        }
        echo json_encode($response);
    }

	/**
	 * Redirect a user checking if is admin
	 *
	 * @return \CodeIgniter\HTTP\RedirectResponse
	 */
	public function redirectUser()
	{
		if ($this->ionAuth->isAdmin())
		{
			return redirect()->to('/Admin/auth');
		}
		return redirect()->to('/');
	}

	/**
	 * Edit a user
	 *
	 * @param integer $id User id
	 *
	 * @return string string|\CodeIgniter\HTTP\RedirectResponse
	 */
    //	public function edit_user(int $id)
    //	{
    //		$this->data['title'] = lang('Auth.edit_user_heading');
    //
    //		if (! $this->ionAuth->loggedIn() || (! $this->ionAuth->isAdmin() && ! ($this->ionAuth->user()->row()->id == $id)))
    //		{
    //			return redirect()->to('/auth');
    //		}
    //
    //		$user          = $this->ionAuth->user($id)->row();
    //		$groups        = $this->ionAuth->groups()->resultArray();
    //		$currentGroups = $this->ionAuth->getUsersGroups($id)->getResult();
    //
    //		if (! empty($_POST))
    //		{
    //			// validate form input
    //			$this->validation->setRule('first_name', lang('Auth.edit_user_validation_fname_label'), 'trim|required');
    //			$this->validation->setRule('last_name', lang('Auth.edit_user_validation_lname_label'), 'trim|required');
    //			$this->validation->setRule('phone', lang('Auth.edit_user_validation_phone_label'), 'trim|required');
    //			$this->validation->setRule('company', lang('Auth.edit_user_validation_company_label'), 'trim|required');
    //
    //			// do we have a valid request?
    //			if ($id !== $this->request->getPost('id', FILTER_VALIDATE_INT))
    //			{
    //				//show_error(lang('Auth.error_security'));
    //				throw new \Exception(lang('Auth.error_security'));
    //			}
    //
    //			// update the password if it was posted
    //			if ($this->request->getPost('password'))
    //			{
    //				$this->validation->setRule('password', lang('Auth.edit_user_validation_password_label'), 'required|min_length[' . $this->configIonAuth->minPasswordLength . ']|matches[password_confirm]');
    //				$this->validation->setRule('password_confirm', lang('Auth.edit_user_validation_password_confirm_label'), 'required');
    //			}
    //
    //			if ($this->request->getPost() && $this->validation->withRequest($this->request)->run())
    //			{
    //				$data = [
    //					'first_name' => $this->request->getPost('first_name'),
    //					'last_name'  => $this->request->getPost('last_name'),
    //					'company'    => $this->request->getPost('company'),
    //					'phone'      => $this->request->getPost('phone'),
    //				];
    //
    //				// update the password if it was posted
    //				if ($this->request->getPost('password'))
    //				{
    //					$data['password'] = $this->request->getPost('password');
    //				}
    //
    //				// Only allow updating groups if user is admin
    //				if ($this->ionAuth->isAdmin())
    //				{
    //					// Update the groups user belongs to
    //					$groupData = $this->request->getPost('groups');
    //
    //					if (! empty($groupData))
    //					{
    //						$this->ionAuth->removeFromGroup('', $id);
    //
    //						foreach ($groupData as $grp)
    //						{
    //							$this->ionAuth->addToGroup($grp, $id);
    //						}
    //					}
    //				}
    //
    //				// check to see if we are updating the user
    //				if ($this->ionAuth->update($user->id, $data))
    //				{
    //					$this->session->setFlashdata('message', $this->ionAuth->messages());
    //				}
    //				else
    //				{
    //					$this->session->setFlashdata('message', $this->ionAuth->errors($this->validationListTemplate));
    //				}
    //				// redirect them back to the admin page if admin, or to the base url if non admin
    //				return $this->redirectUser();
    //			}
    //		}
    //
    //		// display the edit user form
    //
    //		// set the flash data error message if there is one
    //		$this->data['message'] = $this->validation->getErrors() ? $this->validation->listErrors($this->validationListTemplate) : ($this->ionAuth->errors($this->validationListTemplate) ? $this->ionAuth->errors($this->validationListTemplate) : $this->session->getFlashdata('message'));
    //
    //		// pass the user to the view
    //		$this->data['user']          = $user;
    //		$this->data['groups']        = $groups;
    //		$this->data['currentGroups'] = $currentGroups;
    //
    //		$this->data['first_name'] = [
    //			'name'  => 'first_name',
    //			'id'    => 'first_name',
    //			'type'  => 'text',
    //			'value' => set_value('first_name', $user->first_name ?: ''),
    //		];
    //		$this->data['last_name'] = [
    //			'name'  => 'last_name',
    //			'id'    => 'last_name',
    //			'type'  => 'text',
    //			'value' => set_value('last_name', $user->last_name ?: ''),
    //		];
    //		$this->data['company'] = [
    //			'name'  => 'company',
    //			'id'    => 'company',
    //			'type'  => 'text',
    //			'value' => set_value('company', empty($user->company) ? '' : $user->company),
    //		];
    //		$this->data['phone'] = [
    //			'name'  => 'phone',
    //			'id'    => 'phone',
    //			'type'  => 'text',
    //			'value' => set_value('phone', empty($user->phone) ? '' : $user->phone),
    //		];
    //		$this->data['password'] = [
    //			'name' => 'password',
    //			'id'   => 'password',
    //			'type' => 'password',
    //		];
    //		$this->data['password_confirm'] = [
    //			'name' => 'password_confirm',
    //			'id'   => 'password_confirm',
    //			'type' => 'password',
    //		];
    //		$this->data['ionAuth'] = $this->ionAuth;
    //
    //		return $this->renderPage($this->viewsFolder . DIRECTORY_SEPARATOR . 'edit_user', $this->data);
    //	}


    public function manage_groups()
    {
        if (! $this->ionAuth->loggedIn() )
        {
            return redirect()->to('/Admin/Auth/login');
        }

        if(!$this->dt_ci_acl->checkAccess('Auth|manage_groups')){
            $data['assets'] = base_url() . 'assets/';
            echo view('errors/custom/no_permission', $data);
            exit;
        }

        $this->renderPage('Admin/Auth/ManageGroupsView', $this->data,'Manage Group',false, 'Admin');
    }

    public function getGroupsListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $this->datatables->table(MASTER_DB.".tbl_groups as tg");
        $this->datatables->select("tg.id,tg.name,tg.description,tg.created_at,tg.updated_at,concat(COALESCE(tu.first_name,''),' ',COALESCE(tu.last_name,'')) as updated_by");
        $this->datatables->join(MASTER_DB.".tbl_users as tu","tu.id = tg.updated_by","left");
        $this->datatables->groupBy("tg.id");

        $isSuperAdmin = session('is_super_admin');

        if (!$isSuperAdmin) {
            accessFilter($this->datatables, array("society" => "tg.society_id"));
            
        } else {
            // For SuperAdmin, show only superadmin groups (assume society_id is NULL or 0)
            $this->datatables->where("tg.is_super_admin_group", 1); // adjust if your default is NULL or something else
        }

        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "group_id" => isset($displayData['id']) ? $displayData['id'] : "",
                    "is_super_admin" => isset($isSuperAdmin) ? $isSuperAdmin : 0,
                );
                $data[$key]['action_button'] = groupActionButton($actionButtonFilter);
                $data[$key]['created_at'] = isValidDate($displayData['created_at']) ? siteDateFormat($displayData['created_at'],true) : "";
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
            }
        }

        //printArray($data,1);
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }


	/**
	 * Create a new group
	 *
	 * @return string string|\CodeIgniter\HTTP\RedirectResponse
	 */
	public function edit_group($id = 0)
	{
        if($id != 0){
            $this->data['title'] = lang('Auth.edit_group_title');
            $group = $this->ionAuth->group($id)->row();

            // pass the user to the view
            $this->data['group'] = $group;
        } else {
            $this->data['title'] = lang('Auth.create_group_title');
        }

		//if (! $this->ionAuth->loggedIn() || ! $this->ionAuth->isAdmin())
		if (! $this->ionAuth->loggedIn())
		{
			return redirect()->to('/Admin/Auth');
		}
        if(!$this->dt_ci_acl->checkAccess('Auth|edit_group')){
            $data['assets'] = base_url() . 'assets/';
            echo view('errors/custom/no_permission', $data);
            exit;
        }

        $currentPath = $this->request->getPath(); 
        $isSuperAdminRoute = stripos($currentPath, 'superadmin') !== false;
        $groupPermissionData = array();
        if ($isSuperAdminRoute != 1) {
            $societyId = $this->session->get('society_id');
            $userId = $this->session->get('user_id');


            $groupPermissionData = $this->common_web_service_model->getUserGroupsData(array(
                'society_user_id' => $societyId,
                'user_id' => $userId,
                'is_multiple' => 1
            ));

            // printArray($groupPermissionData);
            // printArray($userId,1);
            // printArray($societyId,1);
        }


		// validate form input
		$this->validation->setRule('group_name', lang('Auth.create_group_validation_name_label'), 'trim|required|alpha_dash');
        $this->validation->setRule('description', lang('Auth.create_group_validation_desc_label'), 'required');
        if ($this->request->getPost()) {
            if ($this->validation->withRequest($this->request)->run()) {
                if($id != 0){

                    $permissions = $this->request->getPost('permissions');
                    $additionalArray = array(
                        'description'  => $this->request->getPost('description'),
                        'permissions' => isset($permissions) ? serialize($permissions) : serialize(array()),
                        'society_id' => $this->session->get('society_id'),
                        'updated_by' => $this->ionAuth->getUserId(),
                        'updated_at' => date("Y-m-d H:i:s"),
                    );

                    $groupUpdate = $this->ionAuth->updateGroup($id, $this->request->getPost('group_name'), $additionalArray);
                    if ($groupUpdate)
                    {
                        $this->session->setFlashdata('message', lang('Auth.edit_group_saved'));
                        $response['success'] = true;
                        $response['msg'] = "Group update successfully!";
                        echo json_encode($response);
                        exit;
                    }
                    else {
                    //                        $erros= $this->session->setFlashdata('message', $this->ionAuth->errors($this->validationListTemplate));
                    //                        $errors = $this->validation->getErrors();
                    //                        $response['success'] = false;
                    //                        $response['msg'] = implode("\n", $errors);
                    //                        echo json_encode($response);
                    //                        exit;
                        $errors = $this->ionAuth->getErrors();
                        $response['success'] = false;
                        $response['msg'] = implode("\n", $errors);
                        echo json_encode($response);
                        exit;
                    }
                    return redirect()->to('/Admin/Auth/manage_groups');
                }
                else {
                    $permissions = $this->request->getPost('permissions');
                    $additionalArray = array(
                        'permissions' => isset($permissions) ? serialize($permissions) : serialize(array()),
                        'society_id' => $this->session->get('society_id'),
                        'is_super_admin_group' => $this->session->get('is_super_admin'),
                        'created_by' => $this->ionAuth->getUserId(),
                        'created_at' => date("Y-m-d H:i:s"),
                        'updated_by' => $this->ionAuth->getUserId(),
                        'updated_at' => date("Y-m-d H:i:s"),
                    );

                    $newGroupId = $this->ionAuth->createGroup($this->request->getPost('group_name'), $this->request->getPost('description'),$additionalArray);

                    if ($newGroupId) {
                        // check to see if we are creating the group
                        // redirect them back to the admin page
                       // $this->session->setFlashdata('message', $this->ionAuth->messages());
                       // return redirect()->to('/auth/manage_groups');

                        $response['success'] = true;
                        $response['msg'] = "Group create successfully!";
                        echo json_encode($response);
                        exit;
                    }else {
                        $errors = $this->ionAuth->getErrors();
                        $response['success'] = false;
                        $response['msg'] = implode("\n", $errors);
                        echo json_encode($response);
                        exit;
                    }
                }
            } else {

                $errors = $this->validation->getErrors();
                $response['success'] = false;
                $response['msg'] = implode("\n", $errors);
                echo json_encode($response);
                exit;
            }
        }
			// display the create group form
			// set the flash data error message if there is one
		//	$this->data['message'] = $this->validation->getErrors() ? $this->validation->listErrors($this->validationListTemplate) : ($this->ionAuth->errors($this->validationListTemplate) ? $this->ionAuth->errors($this->validationListTemplate) : $this->session->getFlashdata('message'));

        //			$this->data['group_name'] = [
        //				'name'  => 'group_name',
        //				'id'    => 'group_name',
        //				'type'  => 'text',
        //				'value' => set_value('group_name'),
        //			];
        //			$this->data['description'] = [
        //				'name'  => 'description',
        //				'id'    => 'description',
        //				'type'  => 'text',
        //				'value' => set_value('description'),
        //			];

			//return $this->renderPage($this->viewsFolder . DIRECTORY_SEPARATOR . 'create_group', $this->data);
            if($id != 0){
                $title = lang("Auth.edit_group_heading");
                $this->data['title'] = lang("Auth.edit_group_heading");
            } else {
                $title = lang("Auth.create_group_heading");
                $this->data['title'] = lang("Auth.create_group_heading");
            }
            $this->data['controllers_methods'] = $this->dt_ci_acl->getPermissableMethods();
            
            if(($isSuperAdminRoute != 1)){
                if((!$this->ionAuth->isAdmin())){

                    $permArr = array();
                    if(!empty($groupPermissionData)){
                        foreach ($groupPermissionData as $groupPermissionElement){
                            $permission = unserialize($groupPermissionElement['permissions']);
                            if(is_array($permission)){
                                $permArr = array_merge($permArr, $permission);
                            }
                        }
                    }
                    $customerTypeWiseGroupUserPermission = [];
                    $controllers_methods = $this->data['controllers_methods'];
                    if (isset($controllers_methods) && is_array($controllers_methods) && !empty($controllers_methods)) {
                        foreach ($controllers_methods as $controller_name => $methods_arr) {
                            foreach ($methods_arr as $methods) {
                                foreach ($methods as $methodActual => $label) {
                                    $inputName = $controller_name . "|" . $methodActual;

                                    if (in_array($inputName, $permArr)) {
                                        $customerTypeWiseGroupUserPermission[$controller_name][] = [ $methodActual => $label ];
                                    }
                                }
                            }
                        }
                    }
                    $this->data['controllers_methods'] = $customerTypeWiseGroupUserPermission;
                }
            }
            $this->renderPage('Admin/Auth/EditGroupView', $this->data,$title,false, 'Admin');

	}

	/**
	 * Edit a group
	 *
	 * @param integer $id Group id
	 *
	 * @return string|CodeIgniter\Http\Response
	 */
    /*
	public function edit_group(int $id = 0)
	{
		// bail if no group id given
		if (! $id)
		{
			return redirect()->to('/auth');
		}

		$this->data['title'] = lang('Auth.edit_group_title');

		if (! $this->ionAuth->loggedIn() || ! $this->ionAuth->isAdmin())
		{
			return redirect()->to('/auth');
		}

		$group = $this->ionAuth->group($id)->row();

		// validate form input
		$this->validation->setRule('group_name', lang('Auth.edit_group_validation_name_label'), 'required|alpha_dash');

		if ($this->request->getPost())
		{
			if ($this->validation->withRequest($this->request)->run())
			{
				$groupUpdate = $this->ionAuth->updateGroup($id, $this->request->getPost('group_name'), ['description' => $this->request->getPost('description')]);

				if ($groupUpdate)
				{
					$this->session->setFlashdata('message', lang('Auth.edit_group_saved'));
				}
				else
				{
					$this->session->setFlashdata('message', $this->ionAuth->errors($this->validationListTemplate));
				}
				return redirect()->to('/auth');
			}
		}

		// set the flash data error message if there is one
		$this->data['message'] = $this->validation->listErrors($this->validationListTemplate) ?: ($this->ionAuth->errors($this->validationListTemplate) ?: $this->session->getFlashdata('message'));

		// pass the user to the view
		$this->data['group'] = $group;

		$readonly = $this->configIonAuth->adminGroup === $group->name ? 'readonly' : '';

		$this->data['group_name']        = [
			'name'    => 'group_name',
			'id'      => 'group_name',
			'type'    => 'text',
			'value'   => set_value('group_name', $group->name),
			$readonly => $readonly,
		];
		$this->data['group_description'] = [
			'name'  => 'group_description',
			'id'    => 'group_description',
			'type'  => 'text',
			'value' => set_value('group_description', $group->description),
		];

		return $this->renderPage($this->viewsFolder . DIRECTORY_SEPARATOR . 'edit_group', $this->data);
	} */


    public function deleteGroup(){
        $groupId =   $this->request->getVar('group_id');
           if( isReferenceInTable( 'group_id',MASTER_DB.'.tbl_users_groups', $groupId)
       	// isReferenceInTable( 'salesman_id','tbl_expense', $userId) ||
       	// isReferenceInTable( 'call_owner_id','tbl_call', $userId) ||
       	// isReferenceInTable( 'task_owner_id','tbl_task', $userId) ||
       	// isReferenceInTable( 'salesman_id','tbl_module_salesman', $userId)
           ){
           $response['success'] = false;
           $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
           echo json_encode($response);
           exit;
       }

        $groupData = $this->ionAuth->deleteGroup($groupId);
        if ($groupData) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Auth.group'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang("Auth.group"));
        }
        echo json_encode($response);
    }

	/**
	 * Render the specified view
	 *
	 * @param string     $view       The name of the file to load
	 * @param array|null $data       An array of key/value pairs to make available within the view.
	 * @param boolean    $returnHtml If true return html string
	 *
	 * @return string|void
	 */
	protected function renderPage(string $view, $data = null,$title = '', bool $returnHtml = true,$template = 'Auth')
	{
		//$viewdata = $data ?: $this->data;

		//$viewHtml = view($view, $viewdata);

		if (0)
		{
            $viewdata = $data ?: $this->data;

            $viewHtml = view($view, $viewdata);
			return $viewHtml;
		}
		else
		{
            $data['title'] = $title;
            return $this->dt_ci_template->load($template,$view, $data);
		}
	}



    // public function checkOldPassword()
    // {
    //     $oldPassword = $this->request->getVar("old");

    //     if ($this->ionAuth->getUserId()) {
    //         $builder = $this->db->table(MASTER_DB.'.tbl_users as tu');
    //         $builder->select('tu.password');
    //         $builder->where('id', $this->ionAuth->getUserId());
    //         $checkAuth = $builder->get()->getRowArray();
    //         $dbPassword = $checkAuth['password'];
    //     }
    //     if (password_verify($oldPassword, $dbPassword)) {
    //         echo "true";
    //     } else {
    //         echo "false";
    //     }
    //     die();
    // }

    // public function newPasswordNotSameAsOldPassword()
    // {
    //     $newPassword = $this->request->getVar("new");
    //     $id = $this->request->getVar("id");

    //     if ($newPassword != '') {
    //         $builder = $this->db->table(MASTER_DB.'.tbl_users as tu');
    //         $builder->select('password');
    //         $builder->where('id', $id);
    //         $checkAuth = $builder->get()->getRowArray();
    //         if (!empty($checkAuth)) {
    //             $dbPassword = $checkAuth['password'];
    //         } else {
    //             $dbPassword = '';
    //         }
    //     }
    //     if (password_verify($newPassword, $dbPassword)) {
    //         echo "false";
    //     } else {
    //         echo "true";
    //     }
    //     die();
    // }

    // public function checkEmailExist()
    // {
    //     $emailId   = $this->request->getVar('identity');

    //     if (trim($emailId)) {
    //         $res = $this->ionAuth->checkEmailUnique(MASTER_DB.".tbl_users", "email", $emailId, "", "", array());
    //         if (empty($res)) {
    //             echo "false";
    //             die();
    //         } else {
    //             echo "true";
    //             die();
    //         }
    //     } else {
    //         echo "false";
    //         die();
    //     }
    // }

    // public function getGroupPermission()
    // {
    //     if ($this->ionAuth->loggedIn()) {
    //         $permissions = array();
    //         $groupId = $this->request->getVar('group_id');

    //         if (!empty($groupId)) {
    //             foreach ($groupId as $id) {
    //                 $groupDetails = $this->ionAuth->group($id)->row();
    //                 $permission = unserialize($groupDetails->permissions);
    //                 if (is_array($permission)) {
    //                     $permissions = array_merge($permissions, $permission);
    //                 }
    //             }
    //         }
    //         $permissions = array_unique($permissions);
    //         echo json_encode($permissions);
    //         exit;
    //     } else {
    //         redirect('Admin/Auth/login', 'refresh');
    //     }
    // }

    public function addUserGroupRow()
    {
        $data['row_number'] = $this->request->getVar("row_number");
        $data['groups'] = $this->ionAuth->getGroupData(array('is_super_admin_group'=>1,'is_multiple' => 1));
        $userGroupRow = view('Admin/Auth/userGroupTableRowView', $data);
        echo $userGroupRow;
    }

    public function deleteUserGroupRow()
    {
        $this->db->transStart();

        $userSocietyGroupId  = $this->request->getVar('row_id');
        $userId = $this->request->getVar('user_id');

        $userGroupData = $this->common_web_service_model->deletUserGroupRecord($userSocietyGroupId);
        
        if (($userGroupData)) {
            
            $transactionStatus = $this->db->transComplete();
            if($transactionStatus == 1){
                $response['success'] = true;
                $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Auth.user_group'));
            }
            else{
                $response['success'] = false;
                $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('Auth.user_group'));
            }
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('Auth.user_group'));
        }
        echo json_encode($response);
        exit();
    }
}
