<?php
namespace App\Controllers\Admin;
use App\Models\ParkingPlaceModel;
use CodeIgniter\Controller;
use App\Models\AreaModel;
class Area extends BaseController
{
    protected $area_model;
    public function __construct() {
        $this->area_model = new AreaModel();
        $this->parking_place_model = new ParkingPlaceModel();
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );
        $data['title'] = 'Area';
//        $data['area_modal_view'] = view('Admin/Area/AreaModalView', $data);
        return $this->dt_ci_template->load("Admin","Area/AreaView",$data);
    }

    public function getAreaListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $this->datatables->table("tbl_area as ta");
        $this->datatables->select("ta.area_id, ta.area_name,ta.vehicle_type,ta.slot, ta.number_type,ta.is_active");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,ta.updated_at");
        $this->datatables->join("society_user_master_view as tupdate","tupdate.user_society_id = ta.updated_by","left");
        $this->datatables->groupBy("ta.area_id");
        accessFilter($this->datatables, array("society" => "ta.society_id"));

        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "area_id" => isset($displayData['area_id']) ? $displayData['area_id'] : "",
                );
                $data[$key]['action_button'] = areaActionButton($actionButtonFilter);
                $data[$key]['number_type'] = isset($displayData['number_type']) ? underscoreToUcWord($displayData['number_type']) : "";
                $data[$key]['vehicle_type'] = isset($displayData['vehicle_type']) ? underscoreToUcWord($displayData['vehicle_type']) : "";
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }

    public function manage($areaId = '',$view = '')
    {
        $request    = \Config\Services::request();
        $data['extra_js'] = array(
            "js/jquery.form.min.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/flatpickr/flatpickr.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
        );
        if ($areaId != '') {
            $filterData = array(
                "area_id" => $areaId
            );
            $data['area_data'] = $this->area_model->getAreaData($filterData);
            if (empty($data['area_data'])) {
                return redirect()->to('Admin/Area');
            }
        }

        if ($areaId != '') {
            $data['title'] = lang('Area.edit_area');
        } else {
            $data['title'] = lang('Area.add_area');
        }

        $data['area_data']['view'] = (isset($view) && $view != '' ? 1 : 0);
        if ((isset($data['area_data']['society_id']) && $data['area_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/Area');
        }
        $this->dt_ci_template->load("Admin","Area/AreaManageView",$data);
    }

    public function save()
    {
        $validation = \Config\Services::validation();
        $this->db->transStart();
        $areaId = $this->request->getVar('area_id');
        $areaName = $this->request->getVar('area_name');
        $slot = $this->request->getVar('slot');
        $vehicleType = $this->request->getVar('vehicle_type');
        $numberType = $this->request->getVar('number_type');
        $rangeLabel = $this->request->getVar('range_label');
        $rangeStartFrom = $this->request->getVar('range_start_from');
        $isActive = $this->request->getVar('is_active');

        if (isset($areaId) && $areaId == '') {
			//$validation->setRule('area_name', lang('Area.area_name'), 'required|combination_unique[tbl_area.area_name.'.$this->session->get('society_id').'.]',array('combination_unique' => 'This {field} Already Exists'));
        } else {
			//$validation->setRule('area_name', lang('Area.area_name'), 'required|edit_unique[tbl_area.area_name.' . $areaId . '.'. $this->session->get('society_id').']',array('edit_unique' => 'This {field} Already Exists'));
        }

        $filterData = array(
            "area_id" => $areaId,
            "area_name" => $areaName,
            "vehicle_type" => $vehicleType,
            "society_id" => $this->session->get('society_id'),
            'area_id_not' => $areaId,
            "is_multiple" => 1
        );
        $areaData = $this->area_model->getAreaData($filterData);
        // printArray($areaData,1);
        if(!empty($areaData)){
            $response['success'] = false;
            $response['msg'] = "Can/t Enter Same Parking number from Same Area And Same Flat";
            echo json_encode($response);
            die();
        }

        $validation->setRule('area_name', lang('Area.area_name'), 'required');
        $validation->setRule('slot', lang('Area.slot'), 'required');
        $validation->setRule('vehicle_type', lang('Area.vehicle_type'), 'required');
        $validation->setRule('number_type', lang('Area.number_type'), 'required');

        if($numberType == 'range'){
            // $validation->setRule('range_label', lang('Area.range_label'), 'required');
            $validation->setRule('range_start_from', lang('Area.range_start_from'), 'required');
        }
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

            $changeSlot = 0;
            if(isset($areaId) && $areaId != ''){
                $filterData = array(
                    "area_id" => $areaId,
                    "society_id" => $this->session->get('society_id'),
                );
                $areaData = $this->area_model->getAreaData($filterData);
                // printArray($areaData,1);
                if(!empty($areaData)){
                    if ($areaData['slot'] != $slot) {
                        $changeSlot = $slot - $areaData['slot'];
                        if($changeSlot > 0){
                                if($numberType == 'range'){
                                    $endRangeForm = $rangeStartFrom +$changeSlot;
                                    for($j = $rangeStartFrom; $j<$endRangeForm; $j++) {
                                        $parkingPlaceArray = array(
                                            'parking_place_id' => '',
                                            'area_id' => $areaId,
                                            'number' => $rangeLabel.$j,
                                            'society_id' => $this->session->get('society_id'),
                                            'flat_id' => 0,
                                            'is_active' => isset($isActive) ? 1 : 0,
                                        );
                                        // printArray($parkingPlaceArray,1);
                                        $parkingPlaceData = $this->area_model->insertUpdateRecord($parkingPlaceArray,'parking_place_id','tbl_parking_place', 1,'',array(),array(),array());
                                    }
                                }
                                if($numberType == 'manual'){
                                    for($j = 0; $j<$changeSlot; $j++) {
                                        $parkingPlaceArray = array(
                                            'parking_place_id' => '',
                                            'area_id' => $areaId,
                                            'number' => '',
                                            'society_id' => $this->session->get('society_id'),
                                            'flat_id' => 0,
                                            'is_active' => isset($isActive) ? 1 : 0,
                                        );
                                        $parkingPlaceData = $this->area_model->insertUpdateRecord($parkingPlaceArray,'parking_place_id','tbl_parking_place', 1,'',array(),array(),array());
                                    }
                                }
                        } else {
                            $filterData = array(
                                'area_id' => $areaId,
                                'society_id' => $this->session->get('society_id'),
                            );
                            $parkingPlaceData = $this->parking_place_model->getParkingPlaceData($filterData);
                            if(!empty($parkingPlaceData) && $parkingPlaceData['flat_id'] != 0) {
                                $response['success'] = false;
                                $response['msg'] = lang("Area.flat_already_assigned");
                                echo json_encode($response);
                                exit;
                            } else {
                                $filterData = array(
                                    'area_id' => $areaId,
                                    'society_id' => $this->session->get('society_id'),
                                    'assigned_flat_id' => 0,
                                    'is_multiple' => 1,
                                );
                                $notAssignedParkingPLaceData = $this->parking_place_model->getParkingPlaceData($filterData);
                                if(!empty($notAssignedParkingPLaceData) && count($notAssignedParkingPLaceData) > abs($changeSlot)){
                                    $notAssignedParkingPlaceIdArray = array();
                                    foreach ($notAssignedParkingPLaceData as $key => $value) {
                                        if($key < abs($changeSlot)) {
                                            $notAssignedParkingPlaceIdArray[] = $value['parking_place_id'];
                                        }
                                    }
                                    $this->parking_place_model->deleteRecord($notAssignedParkingPlaceIdArray);
                                } else {
                                    $response['success'] = false;
                                    $response['msg'] = lang("Area.flat_already_assigned");
                                    echo json_encode($response);
                                    exit;
                                }
                            }
                        }
                    }
                }
            }
            // printArray($changeSlot,1);   

            $areaUpdateArray = array();
            $areaArray = array(
                'area_id' => $areaId,
                'area_name' => $areaName,
                'vehicle_type' => $vehicleType,
                'slot' => $slot,
                'number_type' => $numberType,
                //'range_label' => $rangeLabel,
               //'range_start_from' => $rangeStartFrom,
                'society_id' => $this->session->get('society_id'),
                'is_active' => isset($isActive) ? 1 : 0,
            );

            if($numberType == 'range'){
                $areaArray['range_label'] = $rangeLabel;
                $areaArray['range_start_from'] = $rangeStartFrom;
            }
            // $areaData = $this->area_model->insertUpdateRecord($areaArray,'area_id','tbl_area', 1,'',array());
            if(!empty($areaId)){
                $areaUpdateData = $this->area_model->getAreaData(array(
                    'area_id' => $areaId,
                ));
                $areaUpdateArray = compareArray($areaArray,$areaUpdateData);
            }
            $areaData = $this->area_model->insertUpdateRecord($areaArray,'area_id','tbl_area', 1,'',array(),array(),$areaUpdateArray);
            $lastAreaId = $areaData['lastInsertedId'];
            
            
            if($areaId == ''){
                if($numberType == 'range'){
                    $endRangeForm = $rangeStartFrom +$slot;
                    for($i = $rangeStartFrom; $i<$endRangeForm; $i++) {
                        $parkingPlaceArray = array(
                            'parking_place_id' => '',
                            'area_id' => $lastAreaId,
                            'number' => $rangeLabel.$i,
                            'society_id' => $this->session->get('society_id'),
                            'flat_id' => 0,
                            'is_active' => isset($isActive) ? 1 : 0,
                        );
                        $parkingPlaceData = $this->area_model->insertUpdateRecord($parkingPlaceArray,'parking_place_id','tbl_parking_place', 1,'',array(),array(),array());
                    }
                }
                if($numberType == 'manual'){
                    for($i = 0; $i<$slot; $i++) {
                        $parkingPlaceArray = array(
                            'parking_place_id' => '',
                            'area_id' => $lastAreaId,
                            'number' => '',
                            'society_id' => $this->session->get('society_id'),
                            'flat_id' => 0,
                            'is_active' => isset($isActive) ? 1 : 0,
                        );
                        $parkingPlaceData = $this->area_model->insertUpdateRecord($parkingPlaceArray,'parking_place_id','tbl_parking_place', 1,'',array(),array(),array());
                    }
                }
            }

            if (isset($areaId) && $areaId != '') {
                if ($areaData['success']) {
                    $this->db->transCommit();
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('Area.area'));
                } else {
                    $this->db->transRollback();
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('Area.area'));
                }
            } else {
                if ($areaData['success']) {
                    $this->db->transCommit();
                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('Area.area'));
                } else {
                    $this->db->transRollback();
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('Area.area'));
                }
            }
            echo json_encode($response);
            exit();
        }

    }

    public function changeStatus()
    {
        $areaId = $this->request->getVar('area_id');
        $status = $this->request->getVar('status');

        //$status         = ($status == 0) ? 1 : 0;
        $return = $this->area_model->statusChange($areaId,$status,'area_id','tbl_area');
        if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('Area.area'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('Area.area'));
        }
        echo json_encode($response);
        exit();
    }


    public function delete()
    {
        $this->db->transStart();
        $areaId = $this->request->getVar('area_id');
        if( isReferenceInTable('area_id', 'tbl_parking_place', $areaId)) {
            if (!empty($areaId)) {
                foreach ($areaId as $area) {
                    $deleteDataArray['module'] = 'Area';
                    $deleteDataArray['activity'] = "Tried to delete Area ";
                    $deleteDataArray['module_id'] = $area;
                    logActivity('Tried to delete Area [AreaID: ' . $area . ']', $this->data['userId'], 'Area', $area, json_encode($deleteDataArray), '', 'Area', $area);
                }
            }

            $response['success'] = false;
            $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
            echo json_encode($response);
            exit;
        }
        $areaData = $this->area_model->deleteRecord($areaId);
        $transactionStatus = $this->db->transComplete();
        if (($areaData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Area.area'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang('Area.area'));
        }
        echo json_encode($response);
        exit;
    }

    public function getAreaDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page            = $this->request->getVar('page');
        $areaId = $this->request->getVar('area_id');

        $filterData = array(
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT,
            'is_active' => 1,
            'area_id' => $areaId,

        );
        echo $this->area_model->getArea($filterData);
    }

    public function excelExportArea()
    {
        $fileName ='area-' . DATETIMEFORMAT;
        $sheetName = 'Area-' . DATEFORMAT;
        $excelHeaderName = 'Area';
        $tableData = $this->getAreaListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            lang('Area.area'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                $row["area_name"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'C';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }
}
