<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
// use App\Models\MaterialModel;
use App\Models\AMCNotificationModel;

class AMCNotification extends BaseController
{
    protected $item_ledger_model;
    public function __construct() {
        // $this->material_model = new MaterialModel();
        // $this->item_ledger_model = new AMCNotificationModel();

    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/moment/moment.js",
            "vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
        $data['title'] = 'Amc Notification';
        $dataFilters['filters'] = array(
			array(
				"type" => "multi_select",
				"dynamic" => true,
				"class" => "vendorDd",
				"id" => "filter_vendor_id",
				"name" => "filter_vendor_id",
				"title" => "AMC.company_person",
			),
			array(
				"type" => "amc_type",
				"id" => "amc_type",
				"name" => "amc_type",
				"title" => "AMC.amc_type",
			),
			array(
				"type" => "daterange",
				"id" => "filter_period_from",
				"name" => "filter_period_from",
				"title" => "AMC.period",
			),
			array(
				"type" => "daterange",
				"id" => "filter_created_at",
				"name" => "filter_created_at",
				"title" => "CommonMessage.common_created_at",
			),
			array(
				"type" => "daterange",
				"id" => "filter_updated_at",
				"name" => "filter_updated_at",
				"title" => "CommonMessage.common_updated_at",
			),
		);
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Ajax)? $select2Ajax : array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
        return $this->dt_ci_template->load("Admin","AMCNotification/AMCNotificationView",$data);
    }

    public function getAMCNotificationListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }

        $createdAt = $this->request->getVar("filter_created_at");
		$updatedAt = $this->request->getVar("filter_updated_at");
		$vendorId = $this->request->getVar("filter_vendor_id");
		$periodFrom = $this->request->getVar("filter_period_from");
		$amcType = $this->request->getVar("amc_type");

        $this->datatables->table("tbl_amc_detail as tad");
        $this->datatables->select("tad.amc_id,tad.place, tad.amc_type,tad.particular,tad.period_from,tad.period_upto,tad.amount,tad.is_active,tad.society_id,COALESCE(ts.society_name,'') as society_name,COALESCE(ta.amenities_name,'') as amenities_name");
        $this->datatables->select("COALESCE(tv.vendor_name,'') as vendor_name,tad.vendor_id");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tad.updated_at");
        $this->datatables->join(MASTER_DB . ".tbl_society as ts", "ts.society_id = tad.society_id", "left");
        $this->datatables->join("tbl_vendor as tv", "tv.vendor_id = tad.vendor_id", "left");
        $this->datatables->join("society_user_master_view as tupdate", "tupdate.user_society_id = tad.updated_by", "left");
        $this->datatables->join("tbl_amenities as ta", "ta.amenities_id = tad.amenities_id", "left");

        // only rows where period_upto is between today and next 15 days (inclusive)
        $this->datatables->where("DATE(tad.period_upto) BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL 15 DAY)");
        $this->datatables->where("tad.is_active = 1");
        
        if(isset($vendorId)) {
			if(is_array($vendorId)){
				$this->datatables->whereIn("tad.vendor_id",$vendorId);
			} else {
				$this->datatables->where("tad.vendor_id",$vendorId);
			}
		}
		if (isset($amcType)) {
			if (is_array($amcType)) {
				$this->datatables->whereIn("tad.amc_type", $amcType);
			} else {
				$this->datatables->where("tad.amc_type", $amcType);
			}
		}
		if($periodFrom != ''){
			list($fromDate,$toDate) = explode(" - ",$periodFrom);
			$fromDate = DMYToYMD($fromDate);
			$toDate = DMYToYMD($toDate);
			if(strtotime($fromDate) != strtotime($toDate)){
				$this->datatables->where("date_format(tad.period_from,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
				$this->datatables->where("date_format(tad.period_upto,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
			} else {
				$this->datatables->where("date_format(tad.period_from,'".DATE_FORMATE_MYSQL_YMD."') = ",$fromDate);
				$this->datatables->where("date_format(tad.period_upto,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
			}
		}
		if($createdAt != ''){
			list($fromDate,$toDate) = explode(" - ",$createdAt);
			$fromDate = DMYToYMD($fromDate);
			$toDate = DMYToYMD($toDate);
			if(strtotime($fromDate) != strtotime($toDate)){
				$this->datatables->where("date_format(tad.created_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
				$this->datatables->where("date_format(tad.created_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
			} else {
				$this->datatables->where("date_format(tad.created_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
			}
		}
		if($updatedAt != ''){
			list($fromDate,$toDate) = explode(" - ",$updatedAt);
			$fromDate = DMYToYMD($fromDate);
			$toDate = DMYToYMD($toDate);
			if(strtotime($fromDate) != strtotime($toDate)){
				$this->datatables->where("date_format(tad.updated_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
				$this->datatables->where("date_format(tad.updated_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
			} else {
				$this->datatables->where("date_format(tad.updated_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
			}
		}

        $this->datatables->groupBy("tad.amc_id");

        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                // $data[$key]['action_button'] = amcActionButton($actionButtonFilter);
                $data[$key]['amc_type'] = underscoreToUcWord($displayData['amc_type']);
                $data[$key]['period_from'] = siteDateFormat($displayData['period_from']);
                $data[$key]['period_upto'] = siteDateFormat($displayData['period_upto']);
                $data[$key]['amount'] = indianMoneyFormat($displayData['amount'], 2, 0);
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'], true) : "";
                $data[$key]['excel_vendor_name'] = isset($displayData['vendor_name']) ? $displayData['vendor_name'] : "";
                $data[$key]['vendor_name'] = isset($displayData['vendor_name']) ? vendorDocumentToHtml($displayData['vendor_name'], $displayData['vendor_id']) : "";
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }

    public function excelExportAMCNotification()
    {
        $fileName ='AMCNotification-' . DATETIMEFORMAT;
        $sheetName = 'AMCNotification-' . DATEFORMAT;
        $excelHeaderName = 'AMCNotification';
        $tableData = $this->getAMCNotificationListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
			lang('AMC.amc_type'),
			lang('AMC.particular'),
			lang('AMC.company_person'),
			lang('AMC.period_from'),
			lang('AMC.period_to'),
			lang('AMC.amount'),
			// lang('AMC.facilities'),
			// lang('AMC.place'),
			// lang('CommonMessage.common_updated_by'),
			// lang('CommonMessage.common_updated_at')
		);
		foreach ($tableData as $row) {
			$dataRows[] = array(
				$row["amc_type"],
				$row["particular"],
				$row["excel_vendor_name"],
				$row["period_from"],
				$row["period_upto"],
				$row["amount"],
				// $row["amenities_name"],
				// $row["place"],
				// $row["updated_by"],
				// $row["updated_at"]
			);
		}
        $subTotalCellValueArray = [];
        $toColumn = 'J';

        // printArray($dataRows,1);
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }
}