<!doctype html>

<html lang="en" class="light-style layout-navbar-fixed layout-menu-fixed layout-compact" dir="ltr" data-theme="theme-default" data-assets-path="<?= $assets; ?>" data-template="vertical-menu-template">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title><?= isset($title) ? $title : ''; ?> | <?= SITE_NAME ?></title>

    <meta name="description" content="" />

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?= $assets; ?>img/favicon/favicon.ico" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&ampdisplay=swap" rel="stylesheet" />

    <!-- Icons -->
    <link rel="stylesheet" href="<?= $assets; ?>vendor/fonts/fontawesome.css" />
    <link rel="stylesheet" href="<?= $assets; ?>vendor/fonts/tabler-icons.css" />
    <link rel="stylesheet" href="<?= $assets; ?>vendor/fonts/flag-icons.css" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="<?= $assets; ?>vendor/css/rtl/core.css" class="template-customizer-core-css" />
    <link rel="stylesheet" href="<?= $assets; ?>vendor/css/rtl/theme-default.css" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="<?= $assets; ?>css/demo.css" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="<?= $assets; ?>vendor/libs/node-waves/node-waves.css" />
    <link rel="stylesheet" href="<?= $assets; ?>vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <link rel="stylesheet" href="<?= $assets; ?>vendor/libs/typeahead-js/typeahead.css" />
    <link rel="stylesheet" href="<?= $assets; ?>vendor/libs/bootstrap-select/bootstrap-select.css" />
    <link rel="stylesheet" href="<?= $assets; ?>vendor/libs/select2/select2.css" />
    <link rel="stylesheet" href="<?= $assets; ?>vendor/libs/flatpickr/flatpickr.css" />
    <link rel="stylesheet" href="<?= $assets; ?>vendor/libs/jquery-timepicker/jquery-timepicker.css" />
    <link rel="stylesheet" href="<?= $assets; ?>vendor/libs/typeahead-js/typeahead.css" />
    <link rel="stylesheet" href="<?= $assets; ?>vendor/libs/tagify/tagify.css" />
    <link rel="stylesheet" href="<?= $assets; ?>vendor/libs/@form-validation/form-validation.css" />



    <link rel="stylesheet" href="<?= $assets; ?>vendor/libs/datatables-bs5/datatables.bootstrap5.css" />
    <link rel="stylesheet" href="<?= $assets; ?>vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css" />
    <link rel="stylesheet" href="<?= $assets; ?>vendor/libs/datatables-checkboxes-jquery/datatables.checkboxes.css" />

    <!-- Page CSS -->

    <!-- Sweet Alert -->
    <link rel="stylesheet" href="<?= $assets; ?>vendor/libs/animate-css/animate.css" />
    <link rel="stylesheet" href="<?= $assets; ?>vendor/libs/sweetalert2/sweetalert2.css" />

    <!-- Toasts -->
    <link rel="stylesheet" href="<?= $assets; ?>vendor/libs/toastr/toastr.css" />

    <link rel="stylesheet" href="<?= $assets; ?>vendor/libs/bootstrap-datepicker/bootstrap-datepicker.css" />
    <link rel="stylesheet" href="<?= $assets; ?>vendor/libs/flatpickr/flatpickr.css" />
    <link rel="stylesheet" href="<?= $assets; ?>vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.css" />
<!--    <link rel="stylesheet" href="--><?php //= $assets; ?><!--vendor/libs/quill/katex.css" />-->
<!--    <link rel="stylesheet" href="--><?php //= $assets; ?><!--vendor/libs/quill/editor.css" />-->

    <!-- Helpers -->
<!--    <script src="https://cdn.ckeditor.com/ckeditor5/12.0.0/classic/ckeditor.js"></script>-->
    <script src="<?= $assets; ?>vendor/js/helpers.js"></script>
    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Template customizer: To hide customizer set displayCustomizer value false in config.js.  -->
    <!-- <script src="<?//= $assets; ?>vendor/js/template-customizer.js"></script> -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="<?= $assets; ?>js/config.js"></script>

    <!-- <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@tabler/icons-webfont@latest/dist/tabler-icons.min.css" /> -->


    <script type="text/javascript" src="<?= $assets ?>vendor/js/accounting.js"></script>
    <script src="<?= $assets; ?>vendor/libs/jquery/jquery.js"></script>
    <script src="<?= $assets; ?>js/forms-selects.js"></script>
    <script src="<?= $assets; ?>js/bootbox.js"></script>
    <style>
        .font-weight-bold{
            font-weight: 900 !important;
            color: #5d596c !important;
        }
        .validation-invalid-label {
            margin-top: .5rem;
            margin-bottom: .5rem;
            display: block;
            color: #f44336;
            position: relative;
            padding-left: 1.625rem;
        }

        .validation-valid-label {
            margin-top: .5rem;
            margin-bottom: .5rem;
            display: block;
            color: #4caf50;
            position: relative;
            padding-left: 1.625rem;
        }

        /* Ensure dropdown remains hidden until hovered */
        .changeSocietyDropdown:hover .dropdown-menu {
            display: block;
            margin-top: 0;
        }

        /* Disable default bullet icon in submenus */
        .menu-sub .menu-link::before {
            display: none !important;
        }

        .menu-sub .menu-icon,
        .menu-sub i {
            display: inline-block !important;
            opacity: 1 !important;
            font-size: 16px !important;
            margin-right: 8px;
            color: inherit;
        }
    </style>

    <style>
        /* clears the 'X' from Internet Explorer */
        input[type=search]::-ms-clear {  display: none; width : 0; height: 0; }
        input[type=search]::-ms-reveal {  display: none; width : 0; height: 0; }

        /* clears the 'X' from Chrome */
        input[type="search"]::-webkit-search-decoration,
        input[type="search"]::-webkit-search-cancel-button,
        input[type="search"]::-webkit-search-results-button,
        input[type="search"]::-webkit-search-results-decoration { display: none; }
    </style>
</head>
<?php
//$CI = &get_instance();
$this->dt_ci_acl = new \App\Libraries\Dt_ci_acl();
?>

<?php
if (isset($extra_js)) {
    foreach ($extra_js as $js) {
        echo '<script type="text/javascript" src="' . $assets . $js . '"></script>';
        echo "\n";
    }
} ?>

<body>
<!-- Layout wrapper -->
<div class="layout-wrapper layout-content-navbar">
    <div class="layout-container">
        <!-- Menu -->
        
        <aside id="layout-menu" class="layout-menu menu-vertical menu bg-menu-theme">
            <div class="app-brand demo">
                <a href="<?= admin_url('Dashboard'); ?>" class="app-brand-link">
						<span class="app-brand-logo demo">
							<svg width="32" height="22" viewBox="0 0 32 22" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path fill-rule="evenodd" clip-rule="evenodd" d="M0.00172773 0V6.85398C0.00172773 6.85398 -0.133178 9.01207 1.98092 10.8388L13.6912 21.9964L19.7809 21.9181L18.8042 9.88248L16.4951 7.17289L9.23799 0H0.00172773Z" fill="#7367F0" />
								<path opacity="0.06" fill-rule="evenodd" clip-rule="evenodd" d="M7.69824 16.4364L12.5199 3.23696L16.5541 7.25596L7.69824 16.4364Z" fill="#161616" />
								<path opacity="0.06" fill-rule="evenodd" clip-rule="evenodd" d="M8.07751 15.9175L13.9419 4.63989L16.5849 7.28475L8.07751 15.9175Z" fill="#161616" />
								<path fill-rule="evenodd" clip-rule="evenodd" d="M7.77295 16.3566L23.6563 0H32V6.88383C32 6.88383 31.8262 9.17836 30.6591 10.4057L19.7824 22H13.6938L7.77295 16.3566Z" fill="#7367F0" />
							</svg>
						</span>
                    <span class="app-brand-text demo menu-text fw-bold" data-bs-toggle = "tooltip" title="<?= isset($society_id_name) ? $society_id_name : ""; ?>">Your Only</span>
                    <!-- <span class="app-brand-text demo menu-text fw-bold" data-bs-toggle = "tooltip" title="<?= isset($society_id_name) ? $society_id_name : ""; ?>"><?//= isset($society_id_name) ? $society_id_name : ""; ?></span> -->
                </a>

                <a href="javascript:void(0);" class="layout-menu-toggle menu-link text-large ms-auto">
                    <i class="ti menu-toggle-icon d-none d-xl-block ti-sm align-middle"></i>
                    <i class="ti ti-x d-block d-xl-none ti-sm align-middle"></i>
                </a>
            </div>

            <?php if($is_super_admin == 0) {?>
            <div class="px-3 py-2 d-flex flex-column align-items-start w-100">
                <!-- Society Name with Tooltip -->
                <span class="fw-bold text-truncate society-name mb-2 w-100" 
                    style="max-width: 200px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; z-index: 10"
                    data-bs-toggle="tooltip" 
                    title="<?= isset($society_id_name) ? $society_id_name : ''; ?>">
                    <?= isset($society_id_name) ? $society_id_name : ''; ?>
                </span>

                

                <!-- Form to change society_id with a cleaner dropdown -->
                <form method="POST" action="" class="w-100">
                    <select id="society_id" name="society_id" class="select2 form-select w-100"
                        data-placeholder="Select Society">
                        <option value="">Select Society</option>
                        <?php 
                           
                        ?>
                        <?php foreach ($user_society_data as $societyData): ?>
                            <option value="<?= $societyData['society_id'] ?>"
                                <?= isset($_SESSION['society_id']) && $_SESSION['society_id'] == $societyData['society_id'] ? 'selected' : '' ?>>
                                <?= $societyData['society_name'] ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </form>
            </div>
            <?php } ?>

            <div class="px-3 pb-2 w-100">
                <div class="position-relative">
                    <i class="ti ti-search position-absolute text-muted" style="top: 50%; left: 14px; transform: translateY(-50%); font-size: 16px;"></i>
                    <input type="text" id="menuSearch" class="form-control form-control-sm rounded-pill ps-5" style="height: 36px; font-size: 14px; border-radius: 8px;" placeholder="Search menu...">
                    <i id="clearSearch" class="ti ti-x position-absolute text-muted" 
            style="top: 50%; right: 14px; transform: translateY(-50%); font-size: 16px; cursor: pointer; display: none;"></i>
                </div>
            </div>

            <?php
            $mainActive = '';
            $mainOpen = '';

            $subActive = '';
            $subOpen = '';
            ?>

            <div class="menu-inner-shadow"></div>

            <ul class="menu-inner py-1">
                <!-- <li class="nav-item">
                    <input type="text" id="menuSearch" class="form-control" placeholder="Search Menu...">
                </li> -->
                <li class="menu-item">
                    <a href="<?= admin_url('Dashboard'); ?>" class="menu-link">
                        <i class="menu-icon tf-icons ti ti-smart-home"></i>
                        <div data-i18n="<?= lang('SidebarNav.dashboard');?>"><?= lang('SidebarNav.dashboard');?></div>
                    </a>
                </li>
                <?php if($is_super_admin == 0) {?>

                <?php
                if (
                    $this->dt_ci_acl->checkAccess("ManagementCommittee|index") ||
                    $this->dt_ci_acl->checkAccess("ManagementCommittee|manage") ||
                    $this->dt_ci_acl->checkAccess("Vendor|index") ||
                    $this->dt_ci_acl->checkAccess("Vendor|manage") ||
                    $this->dt_ci_acl->checkAccess("CommonKeys|index") ||
                    $this->dt_ci_acl->checkAccess("CommonKeys|manage") 
                ) {
                    ?>
                    <li class="menu-item main-menu">
                        <a href="javascript:void(0);" class="menu-link menu-toggle">
                            <i class="menu-icon tf-icons ti ti-layout-sidebar"></i>
                            <div data-i18n="<?= lang('SidebarNav.charts');?>"><?= lang('SidebarNav.charts');?></div>
                        </a>
                        <ul class="menu-sub">
                            <?php if ($this->dt_ci_acl->checkAccess("ManagementCommittee|index") ||
                                $this->dt_ci_acl->checkAccess("ManagementCommittee|manage")
                            ) { ?>
                                <li class="menu-item sub-menu <?= ($this->dt_ci_acl->getActiveMenu(array("ManagementCommittee", "ManagementCommittee/manage")))  ?>">
                                    <a href="<?= admin_url(); ?>ManagementCommittee" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-user"></i>
                                        <div data-i18n="<?= lang('SidebarNav.management_committee');?>"><?= lang('SidebarNav.management_committee');?></div>
                                    </a>
                                </li>
                            <?php } ?>
                            <?php if ($this->dt_ci_acl->checkAccess("Vendor|index") || $this->dt_ci_acl->checkAccess("Vendor|manage")) { ?>
                                <li class="menu-item sub-menu <?= ($this->dt_ci_acl->getActiveMenu(array("Vendor", "Vendor/manage")))  ?>">
                                    <a href="<?= admin_url(); ?>Vendor" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-user"></i>
                                        <div data-i18n="<?= lang('SidebarNav.vendor');?>"><?= lang('SidebarNav.vendor');?></div>
                                    </a>
                                </li>
                            <?php } ?>
                            <?php if ($this->dt_ci_acl->checkAccess("CommonKeys|index") || $this->dt_ci_acl->checkAccess("CommonKeys|manage")) { ?>
                                <li class="menu-item sub-menu <?= ($this->dt_ci_acl->getActiveMenu(array("CommonKeys", "CommonKeys/manage")))  ?>">
                                    <a href="<?= admin_url(); ?>CommonKeys" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-list"></i>
                                        <div data-i18n="<?= lang('SidebarNav.common_keys');?>"><?= lang('SidebarNav.common_keys');?></div>
                                    </a>
                                </li>
                            <?php } ?>
                        </ul>
                    </li>
                <?php } ?>

                <?php
                if (
                    $this->dt_ci_acl->checkAccess("Member|index")
                ) {
                    ?>
                    <li class="menu-item main-menu">
                        <a href="javascript:void(0);" class="menu-link menu-toggle">
                            <i class="menu-icon tf-icons ti ti-layout-sidebar"></i>
                            <div data-i18n="<?= lang('SidebarNav.information');?>"><?= lang('SidebarNav.information');?></div>
                        </a>

                        <ul class="menu-sub">
                            <?php if ($this->dt_ci_acl->checkAccess("Member|index")
                                ) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("Member")); ?>">
                                    <a href="<?= admin_url(); ?>Member" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-calendar-time"></i>
                                        <div data-i18n="<?= lang('SidebarNav.member');?>"><?= lang('SidebarNav.member');?></div>
                                    </a>
                                </li>
                            <?php } ?>
                        </ul>
                    </li>
                <?php } ?>

                <?php
                if (
                    $this->dt_ci_acl->checkAccess("Vehicle|index") ||
                    $this->dt_ci_acl->checkAccess("ParkingSlot|index") ||
                    $this->dt_ci_acl->checkAccess("OwnershipFlat|index") ||
                    $this->dt_ci_acl->checkAccess("OwnershipFlat|manage") ||
                    $this->dt_ci_acl->checkAccess("TransferredFlat|index") ||
                    $this->dt_ci_acl->checkAccess("TransferredFlat|manage") ||
                    $this->dt_ci_acl->checkAccess("Rentals|index") ||
                    $this->dt_ci_acl->checkAccess("Rentals|manage") ||
                    $this->dt_ci_acl->checkAccess("Investments|index") ||
                    $this->dt_ci_acl->checkAccess("Investments|manage") ||
                    $this->dt_ci_acl->checkAccess("AMC|index") ||
                    $this->dt_ci_acl->checkAccess("AMC|manage") ||
                    $this->dt_ci_acl->checkAccess("Resource|index") ||
                    $this->dt_ci_acl->checkAccess("Resource|manage")
                ) {
                    ?>
                    <li class="menu-item main-menu">
                        <a href="javascript:void(0);" class="menu-link menu-toggle">
                            <i class="menu-icon tf-icons ti ti-layout-sidebar"></i>
                            <div data-i18n="<?= lang('SidebarNav.statutory_registers');?>"><?= lang('SidebarNav.statutory_registers');?></div>
                        </a>

                        <ul class="menu-sub">
                            <?php if ($this->dt_ci_acl->checkAccess("Vehicle|index")) { ?>
                                <li class="menu-item sub-menu <?= ($this->dt_ci_acl->getActiveMenu(array("Vehicle")))  ?>">
                                    <a href="<?= admin_url(); ?>Vehicle" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-user"></i>
                                        <div data-i18n="<?= lang('SidebarNav.vehicle');?>"><?= lang('SidebarNav.vehicle');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("ParkingSlot|index") ||
                                    $this->dt_ci_acl->checkAccess("ParkingSlot|addEdit")
                            ) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("ParkingSlot","ParkingSlot/addEdit")); ?>">
                                    <a href="<?= admin_url(); ?>ParkingSlot" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-list"></i>
                                        <!-- <i class="menu-icon tf-icons ti ti-parking-circle"></i> -->
                                        <div data-i18n="<?= lang('SidebarNav.parking_slot');?>"><?= lang('SidebarNav.parking_slot');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("OwnershipFlat|index") ||
                                    $this->dt_ci_acl->checkAccess("OwnershipFlat|manage")
                             ) { ?>
                                <li class="menu-item sub-menu <?= ($this->dt_ci_acl->getActiveMenu(array("OwnershipFlat", "OwnershipFlat/manage")))  ?>">
                                    <a href="<?= admin_url(); ?>OwnershipFlat?type=first_owner" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-user"></i>
                                        <div data-i18n="<?= lang('SidebarNav.ownership_flat');?>"><?= lang('SidebarNav.ownership_flat');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("TransferredFlat|index") ||
                                    $this->dt_ci_acl->checkAccess("TransferredFlat|manage")
                             ) { ?>
                                <li class="menu-item sub-menu <?= ($this->dt_ci_acl->getActiveMenu(array("TransferredFlat", "TransferredFlat/manage")))  ?>">
                                    <a href="<?= admin_url(); ?>TransferredFlat?type=transferred" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-user"></i>
                                        <div data-i18n="<?= lang('SidebarNav.transferred_flat');?>"><?= lang('SidebarNav.transferred_flat');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("Rentals|index") ||
                                    $this->dt_ci_acl->checkAccess("Rentals|manage")
                             ) { ?>
                                <li class="menu-item sub-menu <?= ($this->dt_ci_acl->getActiveMenu(array("Rentals", "Rentals/manage")))  ?>">
                                    <a href="<?= admin_url(); ?>Rentals" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-user"></i>
                                        <div data-i18n="<?= lang('SidebarNav.rentals');?>"><?= lang('SidebarNav.rentals');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("Investments|index") ||
                                    $this->dt_ci_acl->checkAccess("Investments|manage")
                             ) { ?>
                                <li class="menu-item sub-menu <?= ($this->dt_ci_acl->getActiveMenu(array("Investments", "Investments/manage")))  ?>">
                                    <a href="<?= admin_url(); ?>Investments" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-user"></i>
                                        <div data-i18n="<?= lang('SidebarNav.investment');?>"><?= lang('SidebarNav.investment');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("Resource|index") ||
                                    $this->dt_ci_acl->checkAccess("Resource|manage")
                                ) { ?>
                                <li class="menu-item sub-menu <?= ($this->dt_ci_acl->getActiveMenu(array("Resource", "Resource/manage")))  ?>">
                                <a href="<?= admin_url(); ?>Resource" class="menu-link">
                                    <i class="menu-icon tf-icons ti ti-list"></i>
                                    <div data-i18n="<?= lang('SidebarNav.man_power');?>"><?= lang('SidebarNav.man_power');?></div>
                                </a>
                            </li>
                            <?php } ?>
                        </ul>
                    </li>
                <?php } ?>

                <?php
                if (
                    $this->dt_ci_acl->checkAccess("Booking|index") ||
                    $this->dt_ci_acl->checkAccess("Booking|manage") ||
                    $this->dt_ci_acl->checkAccess("EventBooking|index") ||
                    $this->dt_ci_acl->checkAccess("EventBooking|manage") ||
                    $this->dt_ci_acl->checkAccess("Generator|index") ||
                    $this->dt_ci_acl->checkAccess("GeneratorReading|index") ||
                    $this->dt_ci_acl->checkAccess("GeneratorReading|manage") ||
                    $this->dt_ci_acl->checkAccess("WaterTank|index") ||
                    $this->dt_ci_acl->checkAccess("WaterMeterReading|index") ||
                    $this->dt_ci_acl->checkAccess("WaterMeterReading|manage") ||
                    $this->dt_ci_acl->checkAccess("AMC|index") ||
                    $this->dt_ci_acl->checkAccess("AMC|manage") ||
                    $this->dt_ci_acl->checkAccess("OrganicWasteRecord|index") ||
                    $this->dt_ci_acl->checkAccess("OrganicWasteRecord|manage")
                ) {
                    ?>
                    <li class="menu-item main-menu">
                        <a href="javascript:void(0);" class="menu-link menu-toggle">
                            <i class="menu-icon tf-icons ti ti-layout-sidebar"></i>
                            <div data-i18n="<?= lang('SidebarNav.activities');?>"><?= lang('SidebarNav.activities');?></div>
                        </a>

                        <ul class="menu-sub">
                            <?php if ($this->dt_ci_acl->checkAccess("Booking|index") ||
                                $this->dt_ci_acl->checkAccess("Booking|manage")
                                ) { ?>
                                <li class="menu-item sub-menu <?= ($this->dt_ci_acl->getActiveMenu(array("Booking", "Booking/manage")))  ?>">
                                    <a href="<?= admin_url(); ?>Booking" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-user"></i>
                                        <div data-i18n="<?= lang('SidebarNav.booking');?>"><?= lang('SidebarNav.booking');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("EventBooking|index") ||
                                    $this->dt_ci_acl->checkAccess("EventBooking|manage")
                                ) { ?>
                                <li class="menu-item sub-menu <?= ($this->dt_ci_acl->getActiveMenu(array("EventBooking", "EventBooking/manage")))  ?>">
                                    <a href="<?= admin_url(); ?>EventBooking" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-user"></i>
                                        <div data-i18n="<?= lang('SidebarNav.event_booking');?>"><?= lang('SidebarNav.event_booking');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("Generator|index")||
                                        $this->dt_ci_acl->checkAccess("Generator|addEdit")
                                ) { ?>
                                    <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("Generator","Generator/addEdit")); ?>">
                                        <a href="<?= admin_url(); ?>Generator" class="menu-link">
                                            <!-- <i class="menu-icon tf-icons ti ti-list"></i> -->
                                            <i class="menu-icon ti ti-home-bolt"></i>
                                            <div data-i18n="<?= lang('SidebarNav.generator');?>"><?= lang('SidebarNav.generator');?></div>
                                        </a>
                                    </li>
                                <?php } ?>
            
                                <?php if ($this->dt_ci_acl->checkAccess("GeneratorReading|index")||
                                        $this->dt_ci_acl->checkAccess("GeneratorReading|manage")
                                ) { ?>
                                    <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("GeneratorReading","GeneratorReading/manage")); ?>">
                                        <a href="<?= admin_url(); ?>GeneratorReading" class="menu-link">
                                            <!-- <i class="menu-icon tf-icons ti ti-list"></i> -->
                                            <i class="menu-icon tf-icons ti ti-file-power"></i>
                                            <div data-i18n="<?= lang('SidebarNav.generator_reading');?>"><?= lang('SidebarNav.generator_reading');?></div>
                                        </a>
                                    </li>
                                <?php } ?>
                                <?php if ($this->dt_ci_acl->checkAccess("WaterTank|index") ||
                                        $this->dt_ci_acl->checkAccess("WaterTank|addEdit")
                                ) { ?>
                                    <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("WaterTank","WaterTank|addEdit")); ?>">
                                        <a href="<?= admin_url(); ?>WaterTank" class="menu-link">
                                            <i class="menu-icon ti ti-cylinder"></i>
                                            <div data-i18n="<?= lang('SidebarNav.water_tank');?>"><?= lang('SidebarNav.water_tank');?></div>
                                        </a>
                                    </li>
                                <?php } ?>
            
                                <?php if ($this->dt_ci_acl->checkAccess("WaterMeterReading|index") ||
                                        $this->dt_ci_acl->checkAccess("WaterMeterReading|manage")
                                 ) { ?>
                                    <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("WaterMeterReading","WaterMeterReading/manage")); ?>">
                                        <a href="<?= admin_url(); ?>WaterMeterReading" class="menu-link">
                                            <i class="menu-icon tf-icons ti ti-list"></i>
                                            <div data-i18n="<?= lang('SidebarNav.water_meter_reading');?>"><?= lang('SidebarNav.water_meter_reading');?></div>
                                        </a>
                                    </li>
                                <?php } ?>

                                <?php if ($this->dt_ci_acl->checkAccess("AMC|index") ||
                                    $this->dt_ci_acl->checkAccess("AMC|manage")
                             ) { ?>
                                <li class="menu-item sub-menu <?= ($this->dt_ci_acl->getActiveMenu(array("AMC", "AMC/manage")))  ?>">
                                    <a href="<?= admin_url(); ?>AMC" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-user"></i>
                                        <div data-i18n="<?= lang('SidebarNav.amc_details');?>"><?= lang('SidebarNav.amc_details');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("OrganicWasteRecord|index") ||
                                    $this->dt_ci_acl->checkAccess("OrganicWasteRecord|manage")
                             ) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("OrganicWasteRecord","OrganicWasteRecord/manage")); ?>">
                                    <a href="<?= admin_url(); ?>OrganicWasteRecord" class="menu-link">
                                        <i class="menu-icon ti ti-trash-x"></i>
                                        <div data-i18n="<?= lang('SidebarNav.organic_waste');?>"><?= lang('SidebarNav.organic_waste');?></div>
                                    </a>
                                </li>
                            <?php } ?>
                        </ul>
                    </li>
                <?php } ?>

                <?php
                if (
                    $this->dt_ci_acl->checkAccess("LetterHead|index") ||
                    $this->dt_ci_acl->checkAccess("LetterHead|manage") ||
                    $this->dt_ci_acl->checkAccess("Voucher|index") ||
                    $this->dt_ci_acl->checkAccess("Voucher|manage") ||
                    $this->dt_ci_acl->checkAccess("Receipt|index") ||
                    $this->dt_ci_acl->checkAccess("Receipt|manage") ||
                    $this->dt_ci_acl->checkAccess("SinkingFund|index") ||
                    $this->dt_ci_acl->checkAccess("SinkingFund|manage")
                ) {
                    ?>
                    <li class="menu-item main-menu">
                        <a href="javascript:void(0);" class="menu-link menu-toggle">
                            <i class="menu-icon tf-icons ti ti-layout-sidebar"></i>
                            <div data-i18n="<?= lang('SidebarNav.fill_n_print');?>"><?= lang('SidebarNav.fill_n_print');?></div>
                        </a>

                        <ul class="menu-sub">
                            <?php if ($this->dt_ci_acl->checkAccess("LetterHead|index") || $this->dt_ci_acl->checkAccess("LetterHead|manage")) { ?>
                                <li class="menu-item sub-menu <?= ($this->dt_ci_acl->getActiveMenu(array("LetterHead", "LetterHead/manage")))  ?>">
                                    <a href="<?= admin_url(); ?>LetterHead" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-user"></i>
                                        <div data-i18n="<?= lang('SidebarNav.letter_head');?>"><?= lang('SidebarNav.letter_head');?></div>
                                    </a>
                                </li>
                            <?php } ?>
                            <?php if ($this->dt_ci_acl->checkAccess("Receipt|index") ||
                                    $this->dt_ci_acl->checkAccess("Receipt|manage")
                                ) { ?>
                                <li class="menu-item sub-menu <?= ($this->dt_ci_acl->getActiveMenu(array("Receipt", "Receipt/manage")))  ?>">
                                    <a href="<?= admin_url(); ?>Receipt" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-list"></i>
                                        <div data-i18n="<?= lang('SidebarNav.receipts');?>"><?= lang('SidebarNav.receipts');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("Voucher|index") ||
                                    $this->dt_ci_acl->checkAccess("Voucher|manage")
                                ) { ?>
                                <li class="menu-item sub-menu <?= ($this->dt_ci_acl->getActiveMenu(array("Voucher", "Voucher/manage")))  ?>">
                                    <a href="<?= admin_url(); ?>Voucher" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-list"></i>
                                        <div data-i18n="<?= lang('SidebarNav.voucher');?>"><?= lang('SidebarNav.voucher');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("SinkingFund|index") ||
                                    $this->dt_ci_acl->checkAccess("SinkingFund|manage")
                                ) { ?>
                                <li class="menu-item sub-menu <?= ($this->dt_ci_acl->getActiveMenu(array("SinkingFund", "SinkingFund/manage")))  ?>">
                                    <a href="<?= admin_url(); ?>SinkingFund/" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-list"></i>
                                        <div data-i18n="<?= lang('SidebarNav.sinking_fund');?>"><?= lang('SidebarNav.sinking_fund');?></div>
                                    </a>
                                </li>
                            <?php } ?>
                        </ul>
                    </li>
                <?php } ?>
                <?php
                if (
                    $this->dt_ci_acl->checkAccess("MenPowerAttendance|index") ||
                    $this->dt_ci_acl->checkAccess("MenPowerAttendance|manage") ||
                    $this->dt_ci_acl->checkAccess("Complain|index") ||
                    $this->dt_ci_acl->checkAccess("Complain|manage") ||
                    $this->dt_ci_acl->checkAccess("Visitor|index") ||
                    $this->dt_ci_acl->checkAccess("PollVotes|index") ||
                    $this->dt_ci_acl->checkAccess("PollVotesDetail|index") ||
                    $this->dt_ci_acl->checkAccess("RsvpMeeting|index")
                ) {
                    ?>
                    <li class="menu-item main-menu">
                        <a href="javascript:void(0);" class="menu-link menu-toggle">
                            <i class="menu-icon tf-icons ti ti-layout-sidebar"></i>
                            <div data-i18n="<?= lang('SidebarNav.records');?>"><?= lang('SidebarNav.records');?></div>
                        </a>

                        <ul class="menu-sub">
                            <?php if ($this->dt_ci_acl->checkAccess("MenPowerAttendance|index") ||
                                    $this->dt_ci_acl->checkAccess("MenPowerAttendance|manage")
                            ) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("MenPowerAttendance","MenPowerAttendance/manage")); ?>">
                                    <a href="<?= admin_url(); ?>MenPowerAttendance" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-user-check"></i>
                                        <div data-i18n="<?= lang('SidebarNav.men_power_attendance');?>"><?= lang('SidebarNav.men_power_attendance');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("Complain|index") ||
                                    $this->dt_ci_acl->checkAccess("Complain|manage")
                            ) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("Complain","Complain/manage")); ?>">
                                    <a href="<?= admin_url(); ?>Complain" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-help"></i>
                                        <div data-i18n="<?= lang('SidebarNav.complain');?>"><?= lang('SidebarNav.complain');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("Visitor|index") ||
                                    $this->dt_ci_acl->checkAccess("Visitor|manage")
                             ) { ?>
                                <li class="menu-item sub-menu <?= ($this->dt_ci_acl->getActiveMenu(array("Visitor", "Visitor/manage")))  ?>">
                                    <a href="<?= admin_url(); ?>Visitor" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-user"></i>
                                        <div data-i18n="<?= lang('SidebarNav.visitor');?>"><?= lang('SidebarNav.visitor');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("PollVotes|index")) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("PollVotes")); ?>">

                                    <a href="<?= admin_url(); ?>PollVotes" class="menu-link">
                                    <i class="menu-icon tf-icons ti ti-list"></i>
                                        <div data-i18n="<?= lang('SidebarNav.poll_votes');?>"><?= lang('SidebarNav.poll_votes');?></div>
                                    </a>

                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("PollVotesDetail|index")) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("PollVotesDetail")); ?>">

                                    <a href="<?= admin_url(); ?>PollVotesDetail" class="menu-link">
                                    <i class="menu-icon tf-icons ti ti-list"></i>
                                        <div data-i18n="<?= lang('SidebarNav.poll_votes_detail');?>"><?= lang('SidebarNav.poll_votes_detail');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("RsvpMeeting|index")
                             ) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("RsvpMeeting")); ?>">
                                    <a href="<?= admin_url(); ?>RsvpMeeting" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-calendar-time"></i>
                                        <div data-i18n="<?= lang('SidebarNav.rsvp_meeting');?>"><?= lang('SidebarNav.rsvp_meeting');?></div>
                                    </a>
                                </li>
                            <?php } ?>
                        </ul>
                    </li>
                <?php } ?>

                <?php
                if (
                    $this->dt_ci_acl->checkAccess("Budget|index") ||
                    $this->dt_ci_acl->checkAccess("Budget|manage")
                ) {
                    ?>
                    <li class="menu-item main-menu">
                        <a href="javascript:void(0);" class="menu-link menu-toggle">
                            <i class="menu-icon tf-icons ti ti-layout-sidebar"></i>
                            <div data-i18n="<?= lang('SidebarNav.utilities');?>"><?= lang('SidebarNav.utilities');?></div>
                        </a>

                        <ul class="menu-sub">
                            <?php if ($this->dt_ci_acl->checkAccess("Budget|index") ||
                                    $this->dt_ci_acl->checkAccess("Budget|manage")
                             ) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("Budget","Budget/manage")); ?>">
                                    <a href="<?= admin_url(); ?>Budget" class="menu-link">
                                        <i class="menu-icon ti ti-calendar-dollar"></i>
                                        <div data-i18n="<?= lang('SidebarNav.budget');?>"><?= lang('SidebarNav.budget');?></div>
                                    </a>
                                </li>
                            <?php } ?>
                        </ul>
                    </li>
                <?php } ?>

                <?php
                if (
                    $this->dt_ci_acl->checkAccess("Document|index") ||
                    $this->dt_ci_acl->checkAccess("Document|manage") ||
                    $this->dt_ci_acl->checkAccess("DocumentFolder|index") ||
                    $this->dt_ci_acl->checkAccess("DocumentFolder|manage")
                ) {
                    ?>
                    <li class="menu-item main-menu">
                        <a href="javascript:void(0);" class="menu-link menu-toggle">
                            <i class="menu-icon tf-icons ti ti-layout-sidebar"></i>
                            <div data-i18n="<?= lang('SidebarNav.uploads');?>"><?= lang('SidebarNav.uploads');?></div>
                        </a>

                        <ul class="menu-sub">
                            <?php if (
                                $this->dt_ci_acl->checkAccess("Document|index") ||
                                $this->dt_ci_acl->checkAccess("Document|manage")
                            ) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("Document","Document/manage")); ?>">
                                    <a href="<?= admin_url(); ?>Document" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-file-description"></i>
                                        <div data-i18n="<?= lang('SidebarNav.document');?>"><?= lang('SidebarNav.document');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if (
                                    $this->dt_ci_acl->checkAccess("DocumentFolder|index") ||
                                    $this->dt_ci_acl->checkAccess("DocumentFolder|manage")
                                ) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("DocumentFolder","DocumentFolder/manage")); ?>">
                                    <a href="<?= admin_url(); ?>DocumentFolder" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-file-description"></i>
                                        <div data-i18n="<?= lang('SidebarNav.document_folder');?>"><?= lang('SidebarNav.document_folder');?></div>
                                    </a>
                                </li>
                            <?php } ?>
                        </ul>
                    </li>
                <?php } ?>

                <?php
                if (
                    $this->dt_ci_acl->checkAccess("Society|index") ||
                    
                    $this->dt_ci_acl->checkAccess("Flat|index") ||
                    // $this->dt_ci_acl->checkAccess("Flat|manage") ||
                    $this->dt_ci_acl->checkAccess("Tower|index") ||
                    $this->dt_ci_acl->checkAccess("VisitorCompany|index") ||
                    $this->dt_ci_acl->checkAccess("Tax|index") ||
                    $this->dt_ci_acl->checkAccess("Category|index") ||
                    $this->dt_ci_acl->checkAccess("ResourceType|index") ||
                    $this->dt_ci_acl->checkAccess("ParkingArea|index") ||
                    $this->dt_ci_acl->checkAccess("ParkingArea|manage") ||
                    $this->dt_ci_acl->checkAccess("CommonArea|index") ||
                    $this->dt_ci_acl->checkAccess("ActivityLog|index") ||
                    $this->dt_ci_acl->checkAccess("Bank|index") ||
                    $this->dt_ci_acl->checkAccess("BankAccount|index") ||
                    $this->dt_ci_acl->checkAccess("BankAccount|manage") ||
                    $this->dt_ci_acl->checkAccess("Service|index") ||
                    $this->dt_ci_acl->checkAccess("Service|manage") ||
                    $this->dt_ci_acl->checkAccess("Charges|index") ||
                    $this->dt_ci_acl->checkAccess("Charges|manage") ||
                    $this->dt_ci_acl->checkAccess("Status|index") ||
                    $this->dt_ci_acl->checkAccess("Status|manage") ||
                    $this->dt_ci_acl->checkAccess("Meeting|index") ||
                    $this->dt_ci_acl->checkAccess("Meeting|manage") ||
                    $this->dt_ci_acl->checkAccess("Broker|index") ||
                    $this->dt_ci_acl->checkAccess("Broker|manage") ||
                    $this->dt_ci_acl->checkAccess("Gate|index") ||
                    $this->dt_ci_acl->checkAccess("Gate|manage") ||
                    $this->dt_ci_acl->checkAccess("Notice|index") ||
                    $this->dt_ci_acl->checkAccess("Notice|manage") ||
                    $this->dt_ci_acl->checkAccess("Notification|index") ||
                    $this->dt_ci_acl->checkAccess("Comment|index") ||
                    $this->dt_ci_acl->checkAccess("TagAssign|index") ||
                    $this->dt_ci_acl->checkAccess("TagAssign|manage") ||
                    $this->dt_ci_acl->checkAccess("Faq|index") ||
                    $this->dt_ci_acl->checkAccess("Faq|manage") ||
                    $this->dt_ci_acl->checkAccess("Banner|index") ||
                    $this->dt_ci_acl->checkAccess("Banner|manage") ||
                    $this->dt_ci_acl->checkAccess("Forum|index") ||
                    $this->dt_ci_acl->checkAccess("Forum|manage") ||
                    $this->dt_ci_acl->checkAccess("EmergencyContact|index") ||
                    $this->dt_ci_acl->checkAccess("EmergencyContact|manage") ||
                    // $this->dt_ci_acl->checkAccess("Sos|index") ||
                    // $this->dt_ci_acl->checkAccess("Sos|manage") ||
                    $this->dt_ci_acl->checkAccess("SosEmergency|index") ||
                    $this->dt_ci_acl->checkAccess("Account|index") ||
                    $this->dt_ci_acl->checkAccess("Account|manage") ||
                    $this->dt_ci_acl->checkAccess("SubAccount|index") ||
                    $this->dt_ci_acl->checkAccess("SubAccount|manage")
                ) {
                    ?>
                    <li class="menu-item main-menu">
                        <a href="javascript:void(0);" class="menu-link menu-toggle">
                            <i class="menu-icon tf-icons ti ti-layout-sidebar"></i>
                            <div data-i18n="<?= lang('SidebarNav.master');?>"><?= lang('SidebarNav.master');?></div>
                        </a>

                        <ul class="menu-sub">
                            <?php if (
                                $this->dt_ci_acl->checkAccess("Society|index") ||
                                $this->dt_ci_acl->checkAccess("Society|manage")
                            ) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("Society","Society/manage")); ?>">

                                    <a href="<?= admin_url(); ?>Society" class="menu-link">
                                        <!-- <i class="menu-icon tf-icons ti ti-list"></i> -->
                                        <i class="menu-icon tf-icons ti ti-social"></i>
                                        <div data-i18n="<?= lang('SidebarNav.society');?>"><?= lang('SidebarNav.society');?></div>
                                    </a>

                                </li>
                            <?php } ?>
                            <?php if ($this->dt_ci_acl->checkAccess("Tower|index")||
                                    $this->dt_ci_acl->checkAccess("Tower|manage")
                            ) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("Tower","Tower/manage")); ?>">
                                    <a href="<?= admin_url(); ?>Tower" class="menu-link">
                                        <!-- <i class="menu-icon tf-icons ti ti-building-plus"></i> -->
                                         <i class="menu-icon ti ti-building-skyscraper"></i>
                                        <!-- <i class="menu-icon fa-solid fa-building"></i> -->
                                        <div data-i18n="<?= lang('SidebarNav.tower');?>"><?= lang('SidebarNav.tower');?></div>
                                    </a>
                                </li>
                            <?php } ?>
                            <?php if ($this->dt_ci_acl->checkAccess("VisitorCompany|index")||
                                    $this->dt_ci_acl->checkAccess("VisitorCompany|addEdit")
                            ) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("VisitorCompany","VisitorCompany/addEdit")); ?>">
                                    <a href="<?= admin_url(); ?>VisitorCompany" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-building"></i>
                                        <div data-i18n="<?= lang('SidebarNav.visitor_company');?>"><?= lang('SidebarNav.visitor_company');?></div>
                                    </a>
                                </li>
                            <?php } ?>
                            <?php if ($this->dt_ci_acl->checkAccess("Tax|index") ||
                                    $this->dt_ci_acl->checkAccess("Tax|addEdit")) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("Tax","Tax/addEdit")); ?>">
                                    <a href="<?= admin_url(); ?>Tax" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-receipt-tax"></i>
                                        <div data-i18n="<?= lang('SidebarNav.tax');?>"><?= lang('SidebarNav.tax');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("Category|index") ||
                                    $this->dt_ci_acl->checkAccess("Category|addEdit")
                            ) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("Category","Category/addEdit")); ?>">
                                    <a href="<?= admin_url(); ?>Category" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-category"></i>
                                        <div data-i18n="<?= lang('SidebarNav.category');?>"><?= lang('SidebarNav.category');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("ResourceType|index") ||
                                    $this->dt_ci_acl->checkAccess("ResourceType|addEdit")
                            ) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("ResourceType")); ?>">
                                    <a href="<?= admin_url(); ?>ResourceType" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-category"></i>
                                        <div data-i18n="<?= lang('SidebarNav.resource_type');?>"><?= lang('SidebarNav.resource_type');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("Flat|index") || 
                                    $this->dt_ci_acl->checkAccess("Flat|manage")
                            ) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("Flat","Flat/manage")); ?>">
                                    <a href="<?= admin_url(); ?>Flat" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-building-community"></i>
                                        <div data-i18n="<?= lang('SidebarNav.flat');?>"><?= lang('SidebarNav.flat');?></div>
                                    </a>
                                </li>
                            <?php }?>
                    
                            <?php if ($this->dt_ci_acl->checkAccess("Gate|index") || 
                                    $this->dt_ci_acl->checkAccess("Gate|manage")
                            ) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("Gate","Gate/manage")); ?>">
                                    <a href="<?= admin_url(); ?>Gate" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-door"></i>
                                        <div data-i18n="<?= lang('SidebarNav.gate');?>"><?= lang('SidebarNav.gate');?></div>
                                    </a>
                                </li>
                            <?php }?>
                            
                            <?php if ($this->dt_ci_acl->checkAccess("ParkingArea|index") ||
                                    $this->dt_ci_acl->checkAccess("ParkingArea|manage")
                            ) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("ParkingArea","ParkingArea/manage")); ?>">
                                    <a href="<?= admin_url(); ?>ParkingArea" class="menu-link">
                                        <i class="menu-icon ti ti-parking"></i>
                                        <div data-i18n="<?= lang('SidebarNav.parking_area');?>"><?= lang('SidebarNav.parking_area');?></div>
                                    </a>
                                </li>
                            <?php }?>
                            
                            
                            <?php if ($this->dt_ci_acl->checkAccess("CommonArea|index") ||
                                    $this->dt_ci_acl->checkAccess("CommonArea|addEdit")) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("CommonArea","CommonArea/addEdit")); ?>">
                                    <a href="<?= admin_url(); ?>CommonArea" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-list"></i>
                                        <div data-i18n="<?= lang('SidebarNav.common_area');?>"><?= lang('SidebarNav.common_area');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            
                            <?php if ($this->dt_ci_acl->checkAccess("ManagementCommitteeResponsibilities|index") || 
                                    $this->dt_ci_acl->checkAccess("ManagementCommitteeResponsibilities|addEdit")) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("ManagementCommitteeResponsibilities","ManagementCommitteeResponsibilities/addEdit")); ?>">
                                    <a href="<?= admin_url(); ?>ManagementCommitteeResponsibilities" class="menu-link">
                                        <!-- <i class="menu-icon tf-icons ti ti-list"></i> -->
                                        <i class="menu-icon tf-icons ti ti-checklist"></i>
                                        <div data-i18n="<?= lang('SidebarNav.responsibilities');?>"><?= lang('SidebarNav.responsibilities');?></div>
                                    </a>
                                </li>
                            <?php } ?>
                            

                             <?php if ($this->dt_ci_acl->checkAccess("Bank|index") ||
                                        $this->dt_ci_acl->checkAccess("Bank|addEdit")
                             ) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("Bank","Bank|addEdit")); ?>">
                                    <a href="<?= admin_url(); ?>Bank" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-building-bank"></i>
                                        <div data-i18n="<?= lang('SidebarNav.bank');?>"><?= lang('SidebarNav.bank');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                             <?php if ($this->dt_ci_acl->checkAccess("BankAccount|index") ||
                                    $this->dt_ci_acl->checkAccess("BankAccount|manage")
                             ) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("BankAccount","BankAccount/manage")); ?>">
                                    <a href="<?= admin_url(); ?>BankAccount" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-credit-card"></i>
                                        <div data-i18n="<?= lang('SidebarNav.bank_account');?>"><?= lang('SidebarNav.bank_account');?></div>
                                    </a>
                                </li>
                            <?php } ?>


                            <?php if ($this->dt_ci_acl->checkAccess("Broker|index") ||
                                    $this->dt_ci_acl->checkAccess("Broker|manage")
                             ) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("Broker","Broker/manage")); ?>">
                                    <a href="<?= admin_url(); ?>Broker" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-heart-handshake"></i>
                                        <div data-i18n="<?= lang('SidebarNav.broker');?>"><?= lang('SidebarNav.broker');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("Service|index") ||
                                    $this->dt_ci_acl->checkAccess("Service|manage")
                             ) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("Service","Service/manage")); ?>">
                                    <a href="<?= admin_url(); ?>Service" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-list"></i>
                                        <div data-i18n="<?= lang('SidebarNav.service');?>"><?= lang('SidebarNav.service');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("Charges|index") ||
                                    $this->dt_ci_acl->checkAccess("Charges|manage")
                             ) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("Charges","Charges/manage")); ?>">
                                    <a href="<?= admin_url(); ?>Charges" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-receipt-2"></i>
                                        <div data-i18n="<?= lang('SidebarNav.charges');?>"><?= lang('SidebarNav.charges');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("Status|index") ||
                                    $this->dt_ci_acl->checkAccess("Status|manage")
                             ) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("Status","Status/manage")); ?>">
                                    <a href="<?= admin_url(); ?>Status" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-list"></i>
                                        <div data-i18n="<?= lang('SidebarNav.status');?>"><?= lang('SidebarNav.status');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("Meeting|index") ||
                                    $this->dt_ci_acl->checkAccess("Meeting|manage")
                             ) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("Meeting","Meeting/manage")); ?>">
                                    <a href="<?= admin_url(); ?>Meeting" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-calendar-time"></i>
                                        <div data-i18n="<?= lang('SidebarNav.meeting');?>"><?= lang('SidebarNav.meeting');?></div>
                                    </a>
                                </li>
                            <?php } ?>
                            
                            <?php if ($this->dt_ci_acl->checkAccess("Notice|index") ||
                                    $this->dt_ci_acl->checkAccess("Notice|manage")
                             ) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("Notice","Notice/manage")); ?>">
                                    <a href="<?= admin_url(); ?>Notice" class="menu-link">
                                        <i class="menu-icon ti ti-message-chatbot"></i>
                                        <div data-i18n="<?= lang('SidebarNav.notice');?>"><?= lang('SidebarNav.notice');?></div>
                                    </a>
                                </li>
                            <?php } ?>


                            <?php if ($this->dt_ci_acl->checkAccess("Notification|index")) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("Notification")); ?>">
                                    <a href="<?= admin_url(); ?>Notification" class="menu-link">
                                         <i class="menu-icon ti ti-bell-ringing"></i>
                                        <div data-i18n="<?= lang('SidebarNav.notification');?>"><?= lang('SidebarNav.notification');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("Comment|index")) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("Comment")); ?>">
                                    <a href="<?= admin_url(); ?>Comment" class="menu-link">
                                         <i class="menu-icon tf-icons ti ti-list"></i>
                                        <div data-i18n="<?= lang('SidebarNav.comment');?>"><?= lang('SidebarNav.comment');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("Faq|index") ||
                                    $this->dt_ci_acl->checkAccess("Faq|manage")
                             ) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("Faq","Faq/manage")); ?>">
                                    <a href="<?= admin_url(); ?>Faq" class="menu-link">
                                        <i class="menu-icon ti ti-help-circle-filled"></i>
                                        <div data-i18n="<?= lang('SidebarNav.faq');?>"><?= lang('SidebarNav.faq');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("Tag|index") ||
                                    $this->dt_ci_acl->checkAccess("Tag|manage")
                             ) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("Tag","Tag/manage")); ?>">
                                    <a href="<?= admin_url(); ?>Tag" class="menu-link">
                                        <i class="menu-icon ti ti-tag"></i>
                                        <div data-i18n="<?= lang('SidebarNav.tag');?>"><?= lang('SidebarNav.tag');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("TagAssign|index") ||
                                    $this->dt_ci_acl->checkAccess("TagAssign|manage")
                             ) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("TagAssign","TagAssign/manage")); ?>">
                                    <a href="<?= admin_url(); ?>TagAssign" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-list"></i>
                                        <div data-i18n="<?= lang('SidebarNav.tag_assign');?>"><?= lang('SidebarNav.tag_assign');?></div>
                                    </a>
                                </li>
                            <?php } ?>
                            

                            <?php if ($this->dt_ci_acl->checkAccess("Forum|index") ||
                                    $this->dt_ci_acl->checkAccess("Forum|manage")
                             ) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("Forum","Forum/manage")); ?>">
                                    <a href="<?= admin_url(); ?>Forum" class="menu-link">
                                        <i class="menu-icon ti ti-writing-sign"></i>
                                        <div data-i18n="<?= lang('SidebarNav.forum');?>"><?= lang('SidebarNav.forum');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("Banner|index") ||
                                    $this->dt_ci_acl->checkAccess("Banner|manage")
                             ) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("Banner","Banner/manage")); ?>">
                                    <a href="<?= admin_url(); ?>Banner" class="menu-link">
                                        <i class="menu-icon ti ti-device-tv"></i>
                                        <div data-i18n="<?= lang('SidebarNav.banner');?>"><?= lang('SidebarNav.banner');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("EmergencyContact|index") ||
                                    $this->dt_ci_acl->checkAccess("EmergencyContact|manage")
                             ) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("EmergencyContact","EmergencyContact/manage")); ?>">
                                    <a href="<?= admin_url(); ?>EmergencyContact" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-list"></i>
                                        <div data-i18n="<?= lang('SidebarNav.emergency_contact');?>"><?= lang('SidebarNav.emergency_contact');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("Account|index") ||
                                    $this->dt_ci_acl->checkAccess("Account|manage")
                             ) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("Account","Account/manage")); ?>">
                                    <a href="<?= admin_url(); ?>Account" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-list"></i>
                                        <div data-i18n="<?= lang('SidebarNav.account');?>"><?= lang('SidebarNav.account');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("SubAccount|index") ||
                                    $this->dt_ci_acl->checkAccess("SubAccount|manage")
                             ) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("SubAccount","SubAccount/manage")); ?>">
                                    <a href="<?= admin_url(); ?>SubAccount" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-list"></i>
                                        <div data-i18n="<?= lang('SidebarNav.sub_account');?>"><?= lang('SidebarNav.sub_account');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("SosEmergency|index") ||
                                    $this->dt_ci_acl->checkAccess("SosEmergency|manage")
                             ) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("SosEmergency","SosEmergency/manage")); ?>">
                                    <a href="<?= admin_url(); ?>SosEmergency" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-list"></i>
                                        <div data-i18n="<?= lang('SidebarNav.sos_emergency');?>"><?= lang('SidebarNav.sos_emergency');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("ActivityLog|index")) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("ActivityLog")); ?>">
                                    <a href="<?= admin_url(); ?>ActivityLog" class="menu-link">
                                        <i class="menu-icon ti ti-align-box-left-bottom"></i>
                                        <div data-i18n="<?= lang('SidebarNav.activity_log');?>"><?= lang('SidebarNav.activity_log');?></div>
                                    </a>
                                </li>
                            <?php } ?>
                        </ul>
                    </li>
                <?php } ?>

                <!-- vendor-app menu start -->
                <?php
                if (
                    $this->dt_ci_acl->checkAccess("Vendor|index") ||
                    $this->dt_ci_acl->checkAccess("Vendor|manage") ||
                    $this->dt_ci_acl->checkAccess("Visit|index") ||
                    $this->dt_ci_acl->checkAccess("Visit|index") 
                ) {
                    ?>
                    <li class="menu-item main-menu">
                        <a href="javascript:void(0);" class="menu-link menu-toggle">
                            <i class="menu-icon tf-icons ti ti-layout-sidebar"></i>
                            <div data-i18n="<?= lang('SidebarNav.vendor');?>"><?= lang('SidebarNav.vendor');?></div>
                        </a>

                        <ul class="menu-sub">
                            <?php if ($this->dt_ci_acl->checkAccess("Vendor|index") ||
                                    $this->dt_ci_acl->checkAccess("Vendor|manage")
                             ) { ?>
                                <li class="menu-item sub-menu <?= ($this->dt_ci_acl->getActiveMenu(array("Vendor", "Vendor/manage")))  ?>">
                                    <a href="<?= admin_url(); ?>Vendor" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-user"></i>
                                        <div data-i18n="<?= lang('SidebarNav.vendor');?>"><?= lang('SidebarNav.vendor');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            
                            <?php if ($this->dt_ci_acl->checkAccess("Visit|index") ||
                                    $this->dt_ci_acl->checkAccess("Visit|manage")
                             ) { ?>
                                <li class="menu-item sub-menu <?= ($this->dt_ci_acl->getActiveMenu(array("Visit", "Visit/manage")))  ?>">
                                    <a href="<?= admin_url(); ?>Visit" class="menu-link">
                                        <i class="menu-icon ti ti-brand-google-maps"></i>
                                        <div data-i18n="<?= lang('SidebarNav.visit');?>"><?= lang('SidebarNav.visit');?></div>
                                    </a>
                                </li>
                            <?php } ?>
                        </ul>
                    </li>
                <?php } ?>
                <!-- vendor-app menu end -->


                <?php
                if (
                    $this->dt_ci_acl->checkAccess("Intercom|index") ||
                    $this->dt_ci_acl->checkAccess("Intercom|manage") 
                    // $this->dt_ci_acl->checkAccess("FlatSquareFeetArea|index") ||
                    // $this->dt_ci_acl->checkAccess("FlatSquareFeetArea|manage") ||
                ) {
                    ?>
                    <li class="menu-item main-menu">
                        <a href="javascript:void(0);" class="menu-link menu-toggle">
                            <i class="menu-icon tf-icons ti ti-layout-sidebar"></i>
                            <div data-i18n="<?= lang('SidebarNav.flat');?>"><?= lang('SidebarNav.flat');?></div>
                        </a>

                        <ul class="menu-sub">
                            <?php if ($this->dt_ci_acl->checkAccess("Intercom|index") ||
                                    $this->dt_ci_acl->checkAccess("Intercom|manage")
                                    ) { ?>
                                <li class="menu-item sub-menu <?= ($this->dt_ci_acl->getActiveMenu(array("Intercom", "Intercom/manage")))  ?>">
                                <a href="<?= admin_url(); ?>Intercom" class="menu-link">
                                    <i class="menu-icon tf-icons ti ti-user"></i>
                                    <div data-i18n="<?= lang('SidebarNav.intercom');?>"><?= lang('SidebarNav.intercom');?></div>
                                </a>
                            </li>
                            <?php } ?>
                        </ul>
                    </li>
                <?php } ?>
                <!-- FlatSquareFeetArea-app menu start -->

                <?php
                if (

                    $this->dt_ci_acl->checkAccess("Amenities|index") ||
                    // $this->dt_ci_acl->checkAccess("TimeSlot|index") ||
                    // $this->dt_ci_acl->checkAccess("TimeSlot|manage") ||
                    $this->dt_ci_acl->checkAccess("BookingCalendar|index")

                ) {
                    ?>
                    <li class="menu-item main-menu">
                        <a href="javascript:void(0);" class="menu-link menu-toggle">
                            <i class="menu-icon tf-icons ti ti-layout-sidebar"></i>
                            <div data-i18n="<?= lang('SidebarNav.booking');?>"><?= lang('SidebarNav.booking');?></div>
                        </a>

                        <ul class="menu-sub">
                            <?php if ($this->dt_ci_acl->checkAccess("Amenities|index") ||
                                    $this->dt_ci_acl->checkAccess("Amenities|manage")
                                    ) { ?>
                                <li class="menu-item sub-menu <?= ($this->dt_ci_acl->getActiveMenu(array("Amenities", "Amenities/manage")))  ?>">
                                <a href="<?= admin_url(); ?>Amenities" class="menu-link">
                                    <i class="menu-icon tf-icons ti ti-user"></i>
                                    <div data-i18n="<?= lang('SidebarNav.amenities');?>"><?= lang('SidebarNav.amenities');?></div>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if ($this->dt_ci_acl->checkAccess("BookingCalendar|index")) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("BookingCalendar")); ?>">
                                    <a href="<?= admin_url(); ?>BookingCalendar" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-calendar"></i>
                                        <div data-i18n="<?= lang('SidebarNav.booking_calender');?>"><?= lang('SidebarNav.booking_calender');?></div>
                                    </a>

                                </li>
                            <?php } ?>
                        </ul>
                    </li>
                <?php } ?>

                <!-- Event -->
                <?php
                if (
                    $this->dt_ci_acl->checkAccess("Event|index") ||
                    $this->dt_ci_acl->checkAccess("Event|manage")
                ) {
                    ?>
                    <li class="menu-item main-menu">
                        <a href="javascript:void(0);" class="menu-link menu-toggle">
                            <i class="menu-icon tf-icons ti ti-layout-sidebar"></i>
                            <div data-i18n="<?= lang('SidebarNav.event');?>"><?= lang('SidebarNav.event');?></div>
                        </a>

                        <ul class="menu-sub">
                            <?php if ($this->dt_ci_acl->checkAccess("Event|index") ||
                                    $this->dt_ci_acl->checkAccess("Event|manage")
                                ) { ?>
                                <li class="menu-item sub-menu <?= ($this->dt_ci_acl->getActiveMenu(array("Event", "Event/manage")))  ?>">
                                <a href="<?= admin_url(); ?>Event" class="menu-link">
                                    <i class="menu-icon tf-icons ti ti-user"></i>
                                    <div data-i18n="<?= lang('SidebarNav.event');?>"><?= lang('SidebarNav.event');?></div>
                                </a>
                            </li>
                            <?php } ?>
                        </ul>
                    </li>
                <?php } ?>
                <!-- Event -->

                <?php
                if (
                    $this->dt_ci_acl->checkAccess("Manufacturer|index") ||
                    $this->dt_ci_acl->checkAccess("Item|index") ||
                    $this->dt_ci_acl->checkAccess("Item|manage") ||
                    $this->dt_ci_acl->checkAccess("Material|index") ||
                    $this->dt_ci_acl->checkAccess("Material|manage") ||
                    $this->dt_ci_acl->checkAccess("Material|materialButNotReturnDetailed") ||
                    $this->dt_ci_acl->checkAccess("ItemLedger|index") ||
                    $this->dt_ci_acl->checkAccess("ItemBalance|index") ||
                    $this->dt_ci_acl->checkAccess("Warranty|index") ||
                    $this->dt_ci_acl->checkAccess("Warranty|manage")
                ) {
                    ?>
                    <li class="menu-item main-menu">
                        <a href="javascript:void(0);" class="menu-link menu-toggle">
                            <i class="menu-icon tf-icons ti ti-layout-sidebar"></i>
                            <div data-i18n="<?= lang('SidebarNav.asset');?>"><?= lang('SidebarNav.asset');?></div>
                        </a>

                        <ul class="menu-sub">
                            <?php if ($this->dt_ci_acl->checkAccess("Manufacturer|index") || 
                                $this->dt_ci_acl->checkAccess("Manufacturer|addEdit")) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("Manufacturer","Manufacturer|addEdit")); ?>">
                                    <a href="<?= admin_url(); ?>Manufacturer" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-list"></i>
                                        <div data-i18n="<?= lang('SidebarNav.manufacturer');?>"><?= lang('SidebarNav.manufacturer');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("Item|index") ||
                                    $this->dt_ci_acl->checkAccess("Item|manage")
                                ) { ?>
                                <li class="menu-item sub-menu <?= ($this->dt_ci_acl->getActiveMenu(array("Item", "Item/manage")))  ?>">
                                    <a href="<?= admin_url(); ?>Item" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-list"></i>
                                        <div data-i18n="<?= lang('SidebarNav.item');?>"><?= lang('SidebarNav.item');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("Material|index") ||
                                    $this->dt_ci_acl->checkAccess("Material|manage")
                                ) { ?>
                                <li class="menu-item sub-menu <?= ($this->dt_ci_acl->getActiveMenu(array("Material", "Material/manage")))  ?>">
                                    <a href="<?= admin_url(); ?>Material" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-list"></i>
                                        <div data-i18n="<?= lang('SidebarNav.material');?>"><?= lang('SidebarNav.material');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("Warranty|index") ||
                                    $this->dt_ci_acl->checkAccess("Warranty|manage")
                                ) { ?>
                                <li class="menu-item sub-menu <?= ($this->dt_ci_acl->getActiveMenu(array("Warranty", "Warranty/manage")))  ?>">
                                    <a href="<?= admin_url(); ?>Warranty" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-list"></i>
                                        <div data-i18n="<?= lang('SidebarNav.warranty');?>"><?= lang('SidebarNav.warranty');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("Material|materialButNotReturnDetailed")) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("Material/materialButNotReturnDetailed")); ?>">
                                    <a href="<?= admin_url(); ?>Material/materialButNotReturnDetailed" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-list"></i>
                                        <div data-i18n="<?= lang('SidebarNav.material_but_not_return_detailed');?>"><?= lang('SidebarNav.material_but_not_return_detailed');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("ItemLedger|index")) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("ItemLedger")); ?>">
                                    <a href="<?= admin_url(); ?>ItemLedger" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-list"></i>
                                        <div data-i18n="<?= lang('SidebarNav.item_ledger');?>"><?= lang('SidebarNav.item_ledger');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("ItemBalance|index")) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu(array("ItemBalance")); ?>">
                                    <a href="<?= admin_url(); ?>ItemBalance" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-list"></i>
                                        <div data-i18n="<?= lang('SidebarNav.item_balance');?>"><?= lang('SidebarNav.item_balance');?></div>
                                    </a>
                                </li>
                            <?php } ?>
                        </ul>
                    </li> 
                <?php } ?>


                <?php
                if (
                    $this->dt_ci_acl->checkAccess("KeyIssue|index") ||
                    $this->dt_ci_acl->checkAccess("KeyIssue|manage")
                ) {
                    ?>
                    <li class="menu-item main-menu">
                        <a href="javascript:void(0);" class="menu-link menu-toggle">
                            <i class="menu-icon tf-icons ti ti-layout-sidebar"></i>
                            <div data-i18n="<?= lang('SidebarNav.common_keys');?>"><?= lang('SidebarNav.common_keys');?></div>
                        </a>
                        <ul class="menu-sub">
                            <?php if ($this->dt_ci_acl->checkAccess("KeyIssue|index") ||
                                $this->dt_ci_acl->checkAccess("KeyIssue|manage")
                            ) { ?>
                            <li class="menu-item sub-menu <?= ($this->dt_ci_acl->getActiveMenu(array("KeyIssue", "KeyIssue/manage")))  ?>">
                                <a href="<?= admin_url(); ?>KeyIssue" class="menu-link">
                                    <i class="menu-icon tf-icons ti ti-list"></i>
                                    <div data-i18n="<?= lang('SidebarNav.key_issue');?>"><?= lang('SidebarNav.key_issue');?></div>
                                </a>
                            </li>
                        <?php } ?>
                        </ul>
                    </li>
                <?php } ?>

                <?php
                if (
                    $this->dt_ci_acl->checkAccess("Poll|index") ||
                    $this->dt_ci_acl->checkAccess("Poll|manage")
                    
                ) {
                    ?>
                    <li class="menu-item main-menu">
                        <a href="javascript:void(0);" class="menu-link menu-toggle">
                            <i class="menu-icon tf-icons ti ti-layout-sidebar"></i>
                            <div data-i18n="<?= lang('SidebarNav.poll');?>"><?= lang('SidebarNav.poll');?></div>
                        </a>
                        <ul class="menu-sub">
                            <?php if ($this->dt_ci_acl->checkAccess("Poll|index") ||
                                $this->dt_ci_acl->checkAccess("Poll|manage")
                            ) { ?>
                                <li class="menu-item sub-menu <?= ($this->dt_ci_acl->getActiveMenu(array("Poll", "Poll/manage")))  ?>">
                                    <a href="<?= admin_url(); ?>Poll" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-list"></i>
                                        <div data-i18n="<?= lang('SidebarNav.poll');?>"><?= lang('SidebarNav.poll');?></div>
                                    </a>
                                </li>
                            <?php } ?>
                        </ul>
                    </li>
                <?php } ?>

                 <?php
                if (
                    $this->dt_ci_acl->checkAccess("Invoice|index") ||
                    $this->dt_ci_acl->checkAccess("Invoice|manage")
                ) {
                    ?>
                    <li class="menu-item main-menu">
                        <a href="javascript:void(0);" class="menu-link menu-toggle">
                            <i class="menu-icon tf-icons ti ti-layout-sidebar"></i>
                            <div data-i18n="<?= lang('SidebarNav.invoice');?>"><?= lang('SidebarNav.invoice');?></div>
                        </a>
                        <ul class="menu-sub">
                            <?php if ($this->dt_ci_acl->checkAccess("Invoice|index") ||
                                $this->dt_ci_acl->checkAccess("Invoice|manage")
                            ) { ?>
                                <li class="menu-item sub-menu <?= ($this->dt_ci_acl->getActiveMenu(array("Invoice", "Invoice/manage")))  ?>">
                                    <a href="<?= admin_url(); ?>Invoice" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-list"></i>
                                        <div data-i18n="<?= lang('SidebarNav.invoice');?>"><?= lang('SidebarNav.invoice');?></div>
                                    </a>
                                </li>
                            <?php } ?>
                        </ul>
                    </li>
                <?php } ?>
                <!-- user-management-app menu start -->

            <?php } ?>
                <?php
                $userPrefix = (session('is_super_admin') === true || session('is_super_admin') === '1')  ? 'SuperAdmin/Auth' : 'Admin/Auth';
                $groupPrefix = (session('is_super_admin') === true || session('is_super_admin') === '1')  ? 'SuperAdmin' : 'Admin/Auth';
                if (
                    $this->dt_ci_acl->checkAccess("Auth|index") ||
                    $this->dt_ci_acl->checkAccess("Auth|edit_user") ||
                    $this->dt_ci_acl->checkAccess("Auth|manage_groups") ||
                    $this->dt_ci_acl->checkAccess("Auth|edit_group")
                ) {
                    ?>
                    <li class="menu-item main-menu">
                        <a href="javascript:void(0);" class="menu-link menu-toggle">
                            <i class="menu-icon tf-icons ti ti-layout-sidebar"></i>
                            <div data-i18n="<?= lang('SidebarNav.user_management');?>"><?= lang('SidebarNav.user_management');?></div>
                        </a>
                        <ul class="menu-sub">
                            <?php if ($this->dt_ci_acl->checkAccess("Auth|index") ||
                                    $this->dt_ci_acl->checkAccess("Auth|edit_user")
                                ) { ?>
                                <li class="menu-item sub-menu <?= $this->dt_ci_acl->getActiveMenu([$userPrefix, $userPrefix . '/edit_user']) ?>">
                                    <a href="<?= site_url($userPrefix) ?>" class="menu-link">
                                        <i class="menu-icon tf-icons ti ti-list"></i>
                                        <div data-i18n="<?= lang('SidebarNav.user');?>"><?= "dsfsSdsd". lang('SidebarNav.user');?></div>
                                    </a>
                                </li>
                            <?php } ?>

                            <?php if ($this->dt_ci_acl->checkAccess("Auth|manage_groups") ||
                                    $this->dt_ci_acl->checkAccess("Auth|edit_group")
                                ) { ?>
                                <li class="menu-item sub-menu <?= ($this->dt_ci_acl->getActiveMenu(array($groupPrefix ."/manage_groups", $groupPrefix ."/edit_group")))  ?>">
                                <a href="<?= site_url($groupPrefix . '/manage_groups') ?>" class="menu-link">
                                    <i class="menu-icon tf-icons ti ti-list"></i>
                                    <div data-i18n="<?= lang('SidebarNav.group');?>"><?= lang('SidebarNav.group');?></div>
                                </a>
                            </li>
                            <?php } ?>
                        </ul>
                    </li>
                <?php } ?>
                <!-- user-management-app menu end -->
            </ul>
        </aside>
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page">
            <!-- Navbar -->

            <nav class="layout-navbar container-xxl navbar navbar-expand-xl navbar-detached align-items-center bg-navbar-theme" id="layout-navbar">
                <div class="layout-menu-toggle navbar-nav align-items-xl-center me-3 me-xl-0 d-xl-none">
                    <a class="nav-item nav-link px-0 me-xl-4" href="javascript:void(0)">
                        <i class="ti ti-menu-2 ti-sm"></i>
                    </a>
                </div>

                <div class="navbar-nav-right d-flex align-items-center" id="navbar-collapse">

                    <ul class="navbar-nav flex-row align-items-center ms-auto">

                        <!-- User -->
                        <li class="nav-item navbar-dropdown dropdown-user dropdown">
                            <a class="nav-link dropdown-toggle hide-arrow" href="javascript:void(0);" data-bs-toggle="dropdown">
                                <div class="avatar avatar-online">
                                    <img src="<?= $assets; ?>img/avatars/1.png" alt class="h-auto rounded-circle" />
                                </div>
                            </a>
                            <ul class="dropdown-menu dropdown-menu-end">
                                <li>
                                    <a class="dropdown-item" href="pages-account-settings-account.html">
                                        <div class="d-flex">
                                            <div class="flex-shrink-0 me-3">
                                                <div class="avatar avatar-online">
                                                    <img src="<?= $assets; ?>img/avatars/1.png" alt class="h-auto rounded-circle" />
                                                </div>
                                            </div>
                                            <div class="flex-grow-1">
                                                <span class="fw-medium d-block"><?= isset($user_display_name) ? $user_display_name : ""; ?></span>
                                                <small class="text-muted"></small>
                                            </div>
                                        </div>
                                    </a>
                                </li>
                                <li>
                                    <div class="dropdown-divider"></div>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="<?= admin_url('Auth/change_password'); ?>">
                                        <i class="ti ti-lock me-2 ti-sm"></i>
                                        <span class="align-middle"><?= lang('SidebarNav.change_password');?></span>
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="<?= admin_url('Auth/logout'); ?>">
                                        <i class="ti ti-logout me-2 ti-sm"></i>
                                        <span class="align-middle"><?= lang('SidebarNav.log_out');?></span>
                                    </a>
                                </li>
                            </ul>
                        </li>
                        <!--/ User -->
                    </ul>
                </div>

                <!-- Search Small Screens -->
                <div class="navbar-search-wrapper search-input-wrapper d-none">
                    <input type="text" class="form-control search-input container-xxl border-0" placeholder="Search..." aria-label="Search..." />
                    <i class="ti ti-x ti-sm search-toggler cursor-pointer"></i>
                </div>
            </nav>

            <!-- / Navbar -->

            <!-- Content wrapper -->
            <div class="content-wrapper">
                <!-- Content -->

                <div class="container-xxl flex-grow-1 container-p-y">
                    <?php echo $body; ?>
                </div>
                <!-- / Content -->

                <!-- Footer -->
                <footer class="content-footer footer bg-footer-theme">
                    <div class="container-xxl">
                        <div class="footer-container d-flex align-items-center justify-content-between py-2 flex-md-row flex-column">
                            <div>
                                ©<?= date('Y'); ?>, made with ❤️ by
                                <a href="https://digitattva.in/" target="_blank" class="footer-link text-primary fw-medium">Digitattva</a>
                            </div>

                        </div>
                    </div>
                </footer>
                <!-- / Footer -->

                <div class="content-backdrop fade"></div>
            </div>
            <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
    </div>

    <!-- Overlay -->
    <div class="layout-overlay layout-menu-toggle"></div>

    <!-- Drag Target Area To SlideIn Menu On Small Screens -->
    <div class="drag-target"></div>
</div>
<!-- / Layout wrapper -->

<!-- Core JS -->
<!-- build:js assets/vendor/js/core.js -->

<!-- Loader (hidden by default) -->
<div id="loader" style="display:none; position:fixed; top:0; left:0; width:100%; height:100%;
     background:rgba(255,255,255,0.7); z-index:9999; text-align:center; padding-top:20%;">
    <img src="<?= base_url('assets/images/loader.gif'); ?>" alt="Loading...">
</div>


<script src="<?= $assets; ?>vendor/libs/popper/popper.js"></script>
<script src="<?= $assets; ?>vendor/js/bootstrap.js"></script>
<script src="<?= $assets; ?>vendor/libs/node-waves/node-waves.js"></script>
<script src="<?= $assets; ?>vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="<?= $assets; ?>vendor/libs/hammer/hammer.js"></script>
<script src="<?= $assets; ?>vendor/libs/i18n/i18n.js"></script>
<script src="<?= $assets; ?>vendor/libs/typeahead-js/typeahead.js"></script>
<script src="<?= $assets; ?>vendor/js/menu.js"></script>

<!-- endbuild -->

<!-- Vendors JS -->
<script src="<?= $assets; ?>vendor/libs/select2/select2.js"></script>
<script src="<?= $assets; ?>vendor/libs/bootstrap-select/bootstrap-select.js"></script>
<script src="<?= $assets; ?>vendor/libs/moment/moment.js"></script>
<script src="<?= $assets; ?>vendor/libs/flatpickr/flatpickr.js"></script>
<script src="<?= $assets; ?>vendor/libs/typeahead-js/typeahead.js"></script>
<script src="<?= $assets; ?>vendor/libs/tagify/tagify.js"></script>
<script src="<?= $assets; ?>vendor/libs/@form-validation/popular.js"></script>
<script src="<?= $assets; ?>vendor/libs/@form-validation/bootstrap5.js"></script>
<script src="<?= $assets; ?>vendor/libs/@form-validation/auto-focus.js"></script>

<!-- Main JS -->
<script src="<?= $assets; ?>js/main.js"></script>

<!-- Page JS -->
<!-- <script src="<?= $assets; ?>js/form-validation.js"></script> -->



<script type="text/javascript">

    // $(document).ready(function () {
    //     $("#menuSearch").on("keyup", function () {
    //         let filter = $(this).val().toLowerCase();

    //         $(".menu-item").each(function () {
    //             let text = $(this).text().toLowerCase();
    //             $(this).toggle(text.includes(filter));
    //         });

    //         $(".menu-header").each(function () {
    //             let $header = $(this);
    //             let hasVisibleItems = false;

    //             $header.nextUntil(".menu-header").each(function () {
    //                 if ($(this).hasClass("menu-item") && $(this).is(":visible")) {
    //                     hasVisibleItems = true;
    //                     return false; // Break loop
    //                 }
    //             });

    //             $header.toggle(hasVisibleItems);
    //         });
    //     });
    // });

    $(document).ready(function () {


        $('#society_id').change(function () {
            var societyId = $(this).val();
            
            $.ajax({
                type: "POST",
                url: '<?php echo admin_url("Auth/user_society");?>', // Create this PHP file to handle session storage
                data: { society_id: societyId },
                beforeSend: function () {
                    $('#loader').show(); // Show loader before AJAX call
                },
                success: function () {
                    location.reload(); // Reload page after setting session
                },
                complete: function () {
                    $('#loader').hide(); // Hide loader after request finishes (success or error)
                },
                error: function () {
                    alert("Something went wrong!");
                },
                
            });
        });
    });

    $(document).ready(function () {
        // $('a.menu-link').each(function () {
        //     if ($(this).hasClass('active')) {
        //         $(this).parents(".nav-item-submenu").addClass("nav-item-expanded nav-item-open");
        //         $(this).parents(".nav-group-sub").addClass("show");
        //     }
        // });

        // $('a.menu-link').each(function() {
        //     if ($(this).parents(".sub-menu").hasClass('active')) {
        //         console.log("Yes");
                
        //         $(this).parents(".main-menu").addClass("active open");
        //     } else {
        //         console.log("No");

        //     }
        // });

        $('.sub-menu').each(function () {
            // $(this).closest('.menu-sub').addClass('open'); // Optional if needed
            if ($(this).hasClass('active')) {
                $(this).parents('.main-menu').addClass('active open');
            }
        });
    });

    // $(document).ready(function () {
    //     $("#menuSearch").on("keyup", function () {
    //         let filter = $(this).val().toLowerCase().trim();

    //         // Filter menu items
    //         $(".menu-item").each(function () {
    //             let text = $(this).text().toLowerCase();
    //             $(this).toggle(text.includes(filter));
    //         });

    //         // Show/hide menu headers based on visible items
    //         $(".menu-header").each(function () {
    //             let $header = $(this);
    //             let hasVisibleItems = $header.nextUntil(".menu-header", ".menu-item:visible").length > 0;
    //             $header.toggle(hasVisibleItems);
    //         });

    //         // Scroll sidebar to top when searching
    //         $(".menu-inner").stop().animate({ scrollTop: 0 }, 300);

    //         $("#clearSearch").on("click", function () {
    //             $("#menuSearch").val("").trigger("keyup").focus();
    //             $(this).hide();
    //         });
    //     });
    // });

    $(document).ready(function () {
        var searchInput = $("#menuSearch");
        var clearButton = $("#clearSearch");

        // Search Functionality
        searchInput.on("input", function () {
            var filter = $(this).val().toLowerCase().trim();

            // Show/Hide clear button based on input
            if (filter.length > 0) {
                clearButton.show();
            } else {
                clearButton.hide();
            }

            // Filter menu items
            $(".menu-item").each(function () {
                var text = $(this).text().toLowerCase();
                $(this).toggle(text.includes(filter));
            });

            // Show/hide menu headers based on visible items
            $(".menu-header").each(function () {
                var $header = $(this);
                var hasVisibleItems = $header.nextUntil(".menu-header", ".menu-item:visible").length > 0;
                $header.toggle(hasVisibleItems);
            });

            // Scroll sidebar to top when searching
            $(".menu-inner").stop().animate({ scrollTop: 0 }, 300);
        });

        // Clear Search Input
        clearButton.on("click", function () {
            searchInput.val("").trigger("input").focus();
            $(this).hide();
        });
    });

    $(document).ajaxComplete(function (e, xhr, settings) {
        var responseData = jQuery.parseJSON(xhr.responseText);

        if (responseData.status_code === 401) {
            //check for location header and redirect...
            Swal.fire({
                title: 'Warning',
                text: "Login Again Session Expire",
                icon: 'warning',
                customClass: {
                    confirmButton: 'btn btn-primary waves-effect waves-light'
                },
                buttonsStyling: false
            }).then(function() {
                window.open('<?php echo site_url('Admin/Auth/login');?>', '_blank');
            });
        }
    });


    var dt_DataTable;
    // default datatable parameters
    var datatableLang = <?= json_encode(getDatatableLanguageArray()); ?>;
    var lengthOptions = [10, 25, 50, 75, 100];
    var lengthOptionsNames = [10, 25, 50, 75, 100];

    // send csrf token in all ajax request
    //$.ajaxSetup({
    //    data: {
    //        <?php //= $this->security->get_csrf_token_name(); ?>//: '<?php //= $this->security->get_csrf_hash(); ?>//'
    //    }
    //});

    function sidebarControl(datatableRef) {
        $('.sidebar-control').on('click', function() {
            datatableRef.fixedHeader.adjust();
        });
    }

    function dtFormClear(formName) {
        $("form#" + formName + " input[type=checkbox]").prop('checked', false);
        //$("form#" + formName + " input[type=checkbox]").siblings().remove();
        $("form#" + formName + " input[type=text]").val('');
        $("form#" + formName + " input[type=tel]").val('');
        $("form#" + formName + " input[type=email]").val('');
        $("form#" + formName + " input[type=radio]").prop('checked', false);
        $("form#" + formName + " textarea").val('');
        $('form#' + formName + " input[type=file]").val('');
        $('form#' + formName + " input[type=file]").parents('.form-group').find('img').attr('src', null);
        $("form#" + formName + " input[type=file]").parents('.form-group').find('img').hide();
        $("form#" + formName + " input[type=file]").parents('.form-group').find('span[class=filename]').html('No File Selected');

        $('textarea.ckeditor').each(function() {
            var $textarea = $(this);
            CKEDITOR.instances[$textarea.attr('name')].setData("");
        });

        $("form#" + formName + " select").val('').trigger('change.select2');
        // $("form#" + formName + " .validation-error-label").html('');
        $("form#" + formName + " .validation-invalid-label").html('');
    }

    function ckEditorInit(id){
        // Editor with placeholder
        ClassicEditor.create(document.querySelector('#'+id), {
            heading: {
                options: [
                    { model: 'paragraph', title: 'Paragraph', class: 'ck-heading_paragraph' },
                    { model: 'heading1', view: 'h1', title: 'Heading 1', class: 'ck-heading_heading1' },
                    { model: 'heading2', view: 'h2', title: 'Heading 2', class: 'ck-heading_heading2' },
                    { model: 'heading3', view: 'h3', title: 'Heading 3', class: 'ck-heading_heading3' },
                    { model: 'heading4', view: 'h4', title: 'Heading 4', class: 'ck-heading_heading4' },
                    { model: 'heading5', view: 'h5', title: 'Heading 5', class: 'ck-heading_heading5' },
                    { model: 'heading6', view: 'h6', title: 'Heading 6', class: 'ck-heading_heading6' }
                ]
            }
        }).then(editor => {
            CKEDITOR = editor;
            //editor.setData('<p>This is the editor data.</p>' );
        }).catch(error => {
            console.error(error);
        });
    }

    function switcheryKeyGen(sclass) {
        // var switcherySettings =
        // 	{
        // 		color: '#2196F3'
        // 	};
        // var elems = Array.prototype.slice.call(document.querySelectorAll('.' + sclass));
        // elems.forEach(function(html) {
        // 	var switchery = new Switchery(html,switcherySettings);
        // });
    }


    function getNextSeriesJS(tableType, prefix, societyId) {
        var changedPrefix = prefix;
        $.ajax({
            type: "POST",
            url: "<?php echo admin_url('Rentals/getNextSeries'); ?>",
            dataType: "json",
            data: {
                prefix: changedPrefix,
                type: tableType,
                society_id: societyId
            },
            success: function(data) {
                if (data.success) {
                    $(".series").val(data.data);
                }
            }
        });
    }

    function dtFormFill(formName, data) {
        $.each(data, function(key, val) {
            //Get Form fields Type
            var inputType = $('form#' + formName + ' #' + key).prop("type");
            // CheckBox
            if (inputType == 'checkbox') {
                //$('form#' + formName + ' #' + key).siblings().remove();
                if (val == 1) {
                    $('form#' + formName + ' #' + key).prop("checked", true);
                } else {
                    $('form#' + formName + ' #' + key).prop("checked", false);
                }
            }
            //radio
            else if (inputType == 'radio') {
                $('form#' + formName + ' input[value="' + val + '"]').prop("checked", true);
            }
            //select2 or select or select multiple
            else if (inputType == 'select-one' || inputType == 'select-multiple') {
                if ($('form#' + formName + ' #' + key).length) {
                    $('form#' + formName + '  #' + key).val(val).trigger('change');
                    $('#' + key + '-error').html("");
                }
            }
            //textarea or ckeditor
            else if (inputType == 'textarea') {
                if ($('form#' + formName + ' #' + key).length) {
                    if ($('form#' + formName + ' #' + key).hasClass('ckeditor')) {
                        CKEDITOR.instances[key].setData(val);
                    } else {
                        $('form#' + formName + ' #' + key).val(val);
                    }
                }
            }
            //file
            else if (inputType == 'file') {
                if ($('form#' + formName + ' #' + key).length) {
                    var path = '';
                    if (path != '' && val != '') {
                        $('form#' + formName + ' #' + key).parents('.form-group').find('img').attr('src', path + val);
                        $('form#' + formName + ' #' + key).parents('.form-group').find('img').show();
                        $("form#" + formName + " input[type=file]").parents('.form-group').find('span[class=filename]').html('No File Selected');
                    } else {
                        $('form#' + formName + ' #' + key).parents('.form-group').find('img').attr('src', null);
                        $('form#' + formName + ' #' + key).parents('.form-group').find('img').hide();
                        $("form#" + formName + " input[type=file]").parents('.form-group').find('span[class=filename]').html('No File Selected');
                    }
                }
            }
            // /common
            else {
                if ($('form#' + formName + ' #' + key).length) {
                    $('form#' + formName + ' #' + key).val(val);
                }
            }
        });
        switcheryKeyGen("form-add-switchery");
    }

    function checkBoxRefresh(sclass) {
        ///$('.' + sclass).uniform();
    }

    function dtDataTableSearch(tableId) {
        if (typeof tableId === "undefined" || tableId === null) {
            $(".dataTables_filter input").unbind().keyup(function(e) {
                var minimumChar = "<?= DATATABLE_MINIMUM_INPUT_LENGTH; ?>";
                var maximumChar = "<?= DATATABLE_MAXIMUM_INPUT_LENGTH; ?>";
                // If the length is configure length or more characters, or the user pressed ENTER, search
                if ($(this).val().length != 0 && (($(this).val().length) <= maximumChar) && (($(this).val().length % minimumChar) == 0 || e.keyCode == 13)) {
                    // Call the API search function
                    dt_DataTable.search(this.value).draw();
                }
                if ($(this).val() == "") {
                    dt_DataTable.search(this.value).draw();
                }
            });
        } else {
            $("#" + tableId + "_filter input").unbind().keyup(function(e) {
                dt_DataTable = $("#" + tableId).DataTable();
                var minimumChar = "<?= DATATABLE_MINIMUM_INPUT_LENGTH; ?>";
                var maximumChar = "<?= DATATABLE_MAXIMUM_INPUT_LENGTH; ?>";
                // If the length is configure length or more characters, or the user pressed ENTER, search
                if ($(this).val().length != 0 && (($(this).val().length) <= maximumChar) && (($(this).val().length % minimumChar) == 0 || e.keyCode == 13)) {
                    // Call the API search function
                    dt_DataTable.search(this.value).draw();
                }
                if ($(this).val() == "") {
                    dt_DataTable.search(this.value).draw();
                }
            });
        }
    }


    $(document).on('click', '.datatable-select-all-second', function() {
        var checkedStatus = this.checked;
        $('.dt-datatable tbody tr').find('td:eq(0) :checkbox').each(function() {
            $(this).prop('checked', checkedStatus);
        });
    });

    function numberInit() {
        $('.numberInit').each(function() {
            var number = $(this);
            $("#" + number.attr('id')).keydown(function(e) {
                // Allow: backspace, delete, tab, escape, enter and .
                if ($.inArray(e.keyCode, [46, 8, 9, 27, 13, 110, 190]) !== -1 ||
                    // Allow: Ctrl+A, Command+A
                    (e.keyCode === 65 && (e.ctrlKey === true || e.metaKey === true)) ||
                    // Allow: home, end, left, right, down, up
                    (e.keyCode >= 35 && e.keyCode <= 40)) {
                    // let it happen, don't do anything
                    return;
                }
                // Ensure that it is a number and stop the keypress
                if ((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105)) {
                    e.preventDefault();
                }
            });
        });
    }

    function nonDecimal() {
    $('.nonDecimal').each(function () {
        var number = $(this);
        $("#" + number.attr('id')).keydown(function (e) {
            // Allow: backspace, delete, tab, escape, and enter
            if ($.inArray(e.keyCode, [46, 8, 9, 27, 13]) !== -1 ||
                // Allow: Ctrl+A, Command+A
                (e.keyCode === 65 && (e.ctrlKey === true || e.metaKey === true)) ||
                // Allow: home, end, left, right, down, up
                (e.keyCode >= 35 && e.keyCode <= 40)) {
                return; // let it happen, don't do anything
            }
            // Ensure that it is an integer and stop the keypress if not
            if ((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && 
                (e.keyCode < 96 || e.keyCode > 105)) {
                e.preventDefault();
            }
        });
    });
}

    function Select2InitModalPopup() {
        $('.select2').each(function() {
            var $this = $(this);
            $this.wrap('<div class="position-relative"></div>').select2({
                placeholder: 'Select value',
                dropdownParent: $this.parent()
            });
        });
    }

    function customToolTip() {
        // Init BS Tooltip
        const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        tooltipTriggerList.map(function(tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });

        // const tooltip = bootstrap.Tooltip.getInstance('.dt-edit-record');
        // // setContent example
        // tooltip.setContent({ '.tooltip-inner': 'another title' })
    }

    function addSerialNumber(addSerialNumber) {
        $('table#' + addSerialNumber + ' tbody tr').each(function(index) {
            $(this).find('td:nth-child(1)').html(index + 1);
        });
    }

    function formatDecimal(x, d) {
        if (!d) {
            //var toFixedValue = parseInt($("#company_maximum_decimal_point").val());
            d = toFixedValue;
        }
        return parseFloat(accounting.toFixed(x, d));
    }

    function ucWordJS(str){
        var string = str.toLowerCase().replace(/\b[a-z]/g, function(letter) {
            return letter.toUpperCase();
        });

        return string;
    }

    function addValidation(type, selecter, rules) {
        $('' + type + '' + selecter + '').each(function() {
            $(this).rules('add', rules);
        });
    }


    function dtButtonHide(name = '') {
        $(name).prop("disabled", true).hide();
        // $(name).css("visibility", "hidden");
    }

    function dtButtonShow(name = '') {
        $(name).prop("disabled", false).show();
        // $(name).css("visibility", "visible");
    }

    $(document).on('click', '.dt-detail-model-view,.dt-own-detail-model-view', function() {
        var viewId = $(this).attr('data-dt_view_id');
        var viewModule = $(this).attr('data-dt_view_module');
        var sameModule = $(this).attr('data-dt_same_module');
        var viewUrl = $(this).attr('data-dt_view_url');
        $.ajax({
            type: "POST",
            url: viewUrl,
            dataType: "json",
            data: {
                view_id: viewId,
                view_module: viewModule,
                view_same_module: sameModule
            },
            beforeSend: function(formData, jqForm, options) {
                Swal.fire({
                    title: "Please Wait",
                    text: "Please have patience, Data is been loaded",
                    icon: "info",
                    showConfirmButton: false
                });
            },
            complete: function() {
                Swal.close();
            },
            success: function(data) {
                if (data['success']) {
                    $('.dt-view-module-title').html(data['view_title']);
                    $('.dt-view-module-detail').html(data['view_detail']);
                    $("#view_module_detail").modal('show');
                } else {
                    //this can be changed to empty model!
                    Swal.fire({
                        title: "<?= ucwords(lang('error')); ?>",
                        text: "Something went Wrong",
                        type: "<?= lang('error'); ?>",
                        confirmButtonColor: "<?= BTN_ERROR; ?>"
                    });
                }
            }
        });
    });
</script>
</body>

<!--
<div id="view_module_detail" class="modal fade" tabindex="-1">
	<div class="modal-dialog modal-lg modal-simple modal-add-new-address">
		<div class="modal-content p-3 p-md-5">
			<div class="modal-header">
				<h5 class="modal-title dt-view-module-title">Basic modal</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>

			<div class="modal-body">
				<div class="dt-view-module-detail table-responsive pre-scrollable">

				</div>
			</div>

			<div class="modal-footer">
				<button type="button" class="btn-close" data-dismiss="modal">Close</button>
			</div>
		</div>
	</div>
</div> -->


<!-- Extra Large Modal -->
<div class="modal fade" id="view_module_detail" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title dt-view-module-title"></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body dt-view-module-detail">


            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-label-secondary" data-bs-dismiss="modal">
                    Close
                </button>

            </div>
        </div>
    </div>
</div>

</html>
