<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('WaterMeterReading.water_meter_reading_detail');?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open tag
				$form_id = array(
					'id'=>'form_water_meter_reading',
				);
				echo form_open_multipart('',$form_id);
				$waterMeterReadingId = (isset($water_meter_reading_data['water_meter_reading_id']) && ($water_meter_reading_data['water_meter_reading_id'] != '')) ? $water_meter_reading_data['water_meter_reading_id'] : '';
				?>
				<input type="hidden" id="water_meter_reading_id" name="water_meter_reading_id" value="<?= $waterMeterReadingId ?>">

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('WaterMeterReading.water_tank_id');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
							<select id="water_tank_id" name="water_tank_id" class="select2 form-select form-select-lg waterTankDd" data-allow-clear="true">
								<option></option>
								<?php if(isset($water_meter_reading_data['water_tank_id']) && $water_meter_reading_data['water_tank_id'] != 0){ ?>
								<option value="<?= isset($water_meter_reading_data['water_tank_id']) ? $water_meter_reading_data['water_tank_id'] : 0 ?>" selected> <?= isset($water_meter_reading_data['water_tank_name']) ? $water_meter_reading_data['water_tank_name'] : ''  ?> </option>
								<?php } ?>
							</select>
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('WaterMeterReading.reading_date_time');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="reading_date_time" id="reading_date_time" placeholder="Enter <?= lang('WaterMeterReading.reading_date_time');?>" value="<?= (isset($water_meter_reading_data['reading_date_time']) && isValidDate($water_meter_reading_data['reading_date_time'])) ? siteDateFormat($water_meter_reading_data['reading_date_time'],true) : ''; ?>" />
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('WaterMeterReading.source');?><span class="text-danger"> *</span></label>
						<?php
						$sources = source();
						?>
						<div class="col-sm-10">
						<select data-placeholder="Select  <?= lang('WaterMeterReading.source'); ?>" name="source"
								id="source" class="select2 form-select" data-allow-clear="true">
							<option> </option>
							<?php
							$selectedSource = isset($water_meter_reading_data['source']) ? $water_meter_reading_data['source'] : "";
							foreach ($sources as $key => $sourceElement) { ?>
								<option <?= ($selectedSource == $key) ? "selected" : ""; ?>
										value="<?= $key; ?>"> <?= $sourceElement; ?> </option>
							<?php } ?>
						</select>
						</div>
					</div>
					
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('WaterMeterReading.supply_volume');?></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control numberInit" name="supply_volume" id="supply_volume" placeholder="Enter <?= lang('WaterMeterReading.supply_volume');?>" value="<?= (isset($water_meter_reading_data['supply_volume']) && ($water_meter_reading_data['supply_volume'] != '')) ? roundNumber($water_meter_reading_data['supply_volume']) : '';  ?>" />
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('WaterMeterReading.availability_volume');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control numberInit" name="availability_volume" id="availability_volume" placeholder="Enter <?= lang('WaterMeterReading.availability_volume');?>" value="<?= (isset($water_meter_reading_data['availability_volume']) && ($water_meter_reading_data['availability_volume'] != '')) ? roundNumber($water_meter_reading_data['availability_volume']) : '';  ?>" />
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('WaterMeterReading.remarks');?></label>
						<div class="col-sm-10">
							<textarea name="remarks"  id="remarks" placeholder="Enter <?= lang('WaterMeterReading.remarks'); ?>" rows="3" cols="5"  class="form-control"><?= (isset($water_meter_reading_data['remarks']) && ($water_meter_reading_data['remarks'] != '')) ? $water_meter_reading_data['remarks'] : ''; ?></textarea>
						</div>
					</div>

					

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('CommonMessage.common_active');?></label>
							<div class="col-sm-10">
							<label class="switch switch-sm"><span class="switch-label"></span>
								<input type="checkbox" class="switch-input form-add-switchery"  name="is_active" id="is_active" <?php echo (!isset($water_meter_reading_data['is_active']) || $water_meter_reading_data['is_active'] == 1) ? 'checked="checked"' : ''; ?>/>
								<span class="switch-toggle-slider">
		                              <span class="switch-on"></span>
		                              <span class="switch-off"></span>
		                            </span>
								
							</label>
						</div>
					</div>

					<div class="pt-4">
						<button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit">Submit</button>
						<button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('WaterMeterReading'); ?>'" class="btn btn-label-secondary">Cancel</button>
					</div>
				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<script>
    $(document).ready(function() {
    	numberInit();
		switcheryKeyGen("datatable-list-switchery");
		waterTankDd();
		$('#source').select2();
        // Initialize
		var validator = $("#form_water_meter_reading").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
            rules: {
				reading_date_time : {
					required : true,
				},
				// remarks : {
				// 	required : true,
				// },
                // supply_volume: {
                //     required: true,
                // },
                availability_volume: {
                    required: true,
                },
                source: {
                    required: true,
                },
                water_tank_id: {
                    required: true,
                },
				
            },
            messages: {
				reading_date_time: {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('WaterMeterReading.reading_date_time');?>"
				},
				// remarks: {
				// 	required: "<?//= lang('CommonMessage.common_please_enter'); ?> <?//= lang('WaterMeterReading.remarks');?>"
				// },
				// supply_volume: {
                //     required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('WaterMeterReading.supply_volume');?>"
                // },
                availability_volume: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('WaterMeterReading.availability_volume');?>"
                },
                source: {
                    required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('WaterMeterReading.source');?>"
                },
                water_tank_id: {
                    required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('WaterMeterReading.water_tank');?>"
                },
            },
            submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("WaterMeterReading/save");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
						dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function () {

					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
								onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('WatermeterReading');?>';
                                }
							});
							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('WatermeterReading');?>';
							// }, 1000);
						} else {
							dtButtonShow('#submitBtn');
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
            }
        });
        $("#reading_date_time").flatpickr({
			// monthSelectorType: 'static',
    		enableTime: true,
    		dateFormat: "d-m-Y H:i",
    		maxDate : "<?= TODAY_DATE ?>",
			// dateFormat: 'd-m-Y'
		});
    });

	$(document).on('input', '#supply_volume', function () {
        var waterTankId    = $('#water_tank_id').val();
        var readingDateTime    = $('#reading_date_time').val();
        var availabilityVolume    = $('#availability_volume').val();
        var supplyVolume    = $('#supply_volume').val();
        var waterMeterReadingId    = $('#water_meter_reading_id').val();
        $.ajax({
            type: "POST",
            url: "<?php echo admin_url('WaterMeterReading/getAvailabilityVolume'); ?>",
            dataType: "json",
            data: {
                water_tank_id : waterTankId,
                reading_date_time : readingDateTime,
                supply_volume : supplyVolume,
                water_meter_reading_id : waterMeterReadingId,
            },
            success: function (resObj) {
                if (resObj.success) {
                    $('#availability_volume').val(resObj.availability_volume);
                } 
				<?php /*
				else {
                    $('#purchase_lr_product_table tbody').html(resObj.product_row_data);
                    swalInit.fire({
                        title: resObj.title,
                        text: resObj.msg,
                        confirmButtonColor: "<?= BTN_DELETE_INFO; ?>",
                        icon: "<?= lang('info'); ?>"
                    }).then(function () {
                        return false;
                    });
                }
					<?php */ ?>
            }  
        });
    });

	$(document).on('change', '#water_tank_id,#reading_date_time', function () {
		$('#availability_volume').val('');
    });
	
</script>

<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
