<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
$moduleType = isset($module_type) ? $module_type : "";
if ($moduleType == 'voucher') {
	$url = admin_url('Voucher/manage?type=voucher');
} else {
	$url = admin_url('Voucher/manage?type=receipt');
}
?>
<?= isset($advance_filter) ? $advance_filter : ""; ?>
<a style="display: none;" href="" class="dt-export-anchor" target="_blank"></a>

<div class="card">
    <div class="card-datatable table-responsive">
        <table id="voucher_table" class="table dt-datatable">
            <thead class="border-top">
            <tr>
                <th><input class="form-check-input datatable-select-all-second" type="checkbox"  /></th>
                <th class="font-weight-bold" ><?= lang("Voucher.".$moduleType."_type"); ?></th>
                <th class="font-weight-bold" ><?= lang("Voucher.transaction_mode"); ?></th>
                <th class="font-weight-bold" ><?= lang("Voucher.date"); ?></th>
                <th class="font-weight-bold" ><?= lang("Voucher.reference_no"); ?></th>
                <th class="font-weight-bold" ><?= lang("CommonMessage.common_action"); ?></th>
            </tr>
            </thead>
        </table>
    </div>
    <!--    </div>-->
</div>
<script type="text/javascript">

    var dt_DataTable;

    $(document).ready(function () {
        commonAreaDd();

        dt_DataTable = $('#voucher_table').DataTable( {
            dom:'<"card-header d-flex border-top rounded-0 flex-wrap py-0"' +
                '<"me-5 ms-n2 pe-5"f>' +
                '<"d-flex justify-content-start justify-content-md-end align-items-baseline"<"dt-action-buttons d-flex flex-column align-items-start align-items-md-center justify-content-sm-center mb-3 mb-md-0 pt-0 gap-4 gap-sm-0 flex-sm-row"lB>>' +
                '>t' +
                '<"row mx-2"' +
                '<"col-sm-12 col-md-6"i>' +
                '<"col-sm-12 col-md-6"p>' +
                '>',
            processing: true,
            serverSide: true,
            displayLength: 10,
            language: {
                sLengthMenu: 'Show _MENU_',
                search: '',
                searchPlaceholder: 'Search <?= $moduleType ?>',
                info: 'Displaying _START_ to _END_ of _TOTAL_ entries'
            },

            buttons: [
                {
                    extend: 'collection',
                    className: 'btn btn-label-secondary px-2 dropdown-toggle me-2 waves-effect waves-light',
                    text: '<i class="ti ti-download me-1 ti-xs"></i>Export',
                    buttons: [
                        {
                            text: '<i class="ti ti-file me-2" ></i>Cash Book Pdf',
                            className: 'dropdown-item dt-excel-export'
                        },
                        // {
                        //  extend: 'pdf',
                        //  text: '<i class="ti ti-file-text me-2"></i>Pdf',
                        //  className: 'dropdown-item',
                        //
                        // }
                    ]
                },
                <?php if ($dtCIAcl->checkAccess("Voucher|manage")) { ?>
                {
                    text: '<i class="ti ti-plus me-0 me-sm-1 ti-xs"></i><span class="d-none d-sm-inline-block"><?= lang('Voucher.add_'.$moduleType);?></span>',
                    className: 'add-new btn btn-primary px-1 me-2',
                    action: function () {
                        window.location.href = '<?= $url;?>';
                    }
                },

                <?php } ?>
                <?php if ($dtCIAcl->checkAccess("Voucher|delete")) { ?>
                {
                    text: '<i class="ti ti-trash me-0 me-sm-1 ti-xs"></i><span class="d-none d-sm-inline-block"><?= lang('Voucher.delete_'.$moduleType);?></span>',
                    //className: 'btn btn-danger ms-2 ms-sm-0 waves-effect waves-light dt-delete-record invisible',
                    className: 'btn btn-danger  px-1 dt-delete-record',
                },
                // {
                //  text: '<span class="ti ti-trash"></span>',
                //  className: 'add-new  ms-2 ms-sm-0 waves-effect waves-light rounded-pill btn btn-icon btn-danger dt-delete-record',
                // },
                <?php } ?>
            ],
            "ajax": {
                "url": "<?php echo admin_url('Voucher/getVoucherListing'); ?>",
                "type": "POST",
                "data": function(d) {
                    var params = {};
                    params["<?= csrf_token(); ?>"] = "<?= csrf_hash() ?>";
                    params["module_type"] = '<?= $moduleType; ?>';
                    var filterData = $("#advanceFilter").serializeArray();
                    $.each(filterData, function(i, val) {
                        var name = val.name;
                        if (typeof params[name] == 'undefined') {
                            params[name] = val.value;
                        } else if ($.isArray(params[name])) {
                            params[name].push(val.value);
                        } else {
                            params[name] = [params[name]];
                            params[name].push(val.value);
                        }
                    });

                    return $.extend({}, d, params);
                }
            },
            "order": [[ 0, "desc" ]],
            "columns": [
                {
                    "data": "voucher_id",
                    "render": function (data, type, row) {
                        return '<input class="form-check-input datatable-checkbox" type="checkbox" id="ids_' + row['voucher_id'] + '" name="ids[]" value="' + row['voucher_id'] + '"/>';
                    },
                    "sortable": false,
                    "searchable": false,
                    "class": "no_click_allowed"
                },
                {"data": "voucher_type" },
                {"data": "transaction_mode" },
                {"data": "date",},
                {"data": "reference_no",},
                {
                    "data": "action_button",
                    "class" : "text-center",
                    "sortable": false,
                    "searchable": false,
                    "class":"no_click_allowed",
                },
            ],
            createdRow: function (row, data, dataIndex) {
				// $(row).find("td:not(.no_click_allowed,.own_detail_model_view)").addClass('dt-detail-model-view');
				// $(row).find("td:not(.no_click_allowed,.own_detail_model_view)").attr('data-dt_view_id', data['voucher_id']);
				// $(row).find("td:not(.no_click_allowed,.own_detail_model_view)").attr('data-dt_view_url', '<?= admin_url("Voucher/view"); ?>');
			},
            "fnDrawCallback": function (oSettings, json) {
                customToolTip();
                $('.dataTables_length').addClass('mt-2 mt-sm-0 mt-md-3 me-2');
                $('.dt-buttons').addClass('d-flex flex-wrap');
                $('.dataTables_filter .form-control').removeClass('form-control-sm');
                $('.dataTables_length .form-select').removeClass('form-select-sm');
                switcheryKeyGen("datatable-list-switchery");
            }
        });
        dtDataTableSearch();
    });
    //modal open
    $(document).on('click', '.add_voucher', function () {
        dtFormClear('form_voucher');
        $("form#form_voucher input[name=voucher_id]").val('');
        $('#is_active').prop("checked","checked");
        $('#voucher_modal').modal('show');
        Select2InitModalPopup();
        modalCommonAreaDd();
    });

    //Delete Record
    $(document).on('click', '.dt-delete-record', function () {
        var id = $(this).attr("data-id");
        var deleteId = [];
        if(id != undefined){
            $('.datatable-select-all-second').prop('checked', false);
            $('.datatable-checkbox').prop('checked', false);
            $("#ids_" + id).prop("checked", true);
            deleteId.push(id);
        }
        else{
            var deleteElement =$('#voucher_table tbody .datatable-checkbox:checked');
            var selectedLength = deleteElement.length;
            if (selectedLength == 0) {
                Swal.fire({
                    title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_info')); ?>",
                    text: "<?= lang('CommonMessage.delete_info'); ?>",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'OK',
                    customClass: {
                        confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                        cancelButton: 'btn btn-label-secondary waves-effect waves-light'
                    },
                    buttonsStyling: false
                }).then(function () {
                    return false;
                });
            } else {
                $.each(deleteElement, function (i, ele) {
                    deleteId.push($(ele).val());
                });
            }
        }
        if (deleteId.length > 0) {
            Swal.fire({
                title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_delete')); ?>",
                text: "<?= lang('CommonMessage.delete_warning'); ?>",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'OK',
                customClass: {
                    confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                    cancelButton: 'btn btn-label-secondary waves-effect waves-light'
                },
                buttonsStyling: false
            }).then(function(result) {
                if (result.value) {
                    $.ajax({
                        type: "post",
                        url: "<?= admin_url("Voucher/delete")?>",
                        dataType: "json",
                        data: {voucher_id: deleteId},
                        success: function (data) {
                            if (data['success']) {
                                Swal.fire({
                                    title: 'Success',
                                    text: data['msg'],
                                    icon: 'success',
                                    customClass: {
                                        confirmButton: 'btn btn-primary waves-effect waves-light'
                                    },
                                    buttonsStyling: false
                                }).then(function() {
                                    dt_DataTable.ajax.reload();
                                });
                            } else {
                                Swal.fire({
                                    title: 'Error!',
                                    text: data['msg'],
                                    icon: 'error',
                                    customClass: {
                                        confirmButton: 'btn btn-primary waves-effect waves-light'
                                    },
                                    buttonsStyling: false
                                }).then(function() {
                                    dt_DataTable.ajax.reload();
                                });
                            }
                        }
                    });
                }
                else {
                    $('.datatable-checkbox').prop('checked', false);
                }
            });
        }
    });


    //Edit Record
    $(document).on('click', '.dt-edit-record', function () {
        $('.datatable-select-all-second').prop('checked', false);
        $('.datatable-checkbox').prop('checked', false);
        $("form#form_voucher .validation-invalid-label").html('');
        var id = $(this).attr('data-id');
        $("#ids_" + id).prop("checked", true);
        var edit_val = $('.datatable-checkbox:checked').val();
        var selected_tr = $('.datatable-checkbox:checked');
        var element = $(selected_tr).closest('tr').get(0);
        var aData = dt_DataTable.row(element).data();
        dtFormFill('form_voucher', aData);
        $('#voucher_modal').modal('show');
        modalCommonAreaDd();
        
        // Select2InitModalPopup();
        var commonAreaId = '';
        var commonAreaName = '';
        $.each(aData, function(key, val) {
            if (key === 'common_area_id') {
                commonAreaId = val;
            } else if (key === 'common_area_name') {
                commonAreaName = val;
            }
        });
        if (commonAreaId !== null && commonAreaName !== null) {
            var ids = commonAreaId.split(', ');
            var names = commonAreaName.split(', ');
            var options = ids.map((id, index) => {
                return `<option value="${id}" selected>${names[index]}</option>`;
            }).join('');
            $('#common_area_id').empty().append(options).trigger('change');
        } else {
            $('#common_area_id').empty().trigger('change');
        }

    });

    // unchecked all checkbox of table on modal close
    $(document).on('hide.bs.modal', '#voucher_modal', function () {
       $("#common_area_id").select2('destroy');
        $('.datatable-select-all-second').prop('checked', false);
        $('#voucher_table .datatable-checkbox').prop('checked', false);

    });

    $('#voucher_modal').on('shown.bs.modal', function () {
        $('#voucher_name').focus();
    });

    $(document).on('click', '.form-status', function () {
        var voucherId = $(this).attr('id').split("_").pop();
        //var series = $(this).closest("tr").find(".dt-series").text();
        var series = 'S1';
        var status = $(this).attr('data-value');
        bootbox.confirm("<?= lang('common_permanently_submit'); ?> " + series + "?", function (result) {
            if (result) {
                $.ajax({
                    type: "post",
                    url: "<?= admin_url("Voucher/submitForm")?>",
                    dataType: "json",
                    data: {voucher_id: voucherId, form_status: status},
                    beforeSend: function (formData, jqForm, options) {
                        Swal.fire({
                            text: '<?= lang('CommonMessage.ajax_data_loading_message');?>',
                            showConfirmButton: false,
                            allowOutsideClick: false
                        });
                    },
                    complete: function () {
                        //bootbox.hideAll();
                    },
                    success: function (data) {
                        if (data['success']) {
                            Swal.fire({
                                title: 'Success',
                                text: data['msg'],
                                icon: 'success',
                                customClass: {
                                    confirmButton: 'btn btn-primary waves-effect waves-light'
                                },
                                buttonsStyling: false
                            }).then(function() {
                                dt_DataTable.ajax.reload(null,false);
                            });
                        } else {
                            Swal.fire({
                                title: 'Error!',
                                text: data['msg'],
                                icon: 'error',
                                customClass: {
                                    confirmButton: 'btn btn-danger waves-effect waves-light'
                                },
                                buttonsStyling: false
                            });
                        }
                    }
                });
            }
        });
    });

    $(document).on('click', '.filter_data', function() {
		dt_DataTable.draw();
	});

    $(document).on('click', '.clear_filter', function() {
		$('form#advanceFilter  #filter_common_area_id').val('').trigger('change');
        $('form#advanceFilter  #filter_voucher_status').val('').trigger('change');
		$("#filter_created_at").val('');
		$("#filter_updated_at").val('');
        dateRangePicker();
		dt_DataTable.draw();
	});

    $(document).on('click', '.datatable-checkbox', function () {
        $(".dt-delete-record").removeClass( "invisible" );
    });

    $(document).on('click', '.dt-excel-export', function() {
        $(this).removeClass(".dt-excel-export");
        var dataTableParams = dt_DataTable.ajax.params();
        url = '<?= admin_url('Voucher/pdfExportCashBook/') . ""  ?>';
        var recursiveEncoded = $.param(dataTableParams);
        $('.dt-export-anchor').attr('href', url + "?" + recursiveEncoded);
        $('.dt-export-anchor')[0].click();
    });

</script>
<?= isset($select2_ajax) ? $select2_ajax : ""; ?>