<?php
$html = '';
if (isset($voucher_items_data) && !empty($voucher_items_data)) {
	foreach ($voucher_items_data as $key => $value) {
		$data["row_number"] = $key + 1;
		$data["voucher_items_data"] = $value;
		$html .= view('Admin/Voucher/VoucherItemRowView', $data);
	}
}
?>
<!-- Responsive Table -->
	<div class="table-responsive text-nowrap">
		<table id="voucher_item_table" class="table table-bordered">
			<thead>
			<tr class="text-nowrap">
				<th><?= lang('CommonMessage.common_sr_no'); ?></th>
				<th><?= lang('Voucher.item'); ?><span class="text-danger"> *</span></th>
				<th><?= lang('Voucher.amount'); ?><span class="text-danger"> *</span></th>
				<th><?= lang('CommonMessage.common_action'); ?></th>
			</tr>
			</thead>
			<tbody class="table-border-bottom-0">
			<?php
			if (isset($voucher_items_data) && !empty($voucher_items_data)) {
				echo $html;
			}else { ?>
				<?php
				$data["row_number"] =  1;
				echo view('Admin/Voucher/VoucherItemRowView',$data); ?>
			<?php } ?>

			</tbody>
		</table>
	</div>
<!--/ Responsive Table -->
<script>
	var rowNumber;

	function addVoucherItem() {
		var lastIndex = ($("#voucher_item_table tbody tr:last").length >= 1) ? $("#voucher_item_table tbody tr:last").attr("data-id").split("_").pop() : 0;
		rowNumber = parseInt(lastIndex) + 1;
		$.ajax({
			type: "post",
			url: "<?= admin_url('Voucher/addVoucherItemRow'); ?>",
			dataType: "html",
			async: false,
			data: {
				row_number: rowNumber,
			},
			success: function (data) {
				if (data) {
					$('table#voucher_item_table tbody').append(data);
					addSerialNumber('voucher_item_table');
                    // amenitiesUnit();
					voucherItems();
					customToolTip();
					$(".dt-item-date").flatpickr({
						dateFormat: "d-m-Y",
					});
                    // unitPriceStore();
				}
			}
		});
	}

	var deleteId = [];
	$(document).on('click', '.dt-delete-item-row', function () {
		var trField = $(this).closest('tr');
		var id = $(this).closest('tr').find(".voucher_item_id").val();
		var amenitiesId = $("#amenities_id").val();

		if (id != '') {
				Swal.fire({
					title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_delete')); ?>",
					text: "<?= lang('CommonMessage.delete_warning'); ?>",
					icon: 'warning',
					showCancelButton: true,
					confirmButtonText: 'OK',
					customClass: {
						confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
						cancelButton: 'btn btn-label-secondary waves-effect waves-light'
					},
					buttonsStyling: false

			}).then(function (result) {
				if (result.value) {
					deleteId.push(id);
					$("#delete_voucher_item_id").val(deleteId);
                    $(trField).remove();
                    addSerialNumber('voucher_item_table');
                    if ($('#voucher_item_table tbody > tr').length == 0) {
                        addVoucherItem();
						updateUnitNames();
                        unitPriceStore();
                    }
                    unitPriceStore();
					// $.ajax({
					// 	type: "POST",
					// 	url: "<?php echo admin_url('Voucher/deleteVoucherUnitRow');?>",
					// 	dataType: "json",
					// 	async:false,
					// 	data: {
                    //         amenities_unit_id: deleteId,
                    //         amenities_id: amenitiesId
					// 	},
					// 	success: function (resObj) {
					// 		if (resObj.success) {
					// 			$(trField).remove();
					// 			addSerialNumber('voucher_item_table');
					// 			Swal.fire({
					// 				title: 'Success',
					// 				text: resObj['msg'],
					// 				icon: 'success',
					// 				customClass: {
					// 					confirmButton: 'btn btn-primary waves-effect waves-light'
					// 				},
					// 				buttonsStyling: false
					// 			}).then(function() {
					// 				if ($('#voucher_item_table tbody > tr').length == 0) {
                    //                     addVoucherItem();
					// 					updateUnitNames();
                    //                     unitPriceStore();
					// 				}
                    //                 unitPriceStore();
					// 			});

					// 		} else {
					// 			Swal.fire({
					// 				title: 'Error!',
					// 				text: resObj['msg'],
					// 				icon: 'error',
					// 				customClass: {
					// 					confirmButton: 'btn btn-primary waves-effect waves-light'
					// 				},
					// 				buttonsStyling: false
					// 			});
                    //             unitPriceStore();
					// 		}
					// 	}
					// });
				}
			});
		} else {
			$(trField).remove();
			addSerialNumber('voucher_item_table');
			if ($('#voucher_item_table tbody > tr').length == 0) {
                addVoucherItem();
				updateUnitNames();
			}
            unitPriceStore();
		}
	});
</script>